<?php

/**
 * WVC Editor Wrapper Template
 *
 * This file contains the full-screen HTML structure for the WVC editor.
 * Based on Elementor's editor-wrapper.php structure.
 *
 * @package    WVC_Theme
 * @subpackage Editor
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.0
 */

// Prevent direct access
if (!defined("ABSPATH")) {
    exit;
}

// Get page data from the editor instance
$page_data = $this->get_page_data();
$body_classes = $this->get_body_classes();

// Handle case when page_data is empty array
if (empty($page_data)) {
    $is_built_with_wvc = false;
    $page_title = '';
} else {
    $is_built_with_wvc = $page_data['wvc_editor'];
    $page_title = $page_data['title'];
}


?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php printf(esc_html__('Editing %s with 10Web AI Builder', 'wvc-theme'), esc_html($page_title)); ?></title>
    <?php wp_head(); ?>
    <script>
        var ajaxurl = '<?php echo admin_url('admin-ajax.php', 'relative'); ?>';
    </script>
    <style>
        /* Reset and clean styles for full-screen editor */
        body {
            margin: 0;
            padding: 0;
            background: #fff;
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif;
        }

        /* Hide admin bar if present */
        #wpadminbar {
            display: none !important;
        }

        /* Remove top margin when admin bar is hidden */
        html {
            margin-top: 0 !important;
        }

        /* Main editor container */
        .wvc-editor-main {
            overflow: hidden;
        }

        #wvc-editor-container {
            height: 100%;
            display: flex;
            flex-direction: column;
        }

        #wvc-editor-loading {
            text-align: center;
            padding: 40px;
            font-size: 16px;
            color: #666;
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        #wvc-editor-content {
            flex: 1;
            display: none;
            height: 100%;
        }

        #wvc-editor-root {
            width: 100%;
            height: 100%;
        }

        /* Loading animation */
        .wvc-loading-spinner {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 3px solid #f3f3f3;
            border-top: 3px solid #0073aa;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-right: 10px;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }

        /* WVC Editor specific styles */
        .wvc-editor-active {
            overflow: hidden;
        }

        .wvc-editor-active #wpcontent {
            margin-left: 0 !important;
        }

        /* Header styles for non-WVC pages */
        .wvc-editor-header {
            background: #f1f1f1;
            border-bottom: 1px solid #ddd;
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .wvc-editor-header h1 {
            margin: 0;
            font-size: 18px;
            color: #333;
        }

        .wvc-editor-status {
            font-size: 14px;
            color: #666;
            font-style: italic;
        }

        .wvc-back-button {
            background: #0073aa;
            color: white;
            border: none;
            padding: 8px 16px;
            border-radius: 4px;
            text-decoration: none;
            font-size: 14px;
            cursor: pointer;
            transition: background-color 0.2s;
        }

        .wvc-back-button:hover {
            background: #005a87;
            color: white;
            text-decoration: none;
        }

        /* Full height for WVC built pages */
        .wvc-editor-built .wvc-editor-main {
            height: 100vh;
        }

        /* Adjusted height for non-WVC pages */
        .wvc-editor-not-built .wvc-editor-main {
            height: calc(100vh - 60px);
        }
    </style>
</head>

<body class="<?php echo esc_attr(implode(' ', $body_classes)); ?>">
    <?php if (!empty($page_data) && !$is_built_with_wvc): ?>
        <!-- Header for non-WVC pages -->
        <div class="wvc-editor-header">
            <div>
                <h1><?php echo esc_html(sprintf(__('Edit Page: %s', 'wvc-theme'), $page_title)); ?></h1>
                <span class="wvc-editor-status">
                    <?php _e('Not built with WVC', 'wvc-theme'); ?>
                </span>
            </div>
            <a href="<?php echo esc_url(admin_url('edit.php?post_type=page')); ?>" class="wvc-back-button">
                <?php _e('← Back to Pages', 'wvc-theme'); ?>
            </a>
        </div>
    <?php endif; ?>

    <!-- Main editor area -->
    <div class="wvc-editor-main">
        <div id="wvc-editor-container">
            <?php if ($is_built_with_wvc): ?>
                <!-- Loading and editor root for WVC built pages -->
                <div id="wvc-editor-loading">
                    <div>
                        <div class="wvc-loading-spinner"></div>
                        <?php _e('Loading WVC Editor...', 'wvc-theme'); ?>
                    </div>
                </div>

                <div id="wvc-editor-content">
                    <!-- Editor content will be loaded here -->
                    <div id="wvc-editor-root"></div>
                </div>
            <?php else: ?>
                <!-- Content for non-WVC pages -->
                <div id="wvc-editor-loading">
                    <div>
                        <div class="wvc-loading-spinner"></div>
                        <?php _e('Loading WVC Editor...', 'wvc-theme'); ?>
                    </div>
                </div>

                <div id="wvc-editor-content">
                    <!-- Editor content will be loaded here -->
                    <div id="wvc-editor-root"></div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <?php
    wp_footer();
    /** This action is documented in wp-admin/admin-footer.php */
    do_action('admin_print_footer_scripts');
    ?>

    <script type="text/javascript">
        // Debug: Check what scripts are loaded
        console.log('Available global variables:', Object.keys(window).filter(key => key.includes('wvc')));

        // Function to initialize editor when everything is ready
        function initializeWvcEditor() {
            console.log('Initializing WVC Editor...');

            var loadingEl = document.getElementById('wvc-editor-loading');
            var contentEl = document.getElementById('wvc-editor-content');

            if (loadingEl) {
                loadingEl.style.display = 'none';
            }

            if (contentEl) {
                contentEl.style.display = 'block';
            }

            // Check if variables are available
            if (typeof WVC === 'undefined') {
                console.error('WVC is not defined');
                console.log('Available window variables:', Object.keys(window).filter(key => key.includes('wvc')));
                return false;
            }



            console.log('Variables available:', WVC);

            if (typeof window.initVibeChatWidget === 'function') {
                console.log('Initializing widget via window.initVibeChatWidget...');
                window.initVibeChatWidget('wvc-editor-root');
            } else if (typeof window.VibeChatWidget?.initVibeChatWidget === 'function') {
                console.log('Initializing widget via VibeChatWidget.initVibeChatWidget...');
                window.VibeChatWidget.initVibeChatWidget('wvc-editor-root');
            } else if (typeof window.VibeChatWidget === 'function') {
                console.log('Initializing widget via VibeChatWidget constructor...');
                window.VibeChatWidget('wvc-editor-root');
            } else {
                console.error('No widget initialization function found');
            }

            return true;
        }

        // Try to initialize immediately
        if (!initializeWvcEditor()) {
            // If not ready, wait for DOM and try again
            document.addEventListener('DOMContentLoaded', function() {
                console.log('DOM Content Loaded');

                // Try again after a short delay
                setTimeout(function() {
                    if (!initializeWvcEditor()) {
                        // If still not ready, try again after a longer delay
                        setTimeout(initializeWvcEditor, 500);
                    }
                }, 100);
            });
        }
    </script>
</body>

</html>