window["WPCache"] = new WvcUtils.WPCache();

if (window["WVCMenus"]) {
  window["WVCMenus"]["menusDetailed"].forEach((menu) => {
    window["WPCache"].set(
      `getWithNamespace_wvc/v1_menus/${menu.id}`,
      [`menus/${menu.id}`, {}, "wvc/v1"],
      { data: menu, headers: { wvc_localized: true }, status: 200 }
    );
  });
  console.log(window["WPCache"]);
}
window["WPClient"] = WvcUtils.createWordPressClient(
  window["WVC"].homeUrl,
  window["WPCache"]
);

class WvcClient {
  async getMenuItems({ menuId } = {}) {
    const menu_items_data = await window["WPClient"].get_menu_items(menuId);
    return menu_items_data?.data ?? [];
  }

  getCurrentPostID() {
    return window["WVC"].postId;
  }

    getCurrentPostType() {
        return window["WVC"].postType || 'post';
    }

    async getPosts(postParams = {}, postType = 'post') {
        const params = {
            per_page: postParams?.wp_query?.per_page,
            order: postParams?.wp_query?.order,
            orderby: postParams?.wp_query?.orderby,
            _fields: postParams?.fields,
            _embed: postParams?.embeds ?? []
        }

        // Use get_items for custom post types, get_posts for regular posts
        const post_data = postType === 'post'
            ? await window["WPClient"].get_posts(params)
            : await window["WPClient"].get_items(postType, params);

        return {
            "posts": post_data?.data,
            "total": post_data?.headers["x-wp-total"],
            "total_pages": post_data?.headers["x-wp-totalpages"]
        }
    }

    async formSubmission({
                             // Required fields
                             sectionName,
                             formId,
                             formData,

                             // Optional metadata
                             validationErrors = null,
                             submissionAttempt = 1,
                             formVersion = "1.0.0",
                             ...rest
                         } = {}) {
        if (!sectionName || !formId || !formData) {
            throw new Error(
                "Required fields missing: sectionName, formId, and formData are required"
            );
        }

    // console.log("Submitting form:", {
    //   sectionName,
    //   formId,
    //   formData,
    //   validationErrors,
    //   submissionAttempt,
    //   formVersion,
    //   ...rest,
    // });

    // Auto-generated fields
    const timestamp = Date.now();
    const sessionId = this.generateSessionId();
    const pageUrl = window.location.href;
    const userAgent = navigator.userAgent;

    // Prepare the submission data
    const submissionData = new FormData();

    // Add all form field values
    if (formData instanceof FormData) {
      for (const [key, value] of formData.entries()) {
        submissionData.append(`formData[${key}]`, value);
      }
    } else {
      // Handle object format
      for (const [key, value] of Object.entries(formData)) {
        // console.log("Appending form field:", key, value);

        submissionData.append(`formData[${key}]`, value);
      }
    }

    // Add metadata
    submissionData.append("sectionName", sectionName);
    submissionData.append("formId", formId);
    submissionData.append("timestamp", timestamp.toString());
    submissionData.append("sessionId", sessionId);
    submissionData.append("pageUrl", pageUrl);
    submissionData.append("userAgent", userAgent);
    submissionData.append("submissionAttempt", submissionAttempt.toString());
    submissionData.append("formVersion", formVersion);

    if (validationErrors) {
      submissionData.append(
        "validationErrors",
        JSON.stringify(validationErrors)
      );
    }

    // Add AJAX action and nonce for security
    if (window.wvcHandlerData && window.wvcHandlerData.nonce) {
      console.log("wvcHandlerData:", window.wvcHandlerData);

      submissionData.append("action", window.wvcHandlerData.action); // AJAX action
      submissionData.append("nonce", window.wvcHandlerData.nonce);
    } else {
      console.error("wvcHandlerData or nonce not found");
    }

    // console.log("Submission data prepared:", submissionData, formData);
    // alert("Handling form submission is working well so far!");

    try {
      const response = await fetch(window.wvcHandlerData.ajaxUrl, {
        method: "POST",
        body: submissionData,
      });

      if (!response.ok) {
        throw new Error(`HTTP error! status: ${response.status}`);
      }

      const result = await response.json();

      // Handle WordPress AJAX response format
      if (result.success) {
        return result.data; // Return the actual data
      } else {
        throw new Error(result.data.message || "Form submission failed");
      }
    } catch (error) {
      console.error("Form submission error:", error);
      throw error;
    }
  }

  generateSessionId() {
    // Check if session ID already exists
    let sessionId = sessionStorage.getItem("wvc_session_id");

    if (!sessionId) {
      // Generate a new session ID
      sessionId =
        "wvc_" + Date.now() + "_" + Math.random().toString(36).substr(2, 9);
      sessionStorage.setItem("wvc_session_id", sessionId);
    }

    // console.log("Generated/Retrieved session ID:", sessionId);
    return sessionId;
  }
}

window.wvcClient = new WvcClient();

// WordPress Admin Bar positioning handler
(function () {
  let processedElements = new WeakSet();

  function handleAdminBarPositioning() {
    const adminBar = document.getElementById("wpadminbar");

    if (!adminBar) {
      return;
    }

    // Check if admin bar is visible (not display: none)
    const computedStyle = window.getComputedStyle(adminBar);
    const isVisible =
      computedStyle.display !== "none" && computedStyle.visibility !== "hidden";

    if (!isVisible || !adminBar.offsetHeight) {
      return;
    }

    const adminBarHeight = adminBar.offsetHeight;

    // Find all elements with fixed/sticky positioning and top < admin bar height
    const fixedElements = document.querySelectorAll("*");
    const elementsToAdjust = [];

    fixedElements.forEach((element) => {
      // Skip the admin bar itself and already processed elements
      if (element.id === "wpadminbar" || processedElements.has(element)) {
        return;
      }

      const computedStyle = window.getComputedStyle(element);
      const position = computedStyle.position;
      const top = computedStyle.top;

      if ((position === "fixed" || position === "sticky") && top !== "auto") {
        const topValue = parseFloat(top);
        if (!isNaN(topValue) && topValue < adminBarHeight) {
          elementsToAdjust.push({
            element: element,
            originalTop: topValue,
          });
        }
      }
    });

    // Adjust elements
    elementsToAdjust.forEach((item) => {
      const newTop = item.originalTop + adminBarHeight;
      item.element.style.top = newTop + "px";
      processedElements.add(item.element);
    });
  }

  // Function to continuously monitor for new elements
  function startMonitoring() {
    // Run immediately
    handleAdminBarPositioning();

    // Start observing after 1 second to ensure initial DOM is rendered
    setTimeout(() => {
      // Use MutationObserver to watch for new elements being added
      const observer = new MutationObserver(function (mutations) {
        let shouldCheck = false;
        mutations.forEach(function (mutation) {
          if (mutation.type === "childList" && mutation.addedNodes.length > 0) {
            shouldCheck = true;
          }
        });

        if (shouldCheck) {
          // Use requestAnimationFrame to ensure DOM is fully rendered
          requestAnimationFrame(handleAdminBarPositioning);
        }
      });

      observer.observe(document.body, {
        childList: true,
        subtree: true,
      });
    }, 1000);

    // Also run periodically to catch any missed elements
    setInterval(handleAdminBarPositioning, 1000);
  }

  // Start monitoring when DOM is ready
  if (document.readyState === "loading") {
    document.addEventListener("DOMContentLoaded", startMonitoring);
  } else {
    startMonitoring();
  }

  // Also run on window resize in case admin bar height changes
  window.addEventListener("resize", handleAdminBarPositioning);
})();
