<?php
/**
 * Generated stub declarations for WordPress.
 * @see https://wordpress.org
 * @see https://github.com/php-stubs/wordpress-stubs
 */

namespace {
    /**
     * Generic Skin for the WordPress Upgrader classes. This skin is designed to be extended for specific purposes.
     *
     * @since 2.8.0
     * @since 4.6.0 Moved to its own file from wp-admin/includes/class-wp-upgrader-skins.php.
     */
    #[\AllowDynamicProperties]
    class WP_Upgrader_Skin
    {
        /**
         * Holds the upgrader data.
         *
         * @since 2.8.0
         * @var WP_Upgrader
         */
        public $upgrader;
        /**
         * Whether header is done.
         *
         * @since 2.8.0
         * @var bool
         */
        public $done_header = \false;
        /**
         * Whether footer is done.
         *
         * @since 2.8.0
         * @var bool
         */
        public $done_footer = \false;
        /**
         * Holds the result of an upgrade.
         *
         * @since 2.8.0
         * @var string|bool|WP_Error
         */
        public $result = \false;
        /**
         * Holds the options of an upgrade.
         *
         * @since 2.8.0
         * @var array
         */
        public $options = array();
        /**
         * Constructor.
         *
         * Sets up the generic skin for the WordPress Upgrader classes.
         *
         * @since 2.8.0
         *
         * @param array $args Optional. The WordPress upgrader skin arguments to
         *                    override default options. Default empty array.
         */
        public function __construct($args = array())
        {
        }
        /**
         * Sets the relationship between the skin being used and the upgrader.
         *
         * @since 2.8.0
         *
         * @param WP_Upgrader $upgrader
         */
        public function set_upgrader(&$upgrader)
        {
        }
        /**
         * Sets up the strings used in the update process.
         *
         * @since 3.0.0
         */
        public function add_strings()
        {
        }
        /**
         * Sets the result of an upgrade.
         *
         * @since 2.8.0
         *
         * @param string|bool|WP_Error $result The result of an upgrade.
         */
        public function set_result($result)
        {
        }
        /**
         * Displays a form to the user to request for their FTP/SSH details in order
         * to connect to the filesystem.
         *
         * @since 2.8.0
         * @since 4.6.0 The `$context` parameter default changed from `false` to an empty string.
         *
         * @see request_filesystem_credentials()
         *
         * @param bool|WP_Error $error                        Optional. Whether the current request has failed to connect,
         *                                                    or an error object. Default false.
         * @param string        $context                      Optional. Full path to the directory that is tested
         *                                                    for being writable. Default empty.
         * @param bool          $allow_relaxed_file_ownership Optional. Whether to allow Group/World writable. Default false.
         * @return bool True on success, false on failure.
         */
        public function request_filesystem_credentials($error = \false, $context = '', $allow_relaxed_file_ownership = \false)
        {
        }
        /**
         * Displays the header before the update process.
         *
         * @since 2.8.0
         * @phpstan-return void
         */
        public function header()
        {
        }
        /**
         * Displays the footer following the update process.
         *
         * @since 2.8.0
         * @phpstan-return void
         */
        public function footer()
        {
        }
        /**
         * Displays an error message about the update.
         *
         * @since 2.8.0
         *
         * @param string|WP_Error $errors Errors.
         */
        public function error($errors)
        {
        }
        /**
         * Displays a message about the update.
         *
         * @since 2.8.0
         * @since 5.9.0 Renamed `$string` (a PHP reserved keyword) to `$feedback` for PHP 8 named parameter support.
         *
         * @param string $feedback Message data.
         * @param mixed  ...$args  Optional text replacements.
         * @phpstan-return void
         */
        public function feedback($feedback, ...$args)
        {
        }
        /**
         * Performs an action before an update.
         *
         * @since 2.8.0
         */
        public function before()
        {
        }
        /**
         * Performs an action following an update.
         *
         * @since 2.8.0
         */
        public function after()
        {
        }
        /**
         * Outputs JavaScript that calls function to decrement the update counts.
         *
         * @since 3.9.0
         *
         * @param string $type Type of update count to decrement. Likely values include 'plugin',
         *                     'theme', 'translation', etc.
         * @phpstan-return void
         */
        protected function decrement_update_count($type)
        {
        }
        /**
         * Displays the header before the bulk update process.
         *
         * @since 3.0.0
         */
        public function bulk_header()
        {
        }
        /**
         * Displays the footer following the bulk update process.
         *
         * @since 3.0.0
         */
        public function bulk_footer()
        {
        }
        /**
         * Hides the `process_failed` error message when updating by uploading a zip file.
         *
         * @since 5.5.0
         *
         * @param WP_Error $wp_error WP_Error object.
         * @return bool True if the error should be hidden, false otherwise.
         */
        public function hide_process_failed($wp_error)
        {
        }
    }
    /**
     * Upgrader Skin for Automatic WordPress Upgrades.
     *
     * This skin is designed to be used when no output is intended, all output
     * is captured and stored for the caller to process and log/email/discard.
     *
     * @since 3.7.0
     * @since 4.6.0 Moved to its own file from wp-admin/includes/class-wp-upgrader-skins.php.
     *
     * @see Bulk_Upgrader_Skin
     */
    class Automatic_Upgrader_Skin extends \WP_Upgrader_Skin
    {
        protected $messages = array();
        /**
         * Determines whether the upgrader needs FTP/SSH details in order to connect
         * to the filesystem.
         *
         * @since 3.7.0
         * @since 4.6.0 The `$context` parameter default changed from `false` to an empty string.
         *
         * @see request_filesystem_credentials()
         *
         * @param bool|WP_Error $error                        Optional. Whether the current request has failed to connect,
         *                                                    or an error object. Default false.
         * @param string        $context                      Optional. Full path to the directory that is tested
         *                                                    for being writable. Default empty.
         * @param bool          $allow_relaxed_file_ownership Optional. Whether to allow Group/World writable. Default false.
         * @return bool True on success, false on failure.
         */
        public function request_filesystem_credentials($error = \false, $context = '', $allow_relaxed_file_ownership = \false)
        {
        }
        /**
         * Retrieves the upgrade messages.
         *
         * @since 3.7.0
         *
         * @return string[] Messages during an upgrade.
         */
        public function get_upgrade_messages()
        {
        }
        /**
         * Stores a message about the upgrade.
         *
         * @since 3.7.0
         * @since 5.9.0 Renamed `$data` to `$feedback` for PHP 8 named parameter support.
         *
         * @param string|array|WP_Error $feedback Message data.
         * @param mixed                 ...$args  Optional text replacements.
         * @phpstan-return void
         */
        public function feedback($feedback, ...$args)
        {
        }
        /**
         * Creates a new output buffer.
         *
         * @since 3.7.0
         */
        public function header()
        {
        }
        /**
         * Retrieves the buffered content, deletes the buffer, and processes the output.
         *
         * @since 3.7.0
         */
        public function footer()
        {
        }
    }
    /**
     * Generic Bulk Upgrader Skin for WordPress Upgrades.
     *
     * @since 3.0.0
     * @since 4.6.0 Moved to its own file from wp-admin/includes/class-wp-upgrader-skins.php.
     *
     * @see WP_Upgrader_Skin
     */
    class Bulk_Upgrader_Skin extends \WP_Upgrader_Skin
    {
        /**
         * Whether the bulk update process has started.
         *
         * @since 3.0.0
         * @var bool
         */
        public $in_loop = \false;
        /**
         * Stores an error message about the update.
         *
         * @since 3.0.0
         * @var string|false
         */
        public $error = \false;
        /**
         * Constructor.
         *
         * Sets up the generic skin for the Bulk Upgrader classes.
         *
         * @since 3.0.0
         *
         * @param array $args
         */
        public function __construct($args = array())
        {
        }
        /**
         * Sets up the strings used in the update process.
         *
         * @since 3.0.0
         */
        public function add_strings()
        {
        }
        /**
         * Displays a message about the update.
         *
         * @since 3.0.0
         * @since 5.9.0 Renamed `$string` (a PHP reserved keyword) to `$feedback` for PHP 8 named parameter support.
         *
         * @param string $feedback Message data.
         * @param mixed  ...$args  Optional text replacements.
         * @phpstan-return void
         */
        public function feedback($feedback, ...$args)
        {
        }
        /**
         * Displays the header before the update process.
         *
         * @since 3.0.0
         */
        public function header()
        {
        }
        /**
         * Displays the footer following the update process.
         *
         * @since 3.0.0
         */
        public function footer()
        {
        }
        /**
         * Displays an error message about the update.
         *
         * @since 3.0.0
         * @since 5.9.0 Renamed `$error` to `$errors` for PHP 8 named parameter support.
         *
         * @param string|WP_Error $errors Errors.
         */
        public function error($errors)
        {
        }
        /**
         * Displays the header before the bulk update process.
         *
         * @since 3.0.0
         */
        public function bulk_header()
        {
        }
        /**
         * Displays the footer following the bulk update process.
         *
         * @since 3.0.0
         */
        public function bulk_footer()
        {
        }
        /**
         * Performs an action before a bulk update.
         *
         * @since 3.0.0
         *
         * @param string $title
         */
        public function before($title = '')
        {
        }
        /**
         * Performs an action following a bulk update.
         *
         * @since 3.0.0
         *
         * @param string $title
         */
        public function after($title = '')
        {
        }
        /**
         * Resets the properties used in the update process.
         *
         * @since 3.0.0
         */
        public function reset()
        {
        }
        /**
         * Flushes all output buffers.
         *
         * @since 3.0.0
         */
        public function flush_output()
        {
        }
    }
    /**
     * Bulk Plugin Upgrader Skin for WordPress Plugin Upgrades.
     *
     * @since 3.0.0
     * @since 4.6.0 Moved to its own file from wp-admin/includes/class-wp-upgrader-skins.php.
     *
     * @see Bulk_Upgrader_Skin
     */
    class Bulk_Plugin_Upgrader_Skin extends \Bulk_Upgrader_Skin
    {
        /**
         * Plugin info.
         *
         * The Plugin_Upgrader::bulk_upgrade() method will fill this in
         * with info retrieved from the get_plugin_data() function.
         *
         * @since 3.0.0
         * @var array Plugin data. Values will be empty if not supplied by the plugin.
         */
        public $plugin_info = array();
        /**
         * Sets up the strings used in the update process.
         *
         * @since 3.0.0
         */
        public function add_strings()
        {
        }
        /**
         * Performs an action before a bulk plugin update.
         *
         * @since 3.0.0
         *
         * @param string $title
         */
        public function before($title = '')
        {
        }
        /**
         * Performs an action following a bulk plugin update.
         *
         * @since 3.0.0
         *
         * @param string $title
         */
        public function after($title = '')
        {
        }
        /**
         * Displays the footer following the bulk update process.
         *
         * @since 3.0.0
         */
        public function bulk_footer()
        {
        }
    }
    /**
     * Bulk Theme Upgrader Skin for WordPress Theme Upgrades.
     *
     * @since 3.0.0
     * @since 4.6.0 Moved to its own file from wp-admin/includes/class-wp-upgrader-skins.php.
     *
     * @see Bulk_Upgrader_Skin
     */
    class Bulk_Theme_Upgrader_Skin extends \Bulk_Upgrader_Skin
    {
        /**
         * Theme info.
         *
         * The Theme_Upgrader::bulk_upgrade() method will fill this in
         * with info retrieved from the Theme_Upgrader::theme_info() method,
         * which in turn calls the wp_get_theme() function.
         *
         * @since 3.0.0
         * @var WP_Theme|false The theme's info object, or false.
         */
        public $theme_info = \false;
        /**
         * Sets up the strings used in the update process.
         *
         * @since 3.0.0
         */
        public function add_strings()
        {
        }
        /**
         * Performs an action before a bulk theme update.
         *
         * @since 3.0.0
         *
         * @param string $title
         */
        public function before($title = '')
        {
        }
        /**
         * Performs an action following a bulk theme update.
         *
         * @since 3.0.0
         *
         * @param string $title
         */
        public function after($title = '')
        {
        }
        /**
         * Displays the footer following the bulk update process.
         *
         * @since 3.0.0
         */
        public function bulk_footer()
        {
        }
    }
    /**
     * Core class used for upgrading/installing a local set of files via
     * the Filesystem Abstraction classes from a Zip file.
     *
     * @since 2.8.0
     */
    #[\AllowDynamicProperties]
    class WP_Upgrader
    {
        /**
         * The error/notification strings used to update the user on the progress.
         *
         * @since 2.8.0
         * @var array $strings
         */
        public $strings = array();
        /**
         * The upgrader skin being used.
         *
         * @since 2.8.0
         * @var Automatic_Upgrader_Skin|WP_Upgrader_Skin $skin
         */
        public $skin = \null;
        /**
         * The result of the installation.
         *
         * This is set by WP_Upgrader::install_package(), only when the package is installed
         * successfully. It will then be an array, unless a WP_Error is returned by the
         * {@see 'upgrader_post_install'} filter. In that case, the WP_Error will be assigned to
         * it.
         *
         * @since 2.8.0
         *
         * @var array|WP_Error $result {
         *     @type string $source             The full path to the source the files were installed from.
         *     @type string $source_files       List of all the files in the source directory.
         *     @type string $destination        The full path to the installation destination folder.
         *     @type string $destination_name   The name of the destination folder, or empty if `$destination`
         *                                      and `$local_destination` are the same.
         *     @type string $local_destination  The full local path to the destination folder. This is usually
         *                                      the same as `$destination`.
         *     @type string $remote_destination The full remote path to the destination folder
         *                                      (i.e., from `$wp_filesystem`).
         *     @type bool   $clear_destination  Whether the destination folder was cleared.
         * }
         * @phpstan-var \WP_Error|array{
         *   source: string,
         *   source_files: string,
         *   destination: string,
         *   destination_name: string,
         *   local_destination: string,
         *   remote_destination: string,
         *   clear_destination: bool,
         * }
         */
        public $result = array();
        /**
         * The total number of updates being performed.
         *
         * Set by the bulk update methods.
         *
         * @since 3.0.0
         * @var int $update_count
         */
        public $update_count = 0;
        /**
         * The current update if multiple updates are being performed.
         *
         * Used by the bulk update methods, and incremented for each update.
         *
         * @since 3.0.0
         * @var int
         */
        public $update_current = 0;
        /**
         * Construct the upgrader with a skin.
         *
         * @since 2.8.0
         *
         * @param WP_Upgrader_Skin $skin The upgrader skin to use. Default is a WP_Upgrader_Skin
         *                               instance.
         */
        public function __construct($skin = \null)
        {
        }
        /**
         * Initializes the upgrader.
         *
         * This will set the relationship between the skin being used and this upgrader,
         * and also add the generic strings to `WP_Upgrader::$strings`.
         *
         * Additionally, it will schedule a weekly task to clean up the temporary backup directory.
         *
         * @since 2.8.0
         * @since 6.3.0 Added the `schedule_temp_backup_cleanup()` task.
         */
        public function init()
        {
        }
        /**
         * Schedules the cleanup of the temporary backup directory.
         *
         * @since 6.3.0
         */
        protected function schedule_temp_backup_cleanup()
        {
        }
        /**
         * Adds the generic strings to WP_Upgrader::$strings.
         *
         * @since 2.8.0
         */
        public function generic_strings()
        {
        }
        /**
         * Connects to the filesystem.
         *
         * @since 2.8.0
         *
         * @global WP_Filesystem_Base $wp_filesystem WordPress filesystem subclass.
         *
         * @param string[] $directories                  Optional. Array of directories. If any of these do
         *                                               not exist, a WP_Error object will be returned.
         *                                               Default empty array.
         * @param bool     $allow_relaxed_file_ownership Whether to allow relaxed file ownership.
         *                                               Default false.
         * @return bool|WP_Error True if able to connect, false or a WP_Error otherwise.
         */
        public function fs_connect($directories = array(), $allow_relaxed_file_ownership = \false)
        {
        }
        /**
         * Downloads a package.
         *
         * @since 2.8.0
         * @since 5.2.0 Added the `$check_signatures` parameter.
         * @since 5.5.0 Added the `$hook_extra` parameter.
         *
         * @param string $package          The URI of the package. If this is the full path to an
         *                                 existing local file, it will be returned untouched.
         * @param bool   $check_signatures Whether to validate file signatures. Default false.
         * @param array  $hook_extra       Extra arguments to pass to the filter hooks. Default empty array.
         * @return string|WP_Error The full path to the downloaded package file, or a WP_Error object.
         */
        public function download_package($package, $check_signatures = \false, $hook_extra = array())
        {
        }
        /**
         * Unpacks a compressed package file.
         *
         * @since 2.8.0
         *
         * @global WP_Filesystem_Base $wp_filesystem WordPress filesystem subclass.
         *
         * @param string $package        Full path to the package file.
         * @param bool   $delete_package Optional. Whether to delete the package file after attempting
         *                               to unpack it. Default true.
         * @return string|WP_Error The path to the unpacked contents, or a WP_Error on failure.
         */
        public function unpack_package($package, $delete_package = \true)
        {
        }
        /**
         * Flattens the results of WP_Filesystem_Base::dirlist() for iterating over.
         *
         * @since 4.9.0
         * @access protected
         *
         * @param array  $nested_files Array of files as returned by WP_Filesystem_Base::dirlist().
         * @param string $path         Relative path to prepend to child nodes. Optional.
         * @return array A flattened array of the $nested_files specified.
         */
        protected function flatten_dirlist($nested_files, $path = '')
        {
        }
        /**
         * Clears the directory where this item is going to be installed into.
         *
         * @since 4.3.0
         *
         * @global WP_Filesystem_Base $wp_filesystem WordPress filesystem subclass.
         *
         * @param string $remote_destination The location on the remote filesystem to be cleared.
         * @return true|WP_Error True upon success, WP_Error on failure.
         */
        public function clear_destination($remote_destination)
        {
        }
        /**
         * Install a package.
         *
         * Copies the contents of a package from a source directory, and installs them in
         * a destination directory. Optionally removes the source. It can also optionally
         * clear out the destination folder if it already exists.
         *
         * @since 2.8.0
         * @since 6.2.0 Use move_dir() instead of copy_dir() when possible.
         *
         * @global WP_Filesystem_Base $wp_filesystem        WordPress filesystem subclass.
         * @global string[]           $wp_theme_directories
         *
         * @param array|string $args {
         *     Optional. Array or string of arguments for installing a package. Default empty array.
         *
         *     @type string $source                      Required path to the package source. Default empty.
         *     @type string $destination                 Required path to a folder to install the package in.
         *                                               Default empty.
         *     @type bool   $clear_destination           Whether to delete any files already in the destination
         *                                               folder. Default false.
         *     @type bool   $clear_working               Whether to delete the files from the working directory
         *                                               after copying them to the destination. Default false.
         *     @type bool   $abort_if_destination_exists Whether to abort the installation if
         *                                               the destination folder already exists. Default true.
         *     @type array  $hook_extra                  Extra arguments to pass to the filter hooks called by
         *                                               WP_Upgrader::install_package(). Default empty array.
         * }
         *
         * @return array|WP_Error The result (also stored in `WP_Upgrader::$result`), or a WP_Error on failure.
         * @phpstan-param array{
         *   source?: string,
         *   destination?: string,
         *   clear_destination?: bool,
         *   clear_working?: bool,
         *   abort_if_destination_exists?: bool,
         *   hook_extra?: array,
         * } $args
         */
        public function install_package($args = array())
        {
        }
        /**
         * Runs an upgrade/installation.
         *
         * Attempts to download the package (if it is not a local file), unpack it, and
         * install it in the destination folder.
         *
         * @since 2.8.0
         *
         * @param array $options {
         *     Array or string of arguments for upgrading/installing a package.
         *
         *     @type string $package                     The full path or URI of the package to install.
         *                                               Default empty.
         *     @type string $destination                 The full path to the destination folder.
         *                                               Default empty.
         *     @type bool   $clear_destination           Whether to delete any files already in the
         *                                               destination folder. Default false.
         *     @type bool   $clear_working               Whether to delete the files from the working
         *                                               directory after copying them to the destination.
         *                                               Default true.
         *     @type bool   $abort_if_destination_exists Whether to abort the installation if the destination
         *                                               folder already exists. When true, `$clear_destination`
         *                                               should be false. Default true.
         *     @type bool   $is_multi                    Whether this run is one of multiple upgrade/installation
         *                                               actions being performed in bulk. When true, the skin
         *                                               WP_Upgrader::header() and WP_Upgrader::footer()
         *                                               aren't called. Default false.
         *     @type array  $hook_extra                  Extra arguments to pass to the filter hooks called by
         *                                               WP_Upgrader::run().
         * }
         * @return array|false|WP_Error The result from self::install_package() on success, otherwise a WP_Error,
         *                              or false if unable to connect to the filesystem.
         * @phpstan-param array{
         *   package?: string,
         *   destination?: string,
         *   clear_destination?: bool,
         *   clear_working?: bool,
         *   abort_if_destination_exists?: bool,
         *   is_multi?: bool,
         *   hook_extra?: array,
         * } $options
         */
        public function run($options)
        {
        }
        /**
         * Toggles maintenance mode for the site.
         *
         * Creates/deletes the maintenance file to enable/disable maintenance mode.
         *
         * @since 2.8.0
         *
         * @global WP_Filesystem_Base $wp_filesystem WordPress filesystem subclass.
         *
         * @param bool $enable True to enable maintenance mode, false to disable.
         * @phpstan-return void
         */
        public function maintenance_mode($enable = \false)
        {
        }
        /**
         * Creates a lock using WordPress options.
         *
         * @since 4.5.0
         *
         * @global wpdb $wpdb The WordPress database abstraction object.
         *
         * @param string $lock_name       The name of this unique lock.
         * @param int    $release_timeout Optional. The duration in seconds to respect an existing lock.
         *                                Default: 1 hour.
         * @return bool False if a lock couldn't be created or if the lock is still valid. True otherwise.
         */
        public static function create_lock($lock_name, $release_timeout = \null)
        {
        }
        /**
         * Releases an upgrader lock.
         *
         * @since 4.5.0
         *
         * @see WP_Upgrader::create_lock()
         *
         * @param string $lock_name The name of this unique lock.
         * @return bool True if the lock was successfully released. False on failure.
         */
        public static function release_lock($lock_name)
        {
        }
        /**
         * Moves the plugin or theme being updated into a temporary backup directory.
         *
         * @since 6.3.0
         *
         * @global WP_Filesystem_Base $wp_filesystem WordPress filesystem subclass.
         *
         * @param string[] $args {
         *     Array of data for the temporary backup.
         *
         *     @type string $slug Plugin or theme slug.
         *     @type string $src  Path to the root directory for plugins or themes.
         *     @type string $dir  Destination subdirectory name. Accepts 'plugins' or 'themes'.
         * }
         *
         * @return bool|WP_Error True on success, false on early exit, otherwise WP_Error.
         * @phpstan-param array{
         *   slug?: string,
         *   src?: string,
         *   dir?: string,
         * } $args
         */
        public function move_to_temp_backup_dir($args)
        {
        }
        /**
         * Restores the plugin or theme from temporary backup.
         *
         * @since 6.3.0
         * @since 6.6.0 Added the `$temp_backups` parameter.
         *
         * @global WP_Filesystem_Base $wp_filesystem WordPress filesystem subclass.
         *
         * @param array[] $temp_backups {
         *     Optional. An array of temporary backups.
         *
         *     @type array ...$0 {
         *         Information about the backup.
         *
         *         @type string $dir  The temporary backup location in the upgrade-temp-backup directory.
         *         @type string $slug The item's slug.
         *         @type string $src  The directory where the original is stored. For example, `WP_PLUGIN_DIR`.
         *     }
         * }
         * @return bool|WP_Error True on success, false on early exit, otherwise WP_Error.
         * @phpstan-param array<int|string, array{
         *   dir: string,
         *   slug: string,
         *   src: string,
         * }> $temp_backups
         */
        public function restore_temp_backup(array $temp_backups = array())
        {
        }
        /**
         * Deletes a temporary backup.
         *
         * @since 6.3.0
         * @since 6.6.0 Added the `$temp_backups` parameter.
         *
         * @global WP_Filesystem_Base $wp_filesystem WordPress filesystem subclass.
         *
         * @param array[] $temp_backups {
         *     Optional. An array of temporary backups.
         *
         *     @type array ...$0 {
         *         Information about the backup.
         *
         *         @type string $dir  The temporary backup location in the upgrade-temp-backup directory.
         *         @type string $slug The item's slug.
         *         @type string $src  The directory where the original is stored. For example, `WP_PLUGIN_DIR`.
         *     }
         * }
         * @return bool|WP_Error True on success, false on early exit, otherwise WP_Error.
         * @phpstan-param array<int|string, array{
         *   dir: string,
         *   slug: string,
         *   src: string,
         * }> $temp_backups
         */
        public function delete_temp_backup(array $temp_backups = array())
        {
        }
    }
    /**
     * Core class used for updating core.
     *
     * It allows for WordPress to upgrade itself in combination with
     * the wp-admin/includes/update-core.php file.
     *
     * Note: Newly introduced functions and methods cannot be used here.
     * All functions must be present in the previous version being upgraded from
     * as this file is used there too.
     *
     * @since 2.8.0
     * @since 4.6.0 Moved to its own file from wp-admin/includes/class-wp-upgrader.php.
     *
     * @see WP_Upgrader
     */
    class Core_Upgrader extends \WP_Upgrader
    {
        /**
         * Initializes the upgrade strings.
         *
         * @since 2.8.0
         */
        public function upgrade_strings()
        {
        }
        /**
         * Upgrades WordPress core.
         *
         * @since 2.8.0
         *
         * @global WP_Filesystem_Base $wp_filesystem                WordPress filesystem subclass.
         * @global callable           $_wp_filesystem_direct_method
         *
         * @param object $current Response object for whether WordPress is current.
         * @param array  $args {
         *     Optional. Arguments for upgrading WordPress core. Default empty array.
         *
         *     @type bool $pre_check_md5    Whether to check the file checksums before
         *                                  attempting the upgrade. Default true.
         *     @type bool $attempt_rollback Whether to attempt to rollback the chances if
         *                                  there is a problem. Default false.
         *     @type bool $do_rollback      Whether to perform this "upgrade" as a rollback.
         *                                  Default false.
         * }
         * @return string|false|WP_Error New WordPress version on success, false or WP_Error on failure.
         * @phpstan-param array{
         *   pre_check_md5?: bool,
         *   attempt_rollback?: bool,
         *   do_rollback?: bool,
         * } $args
         */
        public function upgrade($current, $args = array())
        {
        }
        /**
         * Determines if this WordPress Core version should update to an offered version or not.
         *
         * @since 3.7.0
         *
         * @param string $offered_ver The offered version, of the format x.y.z.
         * @return bool True if we should update to the offered version, otherwise false.
         */
        public static function should_update_to_version($offered_ver)
        {
        }
        /**
         * Compares the disk file checksums against the expected checksums.
         *
         * @since 3.7.0
         *
         * @global string $wp_version       The WordPress version string.
         * @global string $wp_local_package Locale code of the package.
         *
         * @return bool True if the checksums match, otherwise false.
         */
        public function check_files()
        {
        }
    }
    /**
     * The custom background class.
     *
     * @since 3.0.0
     */
    #[\AllowDynamicProperties]
    class Custom_Background
    {
        /**
         * Callback for administration header.
         *
         * @since 3.0.0
         * @var callable
         */
        public $admin_header_callback;
        /**
         * Callback for header div.
         *
         * @since 3.0.0
         * @var callable
         */
        public $admin_image_div_callback;
        /**
         * Constructor - Registers administration header callback.
         *
         * @since 3.0.0
         *
         * @param callable $admin_header_callback    Optional. Administration header callback.
         *                                           Default empty string.
         * @param callable $admin_image_div_callback Optional. Custom image div output callback.
         *                                           Default empty string.
         */
        public function __construct($admin_header_callback = '', $admin_image_div_callback = '')
        {
        }
        /**
         * Sets up the hooks for the Custom Background admin page.
         *
         * @since 3.0.0
         * @phpstan-return void
         */
        public function init()
        {
        }
        /**
         * Sets up the enqueue for the CSS & JavaScript files.
         *
         * @since 3.0.0
         */
        public function admin_load()
        {
        }
        /**
         * Executes custom background modification.
         *
         * @since 3.0.0
         * @phpstan-return void
         */
        public function take_action()
        {
        }
        /**
         * Displays the custom background page.
         *
         * @since 3.0.0
         */
        public function admin_page()
        {
        }
        /**
         * Handles an Image upload for the background image.
         *
         * @since 3.0.0
         * @phpstan-return void
         */
        public function handle_upload()
        {
        }
        /**
         * Handles Ajax request for adding custom background context to an attachment.
         *
         * Triggers when the user adds a new background image from the
         * Media Manager.
         *
         * @since 4.1.0
         * @phpstan-return never
         */
        public function ajax_background_add()
        {
        }
        /**
         * @since 3.4.0
         * @deprecated 3.5.0
         *
         * @param array $form_fields
         * @return array $form_fields
         */
        public function attachment_fields_to_edit($form_fields)
        {
        }
        /**
         * @since 3.4.0
         * @deprecated 3.5.0
         *
         * @param array $tabs
         * @return array $tabs
         */
        public function filter_upload_tabs($tabs)
        {
        }
        /**
         * @since 3.4.0
         * @deprecated 3.5.0
         * @phpstan-return never
         */
        public function wp_set_background_image()
        {
        }
    }
    /**
     * The custom header image class.
     *
     * @since 2.1.0
     */
    #[\AllowDynamicProperties]
    class Custom_Image_Header
    {
        /**
         * Callback for administration header.
         *
         * @since 2.1.0
         * @var callable
         */
        public $admin_header_callback;
        /**
         * Callback for header div.
         *
         * @since 3.0.0
         * @var callable
         */
        public $admin_image_div_callback;
        /**
         * Holds default headers.
         *
         * @since 3.0.0
         * @var array
         */
        public $default_headers = array();
        /**
         * Constructor - Registers administration header callback.
         *
         * @since 2.1.0
         *
         * @param callable $admin_header_callback    Administration header callback.
         * @param callable $admin_image_div_callback Optional. Custom image div output callback.
         *                                           Default empty string.
         */
        public function __construct($admin_header_callback, $admin_image_div_callback = '')
        {
        }
        /**
         * Sets up the hooks for the Custom Header admin page.
         *
         * @since 2.1.0
         * @phpstan-return void
         */
        public function init()
        {
        }
        /**
         * Adds contextual help.
         *
         * @since 3.0.0
         */
        public function help()
        {
        }
        /**
         * Gets the current step.
         *
         * @since 2.6.0
         *
         * @return int Current step.
         */
        public function step()
        {
        }
        /**
         * Sets up the enqueue for the JavaScript files.
         *
         * @since 2.1.0
         */
        public function js_includes()
        {
        }
        /**
         * Sets up the enqueue for the CSS files.
         *
         * @since 2.7.0
         */
        public function css_includes()
        {
        }
        /**
         * Executes custom header modification.
         *
         * @since 2.6.0
         * @phpstan-return void
         */
        public function take_action()
        {
        }
        /**
         * Processes the default headers.
         *
         * @since 3.0.0
         *
         * @global array $_wp_default_headers
         * @phpstan-return void
         */
        public function process_default_headers()
        {
        }
        /**
         * Displays UI for selecting one of several default headers.
         *
         * Shows the random image option if this theme has multiple header images.
         * Random image option is on by default if no header has been set.
         *
         * @since 3.0.0
         *
         * @param string $type The header type. One of 'default' (for the Uploaded Images control)
         *                     or 'uploaded' (for the Uploaded Images control).
         * @phpstan-param 'default'|'uploaded' $type
         */
        public function show_header_selector($type = 'default')
        {
        }
        /**
         * Executes JavaScript depending on step.
         *
         * @since 2.1.0
         */
        public function js()
        {
        }
        /**
         * Displays JavaScript based on Step 1 and 3.
         *
         * @since 2.6.0
         */
        public function js_1()
        {
        }
        /**
         * Displays JavaScript based on Step 2.
         *
         * @since 2.6.0
         */
        public function js_2()
        {
        }
        /**
         * Displays first step of custom header image page.
         *
         * @since 2.1.0
         */
        public function step_1()
        {
        }
        /**
         * Displays second step of custom header image page.
         *
         * @since 2.1.0
         */
        public function step_2()
        {
        }
        /**
         * Uploads the file to be cropped in the second step.
         *
         * @since 3.4.0
         */
        public function step_2_manage_upload()
        {
        }
        /**
         * Displays third step of custom header image page.
         *
         * @since 2.1.0
         * @since 4.4.0 Switched to using wp_get_attachment_url() instead of the guid
         *              for retrieving the header image URL.
         */
        public function step_3()
        {
        }
        /**
         * Displays last step of custom header image page.
         *
         * @since 2.1.0
         */
        public function finished()
        {
        }
        /**
         * Displays the page based on the current step.
         *
         * @since 2.1.0
         */
        public function admin_page()
        {
        }
        /**
         * Unused since 3.5.0.
         *
         * @since 3.4.0
         *
         * @param array $form_fields
         * @return array $form_fields
         */
        public function attachment_fields_to_edit($form_fields)
        {
        }
        /**
         * Unused since 3.5.0.
         *
         * @since 3.4.0
         *
         * @param array $tabs
         * @return array $tabs
         */
        public function filter_upload_tabs($tabs)
        {
        }
        /**
         * Chooses a header image, selected from existing uploaded and default headers,
         * or provides an array of uploaded header data (either new, or from media library).
         *
         * @since 3.4.0
         *
         * @param mixed $choice Which header image to select. Allows for values of 'random-default-image',
         *                      for randomly cycling among the default images; 'random-uploaded-image',
         *                      for randomly cycling among the uploaded images; the key of a default image
         *                      registered for that theme; and the key of an image uploaded for that theme
         *                      (the attachment ID of the image). Or an array of arguments: attachment_id,
         *                      url, width, height. All are required.
         * @phpstan-param string|array{attachment_id: int<1, max>, url: string, width: int<0, max>, height: int<0, max>} $choice
         * @phpstan-return void
         */
        final public function set_header_image($choice)
        {
        }
        /**
         * Removes a header image.
         *
         * @since 3.4.0
         */
        final public function remove_header_image()
        {
        }
        /**
         * Resets a header image to the default image for the theme.
         *
         * This method does not do anything if the theme does not have a default header image.
         *
         * @since 3.4.0
         * @phpstan-return void
         */
        final public function reset_header_image()
        {
        }
        /**
         * Calculates width and height based on what the currently selected theme supports.
         *
         * @since 3.9.0
         *
         * @param array $dimensions
         * @return array dst_height and dst_width of header image.
         */
        final public function get_header_dimensions($dimensions)
        {
        }
        /**
         * Creates an attachment 'object'.
         *
         * @since 3.9.0
         * @deprecated 6.5.0
         *
         * @param string $cropped              Cropped image URL.
         * @param int    $parent_attachment_id Attachment ID of parent image.
         * @return array An array with attachment object data.
         */
        final public function create_attachment_object($cropped, $parent_attachment_id)
        {
        }
        /**
         * Inserts an attachment and its metadata.
         *
         * @since 3.9.0
         *
         * @param array  $attachment An array with attachment object data.
         * @param string $cropped    File path to cropped image.
         * @return int Attachment ID.
         */
        final public function insert_attachment($attachment, $cropped)
        {
        }
        /**
         * Gets attachment uploaded by Media Manager, crops it, then saves it as a
         * new object. Returns JSON-encoded object details.
         *
         * @since 3.9.0
         * @phpstan-return never
         */
        public function ajax_header_crop()
        {
        }
        /**
         * Given an attachment ID for a header image, updates its "last used"
         * timestamp to now.
         *
         * Triggered when the user tries adds a new header image from the
         * Media Manager, even if s/he doesn't save that change.
         *
         * @since 3.9.0
         * @phpstan-return never
         */
        public function ajax_header_add()
        {
        }
        /**
         * Given an attachment ID for a header image, unsets it as a user-uploaded
         * header image for the active theme.
         *
         * Triggered when the user clicks the overlay "X" button next to each image
         * choice in the Customizer's Header tool.
         *
         * @since 3.9.0
         * @phpstan-return never
         */
        public function ajax_header_remove()
        {
        }
        /**
         * Updates the last-used postmeta on a header image attachment after saving a new header image via the Customizer.
         *
         * @since 3.9.0
         *
         * @param WP_Customize_Manager $wp_customize Customize manager.
         * @phpstan-return void
         */
        public function customize_set_last_used($wp_customize)
        {
        }
        /**
         * Gets the details of default header images if defined.
         *
         * @since 3.9.0
         *
         * @return array Default header images.
         */
        public function get_default_header_images()
        {
        }
        /**
         * Gets the previously uploaded header images.
         *
         * @since 3.9.0
         *
         * @return array Uploaded header images.
         */
        public function get_uploaded_header_images()
        {
        }
        /**
         * Gets the ID of a previous crop from the same base image.
         *
         * @since 4.9.0
         *
         * @param array $attachment An array with a cropped attachment object data.
         * @return int|false An attachment ID if one exists. False if none.
         */
        public function get_previous_crop($attachment)
        {
        }
    }
    /**
     * Core class used for handling file uploads.
     *
     * This class handles the upload process and passes it as if it's a local file
     * to the Upgrade/Installer functions.
     *
     * @since 2.8.0
     * @since 4.6.0 Moved to its own file from wp-admin/includes/class-wp-upgrader.php.
     */
    #[\AllowDynamicProperties]
    class File_Upload_Upgrader
    {
        /**
         * The full path to the file package.
         *
         * @since 2.8.0
         * @var string $package
         */
        public $package;
        /**
         * The name of the file.
         *
         * @since 2.8.0
         * @var string $filename
         */
        public $filename;
        /**
         * The ID of the attachment post for this file.
         *
         * @since 3.3.0
         * @var int $id
         */
        public $id = 0;
        /**
         * Construct the upgrader for a form.
         *
         * @since 2.8.0
         *
         * @param string $form      The name of the form the file was uploaded from.
         * @param string $urlholder The name of the `GET` parameter that holds the filename.
         */
        public function __construct($form, $urlholder)
        {
        }
        /**
         * Deletes the attachment/uploaded file.
         *
         * @since 3.2.2
         *
         * @return bool Whether the cleanup was successful.
         */
        public function cleanup()
        {
        }
    }
    /**
     * PemFTP base class
     *
     */
    class ftp_base
    {
        var $LocalEcho;
        var $Verbose;
        var $OS_local;
        var $OS_remote;
        var $_lastaction;
        var $_errors;
        var $_type;
        var $_umask;
        var $_timeout;
        var $_passive;
        var $_host;
        var $_fullhost;
        var $_port;
        var $_datahost;
        var $_dataport;
        var $_ftp_control_sock;
        var $_ftp_data_sock;
        var $_ftp_temp_sock;
        var $_ftp_buff_size;
        var $_login;
        var $_password;
        var $_connected;
        var $_ready;
        var $_code;
        var $_message;
        var $_can_restore;
        var $_port_available;
        var $_curtype;
        var $_features;
        var $_error_array;
        var $AuthorizedTransferMode;
        var $OS_FullName;
        var $_eol_code;
        var $AutoAsciiExt;
        function __construct($port_mode = \FALSE, $verb = \FALSE, $le = \FALSE)
        {
        }
        function ftp_base($port_mode = \FALSE)
        {
        }
        function parselisting($line)
        {
        }
        function SendMSG($message = "", $crlf = \true)
        {
        }
        function SetType($mode = \FTP_AUTOASCII)
        {
        }
        function _settype($mode = \FTP_ASCII)
        {
        }
        function Passive($pasv = \NULL)
        {
        }
        function SetServer($host, $port = 21, $reconnect = \true)
        {
        }
        function SetUmask($umask = 022)
        {
        }
        function SetTimeout($timeout = 30)
        {
        }
        function connect($server = \NULL)
        {
        }
        function quit($force = \false)
        {
        }
        function login($user = \NULL, $pass = \NULL)
        {
        }
        function pwd()
        {
        }
        function cdup()
        {
        }
        function chdir($pathname)
        {
        }
        function rmdir($pathname)
        {
        }
        function mkdir($pathname)
        {
        }
        function rename($from, $to)
        {
        }
        function filesize($pathname)
        {
        }
        function abort()
        {
        }
        function mdtm($pathname)
        {
        }
        function systype()
        {
        }
        function delete($pathname)
        {
        }
        function site($command, $fnction = "site")
        {
        }
        function chmod($pathname, $mode)
        {
        }
        function restore($from)
        {
        }
        function features()
        {
        }
        function rawlist($pathname = "", $arg = "")
        {
        }
        function nlist($pathname = "", $arg = "")
        {
        }
        function is_exists($pathname)
        {
        }
        function file_exists($pathname)
        {
        }
        function fget($fp, $remotefile, $rest = 0)
        {
        }
        function get($remotefile, $localfile = \NULL, $rest = 0)
        {
        }
        function fput($remotefile, $fp, $rest = 0)
        {
        }
        function put($localfile, $remotefile = \NULL, $rest = 0)
        {
        }
        function mput($local = ".", $remote = \NULL, $continious = \false)
        {
        }
        function mget($remote, $local = ".", $continious = \false)
        {
        }
        function mdel($remote, $continious = \false)
        {
        }
        function mmkdir($dir, $mode = 0777)
        {
        }
        function glob($pattern, $handle = \NULL)
        {
        }
        function glob_pattern_match($pattern, $subject)
        {
        }
        function glob_regexp($pattern, $subject)
        {
        }
        function dirlist($remote)
        {
        }
        function _checkCode()
        {
        }
        function _list($arg = "", $cmd = "LIST", $fnction = "_list")
        {
        }
        function PushError($fctname, $msg, $desc = \false)
        {
        }
        function PopError()
        {
        }
    }
    /**
     * FTP implementation using fsockopen to connect.
     *
     * @package PemFTP
     * @subpackage Pure
     * @since 2.5.0
     *
     * @version 1.0
     * @copyright Alexey Dotsenko
     * @author Alexey Dotsenko
     * @link https://www.phpclasses.org/package/1743-PHP-FTP-client-in-pure-PHP.html
     * @license LGPL https://opensource.org/licenses/lgpl-license.html
     */
    class ftp_pure extends \ftp_base
    {
        function __construct($verb = \FALSE, $le = \FALSE)
        {
        }
        function _settimeout($sock)
        {
        }
        function _connect($host, $port)
        {
        }
        function _readmsg($fnction = "_readmsg")
        {
        }
        function _exec($cmd, $fnction = "_exec")
        {
        }
        function _data_prepare($mode = \FTP_ASCII)
        {
        }
        function _data_read($mode = \FTP_ASCII, $fp = \NULL)
        {
        }
        function _data_write($mode = \FTP_ASCII, $fp = \NULL)
        {
        }
        function _data_write_block($mode, $block)
        {
        }
        function _data_close()
        {
        }
        function _quit($force = \FALSE)
        {
        }
    }
    /**
     * Socket Based FTP implementation
     *
     * @package PemFTP
     * @subpackage Socket
     * @since 2.5.0
     *
     * @version 1.0
     * @copyright Alexey Dotsenko
     * @author Alexey Dotsenko
     * @link https://www.phpclasses.org/package/1743-PHP-FTP-client-in-pure-PHP.html
     * @license LGPL https://opensource.org/licenses/lgpl-license.html
     */
    class ftp_sockets extends \ftp_base
    {
        function __construct($verb = \FALSE, $le = \FALSE)
        {
        }
        function _settimeout($sock)
        {
        }
        function _connect($host, $port)
        {
        }
        function _readmsg($fnction = "_readmsg")
        {
        }
        function _exec($cmd, $fnction = "_exec")
        {
        }
        function _data_prepare($mode = \FTP_ASCII)
        {
        }
        function _data_read($mode = \FTP_ASCII, $fp = \NULL)
        {
        }
        function _data_write($mode = \FTP_ASCII, $fp = \NULL)
        {
        }
        function _data_write_block($mode, $block)
        {
        }
        function _data_close()
        {
        }
        function _quit()
        {
        }
    }
    class ftp extends \ftp_sockets
    {
    }
    /**
     * Translation Upgrader Skin for WordPress Translation Upgrades.
     *
     * @since 3.7.0
     * @since 4.6.0 Moved to its own file from wp-admin/includes/class-wp-upgrader-skins.php.
     *
     * @see WP_Upgrader_Skin
     */
    class Language_Pack_Upgrader_Skin extends \WP_Upgrader_Skin
    {
        public $language_update = \null;
        public $done_header = \false;
        public $done_footer = \false;
        public $display_footer_actions = \true;
        /**
         * Constructor.
         *
         * Sets up the language pack upgrader skin.
         *
         * @since 3.7.0
         *
         * @param array $args
         */
        public function __construct($args = array())
        {
        }
        /**
         * Performs an action before a language pack update.
         *
         * @since 3.7.0
         */
        public function before()
        {
        }
        /**
         * Displays an error message about the update.
         *
         * @since 3.7.0
         * @since 5.9.0 Renamed `$error` to `$errors` for PHP 8 named parameter support.
         *
         * @param string|WP_Error $errors Errors.
         */
        public function error($errors)
        {
        }
        /**
         * Performs an action following a language pack update.
         *
         * @since 3.7.0
         */
        public function after()
        {
        }
        /**
         * Displays the footer following the bulk update process.
         *
         * @since 3.7.0
         */
        public function bulk_footer()
        {
        }
    }
    /**
     * Core class used for updating/installing language packs (translations)
     * for plugins, themes, and core.
     *
     * @since 3.7.0
     * @since 4.6.0 Moved to its own file from wp-admin/includes/class-wp-upgrader.php.
     *
     * @see WP_Upgrader
     */
    class Language_Pack_Upgrader extends \WP_Upgrader
    {
        /**
         * Result of the language pack upgrade.
         *
         * @since 3.7.0
         * @var array|WP_Error $result
         * @see WP_Upgrader::$result
         */
        public $result;
        /**
         * Whether a bulk upgrade/installation is being performed.
         *
         * @since 3.7.0
         * @var bool $bulk
         */
        public $bulk = \true;
        /**
         * Asynchronously upgrades language packs after other upgrades have been made.
         *
         * Hooked to the {@see 'upgrader_process_complete'} action by default.
         *
         * @since 3.7.0
         *
         * @param false|WP_Upgrader $upgrader Optional. WP_Upgrader instance or false. If `$upgrader` is
         *                                    a Language_Pack_Upgrader instance, the method will bail to
         *                                    avoid recursion. Otherwise unused. Default false.
         * @phpstan-return void
         */
        public static function async_upgrade($upgrader = \false)
        {
        }
        /**
         * Initializes the upgrade strings.
         *
         * @since 3.7.0
         */
        public function upgrade_strings()
        {
        }
        /**
         * Upgrades a language pack.
         *
         * @since 3.7.0
         *
         * @param string|false $update Optional. Whether an update offer is available. Default false.
         * @param array        $args   Optional. Other optional arguments, see
         *                             Language_Pack_Upgrader::bulk_upgrade(). Default empty array.
         * @return array|bool|WP_Error The result of the upgrade, or a WP_Error object instead.
         * @phpstan-param array{
         *   clear_update_cache?: bool,
         * } $args See Language_Pack_Upgrader::bulk_upgrade()
         */
        public function upgrade($update = \false, $args = array())
        {
        }
        /**
         * Upgrades several language packs at once.
         *
         * @since 3.7.0
         *
         * @global WP_Filesystem_Base $wp_filesystem WordPress filesystem subclass.
         *
         * @param object[] $language_updates Optional. Array of language packs to update. See {@see wp_get_translation_updates()}.
         *                                   Default empty array.
         * @param array    $args {
         *     Other arguments for upgrading multiple language packs. Default empty array.
         *
         *     @type bool $clear_update_cache Whether to clear the update cache when done.
         *                                    Default true.
         * }
         * @return array|bool|WP_Error Will return an array of results, or true if there are no updates,
         *                             false or WP_Error for initial errors.
         * @phpstan-param array{
         *   clear_update_cache?: bool,
         * } $args
         */
        public function bulk_upgrade($language_updates = array(), $args = array())
        {
        }
        /**
         * Checks that the package source contains .mo and .po files.
         *
         * Hooked to the {@see 'upgrader_source_selection'} filter by
         * Language_Pack_Upgrader::bulk_upgrade().
         *
         * @since 3.7.0
         *
         * @global WP_Filesystem_Base $wp_filesystem WordPress filesystem subclass.
         *
         * @param string|WP_Error $source        The path to the downloaded package source.
         * @param string          $remote_source Remote file source location.
         * @return string|WP_Error The source as passed, or a WP_Error object on failure.
         */
        public function check_package($source, $remote_source)
        {
        }
        /**
         * Gets the name of an item being updated.
         *
         * @since 3.7.0
         *
         * @param object $update The data for an update.
         * @return string The name of the item being updated.
         */
        public function get_name_for_update($update)
        {
        }
        /**
         * Clears existing translations where this item is going to be installed into.
         *
         * @since 5.1.0
         *
         * @global WP_Filesystem_Base $wp_filesystem WordPress filesystem subclass.
         *
         * @param string $remote_destination The location on the remote filesystem to be cleared.
         * @return bool|WP_Error True upon success, WP_Error on failure.
         */
        public function clear_destination($remote_destination)
        {
        }
    }
    class PclZip
    {
        var $zipname = '';
        var $zip_fd = 0;
        var $error_code = 1;
        var $error_string = '';
        var $magic_quotes_status;
        function __construct($p_zipname)
        {
        }
        public function PclZip($p_zipname)
        {
        }
        function create($p_filelist)
        {
        }
        function add($p_filelist)
        {
        }
        function listContent()
        {
        }
        function extract()
        {
        }
        function extractByIndex($p_index)
        {
        }
        function delete()
        {
        }
        function deleteByIndex($p_index)
        {
        }
        function properties()
        {
        }
        function duplicate($p_archive)
        {
        }
        function merge($p_archive_to_add)
        {
        }
        function errorCode()
        {
        }
        function errorName($p_with_code = \false)
        {
        }
        function errorInfo($p_full = \false)
        {
        }
        function privCheckFormat($p_level = 0)
        {
        }
        function privParseOptions(&$p_options_list, $p_size, &$v_result_list, $v_requested_options = \false)
        {
        }
        function privOptionDefaultThreshold(&$p_options)
        {
        }
        function privFileDescrParseAtt(&$p_file_list, &$p_filedescr, $v_options, $v_requested_options = \false)
        {
        }
        function privFileDescrExpand(&$p_filedescr_list, &$p_options)
        {
        }
        function privCreate($p_filedescr_list, &$p_result_list, &$p_options)
        {
        }
        function privAdd($p_filedescr_list, &$p_result_list, &$p_options)
        {
        }
        function privOpenFd($p_mode)
        {
        }
        function privCloseFd()
        {
        }
        function privAddList($p_filedescr_list, &$p_result_list, &$p_options)
        {
        }
        function privAddFileList($p_filedescr_list, &$p_result_list, &$p_options)
        {
        }
        function privAddFile($p_filedescr, &$p_header, &$p_options)
        {
        }
        function privAddFileUsingTempFile($p_filedescr, &$p_header, &$p_options)
        {
        }
        function privCalculateStoredFilename(&$p_filedescr, &$p_options)
        {
        }
        function privWriteFileHeader(&$p_header)
        {
        }
        function privWriteCentralFileHeader(&$p_header)
        {
        }
        function privWriteCentralHeader($p_nb_entries, $p_size, $p_offset, $p_comment)
        {
        }
        function privList(&$p_list)
        {
        }
        function privConvertHeader2FileInfo($p_header, &$p_info)
        {
        }
        function privExtractByRule(&$p_file_list, $p_path, $p_remove_path, $p_remove_all_path, &$p_options)
        {
        }
        function privExtractFile(&$p_entry, $p_path, $p_remove_path, $p_remove_all_path, &$p_options)
        {
        }
        function privExtractFileUsingTempFile(&$p_entry, &$p_options)
        {
        }
        function privExtractFileInOutput(&$p_entry, &$p_options)
        {
        }
        function privExtractFileAsString(&$p_entry, &$p_string, &$p_options)
        {
        }
        function privReadFileHeader(&$p_header)
        {
        }
        function privReadCentralFileHeader(&$p_header)
        {
        }
        function privCheckFileHeaders(&$p_local_header, &$p_central_header)
        {
        }
        function privReadEndCentralDir(&$p_central_dir)
        {
        }
        function privDeleteByRule(&$p_result_list, &$p_options)
        {
        }
        function privDirCheck($p_dir, $p_is_dir = \false)
        {
        }
        function privMerge(&$p_archive_to_add)
        {
        }
        function privDuplicate($p_archive_filename)
        {
        }
        function privErrorLog($p_error_code = 0, $p_error_string = '')
        {
        }
        function privErrorReset()
        {
        }
        function privDisableMagicQuotes()
        {
        }
        function privSwapBackMagicQuotes()
        {
        }
        // --------------------------------------------------------------------------------
    }
    /**
     * Plugin Installer Skin for WordPress Plugin Installer.
     *
     * @since 2.8.0
     * @since 4.6.0 Moved to its own file from wp-admin/includes/class-wp-upgrader-skins.php.
     *
     * @see WP_Upgrader_Skin
     */
    class Plugin_Installer_Skin extends \WP_Upgrader_Skin
    {
        public $api;
        public $type;
        public $url;
        public $overwrite;
        /**
         * Constructor.
         *
         * Sets up the plugin installer skin.
         *
         * @since 2.8.0
         *
         * @param array $args
         */
        public function __construct($args = array())
        {
        }
        /**
         * Performs an action before installing a plugin.
         *
         * @since 2.8.0
         */
        public function before()
        {
        }
        /**
         * Hides the `process_failed` error when updating a plugin by uploading a zip file.
         *
         * @since 5.5.0
         *
         * @param WP_Error $wp_error WP_Error object.
         * @return bool True if the error should be hidden, false otherwise.
         */
        public function hide_process_failed($wp_error)
        {
        }
        /**
         * Performs an action following a plugin install.
         *
         * @since 2.8.0
         * @phpstan-return void
         */
        public function after()
        {
        }
    }
    /**
     * Plugin Upgrader Skin for WordPress Plugin Upgrades.
     *
     * @since 2.8.0
     * @since 4.6.0 Moved to its own file from wp-admin/includes/class-wp-upgrader-skins.php.
     *
     * @see WP_Upgrader_Skin
     */
    class Plugin_Upgrader_Skin extends \WP_Upgrader_Skin
    {
        /**
         * Holds the plugin slug in the Plugin Directory.
         *
         * @since 2.8.0
         *
         * @var string
         */
        public $plugin = '';
        /**
         * Whether the plugin is active.
         *
         * @since 2.8.0
         *
         * @var bool
         */
        public $plugin_active = \false;
        /**
         * Whether the plugin is active for the entire network.
         *
         * @since 2.8.0
         *
         * @var bool
         */
        public $plugin_network_active = \false;
        /**
         * Constructor.
         *
         * Sets up the plugin upgrader skin.
         *
         * @since 2.8.0
         *
         * @param array $args Optional. The plugin upgrader skin arguments to
         *                    override default options. Default empty array.
         */
        public function __construct($args = array())
        {
        }
        /**
         * Performs an action following a single plugin update.
         *
         * @since 2.8.0
         */
        public function after()
        {
        }
    }
    /**
     * Core class used for upgrading/installing plugins.
     *
     * It is designed to upgrade/install plugins from a local zip, remote zip URL,
     * or uploaded zip file.
     *
     * @since 2.8.0
     * @since 4.6.0 Moved to its own file from wp-admin/includes/class-wp-upgrader.php.
     *
     * @see WP_Upgrader
     */
    class Plugin_Upgrader extends \WP_Upgrader
    {
        /**
         * Plugin upgrade result.
         *
         * @since 2.8.0
         * @var array|WP_Error $result
         *
         * @see WP_Upgrader::$result
         */
        public $result;
        /**
         * Whether a bulk upgrade/installation is being performed.
         *
         * @since 2.9.0
         * @var bool $bulk
         */
        public $bulk = \false;
        /**
         * New plugin info.
         *
         * @since 5.5.0
         * @var array $new_plugin_data
         *
         * @see check_package()
         */
        public $new_plugin_data = array();
        /**
         * Initializes the upgrade strings.
         *
         * @since 2.8.0
         */
        public function upgrade_strings()
        {
        }
        /**
         * Initializes the installation strings.
         *
         * @since 2.8.0
         */
        public function install_strings()
        {
        }
        /**
         * Install a plugin package.
         *
         * @since 2.8.0
         * @since 3.7.0 The `$args` parameter was added, making clearing the plugin update cache optional.
         *
         * @param string $package The full local path or URI of the package.
         * @param array  $args {
         *     Optional. Other arguments for installing a plugin package. Default empty array.
         *
         *     @type bool $clear_update_cache Whether to clear the plugin updates cache if successful.
         *                                    Default true.
         * }
         * @return bool|WP_Error True if the installation was successful, false or a WP_Error otherwise.
         * @phpstan-param array{
         *   clear_update_cache?: bool,
         * } $args
         */
        public function install($package, $args = array())
        {
        }
        /**
         * Upgrades a plugin.
         *
         * @since 2.8.0
         * @since 3.7.0 The `$args` parameter was added, making clearing the plugin update cache optional.
         *
         * @param string $plugin Path to the plugin file relative to the plugins directory.
         * @param array  $args {
         *     Optional. Other arguments for upgrading a plugin package. Default empty array.
         *
         *     @type bool $clear_update_cache Whether to clear the plugin updates cache if successful.
         *                                    Default true.
         * }
         * @return bool|WP_Error True if the upgrade was successful, false or a WP_Error object otherwise.
         * @phpstan-param array{
         *   clear_update_cache?: bool,
         * } $args
         */
        public function upgrade($plugin, $args = array())
        {
        }
        /**
         * Upgrades several plugins at once.
         *
         * @since 2.8.0
         * @since 3.7.0 The `$args` parameter was added, making clearing the plugin update cache optional.
         *
         * @param string[] $plugins Array of paths to plugin files relative to the plugins directory.
         * @param array    $args {
         *     Optional. Other arguments for upgrading several plugins at once.
         *
         *     @type bool $clear_update_cache Whether to clear the plugin updates cache if successful. Default true.
         * }
         * @return array|false An array of results indexed by plugin file, or false if unable to connect to the filesystem.
         * @phpstan-param array{
         *   clear_update_cache?: bool,
         * } $args
         */
        public function bulk_upgrade($plugins, $args = array())
        {
        }
        /**
         * Checks that the source package contains a valid plugin.
         *
         * Hooked to the {@see 'upgrader_source_selection'} filter by Plugin_Upgrader::install().
         *
         * @since 3.3.0
         *
         * @global WP_Filesystem_Base $wp_filesystem WordPress filesystem subclass.
         *
         * @param string $source The path to the downloaded package source.
         * @return string|WP_Error The source as passed, or a WP_Error object on failure.
         */
        public function check_package($source)
        {
        }
        /**
         * Retrieves the path to the file that contains the plugin info.
         *
         * This isn't used internally in the class, but is called by the skins.
         *
         * @since 2.8.0
         *
         * @return string|false The full path to the main plugin file, or false.
         */
        public function plugin_info()
        {
        }
        /**
         * Deactivates a plugin before it is upgraded.
         *
         * Hooked to the {@see 'upgrader_pre_install'} filter by Plugin_Upgrader::upgrade().
         *
         * @since 2.8.0
         * @since 4.1.0 Added a return value.
         *
         * @param bool|WP_Error $response The installation response before the installation has started.
         * @param array         $plugin   Plugin package arguments.
         * @return bool|WP_Error The original `$response` parameter or WP_Error.
         */
        public function deactivate_plugin_before_upgrade($response, $plugin)
        {
        }
        /**
         * Turns on maintenance mode before attempting to background update an active plugin.
         *
         * Hooked to the {@see 'upgrader_pre_install'} filter by Plugin_Upgrader::upgrade().
         *
         * @since 5.4.0
         *
         * @param bool|WP_Error $response The installation response before the installation has started.
         * @param array         $plugin   Plugin package arguments.
         * @return bool|WP_Error The original `$response` parameter or WP_Error.
         */
        public function active_before($response, $plugin)
        {
        }
        /**
         * Turns off maintenance mode after upgrading an active plugin.
         *
         * Hooked to the {@see 'upgrader_post_install'} filter by Plugin_Upgrader::upgrade().
         *
         * @since 5.4.0
         *
         * @param bool|WP_Error $response The installation response after the installation has finished.
         * @param array         $plugin   Plugin package arguments.
         * @return bool|WP_Error The original `$response` parameter or WP_Error.
         */
        public function active_after($response, $plugin)
        {
        }
        /**
         * Deletes the old plugin during an upgrade.
         *
         * Hooked to the {@see 'upgrader_clear_destination'} filter by
         * Plugin_Upgrader::upgrade() and Plugin_Upgrader::bulk_upgrade().
         *
         * @since 2.8.0
         *
         * @global WP_Filesystem_Base $wp_filesystem WordPress filesystem subclass.
         *
         * @param bool|WP_Error $removed            Whether the destination was cleared.
         *                                          True on success, WP_Error on failure.
         * @param string        $local_destination  The local package destination.
         * @param string        $remote_destination The remote package destination.
         * @param array         $plugin             Extra arguments passed to hooked filters.
         * @return bool|WP_Error
         */
        public function delete_old_plugin($removed, $local_destination, $remote_destination, $plugin)
        {
        }
    }
    /**
     * Theme Installer Skin for the WordPress Theme Installer.
     *
     * @since 2.8.0
     * @since 4.6.0 Moved to its own file from wp-admin/includes/class-wp-upgrader-skins.php.
     *
     * @see WP_Upgrader_Skin
     */
    class Theme_Installer_Skin extends \WP_Upgrader_Skin
    {
        public $api;
        public $type;
        public $url;
        public $overwrite;
        /**
         * Constructor.
         *
         * Sets up the theme installer skin.
         *
         * @since 2.8.0
         *
         * @param array $args
         */
        public function __construct($args = array())
        {
        }
        /**
         * Performs an action before installing a theme.
         *
         * @since 2.8.0
         */
        public function before()
        {
        }
        /**
         * Hides the `process_failed` error when updating a theme by uploading a zip file.
         *
         * @since 5.5.0
         *
         * @param WP_Error $wp_error WP_Error object.
         * @return bool True if the error should be hidden, false otherwise.
         */
        public function hide_process_failed($wp_error)
        {
        }
        /**
         * Performs an action following a single theme install.
         *
         * @since 2.8.0
         * @phpstan-return void
         */
        public function after()
        {
        }
    }
    /**
     * Theme Upgrader Skin for WordPress Theme Upgrades.
     *
     * @since 2.8.0
     * @since 4.6.0 Moved to its own file from wp-admin/includes/class-wp-upgrader-skins.php.
     *
     * @see WP_Upgrader_Skin
     */
    class Theme_Upgrader_Skin extends \WP_Upgrader_Skin
    {
        /**
         * Holds the theme slug in the Theme Directory.
         *
         * @since 2.8.0
         *
         * @var string
         */
        public $theme = '';
        /**
         * Constructor.
         *
         * Sets up the theme upgrader skin.
         *
         * @since 2.8.0
         *
         * @param array $args Optional. The theme upgrader skin arguments to
         *                    override default options. Default empty array.
         */
        public function __construct($args = array())
        {
        }
        /**
         * Performs an action following a single theme update.
         *
         * @since 2.8.0
         */
        public function after()
        {
        }
    }
    /**
     * Core class used for upgrading/installing themes.
     *
     * It is designed to upgrade/install themes from a local zip, remote zip URL,
     * or uploaded zip file.
     *
     * @since 2.8.0
     * @since 4.6.0 Moved to its own file from wp-admin/includes/class-wp-upgrader.php.
     *
     * @see WP_Upgrader
     */
    class Theme_Upgrader extends \WP_Upgrader
    {
        /**
         * Result of the theme upgrade offer.
         *
         * @since 2.8.0
         * @var array|WP_Error $result
         * @see WP_Upgrader::$result
         */
        public $result;
        /**
         * Whether multiple themes are being upgraded/installed in bulk.
         *
         * @since 2.9.0
         * @var bool $bulk
         */
        public $bulk = \false;
        /**
         * New theme info.
         *
         * @since 5.5.0
         * @var array $new_theme_data
         *
         * @see check_package()
         */
        public $new_theme_data = array();
        /**
         * Initializes the upgrade strings.
         *
         * @since 2.8.0
         */
        public function upgrade_strings()
        {
        }
        /**
         * Initializes the installation strings.
         *
         * @since 2.8.0
         */
        public function install_strings()
        {
        }
        /**
         * Checks if a child theme is being installed and its parent also needs to be installed.
         *
         * Hooked to the {@see 'upgrader_post_install'} filter by Theme_Upgrader::install().
         *
         * @since 3.4.0
         *
         * @param bool  $install_result
         * @param array $hook_extra
         * @param array $child_result
         * @return bool
         */
        public function check_parent_theme_filter($install_result, $hook_extra, $child_result)
        {
        }
        /**
         * Don't display the activate and preview actions to the user.
         *
         * Hooked to the {@see 'install_theme_complete_actions'} filter by
         * Theme_Upgrader::check_parent_theme_filter() when installing
         * a child theme and installing the parent theme fails.
         *
         * @since 3.4.0
         *
         * @param array $actions Preview actions.
         * @return array
         */
        public function hide_activate_preview_actions($actions)
        {
        }
        /**
         * Install a theme package.
         *
         * @since 2.8.0
         * @since 3.7.0 The `$args` parameter was added, making clearing the update cache optional.
         *
         * @param string $package The full local path or URI of the package.
         * @param array  $args {
         *     Optional. Other arguments for installing a theme package. Default empty array.
         *
         *     @type bool $clear_update_cache Whether to clear the updates cache if successful.
         *                                    Default true.
         * }
         *
         * @return bool|WP_Error True if the installation was successful, false or a WP_Error object otherwise.
         * @phpstan-param array{
         *   clear_update_cache?: bool,
         * } $args
         */
        public function install($package, $args = array())
        {
        }
        /**
         * Upgrades a theme.
         *
         * @since 2.8.0
         * @since 3.7.0 The `$args` parameter was added, making clearing the update cache optional.
         *
         * @param string $theme The theme slug.
         * @param array  $args {
         *     Optional. Other arguments for upgrading a theme. Default empty array.
         *
         *     @type bool $clear_update_cache Whether to clear the update cache if successful.
         *                                    Default true.
         * }
         * @return bool|WP_Error True if the upgrade was successful, false or a WP_Error object otherwise.
         * @phpstan-param array{
         *   clear_update_cache?: bool,
         * } $args
         */
        public function upgrade($theme, $args = array())
        {
        }
        /**
         * Upgrades several themes at once.
         *
         * @since 3.0.0
         * @since 3.7.0 The `$args` parameter was added, making clearing the update cache optional.
         *
         * @param string[] $themes Array of the theme slugs.
         * @param array    $args {
         *     Optional. Other arguments for upgrading several themes at once. Default empty array.
         *
         *     @type bool $clear_update_cache Whether to clear the update cache if successful.
         *                                    Default true.
         * }
         * @return array[]|false An array of results, or false if unable to connect to the filesystem.
         * @phpstan-param array{
         *   clear_update_cache?: bool,
         * } $args
         */
        public function bulk_upgrade($themes, $args = array())
        {
        }
        /**
         * Checks that the package source contains a valid theme.
         *
         * Hooked to the {@see 'upgrader_source_selection'} filter by Theme_Upgrader::install().
         *
         * @since 3.3.0
         *
         * @global WP_Filesystem_Base $wp_filesystem WordPress filesystem subclass.
         *
         * @param string $source The path to the downloaded package source.
         * @return string|WP_Error The source as passed, or a WP_Error object on failure.
         */
        public function check_package($source)
        {
        }
        /**
         * Turns on maintenance mode before attempting to upgrade the active theme.
         *
         * Hooked to the {@see 'upgrader_pre_install'} filter by Theme_Upgrader::upgrade() and
         * Theme_Upgrader::bulk_upgrade().
         *
         * @since 2.8.0
         *
         * @param bool|WP_Error $response The installation response before the installation has started.
         * @param array         $theme    Theme arguments.
         * @return bool|WP_Error The original `$response` parameter or WP_Error.
         */
        public function current_before($response, $theme)
        {
        }
        /**
         * Turns off maintenance mode after upgrading the active theme.
         *
         * Hooked to the {@see 'upgrader_post_install'} filter by Theme_Upgrader::upgrade()
         * and Theme_Upgrader::bulk_upgrade().
         *
         * @since 2.8.0
         *
         * @param bool|WP_Error $response The installation response after the installation has finished.
         * @param array         $theme    Theme arguments.
         * @return bool|WP_Error The original `$response` parameter or WP_Error.
         */
        public function current_after($response, $theme)
        {
        }
        /**
         * Deletes the old theme during an upgrade.
         *
         * Hooked to the {@see 'upgrader_clear_destination'} filter by Theme_Upgrader::upgrade()
         * and Theme_Upgrader::bulk_upgrade().
         *
         * @since 2.8.0
         *
         * @global WP_Filesystem_Base $wp_filesystem Subclass
         *
         * @param bool   $removed
         * @param string $local_destination
         * @param string $remote_destination
         * @param array  $theme
         * @return bool
         */
        public function delete_old_theme($removed, $local_destination, $remote_destination, $theme)
        {
        }
        /**
         * Gets the WP_Theme object for a theme.
         *
         * @since 2.8.0
         * @since 3.0.0 The `$theme` argument was added.
         *
         * @param string $theme The directory name of the theme. This is optional, and if not supplied,
         *                      the directory name from the last result will be used.
         * @return WP_Theme|false The theme's info object, or false `$theme` is not supplied
         *                        and the last result isn't set.
         */
        public function theme_info($theme = \null)
        {
        }
    }
    /**
     * A class for displaying various tree-like structures.
     *
     * Extend the Walker class to use it, see examples below. Child classes
     * do not need to implement all of the abstract methods in the class. The child
     * only needs to implement the methods that are needed.
     *
     * @since 2.1.0
     *
     * @package WordPress
     * @abstract
     */
    #[\AllowDynamicProperties]
    class Walker
    {
        /**
         * What the class handles.
         *
         * @since 2.1.0
         * @var string
         */
        public $tree_type;
        /**
         * DB fields to use.
         *
         * @since 2.1.0
         * @var string[]
         */
        public $db_fields;
        /**
         * Max number of pages walked by the paged walker.
         *
         * @since 2.7.0
         * @var int
         */
        public $max_pages = 1;
        /**
         * Whether the current element has children or not.
         *
         * To be used in start_el().
         *
         * @since 4.0.0
         * @var bool
         */
        public $has_children;
        /**
         * Starts the list before the elements are added.
         *
         * The $args parameter holds additional values that may be used with the child
         * class methods. This method is called at the start of the output list.
         *
         * @since 2.1.0
         * @abstract
         *
         * @param string $output Used to append additional content (passed by reference).
         * @param int    $depth  Depth of the item.
         * @param array  $args   An array of additional arguments.
         */
        public function start_lvl(&$output, $depth = 0, $args = array())
        {
        }
        /**
         * Ends the list of after the elements are added.
         *
         * The $args parameter holds additional values that may be used with the child
         * class methods. This method finishes the list at the end of output of the elements.
         *
         * @since 2.1.0
         * @abstract
         *
         * @param string $output Used to append additional content (passed by reference).
         * @param int    $depth  Depth of the item.
         * @param array  $args   An array of additional arguments.
         */
        public function end_lvl(&$output, $depth = 0, $args = array())
        {
        }
        /**
         * Starts the element output.
         *
         * The $args parameter holds additional values that may be used with the child
         * class methods. Also includes the element output.
         *
         * @since 2.1.0
         * @since 5.9.0 Renamed `$object` (a PHP reserved keyword) to `$data_object` for PHP 8 named parameter support.
         * @abstract
         *
         * @param string $output            Used to append additional content (passed by reference).
         * @param object $data_object       The data object.
         * @param int    $depth             Depth of the item.
         * @param array  $args              An array of additional arguments.
         * @param int    $current_object_id Optional. ID of the current item. Default 0.
         */
        public function start_el(&$output, $data_object, $depth = 0, $args = array(), $current_object_id = 0)
        {
        }
        /**
         * Ends the element output, if needed.
         *
         * The $args parameter holds additional values that may be used with the child class methods.
         *
         * @since 2.1.0
         * @since 5.9.0 Renamed `$object` (a PHP reserved keyword) to `$data_object` for PHP 8 named parameter support.
         * @abstract
         *
         * @param string $output      Used to append additional content (passed by reference).
         * @param object $data_object The data object.
         * @param int    $depth       Depth of the item.
         * @param array  $args        An array of additional arguments.
         */
        public function end_el(&$output, $data_object, $depth = 0, $args = array())
        {
        }
        /**
         * Traverses elements to create list from elements.
         *
         * Display one element if the element doesn't have any children otherwise,
         * display the element and its children. Will only traverse up to the max
         * depth and no ignore elements under that depth. It is possible to set the
         * max depth to include all depths, see walk() method.
         *
         * This method should not be called directly, use the walk() method instead.
         *
         * @since 2.5.0
         *
         * @param object $element           Data object.
         * @param array  $children_elements List of elements to continue traversing (passed by reference).
         * @param int    $max_depth         Max depth to traverse.
         * @param int    $depth             Depth of current element.
         * @param array  $args              An array of arguments.
         * @param string $output            Used to append additional content (passed by reference).
         * @phpstan-return void
         */
        public function display_element($element, &$children_elements, $max_depth, $depth, $args, &$output)
        {
        }
        /**
         * Displays array of elements hierarchically.
         *
         * Does not assume any existing order of elements.
         *
         * $max_depth = -1 means flatly display every element.
         * $max_depth = 0 means display all levels.
         * $max_depth > 0 specifies the number of display levels.
         *
         * @since 2.1.0
         * @since 5.3.0 Formalized the existing `...$args` parameter by adding it
         *              to the function signature.
         *
         * @param array $elements  An array of elements.
         * @param int   $max_depth The maximum hierarchical depth.
         * @param mixed ...$args   Optional additional arguments.
         * @return string The hierarchical item output.
         */
        public function walk($elements, $max_depth, ...$args)
        {
        }
        /**
         * Produces a page of nested elements.
         *
         * Given an array of hierarchical elements, the maximum depth, a specific page number,
         * and number of elements per page, this function first determines all top level root elements
         * belonging to that page, then lists them and all of their children in hierarchical order.
         *
         * $max_depth = 0 means display all levels.
         * $max_depth > 0 specifies the number of display levels.
         *
         * @since 2.7.0
         * @since 5.3.0 Formalized the existing `...$args` parameter by adding it
         *              to the function signature.
         *
         * @param array $elements  An array of elements.
         * @param int   $max_depth The maximum hierarchical depth.
         * @param int   $page_num  The specific page number, beginning with 1.
         * @param int   $per_page  Number of elements per page.
         * @param mixed ...$args   Optional additional arguments.
         * @return string XHTML of the specified page of elements.
         */
        public function paged_walk($elements, $max_depth, $page_num, $per_page, ...$args)
        {
        }
        /**
         * Calculates the total number of root elements.
         *
         * @since 2.7.0
         *
         * @param array $elements Elements to list.
         * @return int Number of root elements.
         */
        public function get_number_of_root_elements($elements)
        {
        }
        /**
         * Unsets all the children for a given top level element.
         *
         * @since 2.7.0
         *
         * @param object $element           The top level element.
         * @param array  $children_elements The children elements.
         * @phpstan-return void
         */
        public function unset_children($element, &$children_elements)
        {
        }
    }
    /**
     * Core walker class to output an unordered list of category checkbox input elements.
     *
     * @since 2.5.1
     *
     * @see Walker
     * @see wp_category_checklist()
     * @see wp_terms_checklist()
     */
    class Walker_Category_Checklist extends \Walker
    {
        public $tree_type = 'category';
        public $db_fields = array('parent' => 'parent', 'id' => 'term_id');
        /**
         * Starts the list before the elements are added.
         *
         * @see Walker:start_lvl()
         *
         * @since 2.5.1
         *
         * @param string $output Used to append additional content (passed by reference).
         * @param int    $depth  Depth of category. Used for tab indentation.
         * @param array  $args   An array of arguments. See {@see wp_terms_checklist()}.
         * @phpstan-param array{
         *   descendants_and_self?: int,
         *   selected_cats?: int[],
         *   popular_cats?: int[],
         *   walker?: Walker,
         *   taxonomy?: string,
         *   checked_ontop?: bool,
         *   echo?: bool,
         * } $args See wp_terms_checklist()
         */
        public function start_lvl(&$output, $depth = 0, $args = array())
        {
        }
        /**
         * Ends the list of after the elements are added.
         *
         * @see Walker::end_lvl()
         *
         * @since 2.5.1
         *
         * @param string $output Used to append additional content (passed by reference).
         * @param int    $depth  Depth of category. Used for tab indentation.
         * @param array  $args   An array of arguments. See {@see wp_terms_checklist()}.
         * @phpstan-param array{
         *   descendants_and_self?: int,
         *   selected_cats?: int[],
         *   popular_cats?: int[],
         *   walker?: Walker,
         *   taxonomy?: string,
         *   checked_ontop?: bool,
         *   echo?: bool,
         * } $args See wp_terms_checklist()
         */
        public function end_lvl(&$output, $depth = 0, $args = array())
        {
        }
        /**
         * Start the element output.
         *
         * @see Walker::start_el()
         *
         * @since 2.5.1
         * @since 5.9.0 Renamed `$category` to `$data_object` and `$id` to `$current_object_id`
         *              to match parent class for PHP 8 named parameter support.
         *
         * @param string  $output            Used to append additional content (passed by reference).
         * @param WP_Term $data_object       The current term object.
         * @param int     $depth             Depth of the term in reference to parents. Default 0.
         * @param array   $args              An array of arguments. See {@see wp_terms_checklist()}.
         * @param int     $current_object_id Optional. ID of the current term. Default 0.
         * @phpstan-param array{
         *   descendants_and_self?: int,
         *   selected_cats?: int[],
         *   popular_cats?: int[],
         *   walker?: Walker,
         *   taxonomy?: string,
         *   checked_ontop?: bool,
         *   echo?: bool,
         * } $args See wp_terms_checklist()
         */
        public function start_el(&$output, $data_object, $depth = 0, $args = array(), $current_object_id = 0)
        {
        }
        /**
         * Ends the element output, if needed.
         *
         * @see Walker::end_el()
         *
         * @since 2.5.1
         * @since 5.9.0 Renamed `$category` to `$data_object` to match parent class for PHP 8 named parameter support.
         *
         * @param string  $output      Used to append additional content (passed by reference).
         * @param WP_Term $data_object The current term object.
         * @param int     $depth       Depth of the term in reference to parents. Default 0.
         * @param array   $args        An array of arguments. See {@see wp_terms_checklist()}.
         * @phpstan-param array{
         *   descendants_and_self?: int,
         *   selected_cats?: int[],
         *   popular_cats?: int[],
         *   walker?: Walker,
         *   taxonomy?: string,
         *   checked_ontop?: bool,
         *   echo?: bool,
         * } $args See wp_terms_checklist()
         */
        public function end_el(&$output, $data_object, $depth = 0, $args = array())
        {
        }
    }
    /**
     * Core class used to implement an HTML list of nav menu items.
     *
     * @since 3.0.0
     *
     * @see Walker
     */
    class Walker_Nav_Menu extends \Walker
    {
        /**
         * What the class handles.
         *
         * @since 3.0.0
         * @var string
         *
         * @see Walker::$tree_type
         */
        public $tree_type = array('post_type', 'taxonomy', 'custom');
        /**
         * Database fields to use.
         *
         * @since 3.0.0
         * @todo Decouple this.
         * @var string[]
         *
         * @see Walker::$db_fields
         */
        public $db_fields = array('parent' => 'menu_item_parent', 'id' => 'db_id');
        /**
         * Constructor.
         *
         * @since 6.8.0
         */
        public function __construct()
        {
        }
        /**
         * Starts the list before the elements are added.
         *
         * @since 3.0.0
         *
         * @see Walker::start_lvl()
         *
         * @param string   $output Used to append additional content (passed by reference).
         * @param int      $depth  Depth of menu item. Used for padding.
         * @param stdClass $args   An object of wp_nav_menu() arguments.
         */
        public function start_lvl(&$output, $depth = 0, $args = \null)
        {
        }
        /**
         * Ends the list of after the elements are added.
         *
         * @since 3.0.0
         *
         * @see Walker::end_lvl()
         *
         * @param string   $output Used to append additional content (passed by reference).
         * @param int      $depth  Depth of menu item. Used for padding.
         * @param stdClass $args   An object of wp_nav_menu() arguments.
         */
        public function end_lvl(&$output, $depth = 0, $args = \null)
        {
        }
        /**
         * Starts the element output.
         *
         * @since 3.0.0
         * @since 4.4.0 The {@see 'nav_menu_item_args'} filter was added.
         * @since 5.9.0 Renamed `$item` to `$data_object` and `$id` to `$current_object_id`
         *              to match parent class for PHP 8 named parameter support.
         * @since 6.7.0 Removed redundant title attributes.
         *
         * @see Walker::start_el()
         *
         * @param string   $output            Used to append additional content (passed by reference).
         * @param WP_Post  $data_object       Menu item data object.
         * @param int      $depth             Depth of menu item. Used for padding.
         * @param stdClass $args              An object of wp_nav_menu() arguments.
         * @param int      $current_object_id Optional. ID of the current menu item. Default 0.
         */
        public function start_el(&$output, $data_object, $depth = 0, $args = \null, $current_object_id = 0)
        {
        }
        /**
         * Ends the element output, if needed.
         *
         * @since 3.0.0
         * @since 5.9.0 Renamed `$item` to `$data_object` to match parent class for PHP 8 named parameter support.
         *
         * @see Walker::end_el()
         *
         * @param string   $output      Used to append additional content (passed by reference).
         * @param WP_Post  $data_object Menu item data object. Not used.
         * @param int      $depth       Depth of page. Not Used.
         * @param stdClass $args        An object of wp_nav_menu() arguments.
         */
        public function end_el(&$output, $data_object, $depth = 0, $args = \null)
        {
        }
        /**
         * Builds a string of HTML attributes from an array of key/value pairs.
         * Empty values are ignored.
         *
         * @since 6.3.0
         *
         * @param  array $atts Optional. An array of HTML attribute key/value pairs. Default empty array.
         * @return string A string of HTML attributes.
         */
        protected function build_atts($atts = array())
        {
        }
    }
    /**
     * Create HTML list of nav menu input items.
     *
     * @since 3.0.0
     * @uses Walker_Nav_Menu
     */
    class Walker_Nav_Menu_Checklist extends \Walker_Nav_Menu
    {
        /**
         * @param array|false $fields Database fields to use.
         */
        public function __construct($fields = \false)
        {
        }
        /**
         * Starts the list before the elements are added.
         *
         * @see Walker_Nav_Menu::start_lvl()
         *
         * @since 3.0.0
         *
         * @param string   $output Used to append additional content (passed by reference).
         * @param int      $depth  Depth of page. Used for padding.
         * @param stdClass $args   Not used.
         */
        public function start_lvl(&$output, $depth = 0, $args = \null)
        {
        }
        /**
         * Ends the list of after the elements are added.
         *
         * @see Walker_Nav_Menu::end_lvl()
         *
         * @since 3.0.0
         *
         * @param string   $output Used to append additional content (passed by reference).
         * @param int      $depth  Depth of page. Used for padding.
         * @param stdClass $args   Not used.
         */
        public function end_lvl(&$output, $depth = 0, $args = \null)
        {
        }
        /**
         * Start the element output.
         *
         * @see Walker_Nav_Menu::start_el()
         *
         * @since 3.0.0
         * @since 5.9.0 Renamed `$item` to `$data_object` and `$id` to `$current_object_id`
         *              to match parent class for PHP 8 named parameter support.
         *
         * @global int        $_nav_menu_placeholder
         * @global int|string $nav_menu_selected_id
         *
         * @param string   $output            Used to append additional content (passed by reference).
         * @param WP_Post  $data_object       Menu item data object.
         * @param int      $depth             Depth of menu item. Used for padding.
         * @param stdClass $args              Not used.
         * @param int      $current_object_id Optional. ID of the current menu item. Default 0.
         */
        public function start_el(&$output, $data_object, $depth = 0, $args = \null, $current_object_id = 0)
        {
        }
    }
    /**
     * Create HTML list of nav menu input items.
     *
     * @since 3.0.0
     *
     * @see Walker_Nav_Menu
     */
    class Walker_Nav_Menu_Edit extends \Walker_Nav_Menu
    {
        /**
         * Starts the list before the elements are added.
         *
         * @see Walker_Nav_Menu::start_lvl()
         *
         * @since 3.0.0
         *
         * @param string   $output Passed by reference.
         * @param int      $depth  Depth of menu item. Used for padding.
         * @param stdClass $args   Not used.
         */
        public function start_lvl(&$output, $depth = 0, $args = \null)
        {
        }
        /**
         * Ends the list of after the elements are added.
         *
         * @see Walker_Nav_Menu::end_lvl()
         *
         * @since 3.0.0
         *
         * @param string   $output Passed by reference.
         * @param int      $depth  Depth of menu item. Used for padding.
         * @param stdClass $args   Not used.
         */
        public function end_lvl(&$output, $depth = 0, $args = \null)
        {
        }
        /**
         * Start the element output.
         *
         * @see Walker_Nav_Menu::start_el()
         * @since 3.0.0
         * @since 5.9.0 Renamed `$item` to `$data_object` and `$id` to `$current_object_id`
         *              to match parent class for PHP 8 named parameter support.
         *
         * @global int $_wp_nav_menu_max_depth
         *
         * @param string   $output            Used to append additional content (passed by reference).
         * @param WP_Post  $data_object       Menu item data object.
         * @param int      $depth             Depth of menu item. Used for padding.
         * @param stdClass $args              Not used.
         * @param int      $current_object_id Optional. ID of the current menu item. Default 0.
         */
        public function start_el(&$output, $data_object, $depth = 0, $args = \null, $current_object_id = 0)
        {
        }
    }
    /**
     * Upgrader Skin for Ajax WordPress upgrades.
     *
     * This skin is designed to be used for Ajax updates.
     *
     * @since 4.6.0
     *
     * @see Automatic_Upgrader_Skin
     */
    class WP_Ajax_Upgrader_Skin extends \Automatic_Upgrader_Skin
    {
        /**
         * Plugin info.
         *
         * The Plugin_Upgrader::bulk_upgrade() method will fill this in
         * with info retrieved from the get_plugin_data() function.
         *
         * @var array Plugin data. Values will be empty if not supplied by the plugin.
         */
        public $plugin_info = array();
        /**
         * Theme info.
         *
         * The Theme_Upgrader::bulk_upgrade() method will fill this in
         * with info retrieved from the Theme_Upgrader::theme_info() method,
         * which in turn calls the wp_get_theme() function.
         *
         * @var WP_Theme|false The theme's info object, or false.
         */
        public $theme_info = \false;
        /**
         * Holds the WP_Error object.
         *
         * @since 4.6.0
         *
         * @var null|WP_Error
         */
        protected $errors = \null;
        /**
         * Constructor.
         *
         * Sets up the WordPress Ajax upgrader skin.
         *
         * @since 4.6.0
         *
         * @see WP_Upgrader_Skin::__construct()
         *
         * @param array $args Optional. The WordPress Ajax upgrader skin arguments to
         *                    override default options. See WP_Upgrader_Skin::__construct().
         *                    Default empty array.
         */
        public function __construct($args = array())
        {
        }
        /**
         * Retrieves the list of errors.
         *
         * @since 4.6.0
         *
         * @return WP_Error Errors during an upgrade.
         */
        public function get_errors()
        {
        }
        /**
         * Retrieves a string for error messages.
         *
         * @since 4.6.0
         *
         * @return string Error messages during an upgrade.
         */
        public function get_error_messages()
        {
        }
        /**
         * Stores an error message about the upgrade.
         *
         * @since 4.6.0
         * @since 5.3.0 Formalized the existing `...$args` parameter by adding it
         *              to the function signature.
         *
         * @param string|WP_Error $errors  Errors.
         * @param mixed           ...$args Optional text replacements.
         */
        public function error($errors, ...$args)
        {
        }
        /**
         * Stores a message about the upgrade.
         *
         * @since 4.6.0
         * @since 5.3.0 Formalized the existing `...$args` parameter by adding it
         *              to the function signature.
         * @since 5.9.0 Renamed `$data` to `$feedback` for PHP 8 named parameter support.
         *
         * @param string|array|WP_Error $feedback Message data.
         * @param mixed                 ...$args  Optional text replacements.
         */
        public function feedback($feedback, ...$args)
        {
        }
    }
    /**
     * Base class for displaying a list of items in an ajaxified HTML table.
     *
     * @since 3.1.0
     */
    #[\AllowDynamicProperties]
    class WP_List_Table
    {
        /**
         * The current list of items.
         *
         * @since 3.1.0
         * @var array
         */
        public $items;
        /**
         * Various information about the current table.
         *
         * @since 3.1.0
         * @var array
         */
        protected $_args;
        /**
         * Various information needed for displaying the pagination.
         *
         * @since 3.1.0
         * @var array
         */
        protected $_pagination_args = array();
        /**
         * The current screen.
         *
         * @since 3.1.0
         * @var WP_Screen
         */
        protected $screen;
        /**
         * The view switcher modes.
         *
         * @since 4.1.0
         * @var array
         */
        protected $modes = array();
        /**
         * Stores the value returned by ->get_column_info().
         *
         * @since 4.1.0
         * @var array
         */
        protected $_column_headers;
        /**
         * {@internal Missing Summary}
         *
         * @var array
         */
        protected $compat_fields = array('_args', '_pagination_args', 'screen', '_actions', '_pagination');
        /**
         * {@internal Missing Summary}
         *
         * @var array
         */
        protected $compat_methods = array('set_pagination_args', 'get_views', 'get_bulk_actions', 'bulk_actions', 'row_actions', 'months_dropdown', 'view_switcher', 'comments_bubble', 'get_items_per_page', 'pagination', 'get_sortable_columns', 'get_column_info', 'get_table_classes', 'display_tablenav', 'extra_tablenav', 'single_row_columns');
        /**
         * Constructor.
         *
         * The child class should call this constructor from its own constructor to override
         * the default $args.
         *
         * @since 3.1.0
         *
         * @param array|string $args {
         *     Array or string of arguments.
         *
         *     @type string $plural   Plural value used for labels and the objects being listed.
         *                            This affects things such as CSS class-names and nonces used
         *                            in the list table, e.g. 'posts'. Default empty.
         *     @type string $singular Singular label for an object being listed, e.g. 'post'.
         *                            Default empty
         *     @type bool   $ajax     Whether the list table supports Ajax. This includes loading
         *                            and sorting data, for example. If true, the class will call
         *                            the _js_vars() method in the footer to provide variables
         *                            to any scripts handling Ajax events. Default false.
         *     @type string $screen   String containing the hook name used to determine the current
         *                            screen. If left null, the current screen will be automatically set.
         *                            Default null.
         * }
         * @phpstan-param array{
         *   plural?: string,
         *   singular?: string,
         *   ajax?: bool,
         *   screen?: string,
         * } $args
         */
        public function __construct($args = array())
        {
        }
        /**
         * Makes private properties readable for backward compatibility.
         *
         * @since 4.0.0
         * @since 6.4.0 Getting a dynamic property is deprecated.
         *
         * @param string $name Property to get.
         * @return mixed Property.
         */
        public function __get($name)
        {
        }
        /**
         * Makes private properties settable for backward compatibility.
         *
         * @since 4.0.0
         * @since 6.4.0 Setting a dynamic property is deprecated.
         *
         * @param string $name  Property to check if set.
         * @param mixed  $value Property value.
         * @phpstan-return void
         */
        public function __set($name, $value)
        {
        }
        /**
         * Makes private properties checkable for backward compatibility.
         *
         * @since 4.0.0
         * @since 6.4.0 Checking a dynamic property is deprecated.
         *
         * @param string $name Property to check if set.
         * @return bool Whether the property is a back-compat property and it is set.
         */
        public function __isset($name)
        {
        }
        /**
         * Makes private properties un-settable for backward compatibility.
         *
         * @since 4.0.0
         * @since 6.4.0 Unsetting a dynamic property is deprecated.
         *
         * @param string $name Property to unset.
         * @phpstan-return void
         */
        public function __unset($name)
        {
        }
        /**
         * Makes private/protected methods readable for backward compatibility.
         *
         * @since 4.0.0
         *
         * @param string $name      Method to call.
         * @param array  $arguments Arguments to pass when calling.
         * @return mixed|bool Return value of the callback, false otherwise.
         */
        public function __call($name, $arguments)
        {
        }
        /**
         * Checks the current user's permissions
         *
         * @since 3.1.0
         * @abstract
         */
        public function ajax_user_can()
        {
        }
        /**
         * Prepares the list of items for displaying.
         *
         * @uses WP_List_Table::set_pagination_args()
         *
         * @since 3.1.0
         * @abstract
         */
        public function prepare_items()
        {
        }
        /**
         * Sets all the necessary pagination arguments.
         *
         * @since 3.1.0
         *
         * @param array|string $args Array or string of arguments with information about the pagination.
         * @phpstan-param array{total_items?: int, total_pages?: int, per_page?: int} $args
         * @phpstan-return void
         */
        protected function set_pagination_args($args)
        {
        }
        /**
         * Access the pagination args.
         *
         * @since 3.1.0
         *
         * @param string $key Pagination argument to retrieve. Common values include 'total_items',
         *                    'total_pages', 'per_page', or 'infinite_scroll'.
         * @return int Number of items that correspond to the given pagination argument.
         */
        public function get_pagination_arg($key)
        {
        }
        /**
         * Determines whether the table has items to display or not
         *
         * @since 3.1.0
         *
         * @return bool
         */
        public function has_items()
        {
        }
        /**
         * Message to be displayed when there are no items
         *
         * @since 3.1.0
         */
        public function no_items()
        {
        }
        /**
         * Displays the search box.
         *
         * @since 3.1.0
         *
         * @param string $text     The 'submit' button label.
         * @param string $input_id ID attribute value for the search input field.
         * @phpstan-return void
         */
        public function search_box($text, $input_id)
        {
        }
        /**
         * Generates views links.
         *
         * @since 6.1.0
         *
         * @param array $link_data {
         *     An array of link data.
         *
         *     @type string $url     The link URL.
         *     @type string $label   The link label.
         *     @type bool   $current Optional. Whether this is the currently selected view.
         * }
         * @return string[] An array of link markup. Keys match the `$link_data` input array.
         * @phpstan-param array{
         *   url?: string,
         *   label?: string,
         *   current?: bool,
         * } $link_data
         */
        protected function get_views_links($link_data = array())
        {
        }
        /**
         * Gets the list of views available on this table.
         *
         * The format is an associative array:
         * - `'id' => 'link'`
         *
         * @since 3.1.0
         *
         * @return array
         */
        protected function get_views()
        {
        }
        /**
         * Displays the list of views available on this table.
         *
         * @since 3.1.0
         * @phpstan-return void
         */
        public function views()
        {
        }
        /**
         * Retrieves the list of bulk actions available for this table.
         *
         * The format is an associative array where each element represents either a top level option value and label, or
         * an array representing an optgroup and its options.
         *
         * For a standard option, the array element key is the field value and the array element value is the field label.
         *
         * For an optgroup, the array element key is the label and the array element value is an associative array of
         * options as above.
         *
         * Example:
         *
         *     [
         *         'edit'         => 'Edit',
         *         'delete'       => 'Delete',
         *         'Change State' => [
         *             'feature' => 'Featured',
         *             'sale'    => 'On Sale',
         *         ]
         *     ]
         *
         * @since 3.1.0
         * @since 5.6.0 A bulk action can now contain an array of options in order to create an optgroup.
         *
         * @return array
         */
        protected function get_bulk_actions()
        {
        }
        /**
         * Displays the bulk actions dropdown.
         *
         * @since 3.1.0
         *
         * @param string $which The location of the bulk actions: Either 'top' or 'bottom'.
         *                      This is designated as optional for backward compatibility.
         * @phpstan-param 'top'|'bottom' $which
         * @phpstan-return void
         */
        protected function bulk_actions($which = '')
        {
        }
        /**
         * Gets the current action selected from the bulk actions dropdown.
         *
         * @since 3.1.0
         *
         * @return string|false The action name. False if no action was selected.
         */
        public function current_action()
        {
        }
        /**
         * Generates the required HTML for a list of row action links.
         *
         * @since 3.1.0
         *
         * @param string[] $actions        An array of action links.
         * @param bool     $always_visible Whether the actions should be always visible.
         * @return string The HTML for the row actions.
         */
        protected function row_actions($actions, $always_visible = \false)
        {
        }
        /**
         * Displays a dropdown for filtering items in the list table by month.
         *
         * @since 3.1.0
         *
         * @global wpdb      $wpdb      WordPress database abstraction object.
         * @global WP_Locale $wp_locale WordPress date and time locale object.
         *
         * @param string $post_type The post type.
         * @phpstan-return void
         */
        protected function months_dropdown($post_type)
        {
        }
        /**
         * Displays a view switcher.
         *
         * @since 3.1.0
         *
         * @param string $current_mode
         */
        protected function view_switcher($current_mode)
        {
        }
        /**
         * Displays a comment count bubble.
         *
         * @since 3.1.0
         *
         * @param int $post_id          The post ID.
         * @param int $pending_comments Number of pending comments.
         */
        protected function comments_bubble($post_id, $pending_comments)
        {
        }
        /**
         * Gets the current page number.
         *
         * @since 3.1.0
         *
         * @return int
         */
        public function get_pagenum()
        {
        }
        /**
         * Gets the number of items to display on a single page.
         *
         * @since 3.1.0
         *
         * @param string $option        User option name.
         * @param int    $default_value Optional. The number of items to display. Default 20.
         * @return int
         */
        protected function get_items_per_page($option, $default_value = 20)
        {
        }
        /**
         * Displays the pagination.
         *
         * @since 3.1.0
         *
         * @param string $which The location of the pagination: Either 'top' or 'bottom'.
         * @phpstan-param 'top'|'bottom' $which
         * @phpstan-return void
         */
        protected function pagination($which)
        {
        }
        /**
         * Gets a list of columns.
         *
         * The format is:
         * - `'internal-name' => 'Title'`
         *
         * @since 3.1.0
         * @abstract
         *
         * @return array
         */
        public function get_columns()
        {
        }
        /**
         * Gets a list of sortable columns.
         *
         * The format is:
         * - `'internal-name' => 'orderby'`
         * - `'internal-name' => array( 'orderby', bool, 'abbr', 'orderby-text', 'initially-sorted-column-order' )` -
         * - `'internal-name' => array( 'orderby', 'asc' )` - The second element sets the initial sorting order.
         * - `'internal-name' => array( 'orderby', true )`  - The second element makes the initial order descending.
         *
         * In the second format, passing true as second parameter will make the initial
         * sorting order be descending. Following parameters add a short column name to
         * be used as 'abbr' attribute, a translatable string for the current sorting,
         * and the initial order for the initial sorted column, 'asc' or 'desc' (default: false).
         *
         * @since 3.1.0
         * @since 6.3.0 Added 'abbr', 'orderby-text' and 'initially-sorted-column-order'.
         *
         * @return array
         */
        protected function get_sortable_columns()
        {
        }
        /**
         * Gets the name of the default primary column.
         *
         * @since 4.3.0
         *
         * @return string Name of the default primary column, in this case, an empty string.
         */
        protected function get_default_primary_column_name()
        {
        }
        /**
         * Gets the name of the primary column.
         *
         * Public wrapper for WP_List_Table::get_default_primary_column_name().
         *
         * @since 4.4.0
         *
         * @return string Name of the default primary column.
         */
        public function get_primary_column()
        {
        }
        /**
         * Gets the name of the primary column.
         *
         * @since 4.3.0
         *
         * @return string The name of the primary column.
         */
        protected function get_primary_column_name()
        {
        }
        /**
         * Gets a list of all, hidden, and sortable columns, with filter applied.
         *
         * @since 3.1.0
         *
         * @return array
         */
        protected function get_column_info()
        {
        }
        /**
         * Returns the number of visible columns.
         *
         * @since 3.1.0
         *
         * @return int
         */
        public function get_column_count()
        {
        }
        /**
         * Prints column headers, accounting for hidden and sortable columns.
         *
         * @since 3.1.0
         *
         * @param bool $with_id Whether to set the ID attribute or not
         */
        public function print_column_headers($with_id = \true)
        {
        }
        /**
         * Print a table description with information about current sorting and order.
         *
         * For the table initial view, information about initial orderby and order
         * should be provided via get_sortable_columns().
         *
         * @since 6.3.0
         * @access public
         * @phpstan-return void
         */
        public function print_table_description()
        {
        }
        /**
         * Displays the table.
         *
         * @since 3.1.0
         */
        public function display()
        {
        }
        /**
         * Gets a list of CSS classes for the WP_List_Table table tag.
         *
         * @since 3.1.0
         *
         * @return string[] Array of CSS classes for the table tag.
         */
        protected function get_table_classes()
        {
        }
        /**
         * Generates the table navigation above or below the table
         *
         * @since 3.1.0
         * @param string $which The location of the navigation: Either 'top' or 'bottom'.
         * @phpstan-param 'top'|'bottom' $which
         */
        protected function display_tablenav($which)
        {
        }
        /**
         * Displays extra controls between bulk actions and pagination.
         *
         * @since 3.1.0
         *
         * @param string $which
         */
        protected function extra_tablenav($which)
        {
        }
        /**
         * Generates the tbody element for the list table.
         *
         * @since 3.1.0
         */
        public function display_rows_or_placeholder()
        {
        }
        /**
         * Generates the list table rows.
         *
         * @since 3.1.0
         */
        public function display_rows()
        {
        }
        /**
         * Generates content for a single row of the table.
         *
         * @since 3.1.0
         *
         * @param object|array $item The current item
         */
        public function single_row($item)
        {
        }
        /**
         * @param object|array $item
         * @param string $column_name
         */
        protected function column_default($item, $column_name)
        {
        }
        /**
         * @param object|array $item
         */
        protected function column_cb($item)
        {
        }
        /**
         * Generates the columns for a single row of the table.
         *
         * @since 3.1.0
         *
         * @param object|array $item The current item.
         */
        protected function single_row_columns($item)
        {
        }
        /**
         * Generates and display row actions links for the list table.
         *
         * @since 4.3.0
         *
         * @param object|array $item        The item being acted upon.
         * @param string       $column_name Current column name.
         * @param string       $primary     Primary column name.
         * @return string The row actions HTML, or an empty string
         *                if the current column is not the primary column.
         */
        protected function handle_row_actions($item, $column_name, $primary)
        {
        }
        /**
         * Handles an incoming ajax request (called from admin-ajax.php)
         *
         * @since 3.1.0
         * @phpstan-return never
         */
        public function ajax_response()
        {
        }
        /**
         * Sends required variables to JavaScript land.
         *
         * @since 3.1.0
         */
        public function _js_vars()
        {
        }
    }
    /**
     * Class for displaying the list of application password items.
     *
     * @since 5.6.0
     *
     * @see WP_List_Table
     */
    class WP_Application_Passwords_List_Table extends \WP_List_Table
    {
        /**
         * Gets the list of columns.
         *
         * @since 5.6.0
         *
         * @return string[] Array of column titles keyed by their column name.
         */
        public function get_columns()
        {
        }
        /**
         * Prepares the list of items for displaying.
         *
         * @since 5.6.0
         *
         * @global int $user_id User ID.
         */
        public function prepare_items()
        {
        }
        /**
         * Handles the name column output.
         *
         * @since 5.6.0
         *
         * @param array $item The current application password item.
         */
        public function column_name($item)
        {
        }
        /**
         * Handles the created column output.
         *
         * @since 5.6.0
         *
         * @param array $item The current application password item.
         */
        public function column_created($item)
        {
        }
        /**
         * Handles the last used column output.
         *
         * @since 5.6.0
         *
         * @param array $item The current application password item.
         */
        public function column_last_used($item)
        {
        }
        /**
         * Handles the last ip column output.
         *
         * @since 5.6.0
         *
         * @param array $item The current application password item.
         */
        public function column_last_ip($item)
        {
        }
        /**
         * Handles the revoke column output.
         *
         * @since 5.6.0
         *
         * @param array $item The current application password item.
         */
        public function column_revoke($item)
        {
        }
        /**
         * Generates content for a single row of the table
         *
         * @since 5.6.0
         *
         * @param array  $item        The current item.
         * @param string $column_name The current column name.
         */
        protected function column_default($item, $column_name)
        {
        }
        /**
         * Generates custom table navigation to prevent conflicting nonces.
         *
         * @since 5.6.0
         *
         * @param string $which The location of the bulk actions: Either 'top' or 'bottom'.
         * @phpstan-param 'top'|'bottom' $which
         */
        protected function display_tablenav($which)
        {
        }
        /**
         * Generates content for a single row of the table.
         *
         * @since 5.6.0
         *
         * @param array $item The current item.
         */
        public function single_row($item)
        {
        }
        /**
         * Gets the name of the default primary column.
         *
         * @since 5.6.0
         *
         * @return string Name of the default primary column, in this case, 'name'.
         */
        protected function get_default_primary_column_name()
        {
        }
        /**
         * Prints the JavaScript template for the new row item.
         *
         * @since 5.6.0
         */
        public function print_js_template_row()
        {
        }
    }
    /**
     * Core class used for handling automatic background updates.
     *
     * @since 3.7.0
     * @since 4.6.0 Moved to its own file from wp-admin/includes/class-wp-upgrader.php.
     */
    #[\AllowDynamicProperties]
    class WP_Automatic_Updater
    {
        /**
         * Tracks update results during processing.
         *
         * @var array
         */
        protected $update_results = array();
        /**
         * Determines whether the entire automatic updater is disabled.
         *
         * @since 3.7.0
         *
         * @return bool True if the automatic updater is disabled, false otherwise.
         */
        public function is_disabled()
        {
        }
        /**
         * Checks whether access to a given directory is allowed.
         *
         * This is used when detecting version control checkouts. Takes into account
         * the PHP `open_basedir` restrictions, so that WordPress does not try to access
         * directories it is not allowed to.
         *
         * @since 6.2.0
         *
         * @param string $dir The directory to check.
         * @return bool True if access to the directory is allowed, false otherwise.
         */
        public function is_allowed_dir($dir)
        {
        }
        /**
         * Checks for version control checkouts.
         *
         * Checks for Subversion, Git, Mercurial, and Bazaar. It recursively looks up the
         * filesystem to the top of the drive, erring on the side of detecting a VCS
         * checkout somewhere.
         *
         * ABSPATH is always checked in addition to whatever `$context` is (which may be the
         * wp-content directory, for example). The underlying assumption is that if you are
         * using version control *anywhere*, then you should be making decisions for
         * how things get updated.
         *
         * @since 3.7.0
         *
         * @param string $context The filesystem path to check, in addition to ABSPATH.
         * @return bool True if a VCS checkout was discovered at `$context` or ABSPATH,
         *              or anywhere higher. False otherwise.
         */
        public function is_vcs_checkout($context)
        {
        }
        /**
         * Tests to see if we can and should update a specific item.
         *
         * @since 3.7.0
         *
         * @global wpdb $wpdb WordPress database abstraction object.
         *
         * @param string $type    The type of update being checked: 'core', 'theme',
         *                        'plugin', 'translation'.
         * @param object $item    The update offer.
         * @param string $context The filesystem context (a path) against which filesystem
         *                        access and status should be checked.
         * @return bool True if the item should be updated, false otherwise.
         */
        public function should_update($type, $item, $context)
        {
        }
        /**
         * Notifies an administrator of a core update.
         *
         * @since 3.7.0
         *
         * @param object $item The update offer.
         * @return bool True if the site administrator is notified of a core update,
         *              false otherwise.
         */
        protected function send_core_update_notification_email($item)
        {
        }
        /**
         * Updates an item, if appropriate.
         *
         * @since 3.7.0
         *
         * @param string $type The type of update being checked: 'core', 'theme', 'plugin', 'translation'.
         * @param object $item The update offer.
         * @return null|WP_Error
         */
        public function update($type, $item)
        {
        }
        /**
         * Kicks off the background update process, looping through all pending updates.
         *
         * @since 3.7.0
         * @phpstan-return void
         */
        public function run()
        {
        }
        /**
         * Checks whether to send an email and avoid processing future updates after
         * attempting a core update.
         *
         * @since 3.7.0
         *
         * @param object $update_result The result of the core update. Includes the update offer and result.
         * @phpstan-return void
         */
        protected function after_core_update($update_result)
        {
        }
        /**
         * Sends an email upon the completion or failure of a background core update.
         *
         * @since 3.7.0
         *
         * @param string $type        The type of email to send. Can be one of 'success', 'fail', 'manual', 'critical'.
         * @param object $core_update The update offer that was attempted.
         * @param mixed  $result      Optional. The result for the core update. Can be WP_Error.
         * @phpstan-return void
         */
        protected function send_email($type, $core_update, $result = \null)
        {
        }
        /**
         * Checks whether an email should be sent after attempting plugin or theme updates.
         *
         * @since 5.5.0
         *
         * @param array $update_results The results of update tasks.
         * @phpstan-return void
         */
        protected function after_plugin_theme_update($update_results)
        {
        }
        /**
         * Sends an email upon the completion or failure of a plugin or theme background update.
         *
         * @since 5.5.0
         *
         * @param string $type               The type of email to send. Can be one of 'success', 'fail', 'mixed'.
         * @param array  $successful_updates A list of updates that succeeded.
         * @param array  $failed_updates     A list of updates that failed.
         * @phpstan-return void
         */
        protected function send_plugin_theme_email($type, $successful_updates, $failed_updates)
        {
        }
        /**
         * Prepares and sends an email of a full log of background update results, useful for debugging and geekery.
         *
         * @since 3.7.0
         */
        protected function send_debug_email()
        {
        }
        /**
         * Performs a loopback request to check for potential fatal errors.
         *
         * Fatal errors cannot be detected unless maintenance mode is enabled.
         *
         * @since 6.6.0
         *
         * @global int $upgrading The Unix timestamp marking when upgrading WordPress began.
         *
         * @return bool Whether a fatal error was detected.
         */
        protected function has_fatal_error()
        {
        }
    }
    /**
     * Core class used to implement displaying comments in a list table.
     *
     * @since 3.1.0
     *
     * @see WP_List_Table
     */
    class WP_Comments_List_Table extends \WP_List_Table
    {
        public $checkbox = \true;
        public $pending_count = array();
        public $extra_items;
        /**
         * Constructor.
         *
         * @since 3.1.0
         *
         * @see WP_List_Table::__construct() for more information on default arguments.
         *
         * @global int $post_id
         *
         * @param array $args An associative array of arguments.
         */
        public function __construct($args = array())
        {
        }
        /**
         * Adds avatars to comment author names.
         *
         * @since 3.1.0
         *
         * @param string $name       Comment author name.
         * @param int    $comment_id Comment ID.
         * @return string Avatar with the user name.
         */
        public function floated_admin_avatar($name, $comment_id)
        {
        }
        /**
         * @return bool
         */
        public function ajax_user_can()
        {
        }
        /**
         * @global string $mode           List table view mode.
         * @global int    $post_id
         * @global string $comment_status
         * @global string $comment_type
         * @global string $search
         */
        public function prepare_items()
        {
        }
        /**
         * @param string $comment_status
         * @return int
         */
        public function get_per_page($comment_status = 'all')
        {
        }
        /**
         * @global string $comment_status
         */
        public function no_items()
        {
        }
        /**
         * @global int $post_id
         * @global string $comment_status
         * @global string $comment_type
         */
        protected function get_views()
        {
        }
        /**
         * @global string $comment_status
         *
         * @return array
         */
        protected function get_bulk_actions()
        {
        }
        /**
         * @global string $comment_status
         * @global string $comment_type
         *
         * @param string $which
         */
        protected function extra_tablenav($which)
        {
        }
        /**
         * @return string|false
         */
        public function current_action()
        {
        }
        /**
         * @global int $post_id
         *
         * @return string[] Array of column titles keyed by their column name.
         */
        public function get_columns()
        {
        }
        /**
         * Displays a comment type drop-down for filtering on the Comments list table.
         *
         * @since 5.5.0
         * @since 5.6.0 Renamed from `comment_status_dropdown()` to `comment_type_dropdown()`.
         *
         * @param string $comment_type The current comment type slug.
         */
        protected function comment_type_dropdown($comment_type)
        {
        }
        /**
         * @return array
         */
        protected function get_sortable_columns()
        {
        }
        /**
         * Gets the name of the default primary column.
         *
         * @since 4.3.0
         *
         * @return string Name of the default primary column, in this case, 'comment'.
         */
        protected function get_default_primary_column_name()
        {
        }
        /**
         * Displays the comments table.
         *
         * Overrides the parent display() method to render extra comments.
         *
         * @since 3.1.0
         */
        public function display()
        {
        }
        /**
         * @global WP_Post    $post    Global post object.
         * @global WP_Comment $comment Global comment object.
         *
         * @param WP_Comment $item
         */
        public function single_row($item)
        {
        }
        /**
         * Generates and displays row actions links.
         *
         * @since 4.3.0
         * @since 5.9.0 Renamed `$comment` to `$item` to match parent class for PHP 8 named parameter support.
         *
         * @global string $comment_status Status for the current listed comments.
         *
         * @param WP_Comment $item        The comment object.
         * @param string     $column_name Current column name.
         * @param string     $primary     Primary column name.
         * @return string Row actions output for comments. An empty string
         *                if the current column is not the primary column,
         *                or if the current user cannot edit the comment.
         */
        protected function handle_row_actions($item, $column_name, $primary)
        {
        }
        /**
         * @since 5.9.0 Renamed `$comment` to `$item` to match parent class for PHP 8 named parameter support.
         *
         * @param WP_Comment $item The comment object.
         */
        public function column_cb($item)
        {
        }
        /**
         * @param WP_Comment $comment The comment object.
         */
        public function column_comment($comment)
        {
        }
        /**
         * @global string $comment_status
         *
         * @param WP_Comment $comment The comment object.
         */
        public function column_author($comment)
        {
        }
        /**
         * @param WP_Comment $comment The comment object.
         */
        public function column_date($comment)
        {
        }
        /**
         * @param WP_Comment $comment The comment object.
         * @phpstan-return void
         */
        public function column_response($comment)
        {
        }
        /**
         * @since 5.9.0 Renamed `$comment` to `$item` to match parent class for PHP 8 named parameter support.
         *
         * @param WP_Comment $item        The comment object.
         * @param string     $column_name The custom column's name.
         */
        public function column_default($item, $column_name)
        {
        }
    }
    /**
     * Class WP_Community_Events.
     *
     * A client for api.wordpress.org/events.
     *
     * @since 4.8.0
     */
    #[\AllowDynamicProperties]
    class WP_Community_Events
    {
        /**
         * ID for a WordPress user account.
         *
         * @since 4.8.0
         *
         * @var int
         */
        protected $user_id = 0;
        /**
         * Stores location data for the user.
         *
         * @since 4.8.0
         *
         * @var false|array
         */
        protected $user_location = \false;
        /**
         * Constructor for WP_Community_Events.
         *
         * @since 4.8.0
         *
         * @param int        $user_id       WP user ID.
         * @param false|array $user_location {
         *     Stored location data for the user. false to pass no location.
         *
         *     @type string $description The name of the location
         *     @type string $latitude    The latitude in decimal degrees notation, without the degree
         *                               symbol. e.g.: 47.615200.
         *     @type string $longitude   The longitude in decimal degrees notation, without the degree
         *                               symbol. e.g.: -122.341100.
         *     @type string $country     The ISO 3166-1 alpha-2 country code. e.g.: BR
         * }
         * @phpstan-param false|array{
         *   description?: string,
         *   latitude?: string,
         *   longitude?: string,
         *   country?: string,
         * } $user_location
         */
        public function __construct($user_id, $user_location = \false)
        {
        }
        /**
         * Gets data about events near a particular location.
         *
         * Cached events will be immediately returned if the `user_location` property
         * is set for the current user, and cached events exist for that location.
         *
         * Otherwise, this method sends a request to the w.org Events API with location
         * data. The API will send back a recognized location based on the data, along
         * with nearby events.
         *
         * The browser's request for events is proxied with this method, rather
         * than having the browser make the request directly to api.wordpress.org,
         * because it allows results to be cached server-side and shared with other
         * users and sites in the network. This makes the process more efficient,
         * since increasing the number of visits that get cached data means users
         * don't have to wait as often; if the user's browser made the request
         * directly, it would also need to make a second request to WP in order to
         * pass the data for caching. Having WP make the request also introduces
         * the opportunity to anonymize the IP before sending it to w.org, which
         * mitigates possible privacy concerns.
         *
         * @since 4.8.0
         * @since 5.5.2 Response no longer contains formatted date field. They're added
         *              in `wp.communityEvents.populateDynamicEventFields()` now.
         *
         * @param string $location_search Optional. City name to help determine the location.
         *                                e.g., "Seattle". Default empty string.
         * @param string $timezone        Optional. Timezone to help determine the location.
         *                                Default empty string.
         * @return array|WP_Error A WP_Error on failure; an array with location and events on
         *                        success.
         */
        public function get_events($location_search = '', $timezone = '')
        {
        }
        /**
         * Builds an array of args to use in an HTTP request to the w.org Events API.
         *
         * @since 4.8.0
         *
         * @param string $search   Optional. City search string. Default empty string.
         * @param string $timezone Optional. Timezone string. Default empty string.
         * @return array The request args.
         */
        protected function get_request_args($search = '', $timezone = '')
        {
        }
        /**
         * Determines the user's actual IP address and attempts to partially
         * anonymize an IP address by converting it to a network ID.
         *
         * Geolocating the network ID usually returns a similar location as the
         * actual IP, but provides some privacy for the user.
         *
         * $_SERVER['REMOTE_ADDR'] cannot be used in all cases, such as when the user
         * is making their request through a proxy, or when the web server is behind
         * a proxy. In those cases, $_SERVER['REMOTE_ADDR'] is set to the proxy address rather
         * than the user's actual address.
         *
         * Modified from https://stackoverflow.com/a/2031935/450127, MIT license.
         * Modified from https://github.com/geertw/php-ip-anonymizer, MIT license.
         *
         * SECURITY WARNING: This function is _NOT_ intended to be used in
         * circumstances where the authenticity of the IP address matters. This does
         * _NOT_ guarantee that the returned address is valid or accurate, and it can
         * be easily spoofed.
         *
         * @since 4.8.0
         *
         * @return string|false The anonymized address on success; the given address
         *                      or false on failure.
         */
        public static function get_unsafe_client_ip()
        {
        }
        /**
         * Test if two pairs of latitude/longitude coordinates match each other.
         *
         * @since 4.8.0
         *
         * @param array $a The first pair, with indexes 'latitude' and 'longitude'.
         * @param array $b The second pair, with indexes 'latitude' and 'longitude'.
         * @return bool True if they match, false if they don't.
         */
        protected function coordinates_match($a, $b)
        {
        }
        /**
         * Generates a transient key based on user location.
         *
         * This could be reduced to a one-liner in the calling functions, but it's
         * intentionally a separate function because it's called from multiple
         * functions, and having it abstracted keeps the logic consistent and DRY,
         * which is less prone to errors.
         *
         * @since 4.8.0
         *
         * @param array $location Should contain 'latitude' and 'longitude' indexes.
         * @return string|false Transient key on success, false on failure.
         */
        protected function get_events_transient_key($location)
        {
        }
        /**
         * Caches an array of events data from the Events API.
         *
         * @since 4.8.0
         *
         * @param array     $events     Response body from the API request.
         * @param int|false $expiration Optional. Amount of time to cache the events. Defaults to false.
         * @return bool true if events were cached; false if not.
         */
        protected function cache_events($events, $expiration = \false)
        {
        }
        /**
         * Gets cached events.
         *
         * @since 4.8.0
         * @since 5.5.2 Response no longer contains formatted date field. They're added
         *              in `wp.communityEvents.populateDynamicEventFields()` now.
         *
         * @return array|false An array containing `location` and `events` items
         *                     on success, false on failure.
         */
        public function get_cached_events()
        {
        }
        /**
         * Adds formatted date and time items for each event in an API response.
         *
         * This has to be called after the data is pulled from the cache, because
         * the cached events are shared by all users. If it was called before storing
         * the cache, then all users would see the events in the localized data/time
         * of the user who triggered the cache refresh, rather than their own.
         *
         * @since 4.8.0
         * @deprecated 5.6.0 No longer used in core.
         *
         * @param array $response_body The response which contains the events.
         * @return array The response with dates and times formatted.
         */
        protected function format_event_data_time($response_body)
        {
        }
        /**
         * Prepares the event list for presentation.
         *
         * Discards expired events, and makes WordCamps "sticky." Attendees need more
         * advanced notice about WordCamps than they do for meetups, so camps should
         * appear in the list sooner. If a WordCamp is coming up, the API will "stick"
         * it in the response, even if it wouldn't otherwise appear. When that happens,
         * the event will be at the end of the list, and will need to be moved into a
         * higher position, so that it doesn't get trimmed off.
         *
         * @since 4.8.0
         * @since 4.9.7 Stick a WordCamp to the final list.
         * @since 5.5.2 Accepts and returns only the events, rather than an entire HTTP response.
         * @since 6.0.0 Decode HTML entities from the event title.
         *
         * @param array $events The events that will be prepared.
         * @return array The response body with events trimmed.
         */
        protected function trim_events(array $events)
        {
        }
        /**
         * Logs responses to Events API requests.
         *
         * @since 4.8.0
         * @deprecated 4.9.0 Use a plugin instead. See #41217 for an example.
         *
         * @param string $message A description of what occurred.
         * @param array  $details Details that provide more context for the
         *                        log entry.
         * @phpstan-return void
         */
        protected function maybe_log_events_response($message, $details)
        {
        }
    }
    /**
     * Class for providing debug data based on a users WordPress environment.
     *
     * @package WordPress
     * @subpackage Site_Health
     * @since 5.2.0
     */
    #[\AllowDynamicProperties]
    class WP_Debug_Data
    {
        /**
         * Calls all core functions to check for updates.
         *
         * @since 5.2.0
         */
        public static function check_for_updates()
        {
        }
        /**
         * Static function for generating site debug data when required.
         *
         * @since 5.2.0
         * @since 5.3.0 Added database charset, database collation,
         *              and timezone information.
         * @since 5.5.0 Added pretty permalinks support information.
         * @since 6.7.0 Modularized into separate theme-oriented methods.
         *
         * @throws ImagickException
         *
         * @return array The debug data for the site.
         */
        public static function debug_data()
        {
        }
        /**
         * Returns the value of a MySQL system variable.
         *
         * @since 5.9.0
         *
         * @global wpdb $wpdb WordPress database abstraction object.
         *
         * @param string $mysql_var Name of the MySQL system variable.
         * @return string|null The variable value on success. Null if the variable does not exist.
         */
        public static function get_mysql_var($mysql_var)
        {
        }
        /**
         * Formats the information gathered for debugging, in a manner suitable for copying to a forum or support ticket.
         *
         * @since 5.2.0
         *
         * @param array  $info_array Information gathered from the `WP_Debug_Data::debug_data()` function.
         * @param string $data_type  The data type to return, either 'info' or 'debug'.
         * @return string The formatted data.
         * @phpstan-param 'info'|'debug' $data_type
         */
        public static function format($info_array, $data_type)
        {
        }
        /**
         * Fetches the total size of all the database tables for the active database user.
         *
         * @since 5.2.0
         *
         * @global wpdb $wpdb WordPress database abstraction object.
         *
         * @return int The size of the database, in bytes.
         */
        public static function get_database_size()
        {
        }
        /**
         * Fetches the sizes of the WordPress directories: `wordpress` (ABSPATH), `plugins`, `themes`, and `uploads`.
         * Intended to supplement the array returned by `WP_Debug_Data::debug_data()`.
         *
         * @since 5.2.0
         *
         * @return array The sizes of the directories, also the database size and total installation size.
         */
        public static function get_sizes()
        {
        }
    }
    /**
     * Base WordPress Filesystem class which Filesystem implementations extend.
     *
     * @since 2.5.0
     */
    #[\AllowDynamicProperties]
    class WP_Filesystem_Base
    {
        /**
         * Whether to display debug data for the connection.
         *
         * @since 2.5.0
         * @var bool
         */
        public $verbose = \false;
        /**
         * Cached list of local filepaths to mapped remote filepaths.
         *
         * @since 2.7.0
         * @var array
         */
        public $cache = array();
        /**
         * The Access method of the current connection, Set automatically.
         *
         * @since 2.5.0
         * @var string
         */
        public $method = '';
        /**
         * @var WP_Error
         */
        public $errors = \null;
        /**
         */
        public $options = array();
        /**
         * Returns the path on the remote filesystem of ABSPATH.
         *
         * @since 2.7.0
         *
         * @return string The location of the remote path.
         */
        public function abspath()
        {
        }
        /**
         * Returns the path on the remote filesystem of WP_CONTENT_DIR.
         *
         * @since 2.7.0
         *
         * @return string The location of the remote path.
         */
        public function wp_content_dir()
        {
        }
        /**
         * Returns the path on the remote filesystem of WP_PLUGIN_DIR.
         *
         * @since 2.7.0
         *
         * @return string The location of the remote path.
         */
        public function wp_plugins_dir()
        {
        }
        /**
         * Returns the path on the remote filesystem of the Themes Directory.
         *
         * @since 2.7.0
         *
         * @param string|false $theme Optional. The theme stylesheet or template for the directory.
         *                            Default false.
         * @return string The location of the remote path.
         */
        public function wp_themes_dir($theme = \false)
        {
        }
        /**
         * Returns the path on the remote filesystem of WP_LANG_DIR.
         *
         * @since 3.2.0
         *
         * @return string The location of the remote path.
         */
        public function wp_lang_dir()
        {
        }
        /**
         * Locates a folder on the remote filesystem.
         *
         * @since 2.5.0
         * @deprecated 2.7.0 use WP_Filesystem_Base::abspath() or WP_Filesystem_Base::wp_*_dir() instead.
         * @see WP_Filesystem_Base::abspath()
         * @see WP_Filesystem_Base::wp_content_dir()
         * @see WP_Filesystem_Base::wp_plugins_dir()
         * @see WP_Filesystem_Base::wp_themes_dir()
         * @see WP_Filesystem_Base::wp_lang_dir()
         *
         * @param string $base    Optional. The folder to start searching from. Default '.'.
         * @param bool   $verbose Optional. True to display debug information. Default false.
         * @return string The location of the remote path.
         */
        public function find_base_dir($base = '.', $verbose = \false)
        {
        }
        /**
         * Locates a folder on the remote filesystem.
         *
         * @since 2.5.0
         * @deprecated 2.7.0 use WP_Filesystem_Base::abspath() or WP_Filesystem_Base::wp_*_dir() methods instead.
         * @see WP_Filesystem_Base::abspath()
         * @see WP_Filesystem_Base::wp_content_dir()
         * @see WP_Filesystem_Base::wp_plugins_dir()
         * @see WP_Filesystem_Base::wp_themes_dir()
         * @see WP_Filesystem_Base::wp_lang_dir()
         *
         * @param string $base    Optional. The folder to start searching from. Default '.'.
         * @param bool   $verbose Optional. True to display debug information. Default false.
         * @return string The location of the remote path.
         */
        public function get_base_dir($base = '.', $verbose = \false)
        {
        }
        /**
         * Locates a folder on the remote filesystem.
         *
         * Assumes that on Windows systems, Stripping off the Drive
         * letter is OK Sanitizes \\ to / in Windows filepaths.
         *
         * @since 2.7.0
         *
         * @param string $folder the folder to locate.
         * @return string|false The location of the remote path, false on failure.
         */
        public function find_folder($folder)
        {
        }
        /**
         * Locates a folder on the remote filesystem.
         *
         * Expects Windows sanitized path.
         *
         * @since 2.7.0
         *
         * @param string $folder The folder to locate.
         * @param string $base   The folder to start searching from.
         * @param bool   $loop   If the function has recursed. Internal use only.
         * @return string|false The location of the remote path, false to cease looping.
         */
        public function search_for_folder($folder, $base = '.', $loop = \false)
        {
        }
        /**
         * Returns the *nix-style file permissions for a file.
         *
         * From the PHP documentation page for fileperms().
         *
         * @link https://www.php.net/manual/en/function.fileperms.php
         *
         * @since 2.5.0
         *
         * @param string $file String filename.
         * @return string The *nix-style representation of permissions.
         */
        public function gethchmod($file)
        {
        }
        /**
         * Gets the permissions of the specified file or filepath in their octal format.
         *
         * @since 2.5.0
         *
         * @param string $file Path to the file.
         * @return string Mode of the file (the last 3 digits).
         */
        public function getchmod($file)
        {
        }
        /**
         * Converts *nix-style file permissions to an octal number.
         *
         * Converts '-rw-r--r--' to 0644
         * From "info at rvgate dot nl"'s comment on the PHP documentation for chmod()
         *
         * @link https://www.php.net/manual/en/function.chmod.php#49614
         *
         * @since 2.5.0
         *
         * @param string $mode string The *nix-style file permissions.
         * @return string Octal representation of permissions.
         */
        public function getnumchmodfromh($mode)
        {
        }
        /**
         * Determines if the string provided contains binary characters.
         *
         * @since 2.7.0
         *
         * @param string $text String to test against.
         * @return bool True if string is binary, false otherwise.
         */
        public function is_binary($text)
        {
        }
        /**
         * Changes the owner of a file or directory.
         *
         * Default behavior is to do nothing, override this in your subclass, if desired.
         *
         * @since 2.5.0
         *
         * @param string     $file      Path to the file or directory.
         * @param string|int $owner     A user name or number.
         * @param bool       $recursive Optional. If set to true, changes file owner recursively.
         *                              Default false.
         * @return bool True on success, false on failure.
         */
        public function chown($file, $owner, $recursive = \false)
        {
        }
        /**
         * Connects filesystem.
         *
         * @since 2.5.0
         * @abstract
         *
         * @return bool True on success, false on failure (always true for WP_Filesystem_Direct).
         */
        public function connect()
        {
        }
        /**
         * Reads entire file into a string.
         *
         * @since 2.5.0
         * @abstract
         *
         * @param string $file Name of the file to read.
         * @return string|false Read data on success, false on failure.
         */
        public function get_contents($file)
        {
        }
        /**
         * Reads entire file into an array.
         *
         * @since 2.5.0
         * @abstract
         *
         * @param string $file Path to the file.
         * @return array|false File contents in an array on success, false on failure.
         */
        public function get_contents_array($file)
        {
        }
        /**
         * Writes a string to a file.
         *
         * @since 2.5.0
         * @abstract
         *
         * @param string    $file     Remote path to the file where to write the data.
         * @param string    $contents The data to write.
         * @param int|false $mode     Optional. The file permissions as octal number, usually 0644.
         *                            Default false.
         * @return bool True on success, false on failure.
         */
        public function put_contents($file, $contents, $mode = \false)
        {
        }
        /**
         * Gets the current working directory.
         *
         * @since 2.5.0
         * @abstract
         *
         * @return string|false The current working directory on success, false on failure.
         */
        public function cwd()
        {
        }
        /**
         * Changes current directory.
         *
         * @since 2.5.0
         * @abstract
         *
         * @param string $dir The new current directory.
         * @return bool True on success, false on failure.
         */
        public function chdir($dir)
        {
        }
        /**
         * Changes the file group.
         *
         * @since 2.5.0
         * @abstract
         *
         * @param string     $file      Path to the file.
         * @param string|int $group     A group name or number.
         * @param bool       $recursive Optional. If set to true, changes file group recursively.
         *                              Default false.
         * @return bool True on success, false on failure.
         */
        public function chgrp($file, $group, $recursive = \false)
        {
        }
        /**
         * Changes filesystem permissions.
         *
         * @since 2.5.0
         * @abstract
         *
         * @param string    $file      Path to the file.
         * @param int|false $mode      Optional. The permissions as octal number, usually 0644 for files,
         *                             0755 for directories. Default false.
         * @param bool      $recursive Optional. If set to true, changes file permissions recursively.
         *                             Default false.
         * @return bool True on success, false on failure.
         */
        public function chmod($file, $mode = \false, $recursive = \false)
        {
        }
        /**
         * Gets the file owner.
         *
         * @since 2.5.0
         * @abstract
         *
         * @param string $file Path to the file.
         * @return string|false Username of the owner on success, false on failure.
         */
        public function owner($file)
        {
        }
        /**
         * Gets the file's group.
         *
         * @since 2.5.0
         * @abstract
         *
         * @param string $file Path to the file.
         * @return string|false The group on success, false on failure.
         */
        public function group($file)
        {
        }
        /**
         * Copies a file.
         *
         * @since 2.5.0
         * @abstract
         *
         * @param string    $source      Path to the source file.
         * @param string    $destination Path to the destination file.
         * @param bool      $overwrite   Optional. Whether to overwrite the destination file if it exists.
         *                               Default false.
         * @param int|false $mode        Optional. The permissions as octal number, usually 0644 for files,
         *                               0755 for dirs. Default false.
         * @return bool True on success, false on failure.
         */
        public function copy($source, $destination, $overwrite = \false, $mode = \false)
        {
        }
        /**
         * Moves a file.
         *
         * @since 2.5.0
         * @abstract
         *
         * @param string $source      Path to the source file.
         * @param string $destination Path to the destination file.
         * @param bool   $overwrite   Optional. Whether to overwrite the destination file if it exists.
         *                            Default false.
         * @return bool True on success, false on failure.
         */
        public function move($source, $destination, $overwrite = \false)
        {
        }
        /**
         * Deletes a file or directory.
         *
         * @since 2.5.0
         * @abstract
         *
         * @param string       $file      Path to the file or directory.
         * @param bool         $recursive Optional. If set to true, deletes files and folders recursively.
         *                                Default false.
         * @param string|false $type      Type of resource. 'f' for file, 'd' for directory.
         *                                Default false.
         * @return bool True on success, false on failure.
         */
        public function delete($file, $recursive = \false, $type = \false)
        {
        }
        /**
         * Checks if a file or directory exists.
         *
         * @since 2.5.0
         * @abstract
         *
         * @param string $path Path to file or directory.
         * @return bool Whether $path exists or not.
         */
        public function exists($path)
        {
        }
        /**
         * Checks if resource is a file.
         *
         * @since 2.5.0
         * @abstract
         *
         * @param string $file File path.
         * @return bool Whether $file is a file.
         */
        public function is_file($file)
        {
        }
        /**
         * Checks if resource is a directory.
         *
         * @since 2.5.0
         * @abstract
         *
         * @param string $path Directory path.
         * @return bool Whether $path is a directory.
         */
        public function is_dir($path)
        {
        }
        /**
         * Checks if a file is readable.
         *
         * @since 2.5.0
         * @abstract
         *
         * @param string $file Path to file.
         * @return bool Whether $file is readable.
         */
        public function is_readable($file)
        {
        }
        /**
         * Checks if a file or directory is writable.
         *
         * @since 2.5.0
         * @abstract
         *
         * @param string $path Path to file or directory.
         * @return bool Whether $path is writable.
         */
        public function is_writable($path)
        {
        }
        /**
         * Gets the file's last access time.
         *
         * @since 2.5.0
         * @abstract
         *
         * @param string $file Path to file.
         * @return int|false Unix timestamp representing last access time, false on failure.
         */
        public function atime($file)
        {
        }
        /**
         * Gets the file modification time.
         *
         * @since 2.5.0
         * @abstract
         *
         * @param string $file Path to file.
         * @return int|false Unix timestamp representing modification time, false on failure.
         */
        public function mtime($file)
        {
        }
        /**
         * Gets the file size (in bytes).
         *
         * @since 2.5.0
         * @abstract
         *
         * @param string $file Path to file.
         * @return int|false Size of the file in bytes on success, false on failure.
         */
        public function size($file)
        {
        }
        /**
         * Sets the access and modification times of a file.
         *
         * Note: If $file doesn't exist, it will be created.
         *
         * @since 2.5.0
         * @abstract
         *
         * @param string $file  Path to file.
         * @param int    $time  Optional. Modified time to set for file.
         *                      Default 0.
         * @param int    $atime Optional. Access time to set for file.
         *                      Default 0.
         * @return bool True on success, false on failure.
         */
        public function touch($file, $time = 0, $atime = 0)
        {
        }
        /**
         * Creates a directory.
         *
         * @since 2.5.0
         * @abstract
         *
         * @param string           $path  Path for new directory.
         * @param int|false        $chmod Optional. The permissions as octal number (or false to skip chmod).
         *                                Default false.
         * @param string|int|false $chown Optional. A user name or number (or false to skip chown).
         *                                Default false.
         * @param string|int|false $chgrp Optional. A group name or number (or false to skip chgrp).
         *                                Default false.
         * @return bool True on success, false on failure.
         */
        public function mkdir($path, $chmod = \false, $chown = \false, $chgrp = \false)
        {
        }
        /**
         * Deletes a directory.
         *
         * @since 2.5.0
         * @abstract
         *
         * @param string $path      Path to directory.
         * @param bool   $recursive Optional. Whether to recursively remove files/directories.
         *                          Default false.
         * @return bool True on success, false on failure.
         */
        public function rmdir($path, $recursive = \false)
        {
        }
        /**
         * Gets details for files in a directory or a specific file.
         *
         * @since 2.5.0
         * @abstract
         *
         * @param string $path           Path to directory or file.
         * @param bool   $include_hidden Optional. Whether to include details of hidden ("." prefixed) files.
         *                               Default true.
         * @param bool   $recursive      Optional. Whether to recursively include file details in nested directories.
         *                               Default false.
         * @return array|false {
         *     Array of arrays containing file information. False if unable to list directory contents.
         *
         *     @type array ...$0 {
         *         Array of file information. Note that some elements may not be available on all filesystems.
         *
         *         @type string           $name        Name of the file or directory.
         *         @type string           $perms       *nix representation of permissions.
         *         @type string           $permsn      Octal representation of permissions.
         *         @type int|string|false $number      File number. May be a numeric string. False if not available.
         *         @type string|false     $owner       Owner name or ID, or false if not available.
         *         @type string|false     $group       File permissions group, or false if not available.
         *         @type int|string|false $size        Size of file in bytes. May be a numeric string.
         *                                             False if not available.
         *         @type int|string|false $lastmodunix Last modified unix timestamp. May be a numeric string.
         *                                             False if not available.
         *         @type string|false     $lastmod     Last modified month (3 letters) and day (without leading 0), or
         *                                             false if not available.
         *         @type string|false     $time        Last modified time, or false if not available.
         *         @type string           $type        Type of resource. 'f' for file, 'd' for directory, 'l' for link.
         *         @type array|false      $files       If a directory and `$recursive` is true, contains another array of
         *                                             files. False if unable to list directory contents.
         *     }
         * }
         * @phpstan-return false|array<int|string, array{
         *   name: string,
         *   perms: string,
         *   permsn: string,
         *   number: int|string|false,
         *   owner: string|false,
         *   group: string|false,
         *   size: int|string|false,
         *   lastmodunix: int|string|false,
         *   lastmod: string|false,
         *   time: string|false,
         *   type: string,
         *   files: array|false,
         * }>
         * @phpstan-return false|array<string, array{name: string, perms: string, permsn: string, owner: string|false, size: int|string|false, lastmodunix: int|string|false, lastmod: string|false, time: string|false, type: 'f'|'d'|'l', group: string|false, number: int|string|false, files?: array|false}>
         */
        public function dirlist($path, $include_hidden = \true, $recursive = \false)
        {
        }
    }
    /**
     * WordPress Filesystem Class for direct PHP file and folder manipulation.
     *
     * @since 2.5.0
     *
     * @see WP_Filesystem_Base
     */
    class WP_Filesystem_Direct extends \WP_Filesystem_Base
    {
        /**
         * Constructor.
         *
         * @since 2.5.0
         *
         * @param mixed $arg Not used.
         */
        public function __construct($arg)
        {
        }
        /**
         * Reads entire file into a string.
         *
         * @since 2.5.0
         *
         * @param string $file Name of the file to read.
         * @return string|false Read data on success, false on failure.
         */
        public function get_contents($file)
        {
        }
        /**
         * Reads entire file into an array.
         *
         * @since 2.5.0
         *
         * @param string $file Path to the file.
         * @return array|false File contents in an array on success, false on failure.
         */
        public function get_contents_array($file)
        {
        }
        /**
         * Writes a string to a file.
         *
         * @since 2.5.0
         *
         * @param string    $file     Remote path to the file where to write the data.
         * @param string    $contents The data to write.
         * @param int|false $mode     Optional. The file permissions as octal number, usually 0644.
         *                            Default false.
         * @return bool True on success, false on failure.
         */
        public function put_contents($file, $contents, $mode = \false)
        {
        }
        /**
         * Gets the current working directory.
         *
         * @since 2.5.0
         *
         * @return string|false The current working directory on success, false on failure.
         */
        public function cwd()
        {
        }
        /**
         * Changes current directory.
         *
         * @since 2.5.0
         *
         * @param string $dir The new current directory.
         * @return bool True on success, false on failure.
         */
        public function chdir($dir)
        {
        }
        /**
         * Changes the file group.
         *
         * @since 2.5.0
         *
         * @param string     $file      Path to the file.
         * @param string|int $group     A group name or number.
         * @param bool       $recursive Optional. If set to true, changes file group recursively.
         *                              Default false.
         * @return bool True on success, false on failure.
         */
        public function chgrp($file, $group, $recursive = \false)
        {
        }
        /**
         * Changes filesystem permissions.
         *
         * @since 2.5.0
         *
         * @param string    $file      Path to the file.
         * @param int|false $mode      Optional. The permissions as octal number, usually 0644 for files,
         *                             0755 for directories. Default false.
         * @param bool      $recursive Optional. If set to true, changes file permissions recursively.
         *                             Default false.
         * @return bool True on success, false on failure.
         */
        public function chmod($file, $mode = \false, $recursive = \false)
        {
        }
        /**
         * Changes the owner of a file or directory.
         *
         * @since 2.5.0
         *
         * @param string     $file      Path to the file or directory.
         * @param string|int $owner     A user name or number.
         * @param bool       $recursive Optional. If set to true, changes file owner recursively.
         *                              Default false.
         * @return bool True on success, false on failure.
         */
        public function chown($file, $owner, $recursive = \false)
        {
        }
        /**
         * Gets the file owner.
         *
         * @since 2.5.0
         *
         * @param string $file Path to the file.
         * @return string|false Username of the owner on success, false on failure.
         */
        public function owner($file)
        {
        }
        /**
         * Gets the permissions of the specified file or filepath in their octal format.
         *
         * FIXME does not handle errors in fileperms()
         *
         * @since 2.5.0
         *
         * @param string $file Path to the file.
         * @return string Mode of the file (the last 3 digits).
         */
        public function getchmod($file)
        {
        }
        /**
         * Gets the file's group.
         *
         * @since 2.5.0
         *
         * @param string $file Path to the file.
         * @return string|false The group on success, false on failure.
         */
        public function group($file)
        {
        }
        /**
         * Copies a file.
         *
         * @since 2.5.0
         *
         * @param string    $source      Path to the source file.
         * @param string    $destination Path to the destination file.
         * @param bool      $overwrite   Optional. Whether to overwrite the destination file if it exists.
         *                               Default false.
         * @param int|false $mode        Optional. The permissions as octal number, usually 0644 for files,
         *                               0755 for dirs. Default false.
         * @return bool True on success, false on failure.
         */
        public function copy($source, $destination, $overwrite = \false, $mode = \false)
        {
        }
        /**
         * Moves a file or directory.
         *
         * After moving files or directories, OPcache will need to be invalidated.
         *
         * If moving a directory fails, `copy_dir()` can be used for a recursive copy.
         *
         * Use `move_dir()` for moving directories with OPcache invalidation and a
         * fallback to `copy_dir()`.
         *
         * @since 2.5.0
         *
         * @param string $source      Path to the source file.
         * @param string $destination Path to the destination file.
         * @param bool   $overwrite   Optional. Whether to overwrite the destination file if it exists.
         *                            Default false.
         * @return bool True on success, false on failure.
         */
        public function move($source, $destination, $overwrite = \false)
        {
        }
        /**
         * Deletes a file or directory.
         *
         * @since 2.5.0
         *
         * @param string       $file      Path to the file or directory.
         * @param bool         $recursive Optional. If set to true, deletes files and folders recursively.
         *                                Default false.
         * @param string|false $type      Type of resource. 'f' for file, 'd' for directory.
         *                                Default false.
         * @return bool True on success, false on failure.
         */
        public function delete($file, $recursive = \false, $type = \false)
        {
        }
        /**
         * Checks if a file or directory exists.
         *
         * @since 2.5.0
         *
         * @param string $path Path to file or directory.
         * @return bool Whether $path exists or not.
         */
        public function exists($path)
        {
        }
        /**
         * Checks if resource is a file.
         *
         * @since 2.5.0
         *
         * @param string $file File path.
         * @return bool Whether $file is a file.
         */
        public function is_file($file)
        {
        }
        /**
         * Checks if resource is a directory.
         *
         * @since 2.5.0
         *
         * @param string $path Directory path.
         * @return bool Whether $path is a directory.
         */
        public function is_dir($path)
        {
        }
        /**
         * Checks if a file is readable.
         *
         * @since 2.5.0
         *
         * @param string $file Path to file.
         * @return bool Whether $file is readable.
         */
        public function is_readable($file)
        {
        }
        /**
         * Checks if a file or directory is writable.
         *
         * @since 2.5.0
         *
         * @param string $path Path to file or directory.
         * @return bool Whether $path is writable.
         */
        public function is_writable($path)
        {
        }
        /**
         * Gets the file's last access time.
         *
         * @since 2.5.0
         *
         * @param string $file Path to file.
         * @return int|false Unix timestamp representing last access time, false on failure.
         */
        public function atime($file)
        {
        }
        /**
         * Gets the file modification time.
         *
         * @since 2.5.0
         *
         * @param string $file Path to file.
         * @return int|false Unix timestamp representing modification time, false on failure.
         */
        public function mtime($file)
        {
        }
        /**
         * Gets the file size (in bytes).
         *
         * @since 2.5.0
         *
         * @param string $file Path to file.
         * @return int|false Size of the file in bytes on success, false on failure.
         */
        public function size($file)
        {
        }
        /**
         * Sets the access and modification times of a file.
         *
         * Note: If $file doesn't exist, it will be created.
         *
         * @since 2.5.0
         *
         * @param string $file  Path to file.
         * @param int    $time  Optional. Modified time to set for file.
         *                      Default 0.
         * @param int    $atime Optional. Access time to set for file.
         *                      Default 0.
         * @return bool True on success, false on failure.
         */
        public function touch($file, $time = 0, $atime = 0)
        {
        }
        /**
         * Creates a directory.
         *
         * @since 2.5.0
         *
         * @param string           $path  Path for new directory.
         * @param int|false        $chmod Optional. The permissions as octal number (or false to skip chmod).
         *                                Default false.
         * @param string|int|false $chown Optional. A user name or number (or false to skip chown).
         *                                Default false.
         * @param string|int|false $chgrp Optional. A group name or number (or false to skip chgrp).
         *                                Default false.
         * @return bool True on success, false on failure.
         */
        public function mkdir($path, $chmod = \false, $chown = \false, $chgrp = \false)
        {
        }
        /**
         * Deletes a directory.
         *
         * @since 2.5.0
         *
         * @param string $path      Path to directory.
         * @param bool   $recursive Optional. Whether to recursively remove files/directories.
         *                          Default false.
         * @return bool True on success, false on failure.
         */
        public function rmdir($path, $recursive = \false)
        {
        }
        /**
         * Gets details for files in a directory or a specific file.
         *
         * @since 2.5.0
         *
         * @param string $path           Path to directory or file.
         * @param bool   $include_hidden Optional. Whether to include details of hidden ("." prefixed) files.
         *                               Default true.
         * @param bool   $recursive      Optional. Whether to recursively include file details in nested directories.
         *                               Default false.
         * @return array|false {
         *     Array of arrays containing file information. False if unable to list directory contents.
         *
         *     @type array ...$0 {
         *         Array of file information. Note that some elements may not be available on all filesystems.
         *
         *         @type string           $name        Name of the file or directory.
         *         @type string           $perms       *nix representation of permissions.
         *         @type string           $permsn      Octal representation of permissions.
         *         @type false            $number      File number. Always false in this context.
         *         @type string|false     $owner       Owner name or ID, or false if not available.
         *         @type string|false     $group       File permissions group, or false if not available.
         *         @type int|string|false $size        Size of file in bytes. May be a numeric string.
         *                                             False if not available.
         *         @type int|string|false $lastmodunix Last modified unix timestamp. May be a numeric string.
         *                                             False if not available.
         *         @type string|false     $lastmod     Last modified month (3 letters) and day (without leading 0), or
         *                                             false if not available.
         *         @type string|false     $time        Last modified time, or false if not available.
         *         @type string           $type        Type of resource. 'f' for file, 'd' for directory, 'l' for link.
         *         @type array|false      $files       If a directory and `$recursive` is true, contains another array of
         *                                             files. False if unable to list directory contents.
         *     }
         * }
         * @phpstan-return false|array<int|string, array{
         *   name: string,
         *   perms: string,
         *   permsn: string,
         *   number: false,
         *   owner: string|false,
         *   group: string|false,
         *   size: int|string|false,
         *   lastmodunix: int|string|false,
         *   lastmod: string|false,
         *   time: string|false,
         *   type: string,
         *   files: array|false,
         * }>
         * @phpstan-return false|array<string, array{name: string, perms: string, permsn: string, owner: string|false, size: int|string|false, lastmodunix: int|string|false, lastmod: string|false, time: string|false, type: 'f'|'d'|'l', group: string|false, number: int|string|false, files?: array|false}>
         */
        public function dirlist($path, $include_hidden = \true, $recursive = \false)
        {
        }
    }
    /**
     * WordPress Filesystem Class for implementing FTP.
     *
     * @since 2.5.0
     *
     * @see WP_Filesystem_Base
     */
    class WP_Filesystem_FTPext extends \WP_Filesystem_Base
    {
        /**
         * @since 2.5.0
         * @var resource
         */
        public $link;
        /**
         * Constructor.
         *
         * @since 2.5.0
         *
         * @param array $opt
         * @phpstan-return void
         */
        public function __construct($opt = '')
        {
        }
        /**
         * Connects filesystem.
         *
         * @since 2.5.0
         *
         * @return bool True on success, false on failure.
         */
        public function connect()
        {
        }
        /**
         * Reads entire file into a string.
         *
         * @since 2.5.0
         *
         * @param string $file Name of the file to read.
         * @return string|false Read data on success, false if no temporary file could be opened,
         *                      or if the file couldn't be retrieved.
         */
        public function get_contents($file)
        {
        }
        /**
         * Reads entire file into an array.
         *
         * @since 2.5.0
         *
         * @param string $file Path to the file.
         * @return array|false File contents in an array on success, false on failure.
         */
        public function get_contents_array($file)
        {
        }
        /**
         * Writes a string to a file.
         *
         * @since 2.5.0
         *
         * @param string    $file     Remote path to the file where to write the data.
         * @param string    $contents The data to write.
         * @param int|false $mode     Optional. The file permissions as octal number, usually 0644.
         *                            Default false.
         * @return bool True on success, false on failure.
         */
        public function put_contents($file, $contents, $mode = \false)
        {
        }
        /**
         * Gets the current working directory.
         *
         * @since 2.5.0
         *
         * @return string|false The current working directory on success, false on failure.
         */
        public function cwd()
        {
        }
        /**
         * Changes current directory.
         *
         * @since 2.5.0
         *
         * @param string $dir The new current directory.
         * @return bool True on success, false on failure.
         */
        public function chdir($dir)
        {
        }
        /**
         * Changes filesystem permissions.
         *
         * @since 2.5.0
         *
         * @param string    $file      Path to the file.
         * @param int|false $mode      Optional. The permissions as octal number, usually 0644 for files,
         *                             0755 for directories. Default false.
         * @param bool      $recursive Optional. If set to true, changes file permissions recursively.
         *                             Default false.
         * @return bool True on success, false on failure.
         */
        public function chmod($file, $mode = \false, $recursive = \false)
        {
        }
        /**
         * Gets the file owner.
         *
         * @since 2.5.0
         *
         * @param string $file Path to the file.
         * @return string|false Username of the owner on success, false on failure.
         */
        public function owner($file)
        {
        }
        /**
         * Gets the permissions of the specified file or filepath in their octal format.
         *
         * @since 2.5.0
         *
         * @param string $file Path to the file.
         * @return string Mode of the file (the last 3 digits).
         */
        public function getchmod($file)
        {
        }
        /**
         * Gets the file's group.
         *
         * @since 2.5.0
         *
         * @param string $file Path to the file.
         * @return string|false The group on success, false on failure.
         */
        public function group($file)
        {
        }
        /**
         * Copies a file.
         *
         * @since 2.5.0
         *
         * @param string    $source      Path to the source file.
         * @param string    $destination Path to the destination file.
         * @param bool      $overwrite   Optional. Whether to overwrite the destination file if it exists.
         *                               Default false.
         * @param int|false $mode        Optional. The permissions as octal number, usually 0644 for files,
         *                               0755 for dirs. Default false.
         * @return bool True on success, false on failure.
         */
        public function copy($source, $destination, $overwrite = \false, $mode = \false)
        {
        }
        /**
         * Moves a file or directory.
         *
         * After moving files or directories, OPcache will need to be invalidated.
         *
         * If moving a directory fails, `copy_dir()` can be used for a recursive copy.
         *
         * Use `move_dir()` for moving directories with OPcache invalidation and a
         * fallback to `copy_dir()`.
         *
         * @since 2.5.0
         *
         * @param string $source      Path to the source file or directory.
         * @param string $destination Path to the destination file or directory.
         * @param bool   $overwrite   Optional. Whether to overwrite the destination if it exists.
         *                            Default false.
         * @return bool True on success, false on failure.
         */
        public function move($source, $destination, $overwrite = \false)
        {
        }
        /**
         * Deletes a file or directory.
         *
         * @since 2.5.0
         *
         * @param string       $file      Path to the file or directory.
         * @param bool         $recursive Optional. If set to true, deletes files and folders recursively.
         *                                Default false.
         * @param string|false $type      Type of resource. 'f' for file, 'd' for directory.
         *                                Default false.
         * @return bool True on success, false on failure.
         */
        public function delete($file, $recursive = \false, $type = \false)
        {
        }
        /**
         * Checks if a file or directory exists.
         *
         * @since 2.5.0
         * @since 6.3.0 Returns false for an empty path.
         *
         * @param string $path Path to file or directory.
         * @return bool Whether $path exists or not.
         */
        public function exists($path)
        {
        }
        /**
         * Checks if resource is a file.
         *
         * @since 2.5.0
         *
         * @param string $file File path.
         * @return bool Whether $file is a file.
         */
        public function is_file($file)
        {
        }
        /**
         * Checks if resource is a directory.
         *
         * @since 2.5.0
         *
         * @param string $path Directory path.
         * @return bool Whether $path is a directory.
         */
        public function is_dir($path)
        {
        }
        /**
         * Checks if a file is readable.
         *
         * @since 2.5.0
         *
         * @param string $file Path to file.
         * @return bool Whether $file is readable.
         */
        public function is_readable($file)
        {
        }
        /**
         * Checks if a file or directory is writable.
         *
         * @since 2.5.0
         *
         * @param string $path Path to file or directory.
         * @return bool Whether $path is writable.
         */
        public function is_writable($path)
        {
        }
        /**
         * Gets the file's last access time.
         *
         * @since 2.5.0
         *
         * @param string $file Path to file.
         * @return int|false Unix timestamp representing last access time, false on failure.
         */
        public function atime($file)
        {
        }
        /**
         * Gets the file modification time.
         *
         * @since 2.5.0
         *
         * @param string $file Path to file.
         * @return int|false Unix timestamp representing modification time, false on failure.
         */
        public function mtime($file)
        {
        }
        /**
         * Gets the file size (in bytes).
         *
         * @since 2.5.0
         *
         * @param string $file Path to file.
         * @return int|false Size of the file in bytes on success, false on failure.
         */
        public function size($file)
        {
        }
        /**
         * Sets the access and modification times of a file.
         *
         * Note: If $file doesn't exist, it will be created.
         *
         * @since 2.5.0
         *
         * @param string $file  Path to file.
         * @param int    $time  Optional. Modified time to set for file.
         *                      Default 0.
         * @param int    $atime Optional. Access time to set for file.
         *                      Default 0.
         * @return bool True on success, false on failure.
         */
        public function touch($file, $time = 0, $atime = 0)
        {
        }
        /**
         * Creates a directory.
         *
         * @since 2.5.0
         *
         * @param string           $path  Path for new directory.
         * @param int|false        $chmod Optional. The permissions as octal number (or false to skip chmod).
         *                                Default false.
         * @param string|int|false $chown Optional. A user name or number (or false to skip chown).
         *                                Default false.
         * @param string|int|false $chgrp Optional. A group name or number (or false to skip chgrp).
         *                                Default false.
         * @return bool True on success, false on failure.
         */
        public function mkdir($path, $chmod = \false, $chown = \false, $chgrp = \false)
        {
        }
        /**
         * Deletes a directory.
         *
         * @since 2.5.0
         *
         * @param string $path      Path to directory.
         * @param bool   $recursive Optional. Whether to recursively remove files/directories.
         *                          Default false.
         * @return bool True on success, false on failure.
         */
        public function rmdir($path, $recursive = \false)
        {
        }
        /**
         * @param string $line
         * @return array {
         *     Array of file information.
         *
         *     @type string       $name        Name of the file or directory.
         *     @type string       $perms       *nix representation of permissions.
         *     @type string       $permsn      Octal representation of permissions.
         *     @type string|false $number      File number as a string, or false if not available.
         *     @type string|false $owner       Owner name or ID, or false if not available.
         *     @type string|false $group       File permissions group, or false if not available.
         *     @type string|false $size        Size of file in bytes as a string, or false if not available.
         *     @type string|false $lastmodunix Last modified unix timestamp as a string, or false if not available.
         *     @type string|false $lastmod     Last modified month (3 letters) and day (without leading 0), or
         *                                     false if not available.
         *     @type string|false $time        Last modified time, or false if not available.
         *     @type string       $type        Type of resource. 'f' for file, 'd' for directory, 'l' for link.
         *     @type array|false  $files       If a directory and `$recursive` is true, contains another array of files.
         *                                     False if unable to list directory contents.
         * }
         * @phpstan-return array{
         *   name: string,
         *   perms: string,
         *   permsn: string,
         *   number: string|false,
         *   owner: string|false,
         *   group: string|false,
         *   size: string|false,
         *   lastmodunix: string|false,
         *   lastmod: string|false,
         *   time: string|false,
         *   type: string,
         *   files: array|false,
         * }
         */
        public function parselisting($line)
        {
        }
        /**
         * Gets details for files in a directory or a specific file.
         *
         * @since 2.5.0
         *
         * @param string $path           Path to directory or file.
         * @param bool   $include_hidden Optional. Whether to include details of hidden ("." prefixed) files.
         *                               Default true.
         * @param bool   $recursive      Optional. Whether to recursively include file details in nested directories.
         *                               Default false.
         * @return array|false {
         *     Array of arrays containing file information. False if unable to list directory contents.
         *
         *     @type array ...$0 {
         *         Array of file information. Note that some elements may not be available on all filesystems.
         *
         *         @type string           $name        Name of the file or directory.
         *         @type string           $perms       *nix representation of permissions.
         *         @type string           $permsn      Octal representation of permissions.
         *         @type int|string|false $number      File number. May be a numeric string. False if not available.
         *         @type string|false     $owner       Owner name or ID, or false if not available.
         *         @type string|false     $group       File permissions group, or false if not available.
         *         @type int|string|false $size        Size of file in bytes. May be a numeric string.
         *                                             False if not available.
         *         @type int|string|false $lastmodunix Last modified unix timestamp. May be a numeric string.
         *                                             False if not available.
         *         @type string|false     $lastmod     Last modified month (3 letters) and day (without leading 0), or
         *                                             false if not available.
         *         @type string|false     $time        Last modified time, or false if not available.
         *         @type string           $type        Type of resource. 'f' for file, 'd' for directory, 'l' for link.
         *         @type array|false      $files       If a directory and `$recursive` is true, contains another array of
         *                                             files. False if unable to list directory contents.
         *     }
         * }
         * @phpstan-return false|array<int|string, array{
         *   name: string,
         *   perms: string,
         *   permsn: string,
         *   number: int|string|false,
         *   owner: string|false,
         *   group: string|false,
         *   size: int|string|false,
         *   lastmodunix: int|string|false,
         *   lastmod: string|false,
         *   time: string|false,
         *   type: string,
         *   files: array|false,
         * }>
         * @phpstan-return false|array<string, array{name: string, perms: string, permsn: string, owner: string|false, size: int|string|false, lastmodunix: int|string|false, lastmod: string|false, time: string|false, type: 'f'|'d'|'l', group: string|false, number: int|string|false, files?: array|false}>
         */
        public function dirlist($path = '.', $include_hidden = \true, $recursive = \false)
        {
        }
        /**
         * Destructor.
         *
         * @since 2.5.0
         */
        public function __destruct()
        {
        }
    }
    /**
     * WordPress Filesystem Class for implementing FTP Sockets.
     *
     * @since 2.5.0
     *
     * @see WP_Filesystem_Base
     */
    class WP_Filesystem_ftpsockets extends \WP_Filesystem_Base
    {
        /**
         * @since 2.5.0
         * @var ftp
         */
        public $ftp;
        /**
         * Constructor.
         *
         * @since 2.5.0
         *
         * @param array $opt
         * @phpstan-return void
         */
        public function __construct($opt = '')
        {
        }
        /**
         * Connects filesystem.
         *
         * @since 2.5.0
         *
         * @return bool True on success, false on failure.
         */
        public function connect()
        {
        }
        /**
         * Reads entire file into a string.
         *
         * @since 2.5.0
         *
         * @param string $file Name of the file to read.
         * @return string|false Read data on success, false if no temporary file could be opened,
         *                      or if the file couldn't be retrieved.
         */
        public function get_contents($file)
        {
        }
        /**
         * Reads entire file into an array.
         *
         * @since 2.5.0
         *
         * @param string $file Path to the file.
         * @return array|false File contents in an array on success, false on failure.
         */
        public function get_contents_array($file)
        {
        }
        /**
         * Writes a string to a file.
         *
         * @since 2.5.0
         *
         * @param string    $file     Remote path to the file where to write the data.
         * @param string    $contents The data to write.
         * @param int|false $mode     Optional. The file permissions as octal number, usually 0644.
         *                            Default false.
         * @return bool True on success, false on failure.
         */
        public function put_contents($file, $contents, $mode = \false)
        {
        }
        /**
         * Gets the current working directory.
         *
         * @since 2.5.0
         *
         * @return string|false The current working directory on success, false on failure.
         */
        public function cwd()
        {
        }
        /**
         * Changes current directory.
         *
         * @since 2.5.0
         *
         * @param string $dir The new current directory.
         * @return bool True on success, false on failure.
         */
        public function chdir($dir)
        {
        }
        /**
         * Changes filesystem permissions.
         *
         * @since 2.5.0
         *
         * @param string    $file      Path to the file.
         * @param int|false $mode      Optional. The permissions as octal number, usually 0644 for files,
         *                             0755 for directories. Default false.
         * @param bool      $recursive Optional. If set to true, changes file permissions recursively.
         *                             Default false.
         * @return bool True on success, false on failure.
         */
        public function chmod($file, $mode = \false, $recursive = \false)
        {
        }
        /**
         * Gets the file owner.
         *
         * @since 2.5.0
         *
         * @param string $file Path to the file.
         * @return string|false Username of the owner on success, false on failure.
         */
        public function owner($file)
        {
        }
        /**
         * Gets the permissions of the specified file or filepath in their octal format.
         *
         * @since 2.5.0
         *
         * @param string $file Path to the file.
         * @return string Mode of the file (the last 3 digits).
         */
        public function getchmod($file)
        {
        }
        /**
         * Gets the file's group.
         *
         * @since 2.5.0
         *
         * @param string $file Path to the file.
         * @return string|false The group on success, false on failure.
         */
        public function group($file)
        {
        }
        /**
         * Copies a file.
         *
         * @since 2.5.0
         *
         * @param string    $source      Path to the source file.
         * @param string    $destination Path to the destination file.
         * @param bool      $overwrite   Optional. Whether to overwrite the destination file if it exists.
         *                               Default false.
         * @param int|false $mode        Optional. The permissions as octal number, usually 0644 for files,
         *                               0755 for dirs. Default false.
         * @return bool True on success, false on failure.
         */
        public function copy($source, $destination, $overwrite = \false, $mode = \false)
        {
        }
        /**
         * Moves a file or directory.
         *
         * After moving files or directories, OPcache will need to be invalidated.
         *
         * If moving a directory fails, `copy_dir()` can be used for a recursive copy.
         *
         * Use `move_dir()` for moving directories with OPcache invalidation and a
         * fallback to `copy_dir()`.
         *
         * @since 2.5.0
         *
         * @param string $source      Path to the source file or directory.
         * @param string $destination Path to the destination file or directory.
         * @param bool   $overwrite   Optional. Whether to overwrite the destination if it exists.
         *                            Default false.
         * @return bool True on success, false on failure.
         */
        public function move($source, $destination, $overwrite = \false)
        {
        }
        /**
         * Deletes a file or directory.
         *
         * @since 2.5.0
         *
         * @param string       $file      Path to the file or directory.
         * @param bool         $recursive Optional. If set to true, deletes files and folders recursively.
         *                                Default false.
         * @param string|false $type      Type of resource. 'f' for file, 'd' for directory.
         *                                Default false.
         * @return bool True on success, false on failure.
         */
        public function delete($file, $recursive = \false, $type = \false)
        {
        }
        /**
         * Checks if a file or directory exists.
         *
         * @since 2.5.0
         * @since 6.3.0 Returns false for an empty path.
         *
         * @param string $path Path to file or directory.
         * @return bool Whether $path exists or not.
         */
        public function exists($path)
        {
        }
        /**
         * Checks if resource is a file.
         *
         * @since 2.5.0
         *
         * @param string $file File path.
         * @return bool Whether $file is a file.
         */
        public function is_file($file)
        {
        }
        /**
         * Checks if resource is a directory.
         *
         * @since 2.5.0
         *
         * @param string $path Directory path.
         * @return bool Whether $path is a directory.
         */
        public function is_dir($path)
        {
        }
        /**
         * Checks if a file is readable.
         *
         * @since 2.5.0
         *
         * @param string $file Path to file.
         * @return bool Whether $file is readable.
         */
        public function is_readable($file)
        {
        }
        /**
         * Checks if a file or directory is writable.
         *
         * @since 2.5.0
         *
         * @param string $path Path to file or directory.
         * @return bool Whether $path is writable.
         */
        public function is_writable($path)
        {
        }
        /**
         * Gets the file's last access time.
         *
         * @since 2.5.0
         *
         * @param string $file Path to file.
         * @return int|false Unix timestamp representing last access time, false on failure.
         */
        public function atime($file)
        {
        }
        /**
         * Gets the file modification time.
         *
         * @since 2.5.0
         *
         * @param string $file Path to file.
         * @return int|false Unix timestamp representing modification time, false on failure.
         */
        public function mtime($file)
        {
        }
        /**
         * Gets the file size (in bytes).
         *
         * @since 2.5.0
         *
         * @param string $file Path to file.
         * @return int|false Size of the file in bytes on success, false on failure.
         */
        public function size($file)
        {
        }
        /**
         * Sets the access and modification times of a file.
         *
         * Note: If $file doesn't exist, it will be created.
         *
         * @since 2.5.0
         *
         * @param string $file  Path to file.
         * @param int    $time  Optional. Modified time to set for file.
         *                      Default 0.
         * @param int    $atime Optional. Access time to set for file.
         *                      Default 0.
         * @return bool True on success, false on failure.
         */
        public function touch($file, $time = 0, $atime = 0)
        {
        }
        /**
         * Creates a directory.
         *
         * @since 2.5.0
         *
         * @param string           $path  Path for new directory.
         * @param int|false        $chmod Optional. The permissions as octal number (or false to skip chmod).
         *                                Default false.
         * @param string|int|false $chown Optional. A user name or number (or false to skip chown).
         *                                Default false.
         * @param string|int|false $chgrp Optional. A group name or number (or false to skip chgrp).
         *                                Default false.
         * @return bool True on success, false on failure.
         */
        public function mkdir($path, $chmod = \false, $chown = \false, $chgrp = \false)
        {
        }
        /**
         * Deletes a directory.
         *
         * @since 2.5.0
         *
         * @param string $path      Path to directory.
         * @param bool   $recursive Optional. Whether to recursively remove files/directories.
         *                          Default false.
         * @return bool True on success, false on failure.
         */
        public function rmdir($path, $recursive = \false)
        {
        }
        /**
         * Gets details for files in a directory or a specific file.
         *
         * @since 2.5.0
         *
         * @param string $path           Path to directory or file.
         * @param bool   $include_hidden Optional. Whether to include details of hidden ("." prefixed) files.
         *                               Default true.
         * @param bool   $recursive      Optional. Whether to recursively include file details in nested directories.
         *                               Default false.
         * @return array|false {
         *     Array of arrays containing file information. False if unable to list directory contents.
         *
         *     @type array ...$0 {
         *         Array of file information. Note that some elements may not be available on all filesystems.
         *
         *         @type string           $name        Name of the file or directory.
         *         @type string           $perms       *nix representation of permissions.
         *         @type string           $permsn      Octal representation of permissions.
         *         @type int|string|false $number      File number. May be a numeric string. False if not available.
         *         @type string|false     $owner       Owner name or ID, or false if not available.
         *         @type string|false     $group       File permissions group, or false if not available.
         *         @type int|string|false $size        Size of file in bytes. May be a numeric string.
         *                                             False if not available.
         *         @type int|string|false $lastmodunix Last modified unix timestamp. May be a numeric string.
         *                                             False if not available.
         *         @type string|false     $lastmod     Last modified month (3 letters) and day (without leading 0), or
         *                                             false if not available.
         *         @type string|false     $time        Last modified time, or false if not available.
         *         @type string           $type        Type of resource. 'f' for file, 'd' for directory, 'l' for link.
         *         @type array|false      $files       If a directory and `$recursive` is true, contains another array of
         *                                             files. False if unable to list directory contents.
         *     }
         * }
         * @phpstan-return false|array<int|string, array{
         *   name: string,
         *   perms: string,
         *   permsn: string,
         *   number: int|string|false,
         *   owner: string|false,
         *   group: string|false,
         *   size: int|string|false,
         *   lastmodunix: int|string|false,
         *   lastmod: string|false,
         *   time: string|false,
         *   type: string,
         *   files: array|false,
         * }>
         * @phpstan-return false|array<string, array{name: string, perms: string, permsn: string, owner: string|false, size: int|string|false, lastmodunix: int|string|false, lastmod: string|false, time: string|false, type: 'f'|'d'|'l', group: string|false, number: int|string|false, files?: array|false}>
         */
        public function dirlist($path = '.', $include_hidden = \true, $recursive = \false)
        {
        }
        /**
         * Destructor.
         *
         * @since 2.5.0
         */
        public function __destruct()
        {
        }
    }
    /**
     * WordPress Filesystem Class for implementing SSH2
     *
     * To use this class you must follow these steps for PHP 5.2.6+
     *
     * {@link http://kevin.vanzonneveld.net/techblog/article/make_ssh_connections_with_php/ - Installation Notes}
     *
     * Compile libssh2 (Note: Only 0.14 is officially working with PHP 5.2.6+ right now, But many users have found the latest versions work)
     *
     * cd /usr/src
     * wget https://www.libssh2.org/download/libssh2-0.14.tar.gz
     * tar -zxvf libssh2-0.14.tar.gz
     * cd libssh2-0.14/
     * ./configure
     * make all install
     *
     * Note: Do not leave the directory yet!
     *
     * Enter: pecl install -f ssh2
     *
     * Copy the ssh.so file it creates to your PHP Module Directory.
     * Open up your PHP.INI file and look for where extensions are placed.
     * Add in your PHP.ini file: extension=ssh2.so
     *
     * Restart Apache!
     * Check phpinfo() streams to confirm that: ssh2.shell, ssh2.exec, ssh2.tunnel, ssh2.scp, ssh2.sftp  exist.
     *
     * Note: As of WordPress 2.8, this utilizes the PHP5+ function `stream_get_contents()`.
     *
     * @since 2.7.0
     *
     * @package WordPress
     * @subpackage Filesystem
     */
    class WP_Filesystem_SSH2 extends \WP_Filesystem_Base
    {
        /**
         * @since 2.7.0
         * @var resource
         */
        public $link = \false;
        /**
         * @since 2.7.0
         * @var resource
         */
        public $sftp_link;
        /**
         * @since 2.7.0
         * @var bool
         */
        public $keys = \false;
        /**
         * Constructor.
         *
         * @since 2.7.0
         *
         * @param array $opt
         * @phpstan-return void
         */
        public function __construct($opt = '')
        {
        }
        /**
         * Connects filesystem.
         *
         * @since 2.7.0
         *
         * @return bool True on success, false on failure.
         */
        public function connect()
        {
        }
        /**
         * Gets the ssh2.sftp PHP stream wrapper path to open for the given file.
         *
         * This method also works around a PHP bug where the root directory (/) cannot
         * be opened by PHP functions, causing a false failure. In order to work around
         * this, the path is converted to /./ which is semantically the same as /
         * See https://bugs.php.net/bug.php?id=64169 for more details.
         *
         * @since 4.4.0
         *
         * @param string $path The File/Directory path on the remote server to return
         * @return string The ssh2.sftp:// wrapped path to use.
         */
        public function sftp_path($path)
        {
        }
        /**
         * @since 2.7.0
         *
         * @param string $command
         * @param bool   $returnbool
         * @return bool|string True on success, false on failure. String if the command was executed, `$returnbool`
         *                     is false (default), and data from the resulting stream was retrieved.
         */
        public function run_command($command, $returnbool = \false)
        {
        }
        /**
         * Reads entire file into a string.
         *
         * @since 2.7.0
         *
         * @param string $file Name of the file to read.
         * @return string|false Read data on success, false if no temporary file could be opened,
         *                      or if the file couldn't be retrieved.
         */
        public function get_contents($file)
        {
        }
        /**
         * Reads entire file into an array.
         *
         * @since 2.7.0
         *
         * @param string $file Path to the file.
         * @return array|false File contents in an array on success, false on failure.
         */
        public function get_contents_array($file)
        {
        }
        /**
         * Writes a string to a file.
         *
         * @since 2.7.0
         *
         * @param string    $file     Remote path to the file where to write the data.
         * @param string    $contents The data to write.
         * @param int|false $mode     Optional. The file permissions as octal number, usually 0644.
         *                            Default false.
         * @return bool True on success, false on failure.
         */
        public function put_contents($file, $contents, $mode = \false)
        {
        }
        /**
         * Gets the current working directory.
         *
         * @since 2.7.0
         *
         * @return string|false The current working directory on success, false on failure.
         */
        public function cwd()
        {
        }
        /**
         * Changes current directory.
         *
         * @since 2.7.0
         *
         * @param string $dir The new current directory.
         * @return bool True on success, false on failure.
         */
        public function chdir($dir)
        {
        }
        /**
         * Changes the file group.
         *
         * @since 2.7.0
         *
         * @param string     $file      Path to the file.
         * @param string|int $group     A group name or number.
         * @param bool       $recursive Optional. If set to true, changes file group recursively.
         *                              Default false.
         * @return bool True on success, false on failure.
         */
        public function chgrp($file, $group, $recursive = \false)
        {
        }
        /**
         * Changes filesystem permissions.
         *
         * @since 2.7.0
         *
         * @param string    $file      Path to the file.
         * @param int|false $mode      Optional. The permissions as octal number, usually 0644 for files,
         *                             0755 for directories. Default false.
         * @param bool      $recursive Optional. If set to true, changes file permissions recursively.
         *                             Default false.
         * @return bool True on success, false on failure.
         */
        public function chmod($file, $mode = \false, $recursive = \false)
        {
        }
        /**
         * Changes the owner of a file or directory.
         *
         * @since 2.7.0
         *
         * @param string     $file      Path to the file or directory.
         * @param string|int $owner     A user name or number.
         * @param bool       $recursive Optional. If set to true, changes file owner recursively.
         *                              Default false.
         * @return bool True on success, false on failure.
         */
        public function chown($file, $owner, $recursive = \false)
        {
        }
        /**
         * Gets the file owner.
         *
         * @since 2.7.0
         *
         * @param string $file Path to the file.
         * @return string|false Username of the owner on success, false on failure.
         */
        public function owner($file)
        {
        }
        /**
         * Gets the permissions of the specified file or filepath in their octal format.
         *
         * @since 2.7.0
         *
         * @param string $file Path to the file.
         * @return string Mode of the file (the last 3 digits).
         */
        public function getchmod($file)
        {
        }
        /**
         * Gets the file's group.
         *
         * @since 2.7.0
         *
         * @param string $file Path to the file.
         * @return string|false The group on success, false on failure.
         */
        public function group($file)
        {
        }
        /**
         * Copies a file.
         *
         * @since 2.7.0
         *
         * @param string    $source      Path to the source file.
         * @param string    $destination Path to the destination file.
         * @param bool      $overwrite   Optional. Whether to overwrite the destination file if it exists.
         *                               Default false.
         * @param int|false $mode        Optional. The permissions as octal number, usually 0644 for files,
         *                               0755 for dirs. Default false.
         * @return bool True on success, false on failure.
         */
        public function copy($source, $destination, $overwrite = \false, $mode = \false)
        {
        }
        /**
         * Moves a file or directory.
         *
         * After moving files or directories, OPcache will need to be invalidated.
         *
         * If moving a directory fails, `copy_dir()` can be used for a recursive copy.
         *
         * Use `move_dir()` for moving directories with OPcache invalidation and a
         * fallback to `copy_dir()`.
         *
         * @since 2.7.0
         *
         * @param string $source      Path to the source file or directory.
         * @param string $destination Path to the destination file or directory.
         * @param bool   $overwrite   Optional. Whether to overwrite the destination if it exists.
         *                            Default false.
         * @return bool True on success, false on failure.
         */
        public function move($source, $destination, $overwrite = \false)
        {
        }
        /**
         * Deletes a file or directory.
         *
         * @since 2.7.0
         *
         * @param string       $file      Path to the file or directory.
         * @param bool         $recursive Optional. If set to true, deletes files and folders recursively.
         *                                Default false.
         * @param string|false $type      Type of resource. 'f' for file, 'd' for directory.
         *                                Default false.
         * @return bool True on success, false on failure.
         */
        public function delete($file, $recursive = \false, $type = \false)
        {
        }
        /**
         * Checks if a file or directory exists.
         *
         * @since 2.7.0
         *
         * @param string $path Path to file or directory.
         * @return bool Whether $path exists or not.
         */
        public function exists($path)
        {
        }
        /**
         * Checks if resource is a file.
         *
         * @since 2.7.0
         *
         * @param string $file File path.
         * @return bool Whether $file is a file.
         */
        public function is_file($file)
        {
        }
        /**
         * Checks if resource is a directory.
         *
         * @since 2.7.0
         *
         * @param string $path Directory path.
         * @return bool Whether $path is a directory.
         */
        public function is_dir($path)
        {
        }
        /**
         * Checks if a file is readable.
         *
         * @since 2.7.0
         *
         * @param string $file Path to file.
         * @return bool Whether $file is readable.
         */
        public function is_readable($file)
        {
        }
        /**
         * Checks if a file or directory is writable.
         *
         * @since 2.7.0
         *
         * @param string $path Path to file or directory.
         * @return bool Whether $path is writable.
         */
        public function is_writable($path)
        {
        }
        /**
         * Gets the file's last access time.
         *
         * @since 2.7.0
         *
         * @param string $file Path to file.
         * @return int|false Unix timestamp representing last access time, false on failure.
         */
        public function atime($file)
        {
        }
        /**
         * Gets the file modification time.
         *
         * @since 2.7.0
         *
         * @param string $file Path to file.
         * @return int|false Unix timestamp representing modification time, false on failure.
         */
        public function mtime($file)
        {
        }
        /**
         * Gets the file size (in bytes).
         *
         * @since 2.7.0
         *
         * @param string $file Path to file.
         * @return int|false Size of the file in bytes on success, false on failure.
         */
        public function size($file)
        {
        }
        /**
         * Sets the access and modification times of a file.
         *
         * Note: Not implemented.
         *
         * @since 2.7.0
         *
         * @param string $file  Path to file.
         * @param int    $time  Optional. Modified time to set for file.
         *                      Default 0.
         * @param int    $atime Optional. Access time to set for file.
         *                      Default 0.
         */
        public function touch($file, $time = 0, $atime = 0)
        {
        }
        /**
         * Creates a directory.
         *
         * @since 2.7.0
         *
         * @param string           $path  Path for new directory.
         * @param int|false        $chmod Optional. The permissions as octal number (or false to skip chmod).
         *                                Default false.
         * @param string|int|false $chown Optional. A user name or number (or false to skip chown).
         *                                Default false.
         * @param string|int|false $chgrp Optional. A group name or number (or false to skip chgrp).
         *                                Default false.
         * @return bool True on success, false on failure.
         */
        public function mkdir($path, $chmod = \false, $chown = \false, $chgrp = \false)
        {
        }
        /**
         * Deletes a directory.
         *
         * @since 2.7.0
         *
         * @param string $path      Path to directory.
         * @param bool   $recursive Optional. Whether to recursively remove files/directories.
         *                          Default false.
         * @return bool True on success, false on failure.
         */
        public function rmdir($path, $recursive = \false)
        {
        }
        /**
         * Gets details for files in a directory or a specific file.
         *
         * @since 2.7.0
         *
         * @param string $path           Path to directory or file.
         * @param bool   $include_hidden Optional. Whether to include details of hidden ("." prefixed) files.
         *                               Default true.
         * @param bool   $recursive      Optional. Whether to recursively include file details in nested directories.
         *                               Default false.
         * @return array|false {
         *     Array of arrays containing file information. False if unable to list directory contents.
         *
         *     @type array ...$0 {
         *         Array of file information. Note that some elements may not be available on all filesystems.
         *
         *         @type string           $name        Name of the file or directory.
         *         @type string           $perms       *nix representation of permissions.
         *         @type string           $permsn      Octal representation of permissions.
         *         @type false            $number      File number. Always false in this context.
         *         @type string|false     $owner       Owner name or ID, or false if not available.
         *         @type string|false     $group       File permissions group, or false if not available.
         *         @type int|string|false $size        Size of file in bytes. May be a numeric string.
         *                                             False if not available.
         *         @type int|string|false $lastmodunix Last modified unix timestamp. May be a numeric string.
         *                                             False if not available.
         *         @type string|false     $lastmod     Last modified month (3 letters) and day (without leading 0), or
         *                                             false if not available.
         *         @type string|false     $time        Last modified time, or false if not available.
         *         @type string           $type        Type of resource. 'f' for file, 'd' for directory, 'l' for link.
         *         @type array|false      $files       If a directory and `$recursive` is true, contains another array of
         *                                             files. False if unable to list directory contents.
         *     }
         * }
         * @phpstan-return false|array<int|string, array{
         *   name: string,
         *   perms: string,
         *   permsn: string,
         *   number: false,
         *   owner: string|false,
         *   group: string|false,
         *   size: int|string|false,
         *   lastmodunix: int|string|false,
         *   lastmod: string|false,
         *   time: string|false,
         *   type: string,
         *   files: array|false,
         * }>
         * @phpstan-return false|array<string, array{name: string, perms: string, permsn: string, owner: string|false, size: int|string|false, lastmodunix: int|string|false, lastmod: string|false, time: string|false, type: 'f'|'d'|'l', group: string|false, number: int|string|false, files?: array|false}>
         */
        public function dirlist($path, $include_hidden = \true, $recursive = \false)
        {
        }
    }
    /**
     * WP_Importer base class
     */
    #[\AllowDynamicProperties]
    class WP_Importer
    {
        /**
         * Class Constructor
         */
        public function __construct()
        {
        }
        /**
         * Returns array with imported permalinks from WordPress database.
         *
         * @global wpdb $wpdb WordPress database abstraction object.
         *
         * @param string $importer_name
         * @param string $blog_id
         * @return array
         */
        public function get_imported_posts($importer_name, $blog_id)
        {
        }
        /**
         * Returns count of imported permalinks from WordPress database.
         *
         * @global wpdb $wpdb WordPress database abstraction object.
         *
         * @param string $importer_name
         * @param string $blog_id
         * @return int
         */
        public function count_imported_posts($importer_name, $blog_id)
        {
        }
        /**
         * Sets array with imported comments from WordPress database.
         *
         * @global wpdb $wpdb WordPress database abstraction object.
         *
         * @param string $blog_id
         * @return array
         */
        public function get_imported_comments($blog_id)
        {
        }
        /**
         * @param int $blog_id
         * @return int|void
         */
        public function set_blog($blog_id)
        {
        }
        /**
         * @param int $user_id
         * @return int|void
         */
        public function set_user($user_id)
        {
        }
        /**
         * Sorts by strlen, longest string first.
         *
         * @param string $a
         * @param string $b
         * @return int
         */
        public function cmpr_strlen($a, $b)
        {
        }
        /**
         * Gets URL.
         *
         * @param string $url
         * @param string $username
         * @param string $password
         * @param bool   $head
         * @return array
         */
        public function get_page(
            $url,
            $username = '',
            #[\SensitiveParameter]
            $password = '',
            $head = \false
        )
        {
        }
        /**
         * Bumps up the request timeout for http requests.
         *
         * @param int $val
         * @return int
         */
        public function bump_request_timeout($val)
        {
        }
        /**
         * Checks if user has exceeded disk quota.
         *
         * @return bool
         */
        public function is_user_over_quota()
        {
        }
        /**
         * Replaces newlines, tabs, and multiple spaces with a single space.
         *
         * @param string $text
         * @return string
         */
        public function min_whitespace($text)
        {
        }
        /**
         * Resets global variables that grow out of control during imports.
         *
         * @since 3.0.0
         *
         * @global wpdb  $wpdb       WordPress database abstraction object.
         * @global int[] $wp_actions
         */
        public function stop_the_insanity()
        {
        }
    }
    /**
     * Core class used to implement an internal admin pointers API.
     *
     * @since 3.3.0
     */
    #[\AllowDynamicProperties]
    final class WP_Internal_Pointers
    {
        /**
         * Initializes the new feature pointers.
         *
         * @since 3.3.0
         *
         * All pointers can be disabled using the following:
         *     remove_action( 'admin_enqueue_scripts', array( 'WP_Internal_Pointers', 'enqueue_scripts' ) );
         *
         * Individual pointers (e.g. wp390_widgets) can be disabled using the following:
         *
         *    function yourprefix_remove_pointers() {
         *        remove_action(
         *            'admin_print_footer_scripts',
         *            array( 'WP_Internal_Pointers', 'pointer_wp390_widgets' )
         *        );
         *    }
         *    add_action( 'admin_enqueue_scripts', 'yourprefix_remove_pointers', 11 );
         *
         * @param string $hook_suffix The current admin page.
         * @phpstan-return void
         */
        public static function enqueue_scripts($hook_suffix)
        {
        }
        public static function pointer_wp330_toolbar()
        {
        }
        public static function pointer_wp330_media_uploader()
        {
        }
        public static function pointer_wp330_saving_widgets()
        {
        }
        public static function pointer_wp340_customize_current_theme_link()
        {
        }
        public static function pointer_wp340_choose_image_from_library()
        {
        }
        public static function pointer_wp350_media()
        {
        }
        public static function pointer_wp360_revisions()
        {
        }
        public static function pointer_wp360_locks()
        {
        }
        public static function pointer_wp390_widgets()
        {
        }
        public static function pointer_wp410_dfw()
        {
        }
        public static function pointer_wp496_privacy()
        {
        }
        /**
         * Prevents new users from seeing existing 'new feature' pointers.
         *
         * @since 3.3.0
         *
         * @param int $user_id User ID.
         */
        public static function dismiss_pointers_for_new_users($user_id)
        {
        }
    }
    /**
     * Core class used to implement displaying links in a list table.
     *
     * @since 3.1.0
     *
     * @see WP_List_Table
     */
    class WP_Links_List_Table extends \WP_List_Table
    {
        /**
         * Constructor.
         *
         * @since 3.1.0
         *
         * @see WP_List_Table::__construct() for more information on default arguments.
         *
         * @param array $args An associative array of arguments.
         */
        public function __construct($args = array())
        {
        }
        /**
         * @return bool
         */
        public function ajax_user_can()
        {
        }
        /**
         * @global int    $cat_id
         * @global string $s
         * @global string $orderby
         * @global string $order
         */
        public function prepare_items()
        {
        }
        /**
         */
        public function no_items()
        {
        }
        /**
         * @return array
         */
        protected function get_bulk_actions()
        {
        }
        /**
         * @global int $cat_id
         * @param string $which
         * @phpstan-return void
         */
        protected function extra_tablenav($which)
        {
        }
        /**
         * @return string[] Array of column titles keyed by their column name.
         */
        public function get_columns()
        {
        }
        /**
         * @return array
         */
        protected function get_sortable_columns()
        {
        }
        /**
         * Gets the name of the default primary column.
         *
         * @since 4.3.0
         *
         * @return string Name of the default primary column, in this case, 'name'.
         */
        protected function get_default_primary_column_name()
        {
        }
        /**
         * Handles the checkbox column output.
         *
         * @since 4.3.0
         * @since 5.9.0 Renamed `$link` to `$item` to match parent class for PHP 8 named parameter support.
         *
         * @param object $item The current link object.
         */
        public function column_cb($item)
        {
        }
        /**
         * Handles the link name column output.
         *
         * @since 4.3.0
         *
         * @param object $link The current link object.
         */
        public function column_name($link)
        {
        }
        /**
         * Handles the link URL column output.
         *
         * @since 4.3.0
         *
         * @param object $link The current link object.
         */
        public function column_url($link)
        {
        }
        /**
         * Handles the link categories column output.
         *
         * @since 4.3.0
         *
         * @global int $cat_id
         *
         * @param object $link The current link object.
         */
        public function column_categories($link)
        {
        }
        /**
         * Handles the link relation column output.
         *
         * @since 4.3.0
         *
         * @param object $link The current link object.
         */
        public function column_rel($link)
        {
        }
        /**
         * Handles the link visibility column output.
         *
         * @since 4.3.0
         *
         * @param object $link The current link object.
         */
        public function column_visible($link)
        {
        }
        /**
         * Handles the link rating column output.
         *
         * @since 4.3.0
         *
         * @param object $link The current link object.
         */
        public function column_rating($link)
        {
        }
        /**
         * Handles the default column output.
         *
         * @since 4.3.0
         * @since 5.9.0 Renamed `$link` to `$item` to match parent class for PHP 8 named parameter support.
         *
         * @param object $item        Link object.
         * @param string $column_name Current column name.
         */
        public function column_default($item, $column_name)
        {
        }
        /**
         * Generates the list table rows.
         *
         * @since 3.1.0
         */
        public function display_rows()
        {
        }
        /**
         * Generates and displays row action links.
         *
         * @since 4.3.0
         * @since 5.9.0 Renamed `$link` to `$item` to match parent class for PHP 8 named parameter support.
         *
         * @param object $item        Link being acted upon.
         * @param string $column_name Current column name.
         * @param string $primary     Primary column name.
         * @return string Row actions output for links, or an empty string
         *                if the current column is not the primary column.
         */
        protected function handle_row_actions($item, $column_name, $primary)
        {
        }
    }
    /**
     * Helper class to be used only by back compat functions.
     *
     * @since 3.1.0
     */
    class _WP_List_Table_Compat extends \WP_List_Table
    {
        public $_screen;
        public $_columns;
        /**
         * Constructor.
         *
         * @since 3.1.0
         *
         * @param string|WP_Screen $screen  The screen hook name or screen object.
         * @param string[]         $columns An array of columns with column IDs as the keys
         *                                  and translated column names as the values.
         */
        public function __construct($screen, $columns = array())
        {
        }
        /**
         * Gets a list of all, hidden, and sortable columns.
         *
         * @since 3.1.0
         *
         * @return array
         */
        protected function get_column_info()
        {
        }
        /**
         * Gets a list of columns.
         *
         * @since 3.1.0
         *
         * @return array
         */
        public function get_columns()
        {
        }
    }
    /**
     * Core class used to implement displaying media items in a list table.
     *
     * @since 3.1.0
     *
     * @see WP_List_Table
     */
    class WP_Media_List_Table extends \WP_List_Table
    {
        /**
         * Holds the number of pending comments for each post.
         *
         * @since 4.4.0
         * @var array
         */
        protected $comment_pending_count = array();
        /**
         * Constructor.
         *
         * @since 3.1.0
         *
         * @see WP_List_Table::__construct() for more information on default arguments.
         *
         * @param array $args An associative array of arguments.
         */
        public function __construct($args = array())
        {
        }
        /**
         * @return bool
         */
        public function ajax_user_can()
        {
        }
        /**
         * @global string   $mode                  List table view mode.
         * @global WP_Query $wp_query              WordPress Query object.
         * @global array    $post_mime_types
         * @global array    $avail_post_mime_types
         */
        public function prepare_items()
        {
        }
        /**
         * @global array $post_mime_types
         * @global array $avail_post_mime_types
         * @return array
         */
        protected function get_views()
        {
        }
        /**
         * @return array
         */
        protected function get_bulk_actions()
        {
        }
        /**
         * @param string $which
         * @phpstan-return void
         */
        protected function extra_tablenav($which)
        {
        }
        /**
         * @return string
         */
        public function current_action()
        {
        }
        /**
         * @return bool
         */
        public function has_items()
        {
        }
        /**
         */
        public function no_items()
        {
        }
        /**
         * Overrides parent views to use the filter bar display.
         *
         * @global string $mode List table view mode.
         */
        public function views()
        {
        }
        /**
         * @return string[] Array of column titles keyed by their column name.
         */
        public function get_columns()
        {
        }
        /**
         * @return array
         */
        protected function get_sortable_columns()
        {
        }
        /**
         * Handles the checkbox column output.
         *
         * @since 4.3.0
         * @since 5.9.0 Renamed `$post` to `$item` to match parent class for PHP 8 named parameter support.
         *
         * @param WP_Post $item The current WP_Post object.
         */
        public function column_cb($item)
        {
        }
        /**
         * Handles the title column output.
         *
         * @since 4.3.0
         *
         * @param WP_Post $post The current WP_Post object.
         */
        public function column_title($post)
        {
        }
        /**
         * Handles the author column output.
         *
         * @since 4.3.0
         * @since 6.8.0 Added fallback text when author's name is unknown.
         *
         * @param WP_Post $post The current WP_Post object.
         */
        public function column_author($post)
        {
        }
        /**
         * Handles the description column output.
         *
         * @since 4.3.0
         * @deprecated 6.2.0
         *
         * @param WP_Post $post The current WP_Post object.
         */
        public function column_desc($post)
        {
        }
        /**
         * Handles the date column output.
         *
         * @since 4.3.0
         *
         * @param WP_Post $post The current WP_Post object.
         */
        public function column_date($post)
        {
        }
        /**
         * Handles the parent column output.
         *
         * @since 4.3.0
         *
         * @param WP_Post $post The current WP_Post object.
         */
        public function column_parent($post)
        {
        }
        /**
         * Handles the comments column output.
         *
         * @since 4.3.0
         *
         * @param WP_Post $post The current WP_Post object.
         */
        public function column_comments($post)
        {
        }
        /**
         * Handles output for the default column.
         *
         * @since 4.3.0
         * @since 5.9.0 Renamed `$post` to `$item` to match parent class for PHP 8 named parameter support.
         *
         * @param WP_Post $item        The current WP_Post object.
         * @param string  $column_name Current column name.
         * @phpstan-return void
         */
        public function column_default($item, $column_name)
        {
        }
        /**
         * Generates the list table rows.
         *
         * @since 3.1.0
         *
         * @global WP_Post  $post     Global post object.
         * @global WP_Query $wp_query WordPress Query object.
         */
        public function display_rows()
        {
        }
        /**
         * Gets the name of the default primary column.
         *
         * @since 4.3.0
         *
         * @return string Name of the default primary column, in this case, 'title'.
         */
        protected function get_default_primary_column_name()
        {
        }
        /**
         * Generates and displays row action links.
         *
         * @since 4.3.0
         * @since 5.9.0 Renamed `$post` to `$item` to match parent class for PHP 8 named parameter support.
         *
         * @param WP_Post $item        Attachment being acted upon.
         * @param string  $column_name Current column name.
         * @param string  $primary     Primary column name.
         * @return string Row actions output for media attachments, or an empty string
         *                if the current column is not the primary column.
         */
        protected function handle_row_actions($item, $column_name, $primary)
        {
        }
    }
    /**
     * Core class used to implement displaying sites in a list table for the network admin.
     *
     * @since 3.1.0
     *
     * @see WP_List_Table
     */
    class WP_MS_Sites_List_Table extends \WP_List_Table
    {
        /**
         * Site status list.
         *
         * @since 4.3.0
         * @var array
         */
        public $status_list;
        /**
         * Constructor.
         *
         * @since 3.1.0
         *
         * @see WP_List_Table::__construct() for more information on default arguments.
         *
         * @param array $args An associative array of arguments.
         */
        public function __construct($args = array())
        {
        }
        /**
         * @return bool
         */
        public function ajax_user_can()
        {
        }
        /**
         * Prepares the list of sites for display.
         *
         * @since 3.1.0
         *
         * @global string $mode List table view mode.
         * @global string $s
         * @global wpdb   $wpdb WordPress database abstraction object.
         */
        public function prepare_items()
        {
        }
        /**
         */
        public function no_items()
        {
        }
        /**
         * Gets links to filter sites by status.
         *
         * @since 5.3.0
         *
         * @return array
         */
        protected function get_views()
        {
        }
        /**
         * @return array
         */
        protected function get_bulk_actions()
        {
        }
        /**
         * @global string $mode List table view mode.
         *
         * @param string $which The location of the pagination nav markup: Either 'top' or 'bottom'.
         * @phpstan-param 'top'|'bottom' $which
         */
        protected function pagination($which)
        {
        }
        /**
         * Displays extra controls between bulk actions and pagination.
         *
         * @since 5.3.0
         *
         * @param string $which The location of the extra table nav markup: Either 'top' or 'bottom'.
         * @phpstan-param 'top'|'bottom' $which
         */
        protected function extra_tablenav($which)
        {
        }
        /**
         * @return string[] Array of column titles keyed by their column name.
         */
        public function get_columns()
        {
        }
        /**
         * @return array
         */
        protected function get_sortable_columns()
        {
        }
        /**
         * Handles the checkbox column output.
         *
         * @since 4.3.0
         * @since 5.9.0 Renamed `$blog` to `$item` to match parent class for PHP 8 named parameter support.
         *
         * @param array $item Current site.
         */
        public function column_cb($item)
        {
        }
        /**
         * Handles the ID column output.
         *
         * @since 4.4.0
         *
         * @param array $blog Current site.
         */
        public function column_id($blog)
        {
        }
        /**
         * Handles the site name column output.
         *
         * @since 4.3.0
         *
         * @global string $mode List table view mode.
         *
         * @param array $blog Current site.
         */
        public function column_blogname($blog)
        {
        }
        /**
         * Handles the lastupdated column output.
         *
         * @since 4.3.0
         *
         * @global string $mode List table view mode.
         *
         * @param array $blog Current site.
         */
        public function column_lastupdated($blog)
        {
        }
        /**
         * Handles the registered column output.
         *
         * @since 4.3.0
         *
         * @global string $mode List table view mode.
         *
         * @param array $blog Current site.
         */
        public function column_registered($blog)
        {
        }
        /**
         * Handles the users column output.
         *
         * @since 4.3.0
         *
         * @param array $blog Current site.
         */
        public function column_users($blog)
        {
        }
        /**
         * Handles the plugins column output.
         *
         * @since 4.3.0
         *
         * @param array $blog Current site.
         */
        public function column_plugins($blog)
        {
        }
        /**
         * Handles output for the default column.
         *
         * @since 4.3.0
         * @since 5.9.0 Renamed `$blog` to `$item` to match parent class for PHP 8 named parameter support.
         *
         * @param array  $item        Current site.
         * @param string $column_name Current column name.
         */
        public function column_default($item, $column_name)
        {
        }
        /**
         * Generates the list table rows.
         *
         * @since 3.1.0
         */
        public function display_rows()
        {
        }
        /**
         * Determines whether to output comma-separated site states.
         *
         * @since 5.3.0
         *
         * @param array $site
         */
        protected function site_states($site)
        {
        }
        /**
         * Gets the name of the default primary column.
         *
         * @since 4.3.0
         *
         * @return string Name of the default primary column, in this case, 'blogname'.
         */
        protected function get_default_primary_column_name()
        {
        }
        /**
         * Generates and displays row action links.
         *
         * @since 4.3.0
         * @since 5.9.0 Renamed `$blog` to `$item` to match parent class for PHP 8 named parameter support.
         *
         * @param array  $item        Site being acted upon.
         * @param string $column_name Current column name.
         * @param string $primary     Primary column name.
         * @return string Row actions output for sites in Multisite, or an empty string
         *                if the current column is not the primary column.
         */
        protected function handle_row_actions($item, $column_name, $primary)
        {
        }
    }
    /**
     * Core class used to implement displaying themes in a list table for the network admin.
     *
     * @since 3.1.0
     *
     * @see WP_List_Table
     */
    class WP_MS_Themes_List_Table extends \WP_List_Table
    {
        public $site_id;
        public $is_site_themes;
        /**
         * Whether to show the auto-updates UI.
         *
         * @since 5.5.0
         *
         * @var bool True if auto-updates UI is to be shown, false otherwise.
         */
        protected $show_autoupdates = \true;
        /**
         * Constructor.
         *
         * @since 3.1.0
         *
         * @see WP_List_Table::__construct() for more information on default arguments.
         *
         * @global string $status
         * @global int    $page
         *
         * @param array $args An associative array of arguments.
         */
        public function __construct($args = array())
        {
        }
        /**
         * @return array
         */
        protected function get_table_classes()
        {
        }
        /**
         * @return bool
         */
        public function ajax_user_can()
        {
        }
        /**
         * @global string $status
         * @global array $totals
         * @global int $page
         * @global string $orderby
         * @global string $order
         * @global string $s
         */
        public function prepare_items()
        {
        }
        /**
         * @param WP_Theme $theme
         * @return bool
         */
        public function _search_callback($theme)
        {
        }
        /**
         * @global string $orderby
         * @global string $order
         * @param array $theme_a
         * @param array $theme_b
         * @return int
         */
        public function _order_callback($theme_a, $theme_b)
        {
        }
        /**
         */
        public function no_items()
        {
        }
        /**
         * @return string[] Array of column titles keyed by their column name.
         */
        public function get_columns()
        {
        }
        /**
         * @return array
         */
        protected function get_sortable_columns()
        {
        }
        /**
         * Gets the name of the primary column.
         *
         * @since 4.3.0
         *
         * @return string Unalterable name of the primary column name, in this case, 'name'.
         */
        protected function get_primary_column_name()
        {
        }
        /**
         * @global array $totals
         * @global string $status
         * @return array
         */
        protected function get_views()
        {
        }
        /**
         * @global string $status
         *
         * @return array
         */
        protected function get_bulk_actions()
        {
        }
        /**
         * Generates the list table rows.
         *
         * @since 3.1.0
         */
        public function display_rows()
        {
        }
        /**
         * Handles the checkbox column output.
         *
         * @since 4.3.0
         * @since 5.9.0 Renamed `$theme` to `$item` to match parent class for PHP 8 named parameter support.
         *
         * @param WP_Theme $item The current WP_Theme object.
         */
        public function column_cb($item)
        {
        }
        /**
         * Handles the name column output.
         *
         * @since 4.3.0
         *
         * @global string $status
         * @global int    $page
         * @global string $s
         *
         * @param WP_Theme $theme The current WP_Theme object.
         */
        public function column_name($theme)
        {
        }
        /**
         * Handles the description column output.
         *
         * @since 4.3.0
         *
         * @global string $status
         * @global array  $totals
         *
         * @param WP_Theme $theme The current WP_Theme object.
         */
        public function column_description($theme)
        {
        }
        /**
         * Handles the auto-updates column output.
         *
         * @since 5.5.0
         *
         * @global string $status
         * @global int  $page
         *
         * @param WP_Theme $theme The current WP_Theme object.
         */
        public function column_autoupdates($theme)
        {
        }
        /**
         * Handles default column output.
         *
         * @since 4.3.0
         * @since 5.9.0 Renamed `$theme` to `$item` to match parent class for PHP 8 named parameter support.
         *
         * @param WP_Theme $item        The current WP_Theme object.
         * @param string   $column_name The current column name.
         */
        public function column_default($item, $column_name)
        {
        }
        /**
         * Handles the output for a single table row.
         *
         * @since 4.3.0
         *
         * @param WP_Theme $item The current WP_Theme object.
         */
        public function single_row_columns($item)
        {
        }
        /**
         * @global string $status
         * @global array  $totals
         *
         * @param WP_Theme $theme
         */
        public function single_row($theme)
        {
        }
    }
    /**
     * Core class used to implement displaying users in a list table for the network admin.
     *
     * @since 3.1.0
     *
     * @see WP_List_Table
     */
    class WP_MS_Users_List_Table extends \WP_List_Table
    {
        /**
         * @return bool
         */
        public function ajax_user_can()
        {
        }
        /**
         * @global string $mode       List table view mode.
         * @global string $usersearch
         * @global string $role
         */
        public function prepare_items()
        {
        }
        /**
         * @return array
         */
        protected function get_bulk_actions()
        {
        }
        /**
         */
        public function no_items()
        {
        }
        /**
         * @global string $role
         * @return array
         */
        protected function get_views()
        {
        }
        /**
         * @global string $mode List table view mode.
         *
         * @param string $which
         */
        protected function pagination($which)
        {
        }
        /**
         * @return string[] Array of column titles keyed by their column name.
         */
        public function get_columns()
        {
        }
        /**
         * @return array
         */
        protected function get_sortable_columns()
        {
        }
        /**
         * Handles the checkbox column output.
         *
         * @since 4.3.0
         * @since 5.9.0 Renamed `$user` to `$item` to match parent class for PHP 8 named parameter support.
         *
         * @param WP_User $item The current WP_User object.
         * @phpstan-return void
         */
        public function column_cb($item)
        {
        }
        /**
         * Handles the ID column output.
         *
         * @since 4.4.0
         *
         * @param WP_User $user The current WP_User object.
         */
        public function column_id($user)
        {
        }
        /**
         * Handles the username column output.
         *
         * @since 4.3.0
         *
         * @param WP_User $user The current WP_User object.
         */
        public function column_username($user)
        {
        }
        /**
         * Handles the name column output.
         *
         * @since 4.3.0
         *
         * @param WP_User $user The current WP_User object.
         */
        public function column_name($user)
        {
        }
        /**
         * Handles the email column output.
         *
         * @since 4.3.0
         *
         * @param WP_User $user The current WP_User object.
         */
        public function column_email($user)
        {
        }
        /**
         * Handles the registered date column output.
         *
         * @since 4.3.0
         *
         * @global string $mode List table view mode.
         *
         * @param WP_User $user The current WP_User object.
         */
        public function column_registered($user)
        {
        }
        /**
         * @since 4.3.0
         *
         * @param WP_User $user
         * @param string  $classes
         * @param string  $data
         * @param string  $primary
         */
        protected function _column_blogs($user, $classes, $data, $primary)
        {
        }
        /**
         * Handles the sites column output.
         *
         * @since 4.3.0
         *
         * @param WP_User $user The current WP_User object.
         * @phpstan-return void
         */
        public function column_blogs($user)
        {
        }
        /**
         * Handles the default column output.
         *
         * @since 4.3.0
         * @since 5.9.0 Renamed `$user` to `$item` to match parent class for PHP 8 named parameter support.
         *
         * @param WP_User $item        The current WP_User object.
         * @param string  $column_name The current column name.
         */
        public function column_default($item, $column_name)
        {
        }
        /**
         * Generates the list table rows.
         *
         * @since 3.1.0
         */
        public function display_rows()
        {
        }
        /**
         * Gets the name of the default primary column.
         *
         * @since 4.3.0
         *
         * @return string Name of the default primary column, in this case, 'username'.
         */
        protected function get_default_primary_column_name()
        {
        }
        /**
         * Generates and displays row action links.
         *
         * @since 4.3.0
         * @since 5.9.0 Renamed `$user` to `$item` to match parent class for PHP 8 named parameter support.
         *
         * @param WP_User $item        User being acted upon.
         * @param string  $column_name Current column name.
         * @param string  $primary     Primary column name.
         * @return string Row actions output for users in Multisite, or an empty string
         *                if the current column is not the primary column.
         */
        protected function handle_row_actions($item, $column_name, $primary)
        {
        }
    }
    /**
     * Core class used to implement displaying plugins to install in a list table.
     *
     * @since 3.1.0
     *
     * @see WP_List_Table
     */
    class WP_Plugin_Install_List_Table extends \WP_List_Table
    {
        public $order = 'ASC';
        public $orderby = \null;
        public $groups = array();
        /**
         * @return bool
         */
        public function ajax_user_can()
        {
        }
        /**
         * Returns the list of known plugins.
         *
         * Uses the transient data from the updates API to determine the known
         * installed plugins.
         *
         * @since 4.9.0
         * @access protected
         *
         * @return array
         */
        protected function get_installed_plugins()
        {
        }
        /**
         * Returns a list of slugs of installed plugins, if known.
         *
         * Uses the transient data from the updates API to determine the slugs of
         * known installed plugins. This might be better elsewhere, perhaps even
         * within get_plugins().
         *
         * @since 4.0.0
         *
         * @return array
         */
        protected function get_installed_plugin_slugs()
        {
        }
        /**
         * @global array  $tabs
         * @global string $tab
         * @global int    $paged
         * @global string $type
         * @global string $term
         * @phpstan-return void
         */
        public function prepare_items()
        {
        }
        /**
         */
        public function no_items()
        {
        }
        /**
         * @global array $tabs
         * @global string $tab
         *
         * @return array
         */
        protected function get_views()
        {
        }
        /**
         * Overrides parent views so we can use the filter bar display.
         */
        public function views()
        {
        }
        /**
         * Displays the plugin install table.
         *
         * Overrides the parent display() method to provide a different container.
         *
         * @since 4.0.0
         */
        public function display()
        {
        }
        /**
         * @global string $tab
         *
         * @param string $which
         * @phpstan-return void
         */
        protected function display_tablenav($which)
        {
        }
        /**
         * @return array
         */
        protected function get_table_classes()
        {
        }
        /**
         * @return string[] Array of column titles keyed by their column name.
         */
        public function get_columns()
        {
        }
        /**
         * Generates the list table rows.
         *
         * @since 3.1.0
         */
        public function display_rows()
        {
        }
        /**
         * Returns a notice containing a list of dependencies required by the plugin.
         *
         * @since 6.5.0
         *
         * @param array  $plugin_data An array of plugin data. See {@see plugins_api()}
         *                            for the list of possible values.
         * @return string A notice containing a list of dependencies required by the plugin,
         *                or an empty string if none is required.
         * @phpstan-param object|array{
         *   slug?: string,
         *   per_page?: int,
         *   page?: int,
         *   number?: int,
         *   search?: string,
         *   tag?: string,
         *   author?: string,
         *   user?: string,
         *   browse?: string,
         *   locale?: string,
         *   installed_plugins?: string,
         *   is_ssl?: bool,
         *   fields?: array{
         *     short_description?: bool,
         *     description?: bool,
         *     sections?: bool,
         *     tested?: bool,
         *     requires?: bool,
         *     requires_php?: bool,
         *     rating?: bool,
         *     ratings?: bool,
         *     downloaded?: bool,
         *     downloadlink?: bool,
         *     last_updated?: bool,
         *     added?: bool,
         *     tags?: bool,
         *     compatibility?: bool,
         *     homepage?: bool,
         *     versions?: bool,
         *     donate_link?: bool,
         *     reviews?: bool,
         *     banners?: bool,
         *     icons?: bool,
         *     active_installs?: bool,
         *     contributors?: bool,
         *   },
         * } $plugin_data See plugins_api()
         */
        protected function get_dependencies_notice($plugin_data)
        {
        }
        /**
         * Creates a 'More details' link for the plugin.
         *
         * @since 6.5.0
         *
         * @param string $name The plugin's name.
         * @param string $slug The plugin's slug.
         * @return string The 'More details' link for the plugin.
         */
        protected function get_more_details_link($name, $slug)
        {
        }
    }
    /**
     * Core class used to implement displaying installed plugins in a list table.
     *
     * @since 3.1.0
     *
     * @see WP_List_Table
     */
    class WP_Plugins_List_Table extends \WP_List_Table
    {
        /**
         * Whether to show the auto-updates UI.
         *
         * @since 5.5.0
         *
         * @var bool True if auto-updates UI is to be shown, false otherwise.
         */
        protected $show_autoupdates = \true;
        /**
         * Constructor.
         *
         * @since 3.1.0
         *
         * @see WP_List_Table::__construct() for more information on default arguments.
         *
         * @global string $status
         * @global int    $page
         *
         * @param array $args An associative array of arguments.
         */
        public function __construct($args = array())
        {
        }
        /**
         * @return array
         */
        protected function get_table_classes()
        {
        }
        /**
         * @return bool
         */
        public function ajax_user_can()
        {
        }
        /**
         * @global string $status
         * @global array  $plugins
         * @global array  $totals
         * @global int    $page
         * @global string $orderby
         * @global string $order
         * @global string $s
         */
        public function prepare_items()
        {
        }
        /**
         * @global string $s URL encoded search term.
         *
         * @param array $plugin
         * @return bool
         */
        public function _search_callback($plugin)
        {
        }
        /**
         * @global string $orderby
         * @global string $order
         * @param array $plugin_a
         * @param array $plugin_b
         * @return int
         */
        public function _order_callback($plugin_a, $plugin_b)
        {
        }
        /**
         * @global array $plugins
         */
        public function no_items()
        {
        }
        /**
         * Displays the search box.
         *
         * @since 4.6.0
         *
         * @param string $text     The 'submit' button label.
         * @param string $input_id ID attribute value for the search input field.
         * @phpstan-return void
         */
        public function search_box($text, $input_id)
        {
        }
        /**
         * @global string $status
         *
         * @return string[] Array of column titles keyed by their column name.
         */
        public function get_columns()
        {
        }
        /**
         * @return array
         */
        protected function get_sortable_columns()
        {
        }
        /**
         * @global array $totals
         * @global string $status
         * @return array
         */
        protected function get_views()
        {
        }
        /**
         * @global string $status
         * @return array
         */
        protected function get_bulk_actions()
        {
        }
        /**
         * @global string $status
         * @param string $which
         * @phpstan-return void
         */
        public function bulk_actions($which = '')
        {
        }
        /**
         * @global string $status
         * @param string $which
         * @phpstan-return void
         */
        protected function extra_tablenav($which)
        {
        }
        /**
         * @return string
         */
        public function current_action()
        {
        }
        /**
         * Generates the list table rows.
         *
         * @since 3.1.0
         *
         * @global string $status
         * @phpstan-return void
         */
        public function display_rows()
        {
        }
        /**
         * @global string $status
         * @global int $page
         * @global string $s
         * @global array $totals
         *
         * @param array $item
         */
        public function single_row($item)
        {
        }
        /**
         * Gets the name of the primary column for this specific list table.
         *
         * @since 4.3.0
         *
         * @return string Unalterable name for the primary column, in this case, 'name'.
         */
        protected function get_primary_column_name()
        {
        }
        /**
         * Prints a list of other plugins that depend on the plugin.
         *
         * @since 6.5.0
         *
         * @param string $dependency The dependency's filepath, relative to the plugins directory.
         * @phpstan-return void
         */
        protected function add_dependents_to_dependency_plugin_row($dependency)
        {
        }
        /**
         * Prints a list of other plugins that the plugin depends on.
         *
         * @since 6.5.0
         *
         * @param string $dependent The dependent plugin's filepath, relative to the plugins directory.
         * @phpstan-return void
         */
        protected function add_dependencies_to_dependent_plugin_row($dependent)
        {
        }
        /**
         * Returns a 'View details' like link for a dependency.
         *
         * @since 6.5.0
         *
         * @param string $name The dependency's name.
         * @param string $slug The dependency's slug.
         * @return string A 'View details' link for the dependency.
         */
        protected function get_dependency_view_details_link($name, $slug)
        {
        }
        /**
         * Returns a 'View details' link for the plugin.
         *
         * @since 6.5.0
         *
         * @param string $name The plugin's name.
         * @param string $slug The plugin's slug.
         * @return string A 'View details' link for the plugin.
         */
        protected function get_view_details_link($name, $slug)
        {
        }
    }
    /**
     * Core class used to implement displaying post comments in a list table.
     *
     * @since 3.1.0
     *
     * @see WP_Comments_List_Table
     */
    class WP_Post_Comments_List_Table extends \WP_Comments_List_Table
    {
        /**
         * @return array
         */
        protected function get_column_info()
        {
        }
        /**
         * @return array
         */
        protected function get_table_classes()
        {
        }
        /**
         * @param bool $output_empty
         */
        public function display($output_empty = \false)
        {
        }
        /**
         * @param bool $comment_status
         * @return int
         */
        public function get_per_page($comment_status = \false)
        {
        }
    }
    /**
     * Core class used to implement displaying posts in a list table.
     *
     * @since 3.1.0
     *
     * @see WP_List_Table
     */
    class WP_Posts_List_Table extends \WP_List_Table
    {
        /**
         * Whether the items should be displayed hierarchically or linearly.
         *
         * @since 3.1.0
         * @var bool
         */
        protected $hierarchical_display;
        /**
         * Holds the number of pending comments for each post.
         *
         * @since 3.1.0
         * @var array
         */
        protected $comment_pending_count;
        /**
         * Current level for output.
         *
         * @since 4.3.0
         * @var int
         */
        protected $current_level = 0;
        /**
         * Constructor.
         *
         * @since 3.1.0
         *
         * @see WP_List_Table::__construct() for more information on default arguments.
         *
         * @global WP_Post_Type $post_type_object Global post type object.
         * @global wpdb         $wpdb             WordPress database abstraction object.
         *
         * @param array $args An associative array of arguments.
         */
        public function __construct($args = array())
        {
        }
        /**
         * Sets whether the table layout should be hierarchical or not.
         *
         * @since 4.2.0
         *
         * @param bool $display Whether the table layout should be hierarchical.
         */
        public function set_hierarchical_display($display)
        {
        }
        /**
         * @return bool
         */
        public function ajax_user_can()
        {
        }
        /**
         * @global string   $mode             List table view mode.
         * @global array    $avail_post_stati
         * @global WP_Query $wp_query         WordPress Query object.
         * @global int      $per_page
         */
        public function prepare_items()
        {
        }
        /**
         * @return bool
         */
        public function has_items()
        {
        }
        /**
         */
        public function no_items()
        {
        }
        /**
         * Determines if the current view is the "All" view.
         *
         * @since 4.2.0
         *
         * @return bool Whether the current view is the "All" view.
         */
        protected function is_base_request()
        {
        }
        /**
         * Creates a link to edit.php with params.
         *
         * @since 4.4.0
         *
         * @param string[] $args      Associative array of URL parameters for the link.
         * @param string   $link_text Link text.
         * @param string   $css_class Optional. Class attribute. Default empty string.
         * @return string The formatted link string.
         */
        protected function get_edit_link($args, $link_text, $css_class = '')
        {
        }
        /**
         * @global array $locked_post_status This seems to be deprecated.
         * @global array $avail_post_stati
         * @return array
         */
        protected function get_views()
        {
        }
        /**
         * @return array
         */
        protected function get_bulk_actions()
        {
        }
        /**
         * Displays a categories drop-down for filtering on the Posts list table.
         *
         * @since 4.6.0
         *
         * @global int $cat Currently selected category.
         *
         * @param string $post_type Post type slug.
         * @phpstan-return void
         */
        protected function categories_dropdown($post_type)
        {
        }
        /**
         * Displays a formats drop-down for filtering items.
         *
         * @since 5.2.0
         * @access protected
         *
         * @param string $post_type Post type slug.
         * @phpstan-return void
         */
        protected function formats_dropdown($post_type)
        {
        }
        /**
         * @param string $which
         */
        protected function extra_tablenav($which)
        {
        }
        /**
         * @return string
         */
        public function current_action()
        {
        }
        /**
         * @global string $mode List table view mode.
         *
         * @return array
         */
        protected function get_table_classes()
        {
        }
        /**
         * @return string[] Array of column titles keyed by their column name.
         */
        public function get_columns()
        {
        }
        /**
         * @return array
         */
        protected function get_sortable_columns()
        {
        }
        /**
         * Generates the list table rows.
         *
         * @since 3.1.0
         *
         * @global WP_Query $wp_query WordPress Query object.
         * @global int      $per_page
         *
         * @param array $posts
         * @param int   $level
         */
        public function display_rows($posts = array(), $level = 0)
        {
        }
        /**
         * Handles the checkbox column output.
         *
         * @since 4.3.0
         * @since 5.9.0 Renamed `$post` to `$item` to match parent class for PHP 8 named parameter support.
         *
         * @param WP_Post $item The current WP_Post object.
         */
        public function column_cb($item)
        {
        }
        /**
         * @since 4.3.0
         *
         * @param WP_Post $post
         * @param string  $classes
         * @param string  $data
         * @param string  $primary
         */
        protected function _column_title($post, $classes, $data, $primary)
        {
        }
        /**
         * Handles the title column output.
         *
         * @since 4.3.0
         *
         * @global string $mode List table view mode.
         *
         * @param WP_Post $post The current WP_Post object.
         */
        public function column_title($post)
        {
        }
        /**
         * Handles the post date column output.
         *
         * @since 4.3.0
         *
         * @global string $mode List table view mode.
         *
         * @param WP_Post $post The current WP_Post object.
         */
        public function column_date($post)
        {
        }
        /**
         * Handles the comments column output.
         *
         * @since 4.3.0
         *
         * @param WP_Post $post The current WP_Post object.
         */
        public function column_comments($post)
        {
        }
        /**
         * Handles the post author column output.
         *
         * @since 4.3.0
         * @since 6.8.0 Added fallback text when author's name is unknown.
         *
         * @param WP_Post $post The current WP_Post object.
         */
        public function column_author($post)
        {
        }
        /**
         * Handles the default column output.
         *
         * @since 4.3.0
         * @since 5.9.0 Renamed `$post` to `$item` to match parent class for PHP 8 named parameter support.
         *
         * @param WP_Post $item        The current WP_Post object.
         * @param string  $column_name The current column name.
         * @phpstan-return void
         */
        public function column_default($item, $column_name)
        {
        }
        /**
         * @global WP_Post $post Global post object.
         *
         * @param int|WP_Post $post
         * @param int         $level
         */
        public function single_row($post, $level = 0)
        {
        }
        /**
         * Gets the name of the default primary column.
         *
         * @since 4.3.0
         *
         * @return string Name of the default primary column, in this case, 'title'.
         */
        protected function get_default_primary_column_name()
        {
        }
        /**
         * Generates and displays row action links.
         *
         * @since 4.3.0
         * @since 5.9.0 Renamed `$post` to `$item` to match parent class for PHP 8 named parameter support.
         *
         * @param WP_Post $item        Post being acted upon.
         * @param string  $column_name Current column name.
         * @param string  $primary     Primary column name.
         * @return string Row actions output for posts, or an empty string
         *                if the current column is not the primary column.
         */
        protected function handle_row_actions($item, $column_name, $primary)
        {
        }
        /**
         * Outputs the hidden row displayed when inline editing
         *
         * @since 3.1.0
         *
         * @global string $mode List table view mode.
         */
        public function inline_edit()
        {
        }
    }
    /**
     * List Table API: WP_Privacy_Requests_Table class
     *
     * @package WordPress
     * @subpackage Administration
     * @since 4.9.6
     */
    abstract class WP_Privacy_Requests_Table extends \WP_List_Table
    {
        /**
         * Action name for the requests this table will work with. Classes
         * which inherit from WP_Privacy_Requests_Table should define this.
         *
         * Example: 'export_personal_data'.
         *
         * @since 4.9.6
         *
         * @var string $request_type Name of action.
         */
        protected $request_type = 'INVALID';
        /**
         * Post type to be used.
         *
         * @since 4.9.6
         *
         * @var string $post_type The post type.
         */
        protected $post_type = 'INVALID';
        /**
         * Gets columns to show in the list table.
         *
         * @since 4.9.6
         *
         * @return string[] Array of column titles keyed by their column name.
         */
        public function get_columns()
        {
        }
        /**
         * Normalizes the admin URL to the current page (by request_type).
         *
         * @since 5.3.0
         *
         * @return string URL to the current admin page.
         */
        protected function get_admin_url()
        {
        }
        /**
         * Gets a list of sortable columns.
         *
         * @since 4.9.6
         *
         * @return array Default sortable columns.
         */
        protected function get_sortable_columns()
        {
        }
        /**
         * Returns the default primary column.
         *
         * @since 4.9.6
         *
         * @return string Default primary column name.
         */
        protected function get_default_primary_column_name()
        {
        }
        /**
         * Counts the number of requests for each status.
         *
         * @since 4.9.6
         *
         * @global wpdb $wpdb WordPress database abstraction object.
         *
         * @return object Number of posts for each status.
         */
        protected function get_request_counts()
        {
        }
        /**
         * Gets an associative array ( id => link ) with the list of views available on this table.
         *
         * @since 4.9.6
         *
         * @return string[] An array of HTML links keyed by their view.
         */
        protected function get_views()
        {
        }
        /**
         * Gets bulk actions.
         *
         * @since 4.9.6
         *
         * @return array Array of bulk action labels keyed by their action.
         */
        protected function get_bulk_actions()
        {
        }
        /**
         * Process bulk actions.
         *
         * @since 4.9.6
         * @since 5.6.0 Added support for the `complete` action.
         * @phpstan-return void
         */
        public function process_bulk_action()
        {
        }
        /**
         * Prepares items to output.
         *
         * @since 4.9.6
         * @since 5.1.0 Added support for column sorting.
         */
        public function prepare_items()
        {
        }
        /**
         * Returns the markup for the Checkbox column.
         *
         * @since 4.9.6
         *
         * @param WP_User_Request $item Item being shown.
         * @return string Checkbox column markup.
         */
        public function column_cb($item)
        {
        }
        /**
         * Status column.
         *
         * @since 4.9.6
         *
         * @param WP_User_Request $item Item being shown.
         * @return string|void Status column markup. Returns a string if no status is found,
         *                     otherwise it displays the markup.
         */
        public function column_status($item)
        {
        }
        /**
         * Converts a timestamp for display.
         *
         * @since 4.9.6
         *
         * @param int $timestamp Event timestamp.
         * @return string Human readable date.
         */
        protected function get_timestamp_as_date($timestamp)
        {
        }
        /**
         * Handles the default column.
         *
         * @since 4.9.6
         * @since 5.7.0 Added `manage_{$this->screen->id}_custom_column` action.
         *
         * @param WP_User_Request $item        Item being shown.
         * @param string          $column_name Name of column being shown.
         */
        public function column_default($item, $column_name)
        {
        }
        /**
         * Returns the markup for the Created timestamp column. Overridden by children.
         *
         * @since 5.7.0
         *
         * @param WP_User_Request $item Item being shown.
         * @return string Human readable date.
         */
        public function column_created_timestamp($item)
        {
        }
        /**
         * Actions column. Overridden by children.
         *
         * @since 4.9.6
         *
         * @param WP_User_Request $item Item being shown.
         * @return string Email column markup.
         */
        public function column_email($item)
        {
        }
        /**
         * Returns the markup for the next steps column. Overridden by children.
         *
         * @since 4.9.6
         *
         * @param WP_User_Request $item Item being shown.
         */
        public function column_next_steps($item)
        {
        }
        /**
         * Generates content for a single row of the table,
         *
         * @since 4.9.6
         *
         * @param WP_User_Request $item The current item.
         */
        public function single_row($item)
        {
        }
        /**
         * Embeds scripts used to perform actions. Overridden by children.
         *
         * @since 4.9.6
         */
        public function embed_scripts()
        {
        }
    }
    /**
     * WP_Privacy_Data_Export_Requests_Table class.
     *
     * @since 4.9.6
     */
    class WP_Privacy_Data_Export_Requests_List_Table extends \WP_Privacy_Requests_Table
    {
        /**
         * Action name for the requests this table will work with.
         *
         * @since 4.9.6
         *
         * @var string $request_type Name of action.
         */
        protected $request_type = 'export_personal_data';
        /**
         * Post type for the requests.
         *
         * @since 4.9.6
         *
         * @var string $post_type The post type.
         */
        protected $post_type = 'user_request';
        /**
         * Actions column.
         *
         * @since 4.9.6
         *
         * @param WP_User_Request $item Item being shown.
         * @return string Email column markup.
         */
        public function column_email($item)
        {
        }
        /**
         * Displays the next steps column.
         *
         * @since 4.9.6
         *
         * @param WP_User_Request $item Item being shown.
         */
        public function column_next_steps($item)
        {
        }
    }
    /**
     * WP_Privacy_Data_Removal_Requests_List_Table class.
     *
     * @since 4.9.6
     */
    class WP_Privacy_Data_Removal_Requests_List_Table extends \WP_Privacy_Requests_Table
    {
        /**
         * Action name for the requests this table will work with.
         *
         * @since 4.9.6
         *
         * @var string $request_type Name of action.
         */
        protected $request_type = 'remove_personal_data';
        /**
         * Post type for the requests.
         *
         * @since 4.9.6
         *
         * @var string $post_type The post type.
         */
        protected $post_type = 'user_request';
        /**
         * Outputs the Actions column.
         *
         * @since 4.9.6
         *
         * @param WP_User_Request $item Item being shown.
         * @return string Email column markup.
         */
        public function column_email($item)
        {
        }
        /**
         * Outputs the Next steps column.
         *
         * @since 4.9.6
         *
         * @param WP_User_Request $item Item being shown.
         */
        public function column_next_steps($item)
        {
        }
    }
    /**
     * WP_Privacy_Policy_Content class.
     *
     * @package WordPress
     * @subpackage Administration
     * @since 4.9.6
     */
    #[\AllowDynamicProperties]
    final class WP_Privacy_Policy_Content
    {
        /**
         * Adds content to the postbox shown when editing the privacy policy.
         *
         * Plugins and themes should suggest text for inclusion in the site's privacy policy.
         * The suggested text should contain information about any functionality that affects user privacy,
         * and will be shown in the Suggested Privacy Policy Content postbox.
         *
         * Intended for use from `wp_add_privacy_policy_content()`.
         *
         * @since 4.9.6
         *
         * @param string $plugin_name The name of the plugin or theme that is suggesting content for the site's privacy policy.
         * @param string $policy_text The suggested content for inclusion in the policy.
         * @phpstan-return void
         */
        public static function add($plugin_name, $policy_text)
        {
        }
        /**
         * Performs a quick check to determine whether any privacy info has changed.
         *
         * @since 4.9.6
         */
        public static function text_change_check()
        {
        }
        /**
         * Outputs a warning when some privacy info has changed.
         *
         * @since 4.9.6
         * @phpstan-return void
         */
        public static function policy_text_changed_notice()
        {
        }
        /**
         * Updates the cached policy info when the policy page is updated.
         *
         * @since 4.9.6
         * @access private
         *
         * @param int $post_id The ID of the updated post.
         * @phpstan-return void
         */
        public static function _policy_page_updated($post_id)
        {
        }
        /**
         * Checks for updated, added or removed privacy policy information from plugins.
         *
         * Caches the current info in post_meta of the policy page.
         *
         * @since 4.9.6
         *
         * @return array The privacy policy text/information added by core and plugins.
         */
        public static function get_suggested_policy_text()
        {
        }
        /**
         * Adds a notice with a link to the guide when editing the privacy policy page.
         *
         * @since 4.9.6
         * @since 5.0.0 The `$post` parameter was made optional.
         *
         * @global WP_Post $post Global post object.
         *
         * @param WP_Post|null $post The currently edited post. Default null.
         * @phpstan-return void
         */
        public static function notice($post = \null)
        {
        }
        /**
         * Outputs the privacy policy guide together with content from the theme and plugins.
         *
         * @since 4.9.6
         */
        public static function privacy_policy_guide()
        {
        }
        /**
         * Returns the default suggested privacy policy content.
         *
         * @since 4.9.6
         * @since 5.0.0 Added the `$blocks` parameter.
         *
         * @param bool $description Whether to include the descriptions under the section headings. Default false.
         * @param bool $blocks      Whether to format the content for the block editor. Default true.
         * @return string The default policy content.
         */
        public static function get_default_content($description = \false, $blocks = \true)
        {
        }
        /**
         * Adds the suggested privacy policy text to the policy postbox.
         *
         * @since 4.9.6
         */
        public static function add_suggested_content()
        {
        }
    }
    /**
     * Core class used to implement an admin screen API.
     *
     * @since 3.3.0
     */
    #[\AllowDynamicProperties]
    final class WP_Screen
    {
        /**
         * Any action associated with the screen.
         *
         * 'add' for *-add.php and *-new.php screens. Empty otherwise.
         *
         * @since 3.3.0
         * @var string
         */
        public $action;
        /**
         * The base type of the screen.
         *
         * This is typically the same as `$id` but with any post types and taxonomies stripped.
         * For example, for an `$id` of 'edit-post' the base is 'edit'.
         *
         * @since 3.3.0
         * @var string
         */
        public $base;
        /**
         * The unique ID of the screen.
         *
         * @since 3.3.0
         * @var string
         */
        public $id;
        /**
         * Whether the screen is in the network admin.
         *
         * Deprecated. Use in_admin() instead.
         *
         * @since 3.3.0
         * @deprecated 3.5.0
         * @var bool
         */
        public $is_network;
        /**
         * Whether the screen is in the user admin.
         *
         * Deprecated. Use in_admin() instead.
         *
         * @since 3.3.0
         * @deprecated 3.5.0
         * @var bool
         */
        public $is_user;
        /**
         * The base menu parent.
         *
         * This is derived from `$parent_file` by removing the query string and any .php extension.
         * `$parent_file` values of 'edit.php?post_type=page' and 'edit.php?post_type=post'
         * have a `$parent_base` of 'edit'.
         *
         * @since 3.3.0
         * @var string|null
         */
        public $parent_base;
        /**
         * The parent_file for the screen per the admin menu system.
         *
         * Some `$parent_file` values are 'edit.php?post_type=page', 'edit.php', and 'options-general.php'.
         *
         * @since 3.3.0
         * @var string|null
         */
        public $parent_file;
        /**
         * The post type associated with the screen, if any.
         *
         * The 'edit.php?post_type=page' screen has a post type of 'page'.
         * The 'edit-tags.php?taxonomy=$taxonomy&post_type=page' screen has a post type of 'page'.
         *
         * @since 3.3.0
         * @var string
         */
        public $post_type;
        /**
         * The taxonomy associated with the screen, if any.
         *
         * The 'edit-tags.php?taxonomy=category' screen has a taxonomy of 'category'.
         *
         * @since 3.3.0
         * @var string
         */
        public $taxonomy;
        /**
         * Whether the screen is using the block editor.
         *
         * @since 5.0.0
         * @var bool
         */
        public $is_block_editor = \false;
        /**
         * Fetches a screen object.
         *
         * @since 3.3.0
         *
         * @global string $hook_suffix
         *
         * @param string|WP_Screen $hook_name Optional. The hook name (also known as the hook suffix) used to determine the screen.
         *                                    Defaults to the current $hook_suffix global.
         * @return WP_Screen Screen object.
         */
        public static function get($hook_name = '')
        {
        }
        /**
         * Makes the screen object the current screen.
         *
         * @see set_current_screen()
         * @since 3.3.0
         *
         * @global WP_Screen $current_screen WordPress current screen object.
         * @global string    $typenow        The post type of the current screen.
         * @global string    $taxnow         The taxonomy of the current screen.
         */
        public function set_current_screen()
        {
        }
        /**
         * Indicates whether the screen is in a particular admin.
         *
         * @since 3.5.0
         *
         * @param string $admin The admin to check against (network | user | site).
         *                      If empty any of the three admins will result in true.
         * @return bool True if the screen is in the indicated admin, false otherwise.
         */
        public function in_admin($admin = \null)
        {
        }
        /**
         * Sets or returns whether the block editor is loading on the current screen.
         *
         * @since 5.0.0
         *
         * @param bool $set Optional. Sets whether the block editor is loading on the current screen or not.
         * @return bool True if the block editor is being loaded, false otherwise.
         */
        public function is_block_editor($set = \null)
        {
        }
        /**
         * Sets the old string-based contextual help for the screen for backward compatibility.
         *
         * @since 3.3.0
         *
         * @param WP_Screen $screen A screen object.
         * @param string    $help   Help text.
         */
        public static function add_old_compat_help($screen, $help)
        {
        }
        /**
         * Sets the parent information for the screen.
         *
         * This is called in admin-header.php after the menu parent for the screen has been determined.
         *
         * @since 3.3.0
         *
         * @param string $parent_file The parent file of the screen. Typically the $parent_file global.
         */
        public function set_parentage($parent_file)
        {
        }
        /**
         * Adds an option for the screen.
         *
         * Call this in template files after admin.php is loaded and before admin-header.php is loaded
         * to add screen options.
         *
         * @since 3.3.0
         *
         * @param string $option Option ID.
         * @param mixed  $args   Option-dependent arguments.
         */
        public function add_option($option, $args = array())
        {
        }
        /**
         * Removes an option from the screen.
         *
         * @since 3.8.0
         *
         * @param string $option Option ID.
         */
        public function remove_option($option)
        {
        }
        /**
         * Removes all options from the screen.
         *
         * @since 3.8.0
         */
        public function remove_options()
        {
        }
        /**
         * Gets the options registered for the screen.
         *
         * @since 3.8.0
         *
         * @return array Options with arguments.
         */
        public function get_options()
        {
        }
        /**
         * Gets the arguments for an option for the screen.
         *
         * @since 3.3.0
         *
         * @param string       $option Option name.
         * @param string|false $key    Optional. Specific array key for when the option is an array.
         *                             Default false.
         * @return string The option value if set, null otherwise.
         */
        public function get_option($option, $key = \false)
        {
        }
        /**
         * Gets the help tabs registered for the screen.
         *
         * @since 3.4.0
         * @since 4.4.0 Help tabs are ordered by their priority.
         *
         * @return array Help tabs with arguments.
         */
        public function get_help_tabs()
        {
        }
        /**
         * Gets the arguments for a help tab.
         *
         * @since 3.4.0
         *
         * @param string $id Help Tab ID.
         * @return array Help tab arguments.
         */
        public function get_help_tab($id)
        {
        }
        /**
         * Adds a help tab to the contextual help for the screen.
         *
         * Call this on the `load-$pagenow` hook for the relevant screen,
         * or fetch the `$current_screen` object, or use get_current_screen()
         * and then call the method from the object.
         *
         * You may need to filter `$current_screen` using an if or switch statement
         * to prevent new help tabs from being added to ALL admin screens.
         *
         * @since 3.3.0
         * @since 4.4.0 The `$priority` argument was added.
         *
         * @param array $args {
         *     Array of arguments used to display the help tab.
         *
         *     @type string   $title    Title for the tab. Default false.
         *     @type string   $id       Tab ID. Must be HTML-safe and should be unique for this menu.
         *                              It is NOT allowed to contain any empty spaces. Default false.
         *     @type string   $content  Optional. Help tab content in plain text or HTML. Default empty string.
         *     @type callable $callback Optional. A callback to generate the tab content. Default false.
         *     @type int      $priority Optional. The priority of the tab, used for ordering. Default 10.
         * }
         * @phpstan-param array{
         *   title?: string,
         *   id?: string,
         *   content?: string,
         *   callback?: callable,
         *   priority?: int,
         * } $args
         * @phpstan-return void
         */
        public function add_help_tab($args)
        {
        }
        /**
         * Removes a help tab from the contextual help for the screen.
         *
         * @since 3.3.0
         *
         * @param string $id The help tab ID.
         */
        public function remove_help_tab($id)
        {
        }
        /**
         * Removes all help tabs from the contextual help for the screen.
         *
         * @since 3.3.0
         */
        public function remove_help_tabs()
        {
        }
        /**
         * Gets the content from a contextual help sidebar.
         *
         * @since 3.4.0
         *
         * @return string Contents of the help sidebar.
         */
        public function get_help_sidebar()
        {
        }
        /**
         * Adds a sidebar to the contextual help for the screen.
         *
         * Call this in template files after admin.php is loaded and before admin-header.php is loaded
         * to add a sidebar to the contextual help.
         *
         * @since 3.3.0
         *
         * @param string $content Sidebar content in plain text or HTML.
         */
        public function set_help_sidebar($content)
        {
        }
        /**
         * Gets the number of layout columns the user has selected.
         *
         * The layout_columns option controls the max number and default number of
         * columns. This method returns the number of columns within that range selected
         * by the user via Screen Options. If no selection has been made, the default
         * provisioned in layout_columns is returned. If the screen does not support
         * selecting the number of layout columns, 0 is returned.
         *
         * @since 3.4.0
         *
         * @return int Number of columns to display.
         */
        public function get_columns()
        {
        }
        /**
         * Gets the accessible hidden headings and text used in the screen.
         *
         * @since 4.4.0
         *
         * @see set_screen_reader_content() For more information on the array format.
         *
         * @return string[] An associative array of screen reader text strings.
         */
        public function get_screen_reader_content()
        {
        }
        /**
         * Gets a screen reader text string.
         *
         * @since 4.4.0
         *
         * @param string $key Screen reader text array named key.
         * @return string Screen reader text string.
         */
        public function get_screen_reader_text($key)
        {
        }
        /**
         * Adds accessible hidden headings and text for the screen.
         *
         * @since 4.4.0
         *
         * @param array $content {
         *     An associative array of screen reader text strings.
         *
         *     @type string $heading_views      Screen reader text for the filter links heading.
         *                                      Default 'Filter items list'.
         *     @type string $heading_pagination Screen reader text for the pagination heading.
         *                                      Default 'Items list navigation'.
         *     @type string $heading_list       Screen reader text for the items list heading.
         *                                      Default 'Items list'.
         * }
         * @phpstan-param array{
         *   heading_views?: string,
         *   heading_pagination?: string,
         *   heading_list?: string,
         * } $content
         */
        public function set_screen_reader_content($content = array())
        {
        }
        /**
         * Removes all the accessible hidden headings and text for the screen.
         *
         * @since 4.4.0
         */
        public function remove_screen_reader_content()
        {
        }
        /**
         * Renders the screen's help section.
         *
         * This will trigger the deprecated filters for backward compatibility.
         *
         * @since 3.3.0
         *
         * @global string $screen_layout_columns
         * @phpstan-return void
         */
        public function render_screen_meta()
        {
        }
        /**
         * @global array $wp_meta_boxes Global meta box state.
         *
         * @return bool
         */
        public function show_screen_options()
        {
        }
        /**
         * Renders the screen options tab.
         *
         * @since 3.3.0
         *
         * @param array $options {
         *     Options for the tab.
         *
         *     @type bool $wrap Whether the screen-options-wrap div will be included. Defaults to true.
         * }
         * @phpstan-param array{
         *   wrap?: bool,
         * } $options
         */
        public function render_screen_options($options = array())
        {
        }
        /**
         * Renders the meta boxes preferences.
         *
         * @since 4.4.0
         *
         * @global array $wp_meta_boxes Global meta box state.
         * @phpstan-return void
         */
        public function render_meta_boxes_preferences()
        {
        }
        /**
         * Renders the list table columns preferences.
         *
         * @since 4.4.0
         * @phpstan-return void
         */
        public function render_list_table_columns_preferences()
        {
        }
        /**
         * Renders the option for number of columns on the page.
         *
         * @since 3.3.0
         * @phpstan-return void
         */
        public function render_screen_layout()
        {
        }
        /**
         * Renders the items per page option.
         *
         * @since 3.3.0
         * @phpstan-return void
         */
        public function render_per_page_options()
        {
        }
        /**
         * Renders the list table view mode preferences.
         *
         * @since 4.4.0
         *
         * @global string $mode List table view mode.
         * @phpstan-return void
         */
        public function render_view_mode()
        {
        }
        /**
         * Renders screen reader text.
         *
         * @since 4.4.0
         *
         * @param string $key The screen reader text array named key.
         * @param string $tag Optional. The HTML tag to wrap the screen reader text. Default h2.
         * @phpstan-return void
         */
        public function render_screen_reader_content($key = '', $tag = 'h2')
        {
        }
    }
    /**
     * Class for testing automatic updates in the WordPress code.
     *
     * @package WordPress
     * @subpackage Site_Health
     * @since 5.2.0
     */
    #[\AllowDynamicProperties]
    class WP_Site_Health_Auto_Updates
    {
        /**
         * WP_Site_Health_Auto_Updates constructor.
         *
         * @since 5.2.0
         */
        public function __construct()
        {
        }
        /**
         * Runs tests to determine if auto-updates can run.
         *
         * @since 5.2.0
         *
         * @return array The test results.
         */
        public function run_tests()
        {
        }
        /**
         * Tests if auto-updates related constants are set correctly.
         *
         * @since 5.2.0
         * @since 5.5.1 The `$value` parameter can accept an array.
         *
         * @param string $constant         The name of the constant to check.
         * @param bool|string|array $value The value that the constant should be, if set,
         *                                 or an array of acceptable values.
         * @return array|null The test results if there are any constants set incorrectly,
         *                    or null if the test passed.
         */
        public function test_constants($constant, $value)
        {
        }
        /**
         * Checks if updates are intercepted by a filter.
         *
         * @since 5.2.0
         *
         * @return array|null The test results if wp_version_check() is disabled,
         *                    or null if the test passed.
         */
        public function test_wp_version_check_attached()
        {
        }
        /**
         * Checks if automatic updates are disabled by a filter.
         *
         * @since 5.2.0
         *
         * @return array|null The test results if the {@see 'automatic_updater_disabled'} filter is set,
         *                    or null if the test passed.
         */
        public function test_filters_automatic_updater_disabled()
        {
        }
        /**
         * Checks if automatic updates are disabled.
         *
         * @since 5.3.0
         *
         * @return array|false The test results if auto-updates are disabled, false otherwise.
         */
        public function test_wp_automatic_updates_disabled()
        {
        }
        /**
         * Checks if automatic updates have tried to run, but failed, previously.
         *
         * @since 5.2.0
         *
         * @return array|false The test results if auto-updates previously failed, false otherwise.
         */
        public function test_if_failed_update()
        {
        }
        /**
         * Checks if WordPress is controlled by a VCS (Git, Subversion etc).
         *
         * @since 5.2.0
         *
         * @return array The test results.
         */
        public function test_vcs_abspath()
        {
        }
        /**
         * Checks if we can access files without providing credentials.
         *
         * @since 5.2.0
         *
         * @return array The test results.
         */
        public function test_check_wp_filesystem_method()
        {
        }
        /**
         * Checks if core files are writable by the web user/group.
         *
         * @since 5.2.0
         *
         * @global WP_Filesystem_Base $wp_filesystem WordPress filesystem subclass.
         *
         * @return array|false The test results if at least some of WordPress core files are writeable,
         *                     or if a list of the checksums could not be retrieved from WordPress.org.
         *                     False if the core files are not writeable.
         */
        public function test_all_files_writable()
        {
        }
        /**
         * Checks if the install is using a development branch and can use nightly packages.
         *
         * @since 5.2.0
         *
         * @return array|false|null The test results if development updates are blocked.
         *                          False if it isn't a development version. Null if the test passed.
         */
        public function test_accepts_dev_updates()
        {
        }
        /**
         * Checks if the site supports automatic minor updates.
         *
         * @since 5.2.0
         *
         * @return array|null The test results if minor updates are blocked,
         *                    or null if the test passed.
         */
        public function test_accepts_minor_updates()
        {
        }
    }
    /**
     * Class for looking up a site's health based on a user's WordPress environment.
     *
     * @package WordPress
     * @subpackage Site_Health
     * @since 5.2.0
     */
    #[\AllowDynamicProperties]
    class WP_Site_Health
    {
        public $is_mariadb = \false;
        public $php_memory_limit;
        public $schedules;
        public $crons;
        public $last_missed_cron = \null;
        public $last_late_cron = \null;
        /**
         * WP_Site_Health constructor.
         *
         * @since 5.2.0
         */
        public function __construct()
        {
        }
        /**
         * Outputs the content of a tab in the Site Health screen.
         *
         * @since 5.8.0
         *
         * @param string $tab Slug of the current tab being displayed.
         */
        public function show_site_health_tab($tab)
        {
        }
        /**
         * Returns an instance of the WP_Site_Health class, or create one if none exist yet.
         *
         * @since 5.4.0
         *
         * @return WP_Site_Health|null
         */
        public static function get_instance()
        {
        }
        /**
         * Enqueues the site health scripts.
         *
         * @since 5.2.0
         * @phpstan-return void
         */
        public function enqueue_scripts()
        {
        }
        /**
         * Tests whether `wp_version_check` is blocked.
         *
         * It's possible to block updates with the `wp_version_check` filter, but this can't be checked
         * during an Ajax call, as the filter is never introduced then.
         *
         * This filter overrides a standard page request if it's made by an admin through the Ajax call
         * with the right query argument to check for this.
         *
         * @since 5.2.0
         * @phpstan-return void
         */
        public function check_wp_version_check_exists()
        {
        }
        /**
         * Tests for WordPress version and outputs it.
         *
         * Gives various results depending on what kind of updates are available, if any, to encourage
         * the user to install security updates as a priority.
         *
         * @since 5.2.0
         *
         * @return array The test result.
         */
        public function get_test_wordpress_version()
        {
        }
        /**
         * Tests if plugins are outdated, or unnecessary.
         *
         * The test checks if your plugins are up to date, and encourages you to remove any
         * that are not in use.
         *
         * @since 5.2.0
         *
         * @return array The test result.
         */
        public function get_test_plugin_version()
        {
        }
        /**
         * Tests if themes are outdated, or unnecessary.
         *
         * Checks if your site has a default theme (to fall back on if there is a need),
         * if your themes are up to date and, finally, encourages you to remove any themes
         * that are not needed.
         *
         * @since 5.2.0
         *
         * @return array The test results.
         */
        public function get_test_theme_version()
        {
        }
        /**
         * Tests if the supplied PHP version is supported.
         *
         * @since 5.2.0
         *
         * @return array The test results.
         */
        public function get_test_php_version()
        {
        }
        /**
         * Tests if required PHP modules are installed on the host.
         *
         * This test builds on the recommendations made by the WordPress Hosting Team
         * as seen at https://make.wordpress.org/hosting/handbook/handbook/server-environment/#php-extensions
         *
         * @since 5.2.0
         *
         * @return array
         */
        public function get_test_php_extensions()
        {
        }
        /**
         * Tests if the PHP default timezone is set to UTC.
         *
         * @since 5.3.1
         *
         * @return array The test results.
         */
        public function get_test_php_default_timezone()
        {
        }
        /**
         * Tests if there's an active PHP session that can affect loopback requests.
         *
         * @since 5.5.0
         *
         * @return array The test results.
         */
        public function get_test_php_sessions()
        {
        }
        /**
         * Tests if the SQL server is up to date.
         *
         * @since 5.2.0
         *
         * @return array The test results.
         */
        public function get_test_sql_server()
        {
        }
        /**
         * Tests if the site can communicate with WordPress.org.
         *
         * @since 5.2.0
         *
         * @return array The test results.
         */
        public function get_test_dotorg_communication()
        {
        }
        /**
         * Tests if debug information is enabled.
         *
         * When WP_DEBUG is enabled, errors and information may be disclosed to site visitors,
         * or logged to a publicly accessible file.
         *
         * Debugging is also frequently left enabled after looking for errors on a site,
         * as site owners do not understand the implications of this.
         *
         * @since 5.2.0
         *
         * @return array The test results.
         */
        public function get_test_is_in_debug_mode()
        {
        }
        /**
         * Tests if the site is serving content over HTTPS.
         *
         * Many sites have varying degrees of HTTPS support, the most common of which is sites that have it
         * enabled, but only if you visit the right site address.
         *
         * @since 5.2.0
         * @since 5.7.0 Updated to rely on {@see wp_is_using_https()} and {@see wp_is_https_supported()}.
         *
         * @return array The test results.
         */
        public function get_test_https_status()
        {
        }
        /**
         * Checks if the HTTP API can handle SSL/TLS requests.
         *
         * @since 5.2.0
         *
         * @return array The test result.
         */
        public function get_test_ssl_support()
        {
        }
        /**
         * Tests if scheduled events run as intended.
         *
         * If scheduled events are not running, this may indicate something with WP_Cron is not working
         * as intended, or that there are orphaned events hanging around from older code.
         *
         * @since 5.2.0
         *
         * @return array The test results.
         */
        public function get_test_scheduled_events()
        {
        }
        /**
         * Tests if WordPress can run automated background updates.
         *
         * Background updates in WordPress are primarily used for minor releases and security updates.
         * It's important to either have these working, or be aware that they are intentionally disabled
         * for whatever reason.
         *
         * @since 5.2.0
         *
         * @return array The test results.
         */
        public function get_test_background_updates()
        {
        }
        /**
         * Tests if plugin and theme auto-updates appear to be configured correctly.
         *
         * @since 5.5.0
         *
         * @return array The test results.
         */
        public function get_test_plugin_theme_auto_updates()
        {
        }
        /**
         * Tests available disk space for updates.
         *
         * @since 6.3.0
         *
         * @return array The test results.
         */
        public function get_test_available_updates_disk_space()
        {
        }
        /**
         * Tests if plugin and theme temporary backup directories are writable or can be created.
         *
         * @since 6.3.0
         *
         * @global WP_Filesystem_Base $wp_filesystem WordPress filesystem subclass.
         *
         * @return array The test results.
         */
        public function get_test_update_temp_backup_writable()
        {
        }
        /**
         * Tests if loopbacks work as expected.
         *
         * A loopback is when WordPress queries itself, for example to start a new WP_Cron instance,
         * or when editing a plugin or theme. This has shown itself to be a recurring issue,
         * as code can very easily break this interaction.
         *
         * @since 5.2.0
         *
         * @return array The test results.
         */
        public function get_test_loopback_requests()
        {
        }
        /**
         * Tests if HTTP requests are blocked.
         *
         * It's possible to block all outgoing communication (with the possibility of allowing certain
         * hosts) via the HTTP API. This may create problems for users as many features are running as
         * services these days.
         *
         * @since 5.2.0
         *
         * @return array The test results.
         */
        public function get_test_http_requests()
        {
        }
        /**
         * Tests if the REST API is accessible.
         *
         * Various security measures may block the REST API from working, or it may have been disabled in general.
         * This is required for the new block editor to work, so we explicitly test for this.
         *
         * @since 5.2.0
         *
         * @return array The test results.
         */
        public function get_test_rest_availability()
        {
        }
        /**
         * Tests if 'file_uploads' directive in PHP.ini is turned off.
         *
         * @since 5.5.0
         *
         * @return array The test results.
         */
        public function get_test_file_uploads()
        {
        }
        /**
         * Tests if the Authorization header has the expected values.
         *
         * @since 5.6.0
         *
         * @return array
         */
        public function get_test_authorization_header()
        {
        }
        /**
         * Tests if a full page cache is available.
         *
         * @since 6.1.0
         *
         * @return array The test result.
         */
        public function get_test_page_cache()
        {
        }
        /**
         * Tests if the site uses persistent object cache and recommends to use it if not.
         *
         * @since 6.1.0
         *
         * @return array The test result.
         */
        public function get_test_persistent_object_cache()
        {
        }
        /**
         * Calculates total amount of autoloaded data.
         *
         * @since 6.6.0
         *
         * @return int Autoloaded data in bytes.
         */
        public function get_autoloaded_options_size()
        {
        }
        /**
         * Tests the number of autoloaded options.
         *
         * @since 6.6.0
         *
         * @return array The test results.
         */
        public function get_test_autoloaded_options()
        {
        }
        /**
         * Returns a set of tests that belong to the site status page.
         *
         * Each site status test is defined here, they may be `direct` tests, that run on page load, or `async` tests
         * which will run later down the line via JavaScript calls to improve page performance and hopefully also user
         * experiences.
         *
         * @since 5.2.0
         * @since 5.6.0 Added support for `has_rest` and `permissions`.
         *
         * @return array The list of tests to run.
         */
        public static function get_tests()
        {
        }
        /**
         * Adds a class to the body HTML tag.
         *
         * Filters the body class string for admin pages and adds our own class for easier styling.
         *
         * @since 5.2.0
         *
         * @param string $body_class The body class string.
         * @return string The modified body class string.
         */
        public function admin_body_class($body_class)
        {
        }
        /**
         * Checks if any scheduled tasks have been missed.
         *
         * Returns a boolean value of `true` if a scheduled task has been missed and ends processing.
         *
         * If the list of crons is an instance of WP_Error, returns the instance instead of a boolean value.
         *
         * @since 5.2.0
         *
         * @return bool|WP_Error True if a cron was missed, false if not. WP_Error if the cron is set to that.
         */
        public function has_missed_cron()
        {
        }
        /**
         * Checks if any scheduled tasks are late.
         *
         * Returns a boolean value of `true` if a scheduled task is late and ends processing.
         *
         * If the list of crons is an instance of WP_Error, returns the instance instead of a boolean value.
         *
         * @since 5.3.0
         *
         * @return bool|WP_Error True if a cron is late, false if not. WP_Error if the cron is set to that.
         */
        public function has_late_cron()
        {
        }
        /**
         * Checks for potential issues with plugin and theme auto-updates.
         *
         * Though there is no way to 100% determine if plugin and theme auto-updates are configured
         * correctly, a few educated guesses could be made to flag any conditions that would
         * potentially cause unexpected behaviors.
         *
         * @since 5.5.0
         *
         * @return object The test results.
         */
        public function detect_plugin_theme_auto_update_issues()
        {
        }
        /**
         * Runs a loopback test on the site.
         *
         * Loopbacks are what WordPress uses to communicate with itself to start up WP_Cron, scheduled posts,
         * make sure plugin or theme edits don't cause site failures and similar.
         *
         * @since 5.2.0
         *
         * @return object The test results.
         */
        public function can_perform_loopback()
        {
        }
        /**
         * Creates a weekly cron event, if one does not already exist.
         *
         * @since 5.4.0
         */
        public function maybe_create_scheduled_event()
        {
        }
        /**
         * Runs the scheduled event to check and update the latest site health status for the website.
         *
         * @since 5.4.0
         */
        public function wp_cron_scheduled_check()
        {
        }
        /**
         * Checks if the current environment type is set to 'development' or 'local'.
         *
         * @since 5.6.0
         *
         * @return bool True if it is a development environment, false if not.
         */
        public function is_development_environment()
        {
        }
        /**
         * Returns a list of headers and its verification callback to verify if page cache is enabled or not.
         *
         * Note: key is header name and value could be callable function to verify header value.
         * Empty value mean existence of header detect page cache is enabled.
         *
         * @since 6.1.0
         *
         * @return array List of client caching headers and their (optional) verification callbacks.
         */
        public function get_page_cache_headers()
        {
        }
        /**
         * Determines whether to suggest using a persistent object cache.
         *
         * @since 6.1.0
         *
         * @global wpdb $wpdb WordPress database abstraction object.
         *
         * @return bool Whether to suggest using a persistent object cache.
         */
        public function should_suggest_persistent_object_cache()
        {
        }
    }
    /**
     * Core class used to implement site icon functionality.
     *
     * @since 4.3.0
     */
    #[\AllowDynamicProperties]
    class WP_Site_Icon
    {
        /**
         * The minimum size of the site icon.
         *
         * @since 4.3.0
         * @var int
         */
        public $min_size = 512;
        /**
         * The size to which to crop the image so that we can display it in the UI nicely.
         *
         * @since 4.3.0
         * @var int
         */
        public $page_crop = 512;
        /**
         * List of site icon sizes.
         *
         * @since 4.3.0
         * @var int[]
         */
        public $site_icon_sizes = array(
            /*
             * Square, medium sized tiles for IE11+.
             *
             * See https://msdn.microsoft.com/library/dn455106(v=vs.85).aspx
             */
            270,
            /*
             * App icon for Android/Chrome.
             *
             * @link https://developers.google.com/web/updates/2014/11/Support-for-theme-color-in-Chrome-39-for-Android
             * @link https://developer.chrome.com/multidevice/android/installtohomescreen
             */
            192,
            /*
             * App icons up to iPhone 6 Plus.
             *
             * See https://developer.apple.com/library/prerelease/ios/documentation/UserExperience/Conceptual/MobileHIG/IconMatrix.html
             */
            180,
            // Our regular Favicon.
            32,
        );
        /**
         * Registers actions and filters.
         *
         * @since 4.3.0
         */
        public function __construct()
        {
        }
        /**
         * Creates an attachment 'object'.
         *
         * @since 4.3.0
         * @deprecated 6.5.0
         *
         * @param string $cropped              Cropped image URL.
         * @param int    $parent_attachment_id Attachment ID of parent image.
         * @return array An array with attachment object data.
         */
        public function create_attachment_object($cropped, $parent_attachment_id)
        {
        }
        /**
         * Inserts an attachment.
         *
         * @since 4.3.0
         *
         * @param array  $attachment An array with attachment object data.
         * @param string $file       File path of the attached image.
         * @return int               Attachment ID.
         */
        public function insert_attachment($attachment, $file)
        {
        }
        /**
         * Adds additional sizes to be made when creating the site icon images.
         *
         * @since 4.3.0
         *
         * @param array[] $sizes Array of arrays containing information for additional sizes.
         * @return array[] Array of arrays containing additional image sizes.
         */
        public function additional_sizes($sizes = array())
        {
        }
        /**
         * Adds Site Icon sizes to the array of image sizes on demand.
         *
         * @since 4.3.0
         *
         * @param string[] $sizes Array of image size names.
         * @return string[] Array of image size names.
         */
        public function intermediate_image_sizes($sizes = array())
        {
        }
        /**
         * Deletes the Site Icon when the image file is deleted.
         *
         * @since 4.3.0
         *
         * @param int $post_id Attachment ID.
         */
        public function delete_attachment_data($post_id)
        {
        }
        /**
         * Adds custom image sizes when meta data for an image is requested, that happens to be used as Site Icon.
         *
         * @since 4.3.0
         *
         * @param null|array|string $value    The value get_metadata() should return a single metadata value, or an
         *                                    array of values.
         * @param int               $post_id  Post ID.
         * @param string            $meta_key Meta key.
         * @param bool              $single   Whether to return only the first value of the specified `$meta_key`.
         * @return array|null|string The attachment metadata value, array of values, or null.
         */
        public function get_post_metadata($value, $post_id, $meta_key, $single)
        {
        }
    }
    /**
     * Core class used to implement displaying terms in a list table.
     *
     * @since 3.1.0
     *
     * @see WP_List_Table
     */
    class WP_Terms_List_Table extends \WP_List_Table
    {
        public $callback_args;
        /**
         * Constructor.
         *
         * @since 3.1.0
         *
         * @see WP_List_Table::__construct() for more information on default arguments.
         *
         * @global string $post_type Global post type.
         * @global string $taxonomy  Global taxonomy.
         * @global string $action
         * @global object $tax
         *
         * @param array $args An associative array of arguments.
         */
        public function __construct($args = array())
        {
        }
        /**
         * @return bool
         */
        public function ajax_user_can()
        {
        }
        /**
         */
        public function prepare_items()
        {
        }
        /**
         */
        public function no_items()
        {
        }
        /**
         * @return array
         */
        protected function get_bulk_actions()
        {
        }
        /**
         * @return string
         */
        public function current_action()
        {
        }
        /**
         * @return string[] Array of column titles keyed by their column name.
         */
        public function get_columns()
        {
        }
        /**
         * @return array
         */
        protected function get_sortable_columns()
        {
        }
        /**
         * @phpstan-return void
         */
        public function display_rows_or_placeholder()
        {
        }
        /**
         * @global string $taxonomy Global taxonomy.
         *
         * @param WP_Term $tag   Term object.
         * @param int     $level
         */
        public function single_row($tag, $level = 0)
        {
        }
        /**
         * @since 5.9.0 Renamed `$tag` to `$item` to match parent class for PHP 8 named parameter support.
         *
         * @param WP_Term $item Term object.
         * @return string
         */
        public function column_cb($item)
        {
        }
        /**
         * @param WP_Term $tag Term object.
         * @return string
         */
        public function column_name($tag)
        {
        }
        /**
         * Gets the name of the default primary column.
         *
         * @since 4.3.0
         *
         * @return string Name of the default primary column, in this case, 'name'.
         */
        protected function get_default_primary_column_name()
        {
        }
        /**
         * Generates and displays row action links.
         *
         * @since 4.3.0
         * @since 5.9.0 Renamed `$tag` to `$item` to match parent class for PHP 8 named parameter support.
         *
         * @param WP_Term $item        Tag being acted upon.
         * @param string  $column_name Current column name.
         * @param string  $primary     Primary column name.
         * @return string Row actions output for terms, or an empty string
         *                if the current column is not the primary column.
         */
        protected function handle_row_actions($item, $column_name, $primary)
        {
        }
        /**
         * @param WP_Term $tag Term object.
         * @return string
         */
        public function column_description($tag)
        {
        }
        /**
         * @param WP_Term $tag Term object.
         * @return string
         */
        public function column_slug($tag)
        {
        }
        /**
         * @param WP_Term $tag Term object.
         * @return string
         */
        public function column_posts($tag)
        {
        }
        /**
         * @param WP_Term $tag Term object.
         * @return string
         */
        public function column_links($tag)
        {
        }
        /**
         * @since 5.9.0 Renamed `$tag` to `$item` to match parent class for PHP 8 named parameter support.
         *
         * @param WP_Term $item        Term object.
         * @param string  $column_name Name of the column.
         * @return string
         */
        public function column_default($item, $column_name)
        {
        }
        /**
         * Outputs the hidden row displayed when inline editing
         *
         * @since 3.1.0
         * @phpstan-return void
         */
        public function inline_edit()
        {
        }
    }
    /**
     * Core class used to implement displaying installed themes in a list table.
     *
     * @since 3.1.0
     *
     * @see WP_List_Table
     */
    class WP_Themes_List_Table extends \WP_List_Table
    {
        protected $search_terms = array();
        public $features = array();
        /**
         * Constructor.
         *
         * @since 3.1.0
         *
         * @see WP_List_Table::__construct() for more information on default arguments.
         *
         * @param array $args An associative array of arguments.
         */
        public function __construct($args = array())
        {
        }
        /**
         * @return bool
         */
        public function ajax_user_can()
        {
        }
        /**
         */
        public function prepare_items()
        {
        }
        /**
         * @phpstan-return void
         */
        public function no_items()
        {
        }
        /**
         * @param string $which
         * @phpstan-return void
         */
        public function tablenav($which = 'top')
        {
        }
        /**
         * Displays the themes table.
         *
         * Overrides the parent display() method to provide a different container.
         *
         * @since 3.1.0
         */
        public function display()
        {
        }
        /**
         * @return string[] Array of column titles keyed by their column name.
         */
        public function get_columns()
        {
        }
        /**
         */
        public function display_rows_or_placeholder()
        {
        }
        /**
         * Generates the list table rows.
         *
         * @since 3.1.0
         */
        public function display_rows()
        {
        }
        /**
         * @param WP_Theme $theme
         * @return bool
         */
        public function search_theme($theme)
        {
        }
        /**
         * Send required variables to JavaScript land
         *
         * @since 3.4.0
         *
         * @param array $extra_args
         */
        public function _js_vars($extra_args = array())
        {
        }
    }
    /**
     * Core class used to implement displaying themes to install in a list table.
     *
     * @since 3.1.0
     *
     * @see WP_Themes_List_Table
     */
    class WP_Theme_Install_List_Table extends \WP_Themes_List_Table
    {
        public $features = array();
        /**
         * @return bool
         */
        public function ajax_user_can()
        {
        }
        /**
         * @global array  $tabs
         * @global string $tab
         * @global int    $paged
         * @global string $type
         * @global array  $theme_field_defaults
         * @phpstan-return void
         */
        public function prepare_items()
        {
        }
        /**
         */
        public function no_items()
        {
        }
        /**
         * @global array $tabs
         * @global string $tab
         * @return array
         */
        protected function get_views()
        {
        }
        /**
         * Displays the theme install table.
         *
         * Overrides the parent display() method to provide a different container.
         *
         * @since 3.1.0
         */
        public function display()
        {
        }
        /**
         * Generates the list table rows.
         *
         * @since 3.1.0
         */
        public function display_rows()
        {
        }
        /**
         * Prints a theme from the WordPress.org API.
         *
         * @since 3.1.0
         *
         * @global array $themes_allowedtags
         *
         * @param stdClass $theme {
         *     An object that contains theme data returned by the WordPress.org API.
         *
         *     @type string $name           Theme name, e.g. 'Twenty Twenty-One'.
         *     @type string $slug           Theme slug, e.g. 'twentytwentyone'.
         *     @type string $version        Theme version, e.g. '1.1'.
         *     @type string $author         Theme author username, e.g. 'melchoyce'.
         *     @type string $preview_url    Preview URL, e.g. 'https://2021.wordpress.net/'.
         *     @type string $screenshot_url Screenshot URL, e.g. 'https://wordpress.org/themes/twentytwentyone/'.
         *     @type float  $rating         Rating score.
         *     @type int    $num_ratings    The number of ratings.
         *     @type string $homepage       Theme homepage, e.g. 'https://wordpress.org/themes/twentytwentyone/'.
         *     @type string $description    Theme description.
         *     @type string $download_link  Theme ZIP download URL.
         * }
         * @phpstan-param object{
         *   name?: string,
         *   slug?: string,
         *   version?: string,
         *   author?: string,
         *   preview_url?: string,
         *   screenshot_url?: string,
         *   rating?: float,
         *   num_ratings?: int,
         *   homepage?: string,
         *   description?: string,
         *   download_link?: string,
         * } $theme
         * @phpstan-return void
         */
        public function single_row($theme)
        {
        }
        /**
         * Prints the wrapper for the theme installer.
         */
        public function theme_installer()
        {
        }
        /**
         * Prints the wrapper for the theme installer with a provided theme's data.
         * Used to make the theme installer work for no-js.
         *
         * @param stdClass $theme A WordPress.org Theme API object.
         */
        public function theme_installer_single($theme)
        {
        }
        /**
         * Prints the info for a theme (to be used in the theme installer modal).
         *
         * @global array $themes_allowedtags
         *
         * @param stdClass $theme A WordPress.org Theme API object.
         * @phpstan-return void
         */
        public function install_theme_info($theme)
        {
        }
        /**
         * Send required variables to JavaScript land
         *
         * @since 3.4.0
         *
         * @global string $tab  Current tab within Themes->Install screen
         * @global string $type Type of search.
         *
         * @param array $extra_args Unused.
         */
        public function _js_vars($extra_args = array())
        {
        }
    }
    /**
     * Core class used to implement displaying users in a list table.
     *
     * @since 3.1.0
     *
     * @see WP_List_Table
     */
    class WP_Users_List_Table extends \WP_List_Table
    {
        /**
         * Site ID to generate the Users list table for.
         *
         * @since 3.1.0
         * @var int
         */
        public $site_id;
        /**
         * Whether or not the current Users list table is for Multisite.
         *
         * @since 3.1.0
         * @var bool
         */
        public $is_site_users;
        /**
         * Constructor.
         *
         * @since 3.1.0
         *
         * @see WP_List_Table::__construct() for more information on default arguments.
         *
         * @param array $args An associative array of arguments.
         */
        public function __construct($args = array())
        {
        }
        /**
         * Checks the current user's permissions.
         *
         * @since 3.1.0
         *
         * @return bool
         */
        public function ajax_user_can()
        {
        }
        /**
         * Prepares the users list for display.
         *
         * @since 3.1.0
         *
         * @global string $role
         * @global string $usersearch
         */
        public function prepare_items()
        {
        }
        /**
         * Outputs 'no users' message.
         *
         * @since 3.1.0
         */
        public function no_items()
        {
        }
        /**
         * Returns an associative array listing all the views that can be used
         * with this table.
         *
         * Provides a list of roles and user count for that role for easy
         * filtering of the user table.
         *
         * @since 3.1.0
         *
         * @global string $role
         *
         * @return string[] An array of HTML links keyed by their view.
         */
        protected function get_views()
        {
        }
        /**
         * Retrieves an associative array of bulk actions available on this table.
         *
         * @since 3.1.0
         *
         * @return array Array of bulk action labels keyed by their action.
         */
        protected function get_bulk_actions()
        {
        }
        /**
         * Outputs the controls to allow user roles to be changed in bulk.
         *
         * @since 3.1.0
         *
         * @param string $which Whether this is being invoked above ("top")
         *                      or below the table ("bottom").
         */
        protected function extra_tablenav($which)
        {
        }
        /**
         * Captures the bulk action required, and return it.
         *
         * Overridden from the base class implementation to capture
         * the role change drop-down.
         *
         * @since 3.1.0
         *
         * @return string The bulk action required.
         */
        public function current_action()
        {
        }
        /**
         * Gets a list of columns for the list table.
         *
         * @since 3.1.0
         *
         * @return string[] Array of column titles keyed by their column name.
         */
        public function get_columns()
        {
        }
        /**
         * Gets a list of sortable columns for the list table.
         *
         * @since 3.1.0
         *
         * @return array Array of sortable columns.
         */
        protected function get_sortable_columns()
        {
        }
        /**
         * Generates the list table rows.
         *
         * @since 3.1.0
         */
        public function display_rows()
        {
        }
        /**
         * Generates HTML for a single row on the users.php admin panel.
         *
         * @since 3.1.0
         * @since 4.2.0 The `$style` parameter was deprecated.
         * @since 4.4.0 The `$role` parameter was deprecated.
         *
         * @param WP_User $user_object The current user object.
         * @param string  $style       Deprecated. Not used.
         * @param string  $role        Deprecated. Not used.
         * @param int     $numposts    Optional. Post count to display for this user. Defaults
         *                             to zero, as in, a new user has made zero posts.
         * @return string Output for a single row.
         */
        public function single_row($user_object, $style = '', $role = '', $numposts = 0)
        {
        }
        /**
         * Gets the name of the default primary column.
         *
         * @since 4.3.0
         *
         * @return string Name of the default primary column, in this case, 'username'.
         */
        protected function get_default_primary_column_name()
        {
        }
        /**
         * Returns an array of translated user role names for a given user object.
         *
         * @since 4.4.0
         *
         * @param WP_User $user_object The WP_User object.
         * @return string[] An array of user role names keyed by role.
         */
        protected function get_role_list($user_object)
        {
        }
    }
    /**
     * WordPress User Search class.
     *
     * @since 2.1.0
     * @deprecated 3.1.0 Use WP_User_Query
     */
    class WP_User_Search
    {
        /**
         * {@internal Missing Description}}
         *
         * @since 2.1.0
         * @access private
         * @var mixed
         */
        var $results;
        /**
         * {@internal Missing Description}}
         *
         * @since 2.1.0
         * @access private
         * @var string
         */
        var $search_term;
        /**
         * Page number.
         *
         * @since 2.1.0
         * @access private
         * @var int
         */
        var $page;
        /**
         * Role name that users have.
         *
         * @since 2.5.0
         * @access private
         * @var string
         */
        var $role;
        /**
         * Raw page number.
         *
         * @since 2.1.0
         * @access private
         * @var int|bool
         */
        var $raw_page;
        /**
         * Amount of users to display per page.
         *
         * @since 2.1.0
         * @access public
         * @var int
         */
        var $users_per_page = 50;
        /**
         * {@internal Missing Description}}
         *
         * @since 2.1.0
         * @access private
         * @var int
         */
        var $first_user;
        /**
         * {@internal Missing Description}}
         *
         * @since 2.1.0
         * @access private
         * @var int
         */
        var $last_user;
        /**
         * {@internal Missing Description}}
         *
         * @since 2.1.0
         * @access private
         * @var string
         */
        var $query_limit;
        /**
         * {@internal Missing Description}}
         *
         * @since 3.0.0
         * @access private
         * @var string
         */
        var $query_orderby;
        /**
         * {@internal Missing Description}}
         *
         * @since 3.0.0
         * @access private
         * @var string
         */
        var $query_from;
        /**
         * {@internal Missing Description}}
         *
         * @since 3.0.0
         * @access private
         * @var string
         */
        var $query_where;
        /**
         * {@internal Missing Description}}
         *
         * @since 2.1.0
         * @access private
         * @var int
         */
        var $total_users_for_query = 0;
        /**
         * {@internal Missing Description}}
         *
         * @since 2.1.0
         * @access private
         * @var bool
         */
        var $too_many_total_users = \false;
        /**
         * {@internal Missing Description}}
         *
         * @since 2.1.0
         * @access private
         * @var WP_Error
         */
        var $search_errors;
        /**
         * {@internal Missing Description}}
         *
         * @since 2.7.0
         * @access private
         * @var string
         */
        var $paging_text;
        /**
         * PHP5 Constructor - Sets up the object properties.
         *
         * @since 2.1.0
         *
         * @param string $search_term Search terms string.
         * @param int $page Optional. Page ID.
         * @param string $role Role name.
         * @return WP_User_Search
         */
        function __construct($search_term = '', $page = '', $role = '')
        {
        }
        /**
         * PHP4 Constructor - Sets up the object properties.
         *
         * @since 2.1.0
         *
         * @param string $search_term Search terms string.
         * @param int $page Optional. Page ID.
         * @param string $role Role name.
         * @return WP_User_Search
         */
        public function WP_User_Search($search_term = '', $page = '', $role = '')
        {
        }
        /**
         * Prepares the user search query (legacy).
         *
         * @since 2.1.0
         * @access public
         *
         * @global wpdb $wpdb WordPress database abstraction object.
         */
        public function prepare_query()
        {
        }
        /**
         * Executes the user search query.
         *
         * @since 2.1.0
         * @access public
         *
         * @global wpdb $wpdb WordPress database abstraction object.
         */
        public function query()
        {
        }
        /**
         * Prepares variables for use in templates.
         *
         * @since 2.1.0
         * @access public
         */
        function prepare_vars_for_template_usage()
        {
        }
        /**
         * Handles paging for the user search query.
         *
         * @since 2.1.0
         * @access public
         */
        public function do_paging()
        {
        }
        /**
         * Retrieves the user search query results.
         *
         * @since 2.1.0
         * @access public
         *
         * @return array
         */
        public function get_results()
        {
        }
        /**
         * Displaying paging text.
         *
         * @see do_paging() Builds paging text.
         *
         * @since 2.1.0
         * @access public
         */
        function page_links()
        {
        }
        /**
         * Whether paging is enabled.
         *
         * @see do_paging() Builds paging text.
         *
         * @since 2.1.0
         * @access public
         *
         * @return bool
         */
        function results_are_paged()
        {
        }
        /**
         * Whether there are search terms.
         *
         * @since 2.1.0
         * @access public
         *
         * @return bool
         */
        function is_search()
        {
        }
    }
    /**
     * Previous class for list table for privacy data export requests.
     *
     * @since 4.9.6
     * @deprecated 5.3.0
     */
    class WP_Privacy_Data_Export_Requests_Table extends \WP_Privacy_Data_Export_Requests_List_Table
    {
        function __construct($args)
        {
        }
    }
    /**
     * Previous class for list table for privacy data erasure requests.
     *
     * @since 4.9.6
     * @deprecated 5.3.0
     */
    class WP_Privacy_Data_Removal_Requests_Table extends \WP_Privacy_Data_Removal_Requests_List_Table
    {
        function __construct($args)
        {
        }
    }
    class getid3_lib
    {
        /**
         * @param string      $string
         * @param bool        $hex
         * @param bool        $spaces
         * @param string|bool $htmlencoding
         *
         * @return string
         */
        public static function PrintHexBytes($string, $hex = \true, $spaces = \true, $htmlencoding = 'UTF-8')
        {
        }
        /**
         * Truncates a floating-point number at the decimal point.
         *
         * @param float $floatnumber
         *
         * @return float|int returns int (if possible, otherwise float)
         */
        public static function trunc($floatnumber)
        {
        }
        /**
         * @param int|null $variable
         * @param int      $increment
         *
         * @return bool
         */
        public static function safe_inc(&$variable, $increment = 1)
        {
        }
        /**
         * @param int|float $floatnum
         *
         * @return int|float
         */
        public static function CastAsInt($floatnum)
        {
        }
        /**
         * @param int $num
         *
         * @return bool
         */
        public static function intValueSupported($num)
        {
        }
        /**
         * Perform a division, guarding against division by zero
         *
         * @param float|int $numerator
         * @param float|int $denominator
         * @param float|int $fallback
         * @return float|int
         */
        public static function SafeDiv($numerator, $denominator, $fallback = 0)
        {
        }
        /**
         * @param string $fraction
         *
         * @return float
         */
        public static function DecimalizeFraction($fraction)
        {
        }
        /**
         * @param string $binarynumerator
         *
         * @return float
         */
        public static function DecimalBinary2Float($binarynumerator)
        {
        }
        /**
         * @link http://www.scri.fsu.edu/~jac/MAD3401/Backgrnd/binary.html
         *
         * @param string $binarypointnumber
         * @param int    $maxbits
         *
         * @return array
         */
        public static function NormalizeBinaryPoint($binarypointnumber, $maxbits = 52)
        {
        }
        /**
         * @link http://www.scri.fsu.edu/~jac/MAD3401/Backgrnd/binary.html
         *
         * @param float $floatvalue
         *
         * @return string
         */
        public static function Float2BinaryDecimal($floatvalue)
        {
        }
        /**
         * @link http://www.scri.fsu.edu/~jac/MAD3401/Backgrnd/ieee-expl.html
         *
         * @param float $floatvalue
         * @param int $bits
         *
         * @return string|false
         */
        public static function Float2String($floatvalue, $bits)
        {
        }
        /**
         * @param string $byteword
         *
         * @return float|false
         */
        public static function LittleEndian2Float($byteword)
        {
        }
        /**
         * ANSI/IEEE Standard 754-1985, Standard for Binary Floating Point Arithmetic
         *
         * @link https://web.archive.org/web/20120325162206/http://www.psc.edu/general/software/packages/ieee/ieee.php
         * @link http://www.scri.fsu.edu/~jac/MAD3401/Backgrnd/ieee.html
         *
         * @param string $byteword
         *
         * @return float|false
         */
        public static function BigEndian2Float($byteword)
        {
        }
        /**
         * @param string $byteword
         * @param bool   $synchsafe
         * @param bool   $signed
         *
         * @return int|float|false
         * @throws Exception
         */
        public static function BigEndian2Int($byteword, $synchsafe = \false, $signed = \false)
        {
        }
        /**
         * @param string $byteword
         * @param bool   $signed
         *
         * @return int|float|false
         */
        public static function LittleEndian2Int($byteword, $signed = \false)
        {
        }
        /**
         * @param string $byteword
         *
         * @return string
         */
        public static function LittleEndian2Bin($byteword)
        {
        }
        /**
         * @param string $byteword
         *
         * @return string
         */
        public static function BigEndian2Bin($byteword)
        {
        }
        /**
         * @param int  $number
         * @param int  $minbytes
         * @param bool $synchsafe
         * @param bool $signed
         *
         * @return string
         * @throws Exception
         */
        public static function BigEndian2String($number, $minbytes = 1, $synchsafe = \false, $signed = \false)
        {
        }
        /**
         * @param int $number
         *
         * @return string
         */
        public static function Dec2Bin($number)
        {
        }
        /**
         * @param string $binstring
         * @param bool   $signed
         *
         * @return int|float
         */
        public static function Bin2Dec($binstring, $signed = \false)
        {
        }
        /**
         * @param string $binstring
         *
         * @return string
         */
        public static function Bin2String($binstring)
        {
        }
        /**
         * @param int  $number
         * @param int  $minbytes
         * @param bool $synchsafe
         *
         * @return string
         */
        public static function LittleEndian2String($number, $minbytes = 1, $synchsafe = \false)
        {
        }
        /**
         * @param mixed $array1
         * @param mixed $array2
         *
         * @return array|false
         */
        public static function array_merge_clobber($array1, $array2)
        {
        }
        /**
         * @param mixed $array1
         * @param mixed $array2
         *
         * @return array|false
         */
        public static function array_merge_noclobber($array1, $array2)
        {
        }
        /**
         * @param mixed $array1
         * @param mixed $array2
         *
         * @return array|false|null
         */
        public static function flipped_array_merge_noclobber($array1, $array2)
        {
        }
        /**
         * @param array $theArray
         *
         * @return bool
         */
        public static function ksort_recursive(&$theArray)
        {
        }
        /**
         * @param string $filename
         * @param int    $numextensions
         *
         * @return string
         */
        public static function fileextension($filename, $numextensions = 1)
        {
        }
        /**
         * @param int $seconds
         *
         * @return string
         */
        public static function PlaytimeString($seconds)
        {
        }
        /**
         * @param int $macdate
         *
         * @return int|float
         */
        public static function DateMac2Unix($macdate)
        {
        }
        /**
         * @param string $rawdata
         *
         * @return float
         */
        public static function FixedPoint8_8($rawdata)
        {
        }
        /**
         * @param string $rawdata
         *
         * @return float
         */
        public static function FixedPoint16_16($rawdata)
        {
        }
        /**
         * @param string $rawdata
         *
         * @return float
         */
        public static function FixedPoint2_30($rawdata)
        {
        }
        /**
         * @param string $ArrayPath
         * @param string $Separator
         * @param mixed $Value
         *
         * @return array
         */
        public static function CreateDeepArray($ArrayPath, $Separator, $Value)
        {
        }
        /**
         * @param array $arraydata
         * @param bool  $returnkey
         *
         * @return int|false
         */
        public static function array_max($arraydata, $returnkey = \false)
        {
        }
        /**
         * @param array $arraydata
         * @param bool  $returnkey
         *
         * @return int|false
         */
        public static function array_min($arraydata, $returnkey = \false)
        {
        }
        /**
         * @param string $XMLstring
         *
         * @return array|false
         */
        public static function XML2array($XMLstring)
        {
        }
        /**
         * @param SimpleXMLElement|array|mixed $XMLobject
         *
         * @return mixed
         */
        public static function SimpleXMLelement2array($XMLobject)
        {
        }
        /**
         * Returns checksum for a file from starting position to absolute end position.
         *
         * @param string $file
         * @param int    $offset
         * @param int    $end
         * @param string $algorithm
         *
         * @return string|false
         * @throws getid3_exception
         */
        public static function hash_data($file, $offset, $end, $algorithm)
        {
        }
        /**
         * @param string $filename_source
         * @param string $filename_dest
         * @param int    $offset
         * @param int    $length
         *
         * @return bool
         * @throws Exception
         *
         * @deprecated Unused, may be removed in future versions of getID3
         */
        public static function CopyFileParts($filename_source, $filename_dest, $offset, $length)
        {
        }
        /**
         * @param int $charval
         *
         * @return string
         */
        public static function iconv_fallback_int_utf8($charval)
        {
        }
        /**
         * ISO-8859-1 => UTF-8
         *
         * @param string $string
         * @param bool   $bom
         *
         * @return string
         */
        public static function iconv_fallback_iso88591_utf8($string, $bom = \false)
        {
        }
        /**
         * ISO-8859-1 => UTF-16BE
         *
         * @param string $string
         * @param bool   $bom
         *
         * @return string
         */
        public static function iconv_fallback_iso88591_utf16be($string, $bom = \false)
        {
        }
        /**
         * ISO-8859-1 => UTF-16LE
         *
         * @param string $string
         * @param bool   $bom
         *
         * @return string
         */
        public static function iconv_fallback_iso88591_utf16le($string, $bom = \false)
        {
        }
        /**
         * ISO-8859-1 => UTF-16LE (BOM)
         *
         * @param string $string
         *
         * @return string
         */
        public static function iconv_fallback_iso88591_utf16($string)
        {
        }
        /**
         * UTF-8 => ISO-8859-1
         *
         * @param string $string
         *
         * @return string
         */
        public static function iconv_fallback_utf8_iso88591($string)
        {
        }
        /**
         * UTF-8 => UTF-16BE
         *
         * @param string $string
         * @param bool   $bom
         *
         * @return string
         */
        public static function iconv_fallback_utf8_utf16be($string, $bom = \false)
        {
        }
        /**
         * UTF-8 => UTF-16LE
         *
         * @param string $string
         * @param bool   $bom
         *
         * @return string
         */
        public static function iconv_fallback_utf8_utf16le($string, $bom = \false)
        {
        }
        /**
         * UTF-8 => UTF-16LE (BOM)
         *
         * @param string $string
         *
         * @return string
         */
        public static function iconv_fallback_utf8_utf16($string)
        {
        }
        /**
         * UTF-16BE => UTF-8
         *
         * @param string $string
         *
         * @return string
         */
        public static function iconv_fallback_utf16be_utf8($string)
        {
        }
        /**
         * UTF-16LE => UTF-8
         *
         * @param string $string
         *
         * @return string
         */
        public static function iconv_fallback_utf16le_utf8($string)
        {
        }
        /**
         * UTF-16BE => ISO-8859-1
         *
         * @param string $string
         *
         * @return string
         */
        public static function iconv_fallback_utf16be_iso88591($string)
        {
        }
        /**
         * UTF-16LE => ISO-8859-1
         *
         * @param string $string
         *
         * @return string
         */
        public static function iconv_fallback_utf16le_iso88591($string)
        {
        }
        /**
         * UTF-16 (BOM) => ISO-8859-1
         *
         * @param string $string
         *
         * @return string
         */
        public static function iconv_fallback_utf16_iso88591($string)
        {
        }
        /**
         * UTF-16 (BOM) => UTF-8
         *
         * @param string $string
         *
         * @return string
         */
        public static function iconv_fallback_utf16_utf8($string)
        {
        }
        /**
         * @param string $in_charset
         * @param string $out_charset
         * @param string $string
         *
         * @return string
         * @throws Exception
         */
        public static function iconv_fallback($in_charset, $out_charset, $string)
        {
        }
        /**
         * @param mixed  $data
         * @param string $charset
         *
         * @return mixed
         */
        public static function recursiveMultiByteCharString2HTML($data, $charset = 'ISO-8859-1')
        {
        }
        /**
         * @param string|int|float $string
         * @param string           $charset
         *
         * @return string
         */
        public static function MultiByteCharString2HTML($string, $charset = 'ISO-8859-1')
        {
        }
        /**
         * @param int $namecode
         *
         * @return string
         */
        public static function RGADnameLookup($namecode)
        {
        }
        /**
         * @param int $originatorcode
         *
         * @return string
         */
        public static function RGADoriginatorLookup($originatorcode)
        {
        }
        /**
         * @param int $rawadjustment
         * @param int $signbit
         *
         * @return float
         */
        public static function RGADadjustmentLookup($rawadjustment, $signbit)
        {
        }
        /**
         * @param int $namecode
         * @param int $originatorcode
         * @param int $replaygain
         *
         * @return string
         */
        public static function RGADgainString($namecode, $originatorcode, $replaygain)
        {
        }
        /**
         * @param float $amplitude
         *
         * @return float
         */
        public static function RGADamplitude2dB($amplitude)
        {
        }
        /**
         * @param string $imgData
         * @param array  $imageinfo
         *
         * @return array|false
         */
        public static function GetDataImageSize($imgData, &$imageinfo = array())
        {
        }
        /**
         * @param string $mime_type
         *
         * @return string
         */
        public static function ImageExtFromMime($mime_type)
        {
        }
        /**
         * @param array $ThisFileInfo
         * @param bool  $option_tags_html default true (just as in the main getID3 class)
         *
         * @return bool
         */
        public static function CopyTagsToComments(&$ThisFileInfo, $option_tags_html = \true)
        {
        }
        /**
         * @param string $key
         * @param int    $begin
         * @param int    $end
         * @param string $file
         * @param string $name
         *
         * @return string
         */
        public static function EmbeddedLookup($key, $begin, $end, $file, $name)
        {
        }
        /**
         * @param string $filename
         * @param string $sourcefile
         * @param bool   $DieOnFailure
         *
         * @return bool
         * @throws Exception
         */
        public static function IncludeDependency($filename, $sourcefile, $DieOnFailure = \false)
        {
        }
        /**
         * @param string $string
         *
         * @return string
         */
        public static function trimNullByte($string)
        {
        }
        /**
         * @param string $path
         *
         * @return float|bool
         */
        public static function getFileSizeSyscall($path)
        {
        }
        /**
         * @param string $filename
         *
         * @return string|false
         */
        public static function truepath($filename)
        {
        }
        /**
         * Workaround for Bug #37268 (https://bugs.php.net/bug.php?id=37268)
         *
         * @param string $path A path.
         * @param string $suffix If the name component ends in suffix this will also be cut off.
         *
         * @return string
         */
        public static function mb_basename($path, $suffix = '')
        {
        }
    }
    class getID3
    {
        /**
         * CASE SENSITIVE! - i.e. (must be supported by iconv()). Examples:  ISO-8859-1  UTF-8  UTF-16  UTF-16BE
         *
         * @var string
         */
        public $encoding = 'UTF-8';
        /**
         * Should always be 'ISO-8859-1', but some tags may be written in other encodings such as 'EUC-CN' or 'CP1252'
         *
         * @var string
         */
        public $encoding_id3v1 = 'ISO-8859-1';
        /**
         * ID3v1 should always be 'ISO-8859-1', but some tags may be written in other encodings such as 'Windows-1251' or 'KOI8-R'. If true attempt to detect these encodings, but may return incorrect values for some tags actually in ISO-8859-1 encoding
         *
         * @var bool
         */
        public $encoding_id3v1_autodetect = \false;
        /**
         * Read and process ID3v1 tags
         *
         * @var bool
         */
        public $option_tag_id3v1 = \true;
        /**
         * Read and process ID3v2 tags
         *
         * @var bool
         */
        public $option_tag_id3v2 = \true;
        /**
         * Read and process Lyrics3 tags
         *
         * @var bool
         */
        public $option_tag_lyrics3 = \true;
        /**
         * Read and process APE tags
         *
         * @var bool
         */
        public $option_tag_apetag = \true;
        /**
         * Copy tags to root key 'tags' and encode to $this->encoding
         *
         * @var bool
         */
        public $option_tags_process = \true;
        /**
         * Copy tags to root key 'tags_html' properly translated from various encodings to HTML entities
         *
         * @var bool
         */
        public $option_tags_html = \true;
        /**
         * Calculate additional info such as bitrate, channelmode etc
         *
         * @var bool
         */
        public $option_extra_info = \true;
        /**
         * Defaults to true (ATTACHMENTS_INLINE) for backward compatibility
         *
         * @var bool|string
         */
        public $option_save_attachments = \true;
        /**
         * Get MD5 sum of data part - slow
         *
         * @var bool
         */
        public $option_md5_data = \false;
        /**
         * Use MD5 of source file if available - only FLAC and OptimFROG
         *
         * @var bool
         */
        public $option_md5_data_source = \false;
        /**
         * Get SHA1 sum of data part - slow
         *
         * @var bool
         */
        public $option_sha1_data = \false;
        /**
         * Check whether file is larger than 2GB and thus not supported by 32-bit PHP (null: auto-detect based on
         * PHP_INT_MAX)
         *
         * @var bool|null
         */
        public $option_max_2gb_check;
        /**
         * Read buffer size in bytes
         *
         * @var int
         */
        public $option_fread_buffer_size = 32768;
        /** archive.rar
         * if true use PHP RarArchive extension, if false (non-extension parsing not yet written in getID3)
         *
         * @var bool
         */
        public $options_archive_rar_use_php_rar_extension = \true;
        /** archive.gzip
         * Optional file list - disable for speed.
         * Decode gzipped files, if possible, and parse recursively (.tar.gz for example).
         *
         * @var bool
         */
        public $options_archive_gzip_parse_contents = \false;
        /** audio.midi
         * if false only parse most basic information, much faster for some files but may be inaccurate
         *
         * @var bool
         */
        public $options_audio_midi_scanwholefile = \true;
        /** audio.mp3
         * Forces getID3() to scan the file byte-by-byte and log all the valid audio frame headers - extremely slow,
         * unrecommended, but may provide data from otherwise-unusable files.
         *
         * @var bool
         */
        public $options_audio_mp3_allow_bruteforce = \false;
        /** audio.mp3
         * number of frames to scan to determine if MPEG-audio sequence is valid
         * Lower this number to 5-20 for faster scanning
         * Increase this number to 50+ for most accurate detection of valid VBR/CBR mpeg-audio streams
         *
         * @var int
         */
        public $options_audio_mp3_mp3_valid_check_frames = 50;
        /** audio.wavpack
         * Avoid scanning all frames (break after finding ID_RIFF_HEADER and ID_CONFIG_BLOCK,
         * significantly faster for very large files but other data may be missed
         *
         * @var bool
         */
        public $options_audio_wavpack_quick_parsing = \false;
        /** audio-video.flv
         * Break out of the loop if too many frames have been scanned; only scan this
         * many if meta frame does not contain useful duration.
         *
         * @var int
         */
        public $options_audiovideo_flv_max_frames = 100000;
        /** audio-video.matroska
         * If true, do not return information about CLUSTER chunks, since there's a lot of them
         * and they're not usually useful [default: TRUE].
         *
         * @var bool
         */
        public $options_audiovideo_matroska_hide_clusters = \true;
        /** audio-video.matroska
         * True to parse the whole file, not only header [default: FALSE].
         *
         * @var bool
         */
        public $options_audiovideo_matroska_parse_whole_file = \false;
        /** audio-video.quicktime
         * return all parsed data from all atoms if true, otherwise just returned parsed metadata
         *
         * @var bool
         */
        public $options_audiovideo_quicktime_ReturnAtomData = \false;
        /** audio-video.quicktime
         * return all parsed data from all atoms if true, otherwise just returned parsed metadata
         *
         * @var bool
         */
        public $options_audiovideo_quicktime_ParseAllPossibleAtoms = \false;
        /** audio-video.swf
         * return all parsed tags if true, otherwise do not return tags not parsed by getID3
         *
         * @var bool
         */
        public $options_audiovideo_swf_ReturnAllTagData = \false;
        /** graphic.bmp
         * return BMP palette
         *
         * @var bool
         */
        public $options_graphic_bmp_ExtractPalette = \false;
        /** graphic.bmp
         * return image data
         *
         * @var bool
         */
        public $options_graphic_bmp_ExtractData = \false;
        /** graphic.png
         * If data chunk is larger than this do not read it completely (getID3 only needs the first
         * few dozen bytes for parsing).
         *
         * @var int
         */
        public $options_graphic_png_max_data_bytes = 10000000;
        /** misc.pdf
         * return full details of PDF Cross-Reference Table (XREF)
         *
         * @var bool
         */
        public $options_misc_pdf_returnXREF = \false;
        /** misc.torrent
         * Assume all .torrent files are less than 1MB and just read entire thing into memory for easy processing.
         * Override this value if you need to process files larger than 1MB
         *
         * @var int
         */
        public $options_misc_torrent_max_torrent_filesize = 1048576;
        /**
         * Filename of file being analysed.
         *
         * @var string
         */
        public $filename;
        /**
         * Filepointer to file being analysed.
         *
         * @var resource
         */
        public $fp;
        /**
         * Result array.
         *
         * @var array
         */
        public $info;
        /**
         * @var string
         */
        public $tempdir = \GETID3_TEMP_DIR;
        /**
         * @var int
         */
        public $memory_limit = 0;
        /**
         * @var string
         */
        protected $startup_error = '';
        /**
         * @var string
         */
        protected $startup_warning = '';
        const VERSION = '1.9.23-202310190849';
        const FREAD_BUFFER_SIZE = 32768;
        const ATTACHMENTS_NONE = \false;
        const ATTACHMENTS_INLINE = \true;
        /**
         * @throws getid3_exception
         * @phpstan-return void
         */
        public function __construct()
        {
        }
        /**
         * @return string
         */
        public function version()
        {
        }
        /**
         * @return int
         */
        public function fread_buffer_size()
        {
        }
        /**
         * @param array $optArray
         *
         * @return bool
         */
        public function setOption($optArray)
        {
        }
        /**
         * @param string   $filename
         * @param int      $filesize
         * @param resource $fp
         *
         * @return bool
         *
         * @throws getid3_exception
         */
        public function openfile($filename, $filesize = \null, $fp = \null)
        {
        }
        /**
         * analyze file
         *
         * @param string   $filename
         * @param int      $filesize
         * @param string   $original_filename
         * @param resource $fp
         *
         * @return array
         */
        public function analyze($filename, $filesize = \null, $original_filename = '', $fp = \null)
        {
        }
        /**
         * Error handling.
         *
         * @param string $message
         *
         * @return array
         */
        public function error($message)
        {
        }
        /**
         * Warning handling.
         *
         * @param string $message
         *
         * @return bool
         */
        public function warning($message)
        {
        }
        /**
         * Return array containing information about all supported formats.
         *
         * @return array
         */
        public function GetFileFormatArray()
        {
        }
        /**
         * @param string $filedata
         * @param string $filename
         *
         * @return mixed|false
         */
        public function GetFileFormat(&$filedata, $filename = '')
        {
        }
        /**
         * Converts array to $encoding charset from $this->encoding.
         *
         * @param array  $array
         * @param string $encoding
         * @phpstan-return void
         */
        public function CharConvert(&$array, $encoding)
        {
        }
        /**
         * @return bool
         */
        public function HandleAllTags()
        {
        }
        /**
         * Calls getid3_lib::CopyTagsToComments() but passes in the option_tags_html setting from this instance of getID3
         *
         * @param array $ThisFileInfo
         *
         * @return bool
         */
        public function CopyTagsToComments(&$ThisFileInfo)
        {
        }
        /**
         * @param string $algorithm
         *
         * @return array|bool
         */
        public function getHashdata($algorithm)
        {
        }
        public function ChannelsBitratePlaytimeCalculations()
        {
        }
        /**
         * @return bool
         */
        public function CalculateCompressionRatioVideo()
        {
        }
        /**
         * @return bool
         */
        public function CalculateCompressionRatioAudio()
        {
        }
        /**
         * @return bool
         */
        public function CalculateReplayGain()
        {
        }
        /**
         * @return bool
         */
        public function ProcessAudioStreams()
        {
        }
        /**
         * @return string|bool
         */
        public function getid3_tempnam()
        {
        }
        /**
         * @param string $name
         *
         * @return bool
         *
         * @throws getid3_exception
         */
        public function include_module($name)
        {
        }
        /**
         * @param string $filename
         *
         * @return bool
         */
        public static function is_writable($filename)
        {
        }
    }
    abstract class getid3_handler
    {
        /**
         * @var getID3
         */
        protected $getid3;
        /**
         * Analyzing filepointer or string.
         *
         * @var bool
         */
        protected $data_string_flag = \false;
        /**
         * String to analyze.
         *
         * @var string
         */
        protected $data_string = '';
        /**
         * Seek position in string.
         *
         * @var int
         */
        protected $data_string_position = 0;
        /**
         * String length.
         *
         * @var int
         */
        protected $data_string_length = 0;
        /**
         * getid3_handler constructor.
         *
         * @param getID3 $getid3
         * @param string $call_module
         */
        public function __construct(\getID3 $getid3, $call_module = \null)
        {
        }
        /**
         * Analyze from file pointer.
         *
         * @return bool
         */
        abstract public function Analyze();
        /**
         * Analyze from string instead.
         *
         * @param string $string
         */
        public function AnalyzeString($string)
        {
        }
        /**
         * @param string $string
         */
        public function setStringMode($string)
        {
        }
        /**
         * @phpstan-impure
         *
         * @return int|bool
         */
        protected function ftell()
        {
        }
        /**
         * @param int $bytes
         *
         * @phpstan-impure
         *
         * @return string|false
         *
         * @throws getid3_exception
         */
        protected function fread($bytes)
        {
        }
        /**
         * @param int $bytes
         * @param int $whence
         *
         * @phpstan-impure
         *
         * @return int
         *
         * @throws getid3_exception
         */
        protected function fseek($bytes, $whence = \SEEK_SET)
        {
        }
        /**
         * @phpstan-impure
         *
         * @return string|false
         *
         * @throws getid3_exception
         */
        protected function fgets()
        {
        }
        /**
         * @phpstan-impure
         *
         * @return bool
         */
        protected function feof()
        {
        }
        /**
         * @param string $module
         *
         * @return bool
         */
        final protected function isDependencyFor($module)
        {
        }
        /**
         * @param string $text
         *
         * @return bool
         */
        protected function error($text)
        {
        }
        /**
         * @param string $text
         *
         * @return bool
         */
        protected function warning($text)
        {
        }
        /**
         * @param string $text
         */
        protected function notice($text)
        {
        }
        /**
         * @param string $name
         * @param int    $offset
         * @param int    $length
         * @param string $image_mime
         *
         * @return string|null
         *
         * @throws Exception
         * @throws getid3_exception
         */
        public function saveAttachment($name, $offset, $length, $image_mime = \null)
        {
        }
    }
    class getid3_exception extends \Exception
    {
        public $message;
    }
    class getid3_asf extends \getid3_handler
    {
        protected static $ASFIndexParametersObjectIndexSpecifiersIndexTypes = array(1 => 'Nearest Past Data Packet', 2 => 'Nearest Past Media Object', 3 => 'Nearest Past Cleanpoint');
        protected static $ASFMediaObjectIndexParametersObjectIndexSpecifiersIndexTypes = array(1 => 'Nearest Past Data Packet', 2 => 'Nearest Past Media Object', 3 => 'Nearest Past Cleanpoint', 0xff => 'Frame Number Offset');
        protected static $ASFTimecodeIndexParametersObjectIndexSpecifiersIndexTypes = array(2 => 'Nearest Past Media Object', 3 => 'Nearest Past Cleanpoint');
        /**
         * @param getID3 $getid3
         */
        public function __construct(\getID3 $getid3)
        {
        }
        /**
         * @return bool
         */
        public function Analyze()
        {
        }
        /**
         * @param int $CodecListType
         *
         * @return string
         */
        public static function codecListObjectTypeLookup($CodecListType)
        {
        }
        /**
         * @return array
         */
        public static function KnownGUIDs()
        {
        }
        /**
         * @param string $GUIDstring
         *
         * @return string|false
         */
        public static function GUIDname($GUIDstring)
        {
        }
        /**
         * @param int $id
         *
         * @return string
         */
        public static function ASFIndexObjectIndexTypeLookup($id)
        {
        }
        /**
         * @param string $GUIDstring
         *
         * @return string
         */
        public static function GUIDtoBytestring($GUIDstring)
        {
        }
        /**
         * @param string $Bytestring
         *
         * @return string
         */
        public static function BytestringToGUID($Bytestring)
        {
        }
        /**
         * @param int  $FILETIME
         * @param bool $round
         *
         * @return float|int
         */
        public static function FILETIMEtoUNIXtime($FILETIME, $round = \true)
        {
        }
        /**
         * @param int $WMpictureType
         *
         * @return string
         */
        public static function WMpictureTypeLookup($WMpictureType)
        {
        }
        /**
         * @param string $asf_header_extension_object_data
         * @param int    $unhandled_sections
         *
         * @return array
         */
        public function HeaderExtensionObjectDataParse(&$asf_header_extension_object_data, &$unhandled_sections)
        {
        }
        /**
         * @param int $id
         *
         * @return string
         */
        public static function metadataLibraryObjectDataTypeLookup($id)
        {
        }
        /**
         * @param string $data
         *
         * @return array
         */
        public function ASF_WMpicture(&$data)
        {
        }
        /**
         * Remove terminator 00 00 and convert UTF-16LE to Latin-1.
         *
         * @param string $string
         *
         * @return string
         */
        public static function TrimConvert($string)
        {
        }
        /**
         * Remove terminator 00 00.
         *
         * @param string $string
         *
         * @return string
         */
        public static function TrimTerm($string)
        {
        }
    }
    class getid3_flv extends \getid3_handler
    {
        const magic = 'FLV';
        /**
         * Break out of the loop if too many frames have been scanned; only scan this
         * many if meta frame does not contain useful duration.
         *
         * @var int
         */
        public $max_frames = 100000;
        /**
         * @return bool
         */
        public function Analyze()
        {
        }
        /**
         * @param int $id
         *
         * @return string|false
         */
        public static function audioFormatLookup($id)
        {
        }
        /**
         * @param int $id
         *
         * @return int|false
         */
        public static function audioRateLookup($id)
        {
        }
        /**
         * @param int $id
         *
         * @return int|false
         */
        public static function audioBitDepthLookup($id)
        {
        }
        /**
         * @param int $id
         *
         * @return string|false
         */
        public static function videoCodecLookup($id)
        {
        }
    }
    class AMFStream
    {
        /**
         * @var string
         */
        public $bytes;
        /**
         * @var int
         */
        public $pos;
        /**
         * @param string $bytes
         */
        public function __construct(&$bytes)
        {
        }
        /**
         * @return int
         */
        public function readByte()
        {
        }
        /**
         * @return int
         */
        public function readInt()
        {
        }
        /**
         * @return int
         */
        public function readLong()
        {
        }
        /**
         * @return float|false
         */
        public function readDouble()
        {
        }
        /**
         * @return string
         */
        public function readUTF()
        {
        }
        /**
         * @return string
         */
        public function readLongUTF()
        {
        }
        /**
         * @param int $length
         *
         * @return string
         */
        public function read($length)
        {
        }
        /**
         * @return int
         */
        public function peekByte()
        {
        }
        /**
         * @return int
         */
        public function peekInt()
        {
        }
        /**
         * @return int
         */
        public function peekLong()
        {
        }
        /**
         * @return float|false
         */
        public function peekDouble()
        {
        }
        /**
         * @return string
         */
        public function peekUTF()
        {
        }
        /**
         * @return string
         */
        public function peekLongUTF()
        {
        }
    }
    class AMFReader
    {
        /**
         * @var AMFStream
         */
        public $stream;
        /**
         * @param AMFStream $stream
         */
        public function __construct(\AMFStream $stream)
        {
        }
        /**
         * @return mixed
         */
        public function readData()
        {
        }
        /**
         * @return float|false
         */
        public function readDouble()
        {
        }
        /**
         * @return bool
         */
        public function readBoolean()
        {
        }
        /**
         * @return string
         */
        public function readString()
        {
        }
        /**
         * @return array
         */
        public function readObject()
        {
        }
        /**
         * @return array
         */
        public function readMixedArray()
        {
        }
        /**
         * @return array
         */
        public function readArray()
        {
        }
        /**
         * @return float|false
         */
        public function readDate()
        {
        }
        /**
         * @return string
         */
        public function readLongString()
        {
        }
        /**
         * @return string
         */
        public function readXML()
        {
        }
        /**
         * @return array
         */
        public function readTypedObject()
        {
        }
    }
    class AVCSequenceParameterSetReader
    {
        /**
         * @var string
         */
        public $sps;
        public $start = 0;
        public $currentBytes = 0;
        public $currentBits = 0;
        /**
         * @var int
         */
        public $width;
        /**
         * @var int
         */
        public $height;
        /**
         * @param string $sps
         */
        public function __construct($sps)
        {
        }
        public function readData()
        {
        }
        /**
         * @param int $bits
         */
        public function skipBits($bits)
        {
        }
        /**
         * @return int
         */
        public function getBit()
        {
        }
        /**
         * @param int $bits
         *
         * @return int
         */
        public function getBits($bits)
        {
        }
        /**
         * @return int
         */
        public function expGolombUe()
        {
        }
        /**
         * @return int
         */
        public function expGolombSe()
        {
        }
        /**
         * @return int
         */
        public function getWidth()
        {
        }
        /**
         * @return int
         */
        public function getHeight()
        {
        }
    }
    /**
    * @tutorial http://www.matroska.org/technical/specs/index.html
    *
    * @todo Rewrite EBML parser to reduce it's size and honor default element values
    * @todo After rewrite implement stream size calculation, that will provide additional useful info and enable AAC/FLAC audio bitrate detection
    */
    class getid3_matroska extends \getid3_handler
    {
        /**
         * If true, do not return information about CLUSTER chunks, since there's a lot of them
         * and they're not usually useful [default: TRUE].
         *
         * @var bool
         */
        public $hide_clusters = \true;
        /**
         * True to parse the whole file, not only header [default: FALSE].
         *
         * @var bool
         */
        public $parse_whole_file = \false;
        /**
         * @return bool
         */
        public function Analyze()
        {
        }
        /**
         * @param int $target_type
         *
         * @return string|int
         */
        public static function TargetTypeValue($target_type)
        {
        }
        /**
         * @param int $lacingtype
         *
         * @return string|int
         */
        public static function BlockLacingType($lacingtype)
        {
        }
        /**
         * @param string $codecid
         *
         * @return string
         */
        public static function CodecIDtoCommonName($codecid)
        {
        }
        /**
         * @param int $value
         *
         * @return string
         */
        public static function displayUnit($value)
        {
        }
    }
    class getid3_quicktime extends \getid3_handler
    {
        /** audio-video.quicktime
         * return all parsed data from all atoms if true, otherwise just returned parsed metadata
         *
         * @var bool
         */
        public $ReturnAtomData = \false;
        /** audio-video.quicktime
         * return all parsed data from all atoms if true, otherwise just returned parsed metadata
         *
         * @var bool
         */
        public $ParseAllPossibleAtoms = \false;
        /**
         * @return bool
         */
        public function Analyze()
        {
        }
        /**
         * @param string $atomname
         * @param int    $atomsize
         * @param string $atom_data
         * @param int    $baseoffset
         * @param array  $atomHierarchy
         * @param bool   $ParseAllPossibleAtoms
         *
         * @return array|false
         */
        public function QuicktimeParseAtom($atomname, $atomsize, $atom_data, $baseoffset, &$atomHierarchy, $ParseAllPossibleAtoms)
        {
        }
        /**
         * @param string $atom_data
         * @param int    $baseoffset
         * @param array  $atomHierarchy
         * @param bool   $ParseAllPossibleAtoms
         *
         * @return array|false
         */
        public function QuicktimeParseContainerAtom($atom_data, $baseoffset, &$atomHierarchy, $ParseAllPossibleAtoms)
        {
        }
        /**
         * @param string $data
         * @param int    $offset
         *
         * @return int
         */
        public function quicktime_read_mp4_descr_length($data, &$offset)
        {
        }
        /**
         * @param int $languageid
         *
         * @return string
         */
        public function QuicktimeLanguageLookup($languageid)
        {
        }
        /**
         * @param string $codecid
         *
         * @return string
         */
        public function QuicktimeVideoCodecLookup($codecid)
        {
        }
        /**
         * @param string $codecid
         *
         * @return mixed|string
         */
        public function QuicktimeAudioCodecLookup($codecid)
        {
        }
        /**
         * @param string $compressionid
         *
         * @return string
         */
        public function QuicktimeDCOMLookup($compressionid)
        {
        }
        /**
         * @param int $colordepthid
         *
         * @return string
         */
        public function QuicktimeColorNameLookup($colordepthid)
        {
        }
        /**
         * @param int $stik
         *
         * @return string
         */
        public function QuicktimeSTIKLookup($stik)
        {
        }
        /**
         * @param int $audio_profile_id
         *
         * @return string
         */
        public function QuicktimeIODSaudioProfileName($audio_profile_id)
        {
        }
        /**
         * @param int $video_profile_id
         *
         * @return string
         */
        public function QuicktimeIODSvideoProfileName($video_profile_id)
        {
        }
        /**
         * @param int $rtng
         *
         * @return string
         */
        public function QuicktimeContentRatingLookup($rtng)
        {
        }
        /**
         * @param int $akid
         *
         * @return string
         */
        public function QuicktimeStoreAccountTypeLookup($akid)
        {
        }
        /**
         * @param int $sfid
         *
         * @return string
         */
        public function QuicktimeStoreFrontCodeLookup($sfid)
        {
        }
        /**
         * @param string $keyname
         * @param string|array $data
         * @param string $boxname
         *
         * @return bool
         */
        public function CopyToAppropriateCommentsSection($keyname, $data, $boxname = '')
        {
        }
        /**
         * @param string $lstring
         * @param int    $count
         *
         * @return string
         */
        public function LociString($lstring, &$count)
        {
        }
        /**
         * @param string $nullterminatedstring
         *
         * @return string
         */
        public function NoNullString($nullterminatedstring)
        {
        }
        /**
         * @param string $pascalstring
         *
         * @return string
         */
        public function Pascal2String($pascalstring)
        {
        }
        /**
         * @param string $pascalstring
         *
         * @return string
         */
        public function MaybePascal2String($pascalstring)
        {
        }
        /**
         * Helper functions for m4b audiobook chapters
         * code by Steffen Hartmann 2015-Nov-08.
         *
         * @param array  $info
         * @param string $tag
         * @param string $history
         * @param array  $result
         */
        public function search_tag_by_key($info, $tag, $history, &$result)
        {
        }
        /**
         * @param array  $info
         * @param string $k
         * @param string $v
         * @param string $history
         * @param array  $result
         */
        public function search_tag_by_pair($info, $k, $v, $history, &$result)
        {
        }
        /**
         * @param array $info
         *
         * @return array
         */
        public function quicktime_time_to_sample_table($info)
        {
        }
        /**
         * @param array $info
         *
         * @return int
         */
        public function quicktime_bookmark_time_scale($info)
        {
        }
        /*
        // END helper functions for m4b audiobook chapters
        */
    }
    class getid3_riff extends \getid3_handler
    {
        protected $container = 'riff';
        /**
         * @return bool
         *
         * @throws getid3_exception
         */
        public function Analyze()
        {
        }
        /**
         * @param int $startoffset
         * @param int $maxoffset
         *
         * @return array|false
         *
         * @throws Exception
         * @throws getid3_exception
         */
        public function ParseRIFFAMV($startoffset, $maxoffset)
        {
        }
        /**
         * @param int $startoffset
         * @param int $maxoffset
         *
         * @return array|false
         * @throws getid3_exception
         */
        public function ParseRIFF($startoffset, $maxoffset)
        {
        }
        /**
         * @param string $RIFFdata
         *
         * @return bool
         */
        public function ParseRIFFdata(&$RIFFdata)
        {
        }
        /**
         * @param array $RIFFinfoArray
         * @param array $CommentsTargetArray
         *
         * @return bool
         */
        public static function parseComments(&$RIFFinfoArray, &$CommentsTargetArray)
        {
        }
        /**
         * @param string $WaveFormatExData
         *
         * @return array
         */
        public static function parseWAVEFORMATex($WaveFormatExData)
        {
        }
        /**
         * @param string $WavPackChunkData
         *
         * @return bool
         */
        public function parseWavPackHeader($WavPackChunkData)
        {
        }
        /**
         * @param string $BITMAPINFOHEADER
         * @param bool   $littleEndian
         *
         * @return array
         */
        public static function ParseBITMAPINFOHEADER($BITMAPINFOHEADER, $littleEndian = \true)
        {
        }
        /**
         * @param string $DIVXTAG
         * @param bool   $raw
         *
         * @return array
         */
        public static function ParseDIVXTAG($DIVXTAG, $raw = \false)
        {
        }
        /**
         * @param string $tagshortname
         *
         * @return string
         */
        public static function waveSNDMtagLookup($tagshortname)
        {
        }
        /**
         * @param int $wFormatTag
         *
         * @return string
         */
        public static function wFormatTagLookup($wFormatTag)
        {
        }
        /**
         * @param string $fourcc
         *
         * @return string
         */
        public static function fourccLookup($fourcc)
        {
        }
    }
    class getid3_ac3 extends \getid3_handler
    {
        const syncword = 0xb77;
        /**
         * @return bool
         */
        public function Analyze()
        {
        }
        /**
         * @param int $fscod
         *
         * @return int|string|false
         */
        public static function sampleRateCodeLookup($fscod)
        {
        }
        /**
         * @param int $fscod2
         *
         * @return int|string|false
         */
        public static function sampleRateCodeLookup2($fscod2)
        {
        }
        /**
         * @param int $bsmod
         * @param int $acmod
         *
         * @return string|false
         */
        public static function serviceTypeLookup($bsmod, $acmod)
        {
        }
        /**
         * @param int $acmod
         *
         * @return array|false
         */
        public static function audioCodingModeLookup($acmod)
        {
        }
        /**
         * @param int $cmixlev
         *
         * @return int|float|string|false
         */
        public static function centerMixLevelLookup($cmixlev)
        {
        }
        /**
         * @param int $surmixlev
         *
         * @return int|float|string|false
         */
        public static function surroundMixLevelLookup($surmixlev)
        {
        }
        /**
         * @param int $dsurmod
         *
         * @return string|false
         */
        public static function dolbySurroundModeLookup($dsurmod)
        {
        }
        /**
         * @param int  $acmod
         * @param bool $lfeon
         *
         * @return array
         */
        public static function channelsEnabledLookup($acmod, $lfeon)
        {
        }
        /**
         * @param int $compre
         *
         * @return float|int
         */
        public static function heavyCompression($compre)
        {
        }
        /**
         * @param int $roomtyp
         *
         * @return string|false
         */
        public static function roomTypeLookup($roomtyp)
        {
        }
        /**
         * @param int $frmsizecod
         * @param int $fscod
         *
         * @return int|false
         */
        public static function frameSizeLookup($frmsizecod, $fscod)
        {
        }
        /**
         * @param int $frmsizecod
         *
         * @return int|false
         */
        public static function bitrateLookup($frmsizecod)
        {
        }
        /**
         * @param int $numblkscod
         *
         * @return int|false
         */
        public static function blocksPerSyncFrame($numblkscod)
        {
        }
    }
    /**
    * @tutorial http://wiki.multimedia.cx/index.php?title=DTS
    */
    class getid3_dts extends \getid3_handler
    {
        /**
         * Default DTS syncword used in native .cpt or .dts formats.
         */
        const syncword = "\xfe\x80\x01";
        /**
         * Possible syncwords indicating bitstream encoding.
         */
        public static $syncwords = array(
            0 => "\xfe\x80\x01",
            // raw big-endian
            1 => "\xfe\x01\x80",
            // raw little-endian
            2 => "\x1f\xff\xe8\x00",
            // 14-bit big-endian
            3 => "\xff\x1f\x00\xe8",
        );
        /**
         * @return bool
         */
        public function Analyze()
        {
        }
        /**
         * @param int $index
         *
         * @return int|string|false
         */
        public static function bitrateLookup($index)
        {
        }
        /**
         * @param int $index
         *
         * @return int|string|false
         */
        public static function sampleRateLookup($index)
        {
        }
        /**
         * @param int $index
         *
         * @return int|false
         */
        public static function bitPerSampleLookup($index)
        {
        }
        /**
         * @param int $index
         *
         * @return int|false
         */
        public static function numChannelsLookup($index)
        {
        }
        /**
         * @param int $index
         *
         * @return string
         */
        public static function channelArrangementLookup($index)
        {
        }
        /**
         * @param int $index
         * @param int $version
         *
         * @return int|false
         */
        public static function dialogNormalization($index, $version)
        {
        }
    }
    /**
    * @tutorial http://flac.sourceforge.net/format.html
    */
    class getid3_flac extends \getid3_handler
    {
        const syncword = 'fLaC';
        /**
         * @return bool
         */
        public function Analyze()
        {
        }
        /**
         * @return bool
         */
        public function parseMETAdata()
        {
        }
        /**
         * @param string $BlockData
         *
         * @return array
         */
        public static function parseSTREAMINFOdata($BlockData)
        {
        }
        /**
         * Parse METADATA_BLOCK_PICTURE flac structure and extract attachment
         * External usage: audio.ogg
         *
         * @return bool
         */
        public function parsePICTURE()
        {
        }
        /**
         * @param int $blocktype
         *
         * @return string
         */
        public static function metaBlockTypeLookup($blocktype)
        {
        }
        /**
         * @param int $applicationid
         *
         * @return string
         */
        public static function applicationIDLookup($applicationid)
        {
        }
        /**
         * @param int $type_id
         *
         * @return string
         */
        public static function pictureTypeLookup($type_id)
        {
        }
    }
    class getid3_mp3 extends \getid3_handler
    {
        /**
         * Forces getID3() to scan the file byte-by-byte and log all the valid audio frame headers - extremely slow,
         * unrecommended, but may provide data from otherwise-unusable files.
         *
         * @var bool
         */
        public $allow_bruteforce = \false;
        /**
         * number of frames to scan to determine if MPEG-audio sequence is valid
         * Lower this number to 5-20 for faster scanning
         * Increase this number to 50+ for most accurate detection of valid VBR/CBR mpeg-audio streams
         *
         * @var int
         */
        public $mp3_valid_check_frames = 50;
        /**
         * @return bool
         */
        public function Analyze()
        {
        }
        /**
         * @return string
         */
        public function GuessEncoderOptions()
        {
        }
        /**
         * @param int   $offset
         * @param array $info
         * @param bool  $recursivesearch
         * @param bool  $ScanAsCBR
         * @param bool  $FastMPEGheaderScan
         *
         * @return bool
         */
        public function decodeMPEGaudioHeader($offset, &$info, $recursivesearch = \true, $ScanAsCBR = \false, $FastMPEGheaderScan = \false)
        {
        }
        /**
         * @param int $offset
         * @param int $nextframetestoffset
         * @param bool $ScanAsCBR
         *
         * @return bool
         */
        public function RecursiveFrameScanning(&$offset, &$nextframetestoffset, $ScanAsCBR)
        {
        }
        /**
         * @param int  $offset
         * @param bool $deepscan
         *
         * @return int|false
         */
        public function FreeFormatFrameLength($offset, $deepscan = \false)
        {
        }
        /**
         * @return bool
         */
        public function getOnlyMPEGaudioInfoBruteForce()
        {
        }
        /**
         * @param int  $avdataoffset
         * @param bool $BitrateHistogram
         *
         * @return bool
         */
        public function getOnlyMPEGaudioInfo($avdataoffset, $BitrateHistogram = \false)
        {
        }
        /**
         * @return array
         */
        public static function MPEGaudioVersionArray()
        {
        }
        /**
         * @return array
         */
        public static function MPEGaudioLayerArray()
        {
        }
        /**
         * @return array
         */
        public static function MPEGaudioBitrateArray()
        {
        }
        /**
         * @return array
         */
        public static function MPEGaudioFrequencyArray()
        {
        }
        /**
         * @return array
         */
        public static function MPEGaudioChannelModeArray()
        {
        }
        /**
         * @return array
         */
        public static function MPEGaudioModeExtensionArray()
        {
        }
        /**
         * @return array
         */
        public static function MPEGaudioEmphasisArray()
        {
        }
        /**
         * @param string $head4
         * @param bool   $allowBitrate15
         *
         * @return bool
         */
        public static function MPEGaudioHeaderBytesValid($head4, $allowBitrate15 = \false)
        {
        }
        /**
         * @param array $rawarray
         * @param bool  $echoerrors
         * @param bool  $allowBitrate15
         *
         * @return bool
         */
        public static function MPEGaudioHeaderValid($rawarray, $echoerrors = \false, $allowBitrate15 = \false)
        {
        }
        /**
         * @param string $Header4Bytes
         *
         * @return array|false
         */
        public static function MPEGaudioHeaderDecode($Header4Bytes)
        {
        }
        /**
         * @param int|string $bitrate
         * @param string     $version
         * @param string     $layer
         * @param bool       $padding
         * @param int        $samplerate
         *
         * @return int|false
         */
        public static function MPEGaudioFrameLength(&$bitrate, &$version, &$layer, $padding, &$samplerate)
        {
        }
        /**
         * @param float|int $bit_rate
         *
         * @return int|float|string
         */
        public static function ClosestStandardMP3Bitrate($bit_rate)
        {
        }
        /**
         * @param string $version
         * @param string $channelmode
         *
         * @return int
         */
        public static function XingVBRidOffset($version, $channelmode)
        {
        }
        /**
         * @param int $VBRmethodID
         *
         * @return string
         */
        public static function LAMEvbrMethodLookup($VBRmethodID)
        {
        }
        /**
         * @param int $StereoModeID
         *
         * @return string
         */
        public static function LAMEmiscStereoModeLookup($StereoModeID)
        {
        }
        /**
         * @param int $SourceSampleFrequencyID
         *
         * @return string
         */
        public static function LAMEmiscSourceSampleFrequencyLookup($SourceSampleFrequencyID)
        {
        }
        /**
         * @param int $SurroundInfoID
         *
         * @return string
         */
        public static function LAMEsurroundInfoLookup($SurroundInfoID)
        {
        }
        /**
         * @param array $LAMEtag
         *
         * @return string
         */
        public static function LAMEpresetUsedLookup($LAMEtag)
        {
        }
    }
    class getid3_ogg extends \getid3_handler
    {
        /**
         * @link http://xiph.org/vorbis/doc/Vorbis_I_spec.html
         *
         * @return bool
         */
        public function Analyze()
        {
        }
        /**
         * @param string $filedata
         * @param int    $filedataoffset
         * @param array  $oggpageinfo
         *
         * @return bool
         */
        public function ParseVorbisPageHeader(&$filedata, &$filedataoffset, &$oggpageinfo)
        {
        }
        /**
         * @link http://tools.ietf.org/html/draft-ietf-codec-oggopus-03
         *
         * @param string $filedata
         * @param int    $filedataoffset
         * @param array  $oggpageinfo
         *
         * @return bool
         */
        public function ParseOpusPageHeader(&$filedata, &$filedataoffset, &$oggpageinfo)
        {
        }
        /**
         * @return array|false
         */
        public function ParseOggPageHeader()
        {
        }
        /**
         * @link http://xiph.org/vorbis/doc/Vorbis_I_spec.html#x1-810005
         *
         * @return bool
         */
        public function ParseVorbisComments()
        {
        }
        /**
         * @param int $mode
         *
         * @return string|null
         */
        public static function SpeexBandModeLookup($mode)
        {
        }
        /**
         * @param array $OggInfoArray
         * @param int   $SegmentNumber
         *
         * @return int
         */
        public static function OggPageSegmentLength($OggInfoArray, $SegmentNumber = 1)
        {
        }
        /**
         * @param int $nominal_bitrate
         *
         * @return float
         */
        public static function get_quality_from_nominal_bitrate($nominal_bitrate)
        {
        }
        /**
         * @param int $colorspace_id
         *
         * @return string|null
         */
        public static function TheoraColorSpace($colorspace_id)
        {
        }
        /**
         * @param int $pixelformat_id
         *
         * @return string|null
         */
        public static function TheoraPixelFormat($pixelformat_id)
        {
        }
    }
    class getid3_apetag extends \getid3_handler
    {
        /**
         * true: return full data for all attachments;
         * false: return no data for all attachments;
         * integer: return data for attachments <= than this;
         * string: save as file to this directory.
         *
         * @var int|bool|string
         */
        public $inline_attachments = \true;
        public $overrideendoffset = 0;
        /**
         * @return bool
         */
        public function Analyze()
        {
        }
        /**
         * @param string $APEheaderFooterData
         *
         * @return array|false
         */
        public function parseAPEheaderFooter($APEheaderFooterData)
        {
        }
        /**
         * @param int $rawflagint
         *
         * @return array
         */
        public function parseAPEtagFlags($rawflagint)
        {
        }
        /**
         * @param int $contenttypeid
         *
         * @return string
         */
        public function APEcontentTypeFlagLookup($contenttypeid)
        {
        }
        /**
         * @param string $itemkey
         *
         * @return bool
         */
        public function APEtagItemIsUTF8Lookup($itemkey)
        {
        }
    }
    class getid3_id3v1 extends \getid3_handler
    {
        /**
         * @return bool
         */
        public function Analyze()
        {
        }
        /**
         * @param string $str
         *
         * @return string
         */
        public static function cutfield($str)
        {
        }
        /**
         * @param bool $allowSCMPXextended
         *
         * @return string[]
         */
        public static function ArrayOfGenres($allowSCMPXextended = \false)
        {
        }
        /**
         * @param string $genreid
         * @param bool   $allowSCMPXextended
         *
         * @return string|false
         */
        public static function LookupGenreName($genreid, $allowSCMPXextended = \true)
        {
        }
        /**
         * @param string $genre
         * @param bool   $allowSCMPXextended
         *
         * @return string|false
         */
        public static function LookupGenreID($genre, $allowSCMPXextended = \false)
        {
        }
        /**
         * @param string $OriginalGenre
         *
         * @return string|false
         */
        public static function StandardiseID3v1GenreName($OriginalGenre)
        {
        }
        /**
         * @param string     $title
         * @param string     $artist
         * @param string     $album
         * @param string     $year
         * @param int        $genreid
         * @param string     $comment
         * @param int|string $track
         *
         * @return string
         */
        public static function GenerateID3v1Tag($title, $artist, $album, $year, $genreid, $comment, $track = '')
        {
        }
    }
    class getid3_id3v2 extends \getid3_handler
    {
        public $StartingOffset = 0;
        /**
         * @return bool
         */
        public function Analyze()
        {
        }
        /**
         * @param string $genrestring
         *
         * @return array
         */
        public function ParseID3v2GenreString($genrestring)
        {
        }
        /**
         * @param array $parsedFrame
         *
         * @return bool
         */
        public function ParseID3v2Frame(&$parsedFrame)
        {
        }
        /**
         * @param string $data
         *
         * @return string
         */
        public function DeUnsynchronise($data)
        {
        }
        /**
         * @param int $index
         *
         * @return string
         */
        public function LookupExtendedHeaderRestrictionsTagSizeLimits($index)
        {
        }
        /**
         * @param int $index
         *
         * @return string
         */
        public function LookupExtendedHeaderRestrictionsTextEncodings($index)
        {
        }
        /**
         * @param int $index
         *
         * @return string
         */
        public function LookupExtendedHeaderRestrictionsTextFieldSize($index)
        {
        }
        /**
         * @param int $index
         *
         * @return string
         */
        public function LookupExtendedHeaderRestrictionsImageEncoding($index)
        {
        }
        /**
         * @param int $index
         *
         * @return string
         */
        public function LookupExtendedHeaderRestrictionsImageSizeSize($index)
        {
        }
        /**
         * @param string $currencyid
         *
         * @return string
         */
        public function LookupCurrencyUnits($currencyid)
        {
        }
        /**
         * @param string $currencyid
         *
         * @return string
         */
        public function LookupCurrencyCountry($currencyid)
        {
        }
        /**
         * @param string $languagecode
         * @param bool   $casesensitive
         *
         * @return string
         */
        public static function LanguageLookup($languagecode, $casesensitive = \false)
        {
        }
        /**
         * @param int $index
         *
         * @return string
         */
        public static function ETCOEventLookup($index)
        {
        }
        /**
         * @param int $index
         *
         * @return string
         */
        public static function SYTLContentTypeLookup($index)
        {
        }
        /**
         * @param int   $index
         * @param bool $returnarray
         *
         * @return array|string
         */
        public static function APICPictureTypeLookup($index, $returnarray = \false)
        {
        }
        /**
         * @param int $index
         *
         * @return string
         */
        public static function COMRReceivedAsLookup($index)
        {
        }
        /**
         * @param int $index
         *
         * @return string
         */
        public static function RVA2ChannelTypeLookup($index)
        {
        }
        /**
         * @param string $framename
         *
         * @return string
         */
        public static function FrameNameLongLookup($framename)
        {
        }
        /**
         * @param string $framename
         *
         * @return string
         */
        public static function FrameNameShortLookup($framename)
        {
        }
        /**
         * @param string $encoding
         *
         * @return string
         */
        public static function TextEncodingTerminatorLookup($encoding)
        {
        }
        /**
         * @param int $encoding
         *
         * @return string
         */
        public static function TextEncodingNameLookup($encoding)
        {
        }
        /**
         * @param string $string
         * @param string $terminator
         *
         * @return string
         */
        public static function RemoveStringTerminator($string, $terminator)
        {
        }
        /**
         * @param string $string
         *
         * @return string
         */
        public static function MakeUTF16emptyStringEmpty($string)
        {
        }
        /**
         * @param string $framename
         * @param int    $id3v2majorversion
         *
         * @return bool|int
         */
        public static function IsValidID3v2FrameName($framename, $id3v2majorversion)
        {
        }
        /**
         * @param string $numberstring
         * @param bool   $allowdecimal
         * @param bool   $allownegative
         *
         * @return bool
         */
        public static function IsANumber($numberstring, $allowdecimal = \false, $allownegative = \false)
        {
        }
        /**
         * @param string $datestamp
         *
         * @return bool
         */
        public static function IsValidDateStampString($datestamp)
        {
        }
        /**
         * @param int $majorversion
         *
         * @return int
         */
        public static function ID3v2HeaderLength($majorversion)
        {
        }
        /**
         * @param string $frame_name
         *
         * @return string|false
         */
        public static function ID3v22iTunesBrokenFrameName($frame_name)
        {
        }
    }
    class getid3_lyrics3 extends \getid3_handler
    {
        /**
         * @return bool
         */
        public function Analyze()
        {
        }
        /**
         * @param int $endoffset
         * @param int $version
         * @param int $length
         *
         * @return bool
         */
        public function getLyrics3Data($endoffset, $version, $length)
        {
        }
        /**
         * @param string $rawtimestamp
         *
         * @return int|false
         */
        public function Lyrics3Timestamp2Seconds($rawtimestamp)
        {
        }
        /**
         * @param array $Lyrics3data
         *
         * @return bool
         */
        public function Lyrics3LyricsTimestampParse(&$Lyrics3data)
        {
        }
        /**
         * @param string $char
         *
         * @return bool|null
         */
        public function IntString2Bool($char)
        {
        }
    }
    /**
     * IXR_Base64
     *
     * @package IXR
     * @since 1.5.0
     */
    class IXR_Base64
    {
        var $data;
        /**
         * PHP5 constructor.
         */
        function __construct($data)
        {
        }
        /**
         * PHP4 constructor.
         */
        public function IXR_Base64($data)
        {
        }
        function getXml()
        {
        }
    }
    /**
     * IXR_Client
     *
     * @package IXR
     * @since 1.5.0
     *
     */
    class IXR_Client
    {
        var $server;
        var $port;
        var $path;
        var $useragent;
        var $response;
        var $message = \false;
        var $debug = \false;
        var $timeout;
        var $headers = array();
        var $error = \false;
        /**
         * PHP5 constructor.
         */
        function __construct($server, $path = \false, $port = 80, $timeout = 15)
        {
        }
        /**
         * PHP4 constructor.
         */
        public function IXR_Client($server, $path = \false, $port = 80, $timeout = 15)
        {
        }
        /**
         * @since 1.5.0
         * @since 5.5.0 Formalized the existing `...$args` parameter by adding it
         *              to the function signature.
         *
         * @return bool
         */
        function query(...$args)
        {
        }
        function getResponse()
        {
        }
        function isError()
        {
        }
        function getErrorCode()
        {
        }
        function getErrorMessage()
        {
        }
    }
    /**
     * IXR_ClientMulticall
     *
     * @package IXR
     * @since 1.5.0
     */
    class IXR_ClientMulticall extends \IXR_Client
    {
        var $calls = array();
        /**
         * PHP5 constructor.
         */
        function __construct($server, $path = \false, $port = 80)
        {
        }
        /**
         * PHP4 constructor.
         */
        public function IXR_ClientMulticall($server, $path = \false, $port = 80)
        {
        }
        /**
         * @since 1.5.0
         * @since 5.5.0 Formalized the existing `...$args` parameter by adding it
         *              to the function signature.
         */
        function addCall(...$args)
        {
        }
        /**
         * @since 1.5.0
         * @since 5.5.0 Formalized the existing `...$args` parameter by adding it
         *              to the function signature.
         *
         * @return bool
         */
        function query(...$args)
        {
        }
    }
    /**
     * IXR_Date
     *
     * @package IXR
     * @since 1.5.0
     */
    class IXR_Date
    {
        var $year;
        var $month;
        var $day;
        var $hour;
        var $minute;
        var $second;
        var $timezone;
        /**
         * PHP5 constructor.
         */
        function __construct($time)
        {
        }
        /**
         * PHP4 constructor.
         */
        public function IXR_Date($time)
        {
        }
        function parseTimestamp($timestamp)
        {
        }
        function parseIso($iso)
        {
        }
        function getIso()
        {
        }
        function getXml()
        {
        }
        function getTimestamp()
        {
        }
    }
    /**
     * IXR_Error
     *
     * @package IXR
     * @since 1.5.0
     */
    class IXR_Error
    {
        var $code;
        var $message;
        /**
         * PHP5 constructor.
         */
        function __construct($code, $message)
        {
        }
        /**
         * PHP4 constructor.
         */
        public function IXR_Error($code, $message)
        {
        }
        function getXml()
        {
        }
    }
    /**
     * IXR_Server
     *
     * @package IXR
     * @since 1.5.0
     */
    class IXR_Server
    {
        var $data;
        var $callbacks = array();
        var $message;
        var $capabilities;
        /**
         * PHP5 constructor.
         */
        function __construct($callbacks = \false, $data = \false, $wait = \false)
        {
        }
        /**
         * PHP4 constructor.
         */
        public function IXR_Server($callbacks = \false, $data = \false, $wait = \false)
        {
        }
        function serve($data = \false)
        {
        }
        function call($methodname, $args)
        {
        }
        function error($error, $message = \false)
        {
        }
        function output($xml)
        {
        }
        function hasMethod($method)
        {
        }
        function setCapabilities()
        {
        }
        function getCapabilities($args)
        {
        }
        function setCallbacks()
        {
        }
        function listMethods($args)
        {
        }
        function multiCall($methodcalls)
        {
        }
    }
    /**
     * IXR_IntrospectionServer
     *
     * @package IXR
     * @since 1.5.0
     */
    class IXR_IntrospectionServer extends \IXR_Server
    {
        var $signatures;
        var $help;
        /**
         * PHP5 constructor.
         */
        function __construct()
        {
        }
        /**
         * PHP4 constructor.
         */
        public function IXR_IntrospectionServer()
        {
        }
        function addCallback($method, $callback, $args, $help)
        {
        }
        function call($methodname, $args)
        {
        }
        function methodSignature($method)
        {
        }
        function methodHelp($method)
        {
        }
    }
    /**
     * IXR_MESSAGE
     *
     * @package IXR
     * @since 1.5.0
     *
     */
    class IXR_Message
    {
        var $message = \false;
        var $messageType = \false;
        var $faultCode = \false;
        var $faultString = \false;
        var $methodName = '';
        var $params = array();
        var $_arraystructs = array();
        var $_arraystructstypes = array();
        var $_currentStructName = array();
        var $_param;
        var $_value;
        var $_currentTag;
        var $_currentTagContents;
        var $_parser;
        /**
         * PHP5 constructor.
         */
        function __construct($message)
        {
        }
        /**
         * PHP4 constructor.
         */
        public function IXR_Message($message)
        {
        }
        function parse()
        {
        }
        function tag_open($parser, $tag, $attr)
        {
        }
        function cdata($parser, $cdata)
        {
        }
        function tag_close($parser, $tag)
        {
        }
    }
    /**
     * IXR_Request
     *
     * @package IXR
     * @since 1.5.0
     */
    class IXR_Request
    {
        var $method;
        var $args;
        var $xml;
        /**
         * PHP5 constructor.
         */
        function __construct($method, $args)
        {
        }
        /**
         * PHP4 constructor.
         */
        public function IXR_Request($method, $args)
        {
        }
        function getLength()
        {
        }
        function getXml()
        {
        }
    }
    /**
     * IXR_Value
     *
     * @package IXR
     * @since 1.5.0
     */
    class IXR_Value
    {
        var $data;
        var $type;
        /**
         * PHP5 constructor.
         */
        function __construct($data, $type = \false)
        {
        }
        /**
         * PHP4 constructor.
         */
        public function IXR_Value($data, $type = \false)
        {
        }
        function calculateType()
        {
        }
        function getXml()
        {
        }
        /**
         * Checks whether or not the supplied array is a struct or not
         *
         * @param array $array
         * @return bool
         */
        function isStruct($array)
        {
        }
    }
}
namespace PHPMailer\PHPMailer {
    /**
     * PHPMailer exception handler.
     *
     * @author Marcus Bointon <phpmailer@synchromedia.co.uk>
     */
    class Exception extends \Exception
    {
        /**
         * Prettify error message output.
         *
         * @return string
         */
        public function errorMessage()
        {
        }
    }
    /**
     * PHPMailer - PHP email creation and transport class.
     *
     * @author Marcus Bointon (Synchro/coolbru) <phpmailer@synchromedia.co.uk>
     * @author Jim Jagielski (jimjag) <jimjag@gmail.com>
     * @author Andy Prevost (codeworxtech) <codeworxtech@users.sourceforge.net>
     * @author Brent R. Matzelle (original founder)
     */
    class PHPMailer
    {
        const CHARSET_ASCII = 'us-ascii';
        const CHARSET_ISO88591 = 'iso-8859-1';
        const CHARSET_UTF8 = 'utf-8';
        const CONTENT_TYPE_PLAINTEXT = 'text/plain';
        const CONTENT_TYPE_TEXT_CALENDAR = 'text/calendar';
        const CONTENT_TYPE_TEXT_HTML = 'text/html';
        const CONTENT_TYPE_MULTIPART_ALTERNATIVE = 'multipart/alternative';
        const CONTENT_TYPE_MULTIPART_MIXED = 'multipart/mixed';
        const CONTENT_TYPE_MULTIPART_RELATED = 'multipart/related';
        const ENCODING_7BIT = '7bit';
        const ENCODING_8BIT = '8bit';
        const ENCODING_BASE64 = 'base64';
        const ENCODING_BINARY = 'binary';
        const ENCODING_QUOTED_PRINTABLE = 'quoted-printable';
        const ENCRYPTION_STARTTLS = 'tls';
        const ENCRYPTION_SMTPS = 'ssl';
        const ICAL_METHOD_REQUEST = 'REQUEST';
        const ICAL_METHOD_PUBLISH = 'PUBLISH';
        const ICAL_METHOD_REPLY = 'REPLY';
        const ICAL_METHOD_ADD = 'ADD';
        const ICAL_METHOD_CANCEL = 'CANCEL';
        const ICAL_METHOD_REFRESH = 'REFRESH';
        const ICAL_METHOD_COUNTER = 'COUNTER';
        const ICAL_METHOD_DECLINECOUNTER = 'DECLINECOUNTER';
        /**
         * Email priority.
         * Options: null (default), 1 = High, 3 = Normal, 5 = low.
         * When null, the header is not set at all.
         *
         * @var int|null
         */
        public $Priority;
        /**
         * The character set of the message.
         *
         * @var string
         */
        public $CharSet = self::CHARSET_ISO88591;
        /**
         * The MIME Content-type of the message.
         *
         * @var string
         */
        public $ContentType = self::CONTENT_TYPE_PLAINTEXT;
        /**
         * The message encoding.
         * Options: "8bit", "7bit", "binary", "base64", and "quoted-printable".
         *
         * @var string
         */
        public $Encoding = self::ENCODING_8BIT;
        /**
         * Holds the most recent mailer error message.
         *
         * @var string
         */
        public $ErrorInfo = '';
        /**
         * The From email address for the message.
         *
         * @var string
         */
        public $From = '';
        /**
         * The From name of the message.
         *
         * @var string
         */
        public $FromName = '';
        /**
         * The envelope sender of the message.
         * This will usually be turned into a Return-Path header by the receiver,
         * and is the address that bounces will be sent to.
         * If not empty, will be passed via `-f` to sendmail or as the 'MAIL FROM' value over SMTP.
         *
         * @var string
         */
        public $Sender = '';
        /**
         * The Subject of the message.
         *
         * @var string
         */
        public $Subject = '';
        /**
         * An HTML or plain text message body.
         * If HTML then call isHTML(true).
         *
         * @var string
         */
        public $Body = '';
        /**
         * The plain-text message body.
         * This body can be read by mail clients that do not have HTML email
         * capability such as mutt & Eudora.
         * Clients that can read HTML will view the normal Body.
         *
         * @var string
         */
        public $AltBody = '';
        /**
         * An iCal message part body.
         * Only supported in simple alt or alt_inline message types
         * To generate iCal event structures, use classes like EasyPeasyICS or iCalcreator.
         *
         * @see https://kigkonsult.se/iCalcreator/
         *
         * @var string
         */
        public $Ical = '';
        /**
         * Value-array of "method" in Contenttype header "text/calendar"
         *
         * @var string[]
         */
        protected static $IcalMethods = [self::ICAL_METHOD_REQUEST, self::ICAL_METHOD_PUBLISH, self::ICAL_METHOD_REPLY, self::ICAL_METHOD_ADD, self::ICAL_METHOD_CANCEL, self::ICAL_METHOD_REFRESH, self::ICAL_METHOD_COUNTER, self::ICAL_METHOD_DECLINECOUNTER];
        /**
         * The complete compiled MIME message body.
         *
         * @var string
         */
        protected $MIMEBody = '';
        /**
         * The complete compiled MIME message headers.
         *
         * @var string
         */
        protected $MIMEHeader = '';
        /**
         * Extra headers that createHeader() doesn't fold in.
         *
         * @var string
         */
        protected $mailHeader = '';
        /**
         * Word-wrap the message body to this number of chars.
         * Set to 0 to not wrap. A useful value here is 78, for RFC2822 section 2.1.1 compliance.
         *
         * @see static::STD_LINE_LENGTH
         *
         * @var int
         */
        public $WordWrap = 0;
        /**
         * Which method to use to send mail.
         * Options: "mail", "sendmail", or "smtp".
         *
         * @var string
         */
        public $Mailer = 'mail';
        /**
         * The path to the sendmail program.
         *
         * @var string
         */
        public $Sendmail = '/usr/sbin/sendmail';
        /**
         * Whether mail() uses a fully sendmail-compatible MTA.
         * One which supports sendmail's "-oi -f" options.
         *
         * @var bool
         */
        public $UseSendmailOptions = true;
        /**
         * The email address that a reading confirmation should be sent to, also known as read receipt.
         *
         * @var string
         */
        public $ConfirmReadingTo = '';
        /**
         * The hostname to use in the Message-ID header and as default HELO string.
         * If empty, PHPMailer attempts to find one with, in order,
         * $_SERVER['SERVER_NAME'], gethostname(), php_uname('n'), or the value
         * 'localhost.localdomain'.
         *
         * @see PHPMailer::$Helo
         *
         * @var string
         */
        public $Hostname = '';
        /**
         * An ID to be used in the Message-ID header.
         * If empty, a unique id will be generated.
         * You can set your own, but it must be in the format "<id@domain>",
         * as defined in RFC5322 section 3.6.4 or it will be ignored.
         *
         * @see https://www.rfc-editor.org/rfc/rfc5322#section-3.6.4
         *
         * @var string
         */
        public $MessageID = '';
        /**
         * The message Date to be used in the Date header.
         * If empty, the current date will be added.
         *
         * @var string
         */
        public $MessageDate = '';
        /**
         * SMTP hosts.
         * Either a single hostname or multiple semicolon-delimited hostnames.
         * You can also specify a different port
         * for each host by using this format: [hostname:port]
         * (e.g. "smtp1.example.com:25;smtp2.example.com").
         * You can also specify encryption type, for example:
         * (e.g. "tls://smtp1.example.com:587;ssl://smtp2.example.com:465").
         * Hosts will be tried in order.
         *
         * @var string
         */
        public $Host = 'localhost';
        /**
         * The default SMTP server port.
         *
         * @var int
         */
        public $Port = 25;
        /**
         * The SMTP HELO/EHLO name used for the SMTP connection.
         * Default is $Hostname. If $Hostname is empty, PHPMailer attempts to find
         * one with the same method described above for $Hostname.
         *
         * @see PHPMailer::$Hostname
         *
         * @var string
         */
        public $Helo = '';
        /**
         * What kind of encryption to use on the SMTP connection.
         * Options: '', static::ENCRYPTION_STARTTLS, or static::ENCRYPTION_SMTPS.
         *
         * @var string
         */
        public $SMTPSecure = '';
        /**
         * Whether to enable TLS encryption automatically if a server supports it,
         * even if `SMTPSecure` is not set to 'tls'.
         * Be aware that in PHP >= 5.6 this requires that the server's certificates are valid.
         *
         * @var bool
         */
        public $SMTPAutoTLS = true;
        /**
         * Whether to use SMTP authentication.
         * Uses the Username and Password properties.
         *
         * @see PHPMailer::$Username
         * @see PHPMailer::$Password
         *
         * @var bool
         */
        public $SMTPAuth = false;
        /**
         * Options array passed to stream_context_create when connecting via SMTP.
         *
         * @var array
         */
        public $SMTPOptions = [];
        /**
         * SMTP username.
         *
         * @var string
         */
        public $Username = '';
        /**
         * SMTP password.
         *
         * @var string
         */
        public $Password = '';
        /**
         * SMTP authentication type. Options are CRAM-MD5, LOGIN, PLAIN, XOAUTH2.
         * If not specified, the first one from that list that the server supports will be selected.
         *
         * @var string
         */
        public $AuthType = '';
        /**
         * SMTP SMTPXClient command attributes
         *
         * @var array
         */
        protected $SMTPXClient = [];
        /**
         * An implementation of the PHPMailer OAuthTokenProvider interface.
         *
         * @var OAuthTokenProvider
         */
        protected $oauth;
        /**
         * The SMTP server timeout in seconds.
         * Default of 5 minutes (300sec) is from RFC2821 section 4.5.3.2.
         *
         * @var int
         */
        public $Timeout = 300;
        /**
         * Comma separated list of DSN notifications
         * 'NEVER' under no circumstances a DSN must be returned to the sender.
         *         If you use NEVER all other notifications will be ignored.
         * 'SUCCESS' will notify you when your mail has arrived at its destination.
         * 'FAILURE' will arrive if an error occurred during delivery.
         * 'DELAY'   will notify you if there is an unusual delay in delivery, but the actual
         *           delivery's outcome (success or failure) is not yet decided.
         *
         * @see https://www.rfc-editor.org/rfc/rfc3461.html#section-4.1 for more information about NOTIFY
         */
        public $dsn = '';
        /**
         * SMTP class debug output mode.
         * Debug output level.
         * Options:
         * @see SMTP::DEBUG_OFF: No output
         * @see SMTP::DEBUG_CLIENT: Client messages
         * @see SMTP::DEBUG_SERVER: Client and server messages
         * @see SMTP::DEBUG_CONNECTION: As SERVER plus connection status
         * @see SMTP::DEBUG_LOWLEVEL: Noisy, low-level data output, rarely needed
         *
         * @see SMTP::$do_debug
         *
         * @var int
         */
        public $SMTPDebug = 0;
        /**
         * How to handle debug output.
         * Options:
         * * `echo` Output plain-text as-is, appropriate for CLI
         * * `html` Output escaped, line breaks converted to `<br>`, appropriate for browser output
         * * `error_log` Output to error log as configured in php.ini
         * By default PHPMailer will use `echo` if run from a `cli` or `cli-server` SAPI, `html` otherwise.
         * Alternatively, you can provide a callable expecting two params: a message string and the debug level:
         *
         * ```php
         * $mail->Debugoutput = function($str, $level) {echo "debug level $level; message: $str";};
         * ```
         *
         * Alternatively, you can pass in an instance of a PSR-3 compatible logger, though only `debug`
         * level output is used:
         *
         * ```php
         * $mail->Debugoutput = new myPsr3Logger;
         * ```
         *
         * @see SMTP::$Debugoutput
         *
         * @var string|callable|\Psr\Log\LoggerInterface
         */
        public $Debugoutput = 'echo';
        /**
         * Whether to keep the SMTP connection open after each message.
         * If this is set to true then the connection will remain open after a send,
         * and closing the connection will require an explicit call to smtpClose().
         * It's a good idea to use this if you are sending multiple messages as it reduces overhead.
         * See the mailing list example for how to use it.
         *
         * @var bool
         */
        public $SMTPKeepAlive = false;
        /**
         * Whether to split multiple to addresses into multiple messages
         * or send them all in one message.
         * Only supported in `mail` and `sendmail` transports, not in SMTP.
         *
         * @var bool
         *
         * @deprecated 6.0.0 PHPMailer isn't a mailing list manager!
         */
        public $SingleTo = false;
        /**
         * Storage for addresses when SingleTo is enabled.
         *
         * @var array
         */
        protected $SingleToArray = [];
        /**
         * Whether to generate VERP addresses on send.
         * Only applicable when sending via SMTP.
         *
         * @see https://en.wikipedia.org/wiki/Variable_envelope_return_path
         * @see https://www.postfix.org/VERP_README.html Postfix VERP info
         *
         * @var bool
         */
        public $do_verp = false;
        /**
         * Whether to allow sending messages with an empty body.
         *
         * @var bool
         */
        public $AllowEmpty = false;
        /**
         * DKIM selector.
         *
         * @var string
         */
        public $DKIM_selector = '';
        /**
         * DKIM Identity.
         * Usually the email address used as the source of the email.
         *
         * @var string
         */
        public $DKIM_identity = '';
        /**
         * DKIM passphrase.
         * Used if your key is encrypted.
         *
         * @var string
         */
        public $DKIM_passphrase = '';
        /**
         * DKIM signing domain name.
         *
         * @example 'example.com'
         *
         * @var string
         */
        public $DKIM_domain = '';
        /**
         * DKIM Copy header field values for diagnostic use.
         *
         * @var bool
         */
        public $DKIM_copyHeaderFields = true;
        /**
         * DKIM Extra signing headers.
         *
         * @example ['List-Unsubscribe', 'List-Help']
         *
         * @var array
         */
        public $DKIM_extraHeaders = [];
        /**
         * DKIM private key file path.
         *
         * @var string
         */
        public $DKIM_private = '';
        /**
         * DKIM private key string.
         *
         * If set, takes precedence over `$DKIM_private`.
         *
         * @var string
         */
        public $DKIM_private_string = '';
        /**
         * Callback Action function name.
         *
         * The function that handles the result of the send email action.
         * It is called out by send() for each email sent.
         *
         * Value can be any php callable: https://www.php.net/is_callable
         *
         * Parameters:
         *   bool $result           result of the send action
         *   array   $to            email addresses of the recipients
         *   array   $cc            cc email addresses
         *   array   $bcc           bcc email addresses
         *   string  $subject       the subject
         *   string  $body          the email body
         *   string  $from          email address of sender
         *   string  $extra         extra information of possible use
         *                          "smtp_transaction_id' => last smtp transaction id
         *
         * @var string
         */
        public $action_function = '';
        /**
         * What to put in the X-Mailer header.
         * Options: An empty string for PHPMailer default, whitespace/null for none, or a string to use.
         *
         * @var string|null
         */
        public $XMailer = '';
        /**
         * Which validator to use by default when validating email addresses.
         * May be a callable to inject your own validator, but there are several built-in validators.
         * The default validator uses PHP's FILTER_VALIDATE_EMAIL filter_var option.
         *
         * @see PHPMailer::validateAddress()
         *
         * @var string|callable
         */
        public static $validator = 'php';
        /**
         * An instance of the SMTP sender class.
         *
         * @var SMTP
         */
        protected $smtp;
        /**
         * The array of 'to' names and addresses.
         *
         * @var array
         */
        protected $to = [];
        /**
         * The array of 'cc' names and addresses.
         *
         * @var array
         */
        protected $cc = [];
        /**
         * The array of 'bcc' names and addresses.
         *
         * @var array
         */
        protected $bcc = [];
        /**
         * The array of reply-to names and addresses.
         *
         * @var array
         */
        protected $ReplyTo = [];
        /**
         * An array of all kinds of addresses.
         * Includes all of $to, $cc, $bcc.
         *
         * @see PHPMailer::$to
         * @see PHPMailer::$cc
         * @see PHPMailer::$bcc
         *
         * @var array
         */
        protected $all_recipients = [];
        /**
         * An array of names and addresses queued for validation.
         * In send(), valid and non duplicate entries are moved to $all_recipients
         * and one of $to, $cc, or $bcc.
         * This array is used only for addresses with IDN.
         *
         * @see PHPMailer::$to
         * @see PHPMailer::$cc
         * @see PHPMailer::$bcc
         * @see PHPMailer::$all_recipients
         *
         * @var array
         */
        protected $RecipientsQueue = [];
        /**
         * An array of reply-to names and addresses queued for validation.
         * In send(), valid and non duplicate entries are moved to $ReplyTo.
         * This array is used only for addresses with IDN.
         *
         * @see PHPMailer::$ReplyTo
         *
         * @var array
         */
        protected $ReplyToQueue = [];
        /**
         * The array of attachments.
         *
         * @var array
         */
        protected $attachment = [];
        /**
         * The array of custom headers.
         *
         * @var array
         */
        protected $CustomHeader = [];
        /**
         * The most recent Message-ID (including angular brackets).
         *
         * @var string
         */
        protected $lastMessageID = '';
        /**
         * The message's MIME type.
         *
         * @var string
         */
        protected $message_type = '';
        /**
         * The array of MIME boundary strings.
         *
         * @var array
         */
        protected $boundary = [];
        /**
         * The array of available text strings for the current language.
         *
         * @var array
         */
        protected $language = [];
        /**
         * The number of errors encountered.
         *
         * @var int
         */
        protected $error_count = 0;
        /**
         * The S/MIME certificate file path.
         *
         * @var string
         */
        protected $sign_cert_file = '';
        /**
         * The S/MIME key file path.
         *
         * @var string
         */
        protected $sign_key_file = '';
        /**
         * The optional S/MIME extra certificates ("CA Chain") file path.
         *
         * @var string
         */
        protected $sign_extracerts_file = '';
        /**
         * The S/MIME password for the key.
         * Used only if the key is encrypted.
         *
         * @var string
         */
        protected $sign_key_pass = '';
        /**
         * Whether to throw exceptions for errors.
         *
         * @var bool
         */
        protected $exceptions = false;
        /**
         * Unique ID used for message ID and boundaries.
         *
         * @var string
         */
        protected $uniqueid = '';
        /**
         * The PHPMailer Version number.
         *
         * @var string
         */
        const VERSION = '6.9.3';
        /**
         * Error severity: message only, continue processing.
         *
         * @var int
         */
        const STOP_MESSAGE = 0;
        /**
         * Error severity: message, likely ok to continue processing.
         *
         * @var int
         */
        const STOP_CONTINUE = 1;
        /**
         * Error severity: message, plus full stop, critical error reached.
         *
         * @var int
         */
        const STOP_CRITICAL = 2;
        /**
         * The SMTP standard CRLF line break.
         * If you want to change line break format, change static::$LE, not this.
         */
        const CRLF = "\r\n";
        /**
         * "Folding White Space" a white space string used for line folding.
         */
        const FWS = ' ';
        /**
         * SMTP RFC standard line ending; Carriage Return, Line Feed.
         *
         * @var string
         */
        protected static $LE = self::CRLF;
        /**
         * The maximum line length supported by mail().
         *
         * Background: mail() will sometimes corrupt messages
         * with headers longer than 65 chars, see #818.
         *
         * @var int
         */
        const MAIL_MAX_LINE_LENGTH = 63;
        /**
         * The maximum line length allowed by RFC 2822 section 2.1.1.
         *
         * @var int
         */
        const MAX_LINE_LENGTH = 998;
        /**
         * The lower maximum line length allowed by RFC 2822 section 2.1.1.
         * This length does NOT include the line break
         * 76 means that lines will be 77 or 78 chars depending on whether
         * the line break format is LF or CRLF; both are valid.
         *
         * @var int
         */
        const STD_LINE_LENGTH = 76;
        /**
         * Constructor.
         *
         * @param bool $exceptions Should we throw external exceptions?
         */
        public function __construct($exceptions = null)
        {
        }
        /**
         * Destructor.
         */
        public function __destruct()
        {
        }
        /**
         * Output debugging info via a user-defined method.
         * Only generates output if debug output is enabled.
         *
         * @see PHPMailer::$Debugoutput
         * @see PHPMailer::$SMTPDebug
         *
         * @param string $str
         * @phpstan-return void
         */
        protected function edebug($str)
        {
        }
        /**
         * Sets message type to HTML or plain.
         *
         * @param bool $isHtml True for HTML mode
         */
        public function isHTML($isHtml = true)
        {
        }
        /**
         * Send messages using SMTP.
         */
        public function isSMTP()
        {
        }
        /**
         * Send messages using PHP's mail() function.
         */
        public function isMail()
        {
        }
        /**
         * Send messages using $Sendmail.
         */
        public function isSendmail()
        {
        }
        /**
         * Send messages using qmail.
         */
        public function isQmail()
        {
        }
        /**
         * Add a "To" address.
         *
         * @param string $address The email address to send to
         * @param string $name
         *
         * @throws Exception
         *
         * @return bool true on success, false if address already used or invalid in some way
         */
        public function addAddress($address, $name = '')
        {
        }
        /**
         * Add a "CC" address.
         *
         * @param string $address The email address to send to
         * @param string $name
         *
         * @throws Exception
         *
         * @return bool true on success, false if address already used or invalid in some way
         */
        public function addCC($address, $name = '')
        {
        }
        /**
         * Add a "BCC" address.
         *
         * @param string $address The email address to send to
         * @param string $name
         *
         * @throws Exception
         *
         * @return bool true on success, false if address already used or invalid in some way
         */
        public function addBCC($address, $name = '')
        {
        }
        /**
         * Add a "Reply-To" address.
         *
         * @param string $address The email address to reply to
         * @param string $name
         *
         * @throws Exception
         *
         * @return bool true on success, false if address already used or invalid in some way
         */
        public function addReplyTo($address, $name = '')
        {
        }
        /**
         * Add an address to one of the recipient arrays or to the ReplyTo array. Because PHPMailer
         * can't validate addresses with an IDN without knowing the PHPMailer::$CharSet (that can still
         * be modified after calling this function), addition of such addresses is delayed until send().
         * Addresses that have been added already return false, but do not throw exceptions.
         *
         * @param string $kind    One of 'to', 'cc', 'bcc', or 'Reply-To'
         * @param string $address The email address
         * @param string $name    An optional username associated with the address
         *
         * @throws Exception
         *
         * @return bool true on success, false if address already used or invalid in some way
         * @phpstan-param 'to'|'cc'|'bcc'|'Reply-To' $kind
         */
        protected function addOrEnqueueAnAddress($kind, $address, $name)
        {
        }
        /**
         * Set the boundaries to use for delimiting MIME parts.
         * If you override this, ensure you set all 3 boundaries to unique values.
         * The default boundaries include a "=_" sequence which cannot occur in quoted-printable bodies,
         * as suggested by https://www.rfc-editor.org/rfc/rfc2045#section-6.7
         *
         * @return void
         */
        public function setBoundaries()
        {
        }
        /**
         * Add an address to one of the recipient arrays or to the ReplyTo array.
         * Addresses that have been added already return false, but do not throw exceptions.
         *
         * @param string $kind    One of 'to', 'cc', 'bcc', or 'ReplyTo'
         * @param string $address The email address to send, resp. to reply to
         * @param string $name
         *
         * @throws Exception
         *
         * @return bool true on success, false if address already used or invalid in some way
         * @phpstan-param 'to'|'cc'|'bcc'|'ReplyTo' $kind
         */
        protected function addAnAddress($kind, $address, $name = '')
        {
        }
        /**
         * Parse and validate a string containing one or more RFC822-style comma-separated email addresses
         * of the form "display name <address>" into an array of name/address pairs.
         * Uses the imap_rfc822_parse_adrlist function if the IMAP extension is available.
         * Note that quotes in the name part are removed.
         *
         * @see https://www.andrew.cmu.edu/user/agreen1/testing/mrbs/web/Mail/RFC822.php A more careful implementation
         *
         * @param string $addrstr The address list string
         * @param bool   $useimap Whether to use the IMAP extension to parse the list
         * @param string $charset The charset to use when decoding the address list string.
         *
         * @return array
         */
        public static function parseAddresses($addrstr, $useimap = true, $charset = self::CHARSET_ISO88591)
        {
        }
        /**
         * Set the From and FromName properties.
         *
         * @param string $address
         * @param string $name
         * @param bool   $auto    Whether to also set the Sender address, defaults to true
         *
         * @throws Exception
         *
         * @return bool
         */
        public function setFrom($address, $name = '', $auto = true)
        {
        }
        /**
         * Return the Message-ID header of the last email.
         * Technically this is the value from the last time the headers were created,
         * but it's also the message ID of the last sent message except in
         * pathological cases.
         *
         * @return string
         */
        public function getLastMessageID()
        {
        }
        /**
         * Check that a string looks like an email address.
         * Validation patterns supported:
         * * `auto` Pick best pattern automatically;
         * * `pcre8` Use the squiloople.com pattern, requires PCRE > 8.0;
         * * `pcre` Use old PCRE implementation;
         * * `php` Use PHP built-in FILTER_VALIDATE_EMAIL;
         * * `html5` Use the pattern given by the HTML5 spec for 'email' type form input elements.
         * * `noregex` Don't use a regex: super fast, really dumb.
         * Alternatively you may pass in a callable to inject your own validator, for example:
         *
         * ```php
         * PHPMailer::validateAddress('user@example.com', function($address) {
         *     return (strpos($address, '@') !== false);
         * });
         * ```
         *
         * You can also set the PHPMailer::$validator static to a callable, allowing built-in methods to use your validator.
         *
         * @param string          $address       The email address to check
         * @param string|callable $patternselect Which pattern to use
         *
         * @return bool
         */
        public static function validateAddress($address, $patternselect = null)
        {
        }
        /**
         * Tells whether IDNs (Internationalized Domain Names) are supported or not. This requires the
         * `intl` and `mbstring` PHP extensions.
         *
         * @return bool `true` if required functions for IDN support are present
         */
        public static function idnSupported()
        {
        }
        /**
         * Converts IDN in given email address to its ASCII form, also known as punycode, if possible.
         * Important: Address must be passed in same encoding as currently set in PHPMailer::$CharSet.
         * This function silently returns unmodified address if:
         * - No conversion is necessary (i.e. domain name is not an IDN, or is already in ASCII form)
         * - Conversion to punycode is impossible (e.g. required PHP functions are not available)
         *   or fails for any reason (e.g. domain contains characters not allowed in an IDN).
         *
         * @see PHPMailer::$CharSet
         *
         * @param string $address The email address to convert
         *
         * @return string The encoded address in ASCII form
         */
        public function punyencodeAddress($address)
        {
        }
        /**
         * Create a message and send it.
         * Uses the sending method specified by $Mailer.
         *
         * @throws Exception
         *
         * @return bool false on error - See the ErrorInfo property for details of the error
         */
        public function send()
        {
        }
        /**
         * Prepare a message for sending.
         *
         * @throws Exception
         *
         * @return bool
         */
        public function preSend()
        {
        }
        /**
         * Actually send a message via the selected mechanism.
         *
         * @throws Exception
         *
         * @return bool
         */
        public function postSend()
        {
        }
        /**
         * Send mail using the $Sendmail program.
         *
         * @see PHPMailer::$Sendmail
         *
         * @param string $header The message headers
         * @param string $body   The message body
         *
         * @throws Exception
         *
         * @return bool
         */
        protected function sendmailSend($header, $body)
        {
        }
        /**
         * Fix CVE-2016-10033 and CVE-2016-10045 by disallowing potentially unsafe shell characters.
         * Note that escapeshellarg and escapeshellcmd are inadequate for our purposes, especially on Windows.
         *
         * @see https://github.com/PHPMailer/PHPMailer/issues/924 CVE-2016-10045 bug report
         *
         * @param string $string The string to be validated
         *
         * @return bool
         */
        protected static function isShellSafe($string)
        {
        }
        /**
         * Check whether a file path is of a permitted type.
         * Used to reject URLs and phar files from functions that access local file paths,
         * such as addAttachment.
         *
         * @param string $path A relative or absolute path to a file
         *
         * @return bool
         */
        protected static function isPermittedPath($path)
        {
        }
        /**
         * Check whether a file path is safe, accessible, and readable.
         *
         * @param string $path A relative or absolute path to a file
         *
         * @return bool
         */
        protected static function fileIsAccessible($path)
        {
        }
        /**
         * Send mail using the PHP mail() function.
         *
         * @see https://www.php.net/manual/en/book.mail.php
         *
         * @param string $header The message headers
         * @param string $body   The message body
         *
         * @throws Exception
         *
         * @return bool
         */
        protected function mailSend($header, $body)
        {
        }
        /**
         * Get an instance to use for SMTP operations.
         * Override this function to load your own SMTP implementation,
         * or set one with setSMTPInstance.
         *
         * @return SMTP
         */
        public function getSMTPInstance()
        {
        }
        /**
         * Provide an instance to use for SMTP operations.
         *
         * @return SMTP
         */
        public function setSMTPInstance(\PHPMailer\PHPMailer\SMTP $smtp)
        {
        }
        /**
         * Provide SMTP XCLIENT attributes
         *
         * @param string $name  Attribute name
         * @param ?string $value Attribute value
         *
         * @return bool
         */
        public function setSMTPXclientAttribute($name, $value)
        {
        }
        /**
         * Get SMTP XCLIENT attributes
         *
         * @return array
         */
        public function getSMTPXclientAttributes()
        {
        }
        /**
         * Send mail via SMTP.
         * Returns false if there is a bad MAIL FROM, RCPT, or DATA input.
         *
         * @see PHPMailer::setSMTPInstance() to use a different class.
         *
         * @uses \PHPMailer\PHPMailer\SMTP
         *
         * @param string $header The message headers
         * @param string $body   The message body
         *
         * @throws Exception
         *
         * @return bool
         */
        protected function smtpSend($header, $body)
        {
        }
        /**
         * Initiate a connection to an SMTP server.
         * Returns false if the operation failed.
         *
         * @param array $options An array of options compatible with stream_context_create()
         *
         * @throws Exception
         *
         * @uses \PHPMailer\PHPMailer\SMTP
         *
         * @return bool
         */
        public function smtpConnect($options = null)
        {
        }
        /**
         * Close the active SMTP session if one exists.
         */
        public function smtpClose()
        {
        }
        /**
         * Set the language for error messages.
         * The default language is English.
         *
         * @param string $langcode  ISO 639-1 2-character language code (e.g. French is "fr")
         *                          Optionally, the language code can be enhanced with a 4-character
         *                          script annotation and/or a 2-character country annotation.
         * @param string $lang_path Path to the language file directory, with trailing separator (slash)
         *                          Do not set this from user input!
         *
         * @return bool Returns true if the requested language was loaded, false otherwise.
         */
        public function setLanguage($langcode = 'en', $lang_path = '')
        {
        }
        /**
         * Get the array of strings for the current language.
         *
         * @return array
         */
        public function getTranslations()
        {
        }
        /**
         * Create recipient headers.
         *
         * @param string $type
         * @param array  $addr An array of recipients,
         *                     where each recipient is a 2-element indexed array with element 0 containing an address
         *                     and element 1 containing a name, like:
         *                     [['joe@example.com', 'Joe User'], ['zoe@example.com', 'Zoe User']]
         *
         * @return string
         */
        public function addrAppend($type, $addr)
        {
        }
        /**
         * Format an address for use in a message header.
         *
         * @param array $addr A 2-element indexed array, element 0 containing an address, element 1 containing a name like
         *                    ['joe@example.com', 'Joe User']
         *
         * @return string
         */
        public function addrFormat($addr)
        {
        }
        /**
         * Word-wrap message.
         * For use with mailers that do not automatically perform wrapping
         * and for quoted-printable encoded messages.
         * Original written by philippe.
         *
         * @param string $message The message to wrap
         * @param int    $length  The line length to wrap to
         * @param bool   $qp_mode Whether to run in Quoted-Printable mode
         *
         * @return string
         */
        public function wrapText($message, $length, $qp_mode = false)
        {
        }
        /**
         * Find the last character boundary prior to $maxLength in a utf-8
         * quoted-printable encoded string.
         * Original written by Colin Brown.
         *
         * @param string $encodedText utf-8 QP text
         * @param int    $maxLength   Find the last character boundary prior to this length
         *
         * @return int
         */
        public function utf8CharBoundary($encodedText, $maxLength)
        {
        }
        /**
         * Apply word wrapping to the message body.
         * Wraps the message body to the number of chars set in the WordWrap property.
         * You should only do this to plain-text bodies as wrapping HTML tags may break them.
         * This is called automatically by createBody(), so you don't need to call it yourself.
         * @phpstan-return void
         */
        public function setWordWrap()
        {
        }
        /**
         * Assemble message headers.
         *
         * @return string The assembled headers
         */
        public function createHeader()
        {
        }
        /**
         * Get the message MIME type headers.
         *
         * @return string
         */
        public function getMailMIME()
        {
        }
        /**
         * Returns the whole MIME message.
         * Includes complete headers and body.
         * Only valid post preSend().
         *
         * @see PHPMailer::preSend()
         *
         * @return string
         */
        public function getSentMIMEMessage()
        {
        }
        /**
         * Create a unique ID to use for boundaries.
         *
         * @return string
         */
        protected function generateId()
        {
        }
        /**
         * Assemble the message body.
         * Returns an empty string on failure.
         *
         * @throws Exception
         *
         * @return string The assembled message body
         */
        public function createBody()
        {
        }
        /**
         * Get the boundaries that this message will use
         * @return array
         */
        public function getBoundaries()
        {
        }
        /**
         * Return the start of a message boundary.
         *
         * @param string $boundary
         * @param string $charSet
         * @param string $contentType
         * @param string $encoding
         *
         * @return string
         */
        protected function getBoundary($boundary, $charSet, $contentType, $encoding)
        {
        }
        /**
         * Return the end of a message boundary.
         *
         * @param string $boundary
         *
         * @return string
         */
        protected function endBoundary($boundary)
        {
        }
        /**
         * Set the message type.
         * PHPMailer only supports some preset message types, not arbitrary MIME structures.
         */
        protected function setMessageType()
        {
        }
        /**
         * Format a header line.
         *
         * @param string     $name
         * @param string|int $value
         *
         * @return string
         */
        public function headerLine($name, $value)
        {
        }
        /**
         * Return a formatted mail line.
         *
         * @param string $value
         *
         * @return string
         */
        public function textLine($value)
        {
        }
        /**
         * Add an attachment from a path on the filesystem.
         * Never use a user-supplied path to a file!
         * Returns false if the file could not be found or read.
         * Explicitly *does not* support passing URLs; PHPMailer is not an HTTP client.
         * If you need to do that, fetch the resource yourself and pass it in via a local file or string.
         *
         * @param string $path        Path to the attachment
         * @param string $name        Overrides the attachment name
         * @param string $encoding    File encoding (see $Encoding)
         * @param string $type        MIME type, e.g. `image/jpeg`; determined automatically from $path if not specified
         * @param string $disposition Disposition to use
         *
         * @throws Exception
         *
         * @return bool
         */
        public function addAttachment($path, $name = '', $encoding = self::ENCODING_BASE64, $type = '', $disposition = 'attachment')
        {
        }
        /**
         * Return the array of attachments.
         *
         * @return array
         */
        public function getAttachments()
        {
        }
        /**
         * Attach all file, string, and binary attachments to the message.
         * Returns an empty string on failure.
         *
         * @param string $disposition_type
         * @param string $boundary
         *
         * @throws Exception
         *
         * @return string
         */
        protected function attachAll($disposition_type, $boundary)
        {
        }
        /**
         * Encode a file attachment in requested format.
         * Returns an empty string on failure.
         *
         * @param string $path     The full path to the file
         * @param string $encoding The encoding to use; one of 'base64', '7bit', '8bit', 'binary', 'quoted-printable'
         *
         * @return string
         */
        protected function encodeFile($path, $encoding = self::ENCODING_BASE64)
        {
        }
        /**
         * Encode a string in requested format.
         * Returns an empty string on failure.
         *
         * @param string $str      The text to encode
         * @param string $encoding The encoding to use; one of 'base64', '7bit', '8bit', 'binary', 'quoted-printable'
         *
         * @throws Exception
         *
         * @return string
         */
        public function encodeString($str, $encoding = self::ENCODING_BASE64)
        {
        }
        /**
         * Encode a header value (not including its label) optimally.
         * Picks shortest of Q, B, or none. Result includes folding if needed.
         * See RFC822 definitions for phrase, comment and text positions.
         *
         * @param string $str      The header value to encode
         * @param string $position What context the string will be used in
         *
         * @return string
         */
        public function encodeHeader($str, $position = 'text')
        {
        }
        /**
         * Check if a string contains multi-byte characters.
         *
         * @param string $str multi-byte text to wrap encode
         *
         * @return bool
         */
        public function hasMultiBytes($str)
        {
        }
        /**
         * Does a string contain any 8-bit chars (in any charset)?
         *
         * @param string $text
         *
         * @return bool
         */
        public function has8bitChars($text)
        {
        }
        /**
         * Encode and wrap long multibyte strings for mail headers
         * without breaking lines within a character.
         * Adapted from a function by paravoid.
         *
         * @see https://www.php.net/manual/en/function.mb-encode-mimeheader.php#60283
         *
         * @param string $str       multi-byte text to wrap encode
         * @param string $linebreak string to use as linefeed/end-of-line
         *
         * @return string
         */
        public function base64EncodeWrapMB($str, $linebreak = null)
        {
        }
        /**
         * Encode a string in quoted-printable format.
         * According to RFC2045 section 6.7.
         *
         * @param string $string The text to encode
         *
         * @return string
         */
        public function encodeQP($string)
        {
        }
        /**
         * Encode a string using Q encoding.
         *
         * @see https://www.rfc-editor.org/rfc/rfc2047#section-4.2
         *
         * @param string $str      the text to encode
         * @param string $position Where the text is going to be used, see the RFC for what that means
         *
         * @return string
         */
        public function encodeQ($str, $position = 'text')
        {
        }
        /**
         * Add a string or binary attachment (non-filesystem).
         * This method can be used to attach ascii or binary data,
         * such as a BLOB record from a database.
         *
         * @param string $string      String attachment data
         * @param string $filename    Name of the attachment
         * @param string $encoding    File encoding (see $Encoding)
         * @param string $type        File extension (MIME) type
         * @param string $disposition Disposition to use
         *
         * @throws Exception
         *
         * @return bool True on successfully adding an attachment
         */
        public function addStringAttachment($string, $filename, $encoding = self::ENCODING_BASE64, $type = '', $disposition = 'attachment')
        {
        }
        /**
         * Add an embedded (inline) attachment from a file.
         * This can include images, sounds, and just about any other document type.
         * These differ from 'regular' attachments in that they are intended to be
         * displayed inline with the message, not just attached for download.
         * This is used in HTML messages that embed the images
         * the HTML refers to using the `$cid` value in `img` tags, for example `<img src="cid:mylogo">`.
         * Never use a user-supplied path to a file!
         *
         * @param string $path        Path to the attachment
         * @param string $cid         Content ID of the attachment; Use this to reference
         *                            the content when using an embedded image in HTML
         * @param string $name        Overrides the attachment filename
         * @param string $encoding    File encoding (see $Encoding) defaults to `base64`
         * @param string $type        File MIME type (by default mapped from the `$path` filename's extension)
         * @param string $disposition Disposition to use: `inline` (default) or `attachment`
         *                            (unlikely you want this – {@see `addAttachment()`} instead)
         *
         * @return bool True on successfully adding an attachment
         * @throws Exception
         *
         */
        public function addEmbeddedImage($path, $cid, $name = '', $encoding = self::ENCODING_BASE64, $type = '', $disposition = 'inline')
        {
        }
        /**
         * Add an embedded stringified attachment.
         * This can include images, sounds, and just about any other document type.
         * If your filename doesn't contain an extension, be sure to set the $type to an appropriate MIME type.
         *
         * @param string $string      The attachment binary data
         * @param string $cid         Content ID of the attachment; Use this to reference
         *                            the content when using an embedded image in HTML
         * @param string $name        A filename for the attachment. If this contains an extension,
         *                            PHPMailer will attempt to set a MIME type for the attachment.
         *                            For example 'file.jpg' would get an 'image/jpeg' MIME type.
         * @param string $encoding    File encoding (see $Encoding), defaults to 'base64'
         * @param string $type        MIME type - will be used in preference to any automatically derived type
         * @param string $disposition Disposition to use
         *
         * @throws Exception
         *
         * @return bool True on successfully adding an attachment
         */
        public function addStringEmbeddedImage($string, $cid, $name = '', $encoding = self::ENCODING_BASE64, $type = '', $disposition = 'inline')
        {
        }
        /**
         * Validate encodings.
         *
         * @param string $encoding
         *
         * @return bool
         */
        protected function validateEncoding($encoding)
        {
        }
        /**
         * Check if an embedded attachment is present with this cid.
         *
         * @param string $cid
         *
         * @return bool
         */
        protected function cidExists($cid)
        {
        }
        /**
         * Check if an inline attachment is present.
         *
         * @return bool
         */
        public function inlineImageExists()
        {
        }
        /**
         * Check if an attachment (non-inline) is present.
         *
         * @return bool
         */
        public function attachmentExists()
        {
        }
        /**
         * Check if this message has an alternative body set.
         *
         * @return bool
         */
        public function alternativeExists()
        {
        }
        /**
         * Clear queued addresses of given kind.
         *
         * @param string $kind 'to', 'cc', or 'bcc'
         */
        public function clearQueuedAddresses($kind)
        {
        }
        /**
         * Clear all To recipients.
         */
        public function clearAddresses()
        {
        }
        /**
         * Clear all CC recipients.
         */
        public function clearCCs()
        {
        }
        /**
         * Clear all BCC recipients.
         */
        public function clearBCCs()
        {
        }
        /**
         * Clear all ReplyTo recipients.
         */
        public function clearReplyTos()
        {
        }
        /**
         * Clear all recipient types.
         */
        public function clearAllRecipients()
        {
        }
        /**
         * Clear all filesystem, string, and binary attachments.
         */
        public function clearAttachments()
        {
        }
        /**
         * Clear all custom headers.
         */
        public function clearCustomHeaders()
        {
        }
        /**
         * Clear a specific custom header by name or name and value.
         * $name value can be overloaded to contain
         * both header name and value (name:value).
         *
         * @param string      $name  Custom header name
         * @param string|null $value Header value
         *
         * @return bool True if a header was replaced successfully
         */
        public function clearCustomHeader($name, $value = null)
        {
        }
        /**
         * Replace a custom header.
         * $name value can be overloaded to contain
         * both header name and value (name:value).
         *
         * @param string      $name  Custom header name
         * @param string|null $value Header value
         *
         * @return bool True if a header was replaced successfully
         * @throws Exception
         */
        public function replaceCustomHeader($name, $value = null)
        {
        }
        /**
         * Add an error message to the error container.
         *
         * @param string $msg
         */
        protected function setError($msg)
        {
        }
        /**
         * Return an RFC 822 formatted date.
         *
         * @return string
         */
        public static function rfcDate()
        {
        }
        /**
         * Get the server hostname.
         * Returns 'localhost.localdomain' if unknown.
         *
         * @return string
         */
        protected function serverHostname()
        {
        }
        /**
         * Validate whether a string contains a valid value to use as a hostname or IP address.
         * IPv6 addresses must include [], e.g. `[::1]`, not just `::1`.
         *
         * @param string $host The host name or IP address to check
         *
         * @return bool
         */
        public static function isValidHost($host)
        {
        }
        /**
         * Get an error message in the current language.
         *
         * @param string $key
         *
         * @return string
         */
        protected function lang($key)
        {
        }
        /**
         * Check if an error occurred.
         *
         * @return bool True if an error did occur
         */
        public function isError()
        {
        }
        /**
         * Add a custom header.
         * $name value can be overloaded to contain
         * both header name and value (name:value).
         *
         * @param string      $name  Custom header name
         * @param string|null $value Header value
         *
         * @return bool True if a header was set successfully
         * @throws Exception
         */
        public function addCustomHeader($name, $value = null)
        {
        }
        /**
         * Returns all custom headers.
         *
         * @return array
         */
        public function getCustomHeaders()
        {
        }
        /**
         * Create a message body from an HTML string.
         * Automatically inlines images and creates a plain-text version by converting the HTML,
         * overwriting any existing values in Body and AltBody.
         * Do not source $message content from user input!
         * $basedir is prepended when handling relative URLs, e.g. <img src="/images/a.png"> and must not be empty
         * will look for an image file in $basedir/images/a.png and convert it to inline.
         * If you don't provide a $basedir, relative paths will be left untouched (and thus probably break in email)
         * Converts data-uri images into embedded attachments.
         * If you don't want to apply these transformations to your HTML, just set Body and AltBody directly.
         *
         * @param string        $message  HTML message string
         * @param string        $basedir  Absolute path to a base directory to prepend to relative paths to images
         * @param bool|callable $advanced Whether to use the internal HTML to text converter
         *                                or your own custom converter
         * @return string The transformed message body
         *
         * @throws Exception
         *
         * @see PHPMailer::html2text()
         */
        public function msgHTML($message, $basedir = '', $advanced = false)
        {
        }
        /**
         * Convert an HTML string into plain text.
         * This is used by msgHTML().
         * Note - older versions of this function used a bundled advanced converter
         * which was removed for license reasons in #232.
         * Example usage:
         *
         * ```php
         * //Use default conversion
         * $plain = $mail->html2text($html);
         * //Use your own custom converter
         * $plain = $mail->html2text($html, function($html) {
         *     $converter = new MyHtml2text($html);
         *     return $converter->get_text();
         * });
         * ```
         *
         * @param string        $html     The HTML text to convert
         * @param bool|callable $advanced Any boolean value to use the internal converter,
         *                                or provide your own callable for custom conversion.
         *                                *Never* pass user-supplied data into this parameter
         *
         * @return string
         */
        public function html2text($html, $advanced = false)
        {
        }
        /**
         * Get the MIME type for a file extension.
         *
         * @param string $ext File extension
         *
         * @return string MIME type of file
         */
        public static function _mime_types($ext = '')
        {
        }
        /**
         * Map a file name to a MIME type.
         * Defaults to 'application/octet-stream', i.e.. arbitrary binary data.
         *
         * @param string $filename A file name or full path, does not need to exist as a file
         *
         * @return string
         */
        public static function filenameToType($filename)
        {
        }
        /**
         * Multi-byte-safe pathinfo replacement.
         * Drop-in replacement for pathinfo(), but multibyte- and cross-platform-safe.
         *
         * @see https://www.php.net/manual/en/function.pathinfo.php#107461
         *
         * @param string     $path    A filename or path, does not need to exist as a file
         * @param int|string $options Either a PATHINFO_* constant,
         *                            or a string name to return only the specified piece
         *
         * @return string|array
         */
        public static function mb_pathinfo($path, $options = null)
        {
        }
        /**
         * Set or reset instance properties.
         * You should avoid this function - it's more verbose, less efficient, more error-prone and
         * harder to debug than setting properties directly.
         * Usage Example:
         * `$mail->set('SMTPSecure', static::ENCRYPTION_STARTTLS);`
         *   is the same as:
         * `$mail->SMTPSecure = static::ENCRYPTION_STARTTLS;`.
         *
         * @param string $name  The property name to set
         * @param mixed  $value The value to set the property to
         *
         * @return bool
         */
        public function set($name, $value = '')
        {
        }
        /**
         * Strip newlines to prevent header injection.
         *
         * @param string $str
         *
         * @return string
         */
        public function secureHeader($str)
        {
        }
        /**
         * Normalize line breaks in a string.
         * Converts UNIX LF, Mac CR and Windows CRLF line breaks into a single line break format.
         * Defaults to CRLF (for message bodies) and preserves consecutive breaks.
         *
         * @param string $text
         * @param string $breaktype What kind of line break to use; defaults to static::$LE
         *
         * @return string
         */
        public static function normalizeBreaks($text, $breaktype = null)
        {
        }
        /**
         * Remove trailing whitespace from a string.
         *
         * @param string $text
         *
         * @return string The text to remove whitespace from
         */
        public static function stripTrailingWSP($text)
        {
        }
        /**
         * Strip trailing line breaks from a string.
         *
         * @param string $text
         *
         * @return string The text to remove breaks from
         */
        public static function stripTrailingBreaks($text)
        {
        }
        /**
         * Return the current line break format string.
         *
         * @return string
         */
        public static function getLE()
        {
        }
        /**
         * Set the line break format string, e.g. "\r\n".
         *
         * @param string $le
         */
        protected static function setLE($le)
        {
        }
        /**
         * Set the public and private key files and password for S/MIME signing.
         *
         * @param string $cert_filename
         * @param string $key_filename
         * @param string $key_pass            Password for private key
         * @param string $extracerts_filename Optional path to chain certificate
         */
        public function sign($cert_filename, $key_filename, $key_pass, $extracerts_filename = '')
        {
        }
        /**
         * Quoted-Printable-encode a DKIM header.
         *
         * @param string $txt
         *
         * @return string
         */
        public function DKIM_QP($txt)
        {
        }
        /**
         * Generate a DKIM signature.
         *
         * @param string $signHeader
         *
         * @throws Exception
         *
         * @return string The DKIM signature value
         */
        public function DKIM_Sign($signHeader)
        {
        }
        /**
         * Generate a DKIM canonicalization header.
         * Uses the 'relaxed' algorithm from RFC6376 section 3.4.2.
         * Canonicalized headers should *always* use CRLF, regardless of mailer setting.
         *
         * @see https://www.rfc-editor.org/rfc/rfc6376#section-3.4.2
         *
         * @param string $signHeader Header
         *
         * @return string
         */
        public function DKIM_HeaderC($signHeader)
        {
        }
        /**
         * Generate a DKIM canonicalization body.
         * Uses the 'simple' algorithm from RFC6376 section 3.4.3.
         * Canonicalized bodies should *always* use CRLF, regardless of mailer setting.
         *
         * @see https://www.rfc-editor.org/rfc/rfc6376#section-3.4.3
         *
         * @param string $body Message Body
         *
         * @return string
         */
        public function DKIM_BodyC($body)
        {
        }
        /**
         * Create the DKIM header and body in a new message header.
         *
         * @param string $headers_line Header lines
         * @param string $subject      Subject
         * @param string $body         Body
         *
         * @throws Exception
         *
         * @return string
         */
        public function DKIM_Add($headers_line, $subject, $body)
        {
        }
        /**
         * Detect if a string contains a line longer than the maximum line length
         * allowed by RFC 2822 section 2.1.1.
         *
         * @param string $str
         *
         * @return bool
         */
        public static function hasLineLongerThanMax($str)
        {
        }
        /**
         * If a string contains any "special" characters, double-quote the name,
         * and escape any double quotes with a backslash.
         *
         * @param string $str
         *
         * @return string
         *
         * @see RFC822 3.4.1
         */
        public static function quotedString($str)
        {
        }
        /**
         * Allows for public read access to 'to' property.
         * Before the send() call, queued addresses (i.e. with IDN) are not yet included.
         *
         * @return array
         */
        public function getToAddresses()
        {
        }
        /**
         * Allows for public read access to 'cc' property.
         * Before the send() call, queued addresses (i.e. with IDN) are not yet included.
         *
         * @return array
         */
        public function getCcAddresses()
        {
        }
        /**
         * Allows for public read access to 'bcc' property.
         * Before the send() call, queued addresses (i.e. with IDN) are not yet included.
         *
         * @return array
         */
        public function getBccAddresses()
        {
        }
        /**
         * Allows for public read access to 'ReplyTo' property.
         * Before the send() call, queued addresses (i.e. with IDN) are not yet included.
         *
         * @return array
         */
        public function getReplyToAddresses()
        {
        }
        /**
         * Allows for public read access to 'all_recipients' property.
         * Before the send() call, queued addresses (i.e. with IDN) are not yet included.
         *
         * @return array
         */
        public function getAllRecipientAddresses()
        {
        }
        /**
         * Perform a callback.
         *
         * @param bool   $isSent
         * @param array  $to
         * @param array  $cc
         * @param array  $bcc
         * @param string $subject
         * @param string $body
         * @param string $from
         * @param array  $extra
         */
        protected function doCallback($isSent, $to, $cc, $bcc, $subject, $body, $from, $extra)
        {
        }
        /**
         * Get the OAuthTokenProvider instance.
         *
         * @return OAuthTokenProvider
         */
        public function getOAuth()
        {
        }
        /**
         * Set an OAuthTokenProvider instance.
         */
        public function setOAuth(\PHPMailer\PHPMailer\OAuthTokenProvider $oauth)
        {
        }
    }
    /**
     * PHPMailer RFC821 SMTP email transport class.
     * Implements RFC 821 SMTP commands and provides some utility methods for sending mail to an SMTP server.
     *
     * @author Chris Ryan
     * @author Marcus Bointon <phpmailer@synchromedia.co.uk>
     */
    class SMTP
    {
        /**
         * The PHPMailer SMTP version number.
         *
         * @var string
         */
        const VERSION = '6.9.3';
        /**
         * SMTP line break constant.
         *
         * @var string
         */
        const LE = "\r\n";
        /**
         * The SMTP port to use if one is not specified.
         *
         * @var int
         */
        const DEFAULT_PORT = 25;
        /**
         * The SMTPs port to use if one is not specified.
         *
         * @var int
         */
        const DEFAULT_SECURE_PORT = 465;
        /**
         * The maximum line length allowed by RFC 5321 section 4.5.3.1.6,
         * *excluding* a trailing CRLF break.
         *
         * @see https://www.rfc-editor.org/rfc/rfc5321#section-4.5.3.1.6
         *
         * @var int
         */
        const MAX_LINE_LENGTH = 998;
        /**
         * The maximum line length allowed for replies in RFC 5321 section 4.5.3.1.5,
         * *including* a trailing CRLF line break.
         *
         * @see https://www.rfc-editor.org/rfc/rfc5321#section-4.5.3.1.5
         *
         * @var int
         */
        const MAX_REPLY_LENGTH = 512;
        /**
         * Debug level for no output.
         *
         * @var int
         */
        const DEBUG_OFF = 0;
        /**
         * Debug level to show client -> server messages.
         *
         * @var int
         */
        const DEBUG_CLIENT = 1;
        /**
         * Debug level to show client -> server and server -> client messages.
         *
         * @var int
         */
        const DEBUG_SERVER = 2;
        /**
         * Debug level to show connection status, client -> server and server -> client messages.
         *
         * @var int
         */
        const DEBUG_CONNECTION = 3;
        /**
         * Debug level to show all messages.
         *
         * @var int
         */
        const DEBUG_LOWLEVEL = 4;
        /**
         * Debug output level.
         * Options:
         * * self::DEBUG_OFF (`0`) No debug output, default
         * * self::DEBUG_CLIENT (`1`) Client commands
         * * self::DEBUG_SERVER (`2`) Client commands and server responses
         * * self::DEBUG_CONNECTION (`3`) As DEBUG_SERVER plus connection status
         * * self::DEBUG_LOWLEVEL (`4`) Low-level data output, all messages.
         *
         * @var int
         */
        public $do_debug = self::DEBUG_OFF;
        /**
         * How to handle debug output.
         * Options:
         * * `echo` Output plain-text as-is, appropriate for CLI
         * * `html` Output escaped, line breaks converted to `<br>`, appropriate for browser output
         * * `error_log` Output to error log as configured in php.ini
         * Alternatively, you can provide a callable expecting two params: a message string and the debug level:
         *
         * ```php
         * $smtp->Debugoutput = function($str, $level) {echo "debug level $level; message: $str";};
         * ```
         *
         * Alternatively, you can pass in an instance of a PSR-3 compatible logger, though only `debug`
         * level output is used:
         *
         * ```php
         * $mail->Debugoutput = new myPsr3Logger;
         * ```
         *
         * @var string|callable|\Psr\Log\LoggerInterface
         */
        public $Debugoutput = 'echo';
        /**
         * Whether to use VERP.
         *
         * @see https://en.wikipedia.org/wiki/Variable_envelope_return_path
         * @see https://www.postfix.org/VERP_README.html Info on VERP
         *
         * @var bool
         */
        public $do_verp = false;
        /**
         * The timeout value for connection, in seconds.
         * Default of 5 minutes (300sec) is from RFC2821 section 4.5.3.2.
         * This needs to be quite high to function correctly with hosts using greetdelay as an anti-spam measure.
         *
         * @see https://www.rfc-editor.org/rfc/rfc2821#section-4.5.3.2
         *
         * @var int
         */
        public $Timeout = 300;
        /**
         * How long to wait for commands to complete, in seconds.
         * Default of 5 minutes (300sec) is from RFC2821 section 4.5.3.2.
         *
         * @var int
         */
        public $Timelimit = 300;
        /**
         * Patterns to extract an SMTP transaction id from reply to a DATA command.
         * The first capture group in each regex will be used as the ID.
         * MS ESMTP returns the message ID, which may not be correct for internal tracking.
         *
         * @var string[]
         */
        protected $smtp_transaction_id_patterns = ['exim' => '/[\d]{3} OK id=(.*)/', 'sendmail' => '/[\d]{3} 2\.0\.0 (.*) Message/', 'postfix' => '/[\d]{3} 2\.0\.0 Ok: queued as (.*)/', 'Microsoft_ESMTP' => '/[0-9]{3} 2\.[\d]\.0 (.*)@(?:.*) Queued mail for delivery/', 'Amazon_SES' => '/[\d]{3} Ok (.*)/', 'SendGrid' => '/[\d]{3} Ok: queued as (.*)/', 'CampaignMonitor' => '/[\d]{3} 2\.0\.0 OK:([a-zA-Z\d]{48})/', 'Haraka' => '/[\d]{3} Message Queued \((.*)\)/', 'ZoneMTA' => '/[\d]{3} Message queued as (.*)/', 'Mailjet' => '/[\d]{3} OK queued as (.*)/'];
        /**
         * Allowed SMTP XCLIENT attributes.
         * Must be allowed by the SMTP server. EHLO response is not checked.
         *
         * @see https://www.postfix.org/XCLIENT_README.html
         *
         * @var array
         */
        public static $xclient_allowed_attributes = ['NAME', 'ADDR', 'PORT', 'PROTO', 'HELO', 'LOGIN', 'DESTADDR', 'DESTPORT'];
        /**
         * The last transaction ID issued in response to a DATA command,
         * if one was detected.
         *
         * @var string|bool|null
         */
        protected $last_smtp_transaction_id;
        /**
         * The socket for the server connection.
         *
         * @var ?resource
         */
        protected $smtp_conn;
        /**
         * Error information, if any, for the last SMTP command.
         *
         * @var array
         */
        protected $error = ['error' => '', 'detail' => '', 'smtp_code' => '', 'smtp_code_ex' => ''];
        /**
         * The reply the server sent to us for HELO.
         * If null, no HELO string has yet been received.
         *
         * @var string|null
         */
        protected $helo_rply;
        /**
         * The set of SMTP extensions sent in reply to EHLO command.
         * Indexes of the array are extension names.
         * Value at index 'HELO' or 'EHLO' (according to command that was sent)
         * represents the server name. In case of HELO it is the only element of the array.
         * Other values can be boolean TRUE or an array containing extension options.
         * If null, no HELO/EHLO string has yet been received.
         *
         * @var array|null
         */
        protected $server_caps;
        /**
         * The most recent reply received from the server.
         *
         * @var string
         */
        protected $last_reply = '';
        /**
         * Output debugging info via a user-selected method.
         *
         * @param string $str   Debug string to output
         * @param int    $level The debug level of this message; see DEBUG_* constants
         *
         * @see SMTP::$Debugoutput
         * @see SMTP::$do_debug
         * @phpstan-return void
         */
        protected function edebug($str, $level = 0)
        {
        }
        /**
         * Connect to an SMTP server.
         *
         * @param string $host    SMTP server IP or host name
         * @param int    $port    The port number to connect to
         * @param int    $timeout How long to wait for the connection to open
         * @param array  $options An array of options for stream_context_create()
         *
         * @return bool
         */
        public function connect($host, $port = null, $timeout = 30, $options = [])
        {
        }
        /**
         * Create connection to the SMTP server.
         *
         * @param string $host    SMTP server IP or host name
         * @param int    $port    The port number to connect to
         * @param int    $timeout How long to wait for the connection to open
         * @param array  $options An array of options for stream_context_create()
         *
         * @return false|resource
         */
        protected function getSMTPConnection($host, $port = null, $timeout = 30, $options = [])
        {
        }
        /**
         * Initiate a TLS (encrypted) session.
         *
         * @return bool
         */
        public function startTLS()
        {
        }
        /**
         * Perform SMTP authentication.
         * Must be run after hello().
         *
         * @see    hello()
         *
         * @param string $username The user name
         * @param string $password The password
         * @param string $authtype The auth type (CRAM-MD5, PLAIN, LOGIN, XOAUTH2)
         * @param OAuthTokenProvider $OAuth An optional OAuthTokenProvider instance for XOAUTH2 authentication
         *
         * @return bool True if successfully authenticated
         */
        public function authenticate($username, $password, $authtype = null, $OAuth = null)
        {
        }
        /**
         * Calculate an MD5 HMAC hash.
         * Works like hash_hmac('md5', $data, $key)
         * in case that function is not available.
         *
         * @param string $data The data to hash
         * @param string $key  The key to hash with
         *
         * @return string
         */
        protected function hmac($data, $key)
        {
        }
        /**
         * Check connection state.
         *
         * @return bool True if connected
         */
        public function connected()
        {
        }
        /**
         * Close the socket and clean up the state of the class.
         * Don't use this function without first trying to use QUIT.
         *
         * @see quit()
         */
        public function close()
        {
        }
        /**
         * Send an SMTP DATA command.
         * Issues a data command and sends the msg_data to the server,
         * finalizing the mail transaction. $msg_data is the message
         * that is to be sent with the headers. Each header needs to be
         * on a single line followed by a <CRLF> with the message headers
         * and the message body being separated by an additional <CRLF>.
         * Implements RFC 821: DATA <CRLF>.
         *
         * @param string $msg_data Message data to send
         *
         * @return bool
         */
        public function data($msg_data)
        {
        }
        /**
         * Send an SMTP HELO or EHLO command.
         * Used to identify the sending server to the receiving server.
         * This makes sure that client and server are in a known state.
         * Implements RFC 821: HELO <SP> <domain> <CRLF>
         * and RFC 2821 EHLO.
         *
         * @param string $host The host name or IP to connect to
         *
         * @return bool
         */
        public function hello($host = '')
        {
        }
        /**
         * Send an SMTP HELO or EHLO command.
         * Low-level implementation used by hello().
         *
         * @param string $hello The HELO string
         * @param string $host  The hostname to say we are
         *
         * @return bool
         *
         * @see hello()
         */
        protected function sendHello($hello, $host)
        {
        }
        /**
         * Parse a reply to HELO/EHLO command to discover server extensions.
         * In case of HELO, the only parameter that can be discovered is a server name.
         *
         * @param string $type `HELO` or `EHLO`
         */
        protected function parseHelloFields($type)
        {
        }
        /**
         * Send an SMTP MAIL command.
         * Starts a mail transaction from the email address specified in
         * $from. Returns true if successful or false otherwise. If True
         * the mail transaction is started and then one or more recipient
         * commands may be called followed by a data command.
         * Implements RFC 821: MAIL <SP> FROM:<reverse-path> <CRLF>.
         *
         * @param string $from Source address of this message
         *
         * @return bool
         */
        public function mail($from)
        {
        }
        /**
         * Send an SMTP QUIT command.
         * Closes the socket if there is no error or the $close_on_error argument is true.
         * Implements from RFC 821: QUIT <CRLF>.
         *
         * @param bool $close_on_error Should the connection close if an error occurs?
         *
         * @return bool
         */
        public function quit($close_on_error = true)
        {
        }
        /**
         * Send an SMTP RCPT command.
         * Sets the TO argument to $toaddr.
         * Returns true if the recipient was accepted false if it was rejected.
         * Implements from RFC 821: RCPT <SP> TO:<forward-path> <CRLF>.
         *
         * @param string $address The address the message is being sent to
         * @param string $dsn     Comma separated list of DSN notifications. NEVER, SUCCESS, FAILURE
         *                        or DELAY. If you specify NEVER all other notifications are ignored.
         *
         * @return bool
         */
        public function recipient($address, $dsn = '')
        {
        }
        /**
         * Send SMTP XCLIENT command to server and check its return code.
         *
         * @return bool True on success
         */
        public function xclient(array $vars)
        {
        }
        /**
         * Send an SMTP RSET command.
         * Abort any transaction that is currently in progress.
         * Implements RFC 821: RSET <CRLF>.
         *
         * @return bool True on success
         */
        public function reset()
        {
        }
        /**
         * Send a command to an SMTP server and check its return code.
         *
         * @param string    $command       The command name - not sent to the server
         * @param string    $commandstring The actual command to send
         * @param int|array $expect        One or more expected integer success codes
         *
         * @return bool True on success
         */
        protected function sendCommand($command, $commandstring, $expect)
        {
        }
        /**
         * Send an SMTP SAML command.
         * Starts a mail transaction from the email address specified in $from.
         * Returns true if successful or false otherwise. If True
         * the mail transaction is started and then one or more recipient
         * commands may be called followed by a data command. This command
         * will send the message to the users terminal if they are logged
         * in and send them an email.
         * Implements RFC 821: SAML <SP> FROM:<reverse-path> <CRLF>.
         *
         * @param string $from The address the message is from
         *
         * @return bool
         */
        public function sendAndMail($from)
        {
        }
        /**
         * Send an SMTP VRFY command.
         *
         * @param string $name The name to verify
         *
         * @return bool
         */
        public function verify($name)
        {
        }
        /**
         * Send an SMTP NOOP command.
         * Used to keep keep-alives alive, doesn't actually do anything.
         *
         * @return bool
         */
        public function noop()
        {
        }
        /**
         * Send an SMTP TURN command.
         * This is an optional command for SMTP that this class does not support.
         * This method is here to make the RFC821 Definition complete for this class
         * and _may_ be implemented in future.
         * Implements from RFC 821: TURN <CRLF>.
         *
         * @return bool
         */
        public function turn()
        {
        }
        /**
         * Send raw data to the server.
         *
         * @param string $data    The data to send
         * @param string $command Optionally, the command this is part of, used only for controlling debug output
         *
         * @return int|bool The number of bytes sent to the server or false on error
         */
        public function client_send($data, $command = '')
        {
        }
        /**
         * Get the latest error.
         *
         * @return array
         */
        public function getError()
        {
        }
        /**
         * Get SMTP extensions available on the server.
         *
         * @return array|null
         */
        public function getServerExtList()
        {
        }
        /**
         * Get metadata about the SMTP server from its HELO/EHLO response.
         * The method works in three ways, dependent on argument value and current state:
         *   1. HELO/EHLO has not been sent - returns null and populates $this->error.
         *   2. HELO has been sent -
         *     $name == 'HELO': returns server name
         *     $name == 'EHLO': returns boolean false
         *     $name == any other string: returns null and populates $this->error
         *   3. EHLO has been sent -
         *     $name == 'HELO'|'EHLO': returns the server name
         *     $name == any other string: if extension $name exists, returns True
         *       or its options (e.g. AUTH mechanisms supported). Otherwise returns False.
         *
         * @param string $name Name of SMTP extension or 'HELO'|'EHLO'
         *
         * @return string|bool|null
         */
        public function getServerExt($name)
        {
        }
        /**
         * Get the last reply from the server.
         *
         * @return string
         */
        public function getLastReply()
        {
        }
        /**
         * Read the SMTP server's response.
         * Either before eof or socket timeout occurs on the operation.
         * With SMTP we can tell if we have more lines to read if the
         * 4th character is '-' symbol. If it is a space then we don't
         * need to read anything else.
         *
         * @return string
         */
        protected function get_lines()
        {
        }
        /**
         * Enable or disable VERP address generation.
         *
         * @param bool $enabled
         */
        public function setVerp($enabled = false)
        {
        }
        /**
         * Get VERP address generation mode.
         *
         * @return bool
         */
        public function getVerp()
        {
        }
        /**
         * Set error messages and codes.
         *
         * @param string $message      The error message
         * @param string $detail       Further detail on the error
         * @param string $smtp_code    An associated SMTP error code
         * @param string $smtp_code_ex Extended SMTP code
         */
        protected function setError($message, $detail = '', $smtp_code = '', $smtp_code_ex = '')
        {
        }
        /**
         * Set debug output method.
         *
         * @param string|callable $method The name of the mechanism to use for debugging output, or a callable to handle it
         */
        public function setDebugOutput($method = 'echo')
        {
        }
        /**
         * Get debug output method.
         *
         * @return string
         */
        public function getDebugOutput()
        {
        }
        /**
         * Set debug output level.
         *
         * @param int $level
         */
        public function setDebugLevel($level = 0)
        {
        }
        /**
         * Get debug output level.
         *
         * @return int
         */
        public function getDebugLevel()
        {
        }
        /**
         * Set SMTP timeout.
         *
         * @param int $timeout The timeout duration in seconds
         */
        public function setTimeout($timeout = 0)
        {
        }
        /**
         * Get SMTP timeout.
         *
         * @return int
         */
        public function getTimeout()
        {
        }
        /**
         * Reports an error number and string.
         *
         * @param int    $errno   The error number returned by PHP
         * @param string $errmsg  The error message returned by PHP
         * @param string $errfile The file the error occurred in
         * @param int    $errline The line number the error occurred on
         */
        protected function errorHandler($errno, $errmsg, $errfile = '', $errline = 0)
        {
        }
        /**
         * Extract and return the ID of the last SMTP transaction based on
         * a list of patterns provided in SMTP::$smtp_transaction_id_patterns.
         * Relies on the host providing the ID in response to a DATA command.
         * If no reply has been received yet, it will return null.
         * If no pattern was matched, it will return false.
         *
         * @return bool|string|null
         */
        protected function recordLastTransactionID()
        {
        }
        /**
         * Get the queue/transaction ID of the last SMTP transaction
         * If no reply has been received yet, it will return null.
         * If no pattern was matched, it will return false.
         *
         * @return bool|string|null
         *
         * @see recordLastTransactionID()
         */
        public function getLastTransactionID()
        {
        }
    }
}
namespace WpOrg\Requests {
    /**
     * Authentication provider interface
     *
     * Implement this interface to act as an authentication provider.
     *
     * Parameters should be passed via the constructor where possible, as this
     * makes it much easier for users to use your provider.
     *
     * @see \WpOrg\Requests\Hooks
     *
     * @package Requests\Authentication
     */
    interface Auth
    {
        /**
         * Register hooks as needed
         *
         * This method is called in {@see \WpOrg\Requests\Requests::request()} when the user
         * has set an instance as the 'auth' option. Use this callback to register all the
         * hooks you'll need.
         *
         * @see \WpOrg\Requests\Hooks::register()
         * @param \WpOrg\Requests\Hooks $hooks Hook system
         */
        public function register(\WpOrg\Requests\Hooks $hooks);
    }
}
namespace WpOrg\Requests\Auth {
    /**
     * Basic Authentication provider
     *
     * Provides a handler for Basic HTTP authentication via the Authorization
     * header.
     *
     * @package Requests\Authentication
     */
    class Basic implements \WpOrg\Requests\Auth
    {
        /**
         * Username
         *
         * @var string
         */
        public $user;
        /**
         * Password
         *
         * @var string
         */
        public $pass;
        /**
         * Constructor
         *
         * @since 2.0 Throws an `InvalidArgument` exception.
         * @since 2.0 Throws an `ArgumentCount` exception instead of the Requests base `Exception.
         *
         * @param array|null $args Array of user and password. Must have exactly two elements
         *
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed argument is not an array or null.
         * @throws \WpOrg\Requests\Exception\ArgumentCount   On incorrect number of array elements (`authbasicbadargs`).
         * @phpstan-return void
         */
        public function __construct($args = null)
        {
        }
        /**
         * Register the necessary callbacks
         *
         * @see \WpOrg\Requests\Auth\Basic::curl_before_send()
         * @see \WpOrg\Requests\Auth\Basic::fsockopen_header()
         * @param \WpOrg\Requests\Hooks $hooks Hook system
         */
        public function register(\WpOrg\Requests\Hooks $hooks)
        {
        }
        /**
         * Set cURL parameters before the data is sent
         *
         * @param resource|\CurlHandle $handle cURL handle
         */
        public function curl_before_send(&$handle)
        {
        }
        /**
         * Add extra headers to the request before sending
         *
         * @param string $out HTTP header string
         */
        public function fsockopen_header(&$out)
        {
        }
        /**
         * Get the authentication string (user:pass)
         *
         * @return string
         */
        public function getAuthString()
        {
        }
    }
}
namespace WpOrg\Requests {
    /**
     * Autoloader for Requests for PHP.
     *
     * This autoloader supports the PSR-4 based Requests 2.0.0 classes in a case-sensitive manner
     * as the most common server OS-es are case-sensitive and the file names are in mixed case.
     *
     * For the PSR-0 Requests 1.x BC-layer, requested classes will be treated case-insensitively.
     *
     * @package Requests
     */
    final class Autoload
    {
        /**
         * Register the autoloader.
         *
         * Note: the autoloader is *prepended* in the autoload queue.
         * This is done to ensure that the Requests 2.0 autoloader takes precedence
         * over a potentially (dependency-registered) Requests 1.x autoloader.
         *
         * @internal This method contains a safeguard against the autoloader being
         * registered multiple times. This safeguard uses a global constant to
         * (hopefully/in most cases) still function correctly, even if the
         * class would be renamed.
         *
         * @return void
         */
        public static function register()
        {
        }
        /**
         * Autoloader.
         *
         * @param string $class_name Name of the class name to load.
         *
         * @return bool Whether a class was loaded or not.
         */
        public static function load($class_name)
        {
        }
    }
    /**
     * Capability interface declaring the known capabilities.
     *
     * This is used as the authoritative source for which capabilities can be queried.
     *
     * @package Requests\Utilities
     */
    interface Capability
    {
        /**
         * Support for SSL.
         *
         * @var string
         */
        const SSL = 'ssl';
        /**
         * Collection of all capabilities supported in Requests.
         *
         * Note: this does not automatically mean that the capability will be supported for your chosen transport!
         *
         * @var string[]
         */
        const ALL = [self::SSL];
    }
    /**
     * Cookie storage object
     *
     * @package Requests\Cookies
     */
    class Cookie
    {
        /**
         * Cookie name.
         *
         * @var string
         */
        public $name;
        /**
         * Cookie value.
         *
         * @var string
         */
        public $value;
        /**
         * Cookie attributes
         *
         * Valid keys are `'path'`, `'domain'`, `'expires'`, `'max-age'`, `'secure'` and
         * `'httponly'`.
         *
         * @var \WpOrg\Requests\Utility\CaseInsensitiveDictionary|array Array-like object
         */
        public $attributes = [];
        /**
         * Cookie flags
         *
         * Valid keys are `'creation'`, `'last-access'`, `'persistent'` and `'host-only'`.
         *
         * @var array
         */
        public $flags = [];
        /**
         * Reference time for relative calculations
         *
         * This is used in place of `time()` when calculating Max-Age expiration and
         * checking time validity.
         *
         * @var int
         */
        public $reference_time = 0;
        /**
         * Create a new cookie object
         *
         * @param string                                                  $name           The name of the cookie.
         * @param string                                                  $value          The value for the cookie.
         * @param array|\WpOrg\Requests\Utility\CaseInsensitiveDictionary $attributes Associative array of attribute data
         * @param array                                                   $flags          The flags for the cookie.
         *                                                                                Valid keys are `'creation'`, `'last-access'`,
         *                                                                                `'persistent'` and `'host-only'`.
         * @param int|null                                                $reference_time Reference time for relative calculations.
         *
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $name argument is not a string.
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $value argument is not a string.
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $attributes argument is not an array or iterable object with array access.
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $flags argument is not an array.
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $reference_time argument is not an integer or null.
         */
        public function __construct($name, $value, $attributes = [], $flags = [], $reference_time = null)
        {
        }
        /**
         * Get the cookie value
         *
         * Attributes and other data can be accessed via methods.
         */
        public function __toString()
        {
        }
        /**
         * Check if a cookie is expired.
         *
         * Checks the age against $this->reference_time to determine if the cookie
         * is expired.
         *
         * @return boolean True if expired, false if time is valid.
         */
        public function is_expired()
        {
        }
        /**
         * Check if a cookie is valid for a given URI
         *
         * @param \WpOrg\Requests\Iri $uri URI to check
         * @return boolean Whether the cookie is valid for the given URI
         */
        public function uri_matches(\WpOrg\Requests\Iri $uri)
        {
        }
        /**
         * Check if a cookie is valid for a given domain
         *
         * @param string $domain Domain to check
         * @return boolean Whether the cookie is valid for the given domain
         */
        public function domain_matches($domain)
        {
        }
        /**
         * Check if a cookie is valid for a given path
         *
         * From the path-match check in RFC 6265 section 5.1.4
         *
         * @param string $request_path Path to check
         * @return boolean Whether the cookie is valid for the given path
         */
        public function path_matches($request_path)
        {
        }
        /**
         * Normalize cookie and attributes
         *
         * @return boolean Whether the cookie was successfully normalized
         */
        public function normalize()
        {
        }
        /**
         * Parse an individual cookie attribute
         *
         * Handles parsing individual attributes from the cookie values.
         *
         * @param string $name Attribute name
         * @param string|int|bool $value Attribute value (string/integer value, or true if empty/flag)
         * @return mixed Value if available, or null if the attribute value is invalid (and should be skipped)
         */
        protected function normalize_attribute($name, $value)
        {
        }
        /**
         * Format a cookie for a Cookie header
         *
         * This is used when sending cookies to a server.
         *
         * @return string Cookie formatted for Cookie header
         */
        public function format_for_header()
        {
        }
        /**
         * Format a cookie for a Set-Cookie header
         *
         * This is used when sending cookies to clients. This isn't really
         * applicable to client-side usage, but might be handy for debugging.
         *
         * @return string Cookie formatted for Set-Cookie header
         */
        public function format_for_set_cookie()
        {
        }
        /**
         * Parse a cookie string into a cookie object
         *
         * Based on Mozilla's parsing code in Firefox and related projects, which
         * is an intentional deviation from RFC 2109 and RFC 2616. RFC 6265
         * specifies some of this handling, but not in a thorough manner.
         *
         * @param string $cookie_header Cookie header value (from a Set-Cookie header)
         * @param string $name
         * @param int|null $reference_time
         * @return \WpOrg\Requests\Cookie Parsed cookie object
         *
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $cookie_header argument is not a string.
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $name argument is not a string.
         */
        public static function parse($cookie_header, $name = '', $reference_time = null)
        {
        }
        /**
         * Parse all Set-Cookie headers from request headers
         *
         * @param \WpOrg\Requests\Response\Headers $headers Headers to parse from
         * @param \WpOrg\Requests\Iri|null $origin URI for comparing cookie origins
         * @param int|null $time Reference time for expiration calculation
         * @return array
         *
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $origin argument is not null or an instance of the Iri class.
         */
        public static function parse_from_headers(\WpOrg\Requests\Response\Headers $headers, $origin = null, $time = null)
        {
        }
    }
}
namespace WpOrg\Requests\Cookie {
    /**
     * Cookie holder object
     *
     * @package Requests\Cookies
     */
    class Jar implements \ArrayAccess, \IteratorAggregate
    {
        /**
         * Actual item data
         *
         * @var array
         */
        protected $cookies = [];
        /**
         * Create a new jar
         *
         * @param array $cookies Existing cookie values
         *
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed argument is not an array.
         */
        public function __construct($cookies = [])
        {
        }
        /**
         * Normalise cookie data into a \WpOrg\Requests\Cookie
         *
         * @param string|\WpOrg\Requests\Cookie $cookie Cookie header value, possibly pre-parsed (object).
         * @param string                        $key    Optional. The name for this cookie.
         * @return \WpOrg\Requests\Cookie
         */
        public function normalize_cookie($cookie, $key = '')
        {
        }
        /**
         * Check if the given item exists
         *
         * @param string $offset Item key
         * @return boolean Does the item exist?
         */
        #[\ReturnTypeWillChange]
        public function offsetExists($offset)
        {
        }
        /**
         * Get the value for the item
         *
         * @param string $offset Item key
         * @return string|null Item value (null if offsetExists is false)
         */
        #[\ReturnTypeWillChange]
        public function offsetGet($offset)
        {
        }
        /**
         * Set the given item
         *
         * @param string $offset Item name
         * @param string $value Item value
         *
         * @throws \WpOrg\Requests\Exception On attempting to use dictionary as list (`invalidset`)
         */
        #[\ReturnTypeWillChange]
        public function offsetSet($offset, $value)
        {
        }
        /**
         * Unset the given header
         *
         * @param string $offset The key for the item to unset.
         */
        #[\ReturnTypeWillChange]
        public function offsetUnset($offset)
        {
        }
        /**
         * Get an iterator for the data
         *
         * @return \ArrayIterator
         */
        #[\ReturnTypeWillChange]
        public function getIterator()
        {
        }
        /**
         * Register the cookie handler with the request's hooking system
         *
         * @param \WpOrg\Requests\HookManager $hooks Hooking system
         */
        public function register(\WpOrg\Requests\HookManager $hooks)
        {
        }
        /**
         * Add Cookie header to a request if we have any
         *
         * As per RFC 6265, cookies are separated by '; '
         *
         * @param string $url
         * @param array $headers
         * @param array $data
         * @param string $type
         * @param array $options
         */
        public function before_request($url, &$headers, &$data, &$type, &$options)
        {
        }
        /**
         * Parse all cookies from a response and attach them to the response
         *
         * @param \WpOrg\Requests\Response $response Response as received.
         */
        public function before_redirect_check(\WpOrg\Requests\Response $response)
        {
        }
    }
}
namespace WpOrg\Requests {
    /**
     * Exception for HTTP requests
     *
     * @package Requests\Exceptions
     */
    class Exception extends \Exception
    {
        /**
         * Type of exception
         *
         * @var string
         */
        protected $type;
        /**
         * Data associated with the exception
         *
         * @var mixed
         */
        protected $data;
        /**
         * Create a new exception
         *
         * @param string $message Exception message
         * @param string $type Exception type
         * @param mixed $data Associated data
         * @param integer $code Exception numerical code, if applicable
         */
        public function __construct($message, $type, $data = null, $code = 0)
        {
        }
        /**
         * Like {@see \Exception::getCode()}, but a string code.
         *
         * @codeCoverageIgnore
         * @return string
         */
        public function getType()
        {
        }
        /**
         * Gives any relevant data
         *
         * @codeCoverageIgnore
         * @return mixed
         */
        public function getData()
        {
        }
    }
}
namespace WpOrg\Requests\Exception {
    /**
     * Exception for when an incorrect number of arguments are passed to a method.
     *
     * Typically, this exception is used when all arguments for a method are optional,
     * but certain arguments need to be passed together, i.e. a method which can be called
     * with no arguments or with two arguments, but not with one argument.
     *
     * Along the same lines, this exception is also used if a method expects an array
     * with a certain number of elements and the provided number of elements does not comply.
     *
     * @package Requests\Exceptions
     * @since   2.0.0
     */
    final class ArgumentCount extends \WpOrg\Requests\Exception
    {
        /**
         * Create a new argument count exception with a standardized text.
         *
         * @param string $expected The argument count expected as a phrase.
         *                         For example: `at least 2 arguments` or `exactly 1 argument`.
         * @param int    $received The actual argument count received.
         * @param string $type     Exception type.
         *
         * @return \WpOrg\Requests\Exception\ArgumentCount
         */
        public static function create($expected, $received, $type)
        {
        }
    }
    /**
     * Exception based on HTTP response
     *
     * @package Requests\Exceptions
     */
    class Http extends \WpOrg\Requests\Exception
    {
        /**
         * HTTP status code
         *
         * @var integer
         */
        protected $code = 0;
        /**
         * Reason phrase
         *
         * @var string
         */
        protected $reason = 'Unknown';
        /**
         * Create a new exception
         *
         * There is no mechanism to pass in the status code, as this is set by the
         * subclass used. Reason phrases can vary, however.
         *
         * @param string|null $reason Reason phrase
         * @param mixed $data Associated data
         */
        public function __construct($reason = null, $data = null)
        {
        }
        /**
         * Get the status message.
         *
         * @return string
         */
        public function getReason()
        {
        }
        /**
         * Get the correct exception class for a given error code
         *
         * @param int|bool $code HTTP status code, or false if unavailable
         * @return string Exception class name to use
         */
        public static function get_class($code)
        {
        }
    }
}
namespace WpOrg\Requests\Exception\Http {
    /**
     * Exception for 304 Not Modified responses
     *
     * @package Requests\Exceptions
     */
    final class Status304 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 305 Use Proxy responses
     *
     * @package Requests\Exceptions
     */
    final class Status305 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 306 Switch Proxy responses
     *
     * @package Requests\Exceptions
     */
    final class Status306 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 400 Bad Request responses
     *
     * @package Requests\Exceptions
     */
    final class Status400 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 401 Unauthorized responses
     *
     * @package Requests\Exceptions
     */
    final class Status401 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 402 Payment Required responses
     *
     * @package Requests\Exceptions
     */
    final class Status402 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 403 Forbidden responses
     *
     * @package Requests\Exceptions
     */
    final class Status403 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 404 Not Found responses
     *
     * @package Requests\Exceptions
     */
    final class Status404 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 405 Method Not Allowed responses
     *
     * @package Requests\Exceptions
     */
    final class Status405 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 406 Not Acceptable responses
     *
     * @package Requests\Exceptions
     */
    final class Status406 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 407 Proxy Authentication Required responses
     *
     * @package Requests\Exceptions
     */
    final class Status407 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 408 Request Timeout responses
     *
     * @package Requests\Exceptions
     */
    final class Status408 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 409 Conflict responses
     *
     * @package Requests\Exceptions
     */
    final class Status409 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 410 Gone responses
     *
     * @package Requests\Exceptions
     */
    final class Status410 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 411 Length Required responses
     *
     * @package Requests\Exceptions
     */
    final class Status411 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 412 Precondition Failed responses
     *
     * @package Requests\Exceptions
     */
    final class Status412 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 413 Request Entity Too Large responses
     *
     * @package Requests\Exceptions
     */
    final class Status413 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 414 Request-URI Too Large responses
     *
     * @package Requests\Exceptions
     */
    final class Status414 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 415 Unsupported Media Type responses
     *
     * @package Requests\Exceptions
     */
    final class Status415 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 416 Requested Range Not Satisfiable responses
     *
     * @package Requests\Exceptions
     */
    final class Status416 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 417 Expectation Failed responses
     *
     * @package Requests\Exceptions
     */
    final class Status417 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 418 I'm A Teapot responses
     *
     * @link https://tools.ietf.org/html/rfc2324
     *
     * @package Requests\Exceptions
     */
    final class Status418 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 428 Precondition Required responses
     *
     * @link https://tools.ietf.org/html/rfc6585
     *
     * @package Requests\Exceptions
     */
    final class Status428 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 429 Too Many Requests responses
     *
     * @link https://tools.ietf.org/html/draft-nottingham-http-new-status-04
     *
     * @package Requests\Exceptions
     */
    final class Status429 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 431 Request Header Fields Too Large responses
     *
     * @link https://tools.ietf.org/html/rfc6585
     *
     * @package Requests\Exceptions
     */
    final class Status431 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 500 Internal Server Error responses
     *
     * @package Requests\Exceptions
     */
    final class Status500 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 501 Not Implemented responses
     *
     * @package Requests\Exceptions
     */
    final class Status501 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 502 Bad Gateway responses
     *
     * @package Requests\Exceptions
     */
    final class Status502 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 503 Service Unavailable responses
     *
     * @package Requests\Exceptions
     */
    final class Status503 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 504 Gateway Timeout responses
     *
     * @package Requests\Exceptions
     */
    final class Status504 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 505 HTTP Version Not Supported responses
     *
     * @package Requests\Exceptions
     */
    final class Status505 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for 511 Network Authentication Required responses
     *
     * @link https://tools.ietf.org/html/rfc6585
     *
     * @package Requests\Exceptions
     */
    final class Status511 extends \WpOrg\Requests\Exception\Http
    {
    }
    /**
     * Exception for unknown status responses
     *
     * @package Requests\Exceptions
     */
    final class StatusUnknown extends \WpOrg\Requests\Exception\Http
    {
        /**
         * Create a new exception
         *
         * If `$data` is an instance of {@see \WpOrg\Requests\Response}, uses the status
         * code from it. Otherwise, sets as 0
         *
         * @param string|null $reason Reason phrase
         * @param mixed $data Associated data
         */
        public function __construct($reason = null, $data = null)
        {
        }
    }
}
namespace WpOrg\Requests\Exception {
    /**
     * Exception for an invalid argument passed.
     *
     * @package Requests\Exceptions
     * @since   2.0.0
     */
    final class InvalidArgument extends \InvalidArgumentException
    {
        /**
         * Create a new invalid argument exception with a standardized text.
         *
         * @param int    $position The argument position in the function signature. 1-based.
         * @param string $name     The argument name in the function signature.
         * @param string $expected The argument type expected as a string.
         * @param string $received The actual argument type received.
         *
         * @return \WpOrg\Requests\Exception\InvalidArgument
         */
        public static function create($position, $name, $expected, $received)
        {
        }
    }
    /**
     * Transport Exception
     *
     * @package Requests\Exceptions
     */
    class Transport extends \WpOrg\Requests\Exception
    {
    }
}
namespace WpOrg\Requests\Exception\Transport {
    /**
     * CURL Transport Exception.
     *
     * @package Requests\Exceptions
     */
    final class Curl extends \WpOrg\Requests\Exception\Transport
    {
        const EASY = 'cURLEasy';
        const MULTI = 'cURLMulti';
        const SHARE = 'cURLShare';
        /**
         * Create a new exception.
         *
         * @param string $message Exception message.
         * @param string $type    Exception type.
         * @param mixed  $data    Associated data, if applicable.
         * @param int    $code    Exception numerical code, if applicable.
         */
        public function __construct($message, $type, $data = null, $code = 0)
        {
        }
        /**
         * Get the error message.
         *
         * @return string
         */
        public function getReason()
        {
        }
    }
}
namespace WpOrg\Requests {
    /**
     * Event dispatcher
     *
     * @package Requests\EventDispatcher
     */
    interface HookManager
    {
        /**
         * Register a callback for a hook
         *
         * @param string $hook Hook name
         * @param callable $callback Function/method to call on event
         * @param int $priority Priority number. <0 is executed earlier, >0 is executed later
         */
        public function register($hook, $callback, $priority = 0);
        /**
         * Dispatch a message
         *
         * @param string $hook Hook name
         * @param array $parameters Parameters to pass to callbacks
         * @return boolean Successfulness
         */
        public function dispatch($hook, $parameters = []);
    }
    /**
     * Handles adding and dispatching events
     *
     * @package Requests\EventDispatcher
     */
    class Hooks implements \WpOrg\Requests\HookManager
    {
        /**
         * Registered callbacks for each hook
         *
         * @var array
         */
        protected $hooks = [];
        /**
         * Register a callback for a hook
         *
         * @param string $hook Hook name
         * @param callable $callback Function/method to call on event
         * @param int $priority Priority number. <0 is executed earlier, >0 is executed later
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $hook argument is not a string.
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $callback argument is not callable.
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $priority argument is not an integer.
         */
        public function register($hook, $callback, $priority = 0)
        {
        }
        /**
         * Dispatch a message
         *
         * @param string $hook Hook name
         * @param array $parameters Parameters to pass to callbacks
         * @return boolean Successfulness
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $hook argument is not a string.
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $parameters argument is not an array.
         */
        public function dispatch($hook, $parameters = [])
        {
        }
        public function __wakeup()
        {
        }
    }
    /**
     * IDNA URL encoder
     *
     * Note: Not fully compliant, as nameprep does nothing yet.
     *
     * @package Requests\Utilities
     *
     * @link https://tools.ietf.org/html/rfc3490 IDNA specification
     * @link https://tools.ietf.org/html/rfc3492 Punycode/Bootstrap specification
     */
    class IdnaEncoder
    {
        /**
         * ACE prefix used for IDNA
         *
         * @link https://tools.ietf.org/html/rfc3490#section-5
         * @var string
         */
        const ACE_PREFIX = 'xn--';
        /**
         * Maximum length of a IDNA URL in ASCII.
         *
         * @see \WpOrg\Requests\IdnaEncoder::to_ascii()
         *
         * @since 2.0.0
         *
         * @var int
         */
        const MAX_LENGTH = 64;
        /**#@+
         * Bootstrap constant for Punycode
         *
         * @link https://tools.ietf.org/html/rfc3492#section-5
         * @var int
         */
        const BOOTSTRAP_BASE = 36;
        const BOOTSTRAP_TMIN = 1;
        const BOOTSTRAP_TMAX = 26;
        const BOOTSTRAP_SKEW = 38;
        const BOOTSTRAP_DAMP = 700;
        const BOOTSTRAP_INITIAL_BIAS = 72;
        const BOOTSTRAP_INITIAL_N = 128;
        /**#@-*/
        /**
         * Encode a hostname using Punycode
         *
         * @param string|Stringable $hostname Hostname
         * @return string Punycode-encoded hostname
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed argument is not a string or a stringable object.
         */
        public static function encode($hostname)
        {
        }
        /**
         * Convert a UTF-8 text string to an ASCII string using Punycode
         *
         * @param string $text ASCII or UTF-8 string (max length 64 characters)
         * @return string ASCII string
         *
         * @throws \WpOrg\Requests\Exception Provided string longer than 64 ASCII characters (`idna.provided_too_long`)
         * @throws \WpOrg\Requests\Exception Prepared string longer than 64 ASCII characters (`idna.prepared_too_long`)
         * @throws \WpOrg\Requests\Exception Provided string already begins with xn-- (`idna.provided_is_prefixed`)
         * @throws \WpOrg\Requests\Exception Encoded string longer than 64 ASCII characters (`idna.encoded_too_long`)
         */
        public static function to_ascii($text)
        {
        }
        /**
         * Check whether a given text string contains only ASCII characters
         *
         * @internal (Testing found regex was the fastest implementation)
         *
         * @param string $text Text to examine.
         * @return bool Is the text string ASCII-only?
         */
        protected static function is_ascii($text)
        {
        }
        /**
         * Prepare a text string for use as an IDNA name
         *
         * @todo Implement this based on RFC 3491 and the newer 5891
         * @param string $text Text to prepare.
         * @return string Prepared string
         */
        protected static function nameprep($text)
        {
        }
        /**
         * Convert a UTF-8 string to a UCS-4 codepoint array
         *
         * Based on \WpOrg\Requests\Iri::replace_invalid_with_pct_encoding()
         *
         * @param string $input Text to convert.
         * @return array Unicode code points
         *
         * @throws \WpOrg\Requests\Exception Invalid UTF-8 codepoint (`idna.invalidcodepoint`)
         */
        protected static function utf8_to_codepoints($input)
        {
        }
        /**
         * RFC3492-compliant encoder
         *
         * @internal Pseudo-code from Section 6.3 is commented with "#" next to relevant code
         *
         * @param string $input UTF-8 encoded string to encode
         * @return string Punycode-encoded string
         *
         * @throws \WpOrg\Requests\Exception On character outside of the domain (never happens with Punycode) (`idna.character_outside_domain`)
         */
        public static function punycode_encode($input)
        {
        }
        /**
         * Convert a digit to its respective character
         *
         * @link https://tools.ietf.org/html/rfc3492#section-5
         *
         * @param int $digit Digit in the range 0-35
         * @return string Single character corresponding to digit
         *
         * @throws \WpOrg\Requests\Exception On invalid digit (`idna.invalid_digit`)
         */
        protected static function digit_to_char($digit)
        {
        }
        /**
         * Adapt the bias
         *
         * @link https://tools.ietf.org/html/rfc3492#section-6.1
         * @param int $delta
         * @param int $numpoints
         * @param bool $firsttime
         * @return int|float New bias
         *
         * function adapt(delta,numpoints,firsttime):
         */
        protected static function adapt($delta, $numpoints, $firsttime)
        {
        }
    }
    /**
     * Class to validate and to work with IPv6 addresses
     *
     * This was originally based on the PEAR class of the same name, but has been
     * entirely rewritten.
     *
     * @package Requests\Utilities
     */
    final class Ipv6
    {
        /**
         * Uncompresses an IPv6 address
         *
         * RFC 4291 allows you to compress consecutive zero pieces in an address to
         * '::'. This method expects a valid IPv6 address and expands the '::' to
         * the required number of zero pieces.
         *
         * Example:  FF01::101   ->  FF01:0:0:0:0:0:0:101
         *           ::1         ->  0:0:0:0:0:0:0:1
         *
         * @author Alexander Merz <alexander.merz@web.de>
         * @author elfrink at introweb dot nl
         * @author Josh Peck <jmp at joshpeck dot org>
         * @copyright 2003-2005 The PHP Group
         * @license https://opensource.org/licenses/bsd-license.php
         *
         * @param string|Stringable $ip An IPv6 address
         * @return string The uncompressed IPv6 address
         *
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed argument is not a string or a stringable object.
         */
        public static function uncompress($ip)
        {
        }
        /**
         * Compresses an IPv6 address
         *
         * RFC 4291 allows you to compress consecutive zero pieces in an address to
         * '::'. This method expects a valid IPv6 address and compresses consecutive
         * zero pieces to '::'.
         *
         * Example:  FF01:0:0:0:0:0:0:101   ->  FF01::101
         *           0:0:0:0:0:0:0:1        ->  ::1
         *
         * @see \WpOrg\Requests\Ipv6::uncompress()
         *
         * @param string $ip An IPv6 address
         * @return string The compressed IPv6 address
         */
        public static function compress($ip)
        {
        }
        /**
         * Checks an IPv6 address
         *
         * Checks if the given IP is a valid IPv6 address
         *
         * @param string $ip An IPv6 address
         * @return bool true if $ip is a valid IPv6 address
         */
        public static function check_ipv6($ip)
        {
        }
    }
    /**
     * IRI parser/serialiser/normaliser
     *
     * Copyright (c) 2007-2010, Geoffrey Sneddon and Steve Minutillo.
     * All rights reserved.
     *
     * Redistribution and use in source and binary forms, with or without
     * modification, are permitted provided that the following conditions are met:
     *
     *  * Redistributions of source code must retain the above copyright notice,
     *       this list of conditions and the following disclaimer.
     *
     *  * Redistributions in binary form must reproduce the above copyright notice,
     *       this list of conditions and the following disclaimer in the documentation
     *       and/or other materials provided with the distribution.
     *
     *  * Neither the name of the SimplePie Team nor the names of its contributors
     *       may be used to endorse or promote products derived from this software
     *       without specific prior written permission.
     *
     * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
     * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
     * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
     * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS AND CONTRIBUTORS BE
     * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
     * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
     * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
     * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
     * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
     * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
     * POSSIBILITY OF SUCH DAMAGE.
     *
     * @package Requests\Utilities
     * @author Geoffrey Sneddon
     * @author Steve Minutillo
     * @copyright 2007-2009 Geoffrey Sneddon and Steve Minutillo
     * @license https://opensource.org/licenses/bsd-license.php
     * @link http://hg.gsnedders.com/iri/
     *
     * @property string $iri IRI we're working with
     * @property-read string $uri IRI in URI form, {@see \WpOrg\Requests\Iri::to_uri()}
     * @property string $scheme Scheme part of the IRI
     * @property string $authority Authority part, formatted for a URI (userinfo + host + port)
     * @property string $iauthority Authority part of the IRI (userinfo + host + port)
     * @property string $userinfo Userinfo part, formatted for a URI (after '://' and before '@')
     * @property string $iuserinfo Userinfo part of the IRI (after '://' and before '@')
     * @property string $host Host part, formatted for a URI
     * @property string $ihost Host part of the IRI
     * @property string $port Port part of the IRI (after ':')
     * @property string $path Path part, formatted for a URI (after first '/')
     * @property string $ipath Path part of the IRI (after first '/')
     * @property string $query Query part, formatted for a URI (after '?')
     * @property string $iquery Query part of the IRI (after '?')
     * @property string $fragment Fragment, formatted for a URI (after '#')
     * @property string $ifragment Fragment part of the IRI (after '#')
     */
    class Iri
    {
        /**
         * Scheme
         *
         * @var string|null
         */
        protected $scheme = null;
        /**
         * User Information
         *
         * @var string|null
         */
        protected $iuserinfo = null;
        /**
         * ihost
         *
         * @var string|null
         */
        protected $ihost = null;
        /**
         * Port
         *
         * @var string|null
         */
        protected $port = null;
        /**
         * ipath
         *
         * @var string
         */
        protected $ipath = '';
        /**
         * iquery
         *
         * @var string|null
         */
        protected $iquery = null;
        /**
         * ifragment|null
         *
         * @var string
         */
        protected $ifragment = null;
        /**
         * Normalization database
         *
         * Each key is the scheme, each value is an array with each key as the IRI
         * part and value as the default value for that part.
         *
         * @var array
         */
        protected $normalization = array('acap' => array('port' => \WpOrg\Requests\Port::ACAP), 'dict' => array('port' => \WpOrg\Requests\Port::DICT), 'file' => array('ihost' => 'localhost'), 'http' => array('port' => \WpOrg\Requests\Port::HTTP), 'https' => array('port' => \WpOrg\Requests\Port::HTTPS));
        /**
         * Return the entire IRI when you try and read the object as a string
         *
         * @return string
         */
        public function __toString()
        {
        }
        /**
         * Overload __set() to provide access via properties
         *
         * @param string $name Property name
         * @param mixed $value Property value
         */
        public function __set($name, $value)
        {
        }
        /**
         * Overload __get() to provide access via properties
         *
         * @param string $name Property name
         * @return mixed
         */
        public function __get($name)
        {
        }
        /**
         * Overload __isset() to provide access via properties
         *
         * @param string $name Property name
         * @return bool
         */
        public function __isset($name)
        {
        }
        /**
         * Overload __unset() to provide access via properties
         *
         * @param string $name Property name
         */
        public function __unset($name)
        {
        }
        /**
         * Create a new IRI object, from a specified string
         *
         * @param string|Stringable|null $iri
         *
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $iri argument is not a string, Stringable or null.
         */
        public function __construct($iri = null)
        {
        }
        /**
         * Create a new IRI object by resolving a relative IRI
         *
         * Returns false if $base is not absolute, otherwise an IRI.
         *
         * @param \WpOrg\Requests\Iri|string $base (Absolute) Base IRI
         * @param \WpOrg\Requests\Iri|string $relative Relative IRI
         * @return \WpOrg\Requests\Iri|false
         */
        public static function absolutize($base, $relative)
        {
        }
        /**
         * Parse an IRI into scheme/authority/path/query/fragment segments
         *
         * @param string $iri
         * @return array
         */
        protected function parse_iri($iri)
        {
        }
        /**
         * Remove dot segments from a path
         *
         * @param string $input
         * @return string
         */
        protected function remove_dot_segments($input)
        {
        }
        /**
         * Replace invalid character with percent encoding
         *
         * @param string $text Input string
         * @param string $extra_chars Valid characters not in iunreserved or
         *                            iprivate (this is ASCII-only)
         * @param bool $iprivate Allow iprivate
         * @return string
         */
        protected function replace_invalid_with_pct_encoding($text, $extra_chars, $iprivate = false)
        {
        }
        /**
         * Callback function for preg_replace_callback.
         *
         * Removes sequences of percent encoded bytes that represent UTF-8
         * encoded characters in iunreserved
         *
         * @param array $regex_match PCRE match
         * @return string Replacement
         */
        protected function remove_iunreserved_percent_encoded($regex_match)
        {
        }
        protected function scheme_normalization()
        {
        }
        /**
         * Check if the object represents a valid IRI. This needs to be done on each
         * call as some things change depending on another part of the IRI.
         *
         * @return bool
         */
        public function is_valid()
        {
        }
        public function __wakeup()
        {
        }
        /**
         * Set the entire IRI. Returns true on success, false on failure (if there
         * are any invalid characters).
         *
         * @param string $iri
         * @return bool
         */
        protected function set_iri($iri)
        {
        }
        /**
         * Set the scheme. Returns true on success, false on failure (if there are
         * any invalid characters).
         *
         * @param string $scheme
         * @return bool
         */
        protected function set_scheme($scheme)
        {
        }
        /**
         * Set the authority. Returns true on success, false on failure (if there are
         * any invalid characters).
         *
         * @param string $authority
         * @return bool
         */
        protected function set_authority($authority)
        {
        }
        /**
         * Set the iuserinfo.
         *
         * @param string $iuserinfo
         * @return bool
         */
        protected function set_userinfo($iuserinfo)
        {
        }
        /**
         * Set the ihost. Returns true on success, false on failure (if there are
         * any invalid characters).
         *
         * @param string $ihost
         * @return bool
         */
        protected function set_host($ihost)
        {
        }
        /**
         * Set the port. Returns true on success, false on failure (if there are
         * any invalid characters).
         *
         * @param string $port
         * @return bool
         */
        protected function set_port($port)
        {
        }
        /**
         * Set the ipath.
         *
         * @param string $ipath
         * @return bool
         */
        protected function set_path($ipath)
        {
        }
        /**
         * Set the iquery.
         *
         * @param string $iquery
         * @return bool
         */
        protected function set_query($iquery)
        {
        }
        /**
         * Set the ifragment.
         *
         * @param string $ifragment
         * @return bool
         */
        protected function set_fragment($ifragment)
        {
        }
        /**
         * Convert an IRI to a URI (or parts thereof)
         *
         * @param string|bool $iri IRI to convert (or false from {@see \WpOrg\Requests\Iri::get_iri()})
         * @return string|false URI if IRI is valid, false otherwise.
         */
        protected function to_uri($iri)
        {
        }
        /**
         * Get the complete IRI
         *
         * @return string|false
         */
        protected function get_iri()
        {
        }
        /**
         * Get the complete URI
         *
         * @return string
         */
        protected function get_uri()
        {
        }
        /**
         * Get the complete iauthority
         *
         * @return string|null
         */
        protected function get_iauthority()
        {
        }
        /**
         * Get the complete authority
         *
         * @return string
         */
        protected function get_authority()
        {
        }
    }
    /**
     * Find the correct port depending on the Request type.
     *
     * @package Requests\Utilities
     * @since   2.0.0
     */
    final class Port
    {
        /**
         * Port to use with Acap requests.
         *
         * @var int
         */
        const ACAP = 674;
        /**
         * Port to use with Dictionary requests.
         *
         * @var int
         */
        const DICT = 2628;
        /**
         * Port to use with HTTP requests.
         *
         * @var int
         */
        const HTTP = 80;
        /**
         * Port to use with HTTP over SSL requests.
         *
         * @var int
         */
        const HTTPS = 443;
        /**
         * Retrieve the port number to use.
         *
         * @param string $type Request type.
         *                     The following requests types are supported:
         *                     'acap', 'dict', 'http' and 'https'.
         *
         * @return int
         *
         * @throws \WpOrg\Requests\Exception\InvalidArgument When a non-string input has been passed.
         * @throws \WpOrg\Requests\Exception                 When a non-supported port is requested ('portnotsupported').
         * @phpstan-param 'acap'|'dict'|'http'|'https' $type
         */
        public static function get($type)
        {
        }
    }
    /**
     * Proxy connection interface
     *
     * Implement this interface to handle proxy settings and authentication
     *
     * Parameters should be passed via the constructor where possible, as this
     * makes it much easier for users to use your provider.
     *
     * @see \WpOrg\Requests\Hooks
     *
     * @package Requests\Proxy
     * @since   1.6
     */
    interface Proxy
    {
        /**
         * Register hooks as needed
         *
         * This method is called in {@see \WpOrg\Requests\Requests::request()} when the user
         * has set an instance as the 'auth' option. Use this callback to register all the
         * hooks you'll need.
         *
         * @see \WpOrg\Requests\Hooks::register()
         * @param \WpOrg\Requests\Hooks $hooks Hook system
         */
        public function register(\WpOrg\Requests\Hooks $hooks);
    }
}
namespace WpOrg\Requests\Proxy {
    /**
     * HTTP Proxy connection interface
     *
     * Provides a handler for connection via an HTTP proxy
     *
     * @package Requests\Proxy
     * @since   1.6
     */
    final class Http implements \WpOrg\Requests\Proxy
    {
        /**
         * Proxy host and port
         *
         * Notation: "host:port" (eg 127.0.0.1:8080 or someproxy.com:3128)
         *
         * @var string
         */
        public $proxy;
        /**
         * Username
         *
         * @var string
         */
        public $user;
        /**
         * Password
         *
         * @var string
         */
        public $pass;
        /**
         * Do we need to authenticate? (ie username & password have been provided)
         *
         * @var boolean
         */
        public $use_authentication;
        /**
         * Constructor
         *
         * @since 1.6
         *
         * @param array|string|null $args Proxy as a string or an array of proxy, user and password.
         *                                When passed as an array, must have exactly one (proxy)
         *                                or three elements (proxy, user, password).
         *
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed argument is not an array, a string or null.
         * @throws \WpOrg\Requests\Exception\ArgumentCount On incorrect number of arguments (`proxyhttpbadargs`)
         */
        public function __construct($args = null)
        {
        }
        /**
         * Register the necessary callbacks
         *
         * @since 1.6
         * @see \WpOrg\Requests\Proxy\Http::curl_before_send()
         * @see \WpOrg\Requests\Proxy\Http::fsockopen_remote_socket()
         * @see \WpOrg\Requests\Proxy\Http::fsockopen_remote_host_path()
         * @see \WpOrg\Requests\Proxy\Http::fsockopen_header()
         * @param \WpOrg\Requests\Hooks $hooks Hook system
         */
        public function register(\WpOrg\Requests\Hooks $hooks)
        {
        }
        /**
         * Set cURL parameters before the data is sent
         *
         * @since 1.6
         * @param resource|\CurlHandle $handle cURL handle
         */
        public function curl_before_send(&$handle)
        {
        }
        /**
         * Alter remote socket information before opening socket connection
         *
         * @since 1.6
         * @param string $remote_socket Socket connection string
         */
        public function fsockopen_remote_socket(&$remote_socket)
        {
        }
        /**
         * Alter remote path before getting stream data
         *
         * @since 1.6
         * @param string $path Path to send in HTTP request string ("GET ...")
         * @param string $url Full URL we're requesting
         */
        public function fsockopen_remote_host_path(&$path, $url)
        {
        }
        /**
         * Add extra headers to the request before sending
         *
         * @since 1.6
         * @param string $out HTTP header string
         */
        public function fsockopen_header(&$out)
        {
        }
        /**
         * Get the authentication string (user:pass)
         *
         * @since 1.6
         * @return string
         */
        public function get_auth_string()
        {
        }
    }
}
namespace WpOrg\Requests {
    /**
     * Requests for PHP
     *
     * Inspired by Requests for Python.
     *
     * Based on concepts from SimplePie_File, RequestCore and WP_Http.
     *
     * @package Requests
     */
    class Requests
    {
        /**
         * POST method
         *
         * @var string
         */
        const POST = 'POST';
        /**
         * PUT method
         *
         * @var string
         */
        const PUT = 'PUT';
        /**
         * GET method
         *
         * @var string
         */
        const GET = 'GET';
        /**
         * HEAD method
         *
         * @var string
         */
        const HEAD = 'HEAD';
        /**
         * DELETE method
         *
         * @var string
         */
        const DELETE = 'DELETE';
        /**
         * OPTIONS method
         *
         * @var string
         */
        const OPTIONS = 'OPTIONS';
        /**
         * TRACE method
         *
         * @var string
         */
        const TRACE = 'TRACE';
        /**
         * PATCH method
         *
         * @link https://tools.ietf.org/html/rfc5789
         * @var string
         */
        const PATCH = 'PATCH';
        /**
         * Default size of buffer size to read streams
         *
         * @var integer
         */
        const BUFFER_SIZE = 1160;
        /**
         * Option defaults.
         *
         * @see \WpOrg\Requests\Requests::get_default_options()
         * @see \WpOrg\Requests\Requests::request() for values returned by this method
         *
         * @since 2.0.0
         *
         * @var array
         */
        const OPTION_DEFAULTS = ['timeout' => 10, 'connect_timeout' => 10, 'useragent' => 'php-requests/' . self::VERSION, 'protocol_version' => 1.1, 'redirected' => 0, 'redirects' => 10, 'follow_redirects' => true, 'blocking' => true, 'type' => self::GET, 'filename' => false, 'auth' => false, 'proxy' => false, 'cookies' => false, 'max_bytes' => false, 'idn' => true, 'hooks' => null, 'transport' => null, 'verify' => null, 'verifyname' => true];
        /**
         * Default supported Transport classes.
         *
         * @since 2.0.0
         *
         * @var array
         */
        const DEFAULT_TRANSPORTS = [\WpOrg\Requests\Transport\Curl::class => \WpOrg\Requests\Transport\Curl::class, \WpOrg\Requests\Transport\Fsockopen::class => \WpOrg\Requests\Transport\Fsockopen::class];
        /**
         * Current version of Requests
         *
         * @var string
         */
        const VERSION = '2.0.11';
        /**
         * Selected transport name
         *
         * Use {@see \WpOrg\Requests\Requests::get_transport()} instead
         *
         * @var array
         */
        public static $transport = [];
        /**
         * Registered transport classes
         *
         * @var array
         */
        protected static $transports = [];
        /**
         * Default certificate path.
         *
         * @see \WpOrg\Requests\Requests::get_certificate_path()
         * @see \WpOrg\Requests\Requests::set_certificate_path()
         *
         * @var string
         */
        protected static $certificate_path = __DIR__ . '/../certificates/cacert.pem';
        /**
         * Register a transport
         *
         * @param string $transport Transport class to add, must support the \WpOrg\Requests\Transport interface
         */
        public static function add_transport($transport)
        {
        }
        /**
         * Get the fully qualified class name (FQCN) for a working transport.
         *
         * @param array<string, bool> $capabilities Optional. Associative array of capabilities to test against, i.e. `['<capability>' => true]`.
         * @return string FQCN of the transport to use, or an empty string if no transport was
         *                found which provided the requested capabilities.
         */
        protected static function get_transport_class(array $capabilities = [])
        {
        }
        /**
         * Get a working transport.
         *
         * @param array<string, bool> $capabilities Optional. Associative array of capabilities to test against, i.e. `['<capability>' => true]`.
         * @return \WpOrg\Requests\Transport
         * @throws \WpOrg\Requests\Exception If no valid transport is found (`notransport`).
         */
        protected static function get_transport(array $capabilities = [])
        {
        }
        /**
         * Checks to see if we have a transport for the capabilities requested.
         *
         * Supported capabilities can be found in the {@see \WpOrg\Requests\Capability}
         * interface as constants.
         *
         * Example usage:
         * `Requests::has_capabilities([Capability::SSL => true])`.
         *
         * @param array<string, bool> $capabilities Optional. Associative array of capabilities to test against, i.e. `['<capability>' => true]`.
         * @return bool Whether the transport has the requested capabilities.
         */
        public static function has_capabilities(array $capabilities = [])
        {
        }
        /**#@+
         * @see \WpOrg\Requests\Requests::request()
         * @param string $url
         * @param array $headers
         * @param array $options
         * @return \WpOrg\Requests\Response
         */
        /**
         * Send a GET request
         */
        public static function get($url, $headers = [], $options = [])
        {
        }
        /**
         * Send a HEAD request
         */
        public static function head($url, $headers = [], $options = [])
        {
        }
        /**
         * Send a DELETE request
         */
        public static function delete($url, $headers = [], $options = [])
        {
        }
        /**
         * Send a TRACE request
         */
        public static function trace($url, $headers = [], $options = [])
        {
        }
        /**#@-*/
        /**#@+
         * @see \WpOrg\Requests\Requests::request()
         * @param string $url
         * @param array $headers
         * @param array $data
         * @param array $options
         * @return \WpOrg\Requests\Response
         */
        /**
         * Send a POST request
         */
        public static function post($url, $headers = [], $data = [], $options = [])
        {
        }
        /**
         * Send a PUT request
         */
        public static function put($url, $headers = [], $data = [], $options = [])
        {
        }
        /**
         * Send an OPTIONS request
         */
        public static function options($url, $headers = [], $data = [], $options = [])
        {
        }
        /**
         * Send a PATCH request
         *
         * Note: Unlike {@see \WpOrg\Requests\Requests::post()} and {@see \WpOrg\Requests\Requests::put()},
         * `$headers` is required, as the specification recommends that should send an ETag
         *
         * @link https://tools.ietf.org/html/rfc5789
         */
        public static function patch($url, $headers, $data = [], $options = [])
        {
        }
        /**#@-*/
        /**
         * Main interface for HTTP requests
         *
         * This method initiates a request and sends it via a transport before
         * parsing.
         *
         * The `$options` parameter takes an associative array with the following
         * options:
         *
         * - `timeout`: How long should we wait for a response?
         *    Note: for cURL, a minimum of 1 second applies, as DNS resolution
         *    operates at second-resolution only.
         *    (float, seconds with a millisecond precision, default: 10, example: 0.01)
         * - `connect_timeout`: How long should we wait while trying to connect?
         *    (float, seconds with a millisecond precision, default: 10, example: 0.01)
         * - `useragent`: Useragent to send to the server
         *    (string, default: php-requests/$version)
         * - `follow_redirects`: Should we follow 3xx redirects?
         *    (boolean, default: true)
         * - `redirects`: How many times should we redirect before erroring?
         *    (integer, default: 10)
         * - `blocking`: Should we block processing on this request?
         *    (boolean, default: true)
         * - `filename`: File to stream the body to instead.
         *    (string|boolean, default: false)
         * - `auth`: Authentication handler or array of user/password details to use
         *    for Basic authentication
         *    (\WpOrg\Requests\Auth|array|boolean, default: false)
         * - `proxy`: Proxy details to use for proxy by-passing and authentication
         *    (\WpOrg\Requests\Proxy|array|string|boolean, default: false)
         * - `max_bytes`: Limit for the response body size.
         *    (integer|boolean, default: false)
         * - `idn`: Enable IDN parsing
         *    (boolean, default: true)
         * - `transport`: Custom transport. Either a class name, or a
         *    transport object. Defaults to the first working transport from
         *    {@see \WpOrg\Requests\Requests::getTransport()}
         *    (string|\WpOrg\Requests\Transport, default: {@see \WpOrg\Requests\Requests::getTransport()})
         * - `hooks`: Hooks handler.
         *    (\WpOrg\Requests\HookManager, default: new WpOrg\Requests\Hooks())
         * - `verify`: Should we verify SSL certificates? Allows passing in a custom
         *    certificate file as a string. (Using true uses the system-wide root
         *    certificate store instead, but this may have different behaviour
         *    across transports.)
         *    (string|boolean, default: certificates/cacert.pem)
         * - `verifyname`: Should we verify the common name in the SSL certificate?
         *    (boolean, default: true)
         * - `data_format`: How should we send the `$data` parameter?
         *    (string, one of 'query' or 'body', default: 'query' for
         *    HEAD/GET/DELETE, 'body' for POST/PUT/OPTIONS/PATCH)
         *
         * @param string|Stringable $url URL to request
         * @param array $headers Extra headers to send with the request
         * @param array|null $data Data to send either as a query string for GET/HEAD requests, or in the body for POST requests
         * @param string $type HTTP request type (use Requests constants)
         * @param array $options Options for the request (see description for more information)
         * @return \WpOrg\Requests\Response
         *
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $url argument is not a string or Stringable.
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $type argument is not a string.
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $options argument is not an array.
         * @throws \WpOrg\Requests\Exception On invalid URLs (`nonhttp`)
         */
        public static function request($url, $headers = [], $data = [], $type = self::GET, $options = [])
        {
        }
        /**
         * Send multiple HTTP requests simultaneously
         *
         * The `$requests` parameter takes an associative or indexed array of
         * request fields. The key of each request can be used to match up the
         * request with the returned data, or with the request passed into your
         * `multiple.request.complete` callback.
         *
         * The request fields value is an associative array with the following keys:
         *
         * - `url`: Request URL Same as the `$url` parameter to
         *    {@see \WpOrg\Requests\Requests::request()}
         *    (string, required)
         * - `headers`: Associative array of header fields. Same as the `$headers`
         *    parameter to {@see \WpOrg\Requests\Requests::request()}
         *    (array, default: `array()`)
         * - `data`: Associative array of data fields or a string. Same as the
         *    `$data` parameter to {@see \WpOrg\Requests\Requests::request()}
         *    (array|string, default: `array()`)
         * - `type`: HTTP request type (use \WpOrg\Requests\Requests constants). Same as the `$type`
         *    parameter to {@see \WpOrg\Requests\Requests::request()}
         *    (string, default: `\WpOrg\Requests\Requests::GET`)
         * - `cookies`: Associative array of cookie name to value, or cookie jar.
         *    (array|\WpOrg\Requests\Cookie\Jar)
         *
         * If the `$options` parameter is specified, individual requests will
         * inherit options from it. This can be used to use a single hooking system,
         * or set all the types to `\WpOrg\Requests\Requests::POST`, for example.
         *
         * In addition, the `$options` parameter takes the following global options:
         *
         * - `complete`: A callback for when a request is complete. Takes two
         *    parameters, a \WpOrg\Requests\Response/\WpOrg\Requests\Exception reference, and the
         *    ID from the request array (Note: this can also be overridden on a
         *    per-request basis, although that's a little silly)
         *    (callback)
         *
         * @param array $requests Requests data (see description for more information)
         * @param array $options Global and default options (see {@see \WpOrg\Requests\Requests::request()})
         * @return array Responses (either \WpOrg\Requests\Response or a \WpOrg\Requests\Exception object)
         *
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $requests argument is not an array or iterable object with array access.
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $options argument is not an array.
         */
        public static function request_multiple($requests, $options = [])
        {
        }
        /**
         * Get the default options
         *
         * @see \WpOrg\Requests\Requests::request() for values returned by this method
         * @param boolean $multirequest Is this a multirequest?
         * @return array Default option values
         */
        protected static function get_default_options($multirequest = false)
        {
        }
        /**
         * Get default certificate path.
         *
         * @return string Default certificate path.
         */
        public static function get_certificate_path()
        {
        }
        /**
         * Set default certificate path.
         *
         * @param string|Stringable|bool $path Certificate path, pointing to a PEM file.
         *
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $url argument is not a string, Stringable or boolean.
         */
        public static function set_certificate_path($path)
        {
        }
        /**
         * Set the default values
         *
         * The $options parameter is updated with the results.
         *
         * @param string $url URL to request
         * @param array $headers Extra headers to send with the request
         * @param array|null $data Data to send either as a query string for GET/HEAD requests, or in the body for POST requests
         * @param string $type HTTP request type
         * @param array $options Options for the request
         * @return void
         *
         * @throws \WpOrg\Requests\Exception When the $url is not an http(s) URL.
         */
        protected static function set_defaults(&$url, &$headers, &$data, &$type, &$options)
        {
        }
        /**
         * HTTP response parser
         *
         * @param string $headers Full response text including headers and body
         * @param string $url Original request URL
         * @param array $req_headers Original $headers array passed to {@link request()}, in case we need to follow redirects
         * @param array $req_data Original $data array passed to {@link request()}, in case we need to follow redirects
         * @param array $options Original $options array passed to {@link request()}, in case we need to follow redirects
         * @return \WpOrg\Requests\Response
         *
         * @throws \WpOrg\Requests\Exception On missing head/body separator (`requests.no_crlf_separator`)
         * @throws \WpOrg\Requests\Exception On missing head/body separator (`noversion`)
         * @throws \WpOrg\Requests\Exception On missing head/body separator (`toomanyredirects`)
         */
        protected static function parse_response($headers, $url, $req_headers, $req_data, $options)
        {
        }
        /**
         * Callback for `transport.internal.parse_response`
         *
         * Internal use only. Converts a raw HTTP response to a \WpOrg\Requests\Response
         * while still executing a multiple request.
         *
         * `$response` is either set to a \WpOrg\Requests\Response instance, or a \WpOrg\Requests\Exception object
         *
         * @param string $response Full response text including headers and body (will be overwritten with Response instance)
         * @param array $request Request data as passed into {@see \WpOrg\Requests\Requests::request_multiple()}
         * @return void
         */
        public static function parse_multiple(&$response, $request)
        {
        }
        /**
         * Decoded a chunked body as per RFC 2616
         *
         * @link https://tools.ietf.org/html/rfc2616#section-3.6.1
         * @param string $data Chunked body
         * @return string Decoded body
         */
        protected static function decode_chunked($data)
        {
        }
        /**
         * Convert a key => value array to a 'key: value' array for headers
         *
         * @param iterable $dictionary Dictionary of header values
         * @return array List of headers
         *
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed argument is not iterable.
         */
        public static function flatten($dictionary)
        {
        }
        /**
         * Decompress an encoded body
         *
         * Implements gzip, compress and deflate. Guesses which it is by attempting
         * to decode.
         *
         * @param string $data Compressed data in one of the above formats
         * @return string Decompressed string
         *
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed argument is not a string.
         */
        public static function decompress($data)
        {
        }
        /**
         * Decompression of deflated string while staying compatible with the majority of servers.
         *
         * Certain Servers will return deflated data with headers which PHP's gzinflate()
         * function cannot handle out of the box. The following function has been created from
         * various snippets on the gzinflate() PHP documentation.
         *
         * Warning: Magic numbers within. Due to the potential different formats that the compressed
         * data may be returned in, some "magic offsets" are needed to ensure proper decompression
         * takes place. For a simple progmatic way to determine the magic offset in use, see:
         * https://core.trac.wordpress.org/ticket/18273
         *
         * @since 1.6.0
         * @link https://core.trac.wordpress.org/ticket/18273
         * @link https://www.php.net/gzinflate#70875
         * @link https://www.php.net/gzinflate#77336
         *
         * @param string $gz_data String to decompress.
         * @return string|bool False on failure.
         *
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed argument is not a string.
         */
        public static function compatible_gzinflate($gz_data)
        {
        }
    }
    /**
     * HTTP response class
     *
     * Contains a response from \WpOrg\Requests\Requests::request()
     *
     * @package Requests
     */
    class Response
    {
        /**
         * Response body
         *
         * @var string
         */
        public $body = '';
        /**
         * Raw HTTP data from the transport
         *
         * @var string
         */
        public $raw = '';
        /**
         * Headers, as an associative array
         *
         * @var \WpOrg\Requests\Response\Headers Array-like object representing headers
         */
        public $headers = [];
        /**
         * Status code, false if non-blocking
         *
         * @var integer|boolean
         */
        public $status_code = false;
        /**
         * Protocol version, false if non-blocking
         *
         * @var float|boolean
         */
        public $protocol_version = false;
        /**
         * Whether the request succeeded or not
         *
         * @var boolean
         */
        public $success = false;
        /**
         * Number of redirects the request used
         *
         * @var integer
         */
        public $redirects = 0;
        /**
         * URL requested
         *
         * @var string
         */
        public $url = '';
        /**
         * Previous requests (from redirects)
         *
         * @var array Array of \WpOrg\Requests\Response objects
         */
        public $history = [];
        /**
         * Cookies from the request
         *
         * @var \WpOrg\Requests\Cookie\Jar Array-like object representing a cookie jar
         */
        public $cookies = [];
        /**
         * Constructor
         */
        public function __construct()
        {
        }
        /**
         * Is the response a redirect?
         *
         * @return boolean True if redirect (3xx status), false if not.
         */
        public function is_redirect()
        {
        }
        /**
         * Throws an exception if the request was not successful
         *
         * @param boolean $allow_redirects Set to false to throw on a 3xx as well
         *
         * @throws \WpOrg\Requests\Exception If `$allow_redirects` is false, and code is 3xx (`response.no_redirects`)
         * @throws \WpOrg\Requests\Exception\Http On non-successful status code. Exception class corresponds to "Status" + code (e.g. {@see \WpOrg\Requests\Exception\Http\Status404})
         */
        public function throw_for_status($allow_redirects = true)
        {
        }
        /**
         * JSON decode the response body.
         *
         * The method parameters are the same as those for the PHP native `json_decode()` function.
         *
         * @link https://php.net/json-decode
         *
         * @param bool|null $associative Optional. When `true`, JSON objects will be returned as associative arrays;
         *                               When `false`, JSON objects will be returned as objects.
         *                               When `null`, JSON objects will be returned as associative arrays
         *                               or objects depending on whether `JSON_OBJECT_AS_ARRAY` is set in the flags.
         *                               Defaults to `true` (in contrast to the PHP native default of `null`).
         * @param int       $depth       Optional. Maximum nesting depth of the structure being decoded.
         *                               Defaults to `512`.
         * @param int       $options     Optional. Bitmask of JSON_BIGINT_AS_STRING, JSON_INVALID_UTF8_IGNORE,
         *                               JSON_INVALID_UTF8_SUBSTITUTE, JSON_OBJECT_AS_ARRAY, JSON_THROW_ON_ERROR.
         *                               Defaults to `0` (no options set).
         *
         * @return array
         *
         * @throws \WpOrg\Requests\Exception If `$this->body` is not valid json.
         */
        public function decode_body($associative = true, $depth = 512, $options = 0)
        {
        }
    }
}
namespace WpOrg\Requests\Utility {
    /**
     * Case-insensitive dictionary, suitable for HTTP headers
     *
     * @package Requests\Utilities
     */
    class CaseInsensitiveDictionary implements \ArrayAccess, \IteratorAggregate
    {
        /**
         * Actual item data
         *
         * @var array
         */
        protected $data = [];
        /**
         * Creates a case insensitive dictionary.
         *
         * @param array $data Dictionary/map to convert to case-insensitive
         */
        public function __construct(array $data = [])
        {
        }
        /**
         * Check if the given item exists
         *
         * @param string $offset Item key
         * @return boolean Does the item exist?
         */
        #[\ReturnTypeWillChange]
        public function offsetExists($offset)
        {
        }
        /**
         * Get the value for the item
         *
         * @param string $offset Item key
         * @return string|null Item value (null if the item key doesn't exist)
         */
        #[\ReturnTypeWillChange]
        public function offsetGet($offset)
        {
        }
        /**
         * Set the given item
         *
         * @param string $offset Item name
         * @param string $value Item value
         *
         * @throws \WpOrg\Requests\Exception On attempting to use dictionary as list (`invalidset`)
         */
        #[\ReturnTypeWillChange]
        public function offsetSet($offset, $value)
        {
        }
        /**
         * Unset the given header
         *
         * @param string $offset The key for the item to unset.
         */
        #[\ReturnTypeWillChange]
        public function offsetUnset($offset)
        {
        }
        /**
         * Get an iterator for the data
         *
         * @return \ArrayIterator
         */
        #[\ReturnTypeWillChange]
        public function getIterator()
        {
        }
        /**
         * Get the headers as an array
         *
         * @return array Header data
         */
        public function getAll()
        {
        }
    }
}
namespace WpOrg\Requests\Response {
    /**
     * Case-insensitive dictionary, suitable for HTTP headers
     *
     * @package Requests
     */
    class Headers extends \WpOrg\Requests\Utility\CaseInsensitiveDictionary
    {
        /**
         * Get the given header
         *
         * Unlike {@see \WpOrg\Requests\Response\Headers::getValues()}, this returns a string. If there are
         * multiple values, it concatenates them with a comma as per RFC2616.
         *
         * Avoid using this where commas may be used unquoted in values, such as
         * Set-Cookie headers.
         *
         * @param string $offset Name of the header to retrieve.
         * @return string|null Header value
         */
        public function offsetGet($offset)
        {
        }
        /**
         * Set the given item
         *
         * @param string $offset Item name
         * @param string $value Item value
         *
         * @throws \WpOrg\Requests\Exception On attempting to use dictionary as list (`invalidset`)
         */
        public function offsetSet($offset, $value)
        {
        }
        /**
         * Get all values for a given header
         *
         * @param string $offset Name of the header to retrieve.
         * @return array|null Header values
         *
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed argument is not valid as an array key.
         */
        public function getValues($offset)
        {
        }
        /**
         * Flattens a value into a string
         *
         * Converts an array into a string by imploding values with a comma, as per
         * RFC2616's rules for folding headers.
         *
         * @param string|array $value Value to flatten
         * @return string Flattened value
         *
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed argument is not a string or an array.
         */
        public function flatten($value)
        {
        }
        /**
         * Get an iterator for the data
         *
         * Converts the internally stored values to a comma-separated string if there is more
         * than one value for a key.
         *
         * @return \ArrayIterator
         */
        public function getIterator()
        {
        }
    }
}
namespace WpOrg\Requests {
    /**
     * Session handler for persistent requests and default parameters
     *
     * Allows various options to be set as default values, and merges both the
     * options and URL properties together. A base URL can be set for all requests,
     * with all subrequests resolved from this. Base options can be set (including
     * a shared cookie jar), then overridden for individual requests.
     *
     * @package Requests\SessionHandler
     */
    class Session
    {
        /**
         * Base URL for requests
         *
         * URLs will be made absolute using this as the base
         *
         * @var string|null
         */
        public $url = null;
        /**
         * Base headers for requests
         *
         * @var array
         */
        public $headers = [];
        /**
         * Base data for requests
         *
         * If both the base data and the per-request data are arrays, the data will
         * be merged before sending the request.
         *
         * @var array
         */
        public $data = [];
        /**
         * Base options for requests
         *
         * The base options are merged with the per-request data for each request.
         * The only default option is a shared cookie jar between requests.
         *
         * Values here can also be set directly via properties on the Session
         * object, e.g. `$session->useragent = 'X';`
         *
         * @var array
         */
        public $options = [];
        /**
         * Create a new session
         *
         * @param string|Stringable|null $url Base URL for requests
         * @param array $headers Default headers for requests
         * @param array $data Default data for requests
         * @param array $options Default options for requests
         *
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $url argument is not a string, Stringable or null.
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $headers argument is not an array.
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $data argument is not an array.
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $options argument is not an array.
         */
        public function __construct($url = null, $headers = [], $data = [], $options = [])
        {
        }
        /**
         * Get a property's value
         *
         * @param string $name Property name.
         * @return mixed|null Property value, null if none found
         */
        public function __get($name)
        {
        }
        /**
         * Set a property's value
         *
         * @param string $name Property name.
         * @param mixed $value Property value
         */
        public function __set($name, $value)
        {
        }
        /**
         * Remove a property's value
         *
         * @param string $name Property name.
         */
        public function __isset($name)
        {
        }
        /**
         * Remove a property's value
         *
         * @param string $name Property name.
         */
        public function __unset($name)
        {
        }
        /**#@+
         * @see \WpOrg\Requests\Session::request()
         * @param string $url
         * @param array $headers
         * @param array $options
         * @return \WpOrg\Requests\Response
         */
        /**
         * Send a GET request
         */
        public function get($url, $headers = [], $options = [])
        {
        }
        /**
         * Send a HEAD request
         */
        public function head($url, $headers = [], $options = [])
        {
        }
        /**
         * Send a DELETE request
         */
        public function delete($url, $headers = [], $options = [])
        {
        }
        /**#@-*/
        /**#@+
         * @see \WpOrg\Requests\Session::request()
         * @param string $url
         * @param array $headers
         * @param array $data
         * @param array $options
         * @return \WpOrg\Requests\Response
         */
        /**
         * Send a POST request
         */
        public function post($url, $headers = [], $data = [], $options = [])
        {
        }
        /**
         * Send a PUT request
         */
        public function put($url, $headers = [], $data = [], $options = [])
        {
        }
        /**
         * Send a PATCH request
         *
         * Note: Unlike {@see \WpOrg\Requests\Session::post()} and {@see \WpOrg\Requests\Session::put()},
         * `$headers` is required, as the specification recommends that should send an ETag
         *
         * @link https://tools.ietf.org/html/rfc5789
         */
        public function patch($url, $headers, $data = [], $options = [])
        {
        }
        /**#@-*/
        /**
         * Main interface for HTTP requests
         *
         * This method initiates a request and sends it via a transport before
         * parsing.
         *
         * @see \WpOrg\Requests\Requests::request()
         *
         * @param string $url URL to request
         * @param array $headers Extra headers to send with the request
         * @param array|null $data Data to send either as a query string for GET/HEAD requests, or in the body for POST requests
         * @param string $type HTTP request type (use \WpOrg\Requests\Requests constants)
         * @param array $options Options for the request (see {@see \WpOrg\Requests\Requests::request()})
         * @return \WpOrg\Requests\Response
         *
         * @throws \WpOrg\Requests\Exception On invalid URLs (`nonhttp`)
         */
        public function request($url, $headers = [], $data = [], $type = \WpOrg\Requests\Requests::GET, $options = [])
        {
        }
        /**
         * Send multiple HTTP requests simultaneously
         *
         * @see \WpOrg\Requests\Requests::request_multiple()
         *
         * @param array $requests Requests data (see {@see \WpOrg\Requests\Requests::request_multiple()})
         * @param array $options Global and default options (see {@see \WpOrg\Requests\Requests::request()})
         * @return array Responses (either \WpOrg\Requests\Response or a \WpOrg\Requests\Exception object)
         *
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $requests argument is not an array or iterable object with array access.
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $options argument is not an array.
         */
        public function request_multiple($requests, $options = [])
        {
        }
        public function __wakeup()
        {
        }
        /**
         * Merge a request's data with the default data
         *
         * @param array $request Request data (same form as {@see \WpOrg\Requests\Session::request_multiple()})
         * @param boolean $merge_options Should we merge options as well?
         * @return array Request data
         */
        protected function merge_request($request, $merge_options = true)
        {
        }
    }
    /**
     * SSL utilities for Requests
     *
     * Collection of utilities for working with and verifying SSL certificates.
     *
     * @package Requests\Utilities
     */
    final class Ssl
    {
        /**
         * Verify the certificate against common name and subject alternative names
         *
         * Unfortunately, PHP doesn't check the certificate against the alternative
         * names, leading things like 'https://www.github.com/' to be invalid.
         *
         * @link https://tools.ietf.org/html/rfc2818#section-3.1 RFC2818, Section 3.1
         *
         * @param string|Stringable $host Host name to verify against
         * @param array $cert Certificate data from openssl_x509_parse()
         * @return bool
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $host argument is not a string or a stringable object.
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $cert argument is not an array or array accessible.
         */
        public static function verify_certificate($host, $cert)
        {
        }
        /**
         * Verify that a reference name is valid
         *
         * Verifies a dNSName for HTTPS usage, (almost) as per Firefox's rules:
         * - Wildcards can only occur in a name with more than 3 components
         * - Wildcards can only occur as the last character in the first
         *   component
         * - Wildcards may be preceded by additional characters
         *
         * We modify these rules to be a bit stricter and only allow the wildcard
         * character to be the full first component; that is, with the exclusion of
         * the third rule.
         *
         * @param string|Stringable $reference Reference dNSName
         * @return boolean Is the name valid?
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed argument is not a string or a stringable object.
         */
        public static function verify_reference_name($reference)
        {
        }
        /**
         * Match a hostname against a dNSName reference
         *
         * @param string|Stringable $host Requested host
         * @param string|Stringable $reference dNSName to match against
         * @return boolean Does the domain match?
         * @throws \WpOrg\Requests\Exception\InvalidArgument When either of the passed arguments is not a string or a stringable object.
         */
        public static function match_domain($host, $reference)
        {
        }
    }
    /**
     * Base HTTP transport
     *
     * @package Requests\Transport
     */
    interface Transport
    {
        /**
         * Perform a request
         *
         * @param string $url URL to request
         * @param array $headers Associative array of request headers
         * @param string|array $data Data to send either as the POST body, or as parameters in the URL for a GET/HEAD
         * @param array $options Request options, see {@see \WpOrg\Requests\Requests::response()} for documentation
         * @return string Raw HTTP result
         */
        public function request($url, $headers = [], $data = [], $options = []);
        /**
         * Send multiple requests simultaneously
         *
         * @param array $requests Request data (array of 'url', 'headers', 'data', 'options') as per {@see \WpOrg\Requests\Transport::request()}
         * @param array $options Global options, see {@see \WpOrg\Requests\Requests::response()} for documentation
         * @return array Array of \WpOrg\Requests\Response objects (may contain \WpOrg\Requests\Exception or string responses as well)
         */
        public function request_multiple($requests, $options);
        /**
         * Self-test whether the transport can be used.
         *
         * The available capabilities to test for can be found in {@see \WpOrg\Requests\Capability}.
         *
         * @param array<string, bool> $capabilities Optional. Associative array of capabilities to test against, i.e. `['<capability>' => true]`.
         * @return bool Whether the transport can be used.
         */
        public static function test($capabilities = []);
    }
}
namespace WpOrg\Requests\Transport {
    /**
     * cURL HTTP transport
     *
     * @package Requests\Transport
     */
    final class Curl implements \WpOrg\Requests\Transport
    {
        const CURL_7_10_5 = 0x70a05;
        const CURL_7_16_2 = 0x71002;
        /**
         * Raw HTTP data
         *
         * @var string
         */
        public $headers = '';
        /**
         * Raw body data
         *
         * @var string
         */
        public $response_data = '';
        /**
         * Information on the current request
         *
         * @var array cURL information array, see {@link https://www.php.net/curl_getinfo}
         */
        public $info;
        /**
         * cURL version number
         *
         * @var int
         */
        public $version;
        /**
         * Constructor
         */
        public function __construct()
        {
        }
        /**
         * Destructor
         */
        public function __destruct()
        {
        }
        /**
         * Perform a request
         *
         * @param string|Stringable $url URL to request
         * @param array $headers Associative array of request headers
         * @param string|array $data Data to send either as the POST body, or as parameters in the URL for a GET/HEAD
         * @param array $options Request options, see {@see \WpOrg\Requests\Requests::response()} for documentation
         * @return string Raw HTTP result
         *
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $url argument is not a string or Stringable.
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $headers argument is not an array.
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $data parameter is not an array or string.
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $options argument is not an array.
         * @throws \WpOrg\Requests\Exception       On a cURL error (`curlerror`)
         */
        public function request($url, $headers = [], $data = [], $options = [])
        {
        }
        /**
         * Send multiple requests simultaneously
         *
         * @param array $requests Request data
         * @param array $options Global options
         * @return array Array of \WpOrg\Requests\Response objects (may contain \WpOrg\Requests\Exception or string responses as well)
         *
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $requests argument is not an array or iterable object with array access.
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $options argument is not an array.
         */
        public function request_multiple($requests, $options)
        {
        }
        /**
         * Get the cURL handle for use in a multi-request
         *
         * @param string $url URL to request
         * @param array $headers Associative array of request headers
         * @param string|array $data Data to send either as the POST body, or as parameters in the URL for a GET/HEAD
         * @param array $options Request options, see {@see \WpOrg\Requests\Requests::response()} for documentation
         * @return resource|\CurlHandle Subrequest's cURL handle
         */
        public function &get_subrequest_handle($url, $headers, $data, $options)
        {
        }
        /**
         * Process a response
         *
         * @param string $response Response data from the body
         * @param array $options Request options
         * @return string|false HTTP response data including headers. False if non-blocking.
         * @throws \WpOrg\Requests\Exception If the request resulted in a cURL error.
         */
        public function process_response($response, $options)
        {
        }
        /**
         * Collect the headers as they are received
         *
         * @param resource|\CurlHandle $handle cURL handle
         * @param string $headers Header string
         * @return integer Length of provided header
         */
        public function stream_headers($handle, $headers)
        {
        }
        /**
         * Collect data as it's received
         *
         * @since 1.6.1
         *
         * @param resource|\CurlHandle $handle cURL handle
         * @param string $data Body data
         * @return integer Length of provided data
         */
        public function stream_body($handle, $data)
        {
        }
        /**
         * Self-test whether the transport can be used.
         *
         * The available capabilities to test for can be found in {@see \WpOrg\Requests\Capability}.
         *
         * @codeCoverageIgnore
         * @param array<string, bool> $capabilities Optional. Associative array of capabilities to test against, i.e. `['<capability>' => true]`.
         * @return bool Whether the transport can be used.
         */
        public static function test($capabilities = [])
        {
        }
    }
    /**
     * fsockopen HTTP transport
     *
     * @package Requests\Transport
     */
    final class Fsockopen implements \WpOrg\Requests\Transport
    {
        /**
         * Second to microsecond conversion
         *
         * @var integer
         */
        const SECOND_IN_MICROSECONDS = 1000000;
        /**
         * Raw HTTP data
         *
         * @var string
         */
        public $headers = '';
        /**
         * Stream metadata
         *
         * @var array Associative array of properties, see {@link https://www.php.net/stream_get_meta_data}
         */
        public $info;
        /**
         * Perform a request
         *
         * @param string|Stringable $url URL to request
         * @param array $headers Associative array of request headers
         * @param string|array $data Data to send either as the POST body, or as parameters in the URL for a GET/HEAD
         * @param array $options Request options, see {@see \WpOrg\Requests\Requests::response()} for documentation
         * @return string Raw HTTP result
         *
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $url argument is not a string or Stringable.
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $headers argument is not an array.
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $data parameter is not an array or string.
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $options argument is not an array.
         * @throws \WpOrg\Requests\Exception       On failure to connect to socket (`fsockopenerror`)
         * @throws \WpOrg\Requests\Exception       On socket timeout (`timeout`)
         */
        public function request($url, $headers = [], $data = [], $options = [])
        {
        }
        /**
         * Send multiple requests simultaneously
         *
         * @param array $requests Request data (array of 'url', 'headers', 'data', 'options') as per {@see \WpOrg\Requests\Transport::request()}
         * @param array $options Global options, see {@see \WpOrg\Requests\Requests::response()} for documentation
         * @return array Array of \WpOrg\Requests\Response objects (may contain \WpOrg\Requests\Exception or string responses as well)
         *
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $requests argument is not an array or iterable object with array access.
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $options argument is not an array.
         */
        public function request_multiple($requests, $options)
        {
        }
        /**
         * Error handler for stream_socket_client()
         *
         * @param int $errno Error number (e.g. E_WARNING)
         * @param string $errstr Error message
         */
        public function connect_error_handler($errno, $errstr)
        {
        }
        /**
         * Verify the certificate against common name and subject alternative names
         *
         * Unfortunately, PHP doesn't check the certificate against the alternative
         * names, leading things like 'https://www.github.com/' to be invalid.
         * Instead
         *
         * @link https://tools.ietf.org/html/rfc2818#section-3.1 RFC2818, Section 3.1
         *
         * @param string $host Host name to verify against
         * @param resource $context Stream context
         * @return bool
         *
         * @throws \WpOrg\Requests\Exception On failure to connect via TLS (`fsockopen.ssl.connect_error`)
         * @throws \WpOrg\Requests\Exception On not obtaining a match for the host (`fsockopen.ssl.no_match`)
         */
        public function verify_certificate_from_context($host, $context)
        {
        }
        /**
         * Self-test whether the transport can be used.
         *
         * The available capabilities to test for can be found in {@see \WpOrg\Requests\Capability}.
         *
         * @codeCoverageIgnore
         * @param array<string, bool> $capabilities Optional. Associative array of capabilities to test against, i.e. `['<capability>' => true]`.
         * @return bool Whether the transport can be used.
         */
        public static function test($capabilities = [])
        {
        }
    }
}
namespace WpOrg\Requests\Utility {
    /**
     * Iterator for arrays requiring filtered values
     *
     * @package Requests\Utilities
     */
    final class FilteredIterator extends \ArrayIterator
    {
        /**
         * Create a new iterator
         *
         * @param array    $data     The array or object to be iterated on.
         * @param callable $callback Callback to be called on each value
         *
         * @throws \WpOrg\Requests\Exception\InvalidArgument When the passed $data argument is not iterable.
         */
        public function __construct($data, $callback)
        {
        }
        /**
         * Prevent unserialization of the object for security reasons.
         *
         * @phpcs:disable PHPCompatibility.FunctionNameRestrictions.NewMagicMethods.__unserializeFound
         *
         * @param array $data Restored array of data originally serialized.
         *
         * @return void
         */
        #[\ReturnTypeWillChange]
        public function __unserialize($data)
        {
        }
        /**
         * Perform reinitialization tasks.
         *
         * Prevents a callback from being injected during unserialization of an object.
         *
         * @return void
         */
        public function __wakeup()
        {
        }
        /**
         * Get the current item's value after filtering
         *
         * @return string
         */
        #[\ReturnTypeWillChange]
        public function current()
        {
        }
        /**
         * Prevent creating a PHP value from a stored representation of the object for security reasons.
         *
         * @param string $data The serialized string.
         *
         * @return void
         */
        #[\ReturnTypeWillChange]
        public function unserialize($data)
        {
        }
    }
    /**
     * Input validation utilities.
     *
     * @package Requests\Utilities
     */
    final class InputValidator
    {
        /**
         * Verify that a received input parameter is of type string or is "stringable".
         *
         * @param mixed $input Input parameter to verify.
         *
         * @return bool
         */
        public static function is_string_or_stringable($input)
        {
        }
        /**
         * Verify whether a received input parameter is usable as an integer array key.
         *
         * @param mixed $input Input parameter to verify.
         *
         * @return bool
         */
        public static function is_numeric_array_key($input)
        {
        }
        /**
         * Verify whether a received input parameter is "stringable".
         *
         * @param mixed $input Input parameter to verify.
         *
         * @return bool
         */
        public static function is_stringable_object($input)
        {
        }
        /**
         * Verify whether a received input parameter is _accessible as if it were an array_.
         *
         * @param mixed $input Input parameter to verify.
         *
         * @return bool
         */
        public static function has_array_access($input)
        {
        }
        /**
         * Verify whether a received input parameter is "iterable".
         *
         * @internal The PHP native `is_iterable()` function was only introduced in PHP 7.1
         * and this library still supports PHP 5.6.
         *
         * @param mixed $input Input parameter to verify.
         *
         * @return bool
         */
        public static function is_iterable($input)
        {
        }
        /**
         * Verify whether a received input parameter is a Curl handle.
         *
         * The PHP Curl extension worked with resources prior to PHP 8.0 and with
         * an instance of the `CurlHandle` class since PHP 8.0.
         * {@link https://www.php.net/manual/en/migration80.incompatible.php#migration80.incompatible.resource2object}
         *
         * @param mixed $input Input parameter to verify.
         *
         * @return bool
         */
        public static function is_curl_handle($input)
        {
        }
    }
}
namespace {
    /**
     * Autoloader class
     *
     * @package SimplePie
     * @subpackage API
     */
    class SimplePie_Autoloader
    {
        protected $path;
        /**
         * Constructor
         */
        public function __construct()
        {
        }
        /**
         * Autoloader
         *
         * @param string $class The name of the class to attempt to load.
         * @phpstan-return void
         */
        public function autoload($class)
        {
        }
    }
}
namespace SimplePie {
    /**
     * SimplePie
     *
     * @package SimplePie
     * @subpackage API
     */
    class SimplePie
    {
        /**
         * SimplePie Name
         */
        public const NAME = 'SimplePie';
        /**
         * SimplePie Version
         */
        public const VERSION = '1.8.0';
        /**
         * SimplePie Website URL
         */
        public const URL = 'http://simplepie.org';
        /**
         * SimplePie Linkback
         */
        public const LINKBACK = '<a href="' . self::URL . '" title="' . self::NAME . ' ' . self::VERSION . '">' . self::NAME . '</a>';
        /**
         * No Autodiscovery
         * @see SimplePie::set_autodiscovery_level()
         */
        public const LOCATOR_NONE = 0;
        /**
         * Feed Link Element Autodiscovery
         * @see SimplePie::set_autodiscovery_level()
         */
        public const LOCATOR_AUTODISCOVERY = 1;
        /**
         * Local Feed Extension Autodiscovery
         * @see SimplePie::set_autodiscovery_level()
         */
        public const LOCATOR_LOCAL_EXTENSION = 2;
        /**
         * Local Feed Body Autodiscovery
         * @see SimplePie::set_autodiscovery_level()
         */
        public const LOCATOR_LOCAL_BODY = 4;
        /**
         * Remote Feed Extension Autodiscovery
         * @see SimplePie::set_autodiscovery_level()
         */
        public const LOCATOR_REMOTE_EXTENSION = 8;
        /**
         * Remote Feed Body Autodiscovery
         * @see SimplePie::set_autodiscovery_level()
         */
        public const LOCATOR_REMOTE_BODY = 16;
        /**
         * All Feed Autodiscovery
         * @see SimplePie::set_autodiscovery_level()
         */
        public const LOCATOR_ALL = 31;
        /**
         * No known feed type
         */
        public const TYPE_NONE = 0;
        /**
         * RSS 0.90
         */
        public const TYPE_RSS_090 = 1;
        /**
         * RSS 0.91 (Netscape)
         */
        public const TYPE_RSS_091_NETSCAPE = 2;
        /**
         * RSS 0.91 (Userland)
         */
        public const TYPE_RSS_091_USERLAND = 4;
        /**
         * RSS 0.91 (both Netscape and Userland)
         */
        public const TYPE_RSS_091 = 6;
        /**
         * RSS 0.92
         */
        public const TYPE_RSS_092 = 8;
        /**
         * RSS 0.93
         */
        public const TYPE_RSS_093 = 16;
        /**
         * RSS 0.94
         */
        public const TYPE_RSS_094 = 32;
        /**
         * RSS 1.0
         */
        public const TYPE_RSS_10 = 64;
        /**
         * RSS 2.0
         */
        public const TYPE_RSS_20 = 128;
        /**
         * RDF-based RSS
         */
        public const TYPE_RSS_RDF = 65;
        /**
         * Non-RDF-based RSS (truly intended as syndication format)
         */
        public const TYPE_RSS_SYNDICATION = 190;
        /**
         * All RSS
         */
        public const TYPE_RSS_ALL = 255;
        /**
         * Atom 0.3
         */
        public const TYPE_ATOM_03 = 256;
        /**
         * Atom 1.0
         */
        public const TYPE_ATOM_10 = 512;
        /**
         * All Atom
         */
        public const TYPE_ATOM_ALL = 768;
        /**
         * All feed types
         */
        public const TYPE_ALL = 1023;
        /**
         * No construct
         */
        public const CONSTRUCT_NONE = 0;
        /**
         * Text construct
         */
        public const CONSTRUCT_TEXT = 1;
        /**
         * HTML construct
         */
        public const CONSTRUCT_HTML = 2;
        /**
         * XHTML construct
         */
        public const CONSTRUCT_XHTML = 4;
        /**
         * base64-encoded construct
         */
        public const CONSTRUCT_BASE64 = 8;
        /**
         * IRI construct
         */
        public const CONSTRUCT_IRI = 16;
        /**
         * A construct that might be HTML
         */
        public const CONSTRUCT_MAYBE_HTML = 32;
        /**
         * All constructs
         */
        public const CONSTRUCT_ALL = 63;
        /**
         * Don't change case
         */
        public const SAME_CASE = 1;
        /**
         * Change to lowercase
         */
        public const LOWERCASE = 2;
        /**
         * Change to uppercase
         */
        public const UPPERCASE = 4;
        /**
         * PCRE for HTML attributes
         */
        public const PCRE_HTML_ATTRIBUTE = '((?:[\x09\x0A\x0B\x0C\x0D\x20]+[^\x09\x0A\x0B\x0C\x0D\x20\x2F\x3E][^\x09\x0A\x0B\x0C\x0D\x20\x2F\x3D\x3E]*(?:[\x09\x0A\x0B\x0C\x0D\x20]*=[\x09\x0A\x0B\x0C\x0D\x20]*(?:"(?:[^"]*)"|\'(?:[^\']*)\'|(?:[^\x09\x0A\x0B\x0C\x0D\x20\x22\x27\x3E][^\x09\x0A\x0B\x0C\x0D\x20\x3E]*)?))?)*)[\x09\x0A\x0B\x0C\x0D\x20]*';
        /**
         * PCRE for XML attributes
         */
        public const PCRE_XML_ATTRIBUTE = '((?:\s+(?:(?:[^\s:]+:)?[^\s:]+)\s*=\s*(?:"(?:[^"]*)"|\'(?:[^\']*)\'))*)\s*';
        /**
         * XML Namespace
         */
        public const NAMESPACE_XML = 'http://www.w3.org/XML/1998/namespace';
        /**
         * Atom 1.0 Namespace
         */
        public const NAMESPACE_ATOM_10 = 'http://www.w3.org/2005/Atom';
        /**
         * Atom 0.3 Namespace
         */
        public const NAMESPACE_ATOM_03 = 'http://purl.org/atom/ns#';
        /**
         * RDF Namespace
         */
        public const NAMESPACE_RDF = 'http://www.w3.org/1999/02/22-rdf-syntax-ns#';
        /**
         * RSS 0.90 Namespace
         */
        public const NAMESPACE_RSS_090 = 'http://my.netscape.com/rdf/simple/0.9/';
        /**
         * RSS 1.0 Namespace
         */
        public const NAMESPACE_RSS_10 = 'http://purl.org/rss/1.0/';
        /**
         * RSS 1.0 Content Module Namespace
         */
        public const NAMESPACE_RSS_10_MODULES_CONTENT = 'http://purl.org/rss/1.0/modules/content/';
        /**
         * RSS 2.0 Namespace
         * (Stupid, I know, but I'm certain it will confuse people less with support.)
         */
        public const NAMESPACE_RSS_20 = '';
        /**
         * DC 1.0 Namespace
         */
        public const NAMESPACE_DC_10 = 'http://purl.org/dc/elements/1.0/';
        /**
         * DC 1.1 Namespace
         */
        public const NAMESPACE_DC_11 = 'http://purl.org/dc/elements/1.1/';
        /**
         * W3C Basic Geo (WGS84 lat/long) Vocabulary Namespace
         */
        public const NAMESPACE_W3C_BASIC_GEO = 'http://www.w3.org/2003/01/geo/wgs84_pos#';
        /**
         * GeoRSS Namespace
         */
        public const NAMESPACE_GEORSS = 'http://www.georss.org/georss';
        /**
         * Media RSS Namespace
         */
        public const NAMESPACE_MEDIARSS = 'http://search.yahoo.com/mrss/';
        /**
         * Wrong Media RSS Namespace. Caused by a long-standing typo in the spec.
         */
        public const NAMESPACE_MEDIARSS_WRONG = 'http://search.yahoo.com/mrss';
        /**
         * Wrong Media RSS Namespace #2. New namespace introduced in Media RSS 1.5.
         */
        public const NAMESPACE_MEDIARSS_WRONG2 = 'http://video.search.yahoo.com/mrss';
        /**
         * Wrong Media RSS Namespace #3. A possible typo of the Media RSS 1.5 namespace.
         */
        public const NAMESPACE_MEDIARSS_WRONG3 = 'http://video.search.yahoo.com/mrss/';
        /**
         * Wrong Media RSS Namespace #4. New spec location after the RSS Advisory Board takes it over, but not a valid namespace.
         */
        public const NAMESPACE_MEDIARSS_WRONG4 = 'http://www.rssboard.org/media-rss';
        /**
         * Wrong Media RSS Namespace #5. A possible typo of the RSS Advisory Board URL.
         */
        public const NAMESPACE_MEDIARSS_WRONG5 = 'http://www.rssboard.org/media-rss/';
        /**
         * iTunes RSS Namespace
         */
        public const NAMESPACE_ITUNES = 'http://www.itunes.com/dtds/podcast-1.0.dtd';
        /**
         * XHTML Namespace
         */
        public const NAMESPACE_XHTML = 'http://www.w3.org/1999/xhtml';
        /**
         * IANA Link Relations Registry
         */
        public const IANA_LINK_RELATIONS_REGISTRY = 'http://www.iana.org/assignments/relation/';
        /**
         * No file source
         */
        public const FILE_SOURCE_NONE = 0;
        /**
         * Remote file source
         */
        public const FILE_SOURCE_REMOTE = 1;
        /**
         * Local file source
         */
        public const FILE_SOURCE_LOCAL = 2;
        /**
         * fsockopen() file source
         */
        public const FILE_SOURCE_FSOCKOPEN = 4;
        /**
         * cURL file source
         */
        public const FILE_SOURCE_CURL = 8;
        /**
         * file_get_contents() file source
         */
        public const FILE_SOURCE_FILE_GET_CONTENTS = 16;
        /**
         * @var array Raw data
         * @access private
         */
        public $data = [];
        /**
         * @var mixed Error string
         * @access private
         */
        public $error;
        /**
         * @var int HTTP status code
         * @see SimplePie::status_code()
         * @access private
         */
        public $status_code = 0;
        /**
         * @var object Instance of \SimplePie\Sanitize (or other class)
         * @see SimplePie::set_sanitize_class()
         * @access private
         */
        public $sanitize;
        /**
         * @var string SimplePie Useragent
         * @see SimplePie::set_useragent()
         * @access private
         */
        public $useragent = '';
        /**
         * @var string Feed URL
         * @see SimplePie::set_feed_url()
         * @access private
         */
        public $feed_url;
        /**
         * @var string Original feed URL, or new feed URL iff HTTP 301 Moved Permanently
         * @see SimplePie::subscribe_url()
         * @access private
         */
        public $permanent_url = null;
        /**
         * @var object Instance of \SimplePie\File to use as a feed
         * @see SimplePie::set_file()
         * @access private
         */
        public $file;
        /**
         * @var string Raw feed data
         * @see SimplePie::set_raw_data()
         * @access private
         */
        public $raw_data;
        /**
         * @var int Timeout for fetching remote files
         * @see SimplePie::set_timeout()
         * @access private
         */
        public $timeout = 10;
        /**
         * @var array Custom curl options
         * @see SimplePie::set_curl_options()
         * @access private
         */
        public $curl_options = [];
        /**
         * @var bool Forces fsockopen() to be used for remote files instead
         * of cURL, even if a new enough version is installed
         * @see SimplePie::force_fsockopen()
         * @access private
         */
        public $force_fsockopen = false;
        /**
         * @var bool Force the given data/URL to be treated as a feed no matter what
         * it appears like
         * @see SimplePie::force_feed()
         * @access private
         */
        public $force_feed = false;
        /**
         * @var bool Force SimplePie to fallback to expired cache, if enabled,
         * when feed is unavailable.
         * @see SimplePie::force_cache_fallback()
         * @access private
         */
        public $force_cache_fallback = false;
        /**
         * @var int Cache duration (in seconds)
         * @see SimplePie::set_cache_duration()
         * @access private
         */
        public $cache_duration = 3600;
        /**
         * @var int Auto-discovery cache duration (in seconds)
         * @see SimplePie::set_autodiscovery_cache_duration()
         * @access private
         */
        public $autodiscovery_cache_duration = 604800;
        /**
         * @var string Cache location (relative to executing script)
         * @see SimplePie::set_cache_location()
         * @access private
         */
        public $cache_location = './cache';
        /**
         * @var string Function that creates the cache filename
         * @see SimplePie::set_cache_name_function()
         * @access private
         */
        public $cache_name_function = 'md5';
        /**
         * @var bool Reorder feed by date descending
         * @see SimplePie::enable_order_by_date()
         * @access private
         */
        public $order_by_date = true;
        /**
         * @var mixed Force input encoding to be set to the follow value
         * (false, or anything type-cast to false, disables this feature)
         * @see SimplePie::set_input_encoding()
         * @access private
         */
        public $input_encoding = false;
        /**
         * @var int Feed Autodiscovery Level
         * @see SimplePie::set_autodiscovery_level()
         * @access private
         */
        public $autodiscovery = self::LOCATOR_ALL;
        /**
         * Class registry object
         *
         * @var \SimplePie\Registry
         */
        public $registry;
        /**
         * @var int Maximum number of feeds to check with autodiscovery
         * @see SimplePie::set_max_checked_feeds()
         * @access private
         */
        public $max_checked_feeds = 10;
        /**
         * @var array All the feeds found during the autodiscovery process
         * @see SimplePie::get_all_discovered_feeds()
         * @access private
         */
        public $all_discovered_feeds = [];
        /**
         * @var string Web-accessible path to the handler_image.php file.
         * @see SimplePie::set_image_handler()
         * @access private
         */
        public $image_handler = '';
        /**
         * @var array Stores the URLs when multiple feeds are being initialized.
         * @see SimplePie::set_feed_url()
         * @access private
         */
        public $multifeed_url = [];
        /**
         * @var array Stores SimplePie objects when multiple feeds initialized.
         * @access private
         */
        public $multifeed_objects = [];
        /**
         * @var array Stores the get_object_vars() array for use with multifeeds.
         * @see SimplePie::set_feed_url()
         * @access private
         */
        public $config_settings = null;
        /**
         * @var integer Stores the number of items to return per-feed with multifeeds.
         * @see SimplePie::set_item_limit()
         * @access private
         */
        public $item_limit = 0;
        /**
         * @var bool Stores if last-modified and/or etag headers were sent with the
         * request when checking a feed.
         */
        public $check_modified = false;
        /**
         * @var array Stores the default attributes to be stripped by strip_attributes().
         * @see SimplePie::strip_attributes()
         * @access private
         */
        public $strip_attributes = ['bgsound', 'class', 'expr', 'id', 'style', 'onclick', 'onerror', 'onfinish', 'onmouseover', 'onmouseout', 'onfocus', 'onblur', 'lowsrc', 'dynsrc'];
        /**
         * @var array Stores the default attributes to add to different tags by add_attributes().
         * @see SimplePie::add_attributes()
         * @access private
         */
        public $add_attributes = ['audio' => ['preload' => 'none'], 'iframe' => ['sandbox' => 'allow-scripts allow-same-origin'], 'video' => ['preload' => 'none']];
        /**
         * @var array Stores the default tags to be stripped by strip_htmltags().
         * @see SimplePie::strip_htmltags()
         * @access private
         */
        public $strip_htmltags = ['base', 'blink', 'body', 'doctype', 'embed', 'font', 'form', 'frame', 'frameset', 'html', 'iframe', 'input', 'marquee', 'meta', 'noscript', 'object', 'param', 'script', 'style'];
        /**
         * @var array Stores the default attributes to be renamed by rename_attributes().
         * @see SimplePie::rename_attributes()
         * @access private
         */
        public $rename_attributes = [];
        /**
         * @var bool Should we throw exceptions, or use the old-style error property?
         * @access private
         */
        public $enable_exceptions = false;
        /**
         * The SimplePie class contains feed level data and options
         *
         * To use SimplePie, create the SimplePie object with no parameters. You can
         * then set configuration options using the provided methods. After setting
         * them, you must initialise the feed using $feed->init(). At that point the
         * object's methods and properties will be available to you.
         *
         * Previously, it was possible to pass in the feed URL along with cache
         * options directly into the constructor. This has been removed as of 1.3 as
         * it caused a lot of confusion.
         *
         * @since 1.0 Preview Release
         */
        public function __construct()
        {
        }
        /**
         * Used for converting object to a string
         */
        public function __toString()
        {
        }
        /**
         * Remove items that link back to this before destroying this object
         */
        public function __destruct()
        {
        }
        /**
         * Force the given data/URL to be treated as a feed
         *
         * This tells SimplePie to ignore the content-type provided by the server.
         * Be careful when using this option, as it will also disable autodiscovery.
         *
         * @since 1.1
         * @param bool $enable Force the given data/URL to be treated as a feed
         */
        public function force_feed($enable = false)
        {
        }
        /**
         * Set the URL of the feed you want to parse
         *
         * This allows you to enter the URL of the feed you want to parse, or the
         * website you want to try to use auto-discovery on. This takes priority
         * over any set raw data.
         *
         * You can set multiple feeds to mash together by passing an array instead
         * of a string for the $url. Remember that with each additional feed comes
         * additional processing and resources.
         *
         * @since 1.0 Preview Release
         * @see set_raw_data()
         * @param string|array $url This is the URL (or array of URLs) that you want to parse.
         */
        public function set_feed_url($url)
        {
        }
        /**
         * Set an instance of {@see \SimplePie\File} to use as a feed
         *
         * @param \SimplePie\File &$file
         * @return bool True on success, false on failure
         */
        public function set_file(&$file)
        {
        }
        /**
         * Set the raw XML data to parse
         *
         * Allows you to use a string of RSS/Atom data instead of a remote feed.
         *
         * If you have a feed available as a string in PHP, you can tell SimplePie
         * to parse that data string instead of a remote feed. Any set feed URL
         * takes precedence.
         *
         * @since 1.0 Beta 3
         * @param string $data RSS or Atom data as a string.
         * @see set_feed_url()
         */
        public function set_raw_data($data)
        {
        }
        /**
         * Set the default timeout for fetching remote feeds
         *
         * This allows you to change the maximum time the feed's server to respond
         * and send the feed back.
         *
         * @since 1.0 Beta 3
         * @param int $timeout The maximum number of seconds to spend waiting to retrieve a feed.
         */
        public function set_timeout($timeout = 10)
        {
        }
        /**
         * Set custom curl options
         *
         * This allows you to change default curl options
         *
         * @since 1.0 Beta 3
         * @param array $curl_options Curl options to add to default settings
         */
        public function set_curl_options(array $curl_options = [])
        {
        }
        /**
         * Force SimplePie to use fsockopen() instead of cURL
         *
         * @since 1.0 Beta 3
         * @param bool $enable Force fsockopen() to be used
         */
        public function force_fsockopen($enable = false)
        {
        }
        /**
         * Enable/disable caching in SimplePie.
         *
         * This option allows you to disable caching all-together in SimplePie.
         * However, disabling the cache can lead to longer load times.
         *
         * @since 1.0 Preview Release
         * @param bool $enable Enable caching
         */
        public function enable_cache($enable = true)
        {
        }
        /**
         * Set a PSR-16 implementation as cache
         *
         * @param CacheInterface $psr16cache The PSR-16 cache implementation
         *
         * @return void
         */
        public function set_cache(\Psr\SimpleCache\CacheInterface $cache)
        {
        }
        /**
         * SimplePie to continue to fall back to expired cache, if enabled, when
         * feed is unavailable.
         *
         * This tells SimplePie to ignore any file errors and fall back to cache
         * instead. This only works if caching is enabled and cached content
         * still exists.
         *
         * @deprecated since SimplePie 1.8.0, expired cache will not be used anymore.
         *
         * @param bool $enable Force use of cache on fail.
         */
        public function force_cache_fallback($enable = false)
        {
        }
        /**
         * Set the length of time (in seconds) that the contents of a feed will be
         * cached
         *
         * @param int $seconds The feed content cache duration
         */
        public function set_cache_duration($seconds = 3600)
        {
        }
        /**
         * Set the length of time (in seconds) that the autodiscovered feed URL will
         * be cached
         *
         * @param int $seconds The autodiscovered feed URL cache duration.
         */
        public function set_autodiscovery_cache_duration($seconds = 604800)
        {
        }
        /**
         * Set the file system location where the cached files should be stored
         *
         * @deprecated since SimplePie 1.8.0, use \SimplePie\SimplePie::set_cache() instead.
         *
         * @param string $location The file system location.
         */
        public function set_cache_location($location = './cache')
        {
        }
        /**
         * Return the filename (i.e. hash, without path and without extension) of the file to cache a given URL.
         *
         * @param string $url The URL of the feed to be cached.
         * @return string A filename (i.e. hash, without path and without extension).
         */
        public function get_cache_filename($url)
        {
        }
        /**
         * Set whether feed items should be sorted into reverse chronological order
         *
         * @param bool $enable Sort as reverse chronological order.
         */
        public function enable_order_by_date($enable = true)
        {
        }
        /**
         * Set the character encoding used to parse the feed
         *
         * This overrides the encoding reported by the feed, however it will fall
         * back to the normal encoding detection if the override fails
         *
         * @param string $encoding Character encoding
         */
        public function set_input_encoding($encoding = false)
        {
        }
        /**
         * Set how much feed autodiscovery to do
         *
         * @see \SimplePie\SimplePie::LOCATOR_NONE
         * @see \SimplePie\SimplePie::LOCATOR_AUTODISCOVERY
         * @see \SimplePie\SimplePie::LOCATOR_LOCAL_EXTENSION
         * @see \SimplePie\SimplePie::LOCATOR_LOCAL_BODY
         * @see \SimplePie\SimplePie::LOCATOR_REMOTE_EXTENSION
         * @see \SimplePie\SimplePie::LOCATOR_REMOTE_BODY
         * @see \SimplePie\SimplePie::LOCATOR_ALL
         * @param int $level Feed Autodiscovery Level (level can be a combination of the above constants, see bitwise OR operator)
         */
        public function set_autodiscovery_level($level = self::LOCATOR_ALL)
        {
        }
        /**
         * Get the class registry
         *
         * Use this to override SimplePie's default classes
         * @see \SimplePie\Registry
         *
         * @return Registry
         */
        public function &get_registry()
        {
        }
        /**
         * Set which class SimplePie uses for caching
         *
         * @deprecated since SimplePie 1.3, use {@see set_cache()} instead
         *
         * @param string $class Name of custom class
         *
         * @return boolean True on success, false otherwise
         */
        public function set_cache_class($class = \SimplePie\Cache::class)
        {
        }
        /**
         * Set which class SimplePie uses for auto-discovery
         *
         * @deprecated since SimplePie 1.3, use {@see get_registry()} instead
         *
         * @param string $class Name of custom class
         *
         * @return boolean True on success, false otherwise
         */
        public function set_locator_class($class = \SimplePie\Locator::class)
        {
        }
        /**
         * Set which class SimplePie uses for XML parsing
         *
         * @deprecated since SimplePie 1.3, use {@see get_registry()} instead
         *
         * @param string $class Name of custom class
         *
         * @return boolean True on success, false otherwise
         */
        public function set_parser_class($class = \SimplePie\Parser::class)
        {
        }
        /**
         * Set which class SimplePie uses for remote file fetching
         *
         * @deprecated since SimplePie 1.3, use {@see get_registry()} instead
         *
         * @param string $class Name of custom class
         *
         * @return boolean True on success, false otherwise
         */
        public function set_file_class($class = \SimplePie\File::class)
        {
        }
        /**
         * Set which class SimplePie uses for data sanitization
         *
         * @deprecated since SimplePie 1.3, use {@see get_registry()} instead
         *
         * @param string $class Name of custom class
         *
         * @return boolean True on success, false otherwise
         */
        public function set_sanitize_class($class = \SimplePie\Sanitize::class)
        {
        }
        /**
         * Set which class SimplePie uses for handling feed items
         *
         * @deprecated since SimplePie 1.3, use {@see get_registry()} instead
         *
         * @param string $class Name of custom class
         *
         * @return boolean True on success, false otherwise
         */
        public function set_item_class($class = \SimplePie\Item::class)
        {
        }
        /**
         * Set which class SimplePie uses for handling author data
         *
         * @deprecated since SimplePie 1.3, use {@see get_registry()} instead
         *
         * @param string $class Name of custom class
         *
         * @return boolean True on success, false otherwise
         */
        public function set_author_class($class = \SimplePie\Author::class)
        {
        }
        /**
         * Set which class SimplePie uses for handling category data
         *
         * @deprecated since SimplePie 1.3, use {@see get_registry()} instead
         *
         * @param string $class Name of custom class
         *
         * @return boolean True on success, false otherwise
         */
        public function set_category_class($class = \SimplePie\Category::class)
        {
        }
        /**
         * Set which class SimplePie uses for feed enclosures
         *
         * @deprecated since SimplePie 1.3, use {@see get_registry()} instead
         *
         * @param string $class Name of custom class
         *
         * @return boolean True on success, false otherwise
         */
        public function set_enclosure_class($class = \SimplePie\Enclosure::class)
        {
        }
        /**
         * Set which class SimplePie uses for `<media:text>` captions
         *
         * @deprecated since SimplePie 1.3, use {@see get_registry()} instead
         *
         * @param string $class Name of custom class
         *
         * @return boolean True on success, false otherwise
         */
        public function set_caption_class($class = \SimplePie\Caption::class)
        {
        }
        /**
         * Set which class SimplePie uses for `<media:copyright>`
         *
         * @deprecated since SimplePie 1.3, use {@see get_registry()} instead
         *
         * @param string $class Name of custom class
         *
         * @return boolean True on success, false otherwise
         */
        public function set_copyright_class($class = \SimplePie\Copyright::class)
        {
        }
        /**
         * Set which class SimplePie uses for `<media:credit>`
         *
         * @deprecated since SimplePie 1.3, use {@see get_registry()} instead
         *
         * @param string $class Name of custom class
         *
         * @return boolean True on success, false otherwise
         */
        public function set_credit_class($class = \SimplePie\Credit::class)
        {
        }
        /**
         * Set which class SimplePie uses for `<media:rating>`
         *
         * @deprecated since SimplePie 1.3, use {@see get_registry()} instead
         *
         * @param string $class Name of custom class
         *
         * @return boolean True on success, false otherwise
         */
        public function set_rating_class($class = \SimplePie\Rating::class)
        {
        }
        /**
         * Set which class SimplePie uses for `<media:restriction>`
         *
         * @deprecated since SimplePie 1.3, use {@see get_registry()} instead
         *
         * @param string $class Name of custom class
         *
         * @return boolean True on success, false otherwise
         */
        public function set_restriction_class($class = \SimplePie\Restriction::class)
        {
        }
        /**
         * Set which class SimplePie uses for content-type sniffing
         *
         * @deprecated since SimplePie 1.3, use {@see get_registry()} instead
         *
         * @param string $class Name of custom class
         *
         * @return boolean True on success, false otherwise
         */
        public function set_content_type_sniffer_class($class = \SimplePie\Content\Type\Sniffer::class)
        {
        }
        /**
         * Set which class SimplePie uses item sources
         *
         * @deprecated since SimplePie 1.3, use {@see get_registry()} instead
         *
         * @param string $class Name of custom class
         *
         * @return boolean True on success, false otherwise
         */
        public function set_source_class($class = \SimplePie\Source::class)
        {
        }
        /**
         * Set the user agent string
         *
         * @param string $ua New user agent string.
         */
        public function set_useragent($ua = null)
        {
        }
        /**
         * Set a namefilter to modify the cache filename with
         *
         * @param NameFilter $filter
         *
         * @return void
         */
        public function set_cache_namefilter(\SimplePie\Cache\NameFilter $filter): void
        {
        }
        /**
         * Set callback function to create cache filename with
         *
         * @deprecated since SimplePie 1.8.0, use {@see set_cache_namefilter()} instead
         *
         * @param mixed $function Callback function
         */
        public function set_cache_name_function($function = 'md5')
        {
        }
        /**
         * Set options to make SP as fast as possible
         *
         * Forgoes a substantial amount of data sanitization in favor of speed. This
         * turns SimplePie into a dumb parser of feeds.
         *
         * @param bool $set Whether to set them or not
         */
        public function set_stupidly_fast($set = false)
        {
        }
        /**
         * Set maximum number of feeds to check with autodiscovery
         *
         * @param int $max Maximum number of feeds to check
         */
        public function set_max_checked_feeds($max = 10)
        {
        }
        public function remove_div($enable = true)
        {
        }
        public function strip_htmltags($tags = '', $encode = null)
        {
        }
        public function encode_instead_of_strip($enable = true)
        {
        }
        public function rename_attributes($attribs = '')
        {
        }
        public function strip_attributes($attribs = '')
        {
        }
        public function add_attributes($attribs = '')
        {
        }
        /**
         * Set the output encoding
         *
         * Allows you to override SimplePie's output to match that of your webpage.
         * This is useful for times when your webpages are not being served as
         * UTF-8. This setting will be obeyed by {@see handle_content_type()}, and
         * is similar to {@see set_input_encoding()}.
         *
         * It should be noted, however, that not all character encodings can support
         * all characters. If your page is being served as ISO-8859-1 and you try
         * to display a Japanese feed, you'll likely see garbled characters.
         * Because of this, it is highly recommended to ensure that your webpages
         * are served as UTF-8.
         *
         * The number of supported character encodings depends on whether your web
         * host supports {@link http://php.net/mbstring mbstring},
         * {@link http://php.net/iconv iconv}, or both. See
         * {@link http://simplepie.org/wiki/faq/Supported_Character_Encodings} for
         * more information.
         *
         * @param string $encoding
         */
        public function set_output_encoding($encoding = 'UTF-8')
        {
        }
        public function strip_comments($strip = false)
        {
        }
        /**
         * Set element/attribute key/value pairs of HTML attributes
         * containing URLs that need to be resolved relative to the feed
         *
         * Defaults to |a|@href, |area|@href, |blockquote|@cite, |del|@cite,
         * |form|@action, |img|@longdesc, |img|@src, |input|@src, |ins|@cite,
         * |q|@cite
         *
         * @since 1.0
         * @param array|null $element_attribute Element/attribute key/value pairs, null for default
         */
        public function set_url_replacements($element_attribute = null)
        {
        }
        /**
         * Set the list of domains for which to force HTTPS.
         * @see \SimplePie\Sanitize::set_https_domains()
         * @param array List of HTTPS domains. Example array('biz', 'example.com', 'example.org', 'www.example.net').
         */
        public function set_https_domains($domains = [])
        {
        }
        /**
         * Set the handler to enable the display of cached images.
         *
         * @param string $page Web-accessible path to the handler_image.php file.
         * @param string $qs The query string that the value should be passed to.
         */
        public function set_image_handler($page = false, $qs = 'i')
        {
        }
        /**
         * Set the limit for items returned per-feed with multifeeds
         *
         * @param integer $limit The maximum number of items to return.
         */
        public function set_item_limit($limit = 0)
        {
        }
        /**
         * Enable throwing exceptions
         *
         * @param boolean $enable Should we throw exceptions, or use the old-style error property?
         */
        public function enable_exceptions($enable = true)
        {
        }
        /**
         * Initialize the feed object
         *
         * This is what makes everything happen. Period. This is where all of the
         * configuration options get processed, feeds are fetched, cached, and
         * parsed, and all of that other good stuff.
         *
         * @return boolean True if successful, false otherwise
         */
        public function init()
        {
        }
        /**
         * Fetch the data via \SimplePie\File
         *
         * If the data is already cached, attempt to fetch it from there instead
         * @param Base|DataCache|false $cache Cache handler, or false to not load from the cache
         * @return array|true Returns true if the data was loaded from the cache, or an array of HTTP headers and sniffed type
         */
        protected function fetch_data(&$cache)
        {
        }
        /**
         * Get the error message for the occurred error
         *
         * @return string|array Error message, or array of messages for multifeeds
         */
        public function error()
        {
        }
        /**
         * Get the last HTTP status code
         *
         * @return int Status code
         */
        public function status_code()
        {
        }
        /**
         * Get the raw XML
         *
         * This is the same as the old `$feed->enable_xml_dump(true)`, but returns
         * the data instead of printing it.
         *
         * @return string|boolean Raw XML data, false if the cache is used
         */
        public function get_raw_data()
        {
        }
        /**
         * Get the character encoding used for output
         *
         * @since Preview Release
         * @return string
         */
        public function get_encoding()
        {
        }
        /**
         * Send the content-type header with correct encoding
         *
         * This method ensures that the SimplePie-enabled page is being served with
         * the correct {@link http://www.iana.org/assignments/media-types/ mime-type}
         * and character encoding HTTP headers (character encoding determined by the
         * {@see set_output_encoding} config option).
         *
         * This won't work properly if any content or whitespace has already been
         * sent to the browser, because it relies on PHP's
         * {@link http://php.net/header header()} function, and these are the
         * circumstances under which the function works.
         *
         * Because it's setting these settings for the entire page (as is the nature
         * of HTTP headers), this should only be used once per page (again, at the
         * top).
         *
         * @param string $mime MIME type to serve the page as
         */
        public function handle_content_type($mime = 'text/html')
        {
        }
        /**
         * Get the type of the feed
         *
         * This returns a \SimplePie\SimplePie::TYPE_* constant, which can be tested against
         * using {@link http://php.net/language.operators.bitwise bitwise operators}
         *
         * @since 0.8 (usage changed to using constants in 1.0)
         * @see \SimplePie\SimplePie::TYPE_NONE Unknown.
         * @see \SimplePie\SimplePie::TYPE_RSS_090 RSS 0.90.
         * @see \SimplePie\SimplePie::TYPE_RSS_091_NETSCAPE RSS 0.91 (Netscape).
         * @see \SimplePie\SimplePie::TYPE_RSS_091_USERLAND RSS 0.91 (Userland).
         * @see \SimplePie\SimplePie::TYPE_RSS_091 RSS 0.91.
         * @see \SimplePie\SimplePie::TYPE_RSS_092 RSS 0.92.
         * @see \SimplePie\SimplePie::TYPE_RSS_093 RSS 0.93.
         * @see \SimplePie\SimplePie::TYPE_RSS_094 RSS 0.94.
         * @see \SimplePie\SimplePie::TYPE_RSS_10 RSS 1.0.
         * @see \SimplePie\SimplePie::TYPE_RSS_20 RSS 2.0.x.
         * @see \SimplePie\SimplePie::TYPE_RSS_RDF RDF-based RSS.
         * @see \SimplePie\SimplePie::TYPE_RSS_SYNDICATION Non-RDF-based RSS (truly intended as syndication format).
         * @see \SimplePie\SimplePie::TYPE_RSS_ALL Any version of RSS.
         * @see \SimplePie\SimplePie::TYPE_ATOM_03 Atom 0.3.
         * @see \SimplePie\SimplePie::TYPE_ATOM_10 Atom 1.0.
         * @see \SimplePie\SimplePie::TYPE_ATOM_ALL Any version of Atom.
         * @see \SimplePie\SimplePie::TYPE_ALL Any known/supported feed type.
         * @return int \SimplePie\SimplePie::TYPE_* constant
         */
        public function get_type()
        {
        }
        /**
         * Get the URL for the feed
         *
         * When the 'permanent' mode is enabled, returns the original feed URL,
         * except in the case of an `HTTP 301 Moved Permanently` status response,
         * in which case the location of the first redirection is returned.
         *
         * When the 'permanent' mode is disabled (default),
         * may or may not be different from the URL passed to {@see set_feed_url()},
         * depending on whether auto-discovery was used, and whether there were
         * any redirects along the way.
         *
         * @since Preview Release (previously called `get_feed_url()` since SimplePie 0.8.)
         * @todo Support <itunes:new-feed-url>
         * @todo Also, |atom:link|@rel=self
         * @param bool $permanent Permanent mode to return only the original URL or the first redirection
         * iff it is a 301 redirection
         * @return string|null
         */
        public function subscribe_url($permanent = false)
        {
        }
        /**
         * Get data for an feed-level element
         *
         * This method allows you to get access to ANY element/attribute that is a
         * sub-element of the opening feed tag.
         *
         * The return value is an indexed array of elements matching the given
         * namespace and tag name. Each element has `attribs`, `data` and `child`
         * subkeys. For `attribs` and `child`, these contain namespace subkeys.
         * `attribs` then has one level of associative name => value data (where
         * `value` is a string) after the namespace. `child` has tag-indexed keys
         * after the namespace, each member of which is an indexed array matching
         * this same format.
         *
         * For example:
         * <pre>
         * // This is probably a bad example because we already support
         * // <media:content> natively, but it shows you how to parse through
         * // the nodes.
         * $group = $item->get_item_tags(\SimplePie\SimplePie::NAMESPACE_MEDIARSS, 'group');
         * $content = $group[0]['child'][\SimplePie\SimplePie::NAMESPACE_MEDIARSS]['content'];
         * $file = $content[0]['attribs']['']['url'];
         * echo $file;
         * </pre>
         *
         * @since 1.0
         * @see http://simplepie.org/wiki/faq/supported_xml_namespaces
         * @param string $namespace The URL of the XML namespace of the elements you're trying to access
         * @param string $tag Tag name
         * @return array
         */
        public function get_feed_tags($namespace, $tag)
        {
        }
        /**
         * Get data for an channel-level element
         *
         * This method allows you to get access to ANY element/attribute in the
         * channel/header section of the feed.
         *
         * See {@see SimplePie::get_feed_tags()} for a description of the return value
         *
         * @since 1.0
         * @see http://simplepie.org/wiki/faq/supported_xml_namespaces
         * @param string $namespace The URL of the XML namespace of the elements you're trying to access
         * @param string $tag Tag name
         * @return array
         */
        public function get_channel_tags($namespace, $tag)
        {
        }
        /**
         * Get data for an channel-level element
         *
         * This method allows you to get access to ANY element/attribute in the
         * image/logo section of the feed.
         *
         * See {@see SimplePie::get_feed_tags()} for a description of the return value
         *
         * @since 1.0
         * @see http://simplepie.org/wiki/faq/supported_xml_namespaces
         * @param string $namespace The URL of the XML namespace of the elements you're trying to access
         * @param string $tag Tag name
         * @return array
         */
        public function get_image_tags($namespace, $tag)
        {
        }
        /**
         * Get the base URL value from the feed
         *
         * Uses `<xml:base>` if available, otherwise uses the first link in the
         * feed, or failing that, the URL of the feed itself.
         *
         * @see get_link
         * @see subscribe_url
         *
         * @param array $element
         * @return string
         */
        public function get_base($element = [])
        {
        }
        /**
         * Sanitize feed data
         *
         * @access private
         * @see \SimplePie\Sanitize::sanitize()
         * @param string $data Data to sanitize
         * @param int $type One of the \SimplePie\SimplePie::CONSTRUCT_* constants
         * @param string $base Base URL to resolve URLs against
         * @return string Sanitized data
         */
        public function sanitize($data, $type, $base = '')
        {
        }
        /**
         * Get the title of the feed
         *
         * Uses `<atom:title>`, `<title>` or `<dc:title>`
         *
         * @since 1.0 (previously called `get_feed_title` since 0.8)
         * @return string|null
         */
        public function get_title()
        {
        }
        /**
         * Get a category for the feed
         *
         * @since Unknown
         * @param int $key The category that you want to return. Remember that arrays begin with 0, not 1
         * @return \SimplePie\Category|null
         */
        public function get_category($key = 0)
        {
        }
        /**
         * Get all categories for the feed
         *
         * Uses `<atom:category>`, `<category>` or `<dc:subject>`
         *
         * @since Unknown
         * @return array|null List of {@see \SimplePie\Category} objects
         */
        public function get_categories()
        {
        }
        /**
         * Get an author for the feed
         *
         * @since 1.1
         * @param int $key The author that you want to return. Remember that arrays begin with 0, not 1
         * @return \SimplePie\Author|null
         */
        public function get_author($key = 0)
        {
        }
        /**
         * Get all authors for the feed
         *
         * Uses `<atom:author>`, `<author>`, `<dc:creator>` or `<itunes:author>`
         *
         * @since 1.1
         * @return array|null List of {@see \SimplePie\Author} objects
         */
        public function get_authors()
        {
        }
        /**
         * Get a contributor for the feed
         *
         * @since 1.1
         * @param int $key The contrbutor that you want to return. Remember that arrays begin with 0, not 1
         * @return \SimplePie\Author|null
         */
        public function get_contributor($key = 0)
        {
        }
        /**
         * Get all contributors for the feed
         *
         * Uses `<atom:contributor>`
         *
         * @since 1.1
         * @return array|null List of {@see \SimplePie\Author} objects
         */
        public function get_contributors()
        {
        }
        /**
         * Get a single link for the feed
         *
         * @since 1.0 (previously called `get_feed_link` since Preview Release, `get_feed_permalink()` since 0.8)
         * @param int $key The link that you want to return. Remember that arrays begin with 0, not 1
         * @param string $rel The relationship of the link to return
         * @return string|null Link URL
         */
        public function get_link($key = 0, $rel = 'alternate')
        {
        }
        /**
         * Get the permalink for the item
         *
         * Returns the first link available with a relationship of "alternate".
         * Identical to {@see get_link()} with key 0
         *
         * @see get_link
         * @since 1.0 (previously called `get_feed_link` since Preview Release, `get_feed_permalink()` since 0.8)
         * @internal Added for parity between the parent-level and the item/entry-level.
         * @return string|null Link URL
         */
        public function get_permalink()
        {
        }
        /**
         * Get all links for the feed
         *
         * Uses `<atom:link>` or `<link>`
         *
         * @since Beta 2
         * @param string $rel The relationship of links to return
         * @return array|null Links found for the feed (strings)
         */
        public function get_links($rel = 'alternate')
        {
        }
        public function get_all_discovered_feeds()
        {
        }
        /**
         * Get the content for the item
         *
         * Uses `<atom:subtitle>`, `<atom:tagline>`, `<description>`,
         * `<dc:description>`, `<itunes:summary>` or `<itunes:subtitle>`
         *
         * @since 1.0 (previously called `get_feed_description()` since 0.8)
         * @return string|null
         */
        public function get_description()
        {
        }
        /**
         * Get the copyright info for the feed
         *
         * Uses `<atom:rights>`, `<atom:copyright>` or `<dc:rights>`
         *
         * @since 1.0 (previously called `get_feed_copyright()` since 0.8)
         * @return string|null
         */
        public function get_copyright()
        {
        }
        /**
         * Get the language for the feed
         *
         * Uses `<language>`, `<dc:language>`, or @xml_lang
         *
         * @since 1.0 (previously called `get_feed_language()` since 0.8)
         * @return string|null
         */
        public function get_language()
        {
        }
        /**
         * Get the latitude coordinates for the item
         *
         * Compatible with the W3C WGS84 Basic Geo and GeoRSS specifications
         *
         * Uses `<geo:lat>` or `<georss:point>`
         *
         * @since 1.0
         * @link http://www.w3.org/2003/01/geo/ W3C WGS84 Basic Geo
         * @link http://www.georss.org/ GeoRSS
         * @return string|null
         */
        public function get_latitude()
        {
        }
        /**
         * Get the longitude coordinates for the feed
         *
         * Compatible with the W3C WGS84 Basic Geo and GeoRSS specifications
         *
         * Uses `<geo:long>`, `<geo:lon>` or `<georss:point>`
         *
         * @since 1.0
         * @link http://www.w3.org/2003/01/geo/ W3C WGS84 Basic Geo
         * @link http://www.georss.org/ GeoRSS
         * @return string|null
         */
        public function get_longitude()
        {
        }
        /**
         * Get the feed logo's title
         *
         * RSS 0.9.0, 1.0 and 2.0 feeds are allowed to have a "feed logo" title.
         *
         * Uses `<image><title>` or `<image><dc:title>`
         *
         * @return string|null
         */
        public function get_image_title()
        {
        }
        /**
         * Get the feed logo's URL
         *
         * RSS 0.9.0, 2.0, Atom 1.0, and feeds with iTunes RSS tags are allowed to
         * have a "feed logo" URL. This points directly to the image itself.
         *
         * Uses `<itunes:image>`, `<atom:logo>`, `<atom:icon>`,
         * `<image><title>` or `<image><dc:title>`
         *
         * @return string|null
         */
        public function get_image_url()
        {
        }
        /**
         * Get the feed logo's link
         *
         * RSS 0.9.0, 1.0 and 2.0 feeds are allowed to have a "feed logo" link. This
         * points to a human-readable page that the image should link to.
         *
         * Uses `<itunes:image>`, `<atom:logo>`, `<atom:icon>`,
         * `<image><title>` or `<image><dc:title>`
         *
         * @return string|null
         */
        public function get_image_link()
        {
        }
        /**
         * Get the feed logo's link
         *
         * RSS 2.0 feeds are allowed to have a "feed logo" width.
         *
         * Uses `<image><width>` or defaults to 88 if no width is specified and
         * the feed is an RSS 2.0 feed.
         *
         * @return int|null
         */
        public function get_image_width()
        {
        }
        /**
         * Get the feed logo's height
         *
         * RSS 2.0 feeds are allowed to have a "feed logo" height.
         *
         * Uses `<image><height>` or defaults to 31 if no height is specified and
         * the feed is an RSS 2.0 feed.
         *
         * @return int|null
         */
        public function get_image_height()
        {
        }
        /**
         * Get the number of items in the feed
         *
         * This is well-suited for {@link http://php.net/for for()} loops with
         * {@see get_item()}
         *
         * @param int $max Maximum value to return. 0 for no limit
         * @return int Number of items in the feed
         */
        public function get_item_quantity($max = 0)
        {
        }
        /**
         * Get a single item from the feed
         *
         * This is better suited for {@link http://php.net/for for()} loops, whereas
         * {@see get_items()} is better suited for
         * {@link http://php.net/foreach foreach()} loops.
         *
         * @see get_item_quantity()
         * @since Beta 2
         * @param int $key The item that you want to return. Remember that arrays begin with 0, not 1
         * @return \SimplePie\Item|null
         */
        public function get_item($key = 0)
        {
        }
        /**
         * Get all items from the feed
         *
         * This is better suited for {@link http://php.net/for for()} loops, whereas
         * {@see get_items()} is better suited for
         * {@link http://php.net/foreach foreach()} loops.
         *
         * @see get_item_quantity
         * @since Beta 2
         * @param int $start Index to start at
         * @param int $end Number of items to return. 0 for all items after `$start`
         * @return \SimplePie\Item[]|null List of {@see \SimplePie\Item} objects
         */
        public function get_items($start = 0, $end = 0)
        {
        }
        /**
         * Set the favicon handler
         *
         * @deprecated Use your own favicon handling instead
         */
        public function set_favicon_handler($page = false, $qs = 'i')
        {
        }
        /**
         * Get the favicon for the current feed
         *
         * @deprecated Use your own favicon handling instead
         */
        public function get_favicon()
        {
        }
        /**
         * Magic method handler
         *
         * @param string $method Method name
         * @param array $args Arguments to the method
         * @return mixed
         */
        public function __call($method, $args)
        {
        }
        /**
         * Sorting callback for items
         *
         * @access private
         * @param SimplePie $a
         * @param SimplePie $b
         * @return boolean
         */
        public static function sort_items($a, $b)
        {
        }
        /**
         * Merge items from several feeds into one
         *
         * If you're merging multiple feeds together, they need to all have dates
         * for the items or else SimplePie will refuse to sort them.
         *
         * @link http://simplepie.org/wiki/tutorial/sort_multiple_feeds_by_time_and_date#if_feeds_require_separate_per-feed_settings
         * @param array $urls List of SimplePie feed objects to merge
         * @param int $start Starting item
         * @param int $end Number of items to return
         * @param int $limit Maximum number of items per feed
         * @return array
         */
        public static function merge_items($urls, $start = 0, $end = 0, $limit = 0)
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\SimplePie" instead */
    class SimplePie extends \SimplePie\SimplePie
    {
    }
}
namespace SimplePie {
    /**
     * Manages all author-related data
     *
     * Used by {@see Item::get_author()} and {@see SimplePie::get_authors()}
     *
     * This class can be overloaded with {@see SimplePie::set_author_class()}
     *
     * @package SimplePie
     * @subpackage API
     */
    class Author
    {
        /**
         * Author's name
         *
         * @var string
         * @see get_name()
         */
        public $name;
        /**
         * Author's link
         *
         * @var string
         * @see get_link()
         */
        public $link;
        /**
         * Author's email address
         *
         * @var string
         * @see get_email()
         */
        public $email;
        /**
         * Constructor, used to input the data
         *
         * @param string $name
         * @param string $link
         * @param string $email
         */
        public function __construct($name = null, $link = null, $email = null)
        {
        }
        /**
         * String-ified version
         *
         * @return string
         */
        public function __toString()
        {
        }
        /**
         * Author's name
         *
         * @return string|null
         */
        public function get_name()
        {
        }
        /**
         * Author's link
         *
         * @return string|null
         */
        public function get_link()
        {
        }
        /**
         * Author's email address
         *
         * @return string|null
         */
        public function get_email()
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Author" instead */
    class SimplePie_Author extends \SimplePie\Author
    {
    }
}
namespace SimplePie {
    /**
     * Used to create cache objects
     *
     * This class can be overloaded with {@see SimplePie::set_cache_class()},
     * although the preferred way is to create your own handler
     * via {@see register()}
     *
     * @package SimplePie
     * @subpackage Caching
     * @deprecated since SimplePie 1.8.0, use "SimplePie\SimplePie::set_cache()" instead
     */
    class Cache
    {
        /**
         * Cache handler classes
         *
         * These receive 3 parameters to their constructor, as documented in
         * {@see register()}
         * @var array
         */
        protected static $handlers = ['mysql' => 'SimplePie\Cache\MySQL', 'memcache' => 'SimplePie\Cache\Memcache', 'memcached' => 'SimplePie\Cache\Memcached', 'redis' => 'SimplePie\Cache\Redis'];
        /**
         * Create a new SimplePie\Cache object
         *
         * @param string $location URL location (scheme is used to determine handler)
         * @param string $filename Unique identifier for cache object
         * @param Base::TYPE_FEED|Base::TYPE_IMAGE $extension 'spi' or 'spc'
         * @return Base Type of object depends on scheme of `$location`
         */
        public static function get_handler($location, $filename, $extension)
        {
        }
        /**
         * Create a new SimplePie\Cache object
         *
         * @deprecated since SimplePie 1.3.1, use {@see get_handler()} instead
         */
        public function create($location, $filename, $extension)
        {
        }
        /**
         * Register a handler
         *
         * @param string $type DSN type to register for
         * @param class-string<Base> $class Name of handler class. Must implement Base
         */
        public static function register($type, $class)
        {
        }
        /**
         * Parse a URL into an array
         *
         * @param string $url
         * @return array
         */
        public static function parse_URL($url)
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Cache" instead */
    class SimplePie_Cache extends \SimplePie\Cache
    {
    }
}
namespace SimplePie\Cache {
    /**
     * Base for cache objects
     *
     * Classes to be used with {@see \SimplePie\Cache::register()} are expected
     * to implement this interface.
     *
     * @package SimplePie
     * @subpackage Caching
     * @deprecated since SimplePie 1.8.0, use "Psr\SimpleCache\CacheInterface" instead
     */
    interface Base
    {
        /**
         * Feed cache type
         *
         * @var string
         */
        public const TYPE_FEED = 'spc';
        /**
         * Image cache type
         *
         * @var string
         */
        public const TYPE_IMAGE = 'spi';
        /**
         * Create a new cache object
         *
         * @param string $location Location string (from SimplePie::$cache_location)
         * @param string $name Unique ID for the cache
         * @param Base::TYPE_FEED|Base::TYPE_IMAGE $type Either TYPE_FEED for SimplePie data, or TYPE_IMAGE for image data
         */
        public function __construct($location, $name, $type);
        /**
         * Save data to the cache
         *
         * @param array|\SimplePie\SimplePie $data Data to store in the cache. If passed a SimplePie object, only cache the $data property
         * @return bool Successfulness
         */
        public function save($data);
        /**
         * Retrieve the data saved to the cache
         *
         * @return array Data for SimplePie::$data
         */
        public function load();
        /**
         * Retrieve the last modified time for the cache
         *
         * @return int Timestamp
         */
        public function mtime();
        /**
         * Set the last modified time to the current time
         *
         * @return bool Success status
         */
        public function touch();
        /**
         * Remove the cache
         *
         * @return bool Success status
         */
        public function unlink();
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Cache\Base" instead */
    interface SimplePie_Cache_Base extends \SimplePie\Cache\Base
    {
    }
}
namespace SimplePie\Cache {
    /**
     * Base class for database-based caches
     *
     * @package SimplePie
     * @subpackage Caching
     * @deprecated since SimplePie 1.8.0, use implementation of "Psr\SimpleCache\CacheInterface" instead
     */
    abstract class DB implements \SimplePie\Cache\Base
    {
        /**
         * Helper for database conversion
         *
         * Converts a given {@see SimplePie} object into data to be stored
         *
         * @param \SimplePie\SimplePie $data
         * @return array First item is the serialized data for storage, second item is the unique ID for this item
         */
        protected static function prepare_simplepie_object_for_cache($data)
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Cache\DB" instead */
    abstract class SimplePie_Cache_DB extends \SimplePie\Cache\DB
    {
    }
}
namespace SimplePie\Cache {
    /**
     * Caches data to the filesystem
     *
     * @package SimplePie
     * @subpackage Caching
     * @deprecated since SimplePie 1.8.0, use implementation of "Psr\SimpleCache\CacheInterface" instead
     */
    class File implements \SimplePie\Cache\Base
    {
        /**
         * Location string
         *
         * @see SimplePie::$cache_location
         * @var string
         */
        protected $location;
        /**
         * Filename
         *
         * @var string
         */
        protected $filename;
        /**
         * File extension
         *
         * @var string
         */
        protected $extension;
        /**
         * File path
         *
         * @var string
         */
        protected $name;
        /**
         * Create a new cache object
         *
         * @param string $location Location string (from SimplePie::$cache_location)
         * @param string $name Unique ID for the cache
         * @param Base::TYPE_FEED|Base::TYPE_IMAGE $type Either TYPE_FEED for SimplePie data, or TYPE_IMAGE for image data
         */
        public function __construct($location, $name, $type)
        {
        }
        /**
         * Save data to the cache
         *
         * @param array|\SimplePie\SimplePie $data Data to store in the cache. If passed a SimplePie object, only cache the $data property
         * @return bool Successfulness
         */
        public function save($data)
        {
        }
        /**
         * Retrieve the data saved to the cache
         *
         * @return array Data for SimplePie::$data
         */
        public function load()
        {
        }
        /**
         * Retrieve the last modified time for the cache
         *
         * @return int Timestamp
         */
        public function mtime()
        {
        }
        /**
         * Set the last modified time to the current time
         *
         * @return bool Success status
         */
        public function touch()
        {
        }
        /**
         * Remove the cache
         *
         * @return bool Success status
         */
        public function unlink()
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Cache\File" instead */
    class SimplePie_Cache_File extends \SimplePie\Cache\File
    {
    }
}
namespace SimplePie\Cache {
    /**
     * Caches data to memcache
     *
     * Registered for URLs with the "memcache" protocol
     *
     * For example, `memcache://localhost:11211/?timeout=3600&prefix=sp_` will
     * connect to memcache on `localhost` on port 11211. All tables will be
     * prefixed with `sp_` and data will expire after 3600 seconds
     *
     * @package SimplePie
     * @subpackage Caching
     * @uses Memcache
     * @deprecated since SimplePie 1.8.0, use implementation of "Psr\SimpleCache\CacheInterface" instead
     */
    class Memcache implements \SimplePie\Cache\Base
    {
        /**
         * Memcache instance
         *
         * @var Memcache
         */
        protected $cache;
        /**
         * Options
         *
         * @var array
         */
        protected $options;
        /**
         * Cache name
         *
         * @var string
         */
        protected $name;
        /**
         * Create a new cache object
         *
         * @param string $location Location string (from SimplePie::$cache_location)
         * @param string $name Unique ID for the cache
         * @param Base::TYPE_FEED|Base::TYPE_IMAGE $type Either TYPE_FEED for SimplePie data, or TYPE_IMAGE for image data
         */
        public function __construct($location, $name, $type)
        {
        }
        /**
         * Save data to the cache
         *
         * @param array|\SimplePie\SimplePie $data Data to store in the cache. If passed a SimplePie object, only cache the $data property
         * @return bool Successfulness
         */
        public function save($data)
        {
        }
        /**
         * Retrieve the data saved to the cache
         *
         * @return array Data for SimplePie::$data
         */
        public function load()
        {
        }
        /**
         * Retrieve the last modified time for the cache
         *
         * @return int Timestamp
         */
        public function mtime()
        {
        }
        /**
         * Set the last modified time to the current time
         *
         * @return bool Success status
         */
        public function touch()
        {
        }
        /**
         * Remove the cache
         *
         * @return bool Success status
         */
        public function unlink()
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Cache\Memcache" instead */
    class SimplePie_Cache_Memcache extends \SimplePie\Cache\Memcache
    {
    }
}
namespace SimplePie\Cache {
    /**
     * Caches data to memcached
     *
     * Registered for URLs with the "memcached" protocol
     *
     * For example, `memcached://localhost:11211/?timeout=3600&prefix=sp_` will
     * connect to memcached on `localhost` on port 11211. All tables will be
     * prefixed with `sp_` and data will expire after 3600 seconds
     *
     * @package    SimplePie
     * @subpackage Caching
     * @author     Paul L. McNeely
     * @uses       Memcached
     * @deprecated since SimplePie 1.8.0, use implementation of "Psr\SimpleCache\CacheInterface" instead
     */
    class Memcached implements \SimplePie\Cache\Base
    {
        /**
         * NativeMemcached instance
         * @var NativeMemcached
         */
        protected $cache;
        /**
         * Options
         * @var array
         */
        protected $options;
        /**
         * Cache name
         * @var string
         */
        protected $name;
        /**
         * Create a new cache object
         * @param string $location Location string (from SimplePie::$cache_location)
         * @param string $name Unique ID for the cache
         * @param Base::TYPE_FEED|Base::TYPE_IMAGE $type Either TYPE_FEED for SimplePie data, or TYPE_IMAGE for image data
         */
        public function __construct($location, $name, $type)
        {
        }
        /**
         * Save data to the cache
         * @param array|\SimplePie\SimplePie $data Data to store in the cache. If passed a SimplePie object, only cache the $data property
         * @return bool Successfulness
         */
        public function save($data)
        {
        }
        /**
         * Retrieve the data saved to the cache
         * @return array Data for SimplePie::$data
         */
        public function load()
        {
        }
        /**
         * Retrieve the last modified time for the cache
         * @return int Timestamp
         */
        public function mtime()
        {
        }
        /**
         * Set the last modified time to the current time
         * @return bool Success status
         */
        public function touch()
        {
        }
        /**
         * Remove the cache
         * @return bool Success status
         */
        public function unlink()
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Cache\Memcached" instead */
    class SimplePie_Cache_Memcached extends \SimplePie\Cache\Memcached
    {
    }
}
namespace SimplePie\Cache {
    /**
     * Caches data to a MySQL database
     *
     * Registered for URLs with the "mysql" protocol
     *
     * For example, `mysql://root:password@localhost:3306/mydb?prefix=sp_` will
     * connect to the `mydb` database on `localhost` on port 3306, with the user
     * `root` and the password `password`. All tables will be prefixed with `sp_`
     *
     * @package SimplePie
     * @subpackage Caching
     * @deprecated since SimplePie 1.8.0, use implementation of "Psr\SimpleCache\CacheInterface" instead
     */
    class MySQL extends \SimplePie\Cache\DB
    {
        /**
         * PDO instance
         *
         * @var \PDO
         */
        protected $mysql;
        /**
         * Options
         *
         * @var array
         */
        protected $options;
        /**
         * Cache ID
         *
         * @var string
         */
        protected $id;
        /**
         * Create a new cache object
         *
         * @param string $location Location string (from SimplePie::$cache_location)
         * @param string $name Unique ID for the cache
         * @param Base::TYPE_FEED|Base::TYPE_IMAGE $type Either TYPE_FEED for SimplePie data, or TYPE_IMAGE for image data
         * @phpstan-return void
         */
        public function __construct($location, $name, $type)
        {
        }
        /**
         * Save data to the cache
         *
         * @param array|\SimplePie\SimplePie $data Data to store in the cache. If passed a SimplePie object, only cache the $data property
         * @return bool Successfulness
         */
        public function save($data)
        {
        }
        /**
         * Retrieve the data saved to the cache
         *
         * @return array Data for SimplePie::$data
         */
        public function load()
        {
        }
        /**
         * Retrieve the last modified time for the cache
         *
         * @return int Timestamp
         */
        public function mtime()
        {
        }
        /**
         * Set the last modified time to the current time
         *
         * @return bool Success status
         */
        public function touch()
        {
        }
        /**
         * Remove the cache
         *
         * @return bool Success status
         */
        public function unlink()
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Cache\MySQL" instead */
    class SimplePie_Cache_MySQL extends \SimplePie\Cache\MySQL
    {
    }
}
namespace SimplePie\Cache {
    /**
     * Caches data to redis
     *
     * Registered for URLs with the "redis" protocol
     *
     * For example, `redis://localhost:6379/?timeout=3600&prefix=sp_&dbIndex=0` will
     * connect to redis on `localhost` on port 6379. All tables will be
     * prefixed with `simple_primary-` and data will expire after 3600 seconds
     *
     * @package SimplePie
     * @subpackage Caching
     * @uses Redis
     * @deprecated since SimplePie 1.8.0, use implementation of "Psr\SimpleCache\CacheInterface" instead
     */
    class Redis implements \SimplePie\Cache\Base
    {
        /**
         * Redis instance
         *
         * @var NativeRedis
         */
        protected $cache;
        /**
         * Options
         *
         * @var array
         */
        protected $options;
        /**
         * Cache name
         *
         * @var string
         */
        protected $name;
        /**
         * Create a new cache object
         *
         * @param string $location Location string (from SimplePie::$cache_location)
         * @param string $name Unique ID for the cache
         * @param Base::TYPE_FEED|Base::TYPE_IMAGE $type Either TYPE_FEED for SimplePie data, or TYPE_IMAGE for image data
         */
        public function __construct($location, $name, $options = null)
        {
        }
        /**
         * @param NativeRedis $cache
         */
        public function setRedisClient(\Redis $cache)
        {
        }
        /**
         * Save data to the cache
         *
         * @param array|\SimplePie\SimplePie $data Data to store in the cache. If passed a SimplePie object, only cache the $data property
         * @return bool Successfulness
         */
        public function save($data)
        {
        }
        /**
         * Retrieve the data saved to the cache
         *
         * @return array Data for SimplePie::$data
         */
        public function load()
        {
        }
        /**
         * Retrieve the last modified time for the cache
         *
         * @return int Timestamp
         */
        public function mtime()
        {
        }
        /**
         * Set the last modified time to the current time
         *
         * @return bool Success status
         */
        public function touch()
        {
        }
        /**
         * Remove the cache
         *
         * @return bool Success status
         */
        public function unlink()
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Cache\Redis" instead */
    class SimplePie_Cache_Redis extends \SimplePie\Cache\Redis
    {
    }
}
namespace SimplePie {
    /**
     * Handles `<media:text>` captions as defined in Media RSS.
     *
     * Used by {@see \SimplePie\Enclosure::get_caption()} and {@see \SimplePie\Enclosure::get_captions()}
     *
     * This class can be overloaded with {@see \SimplePie\SimplePie::set_caption_class()}
     *
     * @package SimplePie
     * @subpackage API
     */
    class Caption
    {
        /**
         * Content type
         *
         * @var string
         * @see get_type()
         */
        public $type;
        /**
         * Language
         *
         * @var string
         * @see get_language()
         */
        public $lang;
        /**
         * Start time
         *
         * @var string
         * @see get_starttime()
         */
        public $startTime;
        /**
         * End time
         *
         * @var string
         * @see get_endtime()
         */
        public $endTime;
        /**
         * Caption text
         *
         * @var string
         * @see get_text()
         */
        public $text;
        /**
         * Constructor, used to input the data
         *
         * For documentation on all the parameters, see the corresponding
         * properties and their accessors
         */
        public function __construct($type = null, $lang = null, $startTime = null, $endTime = null, $text = null)
        {
        }
        /**
         * String-ified version
         *
         * @return string
         */
        public function __toString()
        {
        }
        /**
         * Get the end time
         *
         * @return string|null Time in the format 'hh:mm:ss.SSS'
         */
        public function get_endtime()
        {
        }
        /**
         * Get the language
         *
         * @link http://tools.ietf.org/html/rfc3066
         * @return string|null Language code as per RFC 3066
         */
        public function get_language()
        {
        }
        /**
         * Get the start time
         *
         * @return string|null Time in the format 'hh:mm:ss.SSS'
         */
        public function get_starttime()
        {
        }
        /**
         * Get the text of the caption
         *
         * @return string|null
         */
        public function get_text()
        {
        }
        /**
         * Get the content type (not MIME type)
         *
         * @return string|null Either 'text' or 'html'
         */
        public function get_type()
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Caption" instead */
    class SimplePie_Caption extends \SimplePie\Caption
    {
    }
}
namespace SimplePie {
    /**
     * Manages all category-related data
     *
     * Used by {@see \SimplePie\Item::get_category()} and {@see \SimplePie\Item::get_categories()}
     *
     * This class can be overloaded with {@see \SimplePie\SimplePie::set_category_class()}
     *
     * @package SimplePie
     * @subpackage API
     */
    class Category
    {
        /**
         * Category identifier
         *
         * @var string|null
         * @see get_term
         */
        public $term;
        /**
         * Categorization scheme identifier
         *
         * @var string|null
         * @see get_scheme()
         */
        public $scheme;
        /**
         * Human readable label
         *
         * @var string|null
         * @see get_label()
         */
        public $label;
        /**
         * Category type
         *
         * category for <category>
         * subject for <dc:subject>
         *
         * @var string|null
         * @see get_type()
         */
        public $type;
        /**
         * Constructor, used to input the data
         *
         * @param string|null $term
         * @param string|null $scheme
         * @param string|null $label
         * @param string|null $type
         */
        public function __construct($term = null, $scheme = null, $label = null, $type = null)
        {
        }
        /**
         * String-ified version
         *
         * @return string
         */
        public function __toString()
        {
        }
        /**
         * Get the category identifier
         *
         * @return string|null
         */
        public function get_term()
        {
        }
        /**
         * Get the categorization scheme identifier
         *
         * @return string|null
         */
        public function get_scheme()
        {
        }
        /**
         * Get the human readable label
         *
         * @param bool $strict
         * @return string|null
         */
        public function get_label($strict = false)
        {
        }
        /**
         * Get the category type
         *
         * @return string|null
         */
        public function get_type()
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Category" instead */
    class SimplePie_Category extends \SimplePie\Category
    {
    }
}
namespace SimplePie\Content\Type {
    /**
     * Content-type sniffing
     *
     * Based on the rules in http://tools.ietf.org/html/draft-abarth-mime-sniff-06
     *
     * This is used since we can't always trust Content-Type headers, and is based
     * upon the HTML5 parsing rules.
     *
     *
     * This class can be overloaded with {@see \SimplePie\SimplePie::set_content_type_sniffer_class()}
     *
     * @package SimplePie
     * @subpackage HTTP
     */
    class Sniffer
    {
        /**
         * File object
         *
         * @var \SimplePie\File
         */
        public $file;
        /**
         * Create an instance of the class with the input file
         *
         * @param Sniffer $file Input file
         */
        public function __construct($file)
        {
        }
        /**
         * Get the Content-Type of the specified file
         *
         * @return string Actual Content-Type
         */
        public function get_type()
        {
        }
        /**
         * Sniff text or binary
         *
         * @return string Actual Content-Type
         */
        public function text_or_binary()
        {
        }
        /**
         * Sniff unknown
         *
         * @return string Actual Content-Type
         */
        public function unknown()
        {
        }
        /**
         * Sniff images
         *
         * @return string Actual Content-Type
         */
        public function image()
        {
        }
        /**
         * Sniff HTML
         *
         * @return string Actual Content-Type
         */
        public function feed_or_html()
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Content\Type\Sniffer" instead */
    class SimplePie_Content_Type_Sniffer extends \SimplePie\Content\Type\Sniffer
    {
    }
}
namespace SimplePie {
    /**
     * Manages `<media:copyright>` copyright tags as defined in Media RSS
     *
     * Used by {@see \SimplePie\Enclosure::get_copyright()}
     *
     * This class can be overloaded with {@see \SimplePie\SimplePie::set_copyright_class()}
     *
     * @package SimplePie
     * @subpackage API
     */
    class Copyright
    {
        /**
         * Copyright URL
         *
         * @var string
         * @see get_url()
         */
        public $url;
        /**
         * Attribution
         *
         * @var string
         * @see get_attribution()
         */
        public $label;
        /**
         * Constructor, used to input the data
         *
         * For documentation on all the parameters, see the corresponding
         * properties and their accessors
         */
        public function __construct($url = null, $label = null)
        {
        }
        /**
         * String-ified version
         *
         * @return string
         */
        public function __toString()
        {
        }
        /**
         * Get the copyright URL
         *
         * @return string|null URL to copyright information
         */
        public function get_url()
        {
        }
        /**
         * Get the attribution text
         *
         * @return string|null
         */
        public function get_attribution()
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Copyright" instead */
    class SimplePie_Copyright extends \SimplePie\Copyright
    {
    }
    /**
     * SimplePie class.
     *
     * Class for backward compatibility.
     *
     * @deprecated Use {@see SimplePie} directly
     * @package SimplePie
     * @subpackage API
     */
    class SimplePie_Core extends \SimplePie
    {
    }
}
namespace SimplePie {
    /**
     * Handles `<media:credit>` as defined in Media RSS
     *
     * Used by {@see \SimplePie\Enclosure::get_credit()} and {@see \SimplePie\Enclosure::get_credits()}
     *
     * This class can be overloaded with {@see \SimplePie\SimplePie::set_credit_class()}
     *
     * @package SimplePie
     * @subpackage API
     */
    class Credit
    {
        /**
         * Credited role
         *
         * @var string
         * @see get_role()
         */
        public $role;
        /**
         * Organizational scheme
         *
         * @var string
         * @see get_scheme()
         */
        public $scheme;
        /**
         * Credited name
         *
         * @var string
         * @see get_name()
         */
        public $name;
        /**
         * Constructor, used to input the data
         *
         * For documentation on all the parameters, see the corresponding
         * properties and their accessors
         */
        public function __construct($role = null, $scheme = null, $name = null)
        {
        }
        /**
         * String-ified version
         *
         * @return string
         */
        public function __toString()
        {
        }
        /**
         * Get the role of the person receiving credit
         *
         * @return string|null
         */
        public function get_role()
        {
        }
        /**
         * Get the organizational scheme
         *
         * @return string|null
         */
        public function get_scheme()
        {
        }
        /**
         * Get the credited person/entity's name
         *
         * @return string|null
         */
        public function get_name()
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Credit" instead */
    class SimplePie_Credit extends \SimplePie\Credit
    {
    }
    /**
     * Decode HTML Entities
     *
     * This implements HTML5 as of revision 967 (2007-06-28)
     *
     * @deprecated Use DOMDocument instead!
     * @package SimplePie
     */
    class SimplePie_Decode_HTML_Entities
    {
        /**
         * Data to be parsed
         *
         * @access private
         * @var string
         */
        public $data = '';
        /**
         * Currently consumed bytes
         *
         * @access private
         * @var string
         */
        public $consumed = '';
        /**
         * Position of the current byte being parsed
         *
         * @access private
         * @var int
         */
        public $position = 0;
        /**
         * Create an instance of the class with the input data
         *
         * @access public
         * @param string $data Input data
         */
        public function __construct($data)
        {
        }
        /**
         * Parse the input data
         *
         * @access public
         * @return string Output data
         */
        public function parse()
        {
        }
        /**
         * Consume the next byte
         *
         * @access private
         * @return mixed The next byte, or false, if there is no more data
         */
        public function consume()
        {
        }
        /**
         * Consume a range of characters
         *
         * @access private
         * @param string $chars Characters to consume
         * @return mixed A series of characters that match the range, or false
         */
        public function consume_range($chars)
        {
        }
        /**
         * Unconsume one byte
         *
         * @access private
         */
        public function unconsume()
        {
        }
        /**
         * Decode an entity
         *
         * @access private
         */
        public function entity()
        {
        }
    }
}
namespace SimplePie {
    /**
     * Handles everything related to enclosures (including Media RSS and iTunes RSS)
     *
     * Used by {@see \SimplePie\Item::get_enclosure()} and {@see \SimplePie\Item::get_enclosures()}
     *
     * This class can be overloaded with {@see \SimplePie\SimplePie::set_enclosure_class()}
     *
     * @package SimplePie
     * @subpackage API
     */
    class Enclosure
    {
        /**
         * @var string
         * @see get_bitrate()
         */
        public $bitrate;
        /**
         * @var array
         * @see get_captions()
         */
        public $captions;
        /**
         * @var array
         * @see get_categories()
         */
        public $categories;
        /**
         * @var int
         * @see get_channels()
         */
        public $channels;
        /**
         * @var \SimplePie\Copyright
         * @see get_copyright()
         */
        public $copyright;
        /**
         * @var array
         * @see get_credits()
         */
        public $credits;
        /**
         * @var string
         * @see get_description()
         */
        public $description;
        /**
         * @var int
         * @see get_duration()
         */
        public $duration;
        /**
         * @var string
         * @see get_expression()
         */
        public $expression;
        /**
         * @var string
         * @see get_framerate()
         */
        public $framerate;
        /**
         * @var string
         * @see get_handler()
         */
        public $handler;
        /**
         * @var array
         * @see get_hashes()
         */
        public $hashes;
        /**
         * @var string
         * @see get_height()
         */
        public $height;
        /**
         * @deprecated
         * @var null
         */
        public $javascript;
        /**
         * @var array
         * @see get_keywords()
         */
        public $keywords;
        /**
         * @var string
         * @see get_language()
         */
        public $lang;
        /**
         * @var string
         * @see get_length()
         */
        public $length;
        /**
         * @var string
         * @see get_link()
         */
        public $link;
        /**
         * @var string
         * @see get_medium()
         */
        public $medium;
        /**
         * @var string
         * @see get_player()
         */
        public $player;
        /**
         * @var array
         * @see get_ratings()
         */
        public $ratings;
        /**
         * @var array
         * @see get_restrictions()
         */
        public $restrictions;
        /**
         * @var string
         * @see get_sampling_rate()
         */
        public $samplingrate;
        /**
         * @var array
         * @see get_thumbnails()
         */
        public $thumbnails;
        /**
         * @var string
         * @see get_title()
         */
        public $title;
        /**
         * @var string
         * @see get_type()
         */
        public $type;
        /**
         * @var string
         * @see get_width()
         */
        public $width;
        /**
         * Constructor, used to input the data
         *
         * For documentation on all the parameters, see the corresponding
         * properties and their accessors
         *
         * @uses idna_convert If available, this will convert an IDN
         */
        public function __construct($link = null, $type = null, $length = null, $javascript = null, $bitrate = null, $captions = null, $categories = null, $channels = null, $copyright = null, $credits = null, $description = null, $duration = null, $expression = null, $framerate = null, $hashes = null, $height = null, $keywords = null, $lang = null, $medium = null, $player = null, $ratings = null, $restrictions = null, $samplingrate = null, $thumbnails = null, $title = null, $width = null)
        {
        }
        /**
         * String-ified version
         *
         * @return string
         */
        public function __toString()
        {
        }
        /**
         * Get the bitrate
         *
         * @return string|null
         */
        public function get_bitrate()
        {
        }
        /**
         * Get a single caption
         *
         * @param int $key
         * @return \SimplePie\Caption|null
         */
        public function get_caption($key = 0)
        {
        }
        /**
         * Get all captions
         *
         * @return array|null Array of {@see \SimplePie\Caption} objects
         */
        public function get_captions()
        {
        }
        /**
         * Get a single category
         *
         * @param int $key
         * @return \SimplePie\Category|null
         */
        public function get_category($key = 0)
        {
        }
        /**
         * Get all categories
         *
         * @return array|null Array of {@see \SimplePie\Category} objects
         */
        public function get_categories()
        {
        }
        /**
         * Get the number of audio channels
         *
         * @return int|null
         */
        public function get_channels()
        {
        }
        /**
         * Get the copyright information
         *
         * @return \SimplePie\Copyright|null
         */
        public function get_copyright()
        {
        }
        /**
         * Get a single credit
         *
         * @param int $key
         * @return \SimplePie\Credit|null
         */
        public function get_credit($key = 0)
        {
        }
        /**
         * Get all credits
         *
         * @return array|null Array of {@see \SimplePie\Credit} objects
         */
        public function get_credits()
        {
        }
        /**
         * Get the description of the enclosure
         *
         * @return string|null
         */
        public function get_description()
        {
        }
        /**
         * Get the duration of the enclosure
         *
         * @param bool $convert Convert seconds into hh:mm:ss
         * @return string|int|null 'hh:mm:ss' string if `$convert` was specified, otherwise integer (or null if none found)
         */
        public function get_duration($convert = false)
        {
        }
        /**
         * Get the expression
         *
         * @return string Probably one of 'sample', 'full', 'nonstop', 'clip'. Defaults to 'full'
         */
        public function get_expression()
        {
        }
        /**
         * Get the file extension
         *
         * @return string|null
         */
        public function get_extension()
        {
        }
        /**
         * Get the framerate (in frames-per-second)
         *
         * @return string|null
         */
        public function get_framerate()
        {
        }
        /**
         * Get the preferred handler
         *
         * @return string|null One of 'flash', 'fmedia', 'quicktime', 'wmedia', 'mp3'
         */
        public function get_handler()
        {
        }
        /**
         * Get a single hash
         *
         * @link http://www.rssboard.org/media-rss#media-hash
         * @param int $key
         * @return string|null Hash as per `media:hash`, prefixed with "$algo:"
         */
        public function get_hash($key = 0)
        {
        }
        /**
         * Get all credits
         *
         * @return array|null Array of strings, see {@see get_hash()}
         */
        public function get_hashes()
        {
        }
        /**
         * Get the height
         *
         * @return string|null
         */
        public function get_height()
        {
        }
        /**
         * Get the language
         *
         * @link http://tools.ietf.org/html/rfc3066
         * @return string|null Language code as per RFC 3066
         */
        public function get_language()
        {
        }
        /**
         * Get a single keyword
         *
         * @param int $key
         * @return string|null
         */
        public function get_keyword($key = 0)
        {
        }
        /**
         * Get all keywords
         *
         * @return array|null Array of strings
         */
        public function get_keywords()
        {
        }
        /**
         * Get length
         *
         * @return float Length in bytes
         */
        public function get_length()
        {
        }
        /**
         * Get the URL
         *
         * @return string|null
         */
        public function get_link()
        {
        }
        /**
         * Get the medium
         *
         * @link http://www.rssboard.org/media-rss#media-content
         * @return string|null Should be one of 'image', 'audio', 'video', 'document', 'executable'
         */
        public function get_medium()
        {
        }
        /**
         * Get the player URL
         *
         * Typically the same as {@see get_permalink()}
         * @return string|null Player URL
         */
        public function get_player()
        {
        }
        /**
         * Get a single rating
         *
         * @param int $key
         * @return \SimplePie\Rating|null
         */
        public function get_rating($key = 0)
        {
        }
        /**
         * Get all ratings
         *
         * @return array|null Array of {@see \SimplePie\Rating} objects
         */
        public function get_ratings()
        {
        }
        /**
         * Get a single restriction
         *
         * @param int $key
         * @return \SimplePie\Restriction|null
         */
        public function get_restriction($key = 0)
        {
        }
        /**
         * Get all restrictions
         *
         * @return array|null Array of {@see \SimplePie\Restriction} objects
         */
        public function get_restrictions()
        {
        }
        /**
         * Get the sampling rate (in kHz)
         *
         * @return string|null
         */
        public function get_sampling_rate()
        {
        }
        /**
         * Get the file size (in MiB)
         *
         * @return float|null File size in mebibytes (1048 bytes)
         */
        public function get_size()
        {
        }
        /**
         * Get a single thumbnail
         *
         * @param int $key
         * @return string|null Thumbnail URL
         */
        public function get_thumbnail($key = 0)
        {
        }
        /**
         * Get all thumbnails
         *
         * @return array|null Array of thumbnail URLs
         */
        public function get_thumbnails()
        {
        }
        /**
         * Get the title
         *
         * @return string|null
         */
        public function get_title()
        {
        }
        /**
         * Get mimetype of the enclosure
         *
         * @see get_real_type()
         * @return string|null MIME type
         */
        public function get_type()
        {
        }
        /**
         * Get the width
         *
         * @return string|null
         */
        public function get_width()
        {
        }
        /**
         * Embed the enclosure using `<embed>`
         *
         * @deprecated Use the second parameter to {@see embed} instead
         *
         * @param array|string $options See first parameter to {@see embed}
         * @return string HTML string to output
         */
        public function native_embed($options = '')
        {
        }
        /**
         * Embed the enclosure using Javascript
         *
         * `$options` is an array or comma-separated key:value string, with the
         * following properties:
         *
         * - `alt` (string): Alternate content for when an end-user does not have
         *    the appropriate handler installed or when a file type is
         *    unsupported. Can be any text or HTML. Defaults to blank.
         * - `altclass` (string): If a file type is unsupported, the end-user will
         *    see the alt text (above) linked directly to the content. That link
         *    will have this value as its class name. Defaults to blank.
         * - `audio` (string): This is an image that should be used as a
         *    placeholder for audio files before they're loaded (QuickTime-only).
         *    Can be any relative or absolute URL. Defaults to blank.
         * - `bgcolor` (string): The background color for the media, if not
         *    already transparent. Defaults to `#ffffff`.
         * - `height` (integer): The height of the embedded media. Accepts any
         *    numeric pixel value (such as `360`) or `auto`. Defaults to `auto`,
         *    and it is recommended that you use this default.
         * - `loop` (boolean): Do you want the media to loop when it's done?
         *    Defaults to `false`.
         * - `mediaplayer` (string): The location of the included
         *    `mediaplayer.swf` file. This allows for the playback of Flash Video
         *    (`.flv`) files, and is the default handler for non-Odeo MP3's.
         *    Defaults to blank.
         * - `video` (string): This is an image that should be used as a
         *    placeholder for video files before they're loaded (QuickTime-only).
         *    Can be any relative or absolute URL. Defaults to blank.
         * - `width` (integer): The width of the embedded media. Accepts any
         *    numeric pixel value (such as `480`) or `auto`. Defaults to `auto`,
         *    and it is recommended that you use this default.
         * - `widescreen` (boolean): Is the enclosure widescreen or standard?
         *    This applies only to video enclosures, and will automatically resize
         *    the content appropriately.  Defaults to `false`, implying 4:3 mode.
         *
         * Note: Non-widescreen (4:3) mode with `width` and `height` set to `auto`
         * will default to 480x360 video resolution.  Widescreen (16:9) mode with
         * `width` and `height` set to `auto` will default to 480x270 video resolution.
         *
         * @todo If the dimensions for media:content are defined, use them when width/height are set to 'auto'.
         * @param array|string $options Comma-separated key:value list, or array
         * @param bool $native Use `<embed>`
         * @return string HTML string to output
         */
        public function embed($options = '', $native = false)
        {
        }
        /**
         * Get the real media type
         *
         * Often, feeds lie to us, necessitating a bit of deeper inspection. This
         * converts types to their canonical representations based on the file
         * extension
         *
         * @see get_type()
         * @param bool $find_handler Internal use only, use {@see get_handler()} instead
         * @return string MIME type
         */
        public function get_real_type($find_handler = false)
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Enclosure" instead */
    class SimplePie_Enclosure extends \SimplePie\Enclosure
    {
    }
}
namespace SimplePie {
    /**
     * General SimplePie exception class
     *
     * @package SimplePie
     */
    class Exception extends \Exception
    {
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Exception" instead */
    class SimplePie_Exception extends \SimplePie\Exception
    {
    }
}
namespace SimplePie {
    /**
     * Used for fetching remote files and reading local files
     *
     * Supports HTTP 1.0 via cURL or fsockopen, with spotty HTTP 1.1 support
     *
     * This class can be overloaded with {@see \SimplePie\SimplePie::set_file_class()}
     *
     * @package SimplePie
     * @subpackage HTTP
     * @todo Move to properly supporting RFC2616 (HTTP/1.1)
     */
    class File
    {
        public $url;
        public $useragent;
        public $success = true;
        public $headers = [];
        public $body;
        public $status_code = 0;
        public $redirects = 0;
        public $error;
        public $method = \SimplePie\SimplePie::FILE_SOURCE_NONE;
        public $permanent_url;
        public function __construct($url, $timeout = 10, $redirects = 5, $headers = null, $useragent = null, $force_fsockopen = false, $curl_options = [])
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\File" instead */
    class SimplePie_File extends \SimplePie\File
    {
    }
}
namespace SimplePie\HTTP {
    /**
     * HTTP Response Parser
     *
     * @package SimplePie
     * @subpackage HTTP
     */
    class Parser
    {
        /**
         * HTTP Version
         *
         * @var float
         */
        public $http_version = 0.0;
        /**
         * Status code
         *
         * @var int
         */
        public $status_code = 0;
        /**
         * Reason phrase
         *
         * @var string
         */
        public $reason = '';
        /**
         * Key/value pairs of the headers
         *
         * @var array
         */
        public $headers = [];
        /**
         * Body of the response
         *
         * @var string
         */
        public $body = '';
        /**
         * Current state of the state machine
         *
         * @var self::STATE_*
         */
        protected $state = self::STATE_HTTP_VERSION;
        /**
         * Input data
         *
         * @var string
         */
        protected $data = '';
        /**
         * Input data length (to avoid calling strlen() everytime this is needed)
         *
         * @var int
         */
        protected $data_length = 0;
        /**
         * Current position of the pointer
         *
         * @var int
         */
        protected $position = 0;
        /**
         * Name of the hedaer currently being parsed
         *
         * @var string
         */
        protected $name = '';
        /**
         * Value of the hedaer currently being parsed
         *
         * @var string
         */
        protected $value = '';
        /**
         * Create an instance of the class with the input data
         *
         * @param string $data Input data
         */
        public function __construct($data)
        {
        }
        /**
         * Parse the input data
         *
         * @return bool true on success, false on failure
         */
        public function parse()
        {
        }
        /**
         * Check whether there is data beyond the pointer
         *
         * @return bool true if there is further data, false if not
         */
        protected function has_data()
        {
        }
        /**
         * See if the next character is LWS
         *
         * @return bool true if the next character is LWS, false if not
         */
        protected function is_linear_whitespace()
        {
        }
        /**
         * Parse the HTTP version
         */
        protected function http_version()
        {
        }
        /**
         * Parse the status code
         */
        protected function status()
        {
        }
        /**
         * Parse the reason phrase
         */
        protected function reason()
        {
        }
        /**
         * Deal with a new line, shifting data around as needed
         */
        protected function new_line()
        {
        }
        /**
         * Parse a header name
         */
        protected function name()
        {
        }
        /**
         * Parse LWS, replacing consecutive LWS characters with a single space
         */
        protected function linear_whitespace()
        {
        }
        /**
         * See what state to move to while within non-quoted header values
         */
        protected function value()
        {
        }
        /**
         * Parse a header value while outside quotes
         */
        protected function value_char()
        {
        }
        /**
         * See what state to move to while within quoted header values
         */
        protected function quote()
        {
        }
        /**
         * Parse a header value while within quotes
         */
        protected function quote_char()
        {
        }
        /**
         * Parse an escaped character within quotes
         */
        protected function quote_escaped()
        {
        }
        /**
         * Parse the body
         */
        protected function body()
        {
        }
        /**
         * Parsed a "Transfer-Encoding: chunked" body
         * @phpstan-return void
         */
        protected function chunked()
        {
        }
        /**
         * Prepare headers (take care of proxies headers)
         *
         * @param string  $headers Raw headers
         * @param integer $count   Redirection count. Default to 1.
         *
         * @return string
         */
        public static function prepareHeaders($headers, $count = 1)
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\HTTP\Parser" instead */
    class SimplePie_HTTP_Parser extends \SimplePie\HTTP\Parser
    {
    }
}
namespace SimplePie {
    /**
     * IRI parser/serialiser/normaliser
     *
     * @package SimplePie
     * @subpackage HTTP
     * @author Sam Sneddon
     * @author Steve Minutillo
     * @author Ryan McCue
     * @copyright 2007-2012 Sam Sneddon, Steve Minutillo, Ryan McCue
     * @license http://www.opensource.org/licenses/bsd-license.php
     */
    class IRI
    {
        /**
         * Scheme
         *
         * @var string
         */
        protected $scheme = null;
        /**
         * User Information
         *
         * @var string
         */
        protected $iuserinfo = null;
        /**
         * ihost
         *
         * @var string
         */
        protected $ihost = null;
        /**
         * Port
         *
         * @var string
         */
        protected $port = null;
        /**
         * ipath
         *
         * @var string
         */
        protected $ipath = '';
        /**
         * iquery
         *
         * @var string
         */
        protected $iquery = null;
        /**
         * ifragment
         *
         * @var string
         */
        protected $ifragment = null;
        /**
         * Normalization database
         *
         * Each key is the scheme, each value is an array with each key as the IRI
         * part and value as the default value for that part.
         */
        protected $normalization = ['acap' => ['port' => 674], 'dict' => ['port' => 2628], 'file' => ['ihost' => 'localhost'], 'http' => ['port' => 80, 'ipath' => '/'], 'https' => ['port' => 443, 'ipath' => '/']];
        /**
         * Return the entire IRI when you try and read the object as a string
         *
         * @return string
         */
        public function __toString()
        {
        }
        /**
         * Overload __set() to provide access via properties
         *
         * @param string $name Property name
         * @param mixed $value Property value
         */
        public function __set($name, $value)
        {
        }
        /**
         * Overload __get() to provide access via properties
         *
         * @param string $name Property name
         * @return mixed
         */
        public function __get($name)
        {
        }
        /**
         * Overload __isset() to provide access via properties
         *
         * @param string $name Property name
         * @return bool
         */
        public function __isset($name)
        {
        }
        /**
         * Overload __unset() to provide access via properties
         *
         * @param string $name Property name
         */
        public function __unset($name)
        {
        }
        /**
         * Create a new IRI object, from a specified string
         *
         * @param string $iri
         */
        public function __construct($iri = null)
        {
        }
        /**
         * Clean up
         */
        public function __destruct()
        {
        }
        /**
         * Create a new IRI object by resolving a relative IRI
         *
         * Returns false if $base is not absolute, otherwise an IRI.
         *
         * @param IRI|string $base (Absolute) Base IRI
         * @param IRI|string $relative Relative IRI
         * @return IRI|false
         */
        public static function absolutize($base, $relative)
        {
        }
        /**
         * Parse an IRI into scheme/authority/path/query/fragment segments
         *
         * @param string $iri
         * @return array
         */
        protected function parse_iri($iri)
        {
        }
        /**
         * Remove dot segments from a path
         *
         * @param string $input
         * @return string
         */
        protected function remove_dot_segments($input)
        {
        }
        /**
         * Replace invalid character with percent encoding
         *
         * @param string $string Input string
         * @param string $extra_chars Valid characters not in iunreserved or
         *                            iprivate (this is ASCII-only)
         * @param bool $iprivate Allow iprivate
         * @return string
         */
        protected function replace_invalid_with_pct_encoding($string, $extra_chars, $iprivate = false)
        {
        }
        /**
         * Callback function for preg_replace_callback.
         *
         * Removes sequences of percent encoded bytes that represent UTF-8
         * encoded characters in iunreserved
         *
         * @param array $match PCRE match
         * @return string Replacement
         */
        protected function remove_iunreserved_percent_encoded($match)
        {
        }
        protected function scheme_normalization()
        {
        }
        /**
         * Check if the object represents a valid IRI. This needs to be done on each
         * call as some things change depending on another part of the IRI.
         *
         * @return bool
         */
        public function is_valid()
        {
        }
        /**
         * Set the entire IRI. Returns true on success, false on failure (if there
         * are any invalid characters).
         *
         * @param string $iri
         * @return bool
         */
        public function set_iri($iri, $clear_cache = false)
        {
        }
        /**
         * Set the scheme. Returns true on success, false on failure (if there are
         * any invalid characters).
         *
         * @param string $scheme
         * @return bool
         */
        public function set_scheme($scheme)
        {
        }
        /**
         * Set the authority. Returns true on success, false on failure (if there are
         * any invalid characters).
         *
         * @param string $authority
         * @return bool
         */
        public function set_authority($authority, $clear_cache = false)
        {
        }
        /**
         * Set the iuserinfo.
         *
         * @param string $iuserinfo
         * @return bool
         */
        public function set_userinfo($iuserinfo)
        {
        }
        /**
         * Set the ihost. Returns true on success, false on failure (if there are
         * any invalid characters).
         *
         * @param string $ihost
         * @return bool
         */
        public function set_host($ihost)
        {
        }
        /**
         * Set the port. Returns true on success, false on failure (if there are
         * any invalid characters).
         *
         * @param string $port
         * @return bool
         */
        public function set_port($port)
        {
        }
        /**
         * Set the ipath.
         *
         * @param string $ipath
         * @return bool
         */
        public function set_path($ipath, $clear_cache = false)
        {
        }
        /**
         * Set the iquery.
         *
         * @param string $iquery
         * @return bool
         */
        public function set_query($iquery)
        {
        }
        /**
         * Set the ifragment.
         *
         * @param string $ifragment
         * @return bool
         */
        public function set_fragment($ifragment)
        {
        }
        /**
         * Convert an IRI to a URI (or parts thereof)
         *
         * @return string
         */
        public function to_uri($string)
        {
        }
        /**
         * Get the complete IRI
         *
         * @return string
         */
        public function get_iri()
        {
        }
        /**
         * Get the complete URI
         *
         * @return string
         */
        public function get_uri()
        {
        }
        /**
         * Get the complete iauthority
         *
         * @return string
         */
        protected function get_iauthority()
        {
        }
        /**
         * Get the complete authority
         *
         * @return string
         */
        protected function get_authority()
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\IRI" instead */
    class SimplePie_IRI extends \SimplePie\IRI
    {
    }
}
namespace SimplePie {
    /**
     * Handles the injection of Registry into other class
     *
     * {@see \SimplePie\SimplePie::get_registry()}
     *
     * @package SimplePie
     */
    interface RegistryAware
    {
        /**
         * Set the Registry into the class
         *
         * @param Registry $registry
         *
         * @return void
         */
        public function set_registry(\SimplePie\Registry $registry);
    }
    /**
     * Manages all item-related data
     *
     * Used by {@see \SimplePie\SimplePie::get_item()} and {@see \SimplePie\SimplePie::get_items()}
     *
     * This class can be overloaded with {@see \SimplePie\SimplePie::set_item_class()}
     *
     * @package \SimplePie\SimplePie
     * @subpackage API
     */
    class Item implements \SimplePie\RegistryAware
    {
        /**
         * Parent feed
         *
         * @access private
         * @var \SimplePie\SimplePie
         */
        public $feed;
        /**
         * Raw data
         *
         * @access private
         * @var array
         */
        public $data = [];
        /**
         * Registry object
         *
         * @see set_registry
         * @var \SimplePie\Registry
         */
        protected $registry;
        /**
         * Create a new item object
         *
         * This is usually used by {@see \SimplePie\SimplePie::get_items} and
         * {@see \SimplePie\SimplePie::get_item}. Avoid creating this manually.
         *
         * @param \SimplePie\SimplePie $feed Parent feed
         * @param array $data Raw data
         */
        public function __construct($feed, $data)
        {
        }
        /**
         * Set the registry handler
         *
         * This is usually used by {@see \SimplePie\Registry::create}
         *
         * @since 1.3
         * @param \SimplePie\Registry $registry
         */
        public function set_registry(\SimplePie\Registry $registry)
        {
        }
        /**
         * Get a string representation of the item
         *
         * @return string
         */
        public function __toString()
        {
        }
        /**
         * Remove items that link back to this before destroying this object
         */
        public function __destruct()
        {
        }
        /**
         * Get data for an item-level element
         *
         * This method allows you to get access to ANY element/attribute that is a
         * sub-element of the item/entry tag.
         *
         * See {@see \SimplePie\SimplePie::get_feed_tags()} for a description of the return value
         *
         * @since 1.0
         * @see http://simplepie.org/wiki/faq/supported_xml_namespaces
         * @param string $namespace The URL of the XML namespace of the elements you're trying to access
         * @param string $tag Tag name
         * @return array
         */
        public function get_item_tags($namespace, $tag)
        {
        }
        /**
         * Get the base URL value.
         * Uses `<xml:base>`, or item link, or feed base URL.
         *
         * @param array $element
         * @return string
         */
        public function get_base($element = [])
        {
        }
        /**
         * Sanitize feed data
         *
         * @access private
         * @see \SimplePie\SimplePie::sanitize()
         * @param string $data Data to sanitize
         * @param int $type One of the \SimplePie\SimplePie::CONSTRUCT_* constants
         * @param string $base Base URL to resolve URLs against
         * @return string Sanitized data
         */
        public function sanitize($data, $type, $base = '')
        {
        }
        /**
         * Get the parent feed
         *
         * Note: this may not work as you think for multifeeds!
         *
         * @link http://simplepie.org/faq/typical_multifeed_gotchas#missing_data_from_feed
         * @since 1.0
         * @return \SimplePie\SimplePie
         */
        public function get_feed()
        {
        }
        /**
         * Get the unique identifier for the item
         *
         * This is usually used when writing code to check for new items in a feed.
         *
         * Uses `<atom:id>`, `<guid>`, `<dc:identifier>` or the `about` attribute
         * for RDF. If none of these are supplied (or `$hash` is true), creates an
         * MD5 hash based on the permalink, title and content.
         *
         * @since Beta 2
         * @param boolean $hash Should we force using a hash instead of the supplied ID?
         * @param string|false $fn User-supplied function to generate an hash
         * @return string|null
         */
        public function get_id($hash = false, $fn = 'md5')
        {
        }
        /**
         * Get the title of the item
         *
         * Uses `<atom:title>`, `<title>` or `<dc:title>`
         *
         * @since Beta 2 (previously called `get_item_title` since 0.8)
         * @return string|null
         */
        public function get_title()
        {
        }
        /**
         * Get the content for the item
         *
         * Prefers summaries over full content , but will return full content if a
         * summary does not exist.
         *
         * To prefer full content instead, use {@see get_content}
         *
         * Uses `<atom:summary>`, `<description>`, `<dc:description>` or
         * `<itunes:subtitle>`
         *
         * @since 0.8
         * @param boolean $description_only Should we avoid falling back to the content?
         * @return string|null
         */
        public function get_description($description_only = false)
        {
        }
        /**
         * Get the content for the item
         *
         * Prefers full content over summaries, but will return a summary if full
         * content does not exist.
         *
         * To prefer summaries instead, use {@see get_description}
         *
         * Uses `<atom:content>` or `<content:encoded>` (RSS 1.0 Content Module)
         *
         * @since 1.0
         * @param boolean $content_only Should we avoid falling back to the description?
         * @return string|null
         */
        public function get_content($content_only = false)
        {
        }
        /**
         * Get the media:thumbnail of the item
         *
         * Uses `<media:thumbnail>`
         *
         *
         * @return array|null
         */
        public function get_thumbnail()
        {
        }
        /**
         * Get a category for the item
         *
         * @since Beta 3 (previously called `get_categories()` since Beta 2)
         * @param int $key The category that you want to return.  Remember that arrays begin with 0, not 1
         * @return \SimplePie\Category|null
         */
        public function get_category($key = 0)
        {
        }
        /**
         * Get all categories for the item
         *
         * Uses `<atom:category>`, `<category>` or `<dc:subject>`
         *
         * @since Beta 3
         * @return \SimplePie\Category[]|null List of {@see \SimplePie\Category} objects
         */
        public function get_categories()
        {
        }
        /**
         * Get an author for the item
         *
         * @since Beta 2
         * @param int $key The author that you want to return.  Remember that arrays begin with 0, not 1
         * @return \SimplePie\Author|null
         */
        public function get_author($key = 0)
        {
        }
        /**
         * Get a contributor for the item
         *
         * @since 1.1
         * @param int $key The contrbutor that you want to return.  Remember that arrays begin with 0, not 1
         * @return \SimplePie\Author|null
         */
        public function get_contributor($key = 0)
        {
        }
        /**
         * Get all contributors for the item
         *
         * Uses `<atom:contributor>`
         *
         * @since 1.1
         * @return \SimplePie\Author[]|null List of {@see \SimplePie\Author} objects
         */
        public function get_contributors()
        {
        }
        /**
         * Get all authors for the item
         *
         * Uses `<atom:author>`, `<author>`, `<dc:creator>` or `<itunes:author>`
         *
         * @since Beta 2
         * @return \SimplePie\Author[]|null List of {@see \SimplePie\Author} objects
         */
        public function get_authors()
        {
        }
        /**
         * Get the copyright info for the item
         *
         * Uses `<atom:rights>` or `<dc:rights>`
         *
         * @since 1.1
         * @return string
         */
        public function get_copyright()
        {
        }
        /**
         * Get the posting date/time for the item
         *
         * Uses `<atom:published>`, `<atom:updated>`, `<atom:issued>`,
         * `<atom:modified>`, `<pubDate>` or `<dc:date>`
         *
         * Note: obeys PHP's timezone setting. To get a UTC date/time, use
         * {@see get_gmdate}
         *
         * @since Beta 2 (previously called `get_item_date` since 0.8)
         *
         * @param string $date_format Supports any PHP date format from {@see http://php.net/date} (empty for the raw data)
         * @return int|string|null
         */
        public function get_date($date_format = 'j F Y, g:i a')
        {
        }
        /**
         * Get the update date/time for the item
         *
         * Uses `<atom:updated>`
         *
         * Note: obeys PHP's timezone setting. To get a UTC date/time, use
         * {@see get_gmdate}
         *
         * @param string $date_format Supports any PHP date format from {@see http://php.net/date} (empty for the raw data)
         * @return int|string|null
         */
        public function get_updated_date($date_format = 'j F Y, g:i a')
        {
        }
        /**
         * Get the localized posting date/time for the item
         *
         * Returns the date formatted in the localized language. To display in
         * languages other than the server's default, you need to change the locale
         * with {@link http://php.net/setlocale setlocale()}. The available
         * localizations depend on which ones are installed on your web server.
         *
         * @since 1.0
         *
         * @param string $date_format Supports any PHP date format from {@see http://php.net/strftime} (empty for the raw data)
         * @return int|string|null
         */
        public function get_local_date($date_format = '%c')
        {
        }
        /**
         * Get the posting date/time for the item (UTC time)
         *
         * @see get_date
         * @param string $date_format Supports any PHP date format from {@see http://php.net/date}
         * @return int|string|null
         */
        public function get_gmdate($date_format = 'j F Y, g:i a')
        {
        }
        /**
         * Get the update date/time for the item (UTC time)
         *
         * @see get_updated_date
         * @param string $date_format Supports any PHP date format from {@see http://php.net/date}
         * @return int|string|null
         */
        public function get_updated_gmdate($date_format = 'j F Y, g:i a')
        {
        }
        /**
         * Get the permalink for the item
         *
         * Returns the first link available with a relationship of "alternate".
         * Identical to {@see get_link()} with key 0
         *
         * @see get_link
         * @since 0.8
         * @return string|null Permalink URL
         */
        public function get_permalink()
        {
        }
        /**
         * Get a single link for the item
         *
         * @since Beta 3
         * @param int $key The link that you want to return.  Remember that arrays begin with 0, not 1
         * @param string $rel The relationship of the link to return
         * @return string|null Link URL
         */
        public function get_link($key = 0, $rel = 'alternate')
        {
        }
        /**
         * Get all links for the item
         *
         * Uses `<atom:link>`, `<link>` or `<guid>`
         *
         * @since Beta 2
         * @param string $rel The relationship of links to return
         * @return array|null Links found for the item (strings)
         */
        public function get_links($rel = 'alternate')
        {
        }
        /**
         * Get an enclosure from the item
         *
         * Supports the <enclosure> RSS tag, as well as Media RSS and iTunes RSS.
         *
         * @since Beta 2
         * @todo Add ability to prefer one type of content over another (in a media group).
         * @param int $key The enclosure that you want to return.  Remember that arrays begin with 0, not 1
         * @return \SimplePie\Enclosure|null
         */
        public function get_enclosure($key = 0, $prefer = null)
        {
        }
        /**
         * Get all available enclosures (podcasts, etc.)
         *
         * Supports the <enclosure> RSS tag, as well as Media RSS and iTunes RSS.
         *
         * At this point, we're pretty much assuming that all enclosures for an item
         * are the same content.  Anything else is too complicated to
         * properly support.
         *
         * @since Beta 2
         * @todo Add support for end-user defined sorting of enclosures by type/handler (so we can prefer the faster-loading FLV over MP4).
         * @todo If an element exists at a level, but its value is empty, we should fall back to the value from the parent (if it exists).
         * @return \SimplePie\Enclosure[]|null List of \SimplePie\Enclosure items
         */
        public function get_enclosures()
        {
        }
        /**
         * Get the latitude coordinates for the item
         *
         * Compatible with the W3C WGS84 Basic Geo and GeoRSS specifications
         *
         * Uses `<geo:lat>` or `<georss:point>`
         *
         * @since 1.0
         * @link http://www.w3.org/2003/01/geo/ W3C WGS84 Basic Geo
         * @link http://www.georss.org/ GeoRSS
         * @return string|null
         */
        public function get_latitude()
        {
        }
        /**
         * Get the longitude coordinates for the item
         *
         * Compatible with the W3C WGS84 Basic Geo and GeoRSS specifications
         *
         * Uses `<geo:long>`, `<geo:lon>` or `<georss:point>`
         *
         * @since 1.0
         * @link http://www.w3.org/2003/01/geo/ W3C WGS84 Basic Geo
         * @link http://www.georss.org/ GeoRSS
         * @return string|null
         */
        public function get_longitude()
        {
        }
        /**
         * Get the `<atom:source>` for the item
         *
         * @since 1.1
         * @return \SimplePie\Source|null
         */
        public function get_source()
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Item" instead */
    class SimplePie_Item extends \SimplePie\Item
    {
    }
}
namespace SimplePie {
    /**
     * Used for feed auto-discovery
     *
     *
     * This class can be overloaded with {@see \SimplePie\SimplePie::set_locator_class()}
     *
     * @package SimplePie
     */
    class Locator implements \SimplePie\RegistryAware
    {
        public $useragent;
        public $timeout;
        public $file;
        public $local = [];
        public $elsewhere = [];
        public $cached_entities = [];
        public $http_base;
        public $base;
        public $base_location = 0;
        public $checked_feeds = 0;
        public $max_checked_feeds = 10;
        public $force_fsockopen = false;
        public $curl_options = [];
        public $dom;
        protected $registry;
        public function __construct(\SimplePie\File $file, $timeout = 10, $useragent = null, $max_checked_feeds = 10, $force_fsockopen = false, $curl_options = [])
        {
        }
        public function set_registry(\SimplePie\Registry $registry)
        {
        }
        public function find($type = \SimplePie\SimplePie::LOCATOR_ALL, &$working = null)
        {
        }
        public function is_feed($file, $check_html = false)
        {
        }
        public function get_base()
        {
        }
        public function autodiscovery()
        {
        }
        protected function search_elements_by_tag($name, &$done, $feeds)
        {
        }
        public function get_links()
        {
        }
        public function get_rel_link($rel)
        {
        }
        public function extension(&$array)
        {
        }
        public function body(&$array)
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Locator" instead */
    class SimplePie_Locator extends \SimplePie\Locator
    {
    }
}
namespace SimplePie {
    /**
     * Miscellaneous utilities
     *
     * @package SimplePie
     */
    class Misc
    {
        public static function time_hms($seconds)
        {
        }
        public static function absolutize_url($relative, $base)
        {
        }
        /**
         * Get a HTML/XML element from a HTML string
         *
         * @deprecated since SimplePie 1.3, use DOMDocument instead (parsing HTML with regex is bad!)
         * @param string $realname Element name (including namespace prefix if applicable)
         * @param string $string HTML document
         * @return array
         */
        public static function get_element($realname, $string)
        {
        }
        public static function element_implode($element)
        {
        }
        public static function error($message, $level, $file, $line)
        {
        }
        public static function fix_protocol($url, $http = 1)
        {
        }
        /**
         * @deprecated since SimplePie 1.8.0, use PHP native array_replace_recursive() instead.
         */
        public static function array_merge_recursive($array1, $array2)
        {
        }
        public static function parse_url($url)
        {
        }
        public static function compress_parse_url($scheme = '', $authority = '', $path = '', $query = '', $fragment = '')
        {
        }
        public static function normalize_url($url)
        {
        }
        public static function percent_encoding_normalization($match)
        {
        }
        /**
         * Converts a Windows-1252 encoded string to a UTF-8 encoded string
         *
         * @static
         * @param string $string Windows-1252 encoded string
         * @return string UTF-8 encoded string
         */
        public static function windows_1252_to_utf8($string)
        {
        }
        /**
         * Change a string from one encoding to another
         *
         * @param string $data Raw data in $input encoding
         * @param string $input Encoding of $data
         * @param string $output Encoding you want
         * @return string|boolean False if we can't convert it
         */
        public static function change_encoding($data, $input, $output)
        {
        }
        protected static function change_encoding_mbstring($data, $input, $output)
        {
        }
        protected static function change_encoding_iconv($data, $input, $output)
        {
        }
        /**
         * @param string $data
         * @param string $input
         * @param string $output
         * @return string|false
         */
        protected static function change_encoding_uconverter($data, $input, $output)
        {
        }
        /**
         * Normalize an encoding name
         *
         * This is automatically generated by create.php
         *
         * To generate it, run `php create.php` on the command line, and copy the
         * output to replace this function.
         *
         * @param string $charset Character set to standardise
         * @return string Standardised name
         */
        public static function encoding($charset)
        {
        }
        public static function get_curl_version()
        {
        }
        /**
         * Strip HTML comments
         *
         * @param string $data Data to strip comments from
         * @return string Comment stripped string
         */
        public static function strip_comments($data)
        {
        }
        public static function parse_date($dt)
        {
        }
        /**
         * Decode HTML entities
         *
         * @deprecated since SimplePie 1.3, use DOMDocument instead
         * @param string $data Input data
         * @return string Output data
         */
        public static function entities_decode($data)
        {
        }
        /**
         * Remove RFC822 comments
         *
         * @param string $data Data to strip comments from
         * @return string Comment stripped string
         */
        public static function uncomment_rfc822($string)
        {
        }
        public static function parse_mime($mime)
        {
        }
        public static function atom_03_construct_type($attribs)
        {
        }
        public static function atom_10_construct_type($attribs)
        {
        }
        public static function atom_10_content_construct_type($attribs)
        {
        }
        public static function is_isegment_nz_nc($string)
        {
        }
        public static function space_separated_tokens($string)
        {
        }
        /**
         * Converts a unicode codepoint to a UTF-8 character
         *
         * @static
         * @param int $codepoint Unicode codepoint
         * @return string UTF-8 character
         */
        public static function codepoint_to_utf8($codepoint)
        {
        }
        /**
         * Similar to parse_str()
         *
         * Returns an associative array of name/value pairs, where the value is an
         * array of values that have used the same name
         *
         * @static
         * @param string $str The input string.
         * @return array
         */
        public static function parse_str($str)
        {
        }
        /**
         * Detect XML encoding, as per XML 1.0 Appendix F.1
         *
         * @todo Add support for EBCDIC
         * @param string $data XML data
         * @param \SimplePie\Registry $registry Class registry
         * @return array Possible encodings
         */
        public static function xml_encoding($data, $registry)
        {
        }
        public static function output_javascript()
        {
        }
        /**
         * Get the SimplePie build timestamp
         *
         * Uses the git index if it exists, otherwise uses the modification time
         * of the newest file.
         */
        public static function get_build()
        {
        }
        /**
         * Get the default user agent string
         *
         * @return string
         */
        public static function get_default_useragent()
        {
        }
        /**
         * Format debugging information
         */
        public static function debug(&$sp)
        {
        }
        public static function silence_errors($num, $str)
        {
        }
        /**
         * Sanitize a URL by removing HTTP credentials.
         * @param string $url the URL to sanitize.
         * @return string the same URL without HTTP credentials.
         */
        public static function url_remove_credentials($url)
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Misc" instead */
    class SimplePie_Misc extends \SimplePie\Misc
    {
    }
}
namespace SimplePie\Net {
    /**
     * Class to validate and to work with IPv6 addresses.
     *
     * @package SimplePie
     * @subpackage HTTP
     * @copyright 2003-2005 The PHP Group
     * @license http://www.opensource.org/licenses/bsd-license.php
     * @link http://pear.php.net/package/Net_IPv6
     * @author Alexander Merz <alexander.merz@web.de>
     * @author elfrink at introweb dot nl
     * @author Josh Peck <jmp at joshpeck dot org>
     * @author Sam Sneddon <geoffers@gmail.com>
     */
    class IPv6
    {
        /**
         * Uncompresses an IPv6 address
         *
         * RFC 4291 allows you to compress concecutive zero pieces in an address to
         * '::'. This method expects a valid IPv6 address and expands the '::' to
         * the required number of zero pieces.
         *
         * Example:  FF01::101   ->  FF01:0:0:0:0:0:0:101
         *           ::1         ->  0:0:0:0:0:0:0:1
         *
         * @author Alexander Merz <alexander.merz@web.de>
         * @author elfrink at introweb dot nl
         * @author Josh Peck <jmp at joshpeck dot org>
         * @copyright 2003-2005 The PHP Group
         * @license http://www.opensource.org/licenses/bsd-license.php
         * @param string $ip An IPv6 address
         * @return string The uncompressed IPv6 address
         */
        public static function uncompress($ip)
        {
        }
        /**
         * Compresses an IPv6 address
         *
         * RFC 4291 allows you to compress concecutive zero pieces in an address to
         * '::'. This method expects a valid IPv6 address and compresses consecutive
         * zero pieces to '::'.
         *
         * Example:  FF01:0:0:0:0:0:0:101   ->  FF01::101
         *           0:0:0:0:0:0:0:1        ->  ::1
         *
         * @see uncompress()
         * @param string $ip An IPv6 address
         * @return string The compressed IPv6 address
         */
        public static function compress($ip)
        {
        }
        /**
         * Checks an IPv6 address
         *
         * Checks if the given IP is a valid IPv6 address
         *
         * @param string $ip An IPv6 address
         * @return bool true if $ip is a valid IPv6 address
         */
        public static function check_ipv6($ip)
        {
        }
        /**
         * Checks if the given IP is a valid IPv6 address
         *
         * @codeCoverageIgnore
         * @deprecated Use {@see IPv6::check_ipv6()} instead
         * @see check_ipv6
         * @param string $ip An IPv6 address
         * @return bool true if $ip is a valid IPv6 address
         */
        public static function checkIPv6($ip)
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Net\IPv6" instead */
    class SimplePie_Net_IPv6 extends \SimplePie\Net\IPv6
    {
    }
}
namespace SimplePie\Parse {
    /**
     * Date Parser
     *
     * @package SimplePie
     * @subpackage Parsing
     */
    class Date
    {
        /**
         * Input data
         *
         * @access protected
         * @var string
         */
        public $date;
        /**
         * List of days, calendar day name => ordinal day number in the week
         *
         * @access protected
         * @var array
         */
        public $day = [
            // English
            'mon' => 1,
            'monday' => 1,
            'tue' => 2,
            'tuesday' => 2,
            'wed' => 3,
            'wednesday' => 3,
            'thu' => 4,
            'thursday' => 4,
            'fri' => 5,
            'friday' => 5,
            'sat' => 6,
            'saturday' => 6,
            'sun' => 7,
            'sunday' => 7,
            // Dutch
            'maandag' => 1,
            'dinsdag' => 2,
            'woensdag' => 3,
            'donderdag' => 4,
            'vrijdag' => 5,
            'zaterdag' => 6,
            'zondag' => 7,
            // French
            'lundi' => 1,
            'mardi' => 2,
            'mercredi' => 3,
            'jeudi' => 4,
            'vendredi' => 5,
            'samedi' => 6,
            'dimanche' => 7,
            // German
            'montag' => 1,
            'mo' => 1,
            'dienstag' => 2,
            'di' => 2,
            'mittwoch' => 3,
            'mi' => 3,
            'donnerstag' => 4,
            'do' => 4,
            'freitag' => 5,
            'fr' => 5,
            'samstag' => 6,
            'sa' => 6,
            'sonnabend' => 6,
            // AFAIK no short form for sonnabend
            'so' => 7,
            'sonntag' => 7,
            // Italian
            'lunedì' => 1,
            'martedì' => 2,
            'mercoledì' => 3,
            'giovedì' => 4,
            'venerdì' => 5,
            'sabato' => 6,
            'domenica' => 7,
            // Spanish
            'lunes' => 1,
            'martes' => 2,
            'miércoles' => 3,
            'jueves' => 4,
            'viernes' => 5,
            'sábado' => 6,
            'domingo' => 7,
            // Finnish
            'maanantai' => 1,
            'tiistai' => 2,
            'keskiviikko' => 3,
            'torstai' => 4,
            'perjantai' => 5,
            'lauantai' => 6,
            'sunnuntai' => 7,
            // Hungarian
            'hétfő' => 1,
            'kedd' => 2,
            'szerda' => 3,
            'csütörtok' => 4,
            'péntek' => 5,
            'szombat' => 6,
            'vasárnap' => 7,
            // Greek
            'Δευ' => 1,
            'Τρι' => 2,
            'Τετ' => 3,
            'Πεμ' => 4,
            'Παρ' => 5,
            'Σαβ' => 6,
            'Κυρ' => 7,
            // Russian
            'Пн.' => 1,
            'Вт.' => 2,
            'Ср.' => 3,
            'Чт.' => 4,
            'Пт.' => 5,
            'Сб.' => 6,
            'Вс.' => 7,
        ];
        /**
         * List of months, calendar month name => calendar month number
         *
         * @access protected
         * @var array
         */
        public $month = [
            // English
            'jan' => 1,
            'january' => 1,
            'feb' => 2,
            'february' => 2,
            'mar' => 3,
            'march' => 3,
            'apr' => 4,
            'april' => 4,
            'may' => 5,
            // No long form of May
            'jun' => 6,
            'june' => 6,
            'jul' => 7,
            'july' => 7,
            'aug' => 8,
            'august' => 8,
            'sep' => 9,
            'september' => 9,
            'oct' => 10,
            'october' => 10,
            'nov' => 11,
            'november' => 11,
            'dec' => 12,
            'december' => 12,
            // Dutch
            'januari' => 1,
            'februari' => 2,
            'maart' => 3,
            'april' => 4,
            'mei' => 5,
            'juni' => 6,
            'juli' => 7,
            'augustus' => 8,
            'september' => 9,
            'oktober' => 10,
            'november' => 11,
            'december' => 12,
            // French
            'janvier' => 1,
            'février' => 2,
            'mars' => 3,
            'avril' => 4,
            'mai' => 5,
            'juin' => 6,
            'juillet' => 7,
            'août' => 8,
            'septembre' => 9,
            'octobre' => 10,
            'novembre' => 11,
            'décembre' => 12,
            // German
            'januar' => 1,
            'jan' => 1,
            'februar' => 2,
            'feb' => 2,
            'märz' => 3,
            'mär' => 3,
            'april' => 4,
            'apr' => 4,
            'mai' => 5,
            // no short form for may
            'juni' => 6,
            'jun' => 6,
            'juli' => 7,
            'jul' => 7,
            'august' => 8,
            'aug' => 8,
            'september' => 9,
            'sep' => 9,
            'oktober' => 10,
            'okt' => 10,
            'november' => 11,
            'nov' => 11,
            'dezember' => 12,
            'dez' => 12,
            // Italian
            'gennaio' => 1,
            'febbraio' => 2,
            'marzo' => 3,
            'aprile' => 4,
            'maggio' => 5,
            'giugno' => 6,
            'luglio' => 7,
            'agosto' => 8,
            'settembre' => 9,
            'ottobre' => 10,
            'novembre' => 11,
            'dicembre' => 12,
            // Spanish
            'enero' => 1,
            'febrero' => 2,
            'marzo' => 3,
            'abril' => 4,
            'mayo' => 5,
            'junio' => 6,
            'julio' => 7,
            'agosto' => 8,
            'septiembre' => 9,
            'setiembre' => 9,
            'octubre' => 10,
            'noviembre' => 11,
            'diciembre' => 12,
            // Finnish
            'tammikuu' => 1,
            'helmikuu' => 2,
            'maaliskuu' => 3,
            'huhtikuu' => 4,
            'toukokuu' => 5,
            'kesäkuu' => 6,
            'heinäkuu' => 7,
            'elokuu' => 8,
            'suuskuu' => 9,
            'lokakuu' => 10,
            'marras' => 11,
            'joulukuu' => 12,
            // Hungarian
            'január' => 1,
            'február' => 2,
            'március' => 3,
            'április' => 4,
            'május' => 5,
            'június' => 6,
            'július' => 7,
            'augusztus' => 8,
            'szeptember' => 9,
            'október' => 10,
            'november' => 11,
            'december' => 12,
            // Greek
            'Ιαν' => 1,
            'Φεβ' => 2,
            'Μάώ' => 3,
            'Μαώ' => 3,
            'Απρ' => 4,
            'Μάι' => 5,
            'Μαϊ' => 5,
            'Μαι' => 5,
            'Ιούν' => 6,
            'Ιον' => 6,
            'Ιούλ' => 7,
            'Ιολ' => 7,
            'Αύγ' => 8,
            'Αυγ' => 8,
            'Σεπ' => 9,
            'Οκτ' => 10,
            'Νοέ' => 11,
            'Δεκ' => 12,
            // Russian
            'Янв' => 1,
            'января' => 1,
            'Фев' => 2,
            'февраля' => 2,
            'Мар' => 3,
            'марта' => 3,
            'Апр' => 4,
            'апреля' => 4,
            'Май' => 5,
            'мая' => 5,
            'Июн' => 6,
            'июня' => 6,
            'Июл' => 7,
            'июля' => 7,
            'Авг' => 8,
            'августа' => 8,
            'Сен' => 9,
            'сентября' => 9,
            'Окт' => 10,
            'октября' => 10,
            'Ноя' => 11,
            'ноября' => 11,
            'Дек' => 12,
            'декабря' => 12,
        ];
        /**
         * List of timezones, abbreviation => offset from UTC
         *
         * @access protected
         * @var array
         */
        public $timezone = ['ACDT' => 37800, 'ACIT' => 28800, 'ACST' => 34200, 'ACT' => -18000, 'ACWDT' => 35100, 'ACWST' => 31500, 'AEDT' => 39600, 'AEST' => 36000, 'AFT' => 16200, 'AKDT' => -28800, 'AKST' => -32400, 'AMDT' => 18000, 'AMT' => -14400, 'ANAST' => 46800, 'ANAT' => 43200, 'ART' => -10800, 'AZOST' => -3600, 'AZST' => 18000, 'AZT' => 14400, 'BIOT' => 21600, 'BIT' => -43200, 'BOT' => -14400, 'BRST' => -7200, 'BRT' => -10800, 'BST' => 3600, 'BTT' => 21600, 'CAST' => 18000, 'CAT' => 7200, 'CCT' => 23400, 'CDT' => -18000, 'CEDT' => 7200, 'CEST' => 7200, 'CET' => 3600, 'CGST' => -7200, 'CGT' => -10800, 'CHADT' => 49500, 'CHAST' => 45900, 'CIST' => -28800, 'CKT' => -36000, 'CLDT' => -10800, 'CLST' => -14400, 'COT' => -18000, 'CST' => -21600, 'CVT' => -3600, 'CXT' => 25200, 'DAVT' => 25200, 'DTAT' => 36000, 'EADT' => -18000, 'EAST' => -21600, 'EAT' => 10800, 'ECT' => -18000, 'EDT' => -14400, 'EEST' => 10800, 'EET' => 7200, 'EGT' => -3600, 'EKST' => 21600, 'EST' => -18000, 'FJT' => 43200, 'FKDT' => -10800, 'FKST' => -14400, 'FNT' => -7200, 'GALT' => -21600, 'GEDT' => 14400, 'GEST' => 10800, 'GFT' => -10800, 'GILT' => 43200, 'GIT' => -32400, 'GST' => 14400, 'GST' => -7200, 'GYT' => -14400, 'HAA' => -10800, 'HAC' => -18000, 'HADT' => -32400, 'HAE' => -14400, 'HAP' => -25200, 'HAR' => -21600, 'HAST' => -36000, 'HAT' => -9000, 'HAY' => -28800, 'HKST' => 28800, 'HMT' => 18000, 'HNA' => -14400, 'HNC' => -21600, 'HNE' => -18000, 'HNP' => -28800, 'HNR' => -25200, 'HNT' => -12600, 'HNY' => -32400, 'IRDT' => 16200, 'IRKST' => 32400, 'IRKT' => 28800, 'IRST' => 12600, 'JFDT' => -10800, 'JFST' => -14400, 'JST' => 32400, 'KGST' => 21600, 'KGT' => 18000, 'KOST' => 39600, 'KOVST' => 28800, 'KOVT' => 25200, 'KRAST' => 28800, 'KRAT' => 25200, 'KST' => 32400, 'LHDT' => 39600, 'LHST' => 37800, 'LINT' => 50400, 'LKT' => 21600, 'MAGST' => 43200, 'MAGT' => 39600, 'MAWT' => 21600, 'MDT' => -21600, 'MESZ' => 7200, 'MEZ' => 3600, 'MHT' => 43200, 'MIT' => -34200, 'MNST' => 32400, 'MSDT' => 14400, 'MSST' => 10800, 'MST' => -25200, 'MUT' => 14400, 'MVT' => 18000, 'MYT' => 28800, 'NCT' => 39600, 'NDT' => -9000, 'NFT' => 41400, 'NMIT' => 36000, 'NOVST' => 25200, 'NOVT' => 21600, 'NPT' => 20700, 'NRT' => 43200, 'NST' => -12600, 'NUT' => -39600, 'NZDT' => 46800, 'NZST' => 43200, 'OMSST' => 25200, 'OMST' => 21600, 'PDT' => -25200, 'PET' => -18000, 'PETST' => 46800, 'PETT' => 43200, 'PGT' => 36000, 'PHOT' => 46800, 'PHT' => 28800, 'PKT' => 18000, 'PMDT' => -7200, 'PMST' => -10800, 'PONT' => 39600, 'PST' => -28800, 'PWT' => 32400, 'PYST' => -10800, 'PYT' => -14400, 'RET' => 14400, 'ROTT' => -10800, 'SAMST' => 18000, 'SAMT' => 14400, 'SAST' => 7200, 'SBT' => 39600, 'SCDT' => 46800, 'SCST' => 43200, 'SCT' => 14400, 'SEST' => 3600, 'SGT' => 28800, 'SIT' => 28800, 'SRT' => -10800, 'SST' => -39600, 'SYST' => 10800, 'SYT' => 7200, 'TFT' => 18000, 'THAT' => -36000, 'TJT' => 18000, 'TKT' => -36000, 'TMT' => 18000, 'TOT' => 46800, 'TPT' => 32400, 'TRUT' => 36000, 'TVT' => 43200, 'TWT' => 28800, 'UYST' => -7200, 'UYT' => -10800, 'UZT' => 18000, 'VET' => -14400, 'VLAST' => 39600, 'VLAT' => 36000, 'VOST' => 21600, 'VUT' => 39600, 'WAST' => 7200, 'WAT' => 3600, 'WDT' => 32400, 'WEST' => 3600, 'WFT' => 43200, 'WIB' => 25200, 'WIT' => 32400, 'WITA' => 28800, 'WKST' => 18000, 'WST' => 28800, 'YAKST' => 36000, 'YAKT' => 32400, 'YAPT' => 36000, 'YEKST' => 21600, 'YEKT' => 18000];
        /**
         * Cached PCRE for Date::$day
         *
         * @access protected
         * @var string
         */
        public $day_pcre;
        /**
         * Cached PCRE for Date::$month
         *
         * @access protected
         * @var string
         */
        public $month_pcre;
        /**
         * Array of user-added callback methods
         *
         * @access private
         * @var array
         */
        public $built_in = [];
        /**
         * Array of user-added callback methods
         *
         * @access private
         * @var array
         */
        public $user = [];
        /**
         * Create new Date object, and set self::day_pcre,
         * self::month_pcre, and self::built_in
         *
         * @access private
         */
        public function __construct()
        {
        }
        /**
         * Get the object
         *
         * @access public
         */
        public static function get()
        {
        }
        /**
         * Parse a date
         *
         * @final
         * @access public
         * @param string $date Date to parse
         * @return int Timestamp corresponding to date string, or false on failure
         */
        public function parse($date)
        {
        }
        /**
         * Add a callback method to parse a date
         *
         * @final
         * @access public
         * @param callable $callback
         */
        public function add_callback($callback)
        {
        }
        /**
         * Parse a superset of W3C-DTF (allows hyphens and colons to be omitted, as
         * well as allowing any of upper or lower case "T", horizontal tabs, or
         * spaces to be used as the time separator (including more than one))
         *
         * @access protected
         * @return int Timestamp
         */
        public function date_w3cdtf($date)
        {
        }
        /**
         * Remove RFC822 comments
         *
         * @access protected
         * @param string $data Data to strip comments from
         * @return string Comment stripped string
         */
        public function remove_rfc2822_comments($string)
        {
        }
        /**
         * Parse RFC2822's date format
         *
         * @access protected
         * @return int Timestamp
         */
        public function date_rfc2822($date)
        {
        }
        /**
         * Parse RFC850's date format
         *
         * @access protected
         * @return int Timestamp
         */
        public function date_rfc850($date)
        {
        }
        /**
         * Parse C99's asctime()'s date format
         *
         * @access protected
         * @return int Timestamp
         */
        public function date_asctime($date)
        {
        }
        /**
         * Parse dates using strtotime()
         *
         * @access protected
         * @return int Timestamp
         */
        public function date_strtotime($date)
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Parse\Date" instead */
    class SimplePie_Parse_Date extends \SimplePie\Parse\Date
    {
    }
}
namespace SimplePie {
    /**
     * Parses XML into something sane
     *
     *
     * This class can be overloaded with {@see \SimplePie\SimplePie::set_parser_class()}
     *
     * @package SimplePie
     * @subpackage Parsing
     */
    class Parser implements \SimplePie\RegistryAware
    {
        public $error_code;
        public $error_string;
        public $current_line;
        public $current_column;
        public $current_byte;
        public $separator = ' ';
        public $namespace = [''];
        public $element = [''];
        public $xml_base = [''];
        public $xml_base_explicit = [false];
        public $xml_lang = [''];
        public $data = [];
        public $datas = [[]];
        public $current_xhtml_construct = -1;
        public $encoding;
        protected $registry;
        public function set_registry(\SimplePie\Registry $registry)
        {
        }
        public function parse(&$data, $encoding, $url = '')
        {
        }
        public function get_error_code()
        {
        }
        public function get_error_string()
        {
        }
        public function get_current_line()
        {
        }
        public function get_current_column()
        {
        }
        public function get_current_byte()
        {
        }
        public function get_data()
        {
        }
        public function tag_open($parser, $tag, $attributes)
        {
        }
        public function cdata($parser, $cdata)
        {
        }
        public function tag_close($parser, $tag)
        {
        }
        public function split_ns($string)
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Parser" instead */
    class SimplePie_Parser extends \SimplePie\Parser
    {
    }
}
namespace SimplePie {
    /**
     * Handles `<media:rating>` or `<itunes:explicit>` tags as defined in Media RSS and iTunes RSS respectively
     *
     * Used by {@see \SimplePie\Enclosure::get_rating()} and {@see \SimplePie\Enclosure::get_ratings()}
     *
     * This class can be overloaded with {@see \SimplePie\SimplePie::set_rating_class()}
     *
     * @package SimplePie
     * @subpackage API
     */
    class Rating
    {
        /**
         * Rating scheme
         *
         * @var string
         * @see get_scheme()
         */
        public $scheme;
        /**
         * Rating value
         *
         * @var string
         * @see get_value()
         */
        public $value;
        /**
         * Constructor, used to input the data
         *
         * For documentation on all the parameters, see the corresponding
         * properties and their accessors
         */
        public function __construct($scheme = null, $value = null)
        {
        }
        /**
         * String-ified version
         *
         * @return string
         */
        public function __toString()
        {
        }
        /**
         * Get the organizational scheme for the rating
         *
         * @return string|null
         */
        public function get_scheme()
        {
        }
        /**
         * Get the value of the rating
         *
         * @return string|null
         */
        public function get_value()
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Rating" instead */
    class SimplePie_Rating extends \SimplePie\Rating
    {
    }
}
namespace SimplePie {
    /**
     * Handles creating objects and calling methods
     *
     * Access this via {@see \SimplePie\SimplePie::get_registry()}
     *
     * @package SimplePie
     */
    class Registry
    {
        /**
         * Default class mapping
         *
         * Overriding classes *must* subclass these.
         *
         * @var array<class-string, class-string>
         */
        protected $default = [\SimplePie\Cache::class => \SimplePie\Cache::class, \SimplePie\Locator::class => \SimplePie\Locator::class, \SimplePie\Parser::class => \SimplePie\Parser::class, \SimplePie\File::class => \SimplePie\File::class, \SimplePie\Sanitize::class => \SimplePie\Sanitize::class, \SimplePie\Item::class => \SimplePie\Item::class, \SimplePie\Author::class => \SimplePie\Author::class, \SimplePie\Category::class => \SimplePie\Category::class, \SimplePie\Enclosure::class => \SimplePie\Enclosure::class, \SimplePie\Caption::class => \SimplePie\Caption::class, \SimplePie\Copyright::class => \SimplePie\Copyright::class, \SimplePie\Credit::class => \SimplePie\Credit::class, \SimplePie\Rating::class => \SimplePie\Rating::class, \SimplePie\Restriction::class => \SimplePie\Restriction::class, \SimplePie\Content\Type\Sniffer::class => \SimplePie\Content\Type\Sniffer::class, \SimplePie\Source::class => \SimplePie\Source::class, \SimplePie\Misc::class => \SimplePie\Misc::class, \SimplePie\XML\Declaration\Parser::class => \SimplePie\XML\Declaration\Parser::class, \SimplePie\Parse\Date::class => \SimplePie\Parse\Date::class];
        /**
         * Class mapping
         *
         * @see register()
         * @var array
         */
        protected $classes = [];
        /**
         * Legacy classes
         *
         * @see register()
         * @var array<class-string>
         */
        protected $legacy = [];
        /**
         * Constructor
         *
         * No-op
         */
        public function __construct()
        {
        }
        /**
         * Register a class
         *
         * @param string $type See {@see $default} for names
         * @param class-string $class Class name, must subclass the corresponding default
         * @param bool $legacy Whether to enable legacy support for this class
         * @return bool Successfulness
         */
        public function register($type, $class, $legacy = false)
        {
        }
        /**
         * Get the class registered for a type
         *
         * Where possible, use {@see create()} or {@see call()} instead
         *
         * @template T
         * @param class-string<T> $type
         * @return class-string<T>|null
         */
        public function get_class($type)
        {
        }
        /**
         * Create a new instance of a given type
         *
         * @template T class-string $type
         * @param class-string<T> $type
         * @param array $parameters Parameters to pass to the constructor
         * @return T Instance of class
         */
        public function &create($type, $parameters = [])
        {
        }
        /**
         * Call a static method for a type
         *
         * @param class-string $type
         * @param string $method
         * @param array $parameters
         * @return mixed
         */
        public function &call($type, $method, $parameters = [])
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Registry" instead */
    class SimplePie_Registry extends \SimplePie\Registry
    {
    }
}
namespace SimplePie {
    /**
     * Handles `<media:restriction>` as defined in Media RSS
     *
     * Used by {@see \SimplePie\Enclosure::get_restriction()} and {@see \SimplePie\Enclosure::get_restrictions()}
     *
     * This class can be overloaded with {@see \SimplePie\SimplePie::set_restriction_class()}
     *
     * @package SimplePie
     * @subpackage API
     */
    class Restriction
    {
        /**
         * Relationship ('allow'/'deny')
         *
         * @var string
         * @see get_relationship()
         */
        public $relationship;
        /**
         * Type of restriction
         *
         * @var string
         * @see get_type()
         */
        public $type;
        /**
         * Restricted values
         *
         * @var string
         * @see get_value()
         */
        public $value;
        /**
         * Constructor, used to input the data
         *
         * For documentation on all the parameters, see the corresponding
         * properties and their accessors
         */
        public function __construct($relationship = null, $type = null, $value = null)
        {
        }
        /**
         * String-ified version
         *
         * @return string
         */
        public function __toString()
        {
        }
        /**
         * Get the relationship
         *
         * @return string|null Either 'allow' or 'deny'
         */
        public function get_relationship()
        {
        }
        /**
         * Get the type
         *
         * @return string|null
         */
        public function get_type()
        {
        }
        /**
         * Get the list of restricted things
         *
         * @return string|null
         */
        public function get_value()
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Restriction" instead */
    class SimplePie_Restriction extends \SimplePie\Restriction
    {
    }
}
namespace SimplePie {
    /**
     * Used for data cleanup and post-processing
     *
     *
     * This class can be overloaded with {@see \SimplePie\SimplePie::set_sanitize_class()}
     *
     * @package SimplePie
     * @todo Move to using an actual HTML parser (this will allow tags to be properly stripped, and to switch between HTML and XHTML), this will also make it easier to shorten a string while preserving HTML tags
     */
    class Sanitize implements \SimplePie\RegistryAware
    {
        public $base;
        public $remove_div = true;
        public $image_handler = '';
        public $strip_htmltags = ['base', 'blink', 'body', 'doctype', 'embed', 'font', 'form', 'frame', 'frameset', 'html', 'iframe', 'input', 'marquee', 'meta', 'noscript', 'object', 'param', 'script', 'style'];
        public $encode_instead_of_strip = false;
        public $strip_attributes = ['bgsound', 'expr', 'id', 'style', 'onclick', 'onerror', 'onfinish', 'onmouseover', 'onmouseout', 'onfocus', 'onblur', 'lowsrc', 'dynsrc'];
        public $rename_attributes = [];
        public $add_attributes = ['audio' => ['preload' => 'none'], 'iframe' => ['sandbox' => 'allow-scripts allow-same-origin'], 'video' => ['preload' => 'none']];
        public $strip_comments = false;
        public $output_encoding = 'UTF-8';
        public $enable_cache = true;
        public $cache_location = './cache';
        public $cache_name_function = 'md5';
        public $timeout = 10;
        public $useragent = '';
        public $force_fsockopen = false;
        public $replace_url_attributes = null;
        public $registry;
        /**
         * List of domains for which to force HTTPS.
         * @see \SimplePie\Sanitize::set_https_domains()
         * Array is a tree split at DNS levels. Example:
         * array('biz' => true, 'com' => array('example' => true), 'net' => array('example' => array('www' => true)))
         */
        public $https_domains = [];
        public function __construct()
        {
        }
        public function remove_div($enable = true)
        {
        }
        public function set_image_handler($page = false)
        {
        }
        public function set_registry(\SimplePie\Registry $registry)
        {
        }
        public function pass_cache_data($enable_cache = true, $cache_location = './cache', $cache_name_function = 'md5', $cache_class = 'SimplePie\Cache', ?\SimplePie\Cache\DataCache $cache = null)
        {
        }
        public function pass_file_data($file_class = 'SimplePie\File', $timeout = 10, $useragent = '', $force_fsockopen = false)
        {
        }
        public function strip_htmltags($tags = ['base', 'blink', 'body', 'doctype', 'embed', 'font', 'form', 'frame', 'frameset', 'html', 'iframe', 'input', 'marquee', 'meta', 'noscript', 'object', 'param', 'script', 'style'])
        {
        }
        public function encode_instead_of_strip($encode = false)
        {
        }
        public function rename_attributes($attribs = [])
        {
        }
        public function strip_attributes($attribs = ['bgsound', 'expr', 'id', 'style', 'onclick', 'onerror', 'onfinish', 'onmouseover', 'onmouseout', 'onfocus', 'onblur', 'lowsrc', 'dynsrc'])
        {
        }
        public function add_attributes($attribs = ['audio' => ['preload' => 'none'], 'iframe' => ['sandbox' => 'allow-scripts allow-same-origin'], 'video' => ['preload' => 'none']])
        {
        }
        public function strip_comments($strip = false)
        {
        }
        public function set_output_encoding($encoding = 'UTF-8')
        {
        }
        /**
         * Set element/attribute key/value pairs of HTML attributes
         * containing URLs that need to be resolved relative to the feed
         *
         * Defaults to |a|@href, |area|@href, |audio|@src, |blockquote|@cite,
         * |del|@cite, |form|@action, |img|@longdesc, |img|@src, |input|@src,
         * |ins|@cite, |q|@cite, |source|@src, |video|@src
         *
         * @since 1.0
         * @param array|null $element_attribute Element/attribute key/value pairs, null for default
         */
        public function set_url_replacements($element_attribute = null)
        {
        }
        /**
         * Set the list of domains for which to force HTTPS.
         * @see \SimplePie\Misc::https_url()
         * Example array('biz', 'example.com', 'example.org', 'www.example.net');
         */
        public function set_https_domains($domains)
        {
        }
        /**
         * Check if the domain is in the list of forced HTTPS.
         */
        protected function is_https_domain($domain)
        {
        }
        /**
         * Force HTTPS for selected Web sites.
         */
        public function https_url($url)
        {
        }
        public function sanitize($data, $type, $base = '')
        {
        }
        protected function preprocess($html, $type)
        {
        }
        public function replace_urls($document, $tag, $attributes)
        {
        }
        public function do_strip_htmltags($match)
        {
        }
        protected function strip_tag($tag, $document, $xpath, $type)
        {
        }
        protected function strip_attr($attrib, $xpath)
        {
        }
        protected function rename_attr($attrib, $xpath)
        {
        }
        protected function add_attr($tag, $valuePairs, $document)
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Sanitize" instead */
    class SimplePie_Sanitize extends \SimplePie\Sanitize
    {
    }
}
namespace SimplePie {
    /**
     * Handles `<atom:source>`
     *
     * Used by {@see \SimplePie\Item::get_source()}
     *
     * This class can be overloaded with {@see \SimplePie::set_source_class()}
     *
     * @package SimplePie
     * @subpackage API
     */
    class Source implements \SimplePie\RegistryAware
    {
        public $item;
        public $data = [];
        protected $registry;
        public function __construct($item, $data)
        {
        }
        public function set_registry(\SimplePie\Registry $registry)
        {
        }
        public function __toString()
        {
        }
        public function get_source_tags($namespace, $tag)
        {
        }
        public function get_base($element = [])
        {
        }
        public function sanitize($data, $type, $base = '')
        {
        }
        public function get_item()
        {
        }
        public function get_title()
        {
        }
        public function get_category($key = 0)
        {
        }
        public function get_categories()
        {
        }
        public function get_author($key = 0)
        {
        }
        public function get_authors()
        {
        }
        public function get_contributor($key = 0)
        {
        }
        public function get_contributors()
        {
        }
        public function get_link($key = 0, $rel = 'alternate')
        {
        }
        /**
         * Added for parity between the parent-level and the item/entry-level.
         */
        public function get_permalink()
        {
        }
        public function get_links($rel = 'alternate')
        {
        }
        public function get_description()
        {
        }
        public function get_copyright()
        {
        }
        public function get_language()
        {
        }
        public function get_latitude()
        {
        }
        public function get_longitude()
        {
        }
        public function get_image_url()
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Source" instead */
    class SimplePie_Source extends \SimplePie\Source
    {
    }
}
namespace SimplePie\XML\Declaration {
    /**
     * Parses the XML Declaration
     *
     * @package SimplePie
     * @subpackage Parsing
     */
    class Parser
    {
        /**
         * XML Version
         *
         * @access public
         * @var string
         */
        public $version = '1.0';
        /**
         * Encoding
         *
         * @access public
         * @var string
         */
        public $encoding = 'UTF-8';
        /**
         * Standalone
         *
         * @access public
         * @var bool
         */
        public $standalone = false;
        /**
         * Current state of the state machine
         *
         * @access private
         * @var self::STATE_*
         */
        public $state = self::STATE_BEFORE_VERSION_NAME;
        /**
         * Input data
         *
         * @access private
         * @var string
         */
        public $data = '';
        /**
         * Input data length (to avoid calling strlen() everytime this is needed)
         *
         * @access private
         * @var int
         */
        public $data_length = 0;
        /**
         * Current position of the pointer
         *
         * @var int
         * @access private
         */
        public $position = 0;
        /**
         * Create an instance of the class with the input data
         *
         * @access public
         * @param string $data Input data
         */
        public function __construct($data)
        {
        }
        /**
         * Parse the input data
         *
         * @access public
         * @return bool true on success, false on failure
         */
        public function parse()
        {
        }
        /**
         * Check whether there is data beyond the pointer
         *
         * @access private
         * @return bool true if there is further data, false if not
         */
        public function has_data()
        {
        }
        /**
         * Advance past any whitespace
         *
         * @return int Number of whitespace characters passed
         */
        public function skip_whitespace()
        {
        }
        /**
         * Read value
         */
        public function get_value()
        {
        }
        public function before_version_name()
        {
        }
        public function version_name()
        {
        }
        public function version_equals()
        {
        }
        public function version_value()
        {
        }
        public function encoding_name()
        {
        }
        public function encoding_equals()
        {
        }
        public function encoding_value()
        {
        }
        public function standalone_name()
        {
        }
        public function standalone_equals()
        {
        }
        public function standalone_value()
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\XML\Declaration\Parser" instead */
    class SimplePie_XML_Declaration_Parser extends \SimplePie\XML\Declaration\Parser
    {
    }
}
namespace SimplePie {
    /**
     * Decode 'gzip' encoded HTTP data
     *
     * @package SimplePie
     * @subpackage HTTP
     * @link http://www.gzip.org/format.txt
     */
    class Gzdecode
    {
        /**
         * Compressed data
         *
         * @access private
         * @var string
         * @see gzdecode::$data
         */
        public $compressed_data;
        /**
         * Size of compressed data
         *
         * @access private
         * @var int
         */
        public $compressed_size;
        /**
         * Minimum size of a valid gzip string
         *
         * @access private
         * @var int
         */
        public $min_compressed_size = 18;
        /**
         * Current position of pointer
         *
         * @access private
         * @var int
         */
        public $position = 0;
        /**
         * Flags (FLG)
         *
         * @access private
         * @var int
         */
        public $flags;
        /**
         * Uncompressed data
         *
         * @access public
         * @see gzdecode::$compressed_data
         * @var string
         */
        public $data;
        /**
         * Modified time
         *
         * @access public
         * @var int
         */
        public $MTIME;
        /**
         * Extra Flags
         *
         * @access public
         * @var int
         */
        public $XFL;
        /**
         * Operating System
         *
         * @access public
         * @var int
         */
        public $OS;
        /**
         * Subfield ID 1
         *
         * @access public
         * @see gzdecode::$extra_field
         * @see gzdecode::$SI2
         * @var string
         */
        public $SI1;
        /**
         * Subfield ID 2
         *
         * @access public
         * @see gzdecode::$extra_field
         * @see gzdecode::$SI1
         * @var string
         */
        public $SI2;
        /**
         * Extra field content
         *
         * @access public
         * @see gzdecode::$SI1
         * @see gzdecode::$SI2
         * @var string
         */
        public $extra_field;
        /**
         * Original filename
         *
         * @access public
         * @var string
         */
        public $filename;
        /**
         * Human readable comment
         *
         * @access public
         * @var string
         */
        public $comment;
        /**
         * Don't allow anything to be set
         *
         * @param string $name
         * @param mixed $value
         */
        public function __set($name, $value)
        {
        }
        /**
         * Set the compressed string and related properties
         *
         * @param string $data
         */
        public function __construct($data)
        {
        }
        /**
         * Decode the GZIP stream
         *
         * @return bool Successfulness
         */
        public function parse()
        {
        }
    }
}
namespace {
    /** @deprecated since SimplePie 1.7.0, use "SimplePie\Gzdecode" instead */
    class SimplePie_gzdecode extends \SimplePie\Gzdecode
    {
    }
}
namespace SimplePie\Cache {
    /**
     * Subset of PSR-16 Cache client for caching data arrays
     *
     * Only get(), set() and delete() methods are used,
     * but not has(), getMultiple(), setMultiple() or deleteMultiple().
     *
     * The methods names must be different, but should be compatible to the
     * methods of \Psr\SimpleCache\CacheInterface.
     *
     * @package SimplePie
     * @subpackage Caching
     * @internal
     */
    interface DataCache
    {
        /**
         * Fetches a value from the cache.
         *
         * Equivalent to \Psr\SimpleCache\CacheInterface::get()
         * <code>
         * public function get(string $key, mixed $default = null): mixed;
         * </code>
         *
         * @param string   $key     The unique key of this item in the cache.
         * @param mixed    $default Default value to return if the key does not exist.
         *
         * @return array|mixed The value of the item from the cache, or $default in case of cache miss.
         *
         * @throws InvalidArgumentException
         *   MUST be thrown if the $key string is not a legal value.
         */
        public function get_data(string $key, $default = null);
        /**
         * Persists data in the cache, uniquely referenced by a key with an optional expiration TTL time.
         *
         * Equivalent to \Psr\SimpleCache\CacheInterface::set()
         * <code>
         * public function set(string $key, mixed $value, null|int|\DateInterval $ttl = null): bool;
         * </code>
         *
         * @param string   $key   The key of the item to store.
         * @param array    $value The value of the item to store, must be serializable.
         * @param null|int $ttl   Optional. The TTL value of this item. If no value is sent and
         *                                      the driver supports TTL then the library may set a default value
         *                                      for it or let the driver take care of that.
         *
         * @return bool True on success and false on failure.
         *
         * @throws InvalidArgumentException
         *   MUST be thrown if the $key string is not a legal value.
         */
        public function set_data(string $key, array $value, ?int $ttl = null): bool;
        /**
         * Delete an item from the cache by its unique key.
         *
         * Equivalent to \Psr\SimpleCache\CacheInterface::delete()
         * <code>
         * public function delete(string $key): bool;
         * </code>
         *
         * @param string $key The unique cache key of the item to delete.
         *
         * @return bool True if the item was successfully removed. False if there was an error.
         *
         * @throws InvalidArgumentException
         *   MUST be thrown if the $key string is not a legal value.
         */
        public function delete_data(string $key): bool;
    }
    /**
     * Adapter for deprecated \SimplePie\Cache\Base implementations
     *
     * @package SimplePie
     * @subpackage Caching
     * @internal
     */
    final class BaseDataCache implements \SimplePie\Cache\DataCache
    {
        public function __construct(\SimplePie\Cache\Base $cache)
        {
        }
        /**
         * Fetches a value from the cache.
         *
         * Equivalent to \Psr\SimpleCache\CacheInterface::get()
         * <code>
         * public function get(string $key, mixed $default = null): mixed;
         * </code>
         *
         * @param string $key     The unique key of this item in the cache.
         * @param mixed  $default Default value to return if the key does not exist.
         *
         * @return array|mixed The value of the item from the cache, or $default in case of cache miss.
         *
         * @throws InvalidArgumentException
         *   MUST be thrown if the $key string is not a legal value.
         */
        public function get_data(string $key, $default = null)
        {
        }
        /**
         * Persists data in the cache, uniquely referenced by a key with an optional expiration TTL time.
         *
         * Equivalent to \Psr\SimpleCache\CacheInterface::set()
         * <code>
         * public function set(string $key, mixed $value, null|int|\DateInterval $ttl = null): bool;
         * </code>
         *
         * @param string   $key   The key of the item to store.
         * @param array    $value The value of the item to store, must be serializable.
         * @param null|int $ttl   Optional. The TTL value of this item. If no value is sent and
         *                                      the driver supports TTL then the library may set a default value
         *                                      for it or let the driver take care of that.
         *
         * @return bool True on success and false on failure.
         *
         * @throws InvalidArgumentException
         *   MUST be thrown if the $key string is not a legal value.
         */
        public function set_data(string $key, array $value, ?int $ttl = null): bool
        {
        }
        /**
         * Delete an item from the cache by its unique key.
         *
         * Equivalent to \Psr\SimpleCache\CacheInterface::delete()
         * <code>
         * public function delete(string $key): bool;
         * </code>
         *
         * @param string $key The unique cache key of the item to delete.
         *
         * @return bool True if the item was successfully removed. False if there was an error.
         *
         * @throws InvalidArgumentException
         *   MUST be thrown if the $key string is not a legal value.
         */
        public function delete_data(string $key): bool
        {
        }
    }
    /**
     * Interface for creating a cache filename
     *
     * @package SimplePie
     * @subpackage Caching
     */
    interface NameFilter
    {
        /**
         * Method to create cache filename with.
         *
         * The returning name MUST follow the rules for keys in PSR-16.
         *
         * @link https://www.php-fig.org/psr/psr-16/
         *
         * The returning name MUST be a string of at least one character
         * that uniquely identifies a cached item, MUST only contain the
         * characters A-Z, a-z, 0-9, _, and . in any order in UTF-8 encoding
         * and MUST not longer then 64 characters. The following characters
         * are reserved for future extensions and MUST NOT be used: {}()/\@:
         *
         * A provided implementing library MAY support additional characters
         * and encodings or longer lengths, but MUST support at least that
         * minimum.
         *
         * @param string $name The name for the cache will be most likly an url with query string
         *
         * @return string the new cache name
         */
        public function filter(string $name): string;
    }
    /**
     * Creating a cache filename with callables
     *
     * @package SimplePie
     * @subpackage Caching
     */
    final class CallableNameFilter implements \SimplePie\Cache\NameFilter
    {
        public function __construct(callable $callable)
        {
        }
        /**
         * Method to create cache filename with.
         *
         * The returning name MUST follow the rules for keys in PSR-16.
         *
         * @link https://www.php-fig.org/psr/psr-16/
         *
         * The returning name MUST be a string of at least one character
         * that uniquely identifies a cached item, MUST only contain the
         * characters A-Z, a-z, 0-9, _, and . in any order in UTF-8 encoding
         * and MUST not longer then 64 characters. The following characters
         * are reserved for future extensions and MUST NOT be used: {}()/\@:
         *
         * A provided implementing library MAY support additional characters
         * and encodings or longer lengths, but MUST support at least that
         * minimum.
         *
         * @param string $name The name for the cache will be most likly an url with query string
         *
         * @return string the new cache name
         */
        public function filter(string $name): string
        {
        }
    }
    /**
     * Caches data into a PSR-16 cache implementation
     *
     * @package SimplePie
     * @subpackage Caching
     * @internal
     */
    final class Psr16 implements \SimplePie\Cache\DataCache
    {
        /**
         * PSR-16 cache implementation
         *
         * @param CacheInterface $cache
         */
        public function __construct(\Psr\SimpleCache\CacheInterface $cache)
        {
        }
        /**
         * Fetches a value from the cache.
         *
         * Equivalent to \Psr\SimpleCache\CacheInterface::get()
         * <code>
         * public function get(string $key, mixed $default = null): mixed;
         * </code>
         *
         * @param string $key     The unique key of this item in the cache.
         * @param mixed  $default Default value to return if the key does not exist.
         *
         * @return array|mixed The value of the item from the cache, or $default in case of cache miss.
         *
         * @throws InvalidArgumentException
         *   MUST be thrown if the $key string is not a legal value.
         */
        public function get_data(string $key, $default = null)
        {
        }
        /**
         * Persists data in the cache, uniquely referenced by a key with an optional expiration TTL time.
         *
         * Equivalent to \Psr\SimpleCache\CacheInterface::set()
         * <code>
         * public function set(string $key, mixed $value, null|int|\DateInterval $ttl = null): bool;
         * </code>
         *
         * @param string   $key   The key of the item to store.
         * @param array    $value The value of the item to store, must be serializable.
         * @param null|int $ttl   Optional. The TTL value of this item. If no value is sent and
         *                                      the driver supports TTL then the library may set a default value
         *                                      for it or let the driver take care of that.
         *
         * @return bool True on success and false on failure.
         *
         * @throws InvalidArgumentException
         *   MUST be thrown if the $key string is not a legal value.
         */
        public function set_data(string $key, array $value, ?int $ttl = null): bool
        {
        }
        /**
         * Delete an item from the cache by its unique key.
         *
         * Equivalent to \Psr\SimpleCache\CacheInterface::delete()
         * <code>
         * public function delete(string $key): bool;
         * </code>
         *
         * @param string $key The unique cache key of the item to delete.
         *
         * @return bool True if the item was successfully removed. False if there was an error.
         *
         * @throws InvalidArgumentException
         *   MUST be thrown if the $key string is not a legal value.
         */
        public function delete_data(string $key): bool
        {
        }
    }
}
namespace {
    /**
     * General API for generating and formatting diffs - the differences between
     * two sequences of strings.
     *
     * The original PHP version of this code was written by Geoffrey T. Dairiki
     * <dairiki@dairiki.org>, and is used/adapted with his permission.
     *
     * Copyright 2004 Geoffrey T. Dairiki <dairiki@dairiki.org>
     * Copyright 2004-2010 The Horde Project (http://www.horde.org/)
     *
     * See the enclosed file COPYING for license information (LGPL). If you did
     * not receive this file, see https://opensource.org/license/lgpl-2-1/.
     *
     * @package Text_Diff
     * @author  Geoffrey T. Dairiki <dairiki@dairiki.org>
     */
    class Text_Diff
    {
        /**
         * Array of changes.
         *
         * @var array
         */
        var $_edits;
        /**
         * Computes diffs between sequences of strings.
         *
         * @param string $engine     Name of the diffing engine to use.  'auto'
         *                           will automatically select the best.
         * @param array $params      Parameters to pass to the diffing engine.
         *                           Normally an array of two arrays, each
         *                           containing the lines from a file.
         */
        function __construct($engine, $params)
        {
        }
        /**
         * PHP4 constructor.
         */
        public function Text_Diff($engine, $params)
        {
        }
        /**
         * Returns the array of differences.
         */
        function getDiff()
        {
        }
        /**
         * returns the number of new (added) lines in a given diff.
         *
         * @since Text_Diff 1.1.0
         *
         * @return int The number of new lines
         */
        function countAddedLines()
        {
        }
        /**
         * Returns the number of deleted (removed) lines in a given diff.
         *
         * @since Text_Diff 1.1.0
         *
         * @return int The number of deleted lines
         */
        function countDeletedLines()
        {
        }
        /**
         * Computes a reversed diff.
         *
         * Example:
         * <code>
         * $diff = new Text_Diff($lines1, $lines2);
         * $rev = $diff->reverse();
         * </code>
         *
         * @return Text_Diff  A Diff object representing the inverse of the
         *                    original diff.  Note that we purposely don't return a
         *                    reference here, since this essentially is a clone()
         *                    method.
         */
        function reverse()
        {
        }
        /**
         * Checks for an empty diff.
         *
         * @return bool True if two sequences were identical.
         */
        function isEmpty()
        {
        }
        /**
         * Computes the length of the Longest Common Subsequence (LCS).
         *
         * This is mostly for diagnostic purposes.
         *
         * @return int The length of the LCS.
         */
        function lcs()
        {
        }
        /**
         * Gets the original set of lines.
         *
         * This reconstructs the $from_lines parameter passed to the constructor.
         *
         * @return array  The original sequence of strings.
         */
        function getOriginal()
        {
        }
        /**
         * Gets the final set of lines.
         *
         * This reconstructs the $to_lines parameter passed to the constructor.
         *
         * @return array  The sequence of strings.
         */
        function getFinal()
        {
        }
        /**
         * Removes trailing newlines from a line of text. This is meant to be used
         * with array_walk().
         *
         * @param string $line  The line to trim.
         * @param int    $key   The index of the line in the array. Not used.
         */
        static function trimNewlines(&$line, $key)
        {
        }
        /**
         * Determines the location of the system temporary directory.
         *
         * @access protected
         *
         * @return string  A directory name which can be used for temp files.
         *                 Returns false if one could not be found.
         */
        static function _getTempDir()
        {
        }
        /**
         * Checks a diff for validity.
         *
         * This is here only for debugging purposes.
         */
        function _check($from_lines, $to_lines)
        {
        }
    }
    /**
     * @package Text_Diff
     * @author  Geoffrey T. Dairiki <dairiki@dairiki.org>
     */
    class Text_MappedDiff extends \Text_Diff
    {
        /**
         * Computes a diff between sequences of strings.
         *
         * This can be used to compute things like case-insensitive diffs, or diffs
         * which ignore changes in white-space.
         *
         * @param array $from_lines         An array of strings.
         * @param array $to_lines           An array of strings.
         * @param array $mapped_from_lines  This array should have the same size
         *                                  number of elements as $from_lines.  The
         *                                  elements in $mapped_from_lines and
         *                                  $mapped_to_lines are what is actually
         *                                  compared when computing the diff.
         * @param array $mapped_to_lines    This array should have the same number
         *                                  of elements as $to_lines.
         */
        function __construct($from_lines, $to_lines, $mapped_from_lines, $mapped_to_lines)
        {
        }
        /**
         * PHP4 constructor.
         */
        public function Text_MappedDiff($from_lines, $to_lines, $mapped_from_lines, $mapped_to_lines)
        {
        }
    }
    /**
     * @package Text_Diff
     * @author  Geoffrey T. Dairiki <dairiki@dairiki.org>
     *
     * @access private
     */
    abstract class Text_Diff_Op
    {
        var $orig;
        var $final;
        abstract function &reverse();
        function norig()
        {
        }
        function nfinal()
        {
        }
    }
    /**
     * @package Text_Diff
     * @author  Geoffrey T. Dairiki <dairiki@dairiki.org>
     *
     * @access private
     */
    class Text_Diff_Op_copy extends \Text_Diff_Op
    {
        /**
         * PHP5 constructor.
         */
        function __construct($orig, $final = \false)
        {
        }
        /**
         * PHP4 constructor.
         */
        public function Text_Diff_Op_copy($orig, $final = \false)
        {
        }
        function &reverse()
        {
        }
    }
    /**
     * @package Text_Diff
     * @author  Geoffrey T. Dairiki <dairiki@dairiki.org>
     *
     * @access private
     */
    class Text_Diff_Op_delete extends \Text_Diff_Op
    {
        /**
         * PHP5 constructor.
         */
        function __construct($lines)
        {
        }
        /**
         * PHP4 constructor.
         */
        public function Text_Diff_Op_delete($lines)
        {
        }
        function &reverse()
        {
        }
    }
    /**
     * @package Text_Diff
     * @author  Geoffrey T. Dairiki <dairiki@dairiki.org>
     *
     * @access private
     */
    class Text_Diff_Op_add extends \Text_Diff_Op
    {
        /**
         * PHP5 constructor.
         */
        function __construct($lines)
        {
        }
        /**
         * PHP4 constructor.
         */
        public function Text_Diff_Op_add($lines)
        {
        }
        function &reverse()
        {
        }
    }
    /**
     * @package Text_Diff
     * @author  Geoffrey T. Dairiki <dairiki@dairiki.org>
     *
     * @access private
     */
    class Text_Diff_Op_change extends \Text_Diff_Op
    {
        /**
         * PHP5 constructor.
         */
        function __construct($orig, $final)
        {
        }
        /**
         * PHP4 constructor.
         */
        public function Text_Diff_Op_change($orig, $final)
        {
        }
        function &reverse()
        {
        }
    }
    /**
     * Class used internally by Text_Diff to actually compute the diffs.
     *
     * This class is implemented using native PHP code.
     *
     * The algorithm used here is mostly lifted from the perl module
     * Algorithm::Diff (version 1.06) by Ned Konz, which is available at:
     * https://cpan.metacpan.org/authors/id/N/NE/NEDKONZ/Algorithm-Diff-1.06.zip
     *
     * More ideas are taken from: http://www.ics.uci.edu/~eppstein/161/960229.html
     *
     * Some ideas (and a bit of code) are taken from analyze.c, of GNU
     * diffutils-2.7, which can be found at:
     * ftp://gnudist.gnu.org/pub/gnu/diffutils/diffutils-2.7.tar.gz
     *
     * Some ideas (subdivision by NCHUNKS > 2, and some optimizations) are from
     * Geoffrey T. Dairiki <dairiki@dairiki.org>. The original PHP version of this
     * code was written by him, and is used/adapted with his permission.
     *
     * Copyright 2004-2010 The Horde Project (http://www.horde.org/)
     *
     * See the enclosed file COPYING for license information (LGPL). If you did
     * not receive this file, see https://opensource.org/license/lgpl-2-1/.
     *
     * @author  Geoffrey T. Dairiki <dairiki@dairiki.org>
     * @package Text_Diff
     */
    class Text_Diff_Engine_native
    {
        public $xchanged;
        public $ychanged;
        public $xv;
        public $yv;
        public $xind;
        public $yind;
        public $seq;
        public $in_seq;
        public $lcs;
        function diff($from_lines, $to_lines)
        {
        }
        /**
         * Divides the Largest Common Subsequence (LCS) of the sequences (XOFF,
         * XLIM) and (YOFF, YLIM) into NCHUNKS approximately equally sized
         * segments.
         *
         * Returns (LCS, PTS).  LCS is the length of the LCS. PTS is an array of
         * NCHUNKS+1 (X, Y) indexes giving the diving points between sub
         * sequences.  The first sub-sequence is contained in (X0, X1), (Y0, Y1),
         * the second in (X1, X2), (Y1, Y2) and so on.  Note that (X0, Y0) ==
         * (XOFF, YOFF) and (X[NCHUNKS], Y[NCHUNKS]) == (XLIM, YLIM).
         *
         * This function assumes that the first lines of the specified portions of
         * the two files do not match, and likewise that the last lines do not
         * match.  The caller must trim matching lines from the beginning and end
         * of the portions it is going to specify.
         */
        function _diag($xoff, $xlim, $yoff, $ylim, $nchunks)
        {
        }
        function _lcsPos($ypos)
        {
        }
        /**
         * Finds LCS of two sequences.
         *
         * The results are recorded in the vectors $this->{x,y}changed[], by
         * storing a 1 in the element for each line that is an insertion or
         * deletion (ie. is not in the LCS).
         *
         * The subsequence of file 0 is (XOFF, XLIM) and likewise for file 1.
         *
         * Note that XLIM, YLIM are exclusive bounds.  All line numbers are
         * origin-0 and discarded lines are not counted.
         */
        function _compareseq($xoff, $xlim, $yoff, $ylim)
        {
        }
        /**
         * Adjusts inserts/deletes of identical lines to join changes as much as
         * possible.
         *
         * We do something when a run of changed lines include a line at one end
         * and has an excluded, identical line at the other.  We are free to
         * choose which identical line is included.  `compareseq' usually chooses
         * the one at the beginning, but usually it is cleaner to consider the
         * following identical line to be the "change".
         *
         * This is extracted verbatim from analyze.c (GNU diffutils-2.7).
         */
        function _shiftBoundaries($lines, &$changed, $other_changed)
        {
        }
    }
    /**
     * Class used internally by Diff to actually compute the diffs.
     *
     * This class uses the Unix `diff` program via shell_exec to compute the
     * differences between the two input arrays.
     *
     * Copyright 2007-2010 The Horde Project (http://www.horde.org/)
     *
     * See the enclosed file COPYING for license information (LGPL). If you did
     * not receive this file, see https://opensource.org/license/lgpl-2-1/.
     *
     * @author  Milian Wolff <mail@milianw.de>
     * @package Text_Diff
     * @since   0.3.0
     */
    class Text_Diff_Engine_shell
    {
        /**
         * Path to the diff executable
         *
         * @var string
         */
        var $_diffCommand = 'diff';
        /**
         * Returns the array of differences.
         *
         * @param array $from_lines lines of text from old file
         * @param array $to_lines   lines of text from new file
         *
         * @return array all changes made (array with Text_Diff_Op_* objects)
         */
        function diff($from_lines, $to_lines)
        {
        }
        /**
         * Get lines from either the old or new text
         *
         * @access private
         *
         * @param array $text_lines Either $from_lines or $to_lines (passed by reference).
         * @param int   $line_no    Current line number (passed by reference).
         * @param int   $end        Optional end line, when we want to chop more
         *                          than one line.
         *
         * @return array The chopped lines
         */
        function _getLines(&$text_lines, &$line_no, $end = \false)
        {
        }
    }
    /**
     * Parses unified or context diffs output from eg. the diff utility.
     *
     * Example:
     * <code>
     * $patch = file_get_contents('example.patch');
     * $diff = new Text_Diff('string', array($patch));
     * $renderer = new Text_Diff_Renderer_inline();
     * echo $renderer->render($diff);
     * </code>
     *
     * Copyright 2005 Örjan Persson <o@42mm.org>
     * Copyright 2005-2010 The Horde Project (http://www.horde.org/)
     *
     * See the enclosed file COPYING for license information (LGPL). If you did
     * not receive this file, see https://opensource.org/license/lgpl-2-1/.
     *
     * @author  Örjan Persson <o@42mm.org>
     * @package Text_Diff
     * @since   0.2.0
     */
    class Text_Diff_Engine_string
    {
        /**
         * Parses a unified or context diff.
         *
         * First param contains the whole diff and the second can be used to force
         * a specific diff type. If the second parameter is 'autodetect', the
         * diff will be examined to find out which type of diff this is.
         *
         * @param string $diff  The diff content.
         * @param string $mode  The diff mode of the content in $diff. One of
         *                      'context', 'unified', or 'autodetect'.
         *
         * @return array  List of all diff operations.
         * @phpstan-param 'context'|'unified'|'autodetect' $mode
         */
        function diff($diff, $mode = 'autodetect')
        {
        }
        /**
         * Parses an array containing the unified diff.
         *
         * @param array $diff  Array of lines.
         *
         * @return array  List of all diff operations.
         */
        function parseUnifiedDiff($diff)
        {
        }
        /**
         * Parses an array containing the context diff.
         *
         * @param array $diff  Array of lines.
         *
         * @return array  List of all diff operations.
         */
        function parseContextDiff(&$diff)
        {
        }
    }
    /**
     * Class used internally by Diff to actually compute the diffs.
     *
     * This class uses the xdiff PECL package (http://pecl.php.net/package/xdiff)
     * to compute the differences between the two input arrays.
     *
     * Copyright 2004-2010 The Horde Project (http://www.horde.org/)
     *
     * See the enclosed file COPYING for license information (LGPL). If you did
     * not receive this file, see https://opensource.org/license/lgpl-2-1/.
     *
     * @author  Jon Parise <jon@horde.org>
     * @package Text_Diff
     */
    class Text_Diff_Engine_xdiff
    {
        /**
         */
        function diff($from_lines, $to_lines)
        {
        }
    }
    /**
     * A class to render Diffs in different formats.
     *
     * This class renders the diff in classic diff format. It is intended that
     * this class be customized via inheritance, to obtain fancier outputs.
     *
     * Copyright 2004-2010 The Horde Project (http://www.horde.org/)
     *
     * See the enclosed file COPYING for license information (LGPL). If you did
     * not receive this file, see https://opensource.org/license/lgpl-2-1/.
     *
     * @package Text_Diff
     */
    class Text_Diff_Renderer
    {
        /**
         * Number of leading context "lines" to preserve.
         *
         * This should be left at zero for this class, but subclasses may want to
         * set this to other values.
         */
        var $_leading_context_lines = 0;
        /**
         * Number of trailing context "lines" to preserve.
         *
         * This should be left at zero for this class, but subclasses may want to
         * set this to other values.
         */
        var $_trailing_context_lines = 0;
        /**
         * Constructor.
         */
        function __construct($params = array())
        {
        }
        /**
         * PHP4 constructor.
         */
        public function Text_Diff_Renderer($params = array())
        {
        }
        /**
         * Get any renderer parameters.
         *
         * @return array  All parameters of this renderer object.
         */
        function getParams()
        {
        }
        /**
         * Renders a diff.
         *
         * @param Text_Diff $diff  A Text_Diff object.
         *
         * @return string  The formatted output.
         */
        function render($diff)
        {
        }
        function _block($xbeg, $xlen, $ybeg, $ylen, &$edits)
        {
        }
        function _startDiff()
        {
        }
        function _endDiff()
        {
        }
        function _blockHeader($xbeg, $xlen, $ybeg, $ylen)
        {
        }
        function _startBlock($header)
        {
        }
        function _endBlock()
        {
        }
        function _lines($lines, $prefix = ' ')
        {
        }
        function _context($lines)
        {
        }
        function _added($lines)
        {
        }
        function _deleted($lines)
        {
        }
        function _changed($orig, $final)
        {
        }
    }
    /**
     * "Inline" diff renderer.
     *
     * This class renders diffs in the Wiki-style "inline" format.
     *
     * @author  Ciprian Popovici
     * @package Text_Diff
     */
    class Text_Diff_Renderer_inline extends \Text_Diff_Renderer
    {
        /**
         * Number of leading context "lines" to preserve.
         *
         * @var integer
         */
        var $_leading_context_lines = 10000;
        /**
         * Number of trailing context "lines" to preserve.
         *
         * @var integer
         */
        var $_trailing_context_lines = 10000;
        /**
         * Prefix for inserted text.
         *
         * @var string
         */
        var $_ins_prefix = '<ins>';
        /**
         * Suffix for inserted text.
         *
         * @var string
         */
        var $_ins_suffix = '</ins>';
        /**
         * Prefix for deleted text.
         *
         * @var string
         */
        var $_del_prefix = '<del>';
        /**
         * Suffix for deleted text.
         *
         * @var string
         */
        var $_del_suffix = '</del>';
        /**
         * Header for each change block.
         *
         * @var string
         */
        var $_block_header = '';
        /**
         * Whether to split down to character-level.
         *
         * @var boolean
         */
        var $_split_characters = \false;
        /**
         * What are we currently splitting on? Used to recurse to show word-level
         * or character-level changes.
         *
         * @var string
         */
        var $_split_level = 'lines';
        function _blockHeader($xbeg, $xlen, $ybeg, $ylen)
        {
        }
        function _startBlock($header)
        {
        }
        function _lines($lines, $prefix = ' ', $encode = \true)
        {
        }
        function _added($lines)
        {
        }
        function _deleted($lines, $words = \false)
        {
        }
        function _changed($orig, $final)
        {
        }
        function _splitOnWords($string, $newlineEscape = "\n")
        {
        }
        function _encode(&$string)
        {
        }
    }
    /**
     * Exception for errors from the Text_Diff package.
     *
     * {@internal This is a WP native addition to the external Text_Diff package.}
     *
     * @package WordPress
     * @subpackage Text_Diff
     */
    class Text_Exception extends \Exception
    {
    }
    /**
     * Structure that store common Atom Feed Properties
     *
     * @package AtomLib
     */
    class AtomFeed
    {
        /**
         * Stores Links
         * @var array
         * @access public
         */
        var $links = array();
        /**
         * Stores Categories
         * @var array
         * @access public
         */
        var $categories = array();
        /**
         * Stores Entries
         *
         * @var array
         * @access public
         */
        var $entries = array();
    }
    /**
     * Structure that store Atom Entry Properties
     *
     * @package AtomLib
     */
    class AtomEntry
    {
        /**
         * Stores Links
         * @var array
         * @access public
         */
        var $links = array();
        /**
         * Stores Categories
         * @var array
         * @access public
         */
        var $categories = array();
    }
    /**
     * AtomLib Atom Parser API
     *
     * @package AtomLib
     */
    class AtomParser
    {
        var $NS = 'http://www.w3.org/2005/Atom';
        var $ATOM_CONTENT_ELEMENTS = array('content', 'summary', 'title', 'subtitle', 'rights');
        var $ATOM_SIMPLE_ELEMENTS = array('id', 'updated', 'published', 'draft');
        var $debug = \false;
        var $depth = 0;
        var $indent = 2;
        var $in_content;
        var $ns_contexts = array();
        var $ns_decls = array();
        var $content_ns_decls = array();
        var $content_ns_contexts = array();
        var $is_xhtml = \false;
        var $is_html = \false;
        var $is_text = \true;
        var $skipped_div = \false;
        var $FILE = "php://input";
        var $feed;
        var $current;
        var $map_attrs_func;
        var $map_xmlns_func;
        var $error;
        var $content;
        /**
         * PHP5 constructor.
         */
        function __construct()
        {
        }
        /**
         * PHP4 constructor.
         */
        public function AtomParser()
        {
        }
        /**
         * Map attributes to key="val"
         *
         * @param string $k Key
         * @param string $v Value
         * @return string
         */
        public static function map_attrs($k, $v)
        {
        }
        /**
         * Map XML namespace to string.
         *
         * @param indexish $p XML Namespace element index
         * @param array $n Two-element array pair. [ 0 => {namespace}, 1 => {url} ]
         * @return string 'xmlns="{url}"' or 'xmlns:{namespace}="{url}"'
         */
        public static function map_xmlns($p, $n)
        {
        }
        function _p($msg)
        {
        }
        function error_handler($log_level, $log_text, $error_file, $error_line)
        {
        }
        function parse()
        {
        }
        function start_element($parser, $name, $attrs)
        {
        }
        function end_element($parser, $name)
        {
        }
        function start_ns($parser, $prefix, $uri)
        {
        }
        function end_ns($parser, $prefix)
        {
        }
        function cdata($parser, $data)
        {
        }
        function _default($parser, $data)
        {
        }
        function ns_to_prefix($qname, $attr = \false)
        {
        }
        function is_declared_content_ns($new_mapping)
        {
        }
        function xml_escape($content)
        {
        }
    }
    /**
     * Helper functions used to render the navigation block.
     *
     * @since 6.5.0
     */
    class WP_Navigation_Block_Renderer
    {
        /**
         * Renders the navigation block.
         *
         * @since 6.5.0
         *
         * @param array    $attributes The block attributes.
         * @param string   $content    The saved content.
         * @param WP_Block $block      The parsed block.
         * @return string Returns the navigation block markup.
         */
        public static function render($attributes, $content, $block)
        {
        }
    }
}
namespace Avifinfo {
    class Tile
    {
        public $tile_item_id;
        public $parent_item_id;
    }
    class Prop
    {
        public $property_index;
        public $item_id;
    }
    class Dim_Prop
    {
        public $property_index;
        public $width;
        public $height;
    }
    class Chan_Prop
    {
        public $property_index;
        public $bit_depth;
        public $num_channels;
    }
    class Features
    {
        public $has_primary_item = false;
        public $has_alpha = false;
        public $primary_item_id;
        public $primary_item_features = array(
            // Deduced from the data below.
            'width' => UNDEFINED,
            // In number of pixels.
            'height' => UNDEFINED,
            // Ignores mirror and rotation.
            'bit_depth' => UNDEFINED,
            // Likely 8, 10 or 12 bits per channel per pixel.
            'num_channels' => UNDEFINED,
        );
        public $tiles = array();
        public $props = array();
        public $dim_props = array();
        public $chan_props = array();
        /**
         * Finds the width, height, bit depth and number of channels of the primary item.
         *
         * @return Status FOUND on success or NOT_FOUND on failure.
         */
        public function get_primary_item_features()
        {
        }
    }
    class Box
    {
        public $size;
        public $type;
        public $version;
        public $flags;
        public $content_size;
        /**
         * Reads the box header.
         *
         * @param stream  $handle              The resource the header will be parsed from.
         * @param int     $num_parsed_boxes    The total number of parsed boxes. Prevents timeouts.
         * @param int     $num_remaining_bytes The number of bytes that should be available from the resource.
         * @return Status                      FOUND on success or an error on failure.
         */
        public function parse($handle, &$num_parsed_boxes, $num_remaining_bytes = MAX_SIZE)
        {
        }
    }
    class Parser
    {
        public $features;
        function __construct($handle)
        {
        }
        /**
         * Parses a file stream.
         *
         * The file type is checked through the "ftyp" box.
         *
         * @return bool True if the input stream is an AVIF bitstream or false.
         */
        public function parse_ftyp()
        {
        }
        /**
         * Parses a file stream.
         *
         * Features are extracted from the "meta" box.
         *
         * @return bool True if the main features of the primary item were parsed or false.
         */
        public function parse_file()
        {
        }
    }
}
namespace {
    /**
     * Portable PHP password hashing framework.
     *
     * @package phpass
     * @version 0.5 / WordPress
     * @link https://www.openwall.com/phpass/
     * @since 2.5.0
     */
    class PasswordHash
    {
        var $itoa64;
        var $iteration_count_log2;
        var $portable_hashes;
        var $random_state;
        function __construct($iteration_count_log2, $portable_hashes)
        {
        }
        function PasswordHash($iteration_count_log2, $portable_hashes)
        {
        }
        function get_random_bytes($count)
        {
        }
        function encode64($input, $count)
        {
        }
        function gensalt_private($input)
        {
        }
        function crypt_private($password, $setting)
        {
        }
        function gensalt_blowfish($input)
        {
        }
        function HashPassword($password)
        {
        }
        function CheckPassword($password, $stored_hash)
        {
        }
    }
    /**
     * mail_fetch/setup.php
     *
     * Copyright (c) 1999-2011 CDI (cdi@thewebmasters.net) All Rights Reserved
     * Modified by Philippe Mingo 2001-2009 mingo@rotedic.com
     * An RFC 1939 compliant wrapper class for the POP3 protocol.
     *
     * Licensed under the GNU GPL. For full terms see the file COPYING.
     *
     * POP3 class
     *
     * @copyright 1999-2011 The SquirrelMail Project Team
     * @license https://opensource.org/licenses/gpl-license.php GNU Public License
     * @package plugins
     * @subpackage mail_fetch
     */
    class POP3
    {
        var $ERROR = '';
        var $TIMEOUT = 60;
        var $COUNT = -1;
        var $BUFFER = 512;
        var $FP = '';
        var $MAILSERVER = '';
        var $DEBUG = \FALSE;
        var $BANNER = '';
        var $ALLOWAPOP = \FALSE;
        /**
         * PHP5 constructor.
         */
        function __construct($server = '', $timeout = '')
        {
        }
        /**
         * PHP4 constructor.
         */
        public function POP3($server = '', $timeout = '')
        {
        }
        function update_timer()
        {
        }
        function connect($server, $port = 110)
        {
        }
        function user($user = "")
        {
        }
        function pass($pass = "")
        {
        }
        function apop($login, $pass)
        {
        }
        function login($login = "", $pass = "")
        {
        }
        function top($msgNum, $numLines = "0")
        {
        }
        function pop_list($msgNum = "")
        {
        }
        function get($msgNum)
        {
        }
        function last($type = "count")
        {
        }
        function reset()
        {
        }
        function send_cmd($cmd = "")
        {
        }
        function quit()
        {
        }
        function popstat()
        {
        }
        function uidl($msgNum = "")
        {
        }
        function delete($msgNum = "")
        {
        }
        function is_ok($cmd = "")
        {
        }
        function strip_clf($text = "")
        {
        }
        function parse_banner($server_text)
        {
        }
    }
    /**
     * Requests for PHP
     *
     * Inspired by Requests for Python.
     *
     * Based on concepts from SimplePie_File, RequestCore and WP_Http.
     *
     * @package Requests
     *
     * @deprecated 6.2.0 Use `WpOrg\Requests\Requests` instead for the actual functionality and
     *                   use `WpOrg\Requests\Autoload` for the autoloading.
     */
    class Requests extends \WpOrg\Requests\Requests
    {
        /**
         * Deprecated autoloader for Requests.
         *
         * @deprecated 6.2.0 Use the `WpOrg\Requests\Autoload::load()` method instead.
         *
         * @codeCoverageIgnore
         *
         * @param string $class Class name to load
         */
        public static function autoloader($class)
        {
        }
        /**
         * Register the built-in autoloader
         *
         * @deprecated 6.2.0 Include the `WpOrg\Requests\Autoload` class and
         *                   call `WpOrg\Requests\Autoload::register()` instead.
         *
         * @codeCoverageIgnore
         */
        public static function register_autoloader()
        {
        }
    }
    /**
     * Core class used to create an HTML dropdown list of Categories.
     *
     * @since 2.1.0
     *
     * @see Walker
     */
    class Walker_CategoryDropdown extends \Walker
    {
        /**
         * What the class handles.
         *
         * @since 2.1.0
         * @var string
         *
         * @see Walker::$tree_type
         */
        public $tree_type = 'category';
        /**
         * Database fields to use.
         *
         * @since 2.1.0
         * @todo Decouple this
         * @var string[]
         *
         * @see Walker::$db_fields
         */
        public $db_fields = array('parent' => 'parent', 'id' => 'term_id');
        /**
         * Starts the element output.
         *
         * @since 2.1.0
         * @since 5.9.0 Renamed `$category` to `$data_object` and `$id` to `$current_object_id`
         *              to match parent class for PHP 8 named parameter support.
         *
         * @see Walker::start_el()
         *
         * @param string  $output            Used to append additional content (passed by reference).
         * @param WP_Term $data_object       Category data object.
         * @param int     $depth             Depth of category. Used for padding.
         * @param array   $args              Uses 'selected', 'show_count', and 'value_field' keys, if they exist.
         *                                   See wp_dropdown_categories().
         * @param int     $current_object_id Optional. ID of the current category. Default 0.
         * @phpstan-param array{
         *   show_option_all?: string,
         *   show_option_none?: string,
         *   option_none_value?: string,
         *   orderby?: string,
         *   pad_counts?: bool,
         *   show_count?: bool|int,
         *   echo?: bool|int,
         *   hierarchical?: bool|int,
         *   depth?: int,
         *   tab_index?: int,
         *   name?: string,
         *   id?: string,
         *   class?: string,
         *   selected?: int|string,
         *   value_field?: string,
         *   taxonomy?: string|array,
         *   hide_if_empty?: bool,
         *   required?: bool,
         *   walker?: Walker,
         *   aria_describedby?: string,
         * } $args See wp_dropdown_categories()
         */
        public function start_el(&$output, $data_object, $depth = 0, $args = array(), $current_object_id = 0)
        {
        }
    }
    /**
     * Core class used to create an HTML list of categories.
     *
     * @since 2.1.0
     *
     * @see Walker
     */
    class Walker_Category extends \Walker
    {
        /**
         * What the class handles.
         *
         * @since 2.1.0
         * @var string
         *
         * @see Walker::$tree_type
         */
        public $tree_type = 'category';
        /**
         * Database fields to use.
         *
         * @since 2.1.0
         * @var string[]
         *
         * @see Walker::$db_fields
         * @todo Decouple this
         */
        public $db_fields = array('parent' => 'parent', 'id' => 'term_id');
        /**
         * Starts the list before the elements are added.
         *
         * @since 2.1.0
         *
         * @see Walker::start_lvl()
         *
         * @param string $output Used to append additional content. Passed by reference.
         * @param int    $depth  Optional. Depth of category. Used for tab indentation. Default 0.
         * @param array  $args   Optional. An array of arguments. Will only append content if style argument
         *                       value is 'list'. See wp_list_categories(). Default empty array.
         * @phpstan-param array{
         *   current_category?: int|int[],
         *   depth?: int,
         *   echo?: bool|int,
         *   exclude?: int[]|string,
         *   exclude_tree?: int[]|string,
         *   feed?: string,
         *   feed_image?: string,
         *   feed_type?: string,
         *   hide_title_if_empty?: bool,
         *   separator?: string,
         *   show_count?: bool|int,
         *   show_option_all?: string,
         *   show_option_none?: string,
         *   style?: string,
         *   taxonomy?: string,
         *   title_li?: string,
         *   use_desc_for_title?: bool|int,
         *   walker?: Walker,
         * } $args See wp_list_categories()
         * @phpstan-return void
         */
        public function start_lvl(&$output, $depth = 0, $args = array())
        {
        }
        /**
         * Ends the list of after the elements are added.
         *
         * @since 2.1.0
         *
         * @see Walker::end_lvl()
         *
         * @param string $output Used to append additional content. Passed by reference.
         * @param int    $depth  Optional. Depth of category. Used for tab indentation. Default 0.
         * @param array  $args   Optional. An array of arguments. Will only append content if style argument
         *                       value is 'list'. See wp_list_categories(). Default empty array.
         * @phpstan-param array{
         *   current_category?: int|int[],
         *   depth?: int,
         *   echo?: bool|int,
         *   exclude?: int[]|string,
         *   exclude_tree?: int[]|string,
         *   feed?: string,
         *   feed_image?: string,
         *   feed_type?: string,
         *   hide_title_if_empty?: bool,
         *   separator?: string,
         *   show_count?: bool|int,
         *   show_option_all?: string,
         *   show_option_none?: string,
         *   style?: string,
         *   taxonomy?: string,
         *   title_li?: string,
         *   use_desc_for_title?: bool|int,
         *   walker?: Walker,
         * } $args See wp_list_categories()
         * @phpstan-return void
         */
        public function end_lvl(&$output, $depth = 0, $args = array())
        {
        }
        /**
         * Starts the element output.
         *
         * @since 2.1.0
         * @since 5.9.0 Renamed `$category` to `$data_object` and `$id` to `$current_object_id`
         *              to match parent class for PHP 8 named parameter support.
         *
         * @see Walker::start_el()
         *
         * @param string  $output            Used to append additional content (passed by reference).
         * @param WP_Term $data_object       Category data object.
         * @param int     $depth             Optional. Depth of category in reference to parents. Default 0.
         * @param array   $args              Optional. An array of arguments. See wp_list_categories().
         *                                   Default empty array.
         * @param int     $current_object_id Optional. ID of the current category. Default 0.
         * @phpstan-param array{
         *   current_category?: int|int[],
         *   depth?: int,
         *   echo?: bool|int,
         *   exclude?: int[]|string,
         *   exclude_tree?: int[]|string,
         *   feed?: string,
         *   feed_image?: string,
         *   feed_type?: string,
         *   hide_title_if_empty?: bool,
         *   separator?: string,
         *   show_count?: bool|int,
         *   show_option_all?: string,
         *   show_option_none?: string,
         *   style?: string,
         *   taxonomy?: string,
         *   title_li?: string,
         *   use_desc_for_title?: bool|int,
         *   walker?: Walker,
         * } $args See wp_list_categories()
         * @phpstan-return void
         */
        public function start_el(&$output, $data_object, $depth = 0, $args = array(), $current_object_id = 0)
        {
        }
        /**
         * Ends the element output, if needed.
         *
         * @since 2.1.0
         * @since 5.9.0 Renamed `$page` to `$data_object` to match parent class for PHP 8 named parameter support.
         *
         * @see Walker::end_el()
         *
         * @param string $output      Used to append additional content (passed by reference).
         * @param object $data_object Category data object. Not used.
         * @param int    $depth       Optional. Depth of category. Not used.
         * @param array  $args        Optional. An array of arguments. Only uses 'list' for whether should
         *                            append to output. See wp_list_categories(). Default empty array.
         * @phpstan-param array{
         *   current_category?: int|int[],
         *   depth?: int,
         *   echo?: bool|int,
         *   exclude?: int[]|string,
         *   exclude_tree?: int[]|string,
         *   feed?: string,
         *   feed_image?: string,
         *   feed_type?: string,
         *   hide_title_if_empty?: bool,
         *   separator?: string,
         *   show_count?: bool|int,
         *   show_option_all?: string,
         *   show_option_none?: string,
         *   style?: string,
         *   taxonomy?: string,
         *   title_li?: string,
         *   use_desc_for_title?: bool|int,
         *   walker?: Walker,
         * } $args See wp_list_categories()
         * @phpstan-return void
         */
        public function end_el(&$output, $data_object, $depth = 0, $args = array())
        {
        }
    }
    /**
     * Core walker class used to create an HTML list of comments.
     *
     * @since 2.7.0
     *
     * @see Walker
     */
    class Walker_Comment extends \Walker
    {
        /**
         * What the class handles.
         *
         * @since 2.7.0
         * @var string
         *
         * @see Walker::$tree_type
         */
        public $tree_type = 'comment';
        /**
         * Database fields to use.
         *
         * @since 2.7.0
         * @var string[]
         *
         * @see Walker::$db_fields
         * @todo Decouple this
         */
        public $db_fields = array('parent' => 'comment_parent', 'id' => 'comment_ID');
        /**
         * Starts the list before the elements are added.
         *
         * @since 2.7.0
         *
         * @see Walker::start_lvl()
         * @global int $comment_depth
         *
         * @param string $output Used to append additional content (passed by reference).
         * @param int    $depth  Optional. Depth of the current comment. Default 0.
         * @param array  $args   Optional. Uses 'style' argument for type of HTML list. Default empty array.
         */
        public function start_lvl(&$output, $depth = 0, $args = array())
        {
        }
        /**
         * Ends the list of items after the elements are added.
         *
         * @since 2.7.0
         *
         * @see Walker::end_lvl()
         * @global int $comment_depth
         *
         * @param string $output Used to append additional content (passed by reference).
         * @param int    $depth  Optional. Depth of the current comment. Default 0.
         * @param array  $args   Optional. Will only append content if style argument value is 'ol' or 'ul'.
         *                       Default empty array.
         */
        public function end_lvl(&$output, $depth = 0, $args = array())
        {
        }
        /**
         * Traverses elements to create list from elements.
         *
         * This function is designed to enhance Walker::display_element() to
         * display children of higher nesting levels than selected inline on
         * the highest depth level displayed. This prevents them being orphaned
         * at the end of the comment list.
         *
         * Example: max_depth = 2, with 5 levels of nested content.
         *     1
         *      1.1
         *        1.1.1
         *        1.1.1.1
         *        1.1.1.1.1
         *        1.1.2
         *        1.1.2.1
         *     2
         *      2.2
         *
         * @since 2.7.0
         *
         * @see Walker::display_element()
         * @see wp_list_comments()
         *
         * @param WP_Comment $element           Comment data object.
         * @param array      $children_elements List of elements to continue traversing. Passed by reference.
         * @param int        $max_depth         Max depth to traverse.
         * @param int        $depth             Depth of the current element.
         * @param array      $args              An array of arguments.
         * @param string     $output            Used to append additional content. Passed by reference.
         * @phpstan-return void
         */
        public function display_element($element, &$children_elements, $max_depth, $depth, $args, &$output)
        {
        }
        /**
         * Starts the element output.
         *
         * @since 2.7.0
         * @since 5.9.0 Renamed `$comment` to `$data_object` and `$id` to `$current_object_id`
         *              to match parent class for PHP 8 named parameter support.
         *
         * @see Walker::start_el()
         * @see wp_list_comments()
         * @global int        $comment_depth
         * @global WP_Comment $comment       Global comment object.
         *
         * @param string     $output            Used to append additional content. Passed by reference.
         * @param WP_Comment $data_object       Comment data object.
         * @param int        $depth             Optional. Depth of the current comment in reference to parents. Default 0.
         * @param array      $args              Optional. An array of arguments. Default empty array.
         * @param int        $current_object_id Optional. ID of the current comment. Default 0.
         * @phpstan-return void
         */
        public function start_el(&$output, $data_object, $depth = 0, $args = array(), $current_object_id = 0)
        {
        }
        /**
         * Ends the element output, if needed.
         *
         * @since 2.7.0
         * @since 5.9.0 Renamed `$comment` to `$data_object` to match parent class for PHP 8 named parameter support.
         *
         * @see Walker::end_el()
         * @see wp_list_comments()
         *
         * @param string     $output      Used to append additional content. Passed by reference.
         * @param WP_Comment $data_object Comment data object.
         * @param int        $depth       Optional. Depth of the current comment. Default 0.
         * @param array      $args        Optional. An array of arguments. Default empty array.
         * @phpstan-return void
         */
        public function end_el(&$output, $data_object, $depth = 0, $args = array())
        {
        }
        /**
         * Outputs a pingback comment.
         *
         * @since 3.6.0
         *
         * @see wp_list_comments()
         *
         * @param WP_Comment $comment The comment object.
         * @param int        $depth   Depth of the current comment.
         * @param array      $args    An array of arguments.
         */
        protected function ping($comment, $depth, $args)
        {
        }
        /**
         * Filters the comment text.
         *
         * Removes links from the pending comment's text if the commenter did not consent
         * to the comment cookies.
         *
         * @since 5.4.2
         *
         * @param string          $comment_text Text of the current comment.
         * @param WP_Comment|null $comment      The comment object. Null if not found.
         * @return string Filtered text of the current comment.
         */
        public function filter_comment_text($comment_text, $comment)
        {
        }
        /**
         * Outputs a single comment.
         *
         * @since 3.6.0
         *
         * @see wp_list_comments()
         *
         * @param WP_Comment $comment Comment to display.
         * @param int        $depth   Depth of the current comment.
         * @param array      $args    An array of arguments.
         */
        protected function comment($comment, $depth, $args)
        {
        }
        /**
         * Outputs a comment in the HTML5 format.
         *
         * @since 3.6.0
         *
         * @see wp_list_comments()
         *
         * @param WP_Comment $comment Comment to display.
         * @param int        $depth   Depth of the current comment.
         * @param array      $args    An array of arguments.
         */
        protected function html5_comment($comment, $depth, $args)
        {
        }
    }
    /**
     * Core class used to create an HTML drop-down list of pages.
     *
     * @since 2.1.0
     *
     * @see Walker
     */
    class Walker_PageDropdown extends \Walker
    {
        /**
         * What the class handles.
         *
         * @since 2.1.0
         * @var string
         *
         * @see Walker::$tree_type
         */
        public $tree_type = 'page';
        /**
         * Database fields to use.
         *
         * @since 2.1.0
         * @var string[]
         *
         * @see Walker::$db_fields
         * @todo Decouple this
         */
        public $db_fields = array('parent' => 'post_parent', 'id' => 'ID');
        /**
         * Starts the element output.
         *
         * @since 2.1.0
         * @since 5.9.0 Renamed `$page` to `$data_object` and `$id` to `$current_object_id`
         *              to match parent class for PHP 8 named parameter support.
         *
         * @see Walker::start_el()
         *
         * @param string  $output            Used to append additional content. Passed by reference.
         * @param WP_Post $data_object       Page data object.
         * @param int     $depth             Optional. Depth of page in reference to parent pages.
         *                                   Used for padding. Default 0.
         * @param array   $args              Optional. Uses 'selected' argument for selected page to
         *                                   set selected HTML attribute for option element. Uses
         *                                   'value_field' argument to fill "value" attribute.
         *                                   See wp_dropdown_pages(). Default empty array.
         * @param int     $current_object_id Optional. ID of the current page. Default 0.
         * @phpstan-param array{
         *   depth?: int,
         *   child_of?: int,
         *   selected?: int|string,
         *   echo?: bool|int,
         *   name?: string,
         *   id?: string,
         *   class?: string,
         *   show_option_none?: string,
         *   show_option_no_change?: string,
         *   option_none_value?: string,
         *   value_field?: string,
         * } $args See wp_dropdown_pages()
         */
        public function start_el(&$output, $data_object, $depth = 0, $args = array(), $current_object_id = 0)
        {
        }
    }
    /**
     * Core walker class used to create an HTML list of pages.
     *
     * @since 2.1.0
     *
     * @see Walker
     */
    class Walker_Page extends \Walker
    {
        /**
         * What the class handles.
         *
         * @since 2.1.0
         * @var string
         *
         * @see Walker::$tree_type
         */
        public $tree_type = 'page';
        /**
         * Database fields to use.
         *
         * @since 2.1.0
         * @var string[]
         *
         * @see Walker::$db_fields
         * @todo Decouple this.
         */
        public $db_fields = array('parent' => 'post_parent', 'id' => 'ID');
        /**
         * Outputs the beginning of the current level in the tree before elements are output.
         *
         * @since 2.1.0
         *
         * @see Walker::start_lvl()
         *
         * @param string $output Used to append additional content (passed by reference).
         * @param int    $depth  Optional. Depth of page. Used for padding. Default 0.
         * @param array  $args   Optional. Arguments for outputting the next level.
         *                       Default empty array.
         */
        public function start_lvl(&$output, $depth = 0, $args = array())
        {
        }
        /**
         * Outputs the end of the current level in the tree after elements are output.
         *
         * @since 2.1.0
         *
         * @see Walker::end_lvl()
         *
         * @param string $output Used to append additional content (passed by reference).
         * @param int    $depth  Optional. Depth of page. Used for padding. Default 0.
         * @param array  $args   Optional. Arguments for outputting the end of the current level.
         *                       Default empty array.
         */
        public function end_lvl(&$output, $depth = 0, $args = array())
        {
        }
        /**
         * Outputs the beginning of the current element in the tree.
         *
         * @see Walker::start_el()
         * @since 2.1.0
         * @since 5.9.0 Renamed `$page` to `$data_object` and `$current_page` to `$current_object_id`
         *              to match parent class for PHP 8 named parameter support.
         *
         * @param string  $output            Used to append additional content. Passed by reference.
         * @param WP_Post $data_object       Page data object.
         * @param int     $depth             Optional. Depth of page. Used for padding. Default 0.
         * @param array   $args              Optional. Array of arguments. Default empty array.
         * @param int     $current_object_id Optional. ID of the current page. Default 0.
         */
        public function start_el(&$output, $data_object, $depth = 0, $args = array(), $current_object_id = 0)
        {
        }
        /**
         * Outputs the end of the current element in the tree.
         *
         * @since 2.1.0
         * @since 5.9.0 Renamed `$page` to `$data_object` to match parent class for PHP 8 named parameter support.
         *
         * @see Walker::end_el()
         *
         * @param string  $output      Used to append additional content. Passed by reference.
         * @param WP_Post $data_object Page data object. Not used.
         * @param int     $depth       Optional. Depth of page. Default 0 (unused).
         * @param array   $args        Optional. Array of arguments. Default empty array.
         */
        public function end_el(&$output, $data_object, $depth = 0, $args = array())
        {
        }
    }
    /**
     * Core class used to implement the Toolbar API.
     *
     * @since 3.1.0
     */
    #[\AllowDynamicProperties]
    class WP_Admin_Bar
    {
        public $user;
        /**
         * Deprecated menu property.
         *
         * @since 3.1.0
         * @deprecated 3.3.0 Modify admin bar nodes with WP_Admin_Bar::get_node(),
         *                   WP_Admin_Bar::add_node(), and WP_Admin_Bar::remove_node().
         * @var array
         */
        public $menu = array();
        /**
         * Initializes the admin bar.
         *
         * @since 3.1.0
         */
        public function initialize()
        {
        }
        /**
         * Adds a node (menu item) to the admin bar menu.
         *
         * @since 3.3.0
         *
         * @param array $node The attributes that define the node.
         */
        public function add_menu($node)
        {
        }
        /**
         * Removes a node from the admin bar.
         *
         * @since 3.1.0
         *
         * @param string $id The menu slug to remove.
         */
        public function remove_menu($id)
        {
        }
        /**
         * Adds a node to the menu.
         *
         * @since 3.1.0
         * @since 4.5.0 Added the ability to pass 'lang' and 'dir' meta data.
         * @since 6.5.0 Added the ability to pass 'menu_title' for an ARIA menu name.
         *
         * @param array $args {
         *     Arguments for adding a node.
         *
         *     @type string $id     ID of the item.
         *     @type string $title  Title of the node.
         *     @type string $parent Optional. ID of the parent node.
         *     @type string $href   Optional. Link for the item.
         *     @type bool   $group  Optional. Whether or not the node is a group. Default false.
         *     @type array  $meta   Meta data including the following keys: 'html', 'class', 'rel', 'lang', 'dir',
         *                          'onclick', 'target', 'title', 'tabindex', 'menu_title'. Default empty.
         * }
         * @phpstan-param array{
         *   id?: string,
         *   title?: string,
         *   parent?: string,
         *   href?: string,
         *   group?: bool,
         *   meta?: array,
         * } $args
         * @phpstan-return void
         */
        public function add_node($args)
        {
        }
        /**
         * @since 3.3.0
         *
         * @param array $args
         */
        final protected function _set_node($args)
        {
        }
        /**
         * Gets a node.
         *
         * @since 3.3.0
         *
         * @param string $id
         * @return object|void Node.
         */
        final public function get_node($id)
        {
        }
        /**
         * @since 3.3.0
         *
         * @param string $id
         * @return object|void
         */
        final protected function _get_node($id)
        {
        }
        /**
         * @since 3.3.0
         *
         * @return array|void
         */
        final public function get_nodes()
        {
        }
        /**
         * @since 3.3.0
         *
         * @return array|void
         */
        final protected function _get_nodes()
        {
        }
        /**
         * Adds a group to a toolbar menu node.
         *
         * Groups can be used to organize toolbar items into distinct sections of a toolbar menu.
         *
         * @since 3.3.0
         *
         * @param array $args {
         *     Array of arguments for adding a group.
         *
         *     @type string $id     ID of the item.
         *     @type string $parent Optional. ID of the parent node. Default 'root'.
         *     @type array  $meta   Meta data for the group including the following keys:
         *                         'class', 'onclick', 'target', and 'title'.
         * }
         * @phpstan-param array{
         *   id?: string,
         *   parent?: string,
         *   meta?: array,
         * } $args
         */
        final public function add_group($args)
        {
        }
        /**
         * Remove a node.
         *
         * @since 3.1.0
         *
         * @param string $id The ID of the item.
         */
        public function remove_node($id)
        {
        }
        /**
         * @since 3.3.0
         *
         * @param string $id
         */
        final protected function _unset_node($id)
        {
        }
        /**
         * @since 3.1.0
         */
        public function render()
        {
        }
        /**
         * @since 3.3.0
         *
         * @return object|void
         */
        final protected function _bind()
        {
        }
        /**
         * @since 3.3.0
         *
         * @param object $root
         */
        final protected function _render($root)
        {
        }
        /**
         * @since 3.3.0
         *
         * @param object $node
         * @phpstan-return void
         */
        final protected function _render_container($node)
        {
        }
        /**
         * @since 3.3.0
         * @since 6.5.0 Added `$menu_title` parameter to allow an ARIA menu name.
         *
         * @param object $node
         * @param string|bool $menu_title The accessible name of this ARIA menu or false if not provided.
         * @phpstan-return void
         */
        final protected function _render_group($node, $menu_title = \false)
        {
        }
        /**
         * @since 3.3.0
         *
         * @param object $node
         * @phpstan-return void
         */
        final protected function _render_item($node)
        {
        }
        /**
         * Renders toolbar items recursively.
         *
         * @since 3.1.0
         * @deprecated 3.3.0 Use WP_Admin_Bar::_render_item() or WP_Admin_bar::render() instead.
         * @see WP_Admin_Bar::_render_item()
         * @see WP_Admin_Bar::render()
         *
         * @param string $id    Unused.
         * @param object $node
         */
        public function recursive_render($id, $node)
        {
        }
        /**
         * Adds menus to the admin bar.
         *
         * @since 3.1.0
         */
        public function add_menus()
        {
        }
    }
    /**
     * Send XML response back to Ajax request.
     *
     * @package WordPress
     * @since 2.1.0
     */
    #[\AllowDynamicProperties]
    class WP_Ajax_Response
    {
        /**
         * Store XML responses to send.
         *
         * @since 2.1.0
         * @var array
         */
        public $responses = array();
        /**
         * Constructor - Passes args to WP_Ajax_Response::add().
         *
         * @since 2.1.0
         *
         * @see WP_Ajax_Response::add()
         *
         * @param string|array $args Optional. Will be passed to add() method.
         */
        public function __construct($args = '')
        {
        }
        /**
         * Appends data to an XML response based on given arguments.
         *
         * With `$args` defaults, extra data output would be:
         *
         *     <response action='{$action}_$id'>
         *      <$what id='$id' position='$position'>
         *          <response_data><![CDATA[$data]]></response_data>
         *      </$what>
         *     </response>
         *
         * @since 2.1.0
         *
         * @param string|array $args {
         *     Optional. An array or string of XML response arguments.
         *
         *     @type string          $what         XML-RPC response type. Used as a child element of `<response>`.
         *                                         Default 'object' (`<object>`).
         *     @type string|false    $action       Value to use for the `action` attribute in `<response>`. Will be
         *                                         appended with `_$id` on output. If false, `$action` will default to
         *                                         the value of `$_POST['action']`. Default false.
         *     @type int|WP_Error    $id           The response ID, used as the response type `id` attribute. Also
         *                                         accepts a `WP_Error` object if the ID does not exist. Default 0.
         *     @type int|false       $old_id       The previous response ID. Used as the value for the response type
         *                                         `old_id` attribute. False hides the attribute. Default false.
         *     @type string          $position     Value of the response type `position` attribute. Accepts 1 (bottom),
         *                                         -1 (top), HTML ID (after), or -HTML ID (before). Default 1 (bottom).
         *     @type string|WP_Error $data         The response content/message. Also accepts a WP_Error object if the
         *                                         ID does not exist. Default empty.
         *     @type array           $supplemental An array of extra strings that will be output within a `<supplemental>`
         *                                         element as CDATA. Default empty array.
         * }
         * @return string XML response.
         * @phpstan-param array{
         *   what?: string,
         *   action?: string|false,
         *   id?: int|WP_Error,
         *   old_id?: int|false,
         *   position?: string,
         *   data?: string|WP_Error,
         *   supplemental?: array,
         * } $args
         */
        public function add($args = '')
        {
        }
        /**
         * Display XML formatted responses.
         *
         * Sets the content type header to text/xml.
         *
         * @since 2.1.0
         */
        public function send()
        {
        }
    }
    /**
     * Class for displaying, modifying, and sanitizing application passwords.
     *
     * @package WordPress
     */
    #[\AllowDynamicProperties]
    class WP_Application_Passwords
    {
        /**
         * The application passwords user meta key.
         *
         * @since 5.6.0
         *
         * @var string
         */
        const USERMETA_KEY_APPLICATION_PASSWORDS = '_application_passwords';
        /**
         * The option name used to store whether application passwords are in use.
         *
         * @since 5.6.0
         *
         * @var string
         */
        const OPTION_KEY_IN_USE = 'using_application_passwords';
        /**
         * The generated application password length.
         *
         * @since 5.6.0
         *
         * @var int
         */
        const PW_LENGTH = 24;
        /**
         * Checks if application passwords are being used by the site.
         *
         * This returns true if at least one application password has ever been created.
         *
         * @since 5.6.0
         *
         * @return bool
         */
        public static function is_in_use()
        {
        }
        /**
         * Creates a new application password.
         *
         * @since 5.6.0
         * @since 5.7.0 Returns WP_Error if application name already exists.
         * @since 6.8.0 The hashed password value now uses wp_fast_hash() instead of phpass.
         *
         * @param int   $user_id  User ID.
         * @param array $args     {
         *     Arguments used to create the application password.
         *
         *     @type string $name   The name of the application password.
         *     @type string $app_id A UUID provided by the application to uniquely identify it.
         * }
         * @return array|WP_Error {
         *     Application password details, or a WP_Error instance if an error occurs.
         *
         *     @type string $0 The generated application password in plain text.
         *     @type array  $1 {
         *         The details about the created password.
         *
         *         @type string $uuid      The unique identifier for the application password.
         *         @type string $app_id    A UUID provided by the application to uniquely identify it.
         *         @type string $name      The name of the application password.
         *         @type string $password  A one-way hash of the password.
         *         @type int    $created   Unix timestamp of when the password was created.
         *         @type null   $last_used Null.
         *         @type null   $last_ip   Null.
         *     }
         * }
         * @phpstan-param array{
         *   name?: string,
         *   app_id?: string,
         * } $args
         * @phpstan-return \WP_Error|array{
         *   0: string,
         *   1: array{
         *     uuid: string,
         *     app_id: string,
         *     name: string,
         *     password: string,
         *     created: int,
         *     last_used: null,
         *     last_ip: null,
         *   },
         * }
         */
        public static function create_new_application_password($user_id, $args = array())
        {
        }
        /**
         * Gets a user's application passwords.
         *
         * @since 5.6.0
         *
         * @param int $user_id User ID.
         * @return array {
         *     The list of application passwords.
         *
         *     @type array ...$0 {
         *         @type string      $uuid      The unique identifier for the application password.
         *         @type string      $app_id    A UUID provided by the application to uniquely identify it.
         *         @type string      $name      The name of the application password.
         *         @type string      $password  A one-way hash of the password.
         *         @type int         $created   Unix timestamp of when the password was created.
         *         @type int|null    $last_used The Unix timestamp of the GMT date the application password was last used.
         *         @type string|null $last_ip   The IP address the application password was last used by.
         *     }
         * }
         * @phpstan-return array<int|string, array{
         *   uuid: string,
         *   app_id: string,
         *   name: string,
         *   password: string,
         *   created: int,
         *   last_used: int|null,
         *   last_ip: string|null,
         * }>
         */
        public static function get_user_application_passwords($user_id)
        {
        }
        /**
         * Gets a user's application password with the given UUID.
         *
         * @since 5.6.0
         *
         * @param int    $user_id User ID.
         * @param string $uuid    The password's UUID.
         * @return array|null {
         *     The application password if found, null otherwise.
         *
         *     @type string      $uuid      The unique identifier for the application password.
         *     @type string      $app_id    A UUID provided by the application to uniquely identify it.
         *     @type string      $name      The name of the application password.
         *     @type string      $password  A one-way hash of the password.
         *     @type int         $created   Unix timestamp of when the password was created.
         *     @type int|null    $last_used The Unix timestamp of the GMT date the application password was last used.
         *     @type string|null $last_ip   The IP address the application password was last used by.
         * }
         * @phpstan-return null|array{
         *   uuid: string,
         *   app_id: string,
         *   name: string,
         *   password: string,
         *   created: int,
         *   last_used: int|null,
         *   last_ip: string|null,
         * }
         */
        public static function get_user_application_password($user_id, $uuid)
        {
        }
        /**
         * Checks if an application password with the given name exists for this user.
         *
         * @since 5.7.0
         *
         * @param int    $user_id User ID.
         * @param string $name    Application name.
         * @return bool Whether the provided application name exists.
         */
        public static function application_name_exists_for_user($user_id, $name)
        {
        }
        /**
         * Updates an application password.
         *
         * @since 5.6.0
         * @since 6.8.0 The actual password should now be hashed using wp_fast_hash().
         *
         * @param int    $user_id User ID.
         * @param string $uuid    The password's UUID.
         * @param array  $update  {
         *     Information about the application password to update.
         *
         *     @type string      $uuid      The unique identifier for the application password.
         *     @type string      $app_id    A UUID provided by the application to uniquely identify it.
         *     @type string      $name      The name of the application password.
         *     @type string      $password  A one-way hash of the password.
         *     @type int         $created   Unix timestamp of when the password was created.
         *     @type int|null    $last_used The Unix timestamp of the GMT date the application password was last used.
         *     @type string|null $last_ip   The IP address the application password was last used by.
         * }
         * @return true|WP_Error True if successful, otherwise a WP_Error instance is returned on error.
         * @phpstan-param array{
         *   uuid?: string,
         *   app_id?: string,
         *   name?: string,
         *   password?: string,
         *   created?: int,
         *   last_used?: int|null,
         *   last_ip?: string|null,
         * } $update
         */
        public static function update_application_password($user_id, $uuid, $update = array())
        {
        }
        /**
         * Records that an application password has been used.
         *
         * @since 5.6.0
         *
         * @param int    $user_id User ID.
         * @param string $uuid    The password's UUID.
         * @return true|WP_Error True if the usage was recorded, a WP_Error if an error occurs.
         */
        public static function record_application_password_usage($user_id, $uuid)
        {
        }
        /**
         * Deletes an application password.
         *
         * @since 5.6.0
         *
         * @param int    $user_id User ID.
         * @param string $uuid    The password's UUID.
         * @return true|WP_Error Whether the password was successfully found and deleted, a WP_Error otherwise.
         */
        public static function delete_application_password($user_id, $uuid)
        {
        }
        /**
         * Deletes all application passwords for the given user.
         *
         * @since 5.6.0
         *
         * @param int $user_id User ID.
         * @return int|WP_Error The number of passwords that were deleted or a WP_Error on failure.
         */
        public static function delete_all_application_passwords($user_id)
        {
        }
        /**
         * Sets a user's application passwords.
         *
         * @since 5.6.0
         *
         * @param int   $user_id   User ID.
         * @param array $passwords {
         *     The list of application passwords.
         *
         *     @type array ...$0 {
         *         @type string      $uuid      The unique identifier for the application password.
         *         @type string      $app_id    A UUID provided by the application to uniquely identify it.
         *         @type string      $name      The name of the application password.
         *         @type string      $password  A one-way hash of the password.
         *         @type int         $created   Unix timestamp of when the password was created.
         *         @type int|null    $last_used The Unix timestamp of the GMT date the application password was last used.
         *         @type string|null $last_ip   The IP address the application password was last used by.
         *     }
         * }
         * @return int|bool User meta ID if the key didn't exist (ie. this is the first time that an application password
         *                  has been saved for the user), true on successful update, false on failure or if the value passed
         *                  is the same as the one that is already in the database.
         * @phpstan-param array<int|string, array{
         *   uuid: string,
         *   app_id: string,
         *   name: string,
         *   password: string,
         *   created: int,
         *   last_used: int|null,
         *   last_ip: string|null,
         * }> $passwords
         */
        protected static function set_user_application_passwords($user_id, $passwords)
        {
        }
        /**
         * Sanitizes and then splits a password into smaller chunks.
         *
         * @since 5.6.0
         *
         * @param string $raw_password The raw application password.
         * @return string The chunked password.
         */
        public static function chunk_password(
            #[\SensitiveParameter]
            $raw_password
        )
        {
        }
        /**
         * Hashes a plaintext application password.
         *
         * @since 6.8.0
         *
         * @param string $password Plaintext password.
         * @return string Hashed password.
         */
        public static function hash_password(
            #[\SensitiveParameter]
            string $password
        ): string
        {
        }
        /**
         * Checks a plaintext application password against a hashed password.
         *
         * @since 6.8.0
         *
         * @param string $password Plaintext password.
         * @param string $hash     Hash of the password to check against.
         * @return bool Whether the password matches the hashed password.
         */
        public static function check_password(
            #[\SensitiveParameter]
            string $password,
            string $hash
        ): bool
        {
        }
    }
    /**
     * Core class used for interacting with block bindings sources.
     *
     * @since 6.5.0
     */
    final class WP_Block_Bindings_Registry
    {
        /**
         * Registers a new block bindings source.
         *
         * This is a low-level method. For most use cases, it is recommended to use
         * the `register_block_bindings_source()` function instead.
         *
         * @see register_block_bindings_source()
         *
         * Sources are used to override block's original attributes with a value
         * coming from the source. Once a source is registered, it can be used by a
         * block by setting its `metadata.bindings` attribute to a value that refers
         * to the source.
         *
         * @since 6.5.0
         *
         * @param string $source_name       The name of the source. It must be a string containing a namespace prefix, i.e.
         *                                  `my-plugin/my-custom-source`. It must only contain lowercase alphanumeric
         *                                  characters, the forward slash `/` and dashes.
         * @param array  $source_properties {
         *     The array of arguments that are used to register a source.
         *
         *     @type string   $label              The label of the source.
         *     @type callable $get_value_callback A callback executed when the source is processed during block rendering.
         *                                        The callback should have the following signature:
         *
         *                                        `function( $source_args, $block_instance, $attribute_name ): mixed`
         *                                            - @param array    $source_args    Array containing source arguments
         *                                                                              used to look up the override value,
         *                                                                              i.e. {"key": "foo"}.
         *                                            - @param WP_Block $block_instance The block instance.
         *                                            - @param string   $attribute_name The name of the target attribute.
         *                                        The callback has a mixed return type; it may return a string to override
         *                                        the block's original value, null, false to remove an attribute, etc.
         *     @type string[] $uses_context       Optional. Array of values to add to block `uses_context` needed by the source.
         * }
         * @return WP_Block_Bindings_Source|false Source when the registration was successful, or `false` on failure.
         * @phpstan-param array{
         *   label?: string,
         *   get_value_callback?: callable,
         *   uses_context?: string[],
         * } $source_properties
         */
        public function register(string $source_name, array $source_properties)
        {
        }
        /**
         * Unregisters a block bindings source.
         *
         * @since 6.5.0
         *
         * @param string $source_name Block bindings source name including namespace.
         * @return WP_Block_Bindings_Source|false The unregistered block bindings source on success and `false` otherwise.
         */
        public function unregister(string $source_name)
        {
        }
        /**
         * Retrieves the list of all registered block bindings sources.
         *
         * @since 6.5.0
         *
         * @return WP_Block_Bindings_Source[] The array of registered sources.
         */
        public function get_all_registered()
        {
        }
        /**
         * Retrieves a registered block bindings source.
         *
         * @since 6.5.0
         *
         * @param string $source_name The name of the source.
         * @return WP_Block_Bindings_Source|null The registered block bindings source, or `null` if it is not registered.
         */
        public function get_registered(string $source_name)
        {
        }
        /**
         * Checks if a block bindings source is registered.
         *
         * @since 6.5.0
         *
         * @param string $source_name The name of the source.
         * @return bool `true` if the block bindings source is registered, `false` otherwise.
         */
        public function is_registered($source_name)
        {
        }
        /**
         * Wakeup magic method.
         *
         * @since 6.5.0
         * @phpstan-return void
         */
        public function __wakeup()
        {
        }
        /**
         * Utility method to retrieve the main instance of the class.
         *
         * The instance will be created if it does not exist yet.
         *
         * @since 6.5.0
         *
         * @return WP_Block_Bindings_Registry The main instance.
         */
        public static function get_instance()
        {
        }
    }
    /**
     * Class representing block bindings source.
     *
     * This class is designed for internal use by the Block Bindings registry.
     *
     * @since 6.5.0
     * @access private
     *
     * @see WP_Block_Bindings_Registry
     */
    final class WP_Block_Bindings_Source
    {
        /**
         * The name of the source.
         *
         * @since 6.5.0
         * @var string
         */
        public $name;
        /**
         * The label of the source.
         *
         * @since 6.5.0
         * @var string
         */
        public $label;
        /**
         * The context added to the blocks needed by the source.
         *
         * @since 6.5.0
         * @var string[]|null
         */
        public $uses_context = \null;
        /**
         * Constructor.
         *
         * Do not use this constructor directly. Instead, use the
         * `WP_Block_Bindings_Registry::register` method or the `register_block_bindings_source` function.
         *
         * @since 6.5.0
         *
         * @param string $name              The name of the source.
         * @param array  $source_properties The properties of the source.
         */
        public function __construct(string $name, array $source_properties)
        {
        }
        /**
         * Calls the callback function specified in the `$get_value_callback` property
         * with the given arguments and returns the result. It can be modified with
         * `block_bindings_source_value` filter.
         *
         * @since 6.5.0
         * @since 6.7.0 `block_bindings_source_value` filter was added.
         *
         * @param array    $source_args    Array containing source arguments used to look up the override value, i.e. {"key": "foo"}.
         * @param WP_Block $block_instance The block instance.
         * @param string   $attribute_name The name of the target attribute.
         * @return mixed The value of the source.
         */
        public function get_value(array $source_args, $block_instance, string $attribute_name)
        {
        }
        /**
         * Wakeup magic method.
         *
         * @since 6.5.0
         */
        public function __wakeup()
        {
        }
    }
    /**
     * Contains information about a block editor being rendered.
     *
     * @since 5.8.0
     */
    #[\AllowDynamicProperties]
    final class WP_Block_Editor_Context
    {
        /**
         * String that identifies the block editor being rendered. Can be one of:
         *
         * - `'core/edit-post'`         - The post editor at `/wp-admin/edit.php`.
         * - `'core/edit-widgets'`      - The widgets editor at `/wp-admin/widgets.php`.
         * - `'core/customize-widgets'` - The widgets editor at `/wp-admin/customize.php`.
         * - `'core/edit-site'`         - The site editor at `/wp-admin/site-editor.php`.
         *
         * Defaults to 'core/edit-post'.
         *
         * @since 6.0.0
         *
         * @var string
         */
        public $name = 'core/edit-post';
        /**
         * The post being edited by the block editor. Optional.
         *
         * @since 5.8.0
         *
         * @var WP_Post|null
         */
        public $post = \null;
        /**
         * Constructor.
         *
         * Populates optional properties for a given block editor context.
         *
         * @since 5.8.0
         *
         * @param array $settings The list of optional settings to expose in a given context.
         */
        public function __construct(array $settings = array())
        {
        }
    }
    /**
     * Class representing a list of block instances.
     *
     * @since 5.5.0
     * @phpstan-implements ArrayAccess<int, WP_Block>
     */
    #[\AllowDynamicProperties]
    class WP_Block_List implements \Iterator, \ArrayAccess, \Countable
    {
        /**
         * Original array of parsed block data, or block instances.
         *
         * @since 5.5.0
         * @var array[]|WP_Block[]
         * @access protected
         */
        protected $blocks;
        /**
         * All available context of the current hierarchy.
         *
         * @since 5.5.0
         * @var array
         * @access protected
         */
        protected $available_context;
        /**
         * Block type registry to use in constructing block instances.
         *
         * @since 5.5.0
         * @var WP_Block_Type_Registry
         * @access protected
         */
        protected $registry;
        /**
         * Constructor.
         *
         * Populates object properties from the provided block instance argument.
         *
         * @since 5.5.0
         *
         * @param array[]|WP_Block[]     $blocks            Array of parsed block data, or block instances.
         * @param array                  $available_context Optional array of ancestry context values.
         * @param WP_Block_Type_Registry $registry          Optional block type registry.
         */
        public function __construct($blocks, $available_context = array(), $registry = \null)
        {
        }
        /**
         * Returns true if a block exists by the specified block offset, or false
         * otherwise.
         *
         * @since 5.5.0
         *
         * @link https://www.php.net/manual/en/arrayaccess.offsetexists.php
         *
         * @param string $offset Offset of block to check for.
         * @return bool Whether block exists.
         * @phpstan-param int $offset
         */
        #[\ReturnTypeWillChange]
        public function offsetExists($offset)
        {
        }
        /**
         * Returns the value by the specified block offset.
         *
         * @since 5.5.0
         *
         * @link https://www.php.net/manual/en/arrayaccess.offsetget.php
         *
         * @param string $offset Offset of block value to retrieve.
         * @return mixed|null Block value if exists, or null.
         * @phpstan-param int $offset
         * @phpstan-return WP_Block|null
         */
        #[\ReturnTypeWillChange]
        public function offsetGet($offset)
        {
        }
        /**
         * Assign a block value by the specified block offset.
         *
         * @since 5.5.0
         *
         * @link https://www.php.net/manual/en/arrayaccess.offsetset.php
         *
         * @param string $offset Offset of block value to set.
         * @param mixed  $value Block value.
         * @phpstan-param int|null $offset
         * @phpstan-return void
         */
        #[\ReturnTypeWillChange]
        public function offsetSet($offset, $value)
        {
        }
        /**
         * Unset a block.
         *
         * @since 5.5.0
         *
         * @link https://www.php.net/manual/en/arrayaccess.offsetunset.php
         *
         * @param string $offset Offset of block value to unset.
         * @phpstan-param int $offset
         * @phpstan-return void
         */
        #[\ReturnTypeWillChange]
        public function offsetUnset($offset)
        {
        }
        /**
         * Rewinds back to the first element of the Iterator.
         *
         * @since 5.5.0
         *
         * @link https://www.php.net/manual/en/iterator.rewind.php
         */
        #[\ReturnTypeWillChange]
        public function rewind()
        {
        }
        /**
         * Returns the current element of the block list.
         *
         * @since 5.5.0
         *
         * @link https://www.php.net/manual/en/iterator.current.php
         *
         * @return mixed Current element.
         */
        #[\ReturnTypeWillChange]
        public function current()
        {
        }
        /**
         * Returns the key of the current element of the block list.
         *
         * @since 5.5.0
         *
         * @link https://www.php.net/manual/en/iterator.key.php
         *
         * @return mixed Key of the current element.
         */
        #[\ReturnTypeWillChange]
        public function key()
        {
        }
        /**
         * Moves the current position of the block list to the next element.
         *
         * @since 5.5.0
         *
         * @link https://www.php.net/manual/en/iterator.next.php
         */
        #[\ReturnTypeWillChange]
        public function next()
        {
        }
        /**
         * Checks if current position is valid.
         *
         * @since 5.5.0
         *
         * @link https://www.php.net/manual/en/iterator.valid.php
         */
        #[\ReturnTypeWillChange]
        public function valid()
        {
        }
        /**
         * Returns the count of blocks in the list.
         *
         * @since 5.5.0
         *
         * @link https://www.php.net/manual/en/countable.count.php
         *
         * @return int Block count.
         */
        #[\ReturnTypeWillChange]
        public function count()
        {
        }
    }
    /**
     * Class used for managing block metadata collections.
     *
     * The WP_Block_Metadata_Registry allows plugins to register metadata for large
     * collections of blocks (e.g., 50-100+) using a single PHP file. This approach
     * reduces the need to read and decode multiple `block.json` files, enhancing
     * performance through opcode caching.
     *
     * @since 6.7.0
     */
    class WP_Block_Metadata_Registry
    {
        /**
         * Registers a block metadata collection.
         *
         * This method allows registering a collection of block metadata from a single
         * manifest file, improving performance for large sets of blocks.
         *
         * The manifest file should be a PHP file that returns an associative array, where
         * the keys are the block identifiers (without their namespace) and the values are
         * the corresponding block metadata arrays. The block identifiers must match the
         * parent directory name for the respective `block.json` file.
         *
         * Example manifest file structure:
         * ```
         * return array(
         *     'example-block' => array(
         *         'title' => 'Example Block',
         *         'category' => 'widgets',
         *         'icon' => 'smiley',
         *         // ... other block metadata
         *     ),
         *     'another-block' => array(
         *         'title' => 'Another Block',
         *         'category' => 'formatting',
         *         'icon' => 'star-filled',
         *         // ... other block metadata
         *     ),
         *     // ... more block metadata entries
         * );
         * ```
         *
         * @since 6.7.0
         *
         * @param string $path     The absolute base path for the collection ( e.g., WP_PLUGIN_DIR . '/my-plugin/blocks/' ).
         * @param string $manifest The absolute path to the manifest file containing the metadata collection.
         * @return bool True if the collection was registered successfully, false otherwise.
         */
        public static function register_collection($path, $manifest)
        {
        }
        /**
         * Retrieves block metadata for a given block within a specific collection.
         *
         * This method uses the registered collections to efficiently lookup
         * block metadata without reading individual `block.json` files.
         *
         * @since 6.7.0
         *
         * @param string $file_or_folder The path to the file or folder containing the block.
         * @return array|null The block metadata for the block, or null if not found.
         */
        public static function get_metadata($file_or_folder)
        {
        }
        /**
         * Gets the list of absolute paths to all block metadata files that are part of the given collection.
         *
         * For instance, if a block metadata collection is registered with path `WP_PLUGIN_DIR . '/my-plugin/blocks/'`,
         * and the manifest file includes metadata for two blocks `'block-a'` and `'block-b'`, the result of this method
         * will be an array containing:
         * * `WP_PLUGIN_DIR . '/my-plugin/blocks/block-a/block.json'`
         * * `WP_PLUGIN_DIR . '/my-plugin/blocks/block-b/block.json'`
         *
         * @since 6.8.0
         *
         * @param string $path The absolute base path for a previously registered collection.
         * @return string[] List of block metadata file paths, or an empty array if the given `$path` is invalid.
         */
        public static function get_collection_block_metadata_files($path)
        {
        }
        /**
         * Checks if metadata exists for a given block name in a specific collection.
         *
         * @since 6.7.0
         *
         * @param string $file_or_folder The path to the file or folder containing the block metadata.
         * @return bool True if metadata exists for the block, false otherwise.
         */
        public static function has_metadata($file_or_folder)
        {
        }
    }
    /**
     * Class WP_Block_Parser_Block
     *
     * Holds the block structure in memory
     *
     * @since 5.0.0
     */
    class WP_Block_Parser_Block
    {
        /**
         * Name of block
         *
         * @example "core/paragraph"
         *
         * @since 5.0.0
         * @var string
         */
        public $blockName;
        /**
         * Optional set of attributes from block comment delimiters
         *
         * @example null
         * @example array( 'columns' => 3 )
         *
         * @since 5.0.0
         * @var array|null
         */
        public $attrs;
        /**
         * List of inner blocks (of this same class)
         *
         * @since 5.0.0
         * @var WP_Block_Parser_Block[]
         */
        public $innerBlocks;
        /**
         * Resultant HTML from inside block comment delimiters
         * after removing inner blocks
         *
         * @example "...Just <!-- wp:test /--> testing..." -> "Just testing..."
         *
         * @since 5.0.0
         * @var string
         */
        public $innerHTML;
        /**
         * List of string fragments and null markers where inner blocks were found
         *
         * @example array(
         *   'innerHTML'    => 'BeforeInnerAfter',
         *   'innerBlocks'  => array( block, block ),
         *   'innerContent' => array( 'Before', null, 'Inner', null, 'After' ),
         * )
         *
         * @since 4.2.0
         * @var array
         */
        public $innerContent;
        /**
         * Constructor.
         *
         * Will populate object properties from the provided arguments.
         *
         * @since 5.0.0
         *
         * @param string $name          Name of block.
         * @param array  $attrs         Optional set of attributes from block comment delimiters.
         * @param array  $inner_blocks  List of inner blocks (of this same class).
         * @param string $inner_html    Resultant HTML from inside block comment delimiters after removing inner blocks.
         * @param array  $inner_content List of string fragments and null markers where inner blocks were found.
         */
        public function __construct($name, $attrs, $inner_blocks, $inner_html, $inner_content)
        {
        }
    }
    /**
     * Class WP_Block_Parser_Frame
     *
     * Holds partial blocks in memory while parsing
     *
     * @internal
     * @since 5.0.0
     */
    class WP_Block_Parser_Frame
    {
        /**
         * Full or partial block
         *
         * @since 5.0.0
         * @var WP_Block_Parser_Block
         */
        public $block;
        /**
         * Byte offset into document for start of parse token
         *
         * @since 5.0.0
         * @var int
         */
        public $token_start;
        /**
         * Byte length of entire parse token string
         *
         * @since 5.0.0
         * @var int
         */
        public $token_length;
        /**
         * Byte offset into document for after parse token ends
         * (used during reconstruction of stack into parse production)
         *
         * @since 5.0.0
         * @var int
         */
        public $prev_offset;
        /**
         * Byte offset into document where leading HTML before token starts
         *
         * @since 5.0.0
         * @var int
         */
        public $leading_html_start;
        /**
         * Constructor
         *
         * Will populate object properties from the provided arguments.
         *
         * @since 5.0.0
         *
         * @param WP_Block_Parser_Block $block              Full or partial block.
         * @param int                   $token_start        Byte offset into document for start of parse token.
         * @param int                   $token_length       Byte length of entire parse token string.
         * @param int|null              $prev_offset        Optional. Byte offset into document for after parse token ends. Default null.
         * @param int|null              $leading_html_start Optional. Byte offset into document where leading HTML before token starts.
         *                                                  Default null.
         */
        public function __construct($block, $token_start, $token_length, $prev_offset = \null, $leading_html_start = \null)
        {
        }
    }
    /**
     * Class WP_Block_Parser
     *
     * Parses a document and constructs a list of parsed block objects
     *
     * @since 5.0.0
     * @since 4.0.0 returns arrays not objects, all attributes are arrays
     */
    class WP_Block_Parser
    {
        /**
         * Input document being parsed
         *
         * @example "Pre-text\n<!-- wp:paragraph -->This is inside a block!<!-- /wp:paragraph -->"
         *
         * @since 5.0.0
         * @var string
         */
        public $document;
        /**
         * Tracks parsing progress through document
         *
         * @since 5.0.0
         * @var int
         */
        public $offset;
        /**
         * List of parsed blocks
         *
         * @since 5.0.0
         * @var WP_Block_Parser_Block[]
         */
        public $output;
        /**
         * Stack of partially-parsed structures in memory during parse
         *
         * @since 5.0.0
         * @var WP_Block_Parser_Frame[]
         */
        public $stack;
        /**
         * Parses a document and returns a list of block structures
         *
         * When encountering an invalid parse will return a best-effort
         * parse. In contrast to the specification parser this does not
         * return an error on invalid inputs.
         *
         * @since 5.0.0
         *
         * @param string $document Input document being parsed.
         * @return array[]
         */
        public function parse($document)
        {
        }
        /**
         * Processes the next token from the input document
         * and returns whether to proceed eating more tokens
         *
         * This is the "next step" function that essentially
         * takes a token as its input and decides what to do
         * with that token before descending deeper into a
         * nested block tree or continuing along the document
         * or breaking out of a level of nesting.
         *
         * @internal
         * @since 5.0.0
         * @return bool
         */
        public function proceed()
        {
        }
        /**
         * Scans the document from where we last left off
         * and finds the next valid token to parse if it exists
         *
         * Returns the type of the find: kind of find, block information, attributes
         *
         * @internal
         * @since 5.0.0
         * @since 4.6.1 fixed a bug in attribute parsing which caused catastrophic backtracking on invalid block comments
         * @return array
         */
        public function next_token()
        {
        }
        /**
         * Returns a new block object for freeform HTML
         *
         * @internal
         * @since 3.9.0
         *
         * @param string $inner_html HTML content of block.
         * @return WP_Block_Parser_Block freeform block object.
         */
        public function freeform($inner_html)
        {
        }
        /**
         * Pushes a length of text from the input document
         * to the output list as a freeform block.
         *
         * @internal
         * @since 5.0.0
         * @param null $length how many bytes of document text to output.
         * @phpstan-return void
         */
        public function add_freeform($length = \null)
        {
        }
        /**
         * Given a block structure from memory pushes
         * a new block to the output list.
         *
         * @internal
         * @since 5.0.0
         * @param WP_Block_Parser_Block $block        The block to add to the output.
         * @param int                   $token_start  Byte offset into the document where the first token for the block starts.
         * @param int                   $token_length Byte length of entire block from start of opening token to end of closing token.
         * @param int|null              $last_offset  Last byte offset into document if continuing form earlier output.
         */
        public function add_inner_block(\WP_Block_Parser_Block $block, $token_start, $token_length, $last_offset = \null)
        {
        }
        /**
         * Pushes the top block from the parsing stack to the output list.
         *
         * @internal
         * @since 5.0.0
         * @param int|null $end_offset byte offset into document for where we should stop sending text output as HTML.
         */
        public function add_block_from_stack($end_offset = \null)
        {
        }
    }
    /**
     * Class used for interacting with block pattern categories.
     */
    #[\AllowDynamicProperties]
    final class WP_Block_Pattern_Categories_Registry
    {
        /**
         * Registers a pattern category.
         *
         * @since 5.5.0
         *
         * @param string $category_name       Pattern category name including namespace.
         * @param array  $category_properties {
         *     List of properties for the block pattern category.
         *
         *     @type string $label Required. A human-readable label for the pattern category.
         * }
         * @return bool True if the pattern was registered with success and false otherwise.
         * @phpstan-param array{
         *   label?: string,
         * } $category_properties
         */
        public function register($category_name, $category_properties)
        {
        }
        /**
         * Unregisters a pattern category.
         *
         * @since 5.5.0
         *
         * @param string $category_name Pattern category name including namespace.
         * @return bool True if the pattern was unregistered with success and false otherwise.
         */
        public function unregister($category_name)
        {
        }
        /**
         * Retrieves an array containing the properties of a registered pattern category.
         *
         * @since 5.5.0
         *
         * @param string $category_name Pattern category name including namespace.
         * @return array Registered pattern properties.
         */
        public function get_registered($category_name)
        {
        }
        /**
         * Retrieves all registered pattern categories.
         *
         * @since 5.5.0
         *
         * @param bool $outside_init_only Return only categories registered outside the `init` action.
         * @return array[] Array of arrays containing the registered pattern categories properties.
         */
        public function get_all_registered($outside_init_only = \false)
        {
        }
        /**
         * Checks if a pattern category is registered.
         *
         * @since 5.5.0
         *
         * @param string $category_name Pattern category name including namespace.
         * @return bool True if the pattern category is registered, false otherwise.
         */
        public function is_registered($category_name)
        {
        }
        /**
         * Utility method to retrieve the main instance of the class.
         *
         * The instance will be created if it does not exist yet.
         *
         * @since 5.5.0
         *
         * @return WP_Block_Pattern_Categories_Registry The main instance.
         */
        public static function get_instance()
        {
        }
    }
    /**
     * Class used for interacting with block patterns.
     *
     * @since 5.5.0
     */
    #[\AllowDynamicProperties]
    final class WP_Block_Patterns_Registry
    {
        /**
         * Registers a block pattern.
         *
         * @since 5.5.0
         * @since 5.8.0 Added support for the `blockTypes` property.
         * @since 6.1.0 Added support for the `postTypes` property.
         * @since 6.2.0 Added support for the `templateTypes` property.
         * @since 6.5.0 Added support for the `filePath` property.
         *
         * @param string $pattern_name       Block pattern name including namespace.
         * @param array  $pattern_properties {
         *     List of properties for the block pattern.
         *
         *     @type string   $title         Required. A human-readable title for the pattern.
         *     @type string   $content       Optional. Block HTML markup for the pattern.
         *                                   If not provided, the content will be retrieved from the `filePath` if set.
         *                                   If both `content` and `filePath` are not set, the pattern will not be registered.
         *     @type string   $description   Optional. Visually hidden text used to describe the pattern
         *                                   in the inserter. A description is optional, but is strongly
         *                                   encouraged when the title does not fully describe what the
         *                                   pattern does. The description will help users discover the
         *                                   pattern while searching.
         *     @type int      $viewportWidth Optional. The intended width of the pattern to allow for a scaled
         *                                   preview within the pattern inserter.
         *     @type bool     $inserter      Optional. Determines whether the pattern is visible in inserter.
         *                                   To hide a pattern so that it can only be inserted programmatically,
         *                                   set this to false. Default true.
         *     @type string[] $categories    Optional. A list of registered pattern categories used to group
         *                                   block patterns. Block patterns can be shown on multiple categories.
         *                                   A category must be registered separately in order to be used here.
         *     @type string[] $keywords      Optional. A list of aliases or keywords that help users discover
         *                                   the pattern while searching.
         *     @type string[] $blockTypes    Optional. A list of block names including namespace that could use
         *                                   the block pattern in certain contexts (placeholder, transforms).
         *                                   The block pattern is available in the block editor inserter
         *                                   regardless of this list of block names.
         *                                   Certain blocks support further specificity besides the block name
         *                                   (e.g. for `core/template-part` you can specify areas
         *                                   like `core/template-part/header` or `core/template-part/footer`).
         *     @type string[] $postTypes     Optional. An array of post types that the pattern is restricted
         *                                   to be used with. The pattern will only be available when editing one
         *                                   of the post types passed on the array. For all the other post types
         *                                   not part of the array the pattern is not available at all.
         *     @type string[] $templateTypes Optional. An array of template types where the pattern fits.
         *     @type string   $filePath      Optional. The full path to the file containing the block pattern content.
         * }
         * @return bool True if the pattern was registered with success and false otherwise.
         * @phpstan-param array{
         *   title?: string,
         *   content?: string,
         *   description?: string,
         *   viewportWidth?: int,
         *   inserter?: bool,
         *   categories?: string[],
         *   keywords?: string[],
         *   blockTypes?: string[],
         *   postTypes?: string[],
         *   templateTypes?: string[],
         *   filePath?: string,
         * } $pattern_properties
         */
        public function register($pattern_name, $pattern_properties)
        {
        }
        /**
         * Unregisters a block pattern.
         *
         * @since 5.5.0
         *
         * @param string $pattern_name Block pattern name including namespace.
         * @return bool True if the pattern was unregistered with success and false otherwise.
         */
        public function unregister($pattern_name)
        {
        }
        /**
         * Retrieves an array containing the properties of a registered block pattern.
         *
         * @since 5.5.0
         *
         * @param string $pattern_name Block pattern name including namespace.
         * @return array Registered pattern properties.
         */
        public function get_registered($pattern_name)
        {
        }
        /**
         * Retrieves all registered block patterns.
         *
         * @since 5.5.0
         *
         * @param bool $outside_init_only Return only patterns registered outside the `init` action.
         * @return array[] Array of arrays containing the registered block patterns properties,
         *                 and per style.
         */
        public function get_all_registered($outside_init_only = \false)
        {
        }
        /**
         * Checks if a block pattern is registered.
         *
         * @since 5.5.0
         *
         * @param string $pattern_name Block pattern name including namespace.
         * @return bool True if the pattern is registered, false otherwise.
         */
        public function is_registered($pattern_name)
        {
        }
        public function __wakeup()
        {
        }
        /**
         * Utility method to retrieve the main instance of the class.
         *
         * The instance will be created if it does not exist yet.
         *
         * @since 5.5.0
         *
         * @return WP_Block_Patterns_Registry The main instance.
         */
        public static function get_instance()
        {
        }
    }
    /**
     * Class used for interacting with block styles.
     *
     * @since 5.3.0
     */
    #[\AllowDynamicProperties]
    final class WP_Block_Styles_Registry
    {
        /**
         * Registers a block style for the given block type.
         *
         * If the block styles are present in a standalone stylesheet, register it and pass
         * its handle as the `style_handle` argument. If the block styles should be inline,
         * use the `inline_style` argument. Usually, one of them would be used to pass CSS
         * styles. However, you could also skip them and provide CSS styles in any stylesheet
         * or with an inline tag.
         *
         * @since 5.3.0
         * @since 6.6.0 Added ability to register style across multiple block types along with theme.json-like style data.
         *
         * @link https://developer.wordpress.org/block-editor/reference-guides/block-api/block-styles/
         *
         * @param string|string[] $block_name       Block type name including namespace or array of namespaced block type names.
         * @param array           $style_properties {
         *     Array containing the properties of the style.
         *
         *     @type string $name         The identifier of the style used to compute a CSS class.
         *     @type string $label        A human-readable label for the style.
         *     @type string $inline_style Inline CSS code that registers the CSS class required
         *                                for the style.
         *     @type string $style_handle The handle to an already registered style that should be
         *                                enqueued in places where block styles are needed.
         *     @type bool   $is_default   Whether this is the default style for the block type.
         *     @type array  $style_data   Theme.json-like object to generate CSS from.
         * }
         * @return bool True if the block style was registered with success and false otherwise.
         * @phpstan-param array{
         *   name?: string,
         *   label?: string,
         *   inline_style?: string,
         *   style_handle?: string,
         *   is_default?: bool,
         *   style_data?: array,
         * } $style_properties
         */
        public function register($block_name, $style_properties)
        {
        }
        /**
         * Unregisters a block style of the given block type.
         *
         * @since 5.3.0
         *
         * @param string $block_name       Block type name including namespace.
         * @param string $block_style_name Block style name.
         * @return bool True if the block style was unregistered with success and false otherwise.
         */
        public function unregister($block_name, $block_style_name)
        {
        }
        /**
         * Retrieves the properties of a registered block style for the given block type.
         *
         * @since 5.3.0
         *
         * @param string $block_name       Block type name including namespace.
         * @param string $block_style_name Block style name.
         * @return array Registered block style properties.
         */
        public function get_registered($block_name, $block_style_name)
        {
        }
        /**
         * Retrieves all registered block styles.
         *
         * @since 5.3.0
         *
         * @return array[] Array of arrays containing the registered block styles properties grouped by block type.
         */
        public function get_all_registered()
        {
        }
        /**
         * Retrieves registered block styles for a specific block type.
         *
         * @since 5.3.0
         *
         * @param string $block_name Block type name including namespace.
         * @return array[] Array whose keys are block style names and whose values are block style properties.
         */
        public function get_registered_styles_for_block($block_name)
        {
        }
        /**
         * Checks if a block style is registered for the given block type.
         *
         * @since 5.3.0
         *
         * @param string $block_name       Block type name including namespace.
         * @param string $block_style_name Block style name.
         * @return bool True if the block style is registered, false otherwise.
         */
        public function is_registered($block_name, $block_style_name)
        {
        }
        /**
         * Utility method to retrieve the main instance of the class.
         *
         * The instance will be created if it does not exist yet.
         *
         * @since 5.3.0
         *
         * @return WP_Block_Styles_Registry The main instance.
         */
        public static function get_instance()
        {
        }
    }
    /**
     * Class encapsulating and implementing Block Supports.
     *
     * @since 5.6.0
     *
     * @access private
     */
    #[\AllowDynamicProperties]
    class WP_Block_Supports
    {
        /**
         * Tracks the current block to be rendered.
         *
         * @since 5.6.0
         * @var array
         */
        public static $block_to_render = \null;
        /**
         * Utility method to retrieve the main instance of the class.
         *
         * The instance will be created if it does not exist yet.
         *
         * @since 5.6.0
         *
         * @return WP_Block_Supports The main instance.
         */
        public static function get_instance()
        {
        }
        /**
         * Initializes the block supports. It registers the block supports block attributes.
         *
         * @since 5.6.0
         */
        public static function init()
        {
        }
        /**
         * Registers a block support.
         *
         * @since 5.6.0
         *
         * @link https://developer.wordpress.org/block-editor/reference-guides/block-api/block-supports/
         *
         * @param string $block_support_name   Block support name.
         * @param array  $block_support_config Array containing the properties of the block support.
         */
        public function register($block_support_name, $block_support_config)
        {
        }
        /**
         * Generates an array of HTML attributes, such as classes, by applying to
         * the given block all of the features that the block supports.
         *
         * @since 5.6.0
         *
         * @return string[] Array of HTML attribute values keyed by their name.
         */
        public function apply_block_supports()
        {
        }
    }
    /**
     * Class representing a block template.
     *
     * @since 5.8.0
     */
    #[\AllowDynamicProperties]
    class WP_Block_Template
    {
        /**
         * Type: wp_template.
         *
         * @since 5.8.0
         * @var string
         */
        public $type;
        /**
         * Theme.
         *
         * @since 5.8.0
         * @var string
         */
        public $theme;
        /**
         * Template slug.
         *
         * @since 5.8.0
         * @var string
         */
        public $slug;
        /**
         * ID.
         *
         * @since 5.8.0
         * @var string
         */
        public $id;
        /**
         * Title.
         *
         * @since 5.8.0
         * @var string
         */
        public $title = '';
        /**
         * Content.
         *
         * @since 5.8.0
         * @var string
         */
        public $content = '';
        /**
         * Description.
         *
         * @since 5.8.0
         * @var string
         */
        public $description = '';
        /**
         * Source of the content. `theme` and `custom` is used for now.
         *
         * @since 5.8.0
         * @var string
         */
        public $source = 'theme';
        /**
         * Origin of the content when the content has been customized.
         * When customized, origin takes on the value of source and source becomes
         * 'custom'.
         *
         * @since 5.9.0
         * @var string|null
         */
        public $origin;
        /**
         * Post ID.
         *
         * @since 5.8.0
         * @var int|null
         */
        public $wp_id;
        /**
         * Template Status.
         *
         * @since 5.8.0
         * @var string
         */
        public $status;
        /**
         * Whether a template is, or is based upon, an existing template file.
         *
         * @since 5.8.0
         * @var bool
         */
        public $has_theme_file;
        /**
         * Whether a template is a custom template.
         *
         * @since 5.9.0
         *
         * @var bool
         */
        public $is_custom = \true;
        /**
         * Author.
         *
         * A value of 0 means no author.
         *
         * @since 5.9.0
         * @var int|null
         */
        public $author;
        /**
         * Plugin.
         *
         * @since 6.7.0
         * @var string|null
         */
        public $plugin;
        /**
         * Post types.
         *
         * @since 5.9.0
         * @var string[]|null
         */
        public $post_types;
        /**
         * Area.
         *
         * @since 5.9.0
         * @var string|null
         */
        public $area;
        /**
         * Modified.
         *
         * @since 6.3.0
         * @var string|null
         */
        public $modified;
    }
    /**
     * Core class used for interacting with templates.
     *
     * @since 6.7.0
     */
    final class WP_Block_Templates_Registry
    {
        /**
         * Registers a template.
         *
         * @since 6.7.0
         *
         * @param string $template_name Template name including namespace.
         * @param array  $args          Optional. Array of template arguments.
         * @return WP_Block_Template|WP_Error The registered template on success, or WP_Error on failure.
         */
        public function register($template_name, $args = array())
        {
        }
        /**
         * Retrieves all registered templates.
         *
         * @since 6.7.0
         *
         * @return WP_Block_Template[] Associative array of `$template_name => $template` pairs.
         */
        public function get_all_registered()
        {
        }
        /**
         * Retrieves a registered template by its name.
         *
         * @since 6.7.0
         *
         * @param string $template_name Template name including namespace.
         * @return WP_Block_Template|null The registered template, or null if it is not registered.
         */
        public function get_registered($template_name)
        {
        }
        /**
         * Retrieves a registered template by its slug.
         *
         * @since 6.7.0
         *
         * @param string $template_slug Slug of the template.
         * @return WP_Block_Template|null The registered template, or null if it is not registered.
         */
        public function get_by_slug($template_slug)
        {
        }
        /**
         * Retrieves registered templates matching a query.
         *
         * @since 6.7.0
         *
         * @param array  $query {
         *     Arguments to retrieve templates. Optional, empty by default.
         *
         *     @type string[] $slug__in     List of slugs to include.
         *     @type string[] $slug__not_in List of slugs to skip.
         *     @type string   $post_type    Post type to get the templates for.
         * }
         * @return WP_Block_Template[] Associative array of `$template_name => $template` pairs.
         * @phpstan-param array{
         *   slug__in?: string[],
         *   slug__not_in?: string[],
         *   post_type?: string,
         * } $query
         */
        public function get_by_query($query = array())
        {
        }
        /**
         * Checks if a template is registered.
         *
         * @since 6.7.0
         *
         * @param string $template_name Template name.
         * @return bool True if the template is registered, false otherwise.
         */
        public function is_registered($template_name)
        {
        }
        /**
         * Unregisters a template.
         *
         * @since 6.7.0
         *
         * @param string $template_name Template name including namespace.
         * @return WP_Block_Template|WP_Error The unregistered template on success, or WP_Error on failure.
         */
        public function unregister($template_name)
        {
        }
        /**
         * Utility method to retrieve the main instance of the class.
         *
         * The instance will be created if it does not exist yet.
         *
         * @since 6.7.0
         *
         * @return WP_Block_Templates_Registry The main instance.
         */
        public static function get_instance()
        {
        }
    }
    /**
     * Core class used for interacting with block types.
     *
     * @since 5.0.0
     */
    #[\AllowDynamicProperties]
    final class WP_Block_Type_Registry
    {
        /**
         * Registers a block type.
         *
         * @since 5.0.0
         *
         * @see WP_Block_Type::__construct()
         *
         * @param string|WP_Block_Type $name Block type name including namespace, or alternatively
         *                                   a complete WP_Block_Type instance. In case a WP_Block_Type
         *                                   is provided, the $args parameter will be ignored.
         * @param array                $args Optional. Array of block type arguments. Accepts any public property
         *                                   of `WP_Block_Type`. See WP_Block_Type::__construct() for information
         *                                   on accepted arguments. Default empty array.
         * @return WP_Block_Type|false The registered block type on success, or false on failure.
         * @phpstan-param array{
         *   api_version?: string,
         *   title?: string,
         *   category?: string|null,
         *   parent?: string[]|null,
         *   ancestor?: string[]|null,
         *   allowed_blocks?: string[]|null,
         *   icon?: string|null,
         *   description?: string,
         *   keywords?: string[],
         *   textdomain?: string|null,
         *   styles?: array[],
         *   variations?: array[],
         *   selectors?: array,
         *   supports?: array|null,
         *   example?: array|null,
         *   render_callback?: callable|null,
         *   variation_callback?: callable|null,
         *   attributes?: array|null,
         *   uses_context?: string[],
         *   provides_context?: string[]|null,
         *   block_hooks?: string[],
         *   editor_script_handles?: string[],
         *   script_handles?: string[],
         *   view_script_handles?: string[],
         *   editor_style_handles?: string[],
         *   style_handles?: string[],
         *   view_style_handles?: string[],
         * } $args See WP_Block_Type::__construct()
         */
        public function register($name, $args = array())
        {
        }
        /**
         * Unregisters a block type.
         *
         * @since 5.0.0
         *
         * @param string|WP_Block_Type $name Block type name including namespace, or alternatively
         *                                   a complete WP_Block_Type instance.
         * @return WP_Block_Type|false The unregistered block type on success, or false on failure.
         */
        public function unregister($name)
        {
        }
        /**
         * Retrieves a registered block type.
         *
         * @since 5.0.0
         *
         * @param string $name Block type name including namespace.
         * @return WP_Block_Type|null The registered block type, or null if it is not registered.
         */
        public function get_registered($name)
        {
        }
        /**
         * Retrieves all registered block types.
         *
         * @since 5.0.0
         *
         * @return WP_Block_Type[] Associative array of `$block_type_name => $block_type` pairs.
         */
        public function get_all_registered()
        {
        }
        /**
         * Checks if a block type is registered.
         *
         * @since 5.0.0
         *
         * @param string $name Block type name including namespace.
         * @return bool True if the block type is registered, false otherwise.
         */
        public function is_registered($name)
        {
        }
        public function __wakeup()
        {
        }
        /**
         * Utility method to retrieve the main instance of the class.
         *
         * The instance will be created if it does not exist yet.
         *
         * @since 5.0.0
         *
         * @return WP_Block_Type_Registry The main instance.
         */
        public static function get_instance()
        {
        }
    }
    /**
     * Core class representing a block type.
     *
     * @since 5.0.0
     *
     * @see register_block_type()
     */
    #[\AllowDynamicProperties]
    class WP_Block_Type
    {
        /**
         * Block API version.
         *
         * @since 5.6.0
         * @var int
         */
        public $api_version = 1;
        /**
         * Block type key.
         *
         * @since 5.0.0
         * @var string
         */
        public $name;
        /**
         * Human-readable block type label.
         *
         * @since 5.5.0
         * @var string
         */
        public $title = '';
        /**
         * Block type category classification, used in search interfaces
         * to arrange block types by category.
         *
         * @since 5.5.0
         * @var string|null
         */
        public $category = \null;
        /**
         * Setting parent lets a block require that it is only available
         * when nested within the specified blocks.
         *
         * @since 5.5.0
         * @var string[]|null
         */
        public $parent = \null;
        /**
         * Setting ancestor makes a block available only inside the specified
         * block types at any position of the ancestor's block subtree.
         *
         * @since 6.0.0
         * @var string[]|null
         */
        public $ancestor = \null;
        /**
         * Limits which block types can be inserted as children of this block type.
         *
         * @since 6.5.0
         * @var string[]|null
         */
        public $allowed_blocks = \null;
        /**
         * Block type icon.
         *
         * @since 5.5.0
         * @var string|null
         */
        public $icon = \null;
        /**
         * A detailed block type description.
         *
         * @since 5.5.0
         * @var string
         */
        public $description = '';
        /**
         * Additional keywords to produce block type as result
         * in search interfaces.
         *
         * @since 5.5.0
         * @var string[]
         */
        public $keywords = array();
        /**
         * The translation textdomain.
         *
         * @since 5.5.0
         * @var string|null
         */
        public $textdomain = \null;
        /**
         * Alternative block styles.
         *
         * @since 5.5.0
         * @var array
         */
        public $styles = array();
        /**
         * Block variations callback.
         *
         * @since 6.5.0
         * @var callable|null
         */
        public $variation_callback = \null;
        /**
         * Custom CSS selectors for theme.json style generation.
         *
         * @since 6.3.0
         * @var array
         */
        public $selectors = array();
        /**
         * Supported features.
         *
         * @since 5.5.0
         * @var array|null
         */
        public $supports = \null;
        /**
         * Structured data for the block preview.
         *
         * @since 5.5.0
         * @var array|null
         */
        public $example = \null;
        /**
         * Block type render callback.
         *
         * @since 5.0.0
         * @var callable
         */
        public $render_callback = \null;
        /**
         * Block type attributes property schemas.
         *
         * @since 5.0.0
         * @var array|null
         */
        public $attributes = \null;
        /**
         * Context provided by blocks of this type.
         *
         * @since 5.5.0
         * @var string[]|null
         */
        public $provides_context = \null;
        /**
         * Block hooks for this block type.
         *
         * A block hook is specified by a block type and a relative position.
         * The hooked block will be automatically inserted in the given position
         * next to the "anchor" block whenever the latter is encountered.
         *
         * @since 6.4.0
         * @var string[]
         */
        public $block_hooks = array();
        /**
         * Block type editor only script handles.
         *
         * @since 6.1.0
         * @var string[]
         */
        public $editor_script_handles = array();
        /**
         * Block type front end and editor script handles.
         *
         * @since 6.1.0
         * @var string[]
         */
        public $script_handles = array();
        /**
         * Block type front end only script handles.
         *
         * @since 6.1.0
         * @var string[]
         */
        public $view_script_handles = array();
        /**
         * Block type front end only script module IDs.
         *
         * @since 6.5.0
         * @var string[]
         */
        public $view_script_module_ids = array();
        /**
         * Block type editor only style handles.
         *
         * @since 6.1.0
         * @var string[]
         */
        public $editor_style_handles = array();
        /**
         * Block type front end and editor style handles.
         *
         * @since 6.1.0
         * @var string[]
         */
        public $style_handles = array();
        /**
         * Block type front end only style handles.
         *
         * @since 6.5.0
         * @var string[]
         */
        public $view_style_handles = array();
        /**
         * Attributes supported by every block.
         *
         * @since 6.0.0 Added `lock`.
         * @since 6.5.0 Added `metadata`.
         * @var array
         */
        const GLOBAL_ATTRIBUTES = array('lock' => array('type' => 'object'), 'metadata' => array('type' => 'object'));
        /**
         * Constructor.
         *
         * Will populate object properties from the provided arguments.
         *
         * @since 5.0.0
         * @since 5.5.0 Added the `title`, `category`, `parent`, `icon`, `description`,
         *              `keywords`, `textdomain`, `styles`, `supports`, `example`,
         *              `uses_context`, and `provides_context` properties.
         * @since 5.6.0 Added the `api_version` property.
         * @since 5.8.0 Added the `variations` property.
         * @since 5.9.0 Added the `view_script` property.
         * @since 6.0.0 Added the `ancestor` property.
         * @since 6.1.0 Added the `editor_script_handles`, `script_handles`, `view_script_handles`,
         *              `editor_style_handles`, and `style_handles` properties.
         *              Deprecated the `editor_script`, `script`, `view_script`, `editor_style`, and `style` properties.
         * @since 6.3.0 Added the `selectors` property.
         * @since 6.4.0 Added the `block_hooks` property.
         * @since 6.5.0 Added the `allowed_blocks`, `variation_callback`, and `view_style_handles` properties.
         *
         * @see register_block_type()
         *
         * @param string       $block_type Block type name including namespace.
         * @param array|string $args       {
         *     Optional. Array or string of arguments for registering a block type. Any arguments may be defined,
         *     however the ones described below are supported by default. Default empty array.
         *
         *     @type string        $api_version              Block API version.
         *     @type string        $title                    Human-readable block type label.
         *     @type string|null   $category                 Block type category classification, used in
         *                                                   search interfaces to arrange block types by category.
         *     @type string[]|null $parent                   Setting parent lets a block require that it is only
         *                                                   available when nested within the specified blocks.
         *     @type string[]|null $ancestor                 Setting ancestor makes a block available only inside the specified
         *                                                   block types at any position of the ancestor's block subtree.
         *     @type string[]|null $allowed_blocks           Limits which block types can be inserted as children of this block type.
         *     @type string|null   $icon                     Block type icon.
         *     @type string        $description              A detailed block type description.
         *     @type string[]      $keywords                 Additional keywords to produce block type as
         *                                                   result in search interfaces.
         *     @type string|null   $textdomain               The translation textdomain.
         *     @type array[]       $styles                   Alternative block styles.
         *     @type array[]       $variations               Block variations.
         *     @type array         $selectors                Custom CSS selectors for theme.json style generation.
         *     @type array|null    $supports                 Supported features.
         *     @type array|null    $example                  Structured data for the block preview.
         *     @type callable|null $render_callback          Block type render callback.
         *     @type callable|null $variation_callback       Block type variations callback.
         *     @type array|null    $attributes               Block type attributes property schemas.
         *     @type string[]      $uses_context             Context values inherited by blocks of this type.
         *     @type string[]|null $provides_context         Context provided by blocks of this type.
         *     @type string[]      $block_hooks              Block hooks.
         *     @type string[]      $editor_script_handles    Block type editor only script handles.
         *     @type string[]      $script_handles           Block type front end and editor script handles.
         *     @type string[]      $view_script_handles      Block type front end only script handles.
         *     @type string[]      $editor_style_handles     Block type editor only style handles.
         *     @type string[]      $style_handles            Block type front end and editor style handles.
         *     @type string[]      $view_style_handles       Block type front end only style handles.
         * }
         * @phpstan-param array{
         *   api_version?: string,
         *   title?: string,
         *   category?: string|null,
         *   parent?: string[]|null,
         *   ancestor?: string[]|null,
         *   allowed_blocks?: string[]|null,
         *   icon?: string|null,
         *   description?: string,
         *   keywords?: string[],
         *   textdomain?: string|null,
         *   styles?: array[],
         *   variations?: array[],
         *   selectors?: array,
         *   supports?: array|null,
         *   example?: array|null,
         *   render_callback?: callable|null,
         *   variation_callback?: callable|null,
         *   attributes?: array|null,
         *   uses_context?: string[],
         *   provides_context?: string[]|null,
         *   block_hooks?: string[],
         *   editor_script_handles?: string[],
         *   script_handles?: string[],
         *   view_script_handles?: string[],
         *   editor_style_handles?: string[],
         *   style_handles?: string[],
         *   view_style_handles?: string[],
         * } $args
         */
        public function __construct($block_type, $args = array())
        {
        }
        /**
         * Proxies getting values for deprecated properties for script and style handles for backward compatibility.
         * Gets the value for the corresponding new property if the first item in the array provided.
         *
         * @since 6.1.0
         *
         * @param string $name Deprecated property name.
         *
         * @return string|string[]|null|void The value read from the new property if the first item in the array provided,
         *                                   null when value not found, or void when unknown property name provided.
         */
        public function __get($name)
        {
        }
        /**
         * Proxies checking for deprecated properties for script and style handles for backward compatibility.
         * Checks whether the corresponding new property has the first item in the array provided.
         *
         * @since 6.1.0
         *
         * @param string $name Deprecated property name.
         *
         * @return bool Returns true when for the new property the first item in the array exists,
         *              or false otherwise.
         */
        public function __isset($name)
        {
        }
        /**
         * Proxies setting values for deprecated properties for script and style handles for backward compatibility.
         * Sets the value for the corresponding new property as the first item in the array.
         * It also allows setting custom properties for backward compatibility.
         *
         * @since 6.1.0
         *
         * @param string $name  Property name.
         * @param mixed  $value Property value.
         * @phpstan-return void
         */
        public function __set($name, $value)
        {
        }
        /**
         * Renders the block type output for given attributes.
         *
         * @since 5.0.0
         *
         * @param array  $attributes Optional. Block attributes. Default empty array.
         * @param string $content    Optional. Block content. Default empty string.
         * @return string Rendered block type output.
         */
        public function render($attributes = array(), $content = '')
        {
        }
        /**
         * Returns true if the block type is dynamic, or false otherwise. A dynamic
         * block is one which defers its rendering to occur on-demand at runtime.
         *
         * @since 5.0.0
         *
         * @return bool Whether block type is dynamic.
         */
        public function is_dynamic()
        {
        }
        /**
         * Validates attributes against the current block schema, populating
         * defaulted and missing values.
         *
         * @since 5.0.0
         *
         * @param array $attributes Original block attributes.
         * @return array Prepared block attributes.
         */
        public function prepare_attributes_for_render($attributes)
        {
        }
        /**
         * Sets block type properties.
         *
         * @since 5.0.0
         *
         * @param array|string $args Array or string of arguments for registering a block type.
         *                           See WP_Block_Type::__construct() for information on accepted arguments.
         * @phpstan-param array{
         *   api_version?: string,
         *   title?: string,
         *   category?: string|null,
         *   parent?: string[]|null,
         *   ancestor?: string[]|null,
         *   allowed_blocks?: string[]|null,
         *   icon?: string|null,
         *   description?: string,
         *   keywords?: string[],
         *   textdomain?: string|null,
         *   styles?: array[],
         *   variations?: array[],
         *   selectors?: array,
         *   supports?: array|null,
         *   example?: array|null,
         *   render_callback?: callable|null,
         *   variation_callback?: callable|null,
         *   attributes?: array|null,
         *   uses_context?: string[],
         *   provides_context?: string[]|null,
         *   block_hooks?: string[],
         *   editor_script_handles?: string[],
         *   script_handles?: string[],
         *   view_script_handles?: string[],
         *   editor_style_handles?: string[],
         *   style_handles?: string[],
         *   view_style_handles?: string[],
         * } $args See WP_Block_Type::__construct()
         */
        public function set_props($args)
        {
        }
        /**
         * Get all available block attributes including possible layout attribute from Columns block.
         *
         * @since 5.0.0
         *
         * @return array Array of attributes.
         */
        public function get_attributes()
        {
        }
        /**
         * Get block variations.
         *
         * @since 6.5.0
         *
         * @return array[]
         */
        public function get_variations()
        {
        }
        /**
         * Get block uses context.
         *
         * @since 6.5.0
         *
         * @return string[]
         */
        public function get_uses_context()
        {
        }
    }
    /**
     * Class representing a parsed instance of a block.
     *
     * @since 5.5.0
     * @property array $attributes
     */
    #[\AllowDynamicProperties]
    class WP_Block
    {
        /**
         * Original parsed array representation of block.
         *
         * @since 5.5.0
         * @var array
         */
        public $parsed_block;
        /**
         * Name of block.
         *
         * @example "core/paragraph"
         *
         * @since 5.5.0
         * @var string
         */
        public $name;
        /**
         * Block type associated with the instance.
         *
         * @since 5.5.0
         * @var WP_Block_Type
         */
        public $block_type;
        /**
         * Block context values.
         *
         * @since 5.5.0
         * @var array
         */
        public $context = array();
        /**
         * All available context of the current hierarchy.
         *
         * @since 5.5.0
         * @var array
         * @access protected
         */
        protected $available_context = array();
        /**
         * Block type registry.
         *
         * @since 5.9.0
         * @var WP_Block_Type_Registry
         * @access protected
         */
        protected $registry;
        /**
         * List of inner blocks (of this same class)
         *
         * @since 5.5.0
         * @var WP_Block_List
         */
        public $inner_blocks = array();
        /**
         * Resultant HTML from inside block comment delimiters after removing inner
         * blocks.
         *
         * @example "...Just <!-- wp:test /--> testing..." -> "Just testing..."
         *
         * @since 5.5.0
         * @var string
         */
        public $inner_html = '';
        /**
         * List of string fragments and null markers where inner blocks were found
         *
         * @example array(
         *   'inner_html'    => 'BeforeInnerAfter',
         *   'inner_blocks'  => array( block, block ),
         *   'inner_content' => array( 'Before', null, 'Inner', null, 'After' ),
         * )
         *
         * @since 5.5.0
         * @var array
         */
        public $inner_content = array();
        /**
         * Constructor.
         *
         * Populates object properties from the provided block instance argument.
         *
         * The given array of context values will not necessarily be available on
         * the instance itself, but is treated as the full set of values provided by
         * the block's ancestry. This is assigned to the private `available_context`
         * property. Only values which are configured to consumed by the block via
         * its registered type will be assigned to the block's `context` property.
         *
         * @since 5.5.0
         *
         * @param array                  $block             {
         *     An associative array of a single parsed block object. See WP_Block_Parser_Block.
         *
         *     @type string   $blockName    Name of block.
         *     @type array    $attrs        Attributes from block comment delimiters.
         *     @type array    $innerBlocks  List of inner blocks. An array of arrays that
         *                                  have the same structure as this one.
         *     @type string   $innerHTML    HTML from inside block comment delimiters.
         *     @type array    $innerContent List of string fragments and null markers where inner blocks were found.
         * }
         * @param array                  $available_context Optional array of ancestry context values.
         * @param WP_Block_Type_Registry $registry          Optional block type registry.
         * @phpstan-param array{
         *   blockName?: string,
         *   attrs?: array,
         *   innerBlocks?: array,
         *   innerHTML?: string,
         *   innerContent?: array,
         * } $block
         */
        public function __construct($block, $available_context = array(), $registry = \null)
        {
        }
        /**
         * Updates the context for the current block and its inner blocks.
         *
         * The method updates the context of inner blocks, if any, by passing down
         * any context values the block provides (`provides_context`).
         *
         * If the block has inner blocks, the method recursively processes them by creating new instances of `WP_Block`
         * for each inner block and updating their context based on the block's `provides_context` property.
         *
         * @since 6.8.0
         */
        public function refresh_context_dependents()
        {
        }
        /**
         * Updates the parsed block content for the current block and its inner blocks.
         *
         * This method sets the `inner_html` and `inner_content` properties of the block based on the parsed
         * block content provided during initialization. It ensures that the block instance reflects the
         * most up-to-date content for both the inner HTML and any string fragments around inner blocks.
         *
         * If the block has inner blocks, this method initializes a new `WP_Block_List` for them, ensuring the
         * correct content and context are updated for each nested block.
         *
         * @since 6.8.0
         */
        public function refresh_parsed_block_dependents()
        {
        }
        /**
         * Returns a value from an inaccessible property.
         *
         * This is used to lazily initialize the `attributes` property of a block,
         * such that it is only prepared with default attributes at the time that
         * the property is accessed. For all other inaccessible properties, a `null`
         * value is returned.
         *
         * @since 5.5.0
         *
         * @param string $name Property name.
         * @return array|null Prepared attributes, or null.
         */
        public function __get($name)
        {
        }
        /**
         * Generates the render output for the block.
         *
         * @since 5.5.0
         * @since 6.5.0 Added block bindings processing.
         *
         * @global WP_Post $post Global post object.
         *
         * @param array $options {
         *     Optional options object.
         *
         *     @type bool $dynamic Defaults to 'true'. Optionally set to false to avoid using the block's render_callback.
         * }
         * @return string Rendered block output.
         * @phpstan-param array{
         *   dynamic?: bool,
         * } $options
         */
        public function render($options = array())
        {
        }
    }
    /**
     * Converts a Classic Menu to Block Menu blocks.
     *
     * @since 6.3.0
     * @access public
     */
    class WP_Classic_To_Block_Menu_Converter
    {
        /**
         * Converts a Classic Menu to blocks.
         *
         * @since 6.3.0
         *
         * @param WP_Term $menu The Menu term object of the menu to convert.
         * @return string|WP_Error The serialized and normalized parsed blocks on success,
         *                         an empty string when there are no menus to convert,
         *                         or WP_Error on invalid menu.
         */
        public static function convert($menu)
        {
        }
    }
    /**
     * Core class used for querying comments.
     *
     * @since 3.1.0
     *
     * @see WP_Comment_Query::__construct() for accepted arguments.
     */
    #[\AllowDynamicProperties]
    class WP_Comment_Query
    {
        /**
         * SQL for database query.
         *
         * @since 4.0.1
         * @var string
         */
        public $request;
        /**
         * Metadata query container
         *
         * @since 3.5.0
         * @var WP_Meta_Query A meta query instance.
         */
        public $meta_query = \false;
        /**
         * Metadata query clauses.
         *
         * @since 4.4.0
         * @var array
         */
        protected $meta_query_clauses;
        /**
         * SQL query clauses.
         *
         * @since 4.4.0
         * @var array
         */
        protected $sql_clau