<?php
/**
 * WVC Header Template
 *
 * This file contains the site header structure for vibecode pages.
 *
 * @package    WVC_Theme
 * @subpackage Templates
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.0
 * @link       https://github.com/your-repo/wvc-theme
 */

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php 
// Get the arguments passed from get_template_part
$header_content = isset($args['header_content']) ? $args['header_content'] : '';
$has_wvc_header_template = isset($args['has_wvc_header_template']) ? $args['has_wvc_header_template'] : false;

wp_body_open();

if ($has_wvc_header_template && !empty($header_content)){
	echo $header_content;
}

?>

<!-- WVC Editor content will be loaded here -->