<?php

/**
 * Empty Page Template
 *
 * This template displays when a page has no content.
 *
 * @package    WVC_Theme
 * @subpackage Templates
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.0
 * @link       https://github.com/your-repo/wvc-theme
 */

?>

<div class="empty-page-container">
    <div class="empty-page-content">
        <h1 class="empty-page-heading">Nothing has been published yet.</h1>
        <p class="empty-page-text">Once you create and publish content, it will appear here.</p>
    </div>
</div>

<style>
@font-face {
    font-family: 'EvergrowSans';
    src: url('<?php echo get_template_directory_uri(); ?>/assets/fonts/EvergrowSans-Regular.woff') format('woff');
    font-weight: 400;
    font-style: normal;
    font-display: swap;
}

@font-face {
    font-family: 'EvergrowSans';
    src: url('<?php echo get_template_directory_uri(); ?>/assets/fonts/EvergrowSans-Bold.woff') format('woff');
    font-weight: 700;
    font-style: normal;
    font-display: swap;
}



.empty-page-container {
    min-height: calc(100vh - 32px);
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 0 20px;
}

.empty-page-content {
    text-align: left;
    max-width: 780px;
    margin: 0 auto;
}

.empty-page-heading {
    font-family: 'EvergrowSans', sans-serif;
    font-size: 44px;
    font-weight: 700;
    color: #14151F;
    margin-bottom: 24px;
    line-height: 52px;
}

.empty-page-text {
    font-family: 'EvergrowSans', sans-serif;
    font-size: 20px;
    font-weight: 400;
    color: #14151F;
    line-height: 28px;
    margin: 0;
}
</style>

<?php
get_footer();
?>
