<?php
/**
 * Single Post Template
 *
 * This template displays individual blog posts. It handles post content-managers,
 * metadata, featured images, author information, comments, and navigation
 * between posts.
 *
 * @package    WVC_Theme
 * @subpackage Templates
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.0
 * @link       https://github.com/your-repo/wvc-theme
 */


$id              = get_the_ID();
$wvc_editor_meta = \WVC\Core\Core::get_wvc_editor_meta($id);

# if this is vibecode page, then we need to output the HTML template

# if there is a single template, then we need to output it instead of the default single

$has_wvc_single_template = false;
$single_content          = '';

// Get current post type
$current_post_type = get_post_type();

// Determine template type value
// post -> 'single'
// testimonial -> 'single_testimonial'
$template_type_value = ($current_post_type === 'post')
    ? 'single'
    : "single_{$current_post_type}";

// Query for CPT-specific template
$single_template = get_posts(array(
    'post_type'      => 'wvc_template',
    'post_status'    => 'publish',
    'meta_query'     => array(
        array(
            'key'     => '_wvc_template_type',
            'value'   => $template_type_value,
            'compare' => '='
        )
    ),
    'posts_per_page' => 1,
    'orderby'        => 'ID',
    'order'          => 'ASC'
));

// Fallback to generic 'single' template if CPT-specific not found
if (empty($single_template) && $current_post_type !== 'post') {
    $single_template = get_posts(array(
        'post_type'      => 'wvc_template',
        'post_status'    => 'publish',
        'meta_query'     => array(
            array(
                'key'     => '_wvc_template_type',
                'value'   => 'single',
                'compare' => '='
            )
        ),
        'posts_per_page' => 1,
        'orderby'        => 'ID',
        'order'          => 'ASC'
    ));
}

if ( ! empty($single_template)) {
    $has_wvc_single_template = true;
    $single_post             = $single_template[0];
    $single_content          = $single_post->post_content;
}


if ($wvc_editor_meta || $has_wvc_single_template):

    // Pass variables to the template using get_template_part with args
    get_template_part('wvc-single', null, array(
        'single_content'          => $single_content,
        'has_wvc_single_template' => $has_wvc_single_template
    ));

    return;
endif;

get_header();
?>

    <main class="site-main bg-white min-h-screen">
        <div class="container mx-auto px-4 py-8 max-w-6xl">
            <div class="flex flex-col lg:flex-row gap-8">
                <div class="content-area flex-1">
                    <?php
                    while (have_posts()) :
                        the_post();
                        ?>
                        <article
                                id="post-<?php the_ID(); ?>" <?php post_class('post single-post bg-white rounded-lg border border-gray-500 overflow-hidden'); ?>>
                            <header class="post-header p-6 bg-primary-100">
                                <?php if (has_post_thumbnail()) : ?>
                                    <div class="post-thumbnail mb-6">
                                        <?php the_post_thumbnail('large',
                                            array('class' => 'w-full h-auto rounded-lg border border-gray-500')); ?>
                                    </div>
                                <?php endif; ?>

                                <h1 class="post-title text-3xl lg:text-4xl font-bold text-black mb-4 leading-tight"><?php the_title(); ?></h1>

                                <div class="post-meta flex flex-wrap items-center gap-4 text-sm text-gray-600 mb-6">
								<span class="post-date flex items-center">
									<svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
										<path fill-rule="evenodd"
                                              d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z"
                                              clip-rule="evenodd"></path>
									</svg>
									<time datetime="<?php echo get_the_date('c'); ?>">
										<?php echo get_the_date(); ?>
									</time>
								</span>
                                    <span class="post-author flex items-center">
									<svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
										<path fill-rule="evenodd"
                                              d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z"
                                              clip-rule="evenodd"></path>
									</svg>
									<?php _e('by', 'wvc-theme'); ?> &nbsp;
									<a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>"
                                       class="text-primary-600 hover:text-primary-800 font-medium">
										<?php the_author(); ?>
									</a>
								</span>
                                    <?php if (has_category()) : ?>
                                        <span class="post-categories flex items-center">
										<svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
											<path d="M7 3a1 1 0 000 2h6a1 1 0 100-2H7zM4 7a1 1 0 011-1h10a1 1 0 110 2H5a1 1 0 01-1-1zM2 11a2 2 0 012-2h12a2 2 0 012 2v4a2 2 0 01-2 2H4a2 2 0 01-2-2v-4z"></path>
										</svg>
										<?php _e('in', 'wvc-theme'); ?> &nbsp; <?php the_category(', '); ?>
									</span>
                                    <?php endif; ?>
                                    <span class="post-comments flex items-center">
									<svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
										<path fill-rule="evenodd"
                                              d="M18 10c0 3.866-3.582 7-8 7a8.841 8.841 0 01-4.083-.98L2 17l1.338-3.123C2.493 12.767 2 11.434 2 10c0-3.866 3.582-7 8-7s8 3.134 8 7zM7 9H5v2h2V9zm8 0h-2v2h2V9zM9 9h2v2H9V9z"
                                              clip-rule="evenodd"></path>
									</svg>
									<a href="<?php comments_link(); ?>" class="text-primary-600 hover:text-primary-800">
										<?php comments_number('0 Comments', '1 Comment', '% Comments'); ?>
									</a>
								</span>
                                </div>

                                <?php
                                // Display custom featured text if available
                                $featured_text = get_post_meta(get_the_ID(), '_wvc_featured_text', true);
                                if ( ! empty($featured_text)) :
                                    ?>
                                    <div class="post-featured-text bg-secondary-100 p-4 rounded-lg border-l-4 border-secondary-500">
                                        <p class="featured-text text-black italic"><?php echo esc_html($featured_text); ?></p>
                                    </div>
                                <?php endif; ?>
                            </header>

                            <div class="post-content p-6 text-black leading-relaxed">
                                <?php the_content(); ?>

                                <?php
                                wp_link_pages(
                                    array(
                                        'before' => '<div class="page-links mt-8 p-4 bg-gray-100 rounded-lg">' . esc_html__('Pages:',
                                                'wvc-theme'),
                                        'after'  => '</div>',
                                    )
                                );
                                ?>
                            </div>

                            <?php if (has_tag()) : ?>
                                <footer class="post-footer p-6 bg-gray-50 border-t border-gray-200">
                                    <div class="post-tags">
                                        <span class="text-sm font-medium text-gray-700 mr-2"><?php _e('Tags: ',
                                                'wvc-theme'); ?></span>
                                        <?php the_tags('', ', ', ''); ?>
                                    </div>
                                </footer>
                            <?php endif; ?>
                        </article>

                        <!-- Post navigation -->
                        <nav class="post-navigation mt-8 bg-white rounded-lg border border-gray-500 overflow-hidden"
                             role="navigation">
                            <h2 class="screen-reader-text"><?php _e('Post navigation', 'wvc-theme'); ?></h2>
                            <div class="nav-links flex flex-col md:flex-row">
                                <?php
                                $prev_post = get_previous_post();
                                $next_post = get_next_post();
                                ?>

                                <?php if ($prev_post) : ?>
                                    <div class="nav-previous flex-1 p-6 bg-primary-100 hover:bg-primary-200 transition-colors duration-200">
                                        <a href="<?php echo get_permalink($prev_post); ?>" rel="prev" class="block">
                                            <span class="nav-subtitle text-sm text-gray-600 block mb-1"><?php _e('Previous Post',
                                                    'wvc-theme'); ?></span>
                                            <span class="nav-title text-lg font-semibold text-black hover:text-primary-600 transition-colors duration-200"><?php echo get_the_title($prev_post); ?></span>
                                        </a>
                                    </div>
                                <?php endif; ?>

                                <?php if ($next_post) : ?>
                                    <div class="nav-next flex-1 p-6 bg-secondary-100 hover:bg-secondary-200 transition-colors duration-200">
                                        <a href="<?php echo get_permalink($next_post); ?>" rel="next" class="block">
                                            <span class="nav-subtitle text-sm text-gray-600 block mb-1"><?php _e('Next Post',
                                                    'wvc-theme'); ?></span>
                                            <span class="nav-title text-lg font-semibold text-black hover:text-secondary-600 transition-colors duration-200"><?php echo get_the_title($next_post); ?></span>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </nav>

                        <!-- Author bio -->
                        <?php if (get_the_author_meta('description')) : ?>
                        <div class="author-bio mt-8 bg-white rounded-lg border border-gray-500 p-6">
                            <div class="flex items-start space-x-4">
                                <div class="author-avatar flex-shrink-0">
                                    <?php echo get_avatar(get_the_author_meta('ID'), 80, '', '',
                                        array('class' => 'w-20 h-20 rounded-full border-4 border-primary-200')); ?>
                                </div>
                                <div class="author-info flex-1">
                                    <h3 class="author-title text-xl font-bold text-black mb-2">
                                        <?php _e('About', 'wvc-theme'); ?>
                                        <a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>"
                                           class="text-primary-600 hover:text-primary-800">
                                            <?php the_author(); ?>
                                        </a>
                                    </h3>
                                    <p class="author-description text-gray-700 leading-relaxed">
                                        <?php echo get_the_author_meta('description'); ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                        <!-- Related posts -->
                        <?php
                        $related_posts = get_posts(
                            array(
                                'category__in' => wp_get_post_categories(get_the_ID()),
                                'numberposts'  => 3,
                                'post__not_in' => array(get_the_ID()),
                                'orderby'      => 'rand',
                            )
                        );

                        if ($related_posts) :
                            ?>
                            <section class="related-posts mt-8 bg-white rounded-lg border border-gray-500 p-6">
                                <h3 class="text-2xl font-bold text-black mb-6"><?php _e('Related Posts',
                                        'wvc-theme'); ?></h3>
                                <div class="related-posts-grid grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                                    <?php foreach ($related_posts as $related) : ?>
                                        <article
                                                class="related-post bg-gray-50 rounded-lg overflow-hidden hover:border-gray-400 border border-gray-500 transition-colors duration-200">
                                            <?php if (has_post_thumbnail($related->ID)) : ?>
                                                <div class="related-post-thumbnail">
                                                    <a href="<?php echo get_permalink($related); ?>" class="block">
                                                        <?php echo get_the_post_thumbnail($related->ID, 'wvc-thumbnail',
                                                            array('class' => 'w-full h-48 object-cover')); ?>
                                                    </a>
                                                </div>
                                            <?php endif; ?>
                                            <div class="p-4">
                                                <h4 class="related-post-title text-lg font-semibold text-black mb-2">
                                                    <a href="<?php echo get_permalink($related); ?>"
                                                       class="hover:text-primary-600 transition-colors duration-200">
                                                        <?php echo get_the_title($related); ?>
                                                    </a>
                                                </h4>
                                                <div class="related-post-meta text-sm text-gray-600">
                                                    <?php echo get_the_date('', $related); ?>
                                                </div>
                                            </div>
                                        </article>
                                    <?php endforeach; ?>
                                </div>
                            </section>
                        <?php endif; ?>

                        <!-- Comments -->
                        <?php
                        if (comments_open() || get_comments_number()) :
                            comments_template();
                        endif;
                        ?>

                    <?php endwhile; ?>
                </div>

                <?php get_sidebar(); ?>
            </div>
        </div>
    </main>

<?php get_footer(); ?>