<?php
/**
 * Search Results Template
 *
 * This template displays search results. It shows a list of posts and pages
 * that match the search query, with search result counts and pagination.
 * Includes search form for new searches.
 *
 * @package    WVC_Theme
 * @subpackage Templates
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.0
 * @link       https://github.com/your-repo/wvc-theme
 */

get_header(); ?>

<main class="site-main bg-white min-h-screen">
    <div class="container mx-auto px-4 py-8">
        <div class="max-w-7xl mx-auto">
            <?php if (have_posts()) : ?>
                <header class="page-header mb-8">
                    <h1 class="page-title text-3xl font-bold text-black mb-4">
                        <?php
                        printf(
                            esc_html__("Search Results for: %s", "wvc-theme"),
                            "<span class=\"text-primary-500\">" . get_search_query() . "</span>"
                        );
                        ?>
                    </h1>
                    <p class="text-gray-600">
                        <?php printf(esc_html__("Found %d results", "wvc-theme"), $wp_query->found_posts); ?>
                    </p>
                </header>

                <div class="posts-container">
                    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                        <?php while (have_posts()) : the_post(); ?>
                            <article id="post-<?php the_ID(); ?>" <?php post_class("post search-result bg-white border border-gray-500 rounded-lg overflow-hidden hover:border-primary-500 transition-colors duration-200"); ?>>
                                <?php if (has_post_thumbnail()) : ?>
                                    <div class="post-thumbnail">
                                        <a href="<?php the_permalink(); ?>" class="block">
                                            <?php the_post_thumbnail("medium", array("class" => "w-full h-48 object-cover")); ?>
                                        </a>
                                    </div>
                                <?php endif; ?>
                                
                                <div class="p-6">
                                    <header class="post-header mb-4">
                                        <h2 class="post-title text-xl font-semibold text-black mb-2">
                                            <a href="<?php the_permalink(); ?>" class="hover:text-primary-500 transition-colors duration-200">
                                                <?php the_title(); ?>
                                            </a>
                                        </h2>
                                        
                                        <div class="post-meta flex flex-wrap gap-4 text-sm text-gray-600">
                                            <span class="post-type bg-primary-100 text-primary-700 px-2 py-1 rounded-full text-xs font-medium">
                                                <?php echo get_post_type(); ?>
                                            </span>
                                            <span class="post-date">
                                                <time datetime="<?php echo get_the_date("c"); ?>">
                                                    <?php echo get_the_date(); ?>
                                                </time>
                                            </span>
                                        </div>
                                    </header>

                                    <div class="post-content">
                                        <div class="text-gray-700 leading-relaxed">
                                            <?php the_excerpt(); ?>
                                        </div>
                                        
                                        <div class="mt-4">
                                            <a href="<?php the_permalink(); ?>" class="inline-block bg-primary-500 text-white px-4 py-2 rounded-md hover:bg-primary-600 transition-colors duration-200 text-sm font-medium">
                                                <?php _e("Read More", "wvc-theme"); ?>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </article>
                        <?php endwhile; ?>
                    </div>
                </div>

                <div class="pagination-container mt-12">
                    <?php
                    the_posts_pagination(
                        array(
                            "mid_size" => 2,
                            "prev_text" => __("Previous", "wvc-theme"),
                            "next_text" => __("Next", "wvc-theme"),
                            "class" => "flex justify-center items-center space-x-2",
                            "prev_class" => "bg-primary-500 text-white px-4 py-2 rounded-md hover:bg-primary-600 transition-colors duration-200",
                            "next_class" => "bg-primary-500 text-white px-4 py-2 rounded-md hover:bg-primary-600 transition-colors duration-200",
                            "current_class" => "bg-primary-900 text-white px-4 py-2 rounded-md",
                            "link_class" => "bg-gray-100 text-gray-700 px-4 py-2 rounded-md hover:bg-gray-200 transition-colors duration-200"
                        )
                    );
                    ?>
                </div>

            <?php else : ?>
                <section class="no-results bg-primary-100 rounded-lg p-8 text-center">
                    <header class="page-header mb-6">
                        <h1 class="page-title text-3xl font-bold text-black mb-4">
                            <?php _e("Nothing Found", "wvc-theme"); ?>
                        </h1>
                    </header>

                    <div class="page-content">
                        <p class="text-gray-700 mb-8 text-lg">
                            <?php _e("Sorry, but nothing matched your search terms. Please try again with some different keywords.", "wvc-theme"); ?>
                        </p>
                        
                        <div class="max-w-md mx-auto">
                            <?php get_search_form(); ?>
                        </div>
                        
                        <div class="mt-8">
                            <a href="<?php echo esc_url(home_url("/")); ?>" class="inline-block bg-primary-500 text-white px-6 py-3 rounded-md hover:bg-primary-600 transition-colors duration-200 font-medium">
                                <?php _e("Back to Home", "wvc-theme"); ?>
                            </a>
                        </div>
                    </div>
                </section>
            <?php endif; ?>
        </div>
    </div>
</main>

<?php get_footer(); ?> 