<?php
/**
 * Main Index Template
 *
 * This is the main template file and serves as the fallback for all other templates.
 * It displays the main content-managers loop and handles various post formats and layouts.
 * This template is used when no more specific template can be found.
 *
 * @package    WVC_Theme
 * @subpackage Templates
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.0
 * @link       https://github.com/your-repo/wvc-theme
 */

get_header(); ?>

<?php if (is_singular()) : ?>
    <!-- Single Item Layout (using page.php as reference) -->
    <main class="site-main bg-white min-h-screen">
        <div class="container mx-auto px-4 py-8 max-w-7xl">
            <div class="grid grid-cols-1 gap-8">
                <div class="content-area lg:col-span-2">
                    <?php while (have_posts()) : the_post(); ?>
                        <article id="post-<?php the_ID(); ?>" <?php post_class("page overflow-hidden"); ?>>
                            <header class="page-header bg-primary-100 p-6 border-b border-gray-200">
                                <?php if (has_post_thumbnail()) : ?>
                                    <div class="page-thumbnail mb-6">
                                        <?php the_post_thumbnail("large", array("class" => "w-full h-auto rounded-lg")); ?>
                                    </div>
                                <?php endif; ?>
                                
                                <h1 class="page-title text-3xl font-bold text-black mb-4"><?php the_title(); ?></h1>
                                
                                <div class="post-meta text-sm text-gray-600 space-x-4">
                                    <span class="post-date">
                                        <time datetime="<?php echo get_the_date('c'); ?>">
                                            <?php echo get_the_date(); ?>
                                        </time>
                                    </span>
                                    <span class="post-author">
                                        <?php _e('by', 'wvc-theme'); ?> <?php the_author(); ?>
                                    </span>
                                    <?php if (has_category()) : ?>
                                        <span class="post-categories">
                                            <?php _e('in', 'wvc-theme'); ?> <?php the_category(', '); ?>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </header>

                            <div class="page-content p-6 bg-white">
                                <div class="prose prose-lg max-w-none text-black">
                                    <?php the_content(); ?>
                                </div>
                                
                                <?php if (has_tag()) : ?>
                                    <footer class="post-footer mt-6 pt-4 border-t border-gray-200">
                                        <div class="post-tags text-sm text-gray-600">
                                            <?php the_tags(__('Tags: ', 'wvc-theme'), ', ', ''); ?>
                                        </div>
                                    </footer>
                                <?php endif; ?>
                                
                                <?php
                                wp_link_pages(
                                    array(
                                        "before" => "<div class=\"page-links mt-8 p-4 bg-gray-100 rounded-lg\"><span class=\"font-semibold text-black\">" . esc_html__("Pages:", "wvc-theme") . "</span>",
                                        "after"  => "</div>",
                                    )
                                );
                                ?>
                            </div>
                        </article>

                        <?php
                        // If comments are open or we have at least one comment, load up the comment template.
                        if (comments_open() || get_comments_number()) :
                            echo '<div class="mt-8 bg-white rounded-lg border border-gray-500 overflow-hidden">';
                            comments_template();
                            echo '</div>';
                        endif;
                        ?>

                    <?php endwhile; ?>
                </div>

                <div class="sidebar-area lg:col-span-1">
                    <?php get_sidebar(); ?>
                </div>
            </div>
        </div>
    </main>

<?php else : ?>
    <!-- Non-Singular Layout (using archive.php as reference) -->
    <main class="site-main bg-white min-h-screen">
        <div class="container mx-auto px-4 py-8">
            <div class="max-w-7xl mx-auto">
                <?php if (have_posts()) : ?>
                    <header class="page-header mb-12 text-center">
                        <?php if (is_home() && !is_front_page()) : ?>
                            <h1 class="page-title text-4xl font-bold text-black mb-4"><?php single_post_title(); ?></h1>
                        <?php else : ?>
                            <h1 class="page-title text-4xl font-bold text-black mb-4"><?php _e('Latest Posts', 'wvc-theme'); ?></h1>
                        <?php endif; ?>
                    </header>

                    <div class="posts-container">
                        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                            <?php
                            while (have_posts()) :
                                the_post();
                                ?>
                                <article id="post-<?php the_ID(); ?>" <?php post_class('post bg-white border border-gray-500 rounded-lg overflow-hidden hover:border-primary-500 transition-colors duration-300'); ?>>
                                    <?php if (has_post_thumbnail()) : ?>
                                        <div class="post-thumbnail">
                                            <a href="<?php the_permalink(); ?>" class="block">
                                                <?php the_post_thumbnail('wvc-featured', array('class' => 'w-full h-48 object-cover')); ?>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <div class="p-6">
                                        <header class="post-header mb-4">
                                            <h2 class="post-title text-xl font-semibold text-black mb-3">
                                                <a href="<?php the_permalink(); ?>" class="hover:text-primary-500 transition-colors duration-300"><?php the_title(); ?></a>
                                            </h2>
                                            
                                            <div class="post-meta text-sm text-gray-600 space-x-4">
                                                <span class="post-date">
                                                    <time datetime="<?php echo get_the_date('c'); ?>">
                                                        <?php echo get_the_date(); ?>
                                                    </time>
                                                </span>
                                                <span class="post-author">
                                                    <?php _e('by', 'wvc-theme'); ?> <?php the_author(); ?>
                                                </span>
                                                <?php if (has_category()) : ?>
                                                    <span class="post-categories">
                                                        <?php _e('in', 'wvc-theme'); ?> <?php the_category(', '); ?>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </header>

                                        <div class="post-content">
                                            <div class="text-gray-700 mb-4 line-clamp-3">
                                                <?php the_excerpt(); ?>
                                            </div>
                                            <a href="<?php the_permalink(); ?>" class="inline-block bg-primary-500 text-white px-6 py-2 rounded-md hover:bg-primary-600 transition-colors duration-300">
                                                <?php _e('Read More', 'wvc-theme'); ?>
                                            </a>
                                        </div>
                                    </div>
                                </article>
                            <?php endwhile; ?>
                        </div>
                    </div>

                    <!-- React Component for Dynamic Content -->
                    <div id="react-post-loader" class="react-component mt-8"></div>

                    <?php
                    // Pagination with Tailwind styles
                    $pagination = get_the_posts_pagination(
                        array(
                            'mid_size'  => 2,
                            'prev_text' => __('Previous', 'wvc-theme'),
                            'next_text' => __('Next', 'wvc-theme'),
                        )
                    );
                    
                    // Apply Tailwind classes to pagination
                    $pagination = str_replace(
                        array(
                            '<nav class="navigation pagination"',
                            '<div class="nav-links"',
                            '<span aria-current="page" class="page-numbers current"',
                            '<a class="page-numbers"',
                            '<a class="prev page-numbers"',
                            '<a class="next page-numbers"',
                        ),
                        array(
                            '<nav class="navigation pagination mt-12"',
                            '<div class="nav-links flex justify-center items-center space-x-2"',
                            '<span aria-current="page" class="page-numbers current bg-primary-500 text-white px-4 py-2 rounded-md"',
                            '<a class="page-numbers bg-white border border-gray-500 text-black px-4 py-2 rounded-md hover:bg-primary-500 hover:text-white transition-colors duration-300"',
                            '<a class="prev page-numbers bg-white border border-gray-500 text-black px-4 py-2 rounded-md hover:bg-primary-500 hover:text-white transition-colors duration-300"',
                            '<a class="next page-numbers bg-white border border-gray-500 text-black px-4 py-2 rounded-md hover:bg-primary-500 hover:text-white transition-colors duration-300"',
                        ),
                        $pagination
                    );
                    
                    echo $pagination;
                    ?>

                <?php else : ?>
                    <section class="no-results bg-gray-100 rounded-lg p-8 text-center">
                        <header class="page-header mb-6">
                            <h1 class="page-title text-3xl font-bold text-black mb-4"><?php _e('Nothing here', 'wvc-theme'); ?></h1>
                        </header>

                        <div class="page-content">
                            <?php if (is_home() && current_user_can('publish_posts')) : ?>
                                <p class="text-gray-700 mb-6">
                                <?php
                                printf(
                                    wp_kses(
                                        __('Ready to publish your first post? <a href="%1$s" class="text-primary-500 hover:text-primary-600 underline">Get started here</a>.', 'wvc-theme'),
                                        array(
                                            'a' => array(
                                                'href' => array(),
                                                'class' => array(),
                                            ),
                                        )
                                    ),
                                    esc_url(admin_url('post-new.php'))
                                );
                                ?>
                                </p>
                            <?php elseif (is_search()) : ?>
                                <p class="text-gray-700 mb-6"><?php _e('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'wvc-theme'); ?></p>
                                <div class="max-w-md mx-auto">
                                    <?php get_search_form(); ?>
                                </div>
                            <?php else : ?>
                                <p class="text-gray-700 mb-6"><?php _e('It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'wvc-theme'); ?></p>
                                <div class="max-w-md mx-auto">
                                    <?php get_search_form(); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </section>
                <?php endif; ?>
            </div>
        </div>
    </main>
<?php endif; ?>

<?php get_footer(); ?>