<?php

/**
 *  REST API functionality
 *
 * This file contains REST API endpoints for deleting and restoring posts
 * using the wvc_delete_post and wvc_restore_post functions.
 */

// Prevent direct access
use Tenweb_Authorization\Helper;

if ( ! defined("ABSPATH")) {
    exit;
}

/**
 * Class WVC_Menu_REST_API
 *
 * Enables and configures WordPress native menu REST API endpoints
 */
class WVC_REST_API
{

    /**
     * The namespace for the REST API
     *
     * @var string
     */
    protected $namespace = 'wvc/v1';

    /**
     * Initialize the class
     */
    public function __construct()
    {
        add_action('rest_api_init', array($this, 'register_routes'));
    }

    /**
     * Check if a user has permission to access the API
     *
     */
    public function permissions_check($request, $cap = null)
    {
        //1. nonce + $cap
        //2. token + cap(later when multiuser feature is implemented)

        // first check if we get request with tenweb-authorization token
        $auth  = Helper::get_instance();
        $token = $request->get_header('tenweb-authorization');

        // if token is empty, check if we got a nonce , its valid and current user  has enough capabilities
        if (empty($token)) {
            if (!empty($request->get_param('wvc_theme_nonce'))) {
                if (check_ajax_referer('wvc_nonce', 'wvc_theme_nonce', false)) {
                    if ($cap) {
                        if (current_user_can($cap)) {
                            return true;
                        }
                    }
                } else {
                    return new WP_Error(
                        'wrong_nonce',
                        __('Wrong nonce', 'wvc-theme'),
                        array('status' => 401)
                    );
                }
            }
        }

        // if we got a token , check if it's valid
        if ( ! empty($token)) {
            if ($auth->check_single_token($token)) {

                return true;
            }

            return new WP_Error(
                'unauthorized',
                __('Unauthorized', 'wvc-theme'),
                array('status' => 401)
            );
        }
    }
}
