<?php

namespace WVC\Includes;

/**
 * WVC Theme Includes Loader
 *
 * This file loads all plugin-related functionality and modules
 * for the WVC theme including core, editor, REST API, and other features.
 *
 * @package    WVC_Theme
 * @subpackage Includes
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.0
 */

// Prevent direct access
if ( ! defined("ABSPATH")) {
    exit;
}
include_once get_template_directory() . '/includes/config.php';


// Load Composer autoloader for vendor dependencies
if (file_exists(get_template_directory() . '/vendor/autoload.php')) {
    require_once get_template_directory() . '/vendor/autoload.php';
}

/**
 * WVC Includes Loader Class
 * 
 * Handles loading all includes and modules for the WVC theme
 */
class Loader {
    
    /**
     * Constructor
     */
    public function __construct() {
        $this->init_hooks();
    }
    
    /**
     * Initialize hooks
     */
    private function init_hooks() {
        // Load includes immediately to ensure functions are available
        $this->load_includes();
        
        // Hook to load includes after theme setup for any additional setup
        add_action("after_setup_theme", array($this, "after_theme_setup"));


    }
    
    /**
     * Load all includes and modules
     */
    public function load_includes() {
        // Theme functionality
        require_once get_template_directory() . "/includes/theme/theme.php";
        require_once get_template_directory() . "/includes/theme/debug-menu.php";
        
        // Core functionality
        require_once get_template_directory() . "/includes/core.php";
        
        // Editor functionality
       require_once get_template_directory() . "/includes/editor/editor.php";
        require_once get_template_directory() . "/includes/editor/admin.php";
        
        // Import functionality
       require_once get_template_directory() . "/includes/import/import.php";


        // REST API functionality
        require_once get_template_directory() . '/includes/rest/wvc-import-rest-api.php';
        require_once get_template_directory() . '/includes/rest/wvc-menu-rest-api.php';
        require_once get_template_directory() . '/includes/rest/wvc-page-rest-api.php';
        require_once get_template_directory() . '/includes/rest/wvc-post-rest-api.php';
        require_once get_template_directory() . '/includes/rest/wvc-delete-restore-rest-api.php';
        require_once get_template_directory() . '/includes/rest/wvc-settings-rest-api.php';
        require_once get_template_directory() . '/includes/rest/wvc-custom-post-type-rest-api.php';


        // Bulk operations
        require_once get_template_directory() . "/includes/bulk-operations/bulk-loader.php";
        require_once get_template_directory() . "/includes/bulk-operations/custom-post-types-loader.php";

        // Custom Post Type Meta Box Handler
        require_once get_template_directory() . "/includes/wvc-cpt-meta-box.php";

        // Custom Post Type Admin Columns and Filters
        require_once get_template_directory() . "/includes/wvc-cpt-admin-columns.php";

        // VC content management
        require_once get_template_directory() . "/includes/vc-content.php";
        
        // Templates hierarchy
        require_once get_template_directory() . "/includes/templates_hierarchy.php";

        require_once get_template_directory() . "/includes/update-check/wvc-tenweb-api.php";
        require_once get_template_directory() . "/includes/update-check/update-checker.php";
        


        
        // WP CLI commands (only if WP_CLI is available)
        if (defined("WP_CLI") && constant("WP_CLI")) {
            require_once get_template_directory() . "/includes/wvc-cli.php";
            if (class_exists("WVC_CLI")) {
                \WVC_CLI::register_commands();
            }
        }
        
    }
    
    /**
     * Additional setup after theme is loaded
     */
    public function after_theme_setup() {
        // Initialize the theme core functionality
        new \WVC\Includes\Theme\Theme_Core();
        
        // Initialize editor and admin functionality
        new \WVC\Editor\Editor();
        new \WVC\Editor\Admin();
    }

}


// Initialize the includes loader
new Loader();

