<?php

namespace WVC\FormSubmissions;

/**
 * WVC Form Submissions Module
 *
 * Main entry point for form submissions functionality
 *
 * @package    WVC_Theme
 * @subpackage FormSubmissions
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.16
 */

// Prevent direct access
if ( ! defined("ABSPATH")) {
    exit;
}

// Include all form submission files
require_once __DIR__ . '/post-type.php';
require_once __DIR__ . '/form-handler.php';
require_once __DIR__ . '/helpers.php';
require_once __DIR__ . '/admin.php';

/**
 * Initialize form submissions functionality
 */
function init_form_submissions() {
    // Register post type
    add_action('init', __NAMESPACE__ . '\wvc_register_form_data_post_type');
    
    // Register AJAX actions
    add_action('init', __NAMESPACE__ . '\wvc_register_ajax_actions');
    
    // Admin interface hooks
    add_filter('manage_wvc_form_data_posts_columns', __NAMESPACE__ . '\wvc_add_form_data_columns');
    add_action('manage_wvc_form_data_posts_custom_column', __NAMESPACE__ . '\wvc_display_form_data_columns', 10, 2);
    add_action('add_meta_boxes', __NAMESPACE__ . '\wvc_add_form_submission_meta_box');
    add_action('admin_menu', __NAMESPACE__ . '\wvc_remove_default_custom_fields');
    add_action('admin_head', __NAMESPACE__ . '\wvc_admin_form_submission_styles');
    add_action('admin_head', __NAMESPACE__ . '\wvc_admin_enhanced_styles_scripts');
    add_action('wp_dashboard_setup', __NAMESPACE__ . '\wvc_add_dashboard_widget');
    add_action('admin_notices', __NAMESPACE__ . '\wvc_admin_form_stats_notice');
    
    // Form overview and filtering hooks
    add_action('admin_menu', __NAMESPACE__ . '\wvc_add_form_overview_menu');
    add_action('admin_menu', __NAMESPACE__ . '\wvc_remove_add_new_button', 999);
    add_action('admin_head', __NAMESPACE__ . '\wvc_hide_add_new_button_css');
    add_action('restrict_manage_posts', __NAMESPACE__ . '\wvc_add_form_id_filter');
    add_action('pre_get_posts', __NAMESPACE__ . '\wvc_filter_submissions_by_form_id');
}

// Initialize the module
init_form_submissions();