/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-11-24 13:32:27 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`),
  KEY `woo_idx_comment_date_type` (`comment_date_gmt`,`comment_type`,`comment_approved`,`comment_post_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=504 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=351 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=111 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actioned_text` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `coupon_id` bigint NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `product_qty` int NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint NOT NULL,
  `product_or_parent_id` bigint NOT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `term_id` bigint NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `global_unique_id` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint DEFAULT '0',
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate_limit_expiry` bigint unsigned NOT NULL,
  `rate_limit_remaining` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint NOT NULL,
  `failure_count` smallint NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`),
  KEY `session_expiry` (`session_expiry`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `zone_id` (`zone_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint unsigned NOT NULL,
  `instance_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint unsigned NOT NULL,
  `tax_rate_compound` int NOT NULL DEFAULT '0',
  `tax_rate_shipping` int NOT NULL DEFAULT '1',
  `tax_rate_order` bigint unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpfm_backup` (
  `id` int NOT NULL AUTO_INCREMENT,
  `backup_name` text COLLATE utf8mb4_unicode_520_ci,
  `backup_date` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("51", "action_scheduler/migration_hook", "complete", "2025-11-24 13:20:54", "2025-11-24 13:20:54", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1763990454;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1763990454;}", "1", "1", "2025-11-24 13:24:32", "2025-11-24 13:24:32", "2", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("1", "51", "action created", "2025-11-24 13:19:54", "2025-11-24 13:19:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("2", "51", "action started via WP Cron", "2025-11-24 13:24:32", "2025-11-24 13:24:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("3", "51", "action complete via WP Cron", "2025-11-24 13:24:32", "2025-11-24 13:24:32");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20251124_asfiroadsde", "4d66dde32c265f808922_20251124133215", "21", "2025-11-24 13:32:27", "Madison22@gmail.com", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-11-24 13:32:15\";s:7:\"Version\";s:6:\"1.5.13\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.34\";s:10:\"VersionPHP\";s:6:\"8.3.23\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:20:\"20251124_asfiroadsde\";s:4:\"Hash\";s:35:\"4d66dde32c265f808922_20251124133215\";s:8:\"NameHash\";s:56:\"20251124_asfiroadsde_4d66dde32c265f808922_20251124133215\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:66:\"20251124_asfiroadsde_4d66dde32c265f808922_20251124133215_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.2\";s:6:\"WPUser\";s:19:\"Madison22@gmail.com\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20251124_asfiroadsde_4d66dde32c265f808922_20251124133215_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:24:\"/home/wplive/web/wp-live\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1259;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:6995;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-11-24 13:32:15\";s:7:\"Version\";s:6:\"1.5.13\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.34\";s:10:\"VersionPHP\";s:6:\"8.3.23\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:20:\"20251124_asfiroadsde\";s:4:\"Hash\";s:35:\"4d66dde32c265f808922_20251124133215\";s:8:\"NameHash\";s:56:\"20251124_asfiroadsde_4d66dde32c265f808922_20251124133215\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:74:\"20251124_asfiroadsde_4d66dde32c265f808922_20251124133215_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:38:\"/home/wplive/web/wp-live/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:69:\"20251124_asfiroadsde_4d66dde32c265f808922_20251124133215_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:126:\"/home/wplive/web/wp-live/wp-content/backups-dup-lite/tmp/20251124_asfiroadsde_4d66dde32c265f808922_20251124133215_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:33:\"/home/wplive/web/wp-live/wp-admin\";i:1;s:36:\"/home/wplive/web/wp-live/wp-includes\";i:2;s:45:\"/home/wplive/web/wp-live/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:24:\"/home/wplive/web/wp-live\";i:1;s:24:\"/home/wplive/web/wp-live\";i:2;s:35:\"/home/wplive/web/wp-live/wp-content\";i:3;s:43:\"/home/wplive/web/wp-live/wp-content/uploads\";i:4;s:43:\"/home/wplive/web/wp-live/wp-content/plugins\";i:5;s:46:\"/home/wplive/web/wp-live/wp-content/mu-plugins\";i:6;s:42:\"/home/wplive/web/wp-live/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:56:\"/home/wplive/web/wp-live/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "cron", "a:17:{i:1763993499;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1763993994;a:2:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1763998251;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"779824090289b105333c6256857f48cf\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:109;}}}}i:1763998281;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"d49a3459eab59251752f2409db1353bc\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:110;}}}}i:1764007899;a:2:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764011497;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764013297;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764015097;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764033894;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764076785;a:1:{s:19:\"two_daily_cron_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764076794;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764077094;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764077351;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764526299;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1764597600;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765043703;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("2", "siteurl", "https://concise-goshawk.10web.cloud", "on");
INSERT INTO `wp_options` VALUES("3", "home", "https://concise-goshawk.10web.cloud", "on");
INSERT INTO `wp_options` VALUES("4", "blogname", "asfiroads.de", "on");
INSERT INTO `wp_options` VALUES("5", "blogdescription", "", "on");
INSERT INTO `wp_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wp_options` VALUES("7", "admin_email", "Madison22@gmail.com", "on");
INSERT INTO `wp_options` VALUES("8", "start_of_week", "1", "on");
INSERT INTO `wp_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wp_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wp_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wp_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wp_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wp_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wp_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wp_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wp_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `wp_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wp_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wp_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wp_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wp_options` VALUES("22", "default_pingback_flag", "1", "on");
INSERT INTO `wp_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `wp_options` VALUES("24", "date_format", "F j, Y", "on");
INSERT INTO `wp_options` VALUES("25", "time_format", "g:i a", "on");
INSERT INTO `wp_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `wp_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `wp_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wp_options` VALUES("29", "permalink_structure", "/%postname%/", "on");
INSERT INTO `wp_options` VALUES("30", "rewrite_rules", "a:106:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:44:\"template-hierarchy/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"template-hierarchy/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"template-hierarchy/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"template-hierarchy/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"template-hierarchy/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"template-hierarchy/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"template-hierarchy/(.+?)/embed/?$\";s:45:\"index.php?wvc_template=$matches[1]&embed=true\";s:37:\"template-hierarchy/(.+?)/trackback/?$\";s:39:\"index.php?wvc_template=$matches[1]&tb=1\";s:45:\"template-hierarchy/(.+?)/page/?([0-9]{1,})/?$\";s:52:\"index.php?wvc_template=$matches[1]&paged=$matches[2]\";s:52:\"template-hierarchy/(.+?)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?wvc_template=$matches[1]&cpage=$matches[2]\";s:41:\"template-hierarchy/(.+?)(?:/([0-9]+))?/?$\";s:51:\"index.php?wvc_template=$matches[1]&page=$matches[2]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=68&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "on");
INSERT INTO `wp_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wp_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wp_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wp_options` VALUES("34", "active_plugins", "a:4:{i:0;s:25:\"duplicator/duplicator.php\";i:1;s:36:\"oneclickweb/text-replacer-plugin.php\";i:2;s:39:\"wp-file-manager/file_folder_manager.php\";i:3;s:45:\"wp-plugin-management/wp-plugin-management.php\";}", "on");
INSERT INTO `wp_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wp_options` VALUES("36", "ping_sites", "https://rpc.pingomatic.com/", "on");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "0", "on");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "", "off");
INSERT INTO `wp_options` VALUES("41", "template", "wvc-theme", "on");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "wvc-theme", "on");
INSERT INTO `wp_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `wp_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wp_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wp_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `wp_options` VALUES("47", "db_version", "60421", "on");
INSERT INTO `wp_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wp_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wp_options` VALUES("50", "blog_public", "1", "on");
INSERT INTO `wp_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wp_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `wp_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wp_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wp_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wp_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wp_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wp_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wp_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wp_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `wp_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wp_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wp_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wp_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wp_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wp_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `wp_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wp_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wp_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wp_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `wp_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wp_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wp_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wp_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("77", "widget_categories", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("78", "widget_text", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("79", "widget_rss", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("80", "uninstall_plugins", "a:2:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:49:\"tenweb-speed-optimizer/tenweb_speed_optimizer.php\";a:2:{i:0;s:31:\"\\TenWebOptimizer\\OptimizerAdmin\";i:1;s:13:\"two_uninstall\";}}", "off");
INSERT INTO `wp_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `wp_options` VALUES("82", "page_for_posts", "0", "on");
INSERT INTO `wp_options` VALUES("83", "page_on_front", "68", "on");
INSERT INTO `wp_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wp_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wp_options` VALUES("87", "site_icon", "0", "on");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wp_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wp_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wp_options` VALUES("92", "admin_email_lifespan", "1779473497", "on");
INSERT INTO `wp_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wp_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wp_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wp_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wp_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("101", "initial_db_version", "60421", "on");
INSERT INTO `wp_options` VALUES("102", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:115:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:16:\"create_customers\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:93:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:16:\"create_customers\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}}", "on");
INSERT INTO `wp_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("104", "user_count", "1", "off");
INSERT INTO `wp_options` VALUES("105", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("106", "sidebars_widgets", "a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `wp_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("116", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("117", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("118", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("119", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("120", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("121", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:5:\"6.8.3\";s:5:\"files\";a:536:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:26:\"post-content/style-rtl.css\";i:309;s:30:\"post-content/style-rtl.min.css\";i:310;s:22:\"post-content/style.css\";i:311;s:26:\"post-content/style.min.css\";i:312;s:23:\"post-date/style-rtl.css\";i:313;s:27:\"post-date/style-rtl.min.css\";i:314;s:19:\"post-date/style.css\";i:315;s:23:\"post-date/style.min.css\";i:316;s:27:\"post-excerpt/editor-rtl.css\";i:317;s:31:\"post-excerpt/editor-rtl.min.css\";i:318;s:23:\"post-excerpt/editor.css\";i:319;s:27:\"post-excerpt/editor.min.css\";i:320;s:26:\"post-excerpt/style-rtl.css\";i:321;s:30:\"post-excerpt/style-rtl.min.css\";i:322;s:22:\"post-excerpt/style.css\";i:323;s:26:\"post-excerpt/style.min.css\";i:324;s:34:\"post-featured-image/editor-rtl.css\";i:325;s:38:\"post-featured-image/editor-rtl.min.css\";i:326;s:30:\"post-featured-image/editor.css\";i:327;s:34:\"post-featured-image/editor.min.css\";i:328;s:33:\"post-featured-image/style-rtl.css\";i:329;s:37:\"post-featured-image/style-rtl.min.css\";i:330;s:29:\"post-featured-image/style.css\";i:331;s:33:\"post-featured-image/style.min.css\";i:332;s:34:\"post-navigation-link/style-rtl.css\";i:333;s:38:\"post-navigation-link/style-rtl.min.css\";i:334;s:30:\"post-navigation-link/style.css\";i:335;s:34:\"post-navigation-link/style.min.css\";i:336;s:27:\"post-template/style-rtl.css\";i:337;s:31:\"post-template/style-rtl.min.css\";i:338;s:23:\"post-template/style.css\";i:339;s:27:\"post-template/style.min.css\";i:340;s:24:\"post-terms/style-rtl.css\";i:341;s:28:\"post-terms/style-rtl.min.css\";i:342;s:20:\"post-terms/style.css\";i:343;s:24:\"post-terms/style.min.css\";i:344;s:24:\"post-title/style-rtl.css\";i:345;s:28:\"post-title/style-rtl.min.css\";i:346;s:20:\"post-title/style.css\";i:347;s:24:\"post-title/style.min.css\";i:348;s:26:\"preformatted/style-rtl.css\";i:349;s:30:\"preformatted/style-rtl.min.css\";i:350;s:22:\"preformatted/style.css\";i:351;s:26:\"preformatted/style.min.css\";i:352;s:24:\"pullquote/editor-rtl.css\";i:353;s:28:\"pullquote/editor-rtl.min.css\";i:354;s:20:\"pullquote/editor.css\";i:355;s:24:\"pullquote/editor.min.css\";i:356;s:23:\"pullquote/style-rtl.css\";i:357;s:27:\"pullquote/style-rtl.min.css\";i:358;s:19:\"pullquote/style.css\";i:359;s:23:\"pullquote/style.min.css\";i:360;s:23:\"pullquote/theme-rtl.css\";i:361;s:27:\"pullquote/theme-rtl.min.css\";i:362;s:19:\"pullquote/theme.css\";i:363;s:23:\"pullquote/theme.min.css\";i:364;s:39:\"query-pagination-numbers/editor-rtl.css\";i:365;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:366;s:35:\"query-pagination-numbers/editor.css\";i:367;s:39:\"query-pagination-numbers/editor.min.css\";i:368;s:31:\"query-pagination/editor-rtl.css\";i:369;s:35:\"query-pagination/editor-rtl.min.css\";i:370;s:27:\"query-pagination/editor.css\";i:371;s:31:\"query-pagination/editor.min.css\";i:372;s:30:\"query-pagination/style-rtl.css\";i:373;s:34:\"query-pagination/style-rtl.min.css\";i:374;s:26:\"query-pagination/style.css\";i:375;s:30:\"query-pagination/style.min.css\";i:376;s:25:\"query-title/style-rtl.css\";i:377;s:29:\"query-title/style-rtl.min.css\";i:378;s:21:\"query-title/style.css\";i:379;s:25:\"query-title/style.min.css\";i:380;s:25:\"query-total/style-rtl.css\";i:381;s:29:\"query-total/style-rtl.min.css\";i:382;s:21:\"query-total/style.css\";i:383;s:25:\"query-total/style.min.css\";i:384;s:20:\"query/editor-rtl.css\";i:385;s:24:\"query/editor-rtl.min.css\";i:386;s:16:\"query/editor.css\";i:387;s:20:\"query/editor.min.css\";i:388;s:19:\"quote/style-rtl.css\";i:389;s:23:\"quote/style-rtl.min.css\";i:390;s:15:\"quote/style.css\";i:391;s:19:\"quote/style.min.css\";i:392;s:19:\"quote/theme-rtl.css\";i:393;s:23:\"quote/theme-rtl.min.css\";i:394;s:15:\"quote/theme.css\";i:395;s:19:\"quote/theme.min.css\";i:396;s:23:\"read-more/style-rtl.css\";i:397;s:27:\"read-more/style-rtl.min.css\";i:398;s:19:\"read-more/style.css\";i:399;s:23:\"read-more/style.min.css\";i:400;s:18:\"rss/editor-rtl.css\";i:401;s:22:\"rss/editor-rtl.min.css\";i:402;s:14:\"rss/editor.css\";i:403;s:18:\"rss/editor.min.css\";i:404;s:17:\"rss/style-rtl.css\";i:405;s:21:\"rss/style-rtl.min.css\";i:406;s:13:\"rss/style.css\";i:407;s:17:\"rss/style.min.css\";i:408;s:21:\"search/editor-rtl.css\";i:409;s:25:\"search/editor-rtl.min.css\";i:410;s:17:\"search/editor.css\";i:411;s:21:\"search/editor.min.css\";i:412;s:20:\"search/style-rtl.css\";i:413;s:24:\"search/style-rtl.min.css\";i:414;s:16:\"search/style.css\";i:415;s:20:\"search/style.min.css\";i:416;s:20:\"search/theme-rtl.css\";i:417;s:24:\"search/theme-rtl.min.css\";i:418;s:16:\"search/theme.css\";i:419;s:20:\"search/theme.min.css\";i:420;s:24:\"separator/editor-rtl.css\";i:421;s:28:\"separator/editor-rtl.min.css\";i:422;s:20:\"separator/editor.css\";i:423;s:24:\"separator/editor.min.css\";i:424;s:23:\"separator/style-rtl.css\";i:425;s:27:\"separator/style-rtl.min.css\";i:426;s:19:\"separator/style.css\";i:427;s:23:\"separator/style.min.css\";i:428;s:23:\"separator/theme-rtl.css\";i:429;s:27:\"separator/theme-rtl.min.css\";i:430;s:19:\"separator/theme.css\";i:431;s:23:\"separator/theme.min.css\";i:432;s:24:\"shortcode/editor-rtl.css\";i:433;s:28:\"shortcode/editor-rtl.min.css\";i:434;s:20:\"shortcode/editor.css\";i:435;s:24:\"shortcode/editor.min.css\";i:436;s:24:\"site-logo/editor-rtl.css\";i:437;s:28:\"site-logo/editor-rtl.min.css\";i:438;s:20:\"site-logo/editor.css\";i:439;s:24:\"site-logo/editor.min.css\";i:440;s:23:\"site-logo/style-rtl.css\";i:441;s:27:\"site-logo/style-rtl.min.css\";i:442;s:19:\"site-logo/style.css\";i:443;s:23:\"site-logo/style.min.css\";i:444;s:27:\"site-tagline/editor-rtl.css\";i:445;s:31:\"site-tagline/editor-rtl.min.css\";i:446;s:23:\"site-tagline/editor.css\";i:447;s:27:\"site-tagline/editor.min.css\";i:448;s:26:\"site-tagline/style-rtl.css\";i:449;s:30:\"site-tagline/style-rtl.min.css\";i:450;s:22:\"site-tagline/style.css\";i:451;s:26:\"site-tagline/style.min.css\";i:452;s:25:\"site-title/editor-rtl.css\";i:453;s:29:\"site-title/editor-rtl.min.css\";i:454;s:21:\"site-title/editor.css\";i:455;s:25:\"site-title/editor.min.css\";i:456;s:24:\"site-title/style-rtl.css\";i:457;s:28:\"site-title/style-rtl.min.css\";i:458;s:20:\"site-title/style.css\";i:459;s:24:\"site-title/style.min.css\";i:460;s:26:\"social-link/editor-rtl.css\";i:461;s:30:\"social-link/editor-rtl.min.css\";i:462;s:22:\"social-link/editor.css\";i:463;s:26:\"social-link/editor.min.css\";i:464;s:27:\"social-links/editor-rtl.css\";i:465;s:31:\"social-links/editor-rtl.min.css\";i:466;s:23:\"social-links/editor.css\";i:467;s:27:\"social-links/editor.min.css\";i:468;s:26:\"social-links/style-rtl.css\";i:469;s:30:\"social-links/style-rtl.min.css\";i:470;s:22:\"social-links/style.css\";i:471;s:26:\"social-links/style.min.css\";i:472;s:21:\"spacer/editor-rtl.css\";i:473;s:25:\"spacer/editor-rtl.min.css\";i:474;s:17:\"spacer/editor.css\";i:475;s:21:\"spacer/editor.min.css\";i:476;s:20:\"spacer/style-rtl.css\";i:477;s:24:\"spacer/style-rtl.min.css\";i:478;s:16:\"spacer/style.css\";i:479;s:20:\"spacer/style.min.css\";i:480;s:20:\"table/editor-rtl.css\";i:481;s:24:\"table/editor-rtl.min.css\";i:482;s:16:\"table/editor.css\";i:483;s:20:\"table/editor.min.css\";i:484;s:19:\"table/style-rtl.css\";i:485;s:23:\"table/style-rtl.min.css\";i:486;s:15:\"table/style.css\";i:487;s:19:\"table/style.min.css\";i:488;s:19:\"table/theme-rtl.css\";i:489;s:23:\"table/theme-rtl.min.css\";i:490;s:15:\"table/theme.css\";i:491;s:19:\"table/theme.min.css\";i:492;s:24:\"tag-cloud/editor-rtl.css\";i:493;s:28:\"tag-cloud/editor-rtl.min.css\";i:494;s:20:\"tag-cloud/editor.css\";i:495;s:24:\"tag-cloud/editor.min.css\";i:496;s:23:\"tag-cloud/style-rtl.css\";i:497;s:27:\"tag-cloud/style-rtl.min.css\";i:498;s:19:\"tag-cloud/style.css\";i:499;s:23:\"tag-cloud/style.min.css\";i:500;s:28:\"template-part/editor-rtl.css\";i:501;s:32:\"template-part/editor-rtl.min.css\";i:502;s:24:\"template-part/editor.css\";i:503;s:28:\"template-part/editor.min.css\";i:504;s:27:\"template-part/theme-rtl.css\";i:505;s:31:\"template-part/theme-rtl.min.css\";i:506;s:23:\"template-part/theme.css\";i:507;s:27:\"template-part/theme.min.css\";i:508;s:30:\"term-description/style-rtl.css\";i:509;s:34:\"term-description/style-rtl.min.css\";i:510;s:26:\"term-description/style.css\";i:511;s:30:\"term-description/style.min.css\";i:512;s:27:\"text-columns/editor-rtl.css\";i:513;s:31:\"text-columns/editor-rtl.min.css\";i:514;s:23:\"text-columns/editor.css\";i:515;s:27:\"text-columns/editor.min.css\";i:516;s:26:\"text-columns/style-rtl.css\";i:517;s:30:\"text-columns/style-rtl.min.css\";i:518;s:22:\"text-columns/style.css\";i:519;s:26:\"text-columns/style.min.css\";i:520;s:19:\"verse/style-rtl.css\";i:521;s:23:\"verse/style-rtl.min.css\";i:522;s:15:\"verse/style.css\";i:523;s:19:\"verse/style.min.css\";i:524;s:20:\"video/editor-rtl.css\";i:525;s:24:\"video/editor-rtl.min.css\";i:526;s:16:\"video/editor.css\";i:527;s:20:\"video/editor.min.css\";i:528;s:19:\"video/style-rtl.css\";i:529;s:23:\"video/style-rtl.min.css\";i:530;s:15:\"video/style.css\";i:531;s:19:\"video/style.min.css\";i:532;s:19:\"video/theme-rtl.css\";i:533;s:23:\"video/theme-rtl.min.css\";i:534;s:15:\"video/theme.css\";i:535;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wp_options` VALUES("124", "_transient_doing_cron", "1763990343.4318630695343017578125", "on");
INSERT INTO `wp_options` VALUES("125", "tenweb_version", "1.19.3", "off");
INSERT INTO `wp_options` VALUES("126", "tenweb_activated", "1", "off");
INSERT INTO `wp_options` VALUES("127", "wp_calendar_block_has_published_posts", "1", "auto");
INSERT INTO `wp_options` VALUES("128", "elementor_experiment-co_pilot", "active", "auto");
INSERT INTO `wp_options` VALUES("130", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.8.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.8.3.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.8.3-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.8.3-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.8.3\";s:7:\"version\";s:5:\"6.8.3\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1763990349;s:15:\"version_checked\";s:5:\"6.8.3\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("135", "elementor_active_kit", "4", "auto");
INSERT INTO `wp_options` VALUES("136", "elementor_font_display", "swap", "auto");
INSERT INTO `wp_options` VALUES("142", "theme_mods_twentytwentyfive", "a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1763921512;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("143", "current_theme", "WordPress AI Builder Theme", "auto");
INSERT INTO `wp_options` VALUES("144", "theme_switched", "", "auto");
INSERT INTO `wp_options` VALUES("147", "theme_mods_tenweb-website-builder-theme", "a:3:{s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1763990672;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("149", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1763990350;s:7:\"checked\";a:4:{s:28:\"tenweb-website-builder-theme\";s:6:\"2.1.19\";s:16:\"twentytwentyfive\";s:3:\"1.3\";s:16:\"twentytwentyfour\";s:3:\"1.3\";s:17:\"twentytwentythree\";s:3:\"1.6\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:3:{s:16:\"twentytwentyfive\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfive\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfive/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfive.1.3.zip\";s:8:\"requires\";s:3:\"6.7\";s:12:\"requires_php\";s:3:\"7.2\";}s:16:\"twentytwentyfour\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfour\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfour/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfour.1.3.zip\";s:8:\"requires\";s:3:\"6.4\";s:12:\"requires_php\";s:3:\"7.0\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.6.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("152", "tenweb_plugins_list", "a:21:{i:0;a:28:{s:10:\"product_id\";i:9;s:4:\"slug\";s:10:\"wd-youtube\";s:5:\"title\";s:16:\"YouTube by 10Web\";s:11:\"description\";s:74:\"Make your WordPress website more interactive with awesome video galleries.\";s:4:\"type\";s:6:\"plugin\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:14:\"wd-youtube.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:107:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/wd-youtube-2017-12-12.svg\";s:9:\"info_link\";s:43:\"https://10web.io/plugins/wordpress-youtube/\";s:9:\"demo_link\";s:33:\"https://demo.10web.io/youtube-wd/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:56:\"https://wordpress.org/support/plugin/wd-youtube/reviews/\";s:9:\"downloads\";i:2000;s:6:\"rating\";s:2:\"90\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:29;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:7:\"v1.0.36\";s:4:\"paid\";s:6:\"5.0.36\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2021-09-11 00:00:02\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:2:{i:0;i:5;i:1;i:1;}s:23:\"force_required_products\";a:1:{i:0;i:2;}s:16:\"required_service\";a:1:{i:0;i:2;}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:1;a:28:{s:10:\"product_id\";i:25;s:4:\"slug\";s:17:\"event-calendar-wd\";s:5:\"title\";s:23:\"Event calendar by 10Web\";s:11:\"description\";s:104:\"Organize and showcase your events through this easy-to-use and advanced WordPress Event Calendar plugin.\";s:4:\"type\";s:6:\"plugin\";s:6:\"author\";s:5:\"10WEB\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:1;s:8:\"zip_name\";s:21:\"event-calendar-wd.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:114:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/event-calendar-wd-2017-12-21.svg\";s:9:\"info_link\";s:50:\"https://10web.io/plugins/wordpress-event-calendar/\";s:9:\"demo_link\";s:40:\"https://demo.10web.io/event-calendar-wd/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:63:\"https://wordpress.org/support/plugin/event-calendar-wd/reviews/\";s:9:\"downloads\";i:20000;s:6:\"rating\";s:2:\"92\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:3;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:7:\"v1.1.55\";s:4:\"paid\";s:6:\"5.1.56\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2022-06-29 07:24:38\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:2;a:28:{s:10:\"product_id\";i:43;s:4:\"slug\";s:17:\"wd-instagram-feed\";s:5:\"title\";s:14:\"Instagram Feed\";s:11:\"description\";s:90:\"Display Instagram posts, photos & videos on your WordPress website in a matter of minutes.\";s:4:\"type\";s:6:\"plugin\";s:6:\"author\";s:5:\"10web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:21:\"wd-instagram-feed.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:114:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/wd-instagram-feed-2017-12-20.svg\";s:9:\"info_link\";s:50:\"https://10web.io/plugins/wordpress-instagram-feed/\";s:9:\"demo_link\";s:35:\"https://demo.10web.io/instagram-wd/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:63:\"https://wordpress.org/support/plugin/wd-instagram-feed/reviews/\";s:9:\"downloads\";i:20000;s:6:\"rating\";s:2:\"90\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:5;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:7:\"v1.4.35\";s:4:\"paid\";s:6:\"2.4.35\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2024-06-18 00:00:09\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:3;a:28:{s:10:\"product_id\";i:47;s:4:\"slug\";s:10:\"staff-team\";s:5:\"title\";s:13:\"Team by 10Web\";s:11:\"description\";s:96:\"Display the details of your team on your WordPress Website with the best team management plugin.\";s:4:\"type\";s:6:\"plugin\";s:6:\"author\";s:5:\"10web\";s:10:\"author_url\";s:16:\"http://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:14:\"staff-team.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:107:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/staff-team-2017-12-12.svg\";s:9:\"info_link\";s:40:\"https://10web.io/plugins/wordpress-team/\";s:9:\"demo_link\";s:30:\"https://demo.10web.io/team-wd/\";s:12:\"support_link\";s:30:\"https://help.10web.io/hc/en-us\";s:11:\"review_link\";s:56:\"https://wordpress.org/support/plugin/staff-team/reviews/\";s:9:\"downloads\";i:1000;s:6:\"rating\";s:2:\"94\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:22;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:6:\"v1.1.7\";s:4:\"paid\";s:5:\"5.1.7\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2021-07-16 00:00:03\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:4;a:28:{s:10:\"product_id\";i:49;s:4:\"slug\";s:6:\"faq-wd\";s:5:\"title\";s:6:\"FAQ WD\";s:11:\"description\";s:75:\"Add a simple, responsive, fully customizable FAQ to your WordPress website.\";s:4:\"type\";s:6:\"plugin\";s:6:\"author\";s:5:\"10web\";s:10:\"author_url\";s:16:\"http://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:10:\"faq-wd.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:103:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/faq-wd-2017-12-12.svg\";s:9:\"info_link\";s:39:\"https://10web.io/plugins/wordpress-faq/\";s:9:\"demo_link\";s:28:\"https://demo.10web.io/faq-2/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:52:\"https://wordpress.org/support/plugin/faq-wd/reviews/\";s:9:\"downloads\";i:1000;s:6:\"rating\";s:2:\"86\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:26;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:7:\"v1.0.41\";s:4:\"paid\";s:6:\"5.0.41\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2021-03-13 00:00:02\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:5;a:28:{s:10:\"product_id\";i:51;s:4:\"slug\";s:13:\"10web-manager\";s:5:\"title\";s:13:\"10Web Manager\";s:11:\"description\";s:102:\"Connect and manage all your WordPress websites in 10Web dashboard with the help of our Manager plugin.\";s:4:\"type\";s:6:\"plugin\";s:6:\"author\";s:5:\"10web\";s:10:\"author_url\";s:16:\"http://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:17:\"10web-manager.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:0:\"\";s:9:\"info_link\";s:16:\"http://10web.io/\";s:9:\"demo_link\";s:16:\"http://10web.io/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:28:\"https://10web.io/contact-us/\";s:9:\"downloads\";i:10000;s:6:\"rating\";s:2:\"82\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:100;s:13:\"download_link\";s:113:\"https://s3-us-west-2.amazonaws.com/10web-products-production/10web-manager/10web-manager/1.19.3/10web-manager.zip\";s:15:\"current_version\";a:2:{s:4:\"free\";s:7:\"v1.3.22\";s:4:\"paid\";s:6:\"1.19.3\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2025-10-17 08:31:32\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.0\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:6;a:28:{s:10:\"product_id\";i:69;s:4:\"slug\";s:18:\"image-optimizer-wd\";s:5:\"title\";s:15:\"Image Optimizer\";s:11:\"description\";s:122:\"Significantly improve load time of your WordPress website by optimizing your image files with the image optimizer service.\";s:4:\"type\";s:6:\"plugin\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:20:\"http://dev.10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:22:\"image-optimizer-wd.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:115:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/image-optimizer-wd-2017-12-12.svg\";s:9:\"info_link\";s:42:\"https://10web.io/services/image-optimizer/\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:64:\"https://wordpress.org/support/plugin/image-optimizer-wd/reviews/\";s:9:\"downloads\";i:4000;s:6:\"rating\";s:2:\"90\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:10;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:7:\"v6.0.67\";s:4:\"paid\";s:6:\"6.0.67\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2025-10-01 00:00:10\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:2:{i:0;i:5;i:1;i:1;}s:23:\"force_required_products\";a:1:{i:0;i:2;}s:16:\"required_service\";a:1:{i:0;i:2;}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:9:\"optimizer\";}i:7;a:28:{s:10:\"product_id\";i:71;s:4:\"slug\";s:9:\"backup-wd\";s:5:\"title\";s:9:\"Backup WD\";s:11:\"description\";s:101:\"Securely backup your WordPress site files and database with the simple, yet powerful backup solution.\";s:4:\"type\";s:6:\"plugin\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:16:\"https://10web.io\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:13:\"backup-wd.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:106:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/backup-wd-2017-12-12.svg\";s:9:\"info_link\";s:33:\"https://10web.io/services/backup/\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:55:\"https://wordpress.org/support/plugin/backup-wd/reviews/\";s:9:\"downloads\";i:7000;s:6:\"rating\";s:2:\"76\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:8;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:7:\"v1.0.20\";s:4:\"paid\";s:6:\"5.0.77\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2023-08-04 10:12:42\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:2:{i:0;i:5;i:1;i:1;}s:23:\"force_required_products\";a:1:{i:0;i:2;}s:16:\"required_service\";a:1:{i:0;i:2;}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:6:\"Backup\";}i:8;a:28:{s:10:\"product_id\";i:89;s:4:\"slug\";s:14:\"wd-google-maps\";s:5:\"title\";s:11:\"Google Maps\";s:11:\"description\";s:111:\"Google Maps WD is an intuitive tool for creating Google maps with advanced markers, custom layers and overlays.\";s:4:\"type\";s:6:\"plugin\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:1;s:8:\"zip_name\";s:18:\"wd-google-maps.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:111:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/wd-google-maps-2017-12-20.svg\";s:9:\"info_link\";s:47:\"https://10web.io/plugins/wordpress-google-maps/\";s:9:\"demo_link\";s:37:\"https://demo.10web.io/google-maps-wd/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:60:\"https://wordpress.org/support/plugin/wd-google-maps/reviews/\";s:9:\"downloads\";i:9000;s:6:\"rating\";s:2:\"90\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:6;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:7:\"v1.0.74\";s:4:\"paid\";s:6:\"5.0.74\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2023-09-14 00:00:13\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:2:{i:0;i:5;i:1;i:1;}s:23:\"force_required_products\";a:1:{i:0;i:2;}s:16:\"required_service\";a:1:{i:0;i:2;}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:9;a:28:{s:10:\"product_id\";i:91;s:4:\"slug\";s:13:\"ad-manager-wd\";s:5:\"title\";s:19:\"AD Manager by 10Web\";s:11:\"description\";s:80:\"Monetize your WordPress website by displaying ads on any page with Ad Manager WD\";s:4:\"type\";s:6:\"plugin\";s:6:\"author\";s:5:\"10web\";s:10:\"author_url\";s:16:\"http://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:17:\"ad-manager-wd.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:110:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/ad-manager-wd-2017-12-12.svg\";s:9:\"info_link\";s:46:\"https://10web.io/plugins/wordpress-ad-manager/\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:59:\"https://wordpress.org/support/plugin/ad-manager-wd/reviews/\";s:9:\"downloads\";i:200;s:6:\"rating\";s:2:\"64\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:30;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:7:\"v1.0.14\";s:4:\"paid\";s:6:\"5.0.14\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2021-06-16 00:00:04\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:2:{i:0;i:5;i:1;i:1;}s:23:\"force_required_products\";a:1:{i:0;i:2;}s:16:\"required_service\";a:1:{i:0;i:2;}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:10;a:28:{s:10:\"product_id\";i:95;s:4:\"slug\";s:10:\"form-maker\";s:5:\"title\";s:10:\"Form Maker\";s:11:\"description\";s:141:\"Form Maker is a user-friendly plugin to create highly customizable and responsive forms in a few minutes with simple drag and drop interface.\";s:4:\"type\";s:6:\"plugin\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:1;s:8:\"zip_name\";s:14:\"form-maker.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:107:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/form-maker-2017-12-20.svg\";s:9:\"info_link\";s:46:\"https://10web.io/plugins/wordpress-form-maker/\";s:9:\"demo_link\";s:22:\"https://demo.10web.io/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:56:\"https://wordpress.org/support/plugin/form-maker/reviews/\";s:9:\"downloads\";i:40000;s:6:\"rating\";s:2:\"90\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:1;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:8:\"v1.15.34\";s:4:\"paid\";s:7:\"2.15.34\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2025-06-12 00:00:14\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:11;a:28:{s:10:\"product_id\";i:97;s:4:\"slug\";s:9:\"slider-wd\";s:5:\"title\";s:15:\"Slider by 10Web\";s:11:\"description\";s:131:\"The responsive, SEO-friendly plugin allows to display your visual content in the form of dynamic and intuitive multi-layer sliders.\";s:4:\"type\";s:6:\"plugin\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:13:\"slider-wd.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:106:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/slider-wd-2017-12-12.svg\";s:9:\"info_link\";s:35:\"https://10web.io/plugins/slider-wd/\";s:9:\"demo_link\";s:29:\"https://demo.10web.io/slider/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:55:\"https://wordpress.org/support/plugin/slider-wd/reviews/\";s:9:\"downloads\";i:20000;s:6:\"rating\";s:2:\"90\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:4;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:7:\"v1.2.62\";s:4:\"paid\";s:6:\"2.2.62\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2024-12-27 00:00:12\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:12;a:28:{s:10:\"product_id\";i:99;s:4:\"slug\";s:14:\"post-slider-wd\";s:5:\"title\";s:20:\"Post Slider by 10Web\";s:11:\"description\";s:91:\"Show off the selected posts of your website in a slider using WordPress Post Slider plugin.\";s:4:\"type\";s:6:\"plugin\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:18:\"post-slider-wd.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:111:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/post-slider-wd-2017-12-12.svg\";s:9:\"info_link\";s:47:\"https://10web.io/plugins/wordpress-post-slider/\";s:9:\"demo_link\";s:37:\"https://demo.10web.io/post-slider-wd/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:60:\"https://wordpress.org/support/plugin/post-slider-wd/reviews/\";s:9:\"downloads\";i:2000;s:6:\"rating\";s:2:\"94\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:21;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:7:\"v1.0.60\";s:4:\"paid\";s:6:\"2.0.60\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2021-11-02 00:00:05\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:13;a:28:{s:10:\"product_id\";i:101;s:4:\"slug\";s:13:\"photo-gallery\";s:5:\"title\";s:13:\"Photo Gallery\";s:11:\"description\";s:89:\"Photo Gallery is a fully responsive WordPress gallery plugin with advanced functionality.\";s:4:\"type\";s:6:\"plugin\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:1;s:8:\"zip_name\";s:17:\"photo-gallery.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:110:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/photo-gallery-2017-12-20.svg\";s:9:\"info_link\";s:49:\"https://10web.io/plugins/wordpress-photo-gallery/\";s:9:\"demo_link\";s:30:\"https://demo.10web.io/gallery/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:59:\"https://wordpress.org/support/plugin/photo-gallery/reviews/\";s:9:\"downloads\";i:200000;s:6:\"rating\";s:2:\"90\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:2;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:7:\"v1.8.35\";s:4:\"paid\";s:6:\"2.8.35\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2025-03-30 00:00:11\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:14;a:28:{s:10:\"product_id\";i:163;s:4:\"slug\";s:12:\"wd-mailchimp\";s:5:\"title\";s:18:\"MailChimp by 10Web\";s:11:\"description\";s:103:\"Integrate MailChimp into your WordPress website and create fully configurable opt-in and opt-out forms.\";s:4:\"type\";s:6:\"plugin\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:16:\"wd-mailchimp.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:109:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/wd-mailchimp-2017-12-20.svg\";s:9:\"info_link\";s:45:\"https://10web.io/plugins/wordpress-mailchimp/\";s:9:\"demo_link\";s:32:\"https://demo.10web.io/mailchimp/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:58:\"https://wordpress.org/support/plugin/wd-mailchimp/reviews/\";s:9:\"downloads\";i:2000;s:6:\"rating\";s:2:\"76\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:28;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:6:\"v1.1.3\";s:4:\"paid\";s:5:\"5.1.3\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2019-08-07 00:00:05\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:15;a:28:{s:10:\"product_id\";i:165;s:4:\"slug\";s:12:\"seo-by-10web\";s:5:\"title\";s:12:\"SEO by 10Web\";s:11:\"description\";s:84:\"Authenticate your Google account and let WordPress SEO by 10Web plugin do the trick.\";s:4:\"type\";s:6:\"plugin\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:16:\"seo-by-10web.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:109:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/seo-by-10web-2018-04-03.svg\";s:9:\"info_link\";s:17:\"https://10web.io/\";s:9:\"demo_link\";s:17:\"https://10web.io/\";s:12:\"support_link\";s:17:\"https://10web.io/\";s:11:\"review_link\";s:17:\"https://10web.io/\";s:9:\"downloads\";i:4000;s:6:\"rating\";s:2:\"60\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:1;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:6:\"v1.2.9\";s:4:\"paid\";s:5:\"2.2.9\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2023-09-02 00:00:21\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:3:\"seo\";}i:16;a:28:{s:10:\"product_id\";i:167;s:4:\"slug\";s:14:\"10web-security\";s:5:\"title\";s:14:\"10Web Security\";s:11:\"description\";s:14:\"10Web Security\";s:4:\"type\";s:6:\"plugin\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:18:\"10web-security.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:0:\"\";s:9:\"info_link\";s:35:\"https://10web.io/services/security/\";s:9:\"demo_link\";s:35:\"https://10web.io/services/security/\";s:12:\"support_link\";s:35:\"https://10web.io/services/security/\";s:11:\"review_link\";s:35:\"https://10web.io/services/security/\";s:9:\"downloads\";i:0;s:6:\"rating\";s:1:\"0\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:0;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"1.0.1\";s:4:\"paid\";s:6:\"5.0.23\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2021-09-29 16:33:19\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:2:{i:0;i:5;i:1;i:1;}s:23:\"force_required_products\";a:1:{i:0;i:2;}s:16:\"required_service\";a:1:{i:0;i:2;}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:8:\"Security\";}i:17;a:28:{s:10:\"product_id\";i:169;s:4:\"slug\";s:14:\"tenweb-builder\";s:5:\"title\";s:13:\"10Web Builder\";s:11:\"description\";s:104:\"10Web Builder is an ultimate premium tool, based on Elementor,  to create websites with stunning design.\";s:4:\"type\";s:6:\"plugin\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:18:\"tenweb-builder.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:111:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/tenweb-builder-2019-08-08.png\";s:9:\"info_link\";s:30:\"https://10web.io/site-builder/\";s:9:\"demo_link\";s:22:\"https://demo.10web.io/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:28:\"https://10web.io/contact-us/\";s:9:\"downloads\";i:1;s:6:\"rating\";s:3:\"100\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:2;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:7:\"1.37.49\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2025-11-21 12:03:43\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:18;a:28:{s:10:\"product_id\";i:177;s:4:\"slug\";s:22:\"tenweb-speed-optimizer\";s:5:\"title\";s:13:\"10Web Booster\";s:11:\"description\";s:105:\"Optimize your website speed and performance with 10Web Speed Optimizer by compressing CSS and JavaScript.\";s:4:\"type\";s:6:\"plugin\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:26:\"tenweb-speed-optimizer.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:119:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/tenweb-speed-optimizer-2019-10-02.svg\";s:9:\"info_link\";s:28:\"https://10web.io/contact-us/\";s:9:\"demo_link\";s:22:\"https://demo.10web.io/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:28:\"https://10web.io/contact-us/\";s:9:\"downloads\";i:100000;s:6:\"rating\";s:2:\"92\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:2;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:7:\"v2.32.7\";s:4:\"paid\";s:6:\"2.32.9\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2025-11-20 14:37:24\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:19;a:28:{s:10:\"product_id\";i:218;s:4:\"slug\";s:14:\"ai-builder-kit\";s:5:\"title\";s:14:\"AI Builder Kit\";s:11:\"description\";s:14:\"ai-builder-kit\";s:4:\"type\";s:6:\"plugin\";s:6:\"author\";s:0:\"\";s:10:\"author_url\";s:0:\"\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:18:\"ai-builder-kit.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:0:\"\";s:9:\"info_link\";s:0:\"\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:0:\"\";s:11:\"review_link\";s:0:\"\";s:9:\"downloads\";i:0;s:6:\"rating\";s:0:\"\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:0;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:0:\"\";s:4:\"paid\";s:6:\"1.0.17\";}s:7:\"is_paid\";i:0;s:20:\"is_hosting_available\";i:0;s:12:\"last_updated\";s:19:\"2025-08-19 07:51:53\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:20;a:28:{s:10:\"product_id\";i:219;s:4:\"slug\";s:18:\"ai-website-builder\";s:5:\"title\";s:18:\"AI Website Builder\";s:11:\"description\";s:109:\"AI Website Builder is an ultimate premium tool, based on Elementor,  to create websites with stunning design.\";s:4:\"type\";s:6:\"plugin\";s:6:\"author\";s:0:\"\";s:10:\"author_url\";s:0:\"\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:22:\"ai-website-builder.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:0:\"\";s:9:\"info_link\";s:0:\"\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:0:\"\";s:11:\"review_link\";s:0:\"\";s:9:\"downloads\";i:0;s:6:\"rating\";s:0:\"\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:0;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:0:\"\";s:4:\"paid\";s:6:\"1.1.28\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2025-11-21 12:00:28\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}}", "off");
INSERT INTO `wp_options` VALUES("153", "tenweb_themes_list", "a:8:{i:0;a:28:{s:10:\"product_id\";i:173;s:4:\"slug\";s:28:\"tenweb-website-builder-theme\";s:5:\"title\";s:13:\"Builder Theme\";s:11:\"description\";s:27:\"10Web Website Builder Theme\";s:4:\"type\";s:5:\"theme\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:16:\"http://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:32:\"tenweb-website-builder-theme.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:125:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/tenweb-website-builder-theme-2019-04-17.png\";s:9:\"info_link\";s:16:\"http://10web.io/\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:16:\"http://10web.io/\";s:11:\"review_link\";s:16:\"http://10web.io/\";s:9:\"downloads\";i:0;s:6:\"rating\";s:1:\"0\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:0;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"2.0.0\";s:4:\"paid\";s:6:\"2.1.19\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2025-09-15 15:26:39\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.0\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:1;a:28:{s:10:\"product_id\";i:185;s:4:\"slug\";s:11:\"10web-theme\";s:5:\"title\";s:11:\"10Web Theme\";s:11:\"description\";s:11:\"10Web Theme\";s:4:\"type\";s:5:\"theme\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:16:\"http://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:15:\"10web-theme.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:108:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/10web-theme-2020-06-17.png\";s:9:\"info_link\";s:16:\"http://10web.io/\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:16:\"http://10web.io/\";s:11:\"review_link\";s:16:\"http://10web.io/\";s:9:\"downloads\";i:0;s:6:\"rating\";s:1:\"0\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:0;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"1.0.0\";s:4:\"paid\";s:9:\"24.01.892\";}s:7:\"is_paid\";i:0;s:20:\"is_hosting_available\";i:0;s:12:\"last_updated\";s:19:\"2025-11-22 06:53:42\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.0\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:2;a:28:{s:10:\"product_id\";i:187;s:4:\"slug\";s:10:\"10web-blog\";s:5:\"title\";s:10:\"10Web Blog\";s:11:\"description\";s:10:\"10Web Blog\";s:4:\"type\";s:5:\"theme\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:16:\"http://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:14:\"10web-blog.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:107:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/10web-blog-2020-06-17.png\";s:9:\"info_link\";s:16:\"http://10web.io/\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:16:\"http://10web.io/\";s:11:\"review_link\";s:16:\"http://10web.io/\";s:9:\"downloads\";i:0;s:6:\"rating\";s:1:\"0\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:0;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"1.0.0\";s:4:\"paid\";s:9:\"23.11.294\";}s:7:\"is_paid\";i:0;s:20:\"is_hosting_available\";i:0;s:12:\"last_updated\";s:19:\"2025-11-24 06:44:18\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.0\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:3;a:28:{s:10:\"product_id\";i:200;s:4:\"slug\";s:13:\"experts-theme\";s:5:\"title\";s:13:\"Experts Theme\";s:11:\"description\";s:13:\"Experts Theme\";s:4:\"type\";s:5:\"theme\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:17:\"experts-theme.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:0:\"\";s:9:\"info_link\";s:17:\"https://10web.io/\";s:9:\"demo_link\";s:17:\"https://10web.io/\";s:12:\"support_link\";s:17:\"https://10web.io/\";s:11:\"review_link\";s:17:\"https://10web.io/\";s:9:\"downloads\";i:0;s:6:\"rating\";s:0:\"\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:0;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"1.0.0\";s:4:\"paid\";s:9:\"22.05.001\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2022-09-15 08:08:22\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.0\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:4;a:28:{s:10:\"product_id\";i:214;s:4:\"slug\";s:25:\"10web-builder-comparisons\";s:5:\"title\";s:25:\"10Web Builder Comparisons\";s:11:\"description\";s:25:\"10Web Builder Comparisons\";s:4:\"type\";s:5:\"theme\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:16:\"http://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:29:\"10web-builder-comparisons.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:122:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/10web-builder-comparisons-2024-03-25.png\";s:9:\"info_link\";s:16:\"http://10web.io/\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:16:\"http://10web.io/\";s:11:\"review_link\";s:16:\"http://10web.io/\";s:9:\"downloads\";i:0;s:6:\"rating\";s:1:\"0\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:0;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"1.0.0\";s:4:\"paid\";s:6:\"1.0.53\";}s:7:\"is_paid\";i:0;s:20:\"is_hosting_available\";i:0;s:12:\"last_updated\";s:19:\"2025-07-08 14:21:14\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.0\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:5;a:28:{s:10:\"product_id\";i:216;s:4:\"slug\";s:25:\"10web-hosting-comparisons\";s:5:\"title\";s:25:\"10Web Hosting Comparisons\";s:11:\"description\";s:25:\"10Web Hosting Comparisons\";s:4:\"type\";s:5:\"theme\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:16:\"http://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:29:\"10web-hosting-comparisons.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:0:\"\";s:9:\"info_link\";s:0:\"\";s:9:\"demo_link\";s:16:\"http://10web.io/\";s:12:\"support_link\";s:16:\"http://10web.io/\";s:11:\"review_link\";s:16:\"http://10web.io/\";s:9:\"downloads\";i:0;s:6:\"rating\";s:1:\"0\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:0;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"1.0.0\";s:4:\"paid\";s:6:\"1.0.39\";}s:7:\"is_paid\";i:0;s:20:\"is_hosting_available\";i:0;s:12:\"last_updated\";s:19:\"2025-07-08 13:59:36\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.0\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:6;a:28:{s:10:\"product_id\";i:220;s:4:\"slug\";s:24:\"ai-website-builder-theme\";s:5:\"title\";s:16:\"AI Builder Theme\";s:11:\"description\";s:24:\"AI Website Builder Theme\";s:4:\"type\";s:5:\"theme\";s:6:\"author\";s:0:\"\";s:10:\"author_url\";s:0:\"\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:28:\"ai-website-builder-theme.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:0:\"\";s:9:\"info_link\";s:0:\"\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:0:\"\";s:11:\"review_link\";s:0:\"\";s:9:\"downloads\";i:0;s:6:\"rating\";s:0:\"\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:0;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:0:\"\";s:4:\"paid\";s:6:\"1.0.15\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2025-09-18 11:02:45\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.0\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:7;a:28:{s:10:\"product_id\";i:222;s:4:\"slug\";s:9:\"wvc-theme\";s:5:\"title\";s:26:\"WordPress AI Builder Theme\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:16:\"http://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:13:\"wvc-theme.zip\";s:9:\"parent_id\";i:0;s:4:\"logo\";s:106:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/wvc-theme-2025-09-16.png\";s:9:\"info_link\";s:16:\"http://10web.io/\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:0:\"\";s:11:\"review_link\";s:0:\"\";s:9:\"downloads\";i:0;s:6:\"rating\";s:1:\"5\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:0;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"1.0.0\";s:4:\"paid\";s:6:\"1.4.30\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2025-11-20 09:02:25\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"6.0.0\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}}", "off");
INSERT INTO `wp_options` VALUES("154", "tenweb_addons_list", "a:35:{i:0;a:28:{s:10:\"product_id\";i:27;s:4:\"slug\";s:14:\"ecwd-subscribe\";s:5:\"title\";s:9:\"Subscribe\";s:11:\"description\";s:153:\"A great tool which allows your users to subscribe to events based on category, tag, organizer, venue and get important updates in their personal calendar\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:18:\"ecwd-subscribe.zip\";s:9:\"parent_id\";i:25;s:4:\"logo\";s:111:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/ecwd-subscribe-2017-12-14.svg\";s:9:\"info_link\";s:49:\"https://10web.io/addons/wordpress-event-calendar/\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:0:\"\";s:9:\"downloads\";i:0;s:6:\"rating\";s:1:\"0\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:123;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:5:\"1.0.8\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2020-08-04 12:14:25\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:1;a:28:{s:10:\"product_id\";i:29;s:4:\"slug\";s:14:\"ecwd-ticketing\";s:5:\"title\";s:13:\"Event Tickets\";s:11:\"description\";s:140:\"Event Tickets Add-on allows your visitors to purchase tickets to your events in a simple and straightforward way directly from your website.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:18:\"ecwd-ticketing.zip\";s:9:\"parent_id\";i:25;s:4:\"logo\";s:111:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/ecwd-ticketing-2017-12-13.svg\";s:9:\"info_link\";s:49:\"https://10web.io/addons/wordpress-event-calendar/\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:0:\"\";s:9:\"downloads\";i:0;s:6:\"rating\";s:1:\"0\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:133;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:5:\"1.0.5\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2021-12-24 07:16:11\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:2;a:28:{s:10:\"product_id\";i:33;s:4:\"slug\";s:30:\"ecwd-frontend-event-management\";s:5:\"title\";s:25:\"Frontend Event Management\";s:11:\"description\";s:103:\"This add-on is designed for allowing the users/guests to add events to the calendar from the front end.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10web\";s:10:\"author_url\";s:16:\"http://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:34:\"ecwd-frontend-event-management.zip\";s:9:\"parent_id\";i:25;s:4:\"logo\";s:122:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/frontend-event-management-2017-12-13.svg\";s:9:\"info_link\";s:49:\"https://10web.io/addons/wordpress-event-calendar/\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:0:\"\";s:9:\"downloads\";i:0;s:6:\"rating\";s:1:\"0\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:120;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:6:\"1.0.20\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2022-03-02 10:15:39\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:3;a:28:{s:10:\"product_id\";i:35;s:4:\"slug\";s:21:\"ecwd.countdown.widget\";s:5:\"title\";s:15:\"Event Countdown\";s:11:\"description\";s:38:\"Add an elegant countdown to your site.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10web\";s:10:\"author_url\";s:16:\"http://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:25:\"ecwd.countdown.widget.zip\";s:9:\"parent_id\";i:25;s:4:\"logo\";s:118:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/ecwd.countdown.widget-2017-12-13.svg\";s:9:\"info_link\";s:49:\"https://10web.io/addons/wordpress-event-calendar/\";s:9:\"demo_link\";s:32:\"https://demo.10web.io/countdown/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:0:\"\";s:9:\"downloads\";i:0;s:6:\"rating\";s:1:\"0\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:127;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:5:\"1.0.9\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2019-09-06 07:03:09\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:4;a:28:{s:10:\"product_id\";i:37;s:4:\"slug\";s:9:\"ecwd.ical\";s:5:\"title\";s:16:\"iCAL Integration\";s:11:\"description\";s:149:\"This add-on integrates the calendar plugin with your iCAL Calendar and gives functionality to import events or just display events without importing.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10web\";s:10:\"author_url\";s:16:\"http://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:13:\"ecwd.ical.zip\";s:9:\"parent_id\";i:25;s:4:\"logo\";s:106:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/ecwd.ical-2017-12-13.svg\";s:9:\"info_link\";s:49:\"https://10web.io/addons/wordpress-event-calendar/\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:0:\"\";s:9:\"downloads\";i:0;s:6:\"rating\";s:1:\"0\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:132;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:5:\"1.0.8\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2018-09-20 12:57:51\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:5;a:28:{s:10:\"product_id\";i:39;s:4:\"slug\";s:9:\"ecwd-gcal\";s:5:\"title\";s:27:\"Google Calendar Integration\";s:11:\"description\";s:135:\"This addon integrates ECWD with your Google Calendar and gives functionality to import events or just display events without importing.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10web\";s:10:\"author_url\";s:16:\"http://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:13:\"ecwd-gcal.zip\";s:9:\"parent_id\";i:25;s:4:\"logo\";s:106:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/ecwd-gcal-2017-12-13.svg\";s:9:\"info_link\";s:49:\"https://10web.io/addons/wordpress-event-calendar/\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:0:\"\";s:9:\"downloads\";i:0;s:6:\"rating\";s:1:\"0\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:131;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:5:\"1.0.7\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2018-09-20 15:12:07\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:6;a:28:{s:10:\"product_id\";i:41;s:4:\"slug\";s:10:\"ecwd-views\";s:5:\"title\";s:5:\"Views\";s:11:\"description\";s:107:\"The Views is a convenient add-on for displaying one of the additional Pro views within the pages and posts.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10web\";s:10:\"author_url\";s:16:\"http://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:14:\"ecwd-views.zip\";s:9:\"parent_id\";i:25;s:4:\"logo\";s:107:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/ecwd-views-2017-12-13.svg\";s:9:\"info_link\";s:49:\"https://10web.io/addons/wordpress-event-calendar/\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:0:\"\";s:9:\"downloads\";i:0;s:6:\"rating\";s:1:\"0\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:129;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:5:\"1.0.4\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2018-09-20 13:29:25\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:7;a:28:{s:10:\"product_id\";i:73;s:4:\"slug\";s:11:\"ecwd.import\";s:5:\"title\";s:13:\"Import/Export\";s:11:\"description\";s:92:\"Event Calendar WD allows exporting and importing of events, categories, organizers and more.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10web\";s:10:\"author_url\";s:16:\"http://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:15:\"ecwd.import.zip\";s:9:\"parent_id\";i:25;s:4:\"logo\";s:108:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/ecwd.import-2017-12-21.svg\";s:9:\"info_link\";s:49:\"https://10web.io/addons/wordpress-event-calendar/\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:0:\"\";s:9:\"downloads\";i:100;s:6:\"rating\";s:3:\"100\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:121;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:6:\"1.0.11\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2019-02-14 14:53:14\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:8;a:28:{s:10:\"product_id\";i:75;s:4:\"slug\";s:20:\"ecwd-upcoming-events\";s:5:\"title\";s:15:\"Upcoming Events\";s:11:\"description\";s:108:\"Choose events within a certain time frame or specific events and display them on site front-end as a widget.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10web\";s:10:\"author_url\";s:16:\"http://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:24:\"ecwd-upcoming-events.zip\";s:9:\"parent_id\";i:25;s:4:\"logo\";s:117:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/ecwd-upcoming-events-2017-12-13.svg\";s:9:\"info_link\";s:49:\"https://10web.io/addons/wordpress-event-calendar/\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:0:\"\";s:9:\"downloads\";i:100;s:6:\"rating\";s:3:\"100\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:128;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:5:\"1.0.8\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2019-04-29 11:54:01\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:9;a:28:{s:10:\"product_id\";i:77;s:4:\"slug\";s:12:\"ecwd-filters\";s:5:\"title\";s:6:\"Filter\";s:11:\"description\";s:63:\"This add-on is designed for advanced event filter and browsing.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10web\";s:10:\"author_url\";s:16:\"http://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:16:\"ecwd-filters.zip\";s:9:\"parent_id\";i:25;s:4:\"logo\";s:109:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/ecwd-filters-2017-12-13.svg\";s:9:\"info_link\";s:49:\"https://10web.io/addons/wordpress-event-calendar/\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:0:\"\";s:9:\"downloads\";i:100;s:6:\"rating\";s:3:\"100\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:126;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:5:\"1.0.8\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2021-08-09 12:49:58\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:10;a:28:{s:10:\"product_id\";i:79;s:4:\"slug\";s:11:\"ecwd-export\";s:5:\"title\";s:27:\"Export to GCal/iCal/Outlook\";s:11:\"description\";s:120:\"Export single or whole month events in CSV and ICS formats and import to their iCalendars, Google and Outlook calendars.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10web\";s:10:\"author_url\";s:16:\"http://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:15:\"ecwd-export.zip\";s:9:\"parent_id\";i:25;s:4:\"logo\";s:108:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/ecwd-export-2017-12-21.svg\";s:9:\"info_link\";s:49:\"https://10web.io/addons/wordpress-event-calendar/\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:0:\"\";s:9:\"downloads\";i:100;s:6:\"rating\";s:3:\"100\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:124;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:5:\"1.0.8\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2018-09-20 15:13:13\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:11;a:28:{s:10:\"product_id\";i:81;s:4:\"slug\";s:10:\"ecwd-embed\";s:5:\"title\";s:5:\"Embed\";s:11:\"description\";s:79:\"Display any of your calendars on any other website using the simple embed code.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10web\";s:10:\"author_url\";s:16:\"http://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:14:\"ecwd-embed.zip\";s:9:\"parent_id\";i:25;s:4:\"logo\";s:107:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/ecwd-embed-2017-12-13.svg\";s:9:\"info_link\";s:49:\"https://10web.io/addons/wordpress-event-calendar/\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:0:\"\";s:9:\"downloads\";i:100;s:6:\"rating\";s:3:\"100\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:125;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:5:\"1.0.3\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2018-09-20 13:31:07\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:12;a:28:{s:10:\"product_id\";i:83;s:4:\"slug\";s:22:\"ecwd-additional-fields\";s:5:\"title\";s:13:\"Custom Fields\";s:11:\"description\";s:98:\"Custom Fields Add-On will enable you to have more fields for more detailed and structured content.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10web\";s:10:\"author_url\";s:16:\"http://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:26:\"ecwd-additional-fields.zip\";s:9:\"parent_id\";i:25;s:4:\"logo\";s:119:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/ecwd-additional-fields-2017-12-14.svg\";s:9:\"info_link\";s:49:\"https://10web.io/addons/wordpress-event-calendar/\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:0:\"\";s:9:\"downloads\";i:100;s:6:\"rating\";s:3:\"100\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:122;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:5:\"1.0.4\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2018-09-20 13:53:49\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:13;a:28:{s:10:\"product_id\";i:107;s:4:\"slug\";s:20:\"photo-gallery-export\";s:5:\"title\";s:27:\"Photo Gallery Export/Import\";s:11:\"description\";s:111:\"Export/Import add-on of Photo Gallery plugin allows you to export all gallery data and import it to a new site.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:24:\"photo-gallery-export.zip\";s:9:\"parent_id\";i:101;s:4:\"logo\";s:117:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/photo-gallery-export-2017-12-13.svg\";s:9:\"info_link\";s:49:\"https://10web.io/plugins/wordpress-photo-gallery/\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:17:\"https://10web.io/\";s:9:\"downloads\";i:1;s:6:\"rating\";s:1:\"1\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:10;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:5:\"1.1.7\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2022-03-11 08:16:34\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:14;a:28:{s:10:\"product_id\";i:113;s:4:\"slug\";s:31:\"ecommerce-wd-top-rated-products\";s:5:\"title\";s:31:\"Ecommerce WD Top Rated Products\";s:11:\"description\";s:106:\"This add-on will allow displaying top rated items of single or multiple categories, depending on the setup\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:35:\"ecommerce-wd-top-rated-products.zip\";s:9:\"parent_id\";i:103;s:4:\"logo\";s:128:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/ecommerce-wd-top-rated-products-2017-12-13.svg\";s:9:\"info_link\";s:17:\"https://10web.io/\";s:9:\"demo_link\";s:17:\"https://10web.io/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:17:\"https://10web.io/\";s:9:\"downloads\";i:1;s:6:\"rating\";s:1:\"1\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:10;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:5:\"1.0.1\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2017-12-22 11:20:19\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:15;a:28:{s:10:\"product_id\";i:115;s:4:\"slug\";s:24:\"ecommerce-wd-bestsellers\";s:5:\"title\";s:24:\"Ecommerce WD Bestsellers\";s:11:\"description\";s:120:\"Ecommerce Bestsellers add-on will allow you to display best-selling items and products in demand in a featured position.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:28:\"ecommerce-wd-bestsellers.zip\";s:9:\"parent_id\";i:103;s:4:\"logo\";s:121:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/ecommerce-wd-bestsellers-2017-12-13.svg\";s:9:\"info_link\";s:17:\"https://10web.io/\";s:9:\"demo_link\";s:17:\"https://10web.io/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:17:\"https://10web.io/\";s:9:\"downloads\";i:1;s:6:\"rating\";s:1:\"1\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:14;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:5:\"1.0.0\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2017-12-22 11:20:13\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:16;a:28:{s:10:\"product_id\";i:117;s:4:\"slug\";s:19:\"ecommerce-wd-stripe\";s:5:\"title\";s:19:\"Ecommerce WD Stripe\";s:11:\"description\";s:101:\"Stripe add-on is a tool for adding Stripe as a payment method for purchasing items from Ecommerce WD.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:23:\"ecommerce-wd-stripe.zip\";s:9:\"parent_id\";i:103;s:4:\"logo\";s:116:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/ecommerce-wd-stripe-2017-12-13.svg\";s:9:\"info_link\";s:17:\"https://10web.io/\";s:9:\"demo_link\";s:17:\"https://10web.io/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:17:\"https://10web.io/\";s:9:\"downloads\";i:1;s:6:\"rating\";s:1:\"1\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:10;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:5:\"1.0.1\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2017-12-25 11:48:17\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:17;a:28:{s:10:\"product_id\";i:119;s:4:\"slug\";s:22:\"ecommerce-wd-mini-cart\";s:5:\"title\";s:22:\"Ecommerce WD Mini Cart\";s:11:\"description\";s:117:\"This add-on is designed for displaying shopping cart information including products and their details to widget area.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:26:\"ecommerce-wd-mini-cart.zip\";s:9:\"parent_id\";i:103;s:4:\"logo\";s:119:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/ecommerce-wd-mini-cart-2017-12-13.svg\";s:9:\"info_link\";s:17:\"https://10web.io/\";s:9:\"demo_link\";s:17:\"https://10web.io/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:17:\"https://10web.io/\";s:9:\"downloads\";i:1;s:6:\"rating\";s:1:\"1\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:10;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:5:\"1.0.5\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2017-12-22 11:20:00\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:18;a:28:{s:10:\"product_id\";i:121;s:4:\"slug\";s:28:\"ecommerce-wd-latest_products\";s:5:\"title\";s:25:\"Ecommerce Latest Products\";s:11:\"description\";s:128:\"Ecommerce Latest Products add-on allows displaying latest products based on a single item or multiple categories of your choice.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:32:\"ecommerce-wd-latest_products.zip\";s:9:\"parent_id\";i:103;s:4:\"logo\";s:125:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/ecommerce-wd-latest_products-2017-12-13.svg\";s:9:\"info_link\";s:17:\"https://10web.io/\";s:9:\"demo_link\";s:17:\"https://10web.io/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:17:\"https://10web.io/\";s:9:\"downloads\";i:1;s:6:\"rating\";s:1:\"1\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:10;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:5:\"1.0.2\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2017-12-22 11:19:54\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:19;a:28:{s:10:\"product_id\";i:123;s:4:\"slug\";s:20:\"ecommerce-wd-filters\";s:5:\"title\";s:20:\"Ecommerce WD Filters\";s:11:\"description\";s:169:\"This add-on is designed for advanced product filter and browsing. It will display multiple filters, which will make it easier for the user to find the relevant products.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:24:\"ecommerce-wd-filters.zip\";s:9:\"parent_id\";i:103;s:4:\"logo\";s:117:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/ecommerce-wd-filters-2017-12-13.svg\";s:9:\"info_link\";s:17:\"https://10web.io/\";s:9:\"demo_link\";s:0:\"\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:17:\"https://10web.io/\";s:9:\"downloads\";i:1;s:6:\"rating\";s:1:\"1\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:10;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:5:\"1.0.4\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2017-12-22 11:19:48\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:20;a:28:{s:10:\"product_id\";i:125;s:4:\"slug\";s:24:\"form-maker-save-progress\";s:5:\"title\";s:24:\"Form Maker Save Progress\";s:11:\"description\";s:190:\"Need to save partially completed forms? Then this add-on will come in handy. Save Progress Add-on allows you to save the incomplete forms, return later and pick up right where they left off.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:28:\"form-maker-save-progress.zip\";s:9:\"parent_id\";i:95;s:4:\"logo\";s:121:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/form-maker-save-progress-2017-12-13.svg\";s:9:\"info_link\";s:17:\"https://10web.io/\";s:9:\"demo_link\";s:17:\"https://10web.io/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:17:\"https://10web.io/\";s:9:\"downloads\";i:1;s:6:\"rating\";s:1:\"1\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:10;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:6:\"1.1.15\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2022-06-27 07:39:06\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:21;a:28:{s:10:\"product_id\";i:127;s:4:\"slug\";s:19:\"form-maker-pushover\";s:5:\"title\";s:19:\"Form Maker Pushover\";s:11:\"description\";s:189:\"Form Maker Pushover integration allows to receive real-time notifications when a user submits a new form. This means messages can be pushed to Android and Apple devices, as well as desktop.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:23:\"form-maker-pushover.zip\";s:9:\"parent_id\";i:95;s:4:\"logo\";s:116:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/form-maker-pushover-2017-12-13.svg\";s:9:\"info_link\";s:17:\"https://10web.io/\";s:9:\"demo_link\";s:17:\"https://10web.io/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:17:\"https://10web.io/\";s:9:\"downloads\";i:1;s:6:\"rating\";s:1:\"1\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:10;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:5:\"1.1.8\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2022-06-28 13:09:53\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:22;a:28:{s:10:\"product_id\";i:129;s:4:\"slug\";s:21:\"form-maker-calculator\";s:5:\"title\";s:21:\"Form Maker Calculator\";s:11:\"description\";s:90:\"The Form Maker Calculator add-on allows creating forms with dynamically calculated fields.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:25:\"form-maker-calculator.zip\";s:9:\"parent_id\";i:95;s:4:\"logo\";s:118:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/form-maker-calculator-2017-12-13.svg\";s:9:\"info_link\";s:17:\"https://10web.io/\";s:9:\"demo_link\";s:17:\"https://10web.io/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:17:\"https://10web.io/\";s:9:\"downloads\";i:1;s:6:\"rating\";s:1:\"1\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:10;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:6:\"1.1.12\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2023-07-31 09:40:20\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:23;a:28:{s:10:\"product_id\";i:131;s:4:\"slug\";s:29:\"form-maker-conditional-emails\";s:5:\"title\";s:29:\"Form Maker Conditional Emails\";s:11:\"description\";s:175:\"Conditional Emails Add-on makes your forms more powerful by allowing you to send multiple, custom email notifications to different recipients depending on the forms submitted.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:33:\"form-maker-conditional-emails.zip\";s:9:\"parent_id\";i:95;s:4:\"logo\";s:126:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/form-maker-conditional-emails-2017-12-13.svg\";s:9:\"info_link\";s:17:\"https://10web.io/\";s:9:\"demo_link\";s:17:\"https://10web.io/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:17:\"https://10web.io/\";s:9:\"downloads\";i:1;s:6:\"rating\";s:1:\"1\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:10;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:6:\"1.1.11\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2022-03-23 12:47:41\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:24;a:28:{s:10:\"product_id\";i:133;s:4:\"slug\";s:24:\"form-maker-export-import\";s:5:\"title\";s:24:\"Form Maker Export/Import\";s:11:\"description\";s:102:\"Moving your form submissions to a different location doesn’t have to be complicated and frustrating.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:28:\"form-maker-export-import.zip\";s:9:\"parent_id\";i:95;s:4:\"logo\";s:121:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/form-maker-export-import-2017-12-13.svg\";s:9:\"info_link\";s:17:\"https://10web.io/\";s:9:\"demo_link\";s:17:\"https://10web.io/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:17:\"https://10web.io/\";s:9:\"downloads\";i:1;s:6:\"rating\";s:1:\"1\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:10;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:6:\"2.1.14\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2022-10-20 10:57:41\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:25;a:28:{s:10:\"product_id\";i:135;s:4:\"slug\";s:29:\"form-maker-gdrive-integration\";s:5:\"title\";s:23:\"Form Maker Google Drive\";s:11:\"description\";s:190:\"The Google Drive Integration add-on integrates Form Maker with Google Drive and makes your work process more efficient by storing data to Google Drive’s cloud storage instead of your site.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:33:\"form-maker-gdrive-integration.zip\";s:9:\"parent_id\";i:95;s:4:\"logo\";s:126:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/form-maker-gdrive-integration-2017-12-13.svg\";s:9:\"info_link\";s:17:\"https://10web.io/\";s:9:\"demo_link\";s:17:\"https://10web.io/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:17:\"https://10web.io/\";s:9:\"downloads\";i:1;s:6:\"rating\";s:1:\"1\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:10;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:5:\"1.2.0\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2022-10-26 14:22:51\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:26;a:28:{s:10:\"product_id\";i:137;s:4:\"slug\";s:20:\"form-maker-mailchimp\";s:5:\"title\";s:20:\"Form Maker Mailchimp\";s:11:\"description\";s:82:\"The add-on allows to add contacts to your subscription lists from submitted forms.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:24:\"form-maker-mailchimp.zip\";s:9:\"parent_id\";i:95;s:4:\"logo\";s:117:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/form-maker-mailchimp-2017-12-13.svg\";s:9:\"info_link\";s:17:\"https://10web.io/\";s:9:\"demo_link\";s:17:\"https://10web.io/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:17:\"https://10web.io/\";s:9:\"downloads\";i:1;s:6:\"rating\";s:1:\"1\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:10;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:6:\"1.1.12\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2022-03-11 08:38:27\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:27;a:28:{s:10:\"product_id\";i:139;s:4:\"slug\";s:26:\"form-maker-pdf-integration\";s:5:\"title\";s:14:\"Form Maker PDF\";s:11:\"description\";s:76:\"Generate files in PDF format with the data captured through submitted forms.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:30:\"form-maker-pdf-integration.zip\";s:9:\"parent_id\";i:95;s:4:\"logo\";s:123:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/form-maker-pdf-integration-2017-12-13.svg\";s:9:\"info_link\";s:17:\"https://10web.io/\";s:9:\"demo_link\";s:17:\"https://10web.io/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:17:\"https://10web.io/\";s:9:\"downloads\";i:1;s:6:\"rating\";s:1:\"1\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:10;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:6:\"1.1.15\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2023-04-07 11:53:22\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:28;a:28:{s:10:\"product_id\";i:141;s:4:\"slug\";s:26:\"form-maker-post-generation\";s:5:\"title\";s:26:\"Form Maker Post Generation\";s:11:\"description\";s:95:\"Post Generation add-on allows creating a post, page or custom post based on the submitted data.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:30:\"form-maker-post-generation.zip\";s:9:\"parent_id\";i:95;s:4:\"logo\";s:123:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/form-maker-post-generation-2017-12-13.svg\";s:9:\"info_link\";s:17:\"https://10web.io/\";s:9:\"demo_link\";s:17:\"https://10web.io/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:17:\"https://10web.io/\";s:9:\"downloads\";i:1;s:6:\"rating\";s:1:\"1\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:10;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:6:\"1.1.11\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2022-03-11 08:43:18\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:29;a:28:{s:10:\"product_id\";i:143;s:4:\"slug\";s:14:\"form-maker-reg\";s:5:\"title\";s:23:\"Form Maker Registration\";s:11:\"description\";s:120:\"User Registration Add-On easily integrates with the Form Maker plugin allowing users to create accounts on your website.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:18:\"form-maker-reg.zip\";s:9:\"parent_id\";i:95;s:4:\"logo\";s:111:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/form-maker-reg-2017-12-13.svg\";s:9:\"info_link\";s:17:\"https://10web.io/\";s:9:\"demo_link\";s:17:\"https://10web.io/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:17:\"https://10web.io/\";s:9:\"downloads\";i:1;s:6:\"rating\";s:1:\"1\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:10;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:6:\"1.2.12\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2022-06-28 15:20:09\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:30;a:28:{s:10:\"product_id\";i:145;s:4:\"slug\";s:17:\"form-maker-stripe\";s:5:\"title\";s:17:\"Form Maker Stripe\";s:11:\"description\";s:92:\"Form Maker Stripe is convenient add-on if you have plans to integrate Stripe payment method.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:21:\"form-maker-stripe.zip\";s:9:\"parent_id\";i:95;s:4:\"logo\";s:114:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/form-maker-stripe-2017-12-13.svg\";s:9:\"info_link\";s:17:\"https://10web.io/\";s:9:\"demo_link\";s:17:\"https://10web.io/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:17:\"https://10web.io/\";s:9:\"downloads\";i:0;s:6:\"rating\";s:1:\"0\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:0;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:6:\"1.2.11\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2022-09-22 13:52:10\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:31;a:28:{s:10:\"product_id\";i:147;s:4:\"slug\";s:30:\"form-maker-dropbox-integration\";s:5:\"title\";s:18:\"Form Maker Dropbox\";s:11:\"description\";s:85:\"Use the Dropbox Integration Add-on to link Form Maker plugin to your Dropbox account.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:34:\"form-maker-dropbox-integration.zip\";s:9:\"parent_id\";i:95;s:4:\"logo\";s:127:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/form-maker-dropbox-integration-2017-12-13.svg\";s:9:\"info_link\";s:17:\"https://10web.io/\";s:9:\"demo_link\";s:17:\"https://10web.io/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:17:\"https://10web.io/\";s:9:\"downloads\";i:1;s:6:\"rating\";s:1:\"1\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:10;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:5:\"1.2.9\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2022-07-04 06:24:33\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:32;a:28:{s:10:\"product_id\";i:151;s:4:\"slug\";s:22:\"gmwd-marker-clustering\";s:5:\"title\";s:22:\"GMWD Marker Clustering\";s:11:\"description\";s:106:\"GMWD Marker Clustering is designed for grouping close markers for more user-friendly display over the map.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:26:\"gmwd-marker-clustering.zip\";s:9:\"parent_id\";i:89;s:4:\"logo\";s:119:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/gmwd-marker-clustering-2017-12-25.svg\";s:9:\"info_link\";s:17:\"https://10web.io/\";s:9:\"demo_link\";s:17:\"https://10web.io/\";s:12:\"support_link\";s:17:\"https://10web.io/\";s:11:\"review_link\";s:17:\"https://10web.io/\";s:9:\"downloads\";i:1;s:6:\"rating\";s:1:\"1\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:10;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:5:\"1.0.2\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2017-12-25 14:32:08\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:33;a:28:{s:10:\"product_id\";i:179;s:4:\"slug\";s:19:\"form-maker-webhooks\";s:5:\"title\";s:19:\"Form Maker Webhooks\";s:11:\"description\";s:203:\"Form Maker Webhooks add-on lets you integrate a third-party service with your form and save the submitted data externally. Connect your forms to a CRM system or an email marketing service with this tool.\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:23:\"form-maker-webhooks.zip\";s:9:\"parent_id\";i:95;s:4:\"logo\";s:116:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/form-maker-webhooks-2019-10-11.svg\";s:9:\"info_link\";s:17:\"https://10web.io/\";s:9:\"demo_link\";s:17:\"https://10web.io/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:17:\"https://10web.io/\";s:9:\"downloads\";i:1;s:6:\"rating\";s:1:\"5\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:1;s:13:\"download_link\";s:0:\"\";s:15:\"current_version\";a:2:{s:4:\"free\";s:5:\"0.0.0\";s:4:\"paid\";s:5:\"1.0.6\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2022-06-24 15:32:10\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:0:\"\";}i:34;a:28:{s:10:\"product_id\";i:206;s:4:\"slug\";s:30:\"ai-assistant-by-10web-seo-pack\";s:5:\"title\";s:11:\"WP SEO Pack\";s:11:\"description\";s:11:\"WP SEO Pack\";s:4:\"type\";s:5:\"addon\";s:6:\"author\";s:5:\"10Web\";s:10:\"author_url\";s:17:\"https://10web.io/\";s:11:\"with_addons\";i:0;s:8:\"zip_name\";s:34:\"ai-assistant-by-10web-seo-pack.zip\";s:9:\"parent_id\";i:205;s:4:\"logo\";s:127:\"https://10web-storage-production.s3.us-west-2.amazonaws.com/public/product_images/ai-assistant-by-10web-seo-pack-2023-03-15.png\";s:9:\"info_link\";s:28:\"https://10web.io/contact-us/\";s:9:\"demo_link\";s:22:\"https://demo.10web.io/\";s:12:\"support_link\";s:28:\"https://10web.io/contact-us/\";s:11:\"review_link\";s:28:\"https://10web.io/contact-us/\";s:9:\"downloads\";i:0;s:6:\"rating\";s:1:\"0\";s:7:\"reviews\";a:0:{}s:12:\"popular_rank\";i:2;s:13:\"download_link\";s:163:\"https://s3-us-west-2.amazonaws.com/10web-products-production/ai-assistant-by-10web-seo-pack/ai-assistant-by-10web-seo-pack/1.0.5/ai-assistant-by-10web-seo-pack.zip\";s:15:\"current_version\";a:2:{s:4:\"free\";s:6:\"v1.0.0\";s:4:\"paid\";s:5:\"1.0.5\";}s:7:\"is_paid\";i:1;s:20:\"is_hosting_available\";i:1;s:12:\"last_updated\";s:19:\"2023-06-23 09:10:29\";s:8:\"requires\";a:4:{s:17:\"required_products\";a:0:{}s:23:\"force_required_products\";a:0:{}s:16:\"required_service\";a:0:{}s:14:\"required_specs\";a:1:{s:9:\"wordpress\";s:5:\"4.4.1\";}}s:8:\"featured\";b:1;s:7:\"enabled\";i:1;s:7:\"service\";s:12:\"ai_assistant\";}}", "off");
INSERT INTO `wp_options` VALUES("155", "tenweb_requests_block", "a:3:{s:13:\"user_products\";i:0;s:11:\"send_states\";i:0;s:9:\"user_info\";i:1;}", "off");
INSERT INTO `wp_options` VALUES("156", "_site_transient_timeout_tenweb_client_products_transient", "1764007915", "off");
INSERT INTO `wp_options` VALUES("157", "_site_transient_tenweb_client_products_transient", "1", "off");
INSERT INTO `wp_options` VALUES("158", "tenweb_last_update_check", "1763921515", "off");
INSERT INTO `wp_options` VALUES("159", "tenweb_last_update_request", "1763921515", "off");
INSERT INTO `wp_options` VALUES("160", "tenweb_plugins_state_hash", "837739de06cbb9c2bf002f377e00f361", "auto");
INSERT INTO `wp_options` VALUES("161", "tenweb_themes_state_hash", "98f748fd6b29eb733c2c671fe040a860", "auto");
INSERT INTO `wp_options` VALUES("162", "tenweb_addons_state_hash", "d751713988987e9331980363e24189ce", "auto");
INSERT INTO `wp_options` VALUES("163", "tenweb_site_state_hash", "42ac5c90136562aa1a491ae30ef13cba", "auto");
INSERT INTO `wp_options` VALUES("164", "_site_transient_timeout_tenweb_auth_error_logs", "1766599929", "off");
INSERT INTO `wp_options` VALUES("165", "_site_transient_tenweb_auth_error_logs", "a:2:{s:25:\"send_site_state_api_error\";a:2:{s:3:\"msg\";s:6822:\"[{\"message\":\"The route api\\/site-state could not be found.\",\"status_code\":404},\"https:\\/\\/manager.10web.io\\/api\\/site-state\\/\",{\"method\":\"POST\",\"body\":{\"data\":{\"blog_id\":null,\"plugins_info\":{\"is_network\":0,\"products\":[{\"product_id\":51,\"slug\":\"10web-manager\",\"title\":\"10WEB\",\"description\":\"Manager is an ideal plugin to effortlessly manage all of your 10WEB products and services.\",\"version\":\"1.19.3\",\"installed\":1,\"active\":0,\"network_active\":0,\"is_paid\":1,\"screenshot\":\"\",\"tenweb_product\":1,\"author\":\"10WEB\",\"repo_version\":\"1.19.3\",\"autoupdate_enabled\":0},{\"product_id\":169,\"slug\":\"tenweb-builder\",\"title\":\"10Web Builder\",\"description\":\"10Web Builder is an ultimate premium tool, based on Elementor,  to create websites with stunning design.\",\"version\":\"1.37.49\",\"installed\":1,\"active\":1,\"network_active\":0,\"is_paid\":1,\"screenshot\":\"\",\"tenweb_product\":1,\"author\":\"10Web\",\"repo_version\":\"1.37.49\",\"autoupdate_enabled\":0},{\"product_id\":177,\"slug\":\"tenweb-speed-optimizer\",\"title\":\"10Web Booster\",\"description\":\"Optimize your website speed and performance with 10Web Booster by compressing CSS and JavaScript.\",\"version\":\"2.32.9\",\"installed\":1,\"active\":0,\"network_active\":0,\"is_paid\":1,\"screenshot\":\"\",\"tenweb_product\":1,\"author\":\"10Web - Website speed optimization team\",\"repo_version\":\"2.32.9\",\"autoupdate_enabled\":0},{\"product_id\":0,\"slug\":\"akismet\",\"title\":\"Akismet Anti-spam: Spam Protection\",\"description\":\"Used by millions, Akismet is quite possibly the best way in the world to <strong>protect your blog from spam<\\/strong>. Akismet Anti-spam keeps your site protected even while you sleep. To get started: activate the Akismet plugin and then go to your Akismet Settings page to set up your API key.\",\"version\":\"5.5\",\"installed\":1,\"active\":0,\"network_active\":0,\"is_paid\":0,\"screenshot\":\"\",\"tenweb_product\":0,\"author\":\"Automattic - Anti-spam Team\",\"repo_version\":\"5.5\",\"autoupdate_enabled\":0},{\"product_id\":0,\"slug\":\"elementor\",\"title\":\"Elementor\",\"description\":\"The Elementor Website Builder has it all: drag and drop page builder, pixel perfect design, mobile responsive editing, and more. Get started now!\",\"version\":\"3.31.5\",\"installed\":1,\"active\":1,\"network_active\":0,\"is_paid\":0,\"screenshot\":\"\",\"tenweb_product\":0,\"author\":\"Elementor.com\",\"repo_version\":\"3.31.5\",\"autoupdate_enabled\":0},{\"product_id\":0,\"slug\":\"hello.php\",\"title\":\"Hello Dolly\",\"description\":\"This is not just a plugin, it symbolizes the hope and enthusiasm of an entire generation summed up in two words sung most famously by Louis Armstrong: Hello, Dolly. When activated you will randomly see a lyric from <cite>Hello, Dolly<\\/cite> in the upper right of your admin screen on every page.\",\"version\":\"1.7.2\",\"installed\":1,\"active\":0,\"network_active\":0,\"is_paid\":0,\"screenshot\":\"\",\"tenweb_product\":0,\"author\":\"Matt Mullenweg\",\"repo_version\":\"1.7.2\",\"autoupdate_enabled\":0}]},\"themes_info\":{\"is_network\":0,\"products\":[{\"product_id\":173,\"slug\":\"tenweb-website-builder-theme\",\"title\":\"Builder Theme\",\"description\":\"This is a basic theme which helps you design your website.\",\"version\":\"2.1.19\",\"installed\":1,\"active\":1,\"network_active\":0,\"is_paid\":1,\"screenshot\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/themes\\/tenweb-website-builder-theme\\/screenshot.png\",\"tenweb_product\":1,\"author\":\"\",\"repo_version\":\"2.1.19\",\"autoupdate_enabled\":0,\"parent_theme_name\":\"\",\"theme_errors\":[]},{\"product_id\":0,\"slug\":\"twentytwentyfive\",\"title\":\"Twenty Twenty-Five\",\"description\":\"Twenty Twenty-Five emphasizes simplicity and adaptability. It offers flexible design options, supported by a variety of patterns for different page types, such as services and landing pages, making it ideal for building personal blogs, professional portfolios, online magazines, or business websites. Its templates cater to various blog styles, from text-focused to image-heavy layouts. Additionally, it supports international typography and diverse color palettes, ensuring accessibility and customization for users worldwide.\",\"version\":\"1.3\",\"installed\":1,\"active\":0,\"network_active\":0,\"is_paid\":0,\"screenshot\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/themes\\/twentytwentyfive\\/screenshot.png\",\"tenweb_product\":0,\"author\":\"the WordPress team\",\"repo_version\":\"1.3\",\"autoupdate_enabled\":0,\"parent_theme_name\":\"\",\"theme_errors\":[]},{\"product_id\":0,\"slug\":\"twentytwentyfour\",\"title\":\"Twenty Twenty-Four\",\"description\":\"Twenty Twenty-Four is designed to be flexible, versatile and applicable to any website. Its collection of templates and patterns tailor to different needs, such as presenting a business, blogging and writing or showcasing work. A multitude of possibilities open up with just a few adjustments to color and typography. Twenty Twenty-Four comes with style variations and full page designs to help speed up the site building process, is fully compatible with the site editor, and takes advantage of new design tools introduced in WordPress 6.4.\",\"version\":\"1.3\",\"installed\":1,\"active\":0,\"network_active\":0,\"is_paid\":0,\"screenshot\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/themes\\/twentytwentyfour\\/screenshot.png\",\"tenweb_product\":0,\"author\":\"the WordPress team\",\"repo_version\":\"1.3\",\"autoupdate_enabled\":0,\"parent_theme_name\":\"\",\"theme_errors\":[]},{\"product_id\":0,\"slug\":\"twentytwentythree\",\"title\":\"Twenty Twenty-Three\",\"description\":\"Twenty Twenty-Three is designed to take advantage of the new design tools introduced in WordPress 6.1. With a clean, blank base as a starting point, this default theme includes ten diverse style variations created by members of the WordPress community. Whether you want to build a complex or incredibly simple website, you can do it quickly and intuitively through the bundled styles or dive into creation and full customization yourself.\",\"version\":\"1.6\",\"installed\":1,\"active\":0,\"network_active\":0,\"is_paid\":0,\"screenshot\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/themes\\/twentytwentythree\\/screenshot.png\",\"tenweb_product\":0,\"author\":\"the WordPress team\",\"repo_version\":\"1.6\",\"autoupdate_enabled\":0,\"parent_theme_name\":\"\",\"theme_errors\":[]}]},\"addons_info\":{\"is_network\":0,\"products\":[]},\"site_info\":{\"platform\":\"wordpress\",\"site_url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\",\"admin_url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-admin\\/\",\"name\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\",\"site_title\":\"Live wordpress\",\"site_screenshot_url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\",\"platform_version\":\"6.8.3\",\"php_version\":\"7.4.33\",\"mysql_version\":\"8.0.34\",\"timezone\":\"UTC\",\"server_type\":\"unknown\",\"server_version\":\"unknown\",\"other_data\":\"{\\\"file_system\\\":{\\\"method\\\":\\\"direct\\\",\\\"config\\\":1},\\\"is_network\\\":0,\\\"blog_id\\\":null,\\\"manager_version\\\":\\\"1.19.3\\\"}\",\"is_network\":0,\"manager_version\":\"1.19.3\"}}},\"headers\":{\"Accept\":\"application\\/x.10webmanager.v1+json\"},\"timeout\":50000}]\";s:4:\"date\";s:19:\"2025-11-23 18:11:55\";}s:23:\"get_user_info_api_error\";a:2:{s:3:\"msg\";s:237:\"[{\"message\":\"The route api\\/domains\\/\\/user\\/me could not be found.\",\"status_code\":404},\"https:\\/\\/manager.10web.io\\/api\\/domains\\/\\/user\\/me\\/\",{\"method\":\"GET\",\"headers\":{\"Accept\":\"application\\/x.10webmanager.v1+json\"},\"timeout\":50000}]\";s:4:\"date\";s:19:\"2025-11-23 18:12:09\";}}", "off");
INSERT INTO `wp_options` VALUES("166", "_site_transient_timeout_tenweb_send_states_transient", "1764033566", "off");
INSERT INTO `wp_options` VALUES("167", "_site_transient_tenweb_send_states_transient", "1", "off");
INSERT INTO `wp_options` VALUES("168", "twbb_show_co_pilot_tour", "no", "auto");
INSERT INTO `wp_options` VALUES("169", "elementor_experiment-editor_v2", "active", "auto");
INSERT INTO `wp_options` VALUES("170", "twbb_version", "1.37.49", "auto");
INSERT INTO `wp_options` VALUES("171", "elementor_experiment-e_global_styleguide", "inactive", "auto");
INSERT INTO `wp_options` VALUES("172", "elementor_experiment-e_element_cache", "inactive", "auto");
INSERT INTO `wp_options` VALUES("173", "elementor_experiment-e_optimized_css_loading", "inactive", "auto");
INSERT INTO `wp_options` VALUES("174", "elementor_experiment-container", "active", "auto");
INSERT INTO `wp_options` VALUES("175", "elementor_onboarded", "1", "auto");
INSERT INTO `wp_options` VALUES("176", "twbb_sections_force_upload", "", "auto");
INSERT INTO `wp_options` VALUES("177", "twbb_tour_status", "not_started", "auto");
INSERT INTO `wp_options` VALUES("178", "elementor_allow_tracking", "no", "auto");
INSERT INTO `wp_options` VALUES("179", "elementor_tracker_notice", "1", "auto");
INSERT INTO `wp_options` VALUES("180", "tenweb_req_result", "a:1:{s:5:\"error\";a:2:{s:7:\"message\";s:30:\"10WebError:Authorization Error\";s:11:\"status_code\";i:401;}}", "off");
INSERT INTO `wp_options` VALUES("183", "tenweb_user_info", "a:2:{s:11:\"client_info\";a:2:{s:4:\"name\";s:12:\"Debra Herman\";s:15:\"timezone_offset\";i:0;}s:14:\"agreement_info\";a:30:{s:2:\"id\";i:3540888;s:10:\"clients_id\";i:3250809;s:14:\"agreement_date\";s:19:\"2025-11-24 13:24:21\";s:11:\"cancel_date\";s:0:\"\";s:11:\"expire_date\";s:0:\"\";s:17:\"next_payment_date\";s:0:\"\";s:16:\"agreement_status\";s:6:\"active\";s:10:\"plan_title\";s:9:\"Free plan\";s:21:\"subscription_category\";s:7:\"starter\";s:15:\"subscription_id\";i:318;s:18:\"subscription_title\";s:9:\"Free Plan\";s:27:\"subscription_original_title\";s:20:\"Free Plan (Platform)\";s:6:\"status\";s:6:\"active\";s:12:\"payment_fail\";i:0;s:11:\"coupon_code\";s:0:\"\";s:25:\"hosting_trial_expire_date\";s:10:\"2025-11-27\";s:10:\"product_id\";s:3:\"221\";s:14:\"can_reactivate\";i:1;s:20:\"app_sumo_expire_date\";s:0:\"\";s:12:\"payment_type\";s:4:\"card\";s:18:\"domains_permission\";a:0:{}s:15:\"cdn_permissions\";a:0:{}s:6:\"paused\";b:0;s:27:\"has_active_domain_agreement\";b:0;s:20:\"has_domain_agreement\";b:0;s:16:\"default_currency\";s:3:\"usd\";s:4:\"plan\";a:37:{s:2:\"id\";i:594;s:5:\"title\";s:9:\"Free plan\";s:13:\"refund_amount\";i:0;s:15:\"prorated_credit\";i:0;s:26:\"additional_prorated_credit\";i:0;s:15:\"coupon_discount\";i:0;s:10:\"plan_price\";i:0;s:19:\"has_prorated_credit\";i:1;s:13:\"period_number\";i:1;s:11:\"period_type\";s:1:\"m\";s:19:\"trial_period_number\";i:0;s:32:\"trial_period_number_with_credits\";i:0;s:17:\"trial_period_type\";s:1:\"d\";s:14:\"json_desc_long\";a:3:{s:8:\"features\";a:2:{s:4:\"main\";a:1:{i:0;a:5:{s:4:\"type\";s:6:\"plugin\";s:9:\"available\";b:1;s:12:\"allAvailable\";b:0;s:14:\"expandFeatures\";b:1;s:8:\"features\";a:3:{i:0;a:2:{s:3:\"key\";s:23:\"photo-gallery-feature-1\";s:9:\"available\";b:1;}i:1;a:2:{s:3:\"key\";s:23:\"photo-gallery-feature-2\";s:9:\"available\";b:1;}i:2;a:2:{s:3:\"key\";s:23:\"photo-gallery-feature-3\";s:9:\"available\";b:1;}}}}s:10:\"additional\";a:7:{i:0;a:5:{s:4:\"type\";s:7:\"service\";s:3:\"key\";s:6:\"backup\";s:5:\"value\";i:1;s:9:\"available\";b:1;s:8:\"features\";a:0:{}}i:1;a:5:{s:4:\"type\";s:7:\"service\";s:3:\"key\";s:9:\"optimizer\";s:5:\"value\";i:1000;s:9:\"available\";b:1;s:8:\"features\";a:0:{}}i:2;a:4:{s:4:\"type\";s:7:\"service\";s:3:\"key\";s:8:\"security\";s:9:\"available\";b:1;s:8:\"features\";a:0:{}}i:3;a:3:{s:4:\"type\";s:7:\"service\";s:3:\"key\";s:11:\"performance\";s:9:\"available\";b:1;}i:4;a:3:{s:4:\"type\";s:7:\"service\";s:3:\"key\";s:3:\"seo\";s:9:\"available\";b:1;}i:5;a:3:{s:4:\"type\";s:14:\"common_feature\";s:3:\"key\";s:14:\"premium-themes\";s:9:\"available\";b:0;}i:6;a:3:{s:4:\"type\";s:7:\"service\";s:3:\"key\";s:15:\"premium_support\";s:9:\"available\";b:0;}}}s:19:\"features_comparison\";a:1:{s:4:\"main\";a:9:{i:0;a:3:{s:4:\"type\";s:7:\"plugins\";s:9:\"available\";b:0;s:8:\"features\";a:3:{i:0;a:2:{s:3:\"key\";s:13:\"photo-gallery\";s:9:\"available\";b:0;}i:1;a:2:{s:3:\"key\";s:10:\"form-maker\";s:9:\"available\";b:0;}i:2;a:2:{s:3:\"key\";s:14:\"event-calendar\";s:9:\"available\";b:0;}}}i:1;a:3:{s:4:\"type\";s:14:\"common_feature\";s:3:\"key\";s:14:\"premium-themes\";s:9:\"available\";b:0;}i:2;a:3:{s:4:\"type\";s:14:\"common_feature\";s:3:\"key\";s:18:\"plugins-management\";s:9:\"available\";b:0;}i:3;a:5:{s:4:\"type\";s:7:\"service\";s:3:\"key\";s:6:\"backup\";s:5:\"value\";i:1;s:9:\"available\";b:1;s:8:\"features\";a:7:{i:0;a:3:{s:3:\"key\";s:4:\"sync\";s:9:\"available\";b:1;s:6:\"hidden\";b:0;}i:1;a:2:{s:3:\"key\";s:16:\"one_click_backup\";s:9:\"available\";b:1;}i:2;a:2:{s:3:\"key\";s:17:\"one_click_restore\";s:9:\"available\";b:1;}i:3;a:2:{s:3:\"key\";s:16:\"monthly_schedule\";s:9:\"available\";b:1;}i:4;a:2:{s:3:\"key\";s:15:\"backup_download\";s:9:\"available\";b:0;}i:5;a:2:{s:3:\"key\";s:20:\"real_time_scheduling\";s:9:\"available\";b:0;}i:6;a:2:{s:3:\"key\";s:17:\"customized_backup\";s:9:\"available\";b:0;}}}i:4;a:5:{s:4:\"type\";s:7:\"service\";s:3:\"key\";s:9:\"optimizer\";s:5:\"value\";i:1000;s:9:\"available\";b:1;s:8:\"features\";a:4:{i:0;a:2:{s:3:\"key\";s:17:\"conservative_mode\";s:9:\"available\";b:1;}i:1;a:2:{s:3:\"key\";s:13:\"balanced_mode\";s:9:\"available\";b:1;}i:2;a:2:{s:3:\"key\";s:12:\"extreme_mode\";s:9:\"available\";b:0;}i:3;a:2:{s:3:\"key\";s:17:\"auto_optimization\";s:9:\"available\";b:0;}}}i:5;a:5:{s:4:\"type\";s:7:\"service\";s:3:\"key\";s:8:\"security\";s:9:\"available\";b:1;s:11:\"hasInfoIcon\";b:1;s:8:\"features\";a:3:{i:0;a:2:{s:3:\"key\";s:13:\"security_scan\";s:9:\"available\";b:1;}i:1;a:2:{s:3:\"key\";s:17:\"scan_file_changes\";s:9:\"available\";b:1;}i:2;a:2:{s:3:\"key\";s:16:\"restore_original\";s:9:\"available\";b:0;}}}i:6;a:3:{s:4:\"type\";s:7:\"service\";s:3:\"key\";s:11:\"performance\";s:9:\"available\";b:1;}i:7;a:3:{s:4:\"type\";s:7:\"service\";s:3:\"key\";s:3:\"seo\";s:9:\"available\";b:1;}i:8;a:3:{s:4:\"type\";s:7:\"service\";s:3:\"key\";s:15:\"premium_support\";s:9:\"available\";b:0;}}}s:16:\"features_service\";a:2:{s:4:\"main\";a:1:{i:0;a:3:{s:4:\"type\";s:7:\"service\";s:14:\"expandFeatures\";b:1;s:9:\"available\";b:1;}}s:10:\"additional\";a:4:{i:0;a:2:{s:4:\"type\";s:7:\"plugins\";s:9:\"available\";b:1;}i:1;a:3:{s:4:\"type\";s:14:\"common_feature\";s:3:\"key\";s:14:\"premium-themes\";s:9:\"available\";b:1;}i:2;a:2:{s:4:\"type\";s:7:\"service\";s:9:\"available\";b:1;}i:3;a:3:{s:4:\"type\";s:7:\"service\";s:3:\"key\";s:15:\"premium_support\";s:9:\"available\";b:1;}}}}s:15:\"json_desc_short\";a:2:{s:19:\"hostingPlanCategory\";s:7:\"starter\";s:7:\"newPlan\";s:4:\"true\";}s:9:\"recurring\";i:1;s:12:\"domain_count\";i:1;s:18:\"total_domain_count\";i:0;s:8:\"services\";a:0:{}s:14:\"app_sumo_price\";i:0;s:23:\"additional_domain_price\";i:0;s:23:\"additional_domain_count\";i:0;s:31:\"additional_domain_charged_price\";i:8;s:33:\"additional_domain_parameter_price\";i:8;s:20:\"additional_cdn_price\";i:0;s:20:\"additional_cdn_count\";i:0;s:28:\"additional_cdn_charged_price\";i:0;s:30:\"additional_cdn_parameter_price\";i:0;s:34:\"additional_ai_assistant_word_price\";i:0;s:34:\"additional_ai_assistant_word_count\";i:0;s:42:\"additional_ai_assistant_word_charged_price\";i:20;s:44:\"additional_ai_assistant_word_parameter_price\";i:20;s:22:\"enable_user_management\";i:0;s:14:\"price_discount\";i:0;s:5:\"price\";i:0;s:20:\"overage_domain_count\";i:0;s:20:\"overage_domain_price\";i:0;}s:22:\"has_10WebX_ltd_payment\";b:0;s:17:\"has_hosting_trial\";i:1;s:21:\"hosting_trial_expired\";i:0;}}", "off");
INSERT INTO `wp_options` VALUES("184", "elementor_landing_pages_activation", "0", "auto");
INSERT INTO `wp_options` VALUES("185", "elementor_checklist", "{\"last_opened_timestamp\":null,\"first_closed_checklist_in_editor\":false,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"should_open_in_editor\":false}", "auto");
INSERT INTO `wp_options` VALUES("186", "elementor_version", "3.31.5", "auto");
INSERT INTO `wp_options` VALUES("187", "elementor_install_history", "a:1:{s:6:\"3.31.5\";i:1763921529;}", "auto");
INSERT INTO `wp_options` VALUES("190", "widget_elementor-library", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("191", "elementor_events_db_version", "1.0.0", "off");
INSERT INTO `wp_options` VALUES("192", "elementor_fonts_manager_font_types", "a:1:{s:6:\"Futura\";s:6:\"custom\";}", "auto");
INSERT INTO `wp_options` VALUES("193", "elementor_fonts_manager_fonts", "a:1:{s:6:\"Futura\";a:2:{s:9:\"font_face\";s:9382:\"@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: normal;\n                                      font-weight: normal;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_font.woff) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: normal;\n                                      font-weight: normal;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_font.woff2) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: normal;\n                                      font-weight: normal;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_font.ttf) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: normal;\n                                      font-weight: normal;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_font.eot) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: normal;\n                                      font-weight: normal;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_font.otf) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: italic;\n                                      font-weight: normal;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_italic_font.woff) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: italic;\n                                      font-weight: normal;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_italic_font.woff2) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: italic;\n                                      font-weight: normal;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_italic_font.ttf) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: italic;\n                                      font-weight: normal;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_italic_font.eot) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: italic;\n                                      font-weight: normal;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_italic_font.otf) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: normal;\n                                      font-weight: bold;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_font.woff) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: normal;\n                                      font-weight: bold;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_font.woff2) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: normal;\n                                      font-weight: bold;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_font.ttf) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: normal;\n                                      font-weight: bold;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_font.eot) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: normal;\n                                      font-weight: bold;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_font.otf) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: italic;\n                                      font-weight: bold;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_Italic_font.woff) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: italic;\n                                      font-weight: bold;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_Italic_font.woff2) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: italic;\n                                      font-weight: bold;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_Italic_font.ttf) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: italic;\n                                      font-weight: bold;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_Italic_font.eot) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: italic;\n                                      font-weight: bold;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_Italic_font.otf) format(\'truetype\');\n                                    }\";s:7:\"post_id\";i:5;}}", "auto");
INSERT INTO `wp_options` VALUES("194", "twbb_last_cli_import_time", "a:3:{s:29:\"start-10web-generate_sections\";i:1763921530;s:27:\"end-10web-generate_sections\";i:1763921554;s:32:\"duration-10web-generate_sections\";i:24;}", "auto");
INSERT INTO `wp_options` VALUES("195", "section_type_descriptions", "a:3:{s:3:\"msg\";s:7:\"Success\";s:6:\"status\";i:200;s:4:\"data\";a:27:{i:0;a:7:{s:12:\"base64_image\";s:968:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAABHNCSVQICAgIfAhkiAAAAotJREFUeF7tnL+SIVEUh89NJJQaT4An0FKS2YyMkKjlqkwgR65qBAJVApQqKRnZbkKq+wnwBKYUAknPvT3bvXbtjJk5k4z766ir9R/nu989Qd/TR9DZdjweK47jmPKQcX5co31Lxt8KhUIDL2ahdrbb7V0gEPipMZh/HbBOp9OPSCTy5AI6HA5LwLmYJ1YwGEwKOa0epFaPGk2jd4cquZQE7HmTl6UAOe9GquGJAHRl0AEIgHh5AQbBIBjEIwCDePyQg2AQDOIRgEE8fshBHzGo0+nQcDgky7J42L/p1YZhULlcpkKh4EfgGrTb7SibzbpgEokEqRNjsdg3DfNzf3u9Xrvx27btxj+dTikcDpMLKJ1O02q1on6/T7lc7nNPuJGrJpMJmaZJ8Xic5vM5iWaz6VSrVRqPx9rD8cZYQcrn89TtdklIneSbRUfbvPOa+GqaCSFIvbR3KpUKtVqtG5kkXxOGmmaDweAFUK1Wo3q9/jV3vpG7KB6NRgOAXhtPALpiOgABEC8ZwiAYBIN4BGAQjx9yEAyCQTwCMIjHDzkIBsEgHgEYxOOHHASDYBCPAAzi8UMOgkEwiEfgIwZh4fCSlr9wKKs5HLXEulyqL6KweQSSySSpJXkUL/zHib+KF1T5SyqVos1mQ71eT/sKDwWnVCpRNBqlxWLxUh+kCqgymYxfPKRzAZVXRDabzf4UUHmWjUYjarfbLigdN1Vdp0rwisWiHz6KOK+YAEAAxEsWMAgGwSAeARjE44ccBINgEI8ADOLxQw6CQXyD1NdzCd5tbvZqGw2W3hhbt8GS+l2+NINFl6Bs2aLLOG/y9gtTzadkyyZv936TN+/wfr835QrHg8ag7N9tAvsek2dzy/WOIm+oTAAAAABJRU5ErkJggg==\";s:24:\"compatible_website_types\";a:2:{i:0;s:5:\"basic\";i:1;s:9:\"ecommerce\";}s:11:\"description\";s:29:\"Describe any section you want\";s:3:\"key\";s:6:\"custom\";s:12:\"template_key\";s:6:\"custom\";s:7:\"ui_name\";s:6:\"Custom\";s:8:\"ui_order\";i:0;}i:1;a:7:{s:12:\"base64_image\";s:1136:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAABHNCSVQICAgIfAhkiAAAAwpJREFUeF7tnL+vIVEUx8+8hIbIij8AjdKPlma3o6N8Kv4A8Ro1asVKFAoFItHS0e0277VmlBr8AWIjKEjMzpm3M89b1uCOzTDnJJPIzNzL+dzvOXfMnLkc7Nl6vc6KopiSdgX395voMy/5X7bb7U3FZw4/zOfzL1ar9YeJwfytAX6z2XxzOp2/ZECr1WpAcA7ihLfZbCFOCqsXSVbfTRRGZ7sqcUlzpJ6TvHgEJJ6N1IQnEiCNQSdABIgtL5CCSEGkIDYCpCA2fpSDSEGkIDYCpCA2fpSDLlFQtVqFVqsFgiCwYb/T1oFAADKZDDw/P6seyApaLBYQi8WA53nAk4LBIHg8njt187qfPZlMZP9RHOh/r9cDh8MBMqBIJALj8RgajQbE4/HrvuFBWnW7XUilUuD1euH19RW4Uqkk5nI56HQ6poejjDFCSiQSUKvVgJNCSr5hhvIi+yCAYYaGN+3FbDYL5XKZ+OwRwDBrNpvvgPL5PBQKBcMBms1mgNutzeVyAW77hjyKxaKxAY1Go1uzUfv3+XwE6BRtAqShxYsBbbdbwAvIWxhegFksFs2uDR1ieOGIkG5hCAcvxLSMAGkQMjQgCjGa5j/p9+IkrZUf/sfxhw+xc2erf8E2NCA9ZrFzZysCdGU8GlpBesxiDx1iVw66rs0MrSBdPb2yM0MDOhZirCFzKSdDAzo2i7HOSgToUgKP9l+MQkxnBbB2Z+gcxOqcHu0J0D3nID0UwNqHYR770IPDw6FUHxz6/X7x6ekJBgN8I4pMIRAKhWC321HxwjFJfCpewPKXcDgM0+kU6vW66Ss8EE46nQa32w1vb2/v9UH4/CsajarFQ2YuoFKKyPr9/kcBlSKzdrsNlUoFhsOhKZORlI/lErxkMqn6T0WcGlIgQASILVuQgkhBpCA2AqQgNn6Ug0hBpCA2AqQgNn6Ug0hB7ArCt1gCbN08bGuBFlg6MbbyAkt4XLppRio6BCVIS3QF9xd5+0mhplISpEXevqqLvCm7l8tliuO4FxODEv4sE9hQmPwGzfqIlzlD8poAAAAASUVORK5CYII=\";s:24:\"compatible_website_types\";a:2:{i:0;s:5:\"basic\";i:1;s:9:\"ecommerce\";}s:11:\"description\";s:30:\"Provide info about the company\";s:3:\"key\";s:5:\"about\";s:12:\"template_key\";s:5:\"about\";s:7:\"ui_name\";s:5:\"About\";s:8:\"ui_order\";i:4;}i:2;a:7:{s:12:\"base64_image\";s:1136:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAABHNCSVQICAgIfAhkiAAAAwlJREFUeF7tnL1u4kAQx8dI0IDQIR4AaCj5aKG566CDEip4AEQaakid4pAoKCgARaKFDrq7BlpsShrgAaJECFIECZ/HOTvmcELM4uiMZyRLyHjXnp//M2t5x8uBxp6fn8uiKBakXTHtfhv95iX/6x6Pp6v4zOGPx8fHby6X65eNwfyrAf7l5eWHz+d7kgFtt9spwTmKE97tdsc5KaxuJFn9tFEYfdpViUuRI/V8yItHQOKnkdrwQAJ04qYTIALElhdIQaQgUhAbAVIQGz/KQaQgUhAbAVIQGz/KQUYU1Gw24f7+HgRBYMNu0dbRaBRKpRLkcjnVA1lB6/Ua0uk08DwPeFAsFoNgMGhRN8+77OVyKfuP4kD/h8MheL1ekAElk0lYLBbQ6XQgk8mcd4YraTUYDKBQKEAoFILxeAzc3d2dWKlUoN/v2x6Oco8RUjabhVarBZwUUvILM5QX2RsBDDM0fGkvlstlqNfrxEdDAMOs2+2+AqpWq1Cr1Q4APTw8AG5mm9/vB9z+N0Met7e37wOaz+dfds3hcPjLzvXZExGgE6QI0LUB2u12gA+0Zhg+EDqdzoOuLacgfJBFSGYYwsEHQ60RIA2NqwBEIWZG7DD0abkQY/D1rKaWA3SJENMbrd6jZzlAlxjF9JIxAToxWl0NIAqxs1KpeY0sl4PMQ6Hfs+UA6YWYkVHJKGDLAdIbxYyMSgTIKAE7vO6gELuwKox0Z7kcZMS5SxxLgFhzEE37aKZ9aOLwWE7qxGEkEhEdDgdMp/hFFJlCIB6Pw36/p+IFPUkcFC9g+UsikYDVagXtdtv2FR4Ip1gsQiAQgMlk8lofhPNNqVRKLR6ycwGVUkQ2Go3eCqgUmfV6PWg0GjCbzWyZjKR8LJfg5fN51X8q4jwhBQJEgNiyBSmIFEQKYiNACmLjRzmIFEQKYiNACmLjRzmIFMSuIPyKJcrWzdW2FmiBpQ/urbzAEv4vvTQjFR2DEqQlumLaRd5+U6iplARpkbfv6iJvyu7NZlPgOO7GxqCEv8sEdhQmfwCF+oiXrRoJAAAAAABJRU5ErkJggg==\";s:24:\"compatible_website_types\";a:2:{i:0;s:5:\"basic\";i:1;s:9:\"ecommerce\";}s:11:\"description\";s:36:\"Explain the benefit of your offering\";s:3:\"key\";s:14:\"single_benefit\";s:12:\"template_key\";s:14:\"single_feature\";s:7:\"ui_name\";s:7:\"Benefit\";s:8:\"ui_order\";i:8;}i:3;a:7:{s:12:\"base64_image\";s:1200:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAABHNCSVQICAgIfAhkiAAAAzpJREFUeF7tnC2M4lAQx6cCDGRzBIMDDBawYO4c60CCAk/CCjzgSQ6BIEEAIcGyDtydAbutxQAOQ7gQQIDodbrXHuyylG5baLfzEpKmtK9vfu8/8/rx5jFwVHa7XYHn+aywK3K830bbrGB/ze12dySbGdxYrVbfnE7nLxuDeasBdr/f//B4PH9EQNvt9oXgvPMT1uVyRRnBrZ4EWf20kRtdbarAJceQei7yYhEQfzVSGx5IgBQ6nQARIG1xgRRECiIFaSOgRkGNRgO63S6wLGvoRc1aeSQSgXw+D+l0Wm6iGIPW6zU8Pj6KYMLhMOCBgUDArHYY0q7ZbCbaz3GcaP9gMICHhwcQAcXjcZhOp9ButyGZTBrSAKtU+vz8DNlsFoLBIIxGI2Cq1SpfLBah3+/bHo7UiQgplUpBs9kERpCT8EzG2zbufKRsdDOGYQBfd/CFQgFqtZpVvOAm7UQ363Q6r4BKpRKUy+WbXNgqF0EelUrFGECHwwFwZLxlwRHH4XDodklDAeGIiJBuWRAOjjx6FQKkQNJQQORieunYxPUYqiAT23110+4CSA/X03u0+ojYXQDpMbrpPVoRoKud6vTAuyiIXOyTvWXG0+6iIDOCMFUMIkBWIqD1UWO5XAL+tBSv1wv4k4pV6sT2KsagyWSihY18bigUkretUicBOtP1xx1JgAiQ+uhAClJgRoAIkHq3Oj6DFEQKIgXd7OaT7oPoPki9u1GQ1jtIW+XJ24h2XhWD1Iv0a52h+LrjnLk4Y+OjSQn4OQa/WaktZq1TNSA0ZLFYXLTf5/OpgmTmOgmQgtpVA0LpmNUd3spaj3Z+CpDa+GLl408A0STO910pT+IUZtbzON315QXzeqlIBKLRKOD0aJpIfkYTJxPJMRUhFovBfD6HVqtl+9n2CCeXy4Hf74fxePyaq4FRP5FIyIkcdk5mkRJ6hsPh/2QWSWW9Xg/q9boIyo4FM50wHSqTycjmU0qmghIIEAHSFixIQaQgUpA2AqQgbfwwBmEOeFhbNV/2bI4WWLrQt+ICS/g/qegsJU5YoityvMjbb3I1GRQnLPL2XV7kTdq92WyywruhJxuD4v4tE9iWmPwFoSgsODJsB1oAAAAASUVORK5CYII=\";s:24:\"compatible_website_types\";a:2:{i:0;s:5:\"basic\";i:1;s:9:\"ecommerce\";}s:11:\"description\";s:21:\"Showcase key benefits\";s:3:\"key\";s:17:\"multiple_benefits\";s:12:\"template_key\";s:17:\"multiple_features\";s:7:\"ui_name\";s:8:\"Benefits\";s:8:\"ui_order\";i:8;}i:4;a:7:{s:12:\"base64_image\";s:1200:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAABHNCSVQICAgIfAhkiAAAAzpJREFUeF7tnC2M4lAQx6cCDGRzBIMDDBawYO4c60CCAk/CCjzgSQ6BIEEAIcGyDtydAbutxQAOQ7gQQIDodbrXHuyylG5baLfzEpKmtK9vfu8/8/rx5jFwVHa7XYHn+aywK3K830bbrGB/ze12dySbGdxYrVbfnE7nLxuDeasBdr/f//B4PH9EQNvt9oXgvPMT1uVyRRnBrZ4EWf20kRtdbarAJceQei7yYhEQfzVSGx5IgBQ6nQARIG1xgRRECiIFaSOgRkGNRgO63S6wLGvoRc1aeSQSgXw+D+l0Wm6iGIPW6zU8Pj6KYMLhMOCBgUDArHYY0q7ZbCbaz3GcaP9gMICHhwcQAcXjcZhOp9ButyGZTBrSAKtU+vz8DNlsFoLBIIxGI2Cq1SpfLBah3+/bHo7UiQgplUpBs9kERpCT8EzG2zbufKRsdDOGYQBfd/CFQgFqtZpVvOAm7UQ363Q6r4BKpRKUy+WbXNgqF0EelUrFGECHwwFwZLxlwRHH4XDodklDAeGIiJBuWRAOjjx6FQKkQNJQQORieunYxPUYqiAT23110+4CSA/X03u0+ojYXQDpMbrpPVoRoKud6vTAuyiIXOyTvWXG0+6iIDOCMFUMIkBWIqD1UWO5XAL+tBSv1wv4k4pV6sT2KsagyWSihY18bigUkretUicBOtP1xx1JgAiQ+uhAClJgRoAIkHq3Oj6DFEQKIgXd7OaT7oPoPki9u1GQ1jtIW+XJ24h2XhWD1Iv0a52h+LrjnLk4Y+OjSQn4OQa/WaktZq1TNSA0ZLFYXLTf5/OpgmTmOgmQgtpVA0LpmNUd3spaj3Z+CpDa+GLl408A0STO910pT+IUZtbzON315QXzeqlIBKLRKOD0aJpIfkYTJxPJMRUhFovBfD6HVqtl+9n2CCeXy4Hf74fxePyaq4FRP5FIyIkcdk5mkRJ6hsPh/2QWSWW9Xg/q9boIyo4FM50wHSqTycjmU0qmghIIEAHSFixIQaQgUpA2AqQgbfwwBmEOeFhbNV/2bI4WWLrQt+ICS/g/qegsJU5YoityvMjbb3I1GRQnLPL2XV7kTdq92WyywruhJxuD4v4tE9iWmPwFoSgsODJsB1oAAAAASUVORK5CYII=\";s:24:\"compatible_website_types\";a:2:{i:0;s:5:\"basic\";i:1;s:9:\"ecommerce\";}s:11:\"description\";s:18:\"Display blog posts\";s:3:\"key\";s:4:\"blog\";s:12:\"template_key\";s:4:\"blog\";s:7:\"ui_name\";s:4:\"Blog\";s:8:\"ui_order\";i:17;}i:5;a:7:{s:12:\"base64_image\";s:1188:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAABHNCSVQICAgIfAhkiAAAAzFJREFUeF7tnL+PKVEUx88oNGRjs9ujoPSjtY3X0VFS8QeIbdRsrXgShWILRKKlo3saWjNKCvSEiN1CYfbe2Tez3q7fM8N4c24ikXHnuudzv+fO3B/nMrCR3t/fkzzPx8glz+Z1HX1nif05s9lcFm1m6JfZbGYxGo1/dAzmuwbY1Wr16/7+fi4Aent76yKcH37CmkwmL0Pc6pnI6reO3OhoUwmXOIPq2cuLpYD4o5HqMCMCOtDoCAgByesXUEGoIFSQPAKnKKhQKEClUgGO41T9U60W7na7IZFIQCQSkaoo9EGLxQKCwSCwLAs0k9/vB4vFolU7VKnXfD6HVqsliMPj8UCj0YC7uzsQAD09PcFwOIRSqQShUEiVCtxKofV6HWKxGNjtdmi328Bks1k+lUpBrVbTPRyxESmkcDgMr6+vwBCXEoYa1L0wfRGgbkYTne7gk8kk5HI55LNBgLpZuVz+BJROpyGTySgGaDqdAv1cMj08PAD9KJUoj5eXF3UA9ft9pep5UjlOp/Ok/PsyqwoIFaRYO2m3IFUVpF2zj68ZAjrA6iqAyPISTCYTIJPhxzflRk6GYeDx8RHIcsxZ959y01UADQaDs+GIxlFIDofjFFvPynsVQKigs9pKmzddRUHaRLG9Vgjo0k+xa7w977JRiXGZ4gq61vhrFyS54zIEdGkXQwUdII6AEJC8GUVUECoIFbSpAXzM42Ne3gQ+KggVhAraqwEcix1wEQSEgOTNP2pOQThhJq9Bb+5uxd+Dbo7Apd+DEJCKBL4vKF5yiXmXWZpysW1L0pdaYr4JQJpXEG7i/KkjaROny+XiDQYDdLs0rheTSMDr9cJ6vcaN5Nsk8c9GchqK4PP5YDweQ7FY1P1uewonHo+D1WqFTqfzGatBg1kCgYAUyEF3mdtsNl3522g0EqINxICeZrP5FcwikqhWq5DP56HX6+kKjmgs6Y+FcKhoNCrZjyGZB6SAgBCQvN4CFYQKQgXJI4AKkseP9kE0FtMtr5j/9m4OD1ja07bCAUv0d1TRVkocOaLLs3nIWwtdTQLFkUPe/NIhb+Ll5XIZI1OdzzoGxf09JrAkMvkAzTGTI7mG3IAAAAAASUVORK5CYII=\";s:24:\"compatible_website_types\";a:2:{i:0;s:5:\"basic\";i:1;s:9:\"ecommerce\";}s:11:\"description\";s:37:\"Encourage visitors to contact company\";s:3:\"key\";s:7:\"contact\";s:12:\"template_key\";s:7:\"contact\";s:7:\"ui_name\";s:7:\"Contact\";s:8:\"ui_order\";i:13;}i:6;a:7:{s:12:\"base64_image\";s:1100:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAABHNCSVQICAgIfAhkiAAAAu5JREFUeF7tnL+SIVEUh0+rMgmldrLJ8AL+pCS7GRkhEQ+gTCJGLFhVAsEEKFVSk5HtJqS6vcCMTGZKIaBKb5+ebdPWDnburDH6dyPVXPp89zunb/VtVyJTWywWWVVVU9qhgPm4hV7LWvxlp9PZMGKW+MVkMvlydXX1w8Jg/nRAXi6X366vr590QPP5fAA4O3kiOxyOoKSl1a2m1XcLpdHRoWpc0hLs2ctLZkDq0Ugt+EEAOjDoAARAYnUBBsEgGCRGAAaJ8UMNgkEwSIwADBLjhxoEg2CQGAEYJMZvqwZVq1VqNpukKIrYt37S3n6/nzKZDCUSiU0EOqDpdErRaJRkWSb+UCAQII/H80nDfNtpPz4+6vGzHBx/p9Mhl8tFOqBwOEwPDw9Ur9cpFou97RcupNf9/T2lUinyer3U6/VIKpVKai6Xo3a7bXk4xhgzpHg8Tnd3dyRpKaXfk2a90F4IcJpx43UxNZvNUrlcBh8TAU6zRqPxDCifz1OhUAAgEwHmUSwWAeg1KwDoQL4A0KkBrVYr4gnnOTSe4NntdqFTeXeDeKLJkM6hMRye6Ik0AEKKnVmKieh8jn3fPcXOMUiRczo5IL7CmYs4F1K+2nD71yugua8IhH19TwqI4YzH453zubm50SG95Qpo9AWgVwhcFCCOESn2v1z/oO89aQ36oBiFfhaATj2TFhquM+y8ZRBuue6O0OaWq8/nU202Gw0G/HcNNINAMBik9XqNZZ+/KbG17MMLh6FQiEajEdVqNcuvjTGcdDpNbreb+v3+88oqT+Iikchm2dXKS8/G8nu3231ZejY0a7VaVKlUaDgcWrIYafVYf3ghmUxu4scTZgdUACAAEqsWMAgGwSAxAjBIjB9qEAyCQWIEYJAYP9QgGASDxAjAIDF+qEFHGMSP2PvFOF9sbwUbLO0ZW32DJX5fuy8Ni3ZBKdoWXQHzJm8/kWobSoq2ydvXzSZvxuHZbJaSJOnWwqCU39sE1g0mvwBHWifRZw04kwAAAABJRU5ErkJggg==\";s:24:\"compatible_website_types\";a:2:{i:0;s:5:\"basic\";i:1;s:9:\"ecommerce\";}s:11:\"description\";s:25:\"Urge users to take action\";s:3:\"key\";s:3:\"cta\";s:12:\"template_key\";s:3:\"cta\";s:7:\"ui_name\";s:14:\"Call to Action\";s:8:\"ui_order\";i:3;}i:7;a:7:{s:12:\"base64_image\";s:1204:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAABHNCSVQICAgIfAhkiAAAAzxJREFUeF7tnL+vKUEUx89KaIjwF6BR+tHSeB0dJRV/gLiNGrXiSRQKBSLR0tE9Da1dpQZ/AREUJPbt7H3r1+XubmZ53D1TyZqdOfOZ7zlnyMwwcFa2222G5/mk8Mh3/lxHn1lh/CWLxdKQxsyQD4vFwmYymf7oGMy1BtjdbvfLbrcvRUCbzWaEcL74CWs2m/2M4FYfgqx+68iNFA9V4JJiUD3f8mIJIF4xUh1WREAyk46AEBBdXEAFoYJQQXQE1CioUqlAs9kEjuMe2umrNu71eiGdTkM8Hj+aKMag1WoFkUgEWJYFUikUCoHNZnvVcTzEruVyCf1+XxSHz+eDbrcLVqsVREDBYBCm0ynU63WIRqMPMeBdGu10OpBMJsHlcsFgMACmWCzy2WwW2u227uFIk0ggxWIxqFarwAguJf7UIO6F5USAuBkp5O8OPpPJQKlUQj5nBIibNRqNT0C5XA7y+TwCOiNAeBQKBWWA9vs9kExHU0hGMBqNsk1o0ZdsJ1cVbtmmChDJcMRwmkLgkMwgV7ToS66P6+9v2faygCaTidrxaVLf7XZftKMKkBayV+pibwlIkylS2AgCkgH1ljFIjYspdaV7nNT0pVCUstWemsWUZitZq/9zBVVBWo3sdQlIjex16WLPVLsatWplF/VCUStDlLSDaV6GEgJCQEoc6X4djEEy/NRkTLqpOL1NvVDUypB3akfVQvGdBqaVrS8LCF3sJ/6a10q2StrBdRCug5To5H4dVBDGIDoFYRaj4/e0t192HfQ0AjIdvSwgdDEM0nROgmkeF4qoIDoCGIPo+GEWo+P3tLcv1kG4ifMr9+MmTo/HwxsMBhiNyLleLBIBv98Ph8MBN5LfksTFRnJyFCEQCMB8Podarab73fYETiqVAofDAcPh8POsBtniGw6Hjwc5yC5zp9OpK3+bzWbiaQPpQE+v1zsdZpFItFotKJfLMB6PdQVHGqwQj8XjUIlE4jh+PJIpIwUEhIDoogUqCBWECqIjgAqi40diEDmL6aVr5se+zeEFS9/MrXjBEvkeVXSTEidc0eU7v+Stj652BMUJl7yFjpe8SY/X63WSYZgPHYPi/l0TWJeY/AVkqMwjDTrQjAAAAABJRU5ErkJggg==\";s:24:\"compatible_website_types\";a:2:{i:0;s:5:\"basic\";i:1;s:9:\"ecommerce\";}s:11:\"description\";s:23:\"Answer common questions\";s:3:\"key\";s:3:\"faq\";s:12:\"template_key\";s:3:\"faq\";s:7:\"ui_name\";s:3:\"FAQ\";s:8:\"ui_order\";i:16;}i:8;a:7:{s:12:\"base64_image\";s:1136:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAABHNCSVQICAgIfAhkiAAAAwlJREFUeF7tnL1u4kAQx8dI0IDQIR4AaCj5aKG566CDEip4AEQaakid4pAoKCgARaKFDrq7BlpsShrgAaJECFIECZ/HOTvmcELM4uiMZyRLyHjXnp//M2t5x8uBxp6fn8uiKBakXTHtfhv95iX/6x6Pp6v4zOGPx8fHby6X65eNwfyrAf7l5eWHz+d7kgFtt9spwTmKE97tdsc5KaxuJFn9tFEYfdpViUuRI/V8yItHQOKnkdrwQAJ04qYTIALElhdIQaQgUhAbAVIQGz/KQaQgUhAbAVIQGz/KQUYU1Gw24f7+HgRBYMNu0dbRaBRKpRLkcjnVA1lB6/Ua0uk08DwPeFAsFoNgMGhRN8+77OVyKfuP4kD/h8MheL1ekAElk0lYLBbQ6XQgk8mcd4YraTUYDKBQKEAoFILxeAzc3d2dWKlUoN/v2x6Oco8RUjabhVarBZwUUvILM5QX2RsBDDM0fGkvlstlqNfrxEdDAMOs2+2+AqpWq1Cr1Q4APTw8AG5mm9/vB9z+N0Met7e37wOaz+dfds3hcPjLzvXZExGgE6QI0LUB2u12gA+0Zhg+EDqdzoOuLacgfJBFSGYYwsEHQ60RIA2NqwBEIWZG7DD0abkQY/D1rKaWA3SJENMbrd6jZzlAlxjF9JIxAToxWl0NIAqxs1KpeY0sl4PMQ6Hfs+UA6YWYkVHJKGDLAdIbxYyMSgTIKAE7vO6gELuwKox0Z7kcZMS5SxxLgFhzEE37aKZ9aOLwWE7qxGEkEhEdDgdMp/hFFJlCIB6Pw36/p+IFPUkcFC9g+UsikYDVagXtdtv2FR4Ip1gsQiAQgMlk8lofhPNNqVRKLR6ycwGVUkQ2Go3eCqgUmfV6PWg0GjCbzWyZjKR8LJfg5fN51X8q4jwhBQJEgNiyBSmIFEQKYiNACmLjRzmIFEQKYiNACmLjRzmIFMSuIPyKJcrWzdW2FmiBpQ/urbzAEv4vvTQjFR2DEqQlumLaRd5+U6iplARpkbfv6iJvyu7NZlPgOO7GxqCEv8sEdhQmfwCF+oiXrRoJAAAAAABJRU5ErkJggg==\";s:24:\"compatible_website_types\";a:2:{i:0;s:5:\"basic\";i:1;s:9:\"ecommerce\";}s:11:\"description\";s:30:\"Highlight a feature in details\";s:3:\"key\";s:14:\"single_feature\";s:12:\"template_key\";s:14:\"single_feature\";s:7:\"ui_name\";s:7:\"Feature\";s:8:\"ui_order\";i:6;}i:9;a:7:{s:12:\"base64_image\";s:1200:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAABHNCSVQICAgIfAhkiAAAAzpJREFUeF7tnC2M4lAQx6cCDGRzBIMDDBawYO4c60CCAk/CCjzgSQ6BIEEAIcGyDtydAbutxQAOQ7gQQIDodbrXHuyylG5baLfzEpKmtK9vfu8/8/rx5jFwVHa7XYHn+aywK3K830bbrGB/ze12dySbGdxYrVbfnE7nLxuDeasBdr/f//B4PH9EQNvt9oXgvPMT1uVyRRnBrZ4EWf20kRtdbarAJceQei7yYhEQfzVSGx5IgBQ6nQARIG1xgRRECiIFaSOgRkGNRgO63S6wLGvoRc1aeSQSgXw+D+l0Wm6iGIPW6zU8Pj6KYMLhMOCBgUDArHYY0q7ZbCbaz3GcaP9gMICHhwcQAcXjcZhOp9ButyGZTBrSAKtU+vz8DNlsFoLBIIxGI2Cq1SpfLBah3+/bHo7UiQgplUpBs9kERpCT8EzG2zbufKRsdDOGYQBfd/CFQgFqtZpVvOAm7UQ363Q6r4BKpRKUy+WbXNgqF0EelUrFGECHwwFwZLxlwRHH4XDodklDAeGIiJBuWRAOjjx6FQKkQNJQQORieunYxPUYqiAT23110+4CSA/X03u0+ojYXQDpMbrpPVoRoKud6vTAuyiIXOyTvWXG0+6iIDOCMFUMIkBWIqD1UWO5XAL+tBSv1wv4k4pV6sT2KsagyWSihY18bigUkretUicBOtP1xx1JgAiQ+uhAClJgRoAIkHq3Oj6DFEQKIgXd7OaT7oPoPki9u1GQ1jtIW+XJ24h2XhWD1Iv0a52h+LrjnLk4Y+OjSQn4OQa/WaktZq1TNSA0ZLFYXLTf5/OpgmTmOgmQgtpVA0LpmNUd3spaj3Z+CpDa+GLl408A0STO910pT+IUZtbzON315QXzeqlIBKLRKOD0aJpIfkYTJxPJMRUhFovBfD6HVqtl+9n2CCeXy4Hf74fxePyaq4FRP5FIyIkcdk5mkRJ6hsPh/2QWSWW9Xg/q9boIyo4FM50wHSqTycjmU0qmghIIEAHSFixIQaQgUpA2AqQgbfwwBmEOeFhbNV/2bI4WWLrQt+ICS/g/qegsJU5YoityvMjbb3I1GRQnLPL2XV7kTdq92WyywruhJxuD4v4tE9iWmPwFoSgsODJsB1oAAAAASUVORK5CYII=\";s:24:\"compatible_website_types\";a:2:{i:0;s:5:\"basic\";i:1;s:9:\"ecommerce\";}s:11:\"description\";s:23:\"Highlight core features\";s:3:\"key\";s:17:\"multiple_features\";s:12:\"template_key\";s:17:\"multiple_features\";s:7:\"ui_name\";s:13:\"Features list\";s:8:\"ui_order\";i:6;}i:10;a:7:{s:12:\"base64_image\";s:1208:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABJCAYAAACesWDiAAADT0lEQVR4Ae2cPUsjURSG35mIEkGJjaL4MSJYCH51lmulhbD+Anf/wWZbQdgtLUT9CZaCRbbTan+C0cLWUUTRxoj4CWb2vlezmiWTk0kWMZnzwNUkkxTz5N4598w5xMELQRCk7u/vv5n/nxBjXNfN3N3dbXR0dOT43OEf84KXz+d/m4ceFOIbUdPJZNJ3OHNub293oXL+xX98fJx0b25uvkLllMJrbm5Ou47jfIESxmfHzKAASigulLKoIAEVJKCCBFSQgAoSUEECKkhABQmoIAEVJKCCJJiscpyengaLi4vB2NgYk9dYDp778vKydVHwYrP54+NjzM7O4ujoCKlUCvPz84gbuVwO2WwWvu9jYGAA29vb6O/vB2jLvGANrq6uBnGHDuiCTugm0dXV9WNrawvmANLpNOLO1NSUXUWbm5toaWmBMz4+HlxdXeHw8BDKK6aqYZeYu7e3h4mJCSjF8Dq8v7//HOY5pZTS6D5IoKncQVMvw9PTE+qdtrY2VEuooJOTE5yfn6MRMPUtjIyMIJFIICqhS6xR5BBTIcXDwwOqIVRQd3c3GgUusdbWVlRD6BLr6emxI+5oFBOoyyhWS1SKSl1GsVqiUlTqMorVEpWiUpdRrJaoFBWNYgIaxQRUkIAKElBBAipIIDSKnZ2dseKBSujs7ERfX599zD3KwcFBRTtwbviGhobeLWRXQ+gMqlQOubi4sGkJ4Qaz0vSEMvnZj0yooCj5DssjHFE/V83735vQJTY8PIzr62tIMB+inEJexALA6OhoRakAl1hB7EelbDZf7bfLE+doBDSKCaigENjMQGzpmV0dl5eXUF4ZHBxEe3s73Lm5OWtrfX0dyjN0wTaYhYWF5/YXz/Nsy8fa2loQd+iALuiEbmwDFW+vzszMWGvmgG1miGO9PpPJ2NVEBzs7O+jt7S1uwVtZWQmMnLppmfvfg+e+tLQUmDSruAXvrUXHceyII2aF2fGWpkreFGd0HySgggRUkIAKElBBAipIQAUJqCABFSSgggRUkAAFZaGEkXXz+fwvKCUxdzU2HHMvOmVqU7smg/eg/MXI8ZPJ5KTLX3szT6b5AhQLXbw4ydmLNH/tzVRCJ80s+o54X5Oy5pLzkzOHTqDI/AGbxOHVTtpH5wAAAABJRU5ErkJggg==\";s:24:\"compatible_website_types\";a:1:{i:0;s:9:\"ecommerce\";}s:11:\"description\";s:29:\"Highlight product information\";s:3:\"key\";s:11:\"ecom_banner\";s:12:\"template_key\";s:11:\"ecom_banner\";s:7:\"ui_name\";s:16:\"Ecommerce banner\";s:8:\"ui_order\";i:0;}i:11;a:7:{s:12:\"base64_image\";s:1096:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAABHNCSVQICAgIfAhkiAAAAu1JREFUeF7tnL+TIUEUx9+oIqHUyWTWP+BHSnKXkRES8Qcom4jZeINTJRAIUKqkZGR3yUrN+AeQyVypXQFV5ubN3sxa63DVhXXz7UgN2rxPf95rulVLtNWWy2VeVdWMdim0fd1Cj2Ut/rLL5WoaMUv8YD6ff3E4HD8sDGbXAXm1Wn3zeDy/dEAvLy9DwPmQJ7LT6QxLWlrda1p9t1AanRyqxiUrwZ6DvGQGpJ6M1IIvBKAjgw5AACRWF2AQDIJBYgRgkBg/1CAYBIPECMAgMX6oQTAIBokRgEFi/FCDYBAMEiPwLwZVq1VqtVqkKMpZP/Szdh4MBimXy1EqlTJvUa9Bi8WC4vE4ybJM/KJQKER3d3efNY6z3NdkMtHjZzk4/l6vR263m3RA0WiUxuMxNRoNSiQSZ7mBW+m02+1SJpMhv99PT09PJD0+PqqFQoE6nY7l4RiDyJCSySTVajWStJTSt31YL7Q3Apxm3HjrWc3n81Qul8FniwCnWbPZfAVULBapVCoB0BYB5vHw8HBZQOv1mnjGFGk8s9jtdpEuTnrvVQDxTMmQRBrD4Rnm3A2AjhC+CiCk2Lm9v2D/VzHogvEJf9RRQH9LBy6SPJNsN56Z9hXf3RnnVvrk2I4COjTjeL1eExLDmc1me0dsd8a5lT4BaGc49311OGrQraTDOe7zJIOEq9yNd/DOIPxY/Tia5o/VQCCg2mw2Gg75v+RoBoFwOEybzQYLZvuUeLdgxkuukUiEptMp1et1y68qMpxsNks+n48Gg8HrmjR/l4nFYuaCtZUX7Y2Ni36//7Zob2jWbrepUqnQaDSyZDHS6rG+7ZNOp834sfV8RAUAAiCxagGDYBAMEiMAg8T4oQbBIBgkRgAGifFDDYJBMEiMAAwS44caBINgkBgBGCTGj2sQ//83KNbNf/tuBQcsHRhb/YAlfh4W7aWkaEd0hbYPefuJVDNBKdohb1/NQ96My8/PzxlJku4tDEr5c0xgw2DyG+wSdQssoQhvAAAAAElFTkSuQmCC\";s:24:\"compatible_website_types\";a:1:{i:0;s:9:\"ecommerce\";}s:11:\"description\";s:16:\"Highlight brands\";s:3:\"key\";s:11:\"ecom_brands\";s:12:\"template_key\";s:5:\"logos\";s:7:\"ui_name\";s:16:\"Ecommerce brands\";s:8:\"ui_order\";i:0;}i:12;a:7:{s:12:\"base64_image\";s:1212:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAABHNCSVQICAgIfAhkiAAAA0RJREFUeF7tnL9P6lAUx09NdJEQjAuDCbAwCqy48DbYdIQJ/gCCi7M6OzwSBwYGISasuOn2WHClZXRREwYWAjHqIAm1p77W+uNRyw2Evn5P0qRpS3vv537PKb33niuRxZ6fn0uqqua1Q3HrcQ/ty1r9yz6fr27UWeKd4XAYWFtb++NhMJ81IL+8vPza2NgY6YCenp46gPPFT+T19fWEpLnVviar3x5yox9XVeNSkKCeqbxkBqT+GKkHLwQgm0YHIAASiwtQEBQEBYkRcKKgSqVC5+fnpCjKXB+6rDePxWJULBYpm82aRdRj0MPDA2UyGZJlmfiiVCpFgUBgWesxl3KNRiNqtVq6OOLxOF1eXpLf7ycd0M7ODt3e3lKtVqPd3d25FMAtN724uKB8Pk+RSITa7TZJJycn6sHBATWbTc/DMRqRIe3t7VG1WiVJcyn9U4PdC/ZOgN2Mjbs71FKpROVyGXwsBNjN6vX6G6DDw0M6Ojr6AGgwGBBv87bNzU3izbBFPddar89l4HPM4/j4+N+Abm5u5s3GvH80GjX3F/lcawWtZQCgb5oegGz8AYAASCxkQkFQEBQkRgAKEuOHGAQFQUFiBKAgMX6IQVAQFCRGAAoS4+eaGMSjK+PxWKy2Dn+9urqqj2JYbWl7FBkOj9Mt0nj8iyG5AtAiwUx71tIqCIBs+oOduhi7BruI1dhFncQxV7nYLEE6GAyakBhOv993JERXBelZhn2s41qzjqu55jUPQDYxCIAAyFF81C8WHXpGDLJhDkAAJDa7AwqCgqCgqRpw5Vts1r/sTl/yolPw+Dtqa2vL7M/hj9Rer+foY9V2Ch4mcX5tVnMS5/b2trqyskKdDuf1wgwCiUSCJpMJJpJ/J4kPE8k5FSGZTNL9/T2dnZ15frY9wykUChQKhej6+votV4M7mdLptJnIwbPMw+Gwp/zt7u5OzzYwEnqurq7ek1kMEo1Gg05PT6nb7XoKjlFZLR7r6VC5XM6sP1IybaQAQAAkFi2gICgIChIjAAWJ8eMYxLmYMbHb/Le/VrDA0pS21RdY4vNQ0beUFG2Jrrh1kbcWXM0EpWiLvKXMRd6Mw4+Pj3lJkvY9DEr5u0xgzWDyCm/PWTKeGODQAAAAAElFTkSuQmCC\";s:24:\"compatible_website_types\";a:2:{i:0;s:5:\"basic\";i:1;s:9:\"ecommerce\";}s:11:\"description\";s:24:\"Showcase images or media\";s:3:\"key\";s:7:\"gallery\";s:12:\"template_key\";s:7:\"gallery\";s:7:\"ui_name\";s:7:\"Gallery\";s:8:\"ui_order\";i:5;}i:13;a:7:{s:12:\"base64_image\";s:1144:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAABHNCSVQICAgIfAhkiAAAAxBJREFUeF7tnD1v2lAUho+pyBKEivgBEAkxNXysTBkZyZoJdiSChBj5GhESDGwMwMIKI2PVSqxgurEk/ABEhYAhUe3e49aEhCYGrl0ZfK6EhMC+4jz3Pef44hcE2BrZbFbs9/tfxuOxbft1qzwPBAJSLBb7XiqVbtSYBXzSbDavq9XqCMEEg0EIhULg9XqtwkWJ8/HxEUajEYiiCAgqnU6HEonEDwUQe+HXdDq1tVotYAQtBeZtsL1eD+LxOHg8HokJ5pPA0mpcLpevu92u5eGosBDS7e0t5HK5bwKqRxAEG8qLxgsBLDOyLEuYYnIqlYJarUZ8tghgmrXbbVAA5fN5KBQKpgM0m80AH0YPt9sN+NgeyKNYLJob0GQyMZrNZn6/30+APqJNgDS0SIAIEF+5IgXpraDn52dYLBZ8y/LO2U6nE+x2u+bcpu5iDw8PgJCMGAjn6upKc2oCpIHI1IAoxehK+pV+qYuZsYvt263e++ymrkF6dLF9uxUB0mzo/z7A1ArSo4uddYoduei6nmZqBeka6ZGTmRqQJEkwn883oeFXnz6fD2y2/3dP0dSA8Eba09PTztq/vaA6Uhx7nUaATnkvRilGezHai+1V6P4eRJtVvTerh9A36lhTdzGjgj5kXgJ0ym3+kJU26ljTmBfI/rK7xBv7C/MkysxABcPh0CghnOS84XAYDVQgVCoVOZPJAFnwXtZRteA1Gg0QVquVHIlEgJk40e1qeZ8iwmHuVjRxwmAw+AMIbzFHo1HFAovePCvbgNGriVZo5hcH/EZUAaSKq9PpQL1eV0BZcSCYZDIJd3d3m/BfAbIiFK2YCZAGIQJEgLSS6OP3SUGkIFIQHwFSEB8/qkGkIFIQHwFSEB8/qkGkIFIQHwFSEB8/qkGkIFIQHwFSEB8/qkGkIFIQHwFSEB8/qkF7KAj/FyfIx/lszxaF9Xp9z2we1bMNkSMwxiWh/EUXuz9PKtoFKV5eXoYUQOxHK58vLi6+UqptKInsdyo3LpfrpwJIHcvlMs7cZvcWBiWytKo5HI6WyuQ3SkCemOCTNWAAAAAASUVORK5CYII=\";s:24:\"compatible_website_types\";a:2:{i:0;s:5:\"basic\";i:1;s:9:\"ecommerce\";}s:11:\"description\";s:26:\"Highlight the main message\";s:3:\"key\";s:4:\"hero\";s:12:\"template_key\";s:4:\"hero\";s:7:\"ui_name\";s:4:\"Hero\";s:8:\"ui_order\";i:1;}i:14;a:7:{s:12:\"base64_image\";s:1096:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAABHNCSVQICAgIfAhkiAAAAu1JREFUeF7tnL+TIUEUx9+oIqHUyWTWP+BHSnKXkRES8Qcom4jZeINTJRAIUKqkZGR3yUrN+AeQyVypXQFV5ubN3sxa63DVhXXz7UgN2rxPf95rulVLtNWWy2VeVdWMdim0fd1Cj2Ut/rLL5WoaMUv8YD6ff3E4HD8sDGbXAXm1Wn3zeDy/dEAvLy9DwPmQJ7LT6QxLWlrda1p9t1AanRyqxiUrwZ6DvGQGpJ6M1IIvBKAjgw5AACRWF2AQDIJBYgRgkBg/1CAYBIPECMAgMX6oQTAIBokRgEFi/FCDYBAMEiPwLwZVq1VqtVqkKMpZP/Szdh4MBimXy1EqlTJvUa9Bi8WC4vE4ybJM/KJQKER3d3efNY6z3NdkMtHjZzk4/l6vR263m3RA0WiUxuMxNRoNSiQSZ7mBW+m02+1SJpMhv99PT09PJD0+PqqFQoE6nY7l4RiDyJCSySTVajWStJTSt31YL7Q3Apxm3HjrWc3n81Qul8FniwCnWbPZfAVULBapVCoB0BYB5vHw8HBZQOv1mnjGFGk8s9jtdpEuTnrvVQDxTMmQRBrD4Rnm3A2AjhC+CiCk2Lm9v2D/VzHogvEJf9RRQH9LBy6SPJNsN56Z9hXf3RnnVvrk2I4COjTjeL1eExLDmc1me0dsd8a5lT4BaGc49311OGrQraTDOe7zJIOEq9yNd/DOIPxY/Tia5o/VQCCg2mw2Gg75v+RoBoFwOEybzQYLZvuUeLdgxkuukUiEptMp1et1y68qMpxsNks+n48Gg8HrmjR/l4nFYuaCtZUX7Y2Ni36//7Zob2jWbrepUqnQaDSyZDHS6rG+7ZNOp834sfV8RAUAAiCxagGDYBAMEiMAg8T4oQbBIBgkRgAGifFDDYJBMEiMAAwS44caBINgkBgBGCTGj2sQ//83KNbNf/tuBQcsHRhb/YAlfh4W7aWkaEd0hbYPefuJVDNBKdohb1/NQ96My8/PzxlJku4tDEr5c0xgw2DyG+wSdQssoQhvAAAAAElFTkSuQmCC\";s:24:\"compatible_website_types\";a:2:{i:0;s:5:\"basic\";i:1;s:9:\"ecommerce\";}s:11:\"description\";s:30:\"Display logos of key customers\";s:3:\"key\";s:5:\"logos\";s:12:\"template_key\";s:5:\"logos\";s:7:\"ui_name\";s:5:\"Logos\";s:8:\"ui_order\";i:2;}i:15;a:7:{s:12:\"base64_image\";s:908:\"iVBORw0KGgoAAAANSUhEUgAAACQAAAAkCAYAAADhAJiYAAACbklEQVR4Ac2YO68pURTH1zAhiJBICPFqqYiaXL3mVhSKo1PyCfQqpU7jA5xCK7eQULpRkCi8Ch1GvOK5715zcyaSc8y9gznbr5mxJ/b8Z9baa/33cIQQ6263K1wulzeO46zAAKpBoPd+PxwOeW6z2VTo2Bu8AFRUCQUtlsultdPpwHg8BhZ4vV6IxWJ4KnC9Xo+kUimIx+NgtTKJGAiCAO12G8rlMqAyMhwOCWtQQzQaJbxGowG/3y8qXa1WQBMLlGA2m0Gn08GjoAa8P3892O/3QSk2m016oA/2+z0oQa/Xi0dMGR5UQMni0Gq14gPhEVFFkN1uh/P5fPO6XJhVEYS58C9Bt1BFkMfjgXtRRdB0OpXOjUajovqmiiAUIRcyOXiskh+43W6gjRaU4HA4Po09UvF5jPdoNBKX3leTfxeoYT6fA9dqtUg2m4VMJgMWiwVYQJs7VCoVsZdhtydYyBqNBkwmE2ABdvtEIiGGWhQEL4QGXgwe45dMJsXqysoPIbjCi8UicOl0mkQiEcjlcsCSUqkE9XoduFAoRNCtIVjMTqeTknkk6/AMwuEw8Ndh6na7ig2a0+kEl8sFz+CTH1Iq5tZ/0Oj971zogwKBgPRblV7m8/lkr8uFWRVBg8FAtrniirq1olURdB0CpagiaLvdSm8IcwTtCFNBs9lMEmQwGO4XdI+x+ioXHrKwdMcobmVx4kdi/wwWiwVwtH+QZrMJhUKBaS/L5/MQDAb/2o9qtQq1Wk00SixAP0R7KtC9PXDr9foX/S7zA16D3+iH8lTQCNgj0A8fPzk8ozsN//F4DNEBZklkMpne6YsR/gDku3xEbhIgsgAAAABJRU5ErkJggg==\";s:24:\"compatible_website_types\";a:2:{i:0;s:5:\"basic\";i:1;s:9:\"ecommerce\";}s:11:\"description\";s:24:\"Showcase portfolio items\";s:3:\"key\";s:9:\"portfolio\";s:12:\"template_key\";s:9:\"portfolio\";s:7:\"ui_name\";s:9:\"Portfolio\";s:8:\"ui_order\";i:7;}i:16;a:7:{s:12:\"base64_image\";s:1152:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAABHNCSVQICAgIfAhkiAAAAxVJREFUeF7tnD1PKkEUhs9S2Gj4CD+Aj8KSj1YabgedllrBDyDYUAu1xSWhoLAAQkKLHTTm0mDLriWF4g8gECMWFOzds95dUYg4WUC5+05CslnY2Zln3vfMspkzEs2Vl5eXrKqqKe1UZP68jY5lrf/Fg4ODmtFniQ9Go5F7b2/vj43BfNSAPJ1Of3k8nrEOaDKZ9ABnwSfy/v5+VNJsda7J6reNbPTlrmpc0hLU8ykvmQGpX0Zqwx8C0IpBByAAshYXoCAoCAqyRkBEQeVymer1OimKstGb/tTKw+EwZTIZOj09NZuox6CnpydKJpMkyzLxj+LxOLnd7p/aj420azweU6fT0cURiUSo1WqR0+kkHVAsFqOHhweqVqt0fHy8kQbsSqXX19eUSqUoEAhQt9sl6fLyUs3lctRsNm0PxxhEhnRyckJXV1ckaZbS/2qwvVDeCLDNuPDrDjWbzVKxWASfOQJss1qt9gro4uKC8vn8VgFxzLu/vyftlYJ5X+0F1cLkIEkSeb1ecrlcW20f8ygUCt8H6Obm5h0co/ccHD8WhhQMBu0FCAra6niv/2bfbrH1d2m9NQLQCp4rAQ2HQ+KPlcKzD3+Msit1cntXAur3+1bYmNceHh6ax7tSJwAtGfr5gQQgABKPDlDQCmYABEDitpq/AgqCgqCgrT184jkIz0HidkOQRpAWVw2meQFmsBgsJiAXzGLisGAxWExcNZjFBJjBYrCYgFwwi4nDgsVgMXHVYBYTYAaLrdtiu7LQYBPtXHjlikWci/IyF3GGQiHV4XBQr8d5vSgGgWg0SrPZDAvJl0ni3UJyTkU4Ojqix8dHqlQqtl9tz3DS6TT5fD66vb19zdXgZJZEImEmcvAqc7/fbyu/DQYDPdvASOhpt9tvySwGiUajQaVSie7u7mwFx+isFo/1dKizszOz/0jJXCEFAAIga9ECCoKCoCBrBKAga/w4BnEuZthaNf/t1Qo2WPpkbPUNlvh7qGgpJUXboisyv8lbB1YzQSnaJm9xc5M34/Tz83NKyw89tzEo5d82gVWDyV+XjVAyL4V3FwAAAABJRU5ErkJggg==\";s:24:\"compatible_website_types\";a:2:{i:0;s:5:\"basic\";i:1;s:9:\"ecommerce\";}s:11:\"description\";s:33:\"Display service or product prices\";s:3:\"key\";s:7:\"pricing\";s:12:\"template_key\";s:7:\"pricing\";s:7:\"ui_name\";s:7:\"Pricing\";s:8:\"ui_order\";i:7;}i:17;a:7:{s:12:\"base64_image\";s:1112:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAABHNCSVQICAgIfAhkiAAAAvlJREFUeF7tnL+z4VAUx0/M0Hhj1l+Af8CPlma3o6Ok4g8wXqNGrVgzCoUCY0ZLR7fb0Er8A+h0dgwKZmRz8jZ5scwjbuLxcm6ViZu453O/5xy5Jy4HmrbdbnOiKKalU0HteQsd85L9lZeXl5ZiM4cHy+Xym8Ph+GVhMP9rgN/tdj/cbvcfGdBmsxkTnBM/4Z1OZ4iT3OpVktVPC7nR1aZKXDIcqedDXjwCEq9GasGOBOjCpBMgAsQWF0hBpCBSEBsBUhAbP4pBpCBSEBsBUhAbP4pBpCBSEBsBUhAbv6MYVKvVoN1ugyAIbHd90qsDgQBks1lIJpOqBTKg1WoFsVgMeJ4H7BQMBsHr9T6pmbcNezabyfajOND+fr8PLpcLZECRSASm0yk0m02Ix+O3fcMXuarX60E6nQafzwfD4RC4crks5vN56Ha7loejzDFCSiQSUK/XgZNcSl6TRnlReyeAboYN62JiLpeDSqVCfDQE0M1ardYboEKhAMVikQBpCCCPUqlkPqD9fg+YJc1omGXsdrsZt5YFcxdAmB0RkhkN4WC2MaMRoAtU7waIXMwMfT/APe+moAew9aYhGA7ITFfSa6ER2c1wQGZmK72AjMhuBOjeWYxcTK/On7y/4S725DxOhv/pgBSX1GYcfGY791hiRFbSO4GfDkjJekrGQTiLxeKsHUZkJQKkl8C9s5je8ZGL6SX2YP2PYhAtuZ7Ojrrk6vf7RZvNBuMx/l2DmkIgFArB4XCgss85SRyVfbBwGA6HYT6fQ6PRsHxtDOFkMhnweDwwGo3eKqv4GyQajaplVyuXnpXy+2AweC89KzLrdDpQrVZhMplYMhhJ8Vh+eSGVSqn20xtmF6RAgAgQW7QgBZGCSEFsBEhBbPwoBpGCSEFsBEhBbPwoBpGCSEFsBEhBbPwoBl2hIHzFPsDG+cteLdAGSx/MrbzBEn4urUuTik5BCdIWXUHtJm+/ydVUSoK0ydt3dZM35fR6vU5zHPdqYVDCv20CmwqTvzMqP9Fb/43gAAAAAElFTkSuQmCC\";s:24:\"compatible_website_types\";a:2:{i:0;s:5:\"basic\";i:1;s:9:\"ecommerce\";}s:11:\"description\";s:25:\"Showcase customer reviews\";s:3:\"key\";s:7:\"reviews\";s:12:\"template_key\";s:12:\"testimonials\";s:7:\"ui_name\";s:7:\"Reviews\";s:8:\"ui_order\";i:14;}i:18;a:7:{s:12:\"base64_image\";s:1136:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAABHNCSVQICAgIfAhkiAAAAwlJREFUeF7tnL1u4kAQx8dI0IDQIR4AaCj5aKG566CDEip4AEQaakid4pAoKCgARaKFDrq7BlpsShrgAaJECFIECZ/HOTvmcELM4uiMZyRLyHjXnp//M2t5x8uBxp6fn8uiKBakXTHtfhv95iX/6x6Pp6v4zOGPx8fHby6X65eNwfyrAf7l5eWHz+d7kgFtt9spwTmKE97tdsc5KaxuJFn9tFEYfdpViUuRI/V8yItHQOKnkdrwQAJ04qYTIALElhdIQaQgUhAbAVIQGz/KQaQgUhAbAVIQGz/KQUYU1Gw24f7+HgRBYMNu0dbRaBRKpRLkcjnVA1lB6/Ua0uk08DwPeFAsFoNgMGhRN8+77OVyKfuP4kD/h8MheL1ekAElk0lYLBbQ6XQgk8mcd4YraTUYDKBQKEAoFILxeAzc3d2dWKlUoN/v2x6Oco8RUjabhVarBZwUUvILM5QX2RsBDDM0fGkvlstlqNfrxEdDAMOs2+2+AqpWq1Cr1Q4APTw8AG5mm9/vB9z+N0Met7e37wOaz+dfds3hcPjLzvXZExGgE6QI0LUB2u12gA+0Zhg+EDqdzoOuLacgfJBFSGYYwsEHQ60RIA2NqwBEIWZG7DD0abkQY/D1rKaWA3SJENMbrd6jZzlAlxjF9JIxAToxWl0NIAqxs1KpeY0sl4PMQ6Hfs+UA6YWYkVHJKGDLAdIbxYyMSgTIKAE7vO6gELuwKox0Z7kcZMS5SxxLgFhzEE37aKZ9aOLwWE7qxGEkEhEdDgdMp/hFFJlCIB6Pw36/p+IFPUkcFC9g+UsikYDVagXtdtv2FR4Ip1gsQiAQgMlk8lofhPNNqVRKLR6ycwGVUkQ2Go3eCqgUmfV6PWg0GjCbzWyZjKR8LJfg5fN51X8q4jwhBQJEgNiyBSmIFEQKYiNACmLjRzmIFEQKYiNACmLjRzmIFMSuIPyKJcrWzdW2FmiBpQ/urbzAEv4vvTQjFR2DEqQlumLaRd5+U6iplARpkbfv6iJvyu7NZlPgOO7GxqCEv8sEdhQmfwCF+oiXrRoJAAAAAABJRU5ErkJggg==\";s:24:\"compatible_website_types\";a:2:{i:0;s:5:\"basic\";i:1;s:9:\"ecommerce\";}s:11:\"description\";s:28:\"Explain a service in details\";s:3:\"key\";s:14:\"single_service\";s:12:\"template_key\";s:14:\"single_feature\";s:7:\"ui_name\";s:7:\"Service\";s:8:\"ui_order\";i:10;}i:19;a:7:{s:12:\"base64_image\";s:1200:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAABHNCSVQICAgIfAhkiAAAAzpJREFUeF7tnC2M4lAQx6cCDGRzBIMDDBawYO4c60CCAk/CCjzgSQ6BIEEAIcGyDtydAbutxQAOQ7gQQIDodbrXHuyylG5baLfzEpKmtK9vfu8/8/rx5jFwVHa7XYHn+aywK3K830bbrGB/ze12dySbGdxYrVbfnE7nLxuDeasBdr/f//B4PH9EQNvt9oXgvPMT1uVyRRnBrZ4EWf20kRtdbarAJceQei7yYhEQfzVSGx5IgBQ6nQARIG1xgRRECiIFaSOgRkGNRgO63S6wLGvoRc1aeSQSgXw+D+l0Wm6iGIPW6zU8Pj6KYMLhMOCBgUDArHYY0q7ZbCbaz3GcaP9gMICHhwcQAcXjcZhOp9ButyGZTBrSAKtU+vz8DNlsFoLBIIxGI2Cq1SpfLBah3+/bHo7UiQgplUpBs9kERpCT8EzG2zbufKRsdDOGYQBfd/CFQgFqtZpVvOAm7UQ363Q6r4BKpRKUy+WbXNgqF0EelUrFGECHwwFwZLxlwRHH4XDodklDAeGIiJBuWRAOjjx6FQKkQNJQQORieunYxPUYqiAT23110+4CSA/X03u0+ojYXQDpMbrpPVoRoKud6vTAuyiIXOyTvWXG0+6iIDOCMFUMIkBWIqD1UWO5XAL+tBSv1wv4k4pV6sT2KsagyWSihY18bigUkretUicBOtP1xx1JgAiQ+uhAClJgRoAIkHq3Oj6DFEQKIgXd7OaT7oPoPki9u1GQ1jtIW+XJ24h2XhWD1Iv0a52h+LrjnLk4Y+OjSQn4OQa/WaktZq1TNSA0ZLFYXLTf5/OpgmTmOgmQgtpVA0LpmNUd3spaj3Z+CpDa+GLl408A0STO910pT+IUZtbzON315QXzeqlIBKLRKOD0aJpIfkYTJxPJMRUhFovBfD6HVqtl+9n2CCeXy4Hf74fxePyaq4FRP5FIyIkcdk5mkRJ6hsPh/2QWSWW9Xg/q9boIyo4FM50wHSqTycjmU0qmghIIEAHSFixIQaQgUpA2AqQgbfwwBmEOeFhbNV/2bI4WWLrQt+ICS/g/qegsJU5YoityvMjbb3I1GRQnLPL2XV7kTdq92WyywruhJxuD4v4tE9iWmPwFoSgsODJsB1oAAAAASUVORK5CYII=\";s:24:\"compatible_website_types\";a:2:{i:0;s:5:\"basic\";i:1;s:9:\"ecommerce\";}s:11:\"description\";s:25:\"Outline tailored services\";s:3:\"key\";s:17:\"multiple_services\";s:12:\"template_key\";s:17:\"multiple_features\";s:7:\"ui_name\";s:13:\"Services list\";s:8:\"ui_order\";i:10;}i:20;a:7:{s:12:\"base64_image\";s:1136:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAABHNCSVQICAgIfAhkiAAAAwlJREFUeF7tnL1u4kAQx8dI0IDQIR4AaCj5aKG566CDEip4AEQaakid4pAoKCgARaKFDrq7BlpsShrgAaJECFIECZ/HOTvmcELM4uiMZyRLyHjXnp//M2t5x8uBxp6fn8uiKBakXTHtfhv95iX/6x6Pp6v4zOGPx8fHby6X65eNwfyrAf7l5eWHz+d7kgFtt9spwTmKE97tdsc5KaxuJFn9tFEYfdpViUuRI/V8yItHQOKnkdrwQAJ04qYTIALElhdIQaQgUhAbAVIQGz/KQaQgUhAbAVIQGz/KQUYU1Gw24f7+HgRBYMNu0dbRaBRKpRLkcjnVA1lB6/Ua0uk08DwPeFAsFoNgMGhRN8+77OVyKfuP4kD/h8MheL1ekAElk0lYLBbQ6XQgk8mcd4YraTUYDKBQKEAoFILxeAzc3d2dWKlUoN/v2x6Oco8RUjabhVarBZwUUvILM5QX2RsBDDM0fGkvlstlqNfrxEdDAMOs2+2+AqpWq1Cr1Q4APTw8AG5mm9/vB9z+N0Met7e37wOaz+dfds3hcPjLzvXZExGgE6QI0LUB2u12gA+0Zhg+EDqdzoOuLacgfJBFSGYYwsEHQ60RIA2NqwBEIWZG7DD0abkQY/D1rKaWA3SJENMbrd6jZzlAlxjF9JIxAToxWl0NIAqxs1KpeY0sl4PMQ6Hfs+UA6YWYkVHJKGDLAdIbxYyMSgTIKAE7vO6gELuwKox0Z7kcZMS5SxxLgFhzEE37aKZ9aOLwWE7qxGEkEhEdDgdMp/hFFJlCIB6Pw36/p+IFPUkcFC9g+UsikYDVagXtdtv2FR4Ip1gsQiAQgMlk8lofhPNNqVRKLR6ycwGVUkQ2Go3eCqgUmfV6PWg0GjCbzWyZjKR8LJfg5fN51X8q4jwhBQJEgNiyBSmIFEQKYiNACmLjRzmIFEQKYiNACmLjRzmIFMSuIPyKJcrWzdW2FmiBpQ/urbzAEv4vvTQjFR2DEqQlumLaRd5+U6iplARpkbfv6iJvyu7NZlPgOO7GxqCEv8sEdhQmfwCF+oiXrRoJAAAAAABJRU5ErkJggg==\";s:24:\"compatible_website_types\";a:2:{i:0;s:5:\"basic\";i:1;s:9:\"ecommerce\";}s:11:\"description\";s:23:\"Highlight your solution\";s:3:\"key\";s:15:\"single_solution\";s:12:\"template_key\";s:14:\"single_feature\";s:7:\"ui_name\";s:8:\"Solution\";s:8:\"ui_order\";i:12;}i:21;a:7:{s:12:\"base64_image\";s:1200:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAABHNCSVQICAgIfAhkiAAAAzpJREFUeF7tnC2M4lAQx6cCDGRzBIMDDBawYO4c60CCAk/CCjzgSQ6BIEEAIcGyDtydAbutxQAOQ7gQQIDodbrXHuyylG5baLfzEpKmtK9vfu8/8/rx5jFwVHa7XYHn+aywK3K830bbrGB/ze12dySbGdxYrVbfnE7nLxuDeasBdr/f//B4PH9EQNvt9oXgvPMT1uVyRRnBrZ4EWf20kRtdbarAJceQei7yYhEQfzVSGx5IgBQ6nQARIG1xgRRECiIFaSOgRkGNRgO63S6wLGvoRc1aeSQSgXw+D+l0Wm6iGIPW6zU8Pj6KYMLhMOCBgUDArHYY0q7ZbCbaz3GcaP9gMICHhwcQAcXjcZhOp9ButyGZTBrSAKtU+vz8DNlsFoLBIIxGI2Cq1SpfLBah3+/bHo7UiQgplUpBs9kERpCT8EzG2zbufKRsdDOGYQBfd/CFQgFqtZpVvOAm7UQ363Q6r4BKpRKUy+WbXNgqF0EelUrFGECHwwFwZLxlwRHH4XDodklDAeGIiJBuWRAOjjx6FQKkQNJQQORieunYxPUYqiAT23110+4CSA/X03u0+ojYXQDpMbrpPVoRoKud6vTAuyiIXOyTvWXG0+6iIDOCMFUMIkBWIqD1UWO5XAL+tBSv1wv4k4pV6sT2KsagyWSihY18bigUkretUicBOtP1xx1JgAiQ+uhAClJgRoAIkHq3Oj6DFEQKIgXd7OaT7oPoPki9u1GQ1jtIW+XJ24h2XhWD1Iv0a52h+LrjnLk4Y+OjSQn4OQa/WaktZq1TNSA0ZLFYXLTf5/OpgmTmOgmQgtpVA0LpmNUd3spaj3Z+CpDa+GLl408A0STO910pT+IUZtbzON315QXzeqlIBKLRKOD0aJpIfkYTJxPJMRUhFovBfD6HVqtl+9n2CCeXy4Hf74fxePyaq4FRP5FIyIkcdk5mkRJ6hsPh/2QWSWW9Xg/q9boIyo4FM50wHSqTycjmU0qmghIIEAHSFixIQaQgUpA2AqQgbfwwBmEOeFhbNV/2bI4WWLrQt+ICS/g/qegsJU5YoityvMjbb3I1GRQnLPL2XV7kTdq92WyywruhJxuD4v4tE9iWmPwFoSgsODJsB1oAAAAASUVORK5CYII=\";s:24:\"compatible_website_types\";a:2:{i:0;s:5:\"basic\";i:1;s:9:\"ecommerce\";}s:11:\"description\";s:23:\"Showcase your solutions\";s:3:\"key\";s:18:\"multiple_solutions\";s:12:\"template_key\";s:17:\"multiple_features\";s:7:\"ui_name\";s:14:\"Solutions list\";s:8:\"ui_order\";i:12;}i:22;a:7:{s:12:\"base64_image\";s:1992:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAACXBIWXMAAB2HAAAdhwGP5fFlAAAAGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAABWJJREFUeJztnE1T01oYx/8nbdKUpKRqVZQrLnBUhKGsUhj8CO50wfgB9NMgbu/de1dsFPAb+NJhI94rw4xunLlKHYcgbdKkL/rcBbSQUjyhDTe5cn4zXeSF5zz8cnp68uSFERH2UF3XfUhE9wGMA9BwunAA/M0Y+zOdTv8OoAYAjIjguu5vRLQCYDLSFOPDGmPsTjqd/kcCoAo5h8gT0TKAlOS67kMIOd3Iu677QNobcwRdIKL7zHGcCgA96mRiii1ByPkZuhR1BnFHCOIgBHEQgjgIQTwcxyHHcWhra4vm5+fJNE3SNI0AnKqPpmlUKBTo0aNHZFkWtbwwx3Ho8+fPuHv3Lt6+fYvp6WnMzMxAUZRwjsD/hHq9jpcvX6JYLCKfz2NxcRGXL18Gtra2aHJykrLZLD1//pxOO8vLy2QYBuXzebIsizA/P08AhJwDLC0tEQBaWFggZpomSZKEV69eRd3LY0WhUIAkSZDW19cxOzsbdT6x4/bt23j37h0k27ah6+J0rJNMJoNKpSLmQTySnSt2dnbQaDT6DqwoCgYHB9vLjUYDOzs7fccFAMMwIMtye7lcLqNer/cdV5ZlGIbhW+cT5DgOPnz40HdDLW7duoV0Og0A+PjxY2iCstksRkdHAQCu6+L9+/ehxAWAmzdvQtP2r1f4vmLfv38PraHOeGHGbjabJxK3WzwxBnEQgjgIQRyEIA5CEAchiIMQxEEI4iAEcRCCOAhBHIQgDkIQByGIg68elE6nkUqlfOWEXpFlGaqqtpcNw4DneaD9m0Z7gjHmK2qpqgpVVUMp8smy3K5ftUh27jAxMdF3Q90YGhrC0NBQ6HGTySTGx8dDj9uOf3CBiLC5udnT0WCM4cKFC75ecxDbtmFZVk89SFVVXLx4seu2fnM+f/78oV5zEJ+garWKzc3NYzfUIpFIYHh4uOu2UqnUV8k1l8shkUgcWu95Xl85M8Zw5cqVI7f7BGmahtHR0Z7GIMYYstnskdtHRkZQLpePHRcAUqlUVznA7rh57dq1nntQZ5G+E5+gHz9+wLbtQHVexhhyuRwGBgYCJeN5HhzHCbSvoii4dOlSoH2JCLZtBz6ouVzOV5Tn4RPkui6+fPkS+I8ZY4EFff36Fd++fQscO5fL+S7tHIXneSiVSoHjAuhdkKZpuH79eqCjwRhDJpMJ3NDIyAjOnj0baF9FUQLJAXa/YkFzBuC7VheEQxcOj/NPHwdZlnHmzJkTiX1SOQNiJs1FCOIgBHHwjUGNRgMbGxuh3AiQSqUwNjbWnr+USiV8+vSp77iMMQwPD7dn1s1mExsbG6jVan3HVhQFY2NjSCb3tfh6ULPZDEUOANRqNd8vS7VaDSUuEfliNZvNUOQAuzdydk44D53N37hxA57n9d1YqzLQ4urVqzAMI5Sz+YMzdlVVQ8tZVdWfn80DgK7rJ3LHWSKRwLlz50KPC5xczoAYpLlIuq6jUqlEnUfsKJfLyGQyYKZpEmMMr1+/jjqnWGGaJhKJBKS5uTkUi0WsrKxEnVNsePbsGVZXVzE3NwdYlkX5fJ4Mw6ClpaUI72+PB0+fPqXBwUGampqi7e3t/YdZ7t27h7W1NZimidnZ2SNLnL8qpVIJL168wOrqKqamprC4uLhbk2o99mNZFi0sLND09DTpuh7540n/9UfXdZqZmaHHjx/T9va2/3GocI7Br4mYB3EQgjgIQRyEIA5CEAcJgB11EjGmLAFYjzqLGLMuMcaeRJ1FXGGMPWFElKpWq0UA+agTihlvBgYGChKAGmPsDoC1qDOKEW/2nNQZ7deIU67rPqDdV3ZN4PS9eMkG8NfeawL/AFAHgH8BYOeRSpJ9wjEAAAAASUVORK5CYII=\";s:24:\"compatible_website_types\";a:1:{i:0;s:9:\"ecommerce\";}s:11:\"description\";s:25:\"Showcase offered products\";s:3:\"key\";s:13:\"products_list\";s:12:\"template_key\";s:13:\"products_list\";s:7:\"ui_name\";s:13:\"Products list\";s:8:\"ui_order\";i:2;}i:23;a:7:{s:12:\"base64_image\";s:1808:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAACXBIWXMAAB2HAAAdhwGP5fFlAAAAGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAABNhJREFUeJztnE1PIkkYx/9VogzQ2L4bzUY9GBOzq3hqNPoR5qYHMx9g5tP4ct29z568+PoNfCFeRnfVxBijcUUlARRoSqHl2cPIOkag0DR2z1q/hEs/lX6e/lU3VQWVZkSEBz4IIb4Q0ScAvwII4H1hAvibMfanz+f7HcAdADAighDiFyJaBTDsaInuYYcx9tHn8/3DAXxQcp4RIqIVAF4uhPgCJacUISHEZ/7wnaMoARF9YqZppgFoThfjUjIcSk4lNO50BW5HCZKgBElQgiQoQRKUIAlKkAQlSIISJEEJkqAEyTBNk0zTpHg8TjMzM2QYBgUCAQLwrj6BQIDC4TDNzs5SIpGgohdmmiZFo1FMTk5id3cXo6OjGBsbQ0NDgz098JOQy+WwsbGBSCSCUCiEhYUFdHd3A/F4nIaHh6mpqYnW1tbovbOyskK6rlMoFKJEIkGYmZkhAErODywvLxMAmpubI2YYBnHOsbm56fRd7irC4TA45+D7+/sYHx93uh7XMTExgb29PXgymQw07fmPipZl4fDwEEKImhZSX1+P/v5++P3+J8ez2SyOjo6Qz+drmt/n82FgYAAej+fJ8WAwiHQ6XX4edHNzU3M5AJDP5xGPx58dj8fjNZcDAEII3NzclI2XFUSP/7jWnEKh4Lr8RdRMWoISJEEJkqAESVCCJChBEjyyBoFA4Puqtkru7u5wdnZm2zDd0tKC1tbWqtunUilcXV3ZkhuoQlBbWxsaGxtfdNJYLIbb29tXF/UjnZ2dz2bZldA07W0FxWIxcM7BGKvqhEII2+QAwPn5Odra2qpuX2lW/BqkgoQQOD09LSmoUCjUfMabSqVgmmbJ2P39fU1zA1UIam9vR09PT8mYZVk4ODhALpezvbAivb29Ze8gIQQODg5q2knSUczr9ZaNeTyeZ6tgu6mU3+v1Vv3ovxbp1UWjUWQymZKF5HI5ZLPZmhRW5Pj4GMFgsGRMCFFxoWkHUkGFQgHX19c1LaISlmUhmUw6ll9NFCVU9QWi6zrq6+ttTVy8M2WPCOccTU1N4Nzevszn81VNCaSCurq6XjSTfgnJZBLHx8cV2/T19aG5ubkm+aPRKC4uLiq2kXaL3XfOS8/tdP6qRrH7+3vbh/NCoYBYLCZtd3Jygo6ODtsfMcuyqlqSlL3q4rBuWRbOz8/tq6wEpS6+mL+4+H3r/P/FygV0XX/RIvG1NDQ0lFytt7a2vsn+AL/fD13Xy8Y9mqYhnU4/D3g8GBwcrGVtFfH7/RgaGnIsfyqVQjAYBDMMgxhj2NracqwYN2IYBurq6sCnp6cRiUSwurrqdE2uYWlpCdvb25iengYSiQSFQiHSdZ2Wl5cd3VXhBhYXF6mxsZFGRkYomUw+bqCamprCzs4ODMPA+Pg4Ojs7ne7IN+Xy8hLr6+vY3t7GyMgIFhYW0NXV9bgFL5FI0NzcHI2OjpKmaY5viXvrj6ZpNDY2RvPz85RMJp9uwbOnD/6fqNW8BCVIghIkQQmSoARJUIIkKEESlCAJSpAEJUiCEiSBA8g4XYSLSXEA+05X4WL2OWPsq9NVuBXG2FdGRN5sNhsBEHK6IJfxze/3hzmAO8bYRwA7TlfkIr49OMkxetyd5RVCfKbvr+z6De/vxUsZAH89vCbwDwA5APgXUJR9PpaxC5sAAAAASUVORK5CYII=\";s:24:\"compatible_website_types\";a:1:{i:0;s:9:\"ecommerce\";}s:11:\"description\";s:30:\"Display key product categories\";s:3:\"key\";s:19:\"products_categories\";s:12:\"template_key\";s:19:\"products_categories\";s:7:\"ui_name\";s:18:\"Product categories\";s:8:\"ui_order\";i:2;}i:24;a:7:{s:12:\"base64_image\";s:1200:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAABHNCSVQICAgIfAhkiAAAAzpJREFUeF7tnC2M4lAQx6cCDGRzBIMDDBawYO4c60CCAk/CCjzgSQ6BIEEAIcGyDtydAbutxQAOQ7gQQIDodbrXHuyylG5baLfzEpKmtK9vfu8/8/rx5jFwVHa7XYHn+aywK3K830bbrGB/ze12dySbGdxYrVbfnE7nLxuDeasBdr/f//B4PH9EQNvt9oXgvPMT1uVyRRnBrZ4EWf20kRtdbarAJceQei7yYhEQfzVSGx5IgBQ6nQARIG1xgRRECiIFaSOgRkGNRgO63S6wLGvoRc1aeSQSgXw+D+l0Wm6iGIPW6zU8Pj6KYMLhMOCBgUDArHYY0q7ZbCbaz3GcaP9gMICHhwcQAcXjcZhOp9ButyGZTBrSAKtU+vz8DNlsFoLBIIxGI2Cq1SpfLBah3+/bHo7UiQgplUpBs9kERpCT8EzG2zbufKRsdDOGYQBfd/CFQgFqtZpVvOAm7UQ363Q6r4BKpRKUy+WbXNgqF0EelUrFGECHwwFwZLxlwRHH4XDodklDAeGIiJBuWRAOjjx6FQKkQNJQQORieunYxPUYqiAT23110+4CSA/X03u0+ojYXQDpMbrpPVoRoKud6vTAuyiIXOyTvWXG0+6iIDOCMFUMIkBWIqD1UWO5XAL+tBSv1wv4k4pV6sT2KsagyWSihY18bigUkretUicBOtP1xx1JgAiQ+uhAClJgRoAIkHq3Oj6DFEQKIgXd7OaT7oPoPki9u1GQ1jtIW+XJ24h2XhWD1Iv0a52h+LrjnLk4Y+OjSQn4OQa/WaktZq1TNSA0ZLFYXLTf5/OpgmTmOgmQgtpVA0LpmNUd3spaj3Z+CpDa+GLl408A0STO910pT+IUZtbzON315QXzeqlIBKLRKOD0aJpIfkYTJxPJMRUhFovBfD6HVqtl+9n2CCeXy4Hf74fxePyaq4FRP5FIyIkcdk5mkRJ6hsPh/2QWSWW9Xg/q9boIyo4FM50wHSqTycjmU0qmghIIEAHSFixIQaQgUpA2AqQgbfwwBmEOeFhbNV/2bI4WWLrQt+ICS/g/qegsJU5YoityvMjbb3I1GRQnLPL2XV7kTdq92WyywruhJxuD4v4tE9iWmPwFoSgsODJsB1oAAAAASUVORK5CYII=\";s:24:\"compatible_website_types\";a:2:{i:0;s:5:\"basic\";i:1;s:9:\"ecommerce\";}s:11:\"description\";s:18:\"Introduce the team\";s:3:\"key\";s:4:\"team\";s:12:\"template_key\";s:4:\"team\";s:7:\"ui_name\";s:4:\"Team\";s:8:\"ui_order\";i:15;}i:25;a:7:{s:12:\"base64_image\";s:1112:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAABHNCSVQICAgIfAhkiAAAAvlJREFUeF7tnL+z4VAUx0/M0Hhj1l+Af8CPlma3o6Ok4g8wXqNGrVgzCoUCY0ZLR7fb0Er8A+h0dgwKZmRz8jZ5scwjbuLxcm6ViZu453O/5xy5Jy4HmrbdbnOiKKalU0HteQsd85L9lZeXl5ZiM4cHy+Xym8Ph+GVhMP9rgN/tdj/cbvcfGdBmsxkTnBM/4Z1OZ4iT3OpVktVPC7nR1aZKXDIcqedDXjwCEq9GasGOBOjCpBMgAsQWF0hBpCBSEBsBUhAbP4pBpCBSEBsBUhAbP4pBpCBSEBsBUhAbv6MYVKvVoN1ugyAIbHd90qsDgQBks1lIJpOqBTKg1WoFsVgMeJ4H7BQMBsHr9T6pmbcNezabyfajOND+fr8PLpcLZECRSASm0yk0m02Ix+O3fcMXuarX60E6nQafzwfD4RC4crks5vN56Ha7loejzDFCSiQSUK/XgZNcSl6TRnlReyeAboYN62JiLpeDSqVCfDQE0M1ardYboEKhAMVikQBpCCCPUqlkPqD9fg+YJc1omGXsdrsZt5YFcxdAmB0RkhkN4WC2MaMRoAtU7waIXMwMfT/APe+moAew9aYhGA7ITFfSa6ER2c1wQGZmK72AjMhuBOjeWYxcTK/On7y/4S725DxOhv/pgBSX1GYcfGY791hiRFbSO4GfDkjJekrGQTiLxeKsHUZkJQKkl8C9s5je8ZGL6SX2YP2PYhAtuZ7Ojrrk6vf7RZvNBuMx/l2DmkIgFArB4XCgss85SRyVfbBwGA6HYT6fQ6PRsHxtDOFkMhnweDwwGo3eKqv4GyQajaplVyuXnpXy+2AweC89KzLrdDpQrVZhMplYMhhJ8Vh+eSGVSqn20xtmF6RAgAgQW7QgBZGCSEFsBEhBbPwoBpGCSEFsBEhBbPwoBpGCSEFsBEhBbPwoBl2hIHzFPsDG+cteLdAGSx/MrbzBEn4urUuTik5BCdIWXUHtJm+/ydVUSoK0ydt3dZM35fR6vU5zHPdqYVDCv20CmwqTvzMqP9Fb/43gAAAAAElFTkSuQmCC\";s:24:\"compatible_website_types\";a:2:{i:0;s:5:\"basic\";i:1;s:9:\"ecommerce\";}s:11:\"description\";s:33:\"Showcase clients\' success stories\";s:3:\"key\";s:12:\"testimonials\";s:12:\"template_key\";s:12:\"testimonials\";s:7:\"ui_name\";s:12:\"Testimonials\";s:8:\"ui_order\";i:11;}i:26;a:7:{s:12:\"base64_image\";s:1060:\"iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAABHNCSVQICAgIfAhkiAAAAtFJREFUeF7tnD+vIVEYh99RSITI+gCCRJT+tDS7HR0lFR9A3EaNWrEShUKBSLR0dLsNrRlfAB9AbASFwuw5c3dcd+0i9yjmmt9UMuaMOc8875uZ8x5HorNtv98XVFXNsl3h8/0m+iyz/tccDkdH77PEP6zX6y9Wq/WHicH87YB8OBy+uVyuXxqg3W43BZyLOJHtdntEYmH1wrT6bqIwururjEtOgj1XeckckHo3UhMeCEA3bjoAAZBYXoBBMAgGiRGAQWL8kINgEAwSIwCDxPghB8EgGCRGAAaJ8XuXgxqNBnW7XVIUReysn7R1KBSifD5P6XT61AMN0GazoUQiQbIsEz8oHA6T1+v9pN382GUvFgut/1wO3v/hcEhOp5M0QLFYjObzObXbbUomkx/7hSdpNRgMKJvNks/no/F4TFK1WlWLxSL1+33Tw9HvMYeUSqWo2WySxEJKG5PmemF7I8DDjG+8LqYWCgWq1Wrgc0aAh1mn03kFVCqVqFwuA9AZAc6jUqkA0P+sAKAb8QJAACSWUmEQDDKYQcfjkU/EEruqB7RerVbk9/vJYrEIne3hIcZf9tisLKGLemTjQCAgdLqnBmSz2cjtdhsLkFFCjFNhcwuNF2JCt8uAjR8eYgbso9AlARCeg4QE0kY38DZ/hSEAIcQeGGIYcr2EeRpyDQaDKn9vmU753zWw6QQikQjxh1+Uff7hxLuyDy8cRqNRWi6X1Gq1TF8b43ByuRx5PB6aTCavlVVeeo7H46eyq5lLz3r5fTQavZWedct6vR7V63WazWamTEYsH2uTFzKZzKn/mGF2QwUAAiCxbAGDYBAMEiMAg8T4IQfBIBgkRgAGifFDDoJBMEiMAAwS44ccdIdBfIp9SIzz07ZWsMDSlXurLbDEv2fj0rDoEpTClugKny/y9hOhdqKksOmEX0+LvOm7t9ttVpKkFxODUv4sE9jWmfwGnZb6wh5QzokAAAAASUVORK5CYII=\";s:24:\"compatible_website_types\";a:2:{i:0;s:5:\"basic\";i:1;s:9:\"ecommerce\";}s:11:\"description\";s:20:\"Display a page title\";s:3:\"key\";s:5:\"title\";s:12:\"template_key\";s:5:\"title\";s:7:\"ui_name\";s:5:\"Title\";s:8:\"ui_order\";i:9;}}}", "on");
INSERT INTO `wp_options` VALUES("196", "twbb_singular_conditions", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("197", "twbb_archive_conditions", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("198", "twbb_general_conditions", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("199", "_site_transient_timeout_wp_theme_files_patterns-7c8dd9829f7721d8849a7f2fe86f85e0", "1763992143", "off");
INSERT INTO `wp_options` VALUES("200", "_site_transient_wp_theme_files_patterns-7c8dd9829f7721d8849a7f2fe86f85e0", "a:2:{s:7:\"version\";s:6:\"2.1.19\";s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("201", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1763990347;s:8:\"response\";a:2:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:3:\"5.6\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:53:\"http://downloads.wordpress.org/plugin/akismet.5.6.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:60:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=2818463\";s:2:\"1x\";s:60:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=2818463\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/akismet/assets/banner-1544x500.png?rev=2900731\";s:2:\"1x\";s:62:\"https://ps.w.org/akismet/assets/banner-772x250.png?rev=2900731\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.8\";s:6:\"tested\";s:3:\"6.9\";s:12:\"requires_php\";s:3:\"7.2\";s:16:\"requires_plugins\";a:0:{}}s:23:\"elementor/elementor.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:6:\"3.33.2\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:7:\"package\";s:58:\"http://downloads.wordpress.org/plugin/elementor.3.33.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.gif?rev=3111597\";s:2:\"1x\";s:62:\"https://ps.w.org/elementor/assets/icon-128x128.gif?rev=3111597\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=3164133\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=3164133\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:5:\"6.8.3\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:2:{s:49:\"tenweb-speed-optimizer/tenweb_speed_optimizer.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:36:\"w.org/plugins/tenweb-speed-optimizer\";s:4:\"slug\";s:22:\"tenweb-speed-optimizer\";s:6:\"plugin\";s:49:\"tenweb-speed-optimizer/tenweb_speed_optimizer.php\";s:11:\"new_version\";s:6:\"2.32.7\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/tenweb-speed-optimizer/\";s:7:\"package\";s:71:\"http://downloads.wordpress.org/plugin/tenweb-speed-optimizer.2.32.7.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:75:\"https://ps.w.org/tenweb-speed-optimizer/assets/icon-256x256.png?rev=2753401\";s:2:\"1x\";s:75:\"https://ps.w.org/tenweb-speed-optimizer/assets/icon-128x128.png?rev=2753401\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:78:\"https://ps.w.org/tenweb-speed-optimizer/assets/banner-1544x500.png?rev=2757096\";s:2:\"1x\";s:77:\"https://ps.w.org/tenweb-speed-optimizer/assets/banner-772x250.png?rev=2757096\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";}s:9:\"hello.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/hello-dolly\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:5:\"1.7.2\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:59:\"http://downloads.wordpress.org/plugin/hello-dolly.1.7.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=2052855\";s:2:\"1x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=2052855\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/hello-dolly/assets/banner-1544x500.jpg?rev=2645582\";s:2:\"1x\";s:66:\"https://ps.w.org/hello-dolly/assets/banner-772x250.jpg?rev=2052855\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.6\";}}s:7:\"checked\";a:5:{s:49:\"tenweb-speed-optimizer/tenweb_speed_optimizer.php\";s:6:\"2.32.9\";s:33:\"tenweb-builder/tenweb-builder.php\";s:7:\"1.37.49\";s:19:\"akismet/akismet.php\";s:3:\"5.5\";s:23:\"elementor/elementor.php\";s:6:\"3.31.5\";s:9:\"hello.php\";s:5:\"1.7.2\";}}", "off");
INSERT INTO `wp_options` VALUES("202", "_site_transient_timeout_theme_roots", "1763992149", "off");
INSERT INTO `wp_options` VALUES("203", "_site_transient_theme_roots", "a:4:{s:28:\"tenweb-website-builder-theme\";s:7:\"/themes\";s:16:\"twentytwentyfive\";s:7:\"/themes\";s:16:\"twentytwentyfour\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";}", "off");
INSERT INTO `wp_options` VALUES("204", "woocommerce_coming_soon", "no", "auto");
INSERT INTO `wp_options` VALUES("205", "woocommerce_store_pages_only", "no", "auto");
INSERT INTO `wp_options` VALUES("206", "woocommerce_private_link", "no", "auto");
INSERT INTO `wp_options` VALUES("209", "tenweb_domain_id", "1455647", "auto");
INSERT INTO `wp_options` VALUES("210", "tenweb_workspace_id", "3184113", "off");
INSERT INTO `wp_options` VALUES("213", "_site_transient_timeout_tenweb_add_workspace_id_checked", "1764595165", "off");
INSERT INTO `wp_options` VALUES("215", "_site_transient_tenweb_add_workspace_id_checked", "1", "off");
INSERT INTO `wp_options` VALUES("231", "tenweb_user_info_transient", "1", "auto");
INSERT INTO `wp_options` VALUES("236", "tenweb_connected_from", "manager", "auto");
INSERT INTO `wp_options` VALUES("237", "tenweb_user_timezone_offset", "0", "auto");
INSERT INTO `wp_options` VALUES("238", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("239", "two_trans_timeout_tenweb_subscription_id", "1764033579", "off");
INSERT INTO `wp_options` VALUES("240", "two_trans_tenweb_subscription_id", "318", "off");
INSERT INTO `wp_options` VALUES("241", "two_trans_timeout_tenweb_plan_title", "1764033579", "off");
INSERT INTO `wp_options` VALUES("242", "two_trans_tenweb_plan_title", "Free plan", "off");
INSERT INTO `wp_options` VALUES("243", "two_trans_timeout_tenweb_subscription_response_code", "1763993979", "off");
INSERT INTO `wp_options` VALUES("244", "two_trans_tenweb_subscription_response_code", "200", "off");
INSERT INTO `wp_options` VALUES("245", "two_settings", "{\"no_optimize_pages\":[],\"two_delay_js_exclusions\":[],\"two_exclude_rev\":\"\",\"two_exclude_slider_by_10web\":\"\",\"two_exclude_elementor_scripts\":\"\",\"two_exclude_photo_gallery_by_10web\":\"\",\"two_exclude_amp_plugin_cdn\":\"\",\"two_exclude_owl\":\"\",\"two_exclude_slick\":\"\",\"two_exclude_google_ads\":\"\",\"two_exclude_css\":\"wp-content\\/cache\\/, admin-bar.min.css, ds-gravity-forms-for-divi\",\"two_gzip\":\"\",\"two_page_cache\":\"\",\"two_page_cache_user\":\"\",\"two_serve_gzip\":\"on\",\"two_empty_encoding_serve_gzip\":\"\",\"two_minify_html\":\"\",\"two_page_cache_life_time\":\"604800\",\"two_disable_jetpack_optimization\":\"\",\"two_generate_ccss_on_load\":[],\"two_fonts_to_preload\":\"\",\"two_fonts_to_preconnect\":\"\",\"two_disabled_speed_optimizer_pages\":\"robots.txt,.well-known\",\"two_async_font\":\"on\",\"two_merge_google_font_faces\":\"\",\"two_load_fonts_via_webfont\":\"\",\"two_test_mode\":\"\",\"two_files_cache\":\"on\",\"two_enable_htaccess_caching_headers\":\"\",\"two_enable_plugin_autoupdate\":\"\",\"two_all_pages_are_optimizable\":\"\",\"two_optimize_archive_pages\":\"\",\"two_connected\":\"1\",\"cloudflare_cache_status\":\"off\",\"two_change_minify\":\"\",\"two_aggregate_css\":\"on\",\"two_include_inline_css\":\"on\",\"two_async_all\":\"\",\"two_async_css\":\"elementor-icons-css, elementor-animations-css, elementor-icons-shared-0-css, elementor-icons-fa-brands-css, elementor-icons-fa-solid-css ,elementor-icons-fa-regular-css, tenweb-website-builder-theme-style-css, open-sans-css, font-awesome-css, bwg_googlefonts-css, bwg_fonts-css, elementor-global-css, google-fonts-1-css, elementor-common-css, wc-block-style-css, wp-block-library-css\",\"two_disable_wp_dashicons\":\"\",\"two_add_overflow_to_page\":\"off\",\"two_disable_css\":\"\",\"two_minify_css\":\"on\",\"two_split_css\":\"\",\"two_aggregate_js\":\"on\",\"two_include_inline_js\":\"on\",\"two_use_extended_exception_list_js\":\"\",\"two_dequeue_jquery_migrate\":\"\",\"two_exclude_delay_js\":\"\",\"two_delay_custom_js_new\":\"\",\"two_delay_js_execution\":\"on\",\"two_delayed_js_load_libs_first\":\"\",\"two_delayed_js_execution_list\":\"getbutton.io,\\/\\/a.omappapi.com\\/app\\/js\\/api.min.js,feedbackcompany.com\\/includes\\/widgets\\/feedback-company-widget.min.js,snap.licdn.com\\/li.lms-analytics\\/insight.min.js,static.ads-twitter.com\\/uwt.js,platform.twitter.com\\/widgets.js,twq(,\\/sdk.js#xfbml,static.leadpages.net\\/leadbars\\/current\\/embed.js,translate.google.com\\/translate_a\\/element.js,widget.manychat.com,xfbml.customerchat.js,static.hotjar.com\\/c\\/hotjar-,smartsuppchat.com\\/loader.js,grecaptcha.execute,Tawk_API,shareaholic,sharethis,simple-share-buttons-adder,addtoany,font-awesome,wpdiscuz,cookie-law-info,pinit.js,\\/gtag\\/js,gtag(,\\/gtm.js,\\/gtm-,fbevents.js,fbq(,google-analytics.com\\/analytics.js,ga( \',ga(\',adsbygoogle,ShopifyBuy,widget.trustpilot.com\\/bootstrap,ft.sdk.min.js,apps.elfsight.com\\/p\\/platform.js,livechatinc.com\\/tracking.js,LiveChatWidget,\\/busting\\/facebook-tracking\\/,olark,pixel-caffeine\\/build\\/frontend.js,wp-emoji-release.min.js\",\"two_exclude_js\":\"wp-content\\/cache\\/, wp-includes\\/js\\/dist\\/, wp-includes\\/js\\/tinymce\\/, jquery.js, jquery.min.js, jquery-migrate.min.js, jquery-migrate.js, jquery.mobile, jquery-mobile\",\"two_minify_js\":\"on\",\"two_delay_all_js_execution\":\"on\",\"two_timeout_js_load\":\"\",\"two_load_excluded_js_via_worker\":\"\",\"two_load_excluded_js_normally\":\"\",\"two_events_after_load\":[\"DOMContentLoaded\",\"Load\",\"Click\"],\"two_disabled_delay_all_js_pages\":\"\",\"two_lazyload\":\"on\",\"two_add_noscript\":\"on\",\"two_lazyload_slider_images\":\"\",\"two_bg_lazyload\":\"on\",\"two_img_in_viewport_lazyload\":\"on\",\"two_iframe_lazyload\":\"on\",\"two_delay_iframe_lazyload\":\"\",\"two_elemrntor_video_iframe\":\"\",\"two_remove_elementor_lazyload\":\"\",\"two_youtube_vimeo_iframe_lazyload\":\"\",\"two_video_lazyload\":\"on\",\"two_exclude_lazyload\":\"\",\"lazy_load_type\":\"vanilla\",\"two_do_not_optimize_images\":\"\",\"two_enable_use_srcset\":\"on\",\"two_enable_nginx_webp_delivery\":\"on\",\"two_enable_htaccess_webp_delivery\":\"on\",\"two_enable_picture_webp_delivery\":\"\",\"two_exclude_images_for_optimize\":\"\",\"two_serve_optimized_bg_image\":\"on\",\"two_async_page\":\"\",\"two_disable_page\":\"\",\"two_critical_pages\":{\"front_page\":{\"title\":\"Home\",\"url\":\"https:\\/\\/concise-goshawk.10web.cloud\",\"id\":\"front_page\",\"sizes\":[\"two_1617650538215\",\"two_1617650549855\",\"two_1617650561871\",\"two_1617650582190\",\"two_1617650596079\",\"two_1617650611968\"],\"load_type\":\"async\",\"wait_until\":\"load\",\"use_uncritical\":\"false\",\"status\":\"success\",\"critical_css\":\"two_front_page_critical.css\",\"critical_fonts\":\"two_front_page_critical_font.json\",\"critical_bg\":\"two_front_page_critical_bg.json\",\"images_in_viewport\":\"two_front_page_images_in_viewport.json\",\"critical_date\":\"1763990402\"}},\"two_critical_sizes\":{\"two_1617650538215\":{\"width\":\"1920\",\"height\":\"800\",\"media\":\"@media screen and (min-width: 1920px)\",\"uid\":\"two_1617650538215\"},\"two_1617650549855\":{\"width\":\"1500\",\"height\":\"800\",\"media\":\"@media screen and (min-width: 1500px) and (max-width: 1920px)\",\"uid\":\"two_1617650549855\"},\"two_1617650561871\":{\"width\":\"1280\",\"height\":\"700\",\"media\":\"@media screen and (min-width: 1280px) and (max-width: 1500px)\",\"uid\":\"two_1617650561871\"},\"two_1617650582190\":{\"width\":\"1024\",\"height\":\"600\",\"media\":\"@media screen and (min-width: 1024px) and (max-width: 1280px)\",\"uid\":\"two_1617650582190\"},\"two_1617650596079\":{\"width\":\"768\",\"height\":\"500\",\"media\":\"@media screen and (min-width: 767px) and (max-width: 1024px)\",\"uid\":\"two_1617650596079\"},\"two_1617650611968\":{\"width\":\"320\",\"height\":\"400\",\"media\":\"@media screen and (max-width: 767px)\",\"uid\":\"two_1617650611968\"}},\"two_critical_url_args\":\"PageSpeed=off&two_nooptimize=1&two_action=generating_critical_css\",\"two_critical_status\":\"true\",\"two_critical_remove\":\"false\",\"two_critical_font_status\":\"true\",\"two_font_actions\":\"not_load\",\"two_non_optimizable_speed_optimizer_pages\":\"\\/wp-admin\\/, \\/xmlrpc.php, wp-.*.php, \\/feed(\\/)*, index.php, sitemap(_index)?.xml, \\/store.*,\\/cart.*, \\/my-account.*, \\/checkout.*, \\/addons.*, well-known, acme-challenge\",\"two_webp_delivery_working\":\"1\",\"two_clear_cache_date\":\"1763990402\",\"tenweb_so_version\":\"2.32.9\"}", "auto");
INSERT INTO `wp_options` VALUES("246", "two_critical_default_settings", "a:4:{s:14:\"use_uncritical\";s:5:\"false\";s:9:\"load_type\";s:5:\"async\";s:10:\"wait_until\";s:4:\"load\";s:13:\"default_sizes\";a:6:{i:0;s:17:\"two_1617650538215\";i:1;s:17:\"two_1617650549855\";i:2;s:17:\"two_1617650561871\";i:3;s:17:\"two_1617650582190\";i:4;s:17:\"two_1617650596079\";i:5;s:17:\"two_1617650611968\";}}", "auto");
INSERT INTO `wp_options` VALUES("247", "two_update_default_excluded_css_list", "1", "auto");
INSERT INTO `wp_options` VALUES("248", "redirect_after_activation_option", "1", "auto");
INSERT INTO `wp_options` VALUES("249", "two_home_url", "https://concise-goshawk.10web.cloud", "auto");
INSERT INTO `wp_options` VALUES("251", "two_set_not_optimizable_and_turn_off_mode_settings_v2", "1", "off");
INSERT INTO `wp_options` VALUES("252", "two_set_dispatch_events", "1", "auto");
INSERT INTO `wp_options` VALUES("253", "two_set_generate_ccss_on_load", "1", "auto");
INSERT INTO `wp_options` VALUES("254", "two_set_compress_html_default", "1", "auto");
INSERT INTO `wp_options` VALUES("256", "two_trans_timeout_two_critical_in_progress_front_page", "1763992184", "off");
INSERT INTO `wp_options` VALUES("257", "two_trans_two_critical_in_progress_front_page", "1", "off");
INSERT INTO `wp_options` VALUES("260", "two_trans_timeout_two_critical_flag", "1764076784", "off");
INSERT INTO `wp_options` VALUES("261", "two_trans_two_critical_flag", "1", "off");
INSERT INTO `wp_options` VALUES("268", "elementor_custom_icon_sets_config", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("269", "action_scheduler_hybrid_store_demarkation", "50", "auto");
INSERT INTO `wp_options` VALUES("270", "schema-ActionScheduler_StoreSchema", "8.0.1763990389", "auto");
INSERT INTO `wp_options` VALUES("271", "schema-ActionScheduler_LoggerSchema", "3.0.1763990389", "auto");
INSERT INTO `wp_options` VALUES("272", "woocommerce_newly_installed", "yes", "auto");
INSERT INTO `wp_options` VALUES("273", "woocommerce_schema_version", "920", "auto");
INSERT INTO `wp_options` VALUES("274", "woocommerce_store_address", "", "on");
INSERT INTO `wp_options` VALUES("275", "woocommerce_store_address_2", "", "on");
INSERT INTO `wp_options` VALUES("276", "woocommerce_store_city", "", "on");
INSERT INTO `wp_options` VALUES("277", "woocommerce_default_country", "US:CA", "on");
INSERT INTO `wp_options` VALUES("278", "woocommerce_store_postcode", "", "on");
INSERT INTO `wp_options` VALUES("279", "woocommerce_allowed_countries", "all", "on");
INSERT INTO `wp_options` VALUES("280", "woocommerce_all_except_countries", "", "on");
INSERT INTO `wp_options` VALUES("281", "woocommerce_specific_allowed_countries", "", "on");
INSERT INTO `wp_options` VALUES("282", "woocommerce_ship_to_countries", "", "on");
INSERT INTO `wp_options` VALUES("283", "woocommerce_specific_ship_to_countries", "", "on");
INSERT INTO `wp_options` VALUES("284", "woocommerce_default_customer_address", "base", "on");
INSERT INTO `wp_options` VALUES("285", "woocommerce_address_autocomplete_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("286", "woocommerce_calc_taxes", "no", "on");
INSERT INTO `wp_options` VALUES("287", "woocommerce_enable_coupons", "yes", "on");
INSERT INTO `wp_options` VALUES("288", "woocommerce_calc_discounts_sequentially", "no", "off");
INSERT INTO `wp_options` VALUES("289", "woocommerce_currency", "USD", "on");
INSERT INTO `wp_options` VALUES("290", "woocommerce_currency_pos", "left", "on");
INSERT INTO `wp_options` VALUES("291", "woocommerce_price_thousand_sep", ",", "on");
INSERT INTO `wp_options` VALUES("292", "woocommerce_price_decimal_sep", ".", "on");
INSERT INTO `wp_options` VALUES("293", "woocommerce_price_num_decimals", "2", "on");
INSERT INTO `wp_options` VALUES("295", "woocommerce_cart_redirect_after_add", "no", "on");
INSERT INTO `wp_options` VALUES("296", "woocommerce_enable_ajax_add_to_cart", "yes", "on");
INSERT INTO `wp_options` VALUES("297", "woocommerce_placeholder_image", "50", "on");
INSERT INTO `wp_options` VALUES("298", "woocommerce_weight_unit", "lbs", "on");
INSERT INTO `wp_options` VALUES("299", "woocommerce_dimension_unit", "in", "on");
INSERT INTO `wp_options` VALUES("300", "woocommerce_enable_reviews", "yes", "on");
INSERT INTO `wp_options` VALUES("301", "woocommerce_review_rating_verification_label", "yes", "off");
INSERT INTO `wp_options` VALUES("302", "woocommerce_review_rating_verification_required", "no", "off");
INSERT INTO `wp_options` VALUES("303", "woocommerce_enable_review_rating", "yes", "on");
INSERT INTO `wp_options` VALUES("304", "woocommerce_review_rating_required", "yes", "off");
INSERT INTO `wp_options` VALUES("305", "woocommerce_manage_stock", "yes", "on");
INSERT INTO `wp_options` VALUES("306", "woocommerce_hold_stock_minutes", "60", "off");
INSERT INTO `wp_options` VALUES("307", "woocommerce_notify_low_stock", "yes", "off");
INSERT INTO `wp_options` VALUES("308", "woocommerce_notify_no_stock", "yes", "off");
INSERT INTO `wp_options` VALUES("309", "woocommerce_stock_email_recipient", "live@10web.cloud", "off");
INSERT INTO `wp_options` VALUES("310", "woocommerce_notify_low_stock_amount", "2", "off");
INSERT INTO `wp_options` VALUES("311", "woocommerce_notify_no_stock_amount", "0", "on");
INSERT INTO `wp_options` VALUES("312", "woocommerce_hide_out_of_stock_items", "no", "on");
INSERT INTO `wp_options` VALUES("313", "woocommerce_stock_format", "", "on");
INSERT INTO `wp_options` VALUES("314", "woocommerce_file_download_method", "force", "off");
INSERT INTO `wp_options` VALUES("315", "woocommerce_downloads_redirect_fallback_allowed", "no", "off");
INSERT INTO `wp_options` VALUES("316", "woocommerce_downloads_require_login", "no", "off");
INSERT INTO `wp_options` VALUES("317", "woocommerce_downloads_grant_access_after_payment", "yes", "off");
INSERT INTO `wp_options` VALUES("318", "woocommerce_downloads_deliver_inline", "", "off");
INSERT INTO `wp_options` VALUES("319", "woocommerce_downloads_add_hash_to_filename", "yes", "on");
INSERT INTO `wp_options` VALUES("320", "woocommerce_downloads_count_partial", "yes", "on");
INSERT INTO `wp_options` VALUES("322", "woocommerce_attribute_lookup_direct_updates", "no", "on");
INSERT INTO `wp_options` VALUES("323", "woocommerce_attribute_lookup_optimized_updates", "no", "on");
INSERT INTO `wp_options` VALUES("324", "woocommerce_product_match_featured_image_by_sku", "no", "on");
INSERT INTO `wp_options` VALUES("325", "woocommerce_prices_include_tax", "no", "on");
INSERT INTO `wp_options` VALUES("326", "woocommerce_tax_based_on", "shipping", "on");
INSERT INTO `wp_options` VALUES("327", "woocommerce_shipping_tax_class", "inherit", "on");
INSERT INTO `wp_options` VALUES("328", "woocommerce_tax_round_at_subtotal", "no", "on");
INSERT INTO `wp_options` VALUES("329", "woocommerce_tax_classes", "", "on");
INSERT INTO `wp_options` VALUES("330", "woocommerce_tax_display_shop", "excl", "on");
INSERT INTO `wp_options` VALUES("331", "woocommerce_tax_display_cart", "excl", "on");
INSERT INTO `wp_options` VALUES("332", "woocommerce_price_display_suffix", "", "on");
INSERT INTO `wp_options` VALUES("333", "woocommerce_tax_total_display", "itemized", "off");
INSERT INTO `wp_options` VALUES("334", "woocommerce_enable_shipping_calc", "yes", "off");
INSERT INTO `wp_options` VALUES("335", "woocommerce_shipping_cost_requires_address", "no", "on");
INSERT INTO `wp_options` VALUES("336", "woocommerce_shipping_hide_rates_when_free", "no", "off");
INSERT INTO `wp_options` VALUES("337", "woocommerce_ship_to_destination", "billing", "off");
INSERT INTO `wp_options` VALUES("338", "woocommerce_shipping_debug_mode", "no", "on");
INSERT INTO `wp_options` VALUES("339", "woocommerce_enable_guest_checkout", "yes", "off");
INSERT INTO `wp_options` VALUES("340", "woocommerce_enable_checkout_login_reminder", "no", "off");
INSERT INTO `wp_options` VALUES("341", "woocommerce_enable_signup_and_login_from_checkout", "no", "off");
INSERT INTO `wp_options` VALUES("342", "woocommerce_enable_myaccount_registration", "no", "off");
INSERT INTO `wp_options` VALUES("343", "woocommerce_registration_generate_password", "yes", "off");
INSERT INTO `wp_options` VALUES("344", "woocommerce_registration_generate_username", "yes", "off");
INSERT INTO `wp_options` VALUES("345", "woocommerce_erasure_request_removes_order_data", "no", "off");
INSERT INTO `wp_options` VALUES("346", "woocommerce_erasure_request_removes_download_data", "no", "off");
INSERT INTO `wp_options` VALUES("347", "woocommerce_allow_bulk_remove_personal_data", "no", "off");
INSERT INTO `wp_options` VALUES("348", "woocommerce_registration_privacy_policy_text", "Your personal data will be used to support your experience throughout this website, to manage access to your account, and for other purposes described in our [privacy_policy].", "on");
INSERT INTO `wp_options` VALUES("349", "woocommerce_checkout_privacy_policy_text", "Your personal data will be used to process your order, support your experience throughout this website, and for other purposes described in our [privacy_policy].", "on");
INSERT INTO `wp_options` VALUES("350", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("351", "woocommerce_trash_pending_orders", "", "off");
INSERT INTO `wp_options` VALUES("352", "woocommerce_trash_failed_orders", "", "off");
INSERT INTO `wp_options` VALUES("353", "woocommerce_trash_cancelled_orders", "", "off");
INSERT INTO `wp_options` VALUES("354", "woocommerce_anonymize_refunded_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("355", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("356", "woocommerce_email_from_name", "Concise Goshawk", "off");
INSERT INTO `wp_options` VALUES("357", "woocommerce_email_from_address", "live@10web.cloud", "off");
INSERT INTO `wp_options` VALUES("358", "woocommerce_email_header_image", "", "off");
INSERT INTO `wp_options` VALUES("359", "woocommerce_email_header_image_width", "120", "on");
INSERT INTO `wp_options` VALUES("360", "woocommerce_email_header_alignment", "left", "on");
INSERT INTO `wp_options` VALUES("361", "woocommerce_email_font_family", "Helvetica", "on");
INSERT INTO `wp_options` VALUES("362", "woocommerce_email_footer_text", "{site_title}<br />{store_address}", "off");
INSERT INTO `wp_options` VALUES("363", "woocommerce_email_base_color", "#720eec", "off");
INSERT INTO `wp_options` VALUES("364", "woocommerce_email_background_color", "#f7f7f7", "off");
INSERT INTO `wp_options` VALUES("365", "woocommerce_email_body_background_color", "#ffffff", "off");
INSERT INTO `wp_options` VALUES("366", "woocommerce_email_text_color", "#3c3c3c", "off");
INSERT INTO `wp_options` VALUES("367", "woocommerce_email_footer_text_color", "#3c3c3c", "off");
INSERT INTO `wp_options` VALUES("368", "woocommerce_email_auto_sync_with_theme", "no", "off");
INSERT INTO `wp_options` VALUES("369", "woocommerce_pos_store_name", "Concise Goshawk", "on");
INSERT INTO `wp_options` VALUES("370", "woocommerce_pos_store_address", "", "on");
INSERT INTO `wp_options` VALUES("371", "woocommerce_pos_store_phone", "", "on");
INSERT INTO `wp_options` VALUES("372", "woocommerce_pos_store_email", "live@10web.cloud", "on");
INSERT INTO `wp_options` VALUES("373", "woocommerce_pos_refund_returns_policy", "", "on");
INSERT INTO `wp_options` VALUES("377", "woocommerce_terms_page_id", "", "off");
INSERT INTO `wp_options` VALUES("378", "woocommerce_checkout_pay_endpoint", "order-pay", "on");
INSERT INTO `wp_options` VALUES("379", "woocommerce_checkout_order_received_endpoint", "order-received", "on");
INSERT INTO `wp_options` VALUES("380", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "on");
INSERT INTO `wp_options` VALUES("381", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "on");
INSERT INTO `wp_options` VALUES("382", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "on");
INSERT INTO `wp_options` VALUES("383", "woocommerce_myaccount_orders_endpoint", "orders", "on");
INSERT INTO `wp_options` VALUES("384", "woocommerce_myaccount_view_order_endpoint", "view-order", "on");
INSERT INTO `wp_options` VALUES("385", "woocommerce_myaccount_downloads_endpoint", "downloads", "on");
INSERT INTO `wp_options` VALUES("386", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "on");
INSERT INTO `wp_options` VALUES("387", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "on");
INSERT INTO `wp_options` VALUES("388", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "on");
INSERT INTO `wp_options` VALUES("389", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "on");
INSERT INTO `wp_options` VALUES("390", "woocommerce_logout_endpoint", "customer-logout", "on");
INSERT INTO `wp_options` VALUES("391", "woocommerce_api_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("392", "woocommerce_allow_tracking", "no", "on");
INSERT INTO `wp_options` VALUES("393", "woocommerce_show_marketplace_suggestions", "yes", "off");
INSERT INTO `wp_options` VALUES("394", "woocommerce_custom_orders_table_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("395", "woocommerce_analytics_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("396", "woocommerce_feature_blueprint_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("397", "woocommerce_feature_email_improvements_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("398", "woocommerce_email_improvements_disabled_count", "1", "auto");
INSERT INTO `wp_options` VALUES("399", "woocommerce_email_improvements_first_disabled_at", "2025-11-24 13:19:50", "auto");
INSERT INTO `wp_options` VALUES("400", "woocommerce_email_improvements_last_disabled_at", "2025-11-24 13:19:50", "auto");
INSERT INTO `wp_options` VALUES("401", "woocommerce_feature_remote_logging_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("402", "woocommerce_feature_site_visibility_badge_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("403", "woocommerce_feature_order_attribution_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("404", "woocommerce_feature_rate_limit_checkout_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("405", "woocommerce_feature_cost_of_goods_sold_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("406", "woocommerce_feature_destroy-empty-sessions_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("407", "woocommerce_feature_mcp_integration_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("408", "woocommerce_feature_experimental-iapi-mini-cart_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("409", "woocommerce_feature_point_of_sale_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("410", "woocommerce_feature_block_email_editor_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("411", "woocommerce_hpos_datastore_caching_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("412", "woocommerce_hpos_fts_index_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("413", "woocommerce_single_image_width", "600", "on");
INSERT INTO `wp_options` VALUES("414", "woocommerce_thumbnail_image_width", "300", "on");
INSERT INTO `wp_options` VALUES("415", "woocommerce_checkout_highlight_required_fields", "yes", "on");
INSERT INTO `wp_options` VALUES("416", "woocommerce_demo_store", "no", "off");
INSERT INTO `wp_options` VALUES("417", "wc_downloads_approved_directories_mode", "enabled", "auto");
INSERT INTO `wp_options` VALUES("418", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:7:\"product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "auto");
INSERT INTO `wp_options` VALUES("419", "current_theme_supports_woocommerce", "yes", "auto");
INSERT INTO `wp_options` VALUES("420", "woocommerce_queue_flush_rewrite_rules", "no", "auto");
INSERT INTO `wp_options` VALUES("421", "product_cat_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("422", "default_product_cat", "16", "auto");
INSERT INTO `wp_options` VALUES("423", "woocommerce_refund_returns_page_created", "55", "off");
INSERT INTO `wp_options` VALUES("424", "woocommerce_refund_returns_page_id", "55", "auto");
INSERT INTO `wp_options` VALUES("425", "woocommerce_paypal_settings", "a:25:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:6:\"PayPal\";s:11:\"description\";s:85:\"Pay via PayPal; you can pay with your credit card if you don\'t have a PayPal account.\";s:5:\"email\";s:16:\"live@10web.cloud\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:14:\"paypal_buttons\";s:3:\"yes\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:9:\"image_url\";s:0:\"\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:16:\"live@10web.cloud\";s:14:\"identity_token\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:28:\"transact_onboarding_complete\";s:2:\"no\";s:12:\"_should_load\";s:2:\"no\";}", "on");
INSERT INTO `wp_options` VALUES("426", "woocommerce_version", "10.3.5", "auto");
INSERT INTO `wp_options` VALUES("427", "woocommerce_db_version", "10.3.5", "auto");
INSERT INTO `wp_options` VALUES("428", "woocommerce_store_id", "95e599c4-30f0-48dc-bf8e-c1cb2374f7d5", "auto");
INSERT INTO `wp_options` VALUES("429", "woocommerce_admin_install_timestamp", "1763990392", "auto");
INSERT INTO `wp_options` VALUES("430", "woocommerce_inbox_variant_assignment", "5", "auto");
INSERT INTO `wp_options` VALUES("431", "woocommerce_remote_variant_assignment", "33", "auto");
INSERT INTO `wp_options` VALUES("432", "woocommerce_attribute_lookup_enabled", "no", "auto");
INSERT INTO `wp_options` VALUES("433", "woocommerce_admin_notices", "a:2:{i:0;s:20:\"no_secure_connection\";i:1;s:14:\"template_files\";}", "auto");
INSERT INTO `wp_options` VALUES("434", "twwp_stripe_account", "O:8:\"stdClass\":5:{s:3:\"msg\";s:7:\"Success\";s:6:\"status\";i:200;s:4:\"data\";a:0:{}s:3:\"err\";N;s:22:\"twwp_last_updated_date\";i:1763990393;}", "auto");
INSERT INTO `wp_options` VALUES("435", "twwp_stripe_keys", "O:8:\"stdClass\":2:{s:4:\"test\";s:107:\"pk_test_51O9OFOD2fAmjePnCJaW4e2rnM7IB9Z9abQOASa8u017URP9nYxeU6RoYykHK5GtSGqHJGZawEwQeywyLY8TLu1Vn00VzgbnLzJ\";s:4:\"live\";s:107:\"pk_live_51O9OFOD2fAmjePnCvS6Qe7mr7qkXq2f0AYzmUcVmE70R2SUEbOz7ta4C4Q5LVId5BP2QIj2YZD1sxxLPQpraIkY800rIRUJA2S\";}", "auto");
INSERT INTO `wp_options` VALUES("436", "woocommerce_excluded_report_order_statuses", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("437", "woocommerce_onboarding_profile", "a:1:{s:7:\"skipped\";b:1;}", "auto");
INSERT INTO `wp_options` VALUES("438", "woocommerce_pre_install_woocommerce_payments_promotion_settings", "a:1:{s:12:\"is_dismissed\";s:3:\"yes\";}", "auto");
INSERT INTO `wp_options` VALUES("439", "woocommerce_setting_payments_recommendations_hidden", "yes", "auto");
INSERT INTO `wp_options` VALUES("440", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"c0tTXmaJa50oBEdm7RloRsDqVMkpJ5vi\";}", "on");
INSERT INTO `wp_options` VALUES("441", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("442", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("443", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("444", "widget_woocommerce_price_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("445", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("446", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("447", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("448", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("449", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("450", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("451", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("452", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("453", "widget_wc_brands_brand_description", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("454", "widget_woocommerce_brand_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("455", "widget_wc_brands_brand_thumbnails", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("456", "jetpack_options", "a:1:{s:14:\"last_heartbeat\";i:1763990394;}", "auto");
INSERT INTO `wp_options` VALUES("457", "woocommerce_checkout_phone_field", "optional", "auto");
INSERT INTO `wp_options` VALUES("458", "woocommerce_checkout_company_field", "hidden", "auto");
INSERT INTO `wp_options` VALUES("459", "woocommerce_checkout_address_2_field", "optional", "auto");
INSERT INTO `wp_options` VALUES("463", "action_scheduler_migration_status", "complete", "auto");
INSERT INTO `wp_options` VALUES("464", "as_has_wp_comment_logs", "no", "on");
INSERT INTO `wp_options` VALUES("466", "theme_mods_wvc-theme", "a:2:{s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;}", "auto");
INSERT INTO `wp_options` VALUES("467", "tenweb_access_token", "eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJhdWQiOiIyMzQ3OTAxIiwianRpIjoiYjUyYTg4YTQ3NjA2ODA3ZTE0NDEwMzQyNDExMTVhNDVmZTczNTUxNmEyMzNlYjliNDk2NzA0YTRiZGE3OWEwYzJiNzFmNjk4ZDFlNTIxODYiLCJpYXQiOjE3NjM5OTA2NzkuNDY1MzEsIm5iZiI6MTc2Mzk5MDY3OS40NjUzMTEsImV4cCI6MTc5NTUyNjY3OS40NTYyNjgsInN1YiI6IjMyNTA4MDkiLCJzY29wZXMiOlsibWFuYWdlciJdfQ.PU0-s9nzYylkaFdVDQedoLi0aUDUmeV_GKFA4z3z7bJdmmR0krBfdoLtugx5pxvtFPiV7T5_-NGCM4BBFmq72JlIJqoMa-f1YPznnny_S4iqHiQjR8vCgB31ArkM7_FmSlgA2U5MPDMw6EZrM8xPZrB1mMkkIW4jiA5JVeceWIqw0g0NOvKyz6heHRypIYWWm9EFbfmWl8KCHJcxv8CjjjqFykM2ZI_MOSAMRwch_Hh1Ip7QfBxTo5OnTtxFlZRrTEf1jZZ81i8azNB49t1IURr3j_MDSs4ChV6BDueoUZOFJtyy3SrtrfmtFuzPBWAsaqdcUX1I6ltY7aCz9Wbs3b9oedn5SuTaMVd6PGtCUPUU0BWhRrFQOziqT8INGD5mpDqryt8GC9Xf9UPD4Ov27wGUyfjTBkxczMob7EaeUaCuv3F0TaXm_xPeFlFb6XP6Mv1YfGcuACpJFjkA-Z3gaYSzan4KXjByEa3SaRXcu0eaExr0AXF_2jlwBZ4rCwTjZhGWhIaYIf5iJiclyp0j7oEwexa5IWTxRWzbGpyhYeu-tsWUpCl9QrUA9D4zNQXkNYJwMLd3Bb4ZHCaMbEOMupQbfOqplU_2Pa27F2Ad6ZenyiDBsWhhIijXXrCuLnsldzEDeQt0SMYElFqwTJsQMbNE5eYonoLpZo0akQK-9Vc", "auto");
INSERT INTO `wp_options` VALUES("468", "tenweb_refresh_token", "def50200b3c5c59ce473b89e7cd400be55b0f7a99684d784efa4af843b5bd2bfbe06a7af92eeb7ca9cf0dbfc1568795e70202ec1001393436900145e12628c3c364bf74de8d3926a3aee24c951f5fc73745458a057ecaf87d49f7556fad6630bf04a58a996a15bb16531a47a396d2f8a1ebd9023777c815727b5a771a2abb36b894fbdd718a162759ad51d1d53caeb915c5f54d092e57909d4d21cbc9fd6e05b525602b6c4ffd4bfa08add8cb2502e6d6a66a67ca95daa86972ea125d698dd1bebff8b717f27be9e830a08a7d845f2b1fafcdb557865313b0044bbee16d2e48521388fd5c400e3b14daf3fcd646ebdb68379028e99e42e3d4111fe32acc9083339647c24d600e8fee20e541b188fd5c8d4418d2da08b3bd255eb8879eb427876700945484be45ea00fb28c81a1b4af42b8ade935fc60992cb40324966ca669c2650d8d6570f30d6842b2f9db40b223dc48996f0edef0385eec617165f0ef663649a0b58f6616bd60a8c74bd76ce6ee50a9049e73c0095f66", "auto");
INSERT INTO `wp_options` VALUES("469", "recently_activated", "a:4:{s:49:\"tenweb-speed-optimizer/tenweb_speed_optimizer.php\";i:1763990678;s:23:\"elementor/elementor.php\";i:1763990678;s:27:\"woocommerce/woocommerce.php\";i:1763990677;s:33:\"tenweb-builder/tenweb-builder.php\";i:1763990677;}", "off");
INSERT INTO `wp_options` VALUES("470", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}", "off");
INSERT INTO `wp_options` VALUES("471", "elementor_remote_info_feed_data", "a:3:{i:0;a:5:{s:5:\"title\";s:76:\"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More\";s:7:\"excerpt\";s:250:\"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.\";s:7:\"created\";i:1759243152;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:138:\"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:67:\"What Is an MCP? The AI Breakthrough Web Creators Shouldn’t Ignore\";s:7:\"excerpt\";s:143:\"Discover how Model Context Protocol (MCP) is shaping AI-tool interaction and redefining how pro web creators build, manage, and scale websites.\";s:7:\"created\";i:1754310811;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:130:\"https://elementor.com/blog/mcp-explained-for-web-creators/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "off");
INSERT INTO `wp_options` VALUES("472", "tenweb_is_available", "1", "auto");
INSERT INTO `wp_options` VALUES("473", "tewneb_user_Error", "2", "off");
INSERT INTO `wp_options` VALUES("474", "auto_update_themes", "a:1:{i:0;s:9:\"wvc-theme\";}", "auto");
INSERT INTO `wp_options` VALUES("475", "wvc_theme_auto_update_set", "1", "auto");
INSERT INTO `wp_options` VALUES("481", "finished_updating_comment_type", "1", "auto");
INSERT INTO `wp_options` VALUES("485", "category_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("486", "wvc_start_woo_pages_removal", "1", "auto");
INSERT INTO `wp_options` VALUES("487", "wvc_woo_reset", "1", "auto");
INSERT INTO `wp_options` VALUES("488", "wvc_purge_cache_called", "1", "auto");
INSERT INTO `wp_options` VALUES("489", "wvc_purge_cache_has_registered_actions", "1", "auto");
INSERT INTO `wp_options` VALUES("490", "wvc_import_result_1763990930", "a:7:{s:7:\"success\";b:1;s:7:\"message\";s:29:\"Import completed successfully\";s:5:\"pages\";a:3:{s:7:\"updated\";i:5;s:6:\"failed\";i:0;s:5:\"pages\";a:5:{i:0;a:5:{s:10:\"page_title\";s:4:\"Blog\";s:14:\"component_name\";s:8:\"BlogPage\";s:6:\"status\";s:7:\"updated\";s:7:\"message\";s:0:\"\";s:2:\"id\";i:57;}i:1;a:5:{s:10:\"page_title\";s:5:\"About\";s:14:\"component_name\";s:9:\"AboutPage\";s:6:\"status\";s:7:\"updated\";s:7:\"message\";s:0:\"\";s:2:\"id\";i:60;}i:2;a:5:{s:10:\"page_title\";s:18:\"Guides   Downloads\";s:14:\"component_name\";s:19:\"GuidesDownloadsPage\";s:6:\"status\";s:7:\"updated\";s:7:\"message\";s:0:\"\";s:2:\"id\";i:63;}i:3;a:5:{s:10:\"page_title\";s:7:\"Contact\";s:14:\"component_name\";s:11:\"ContactPage\";s:6:\"status\";s:7:\"updated\";s:7:\"message\";s:0:\"\";s:2:\"id\";i:65;}i:4;a:5:{s:10:\"page_title\";s:4:\"Home\";s:14:\"component_name\";s:8:\"HomePage\";s:6:\"status\";s:7:\"updated\";s:7:\"message\";s:0:\"\";s:2:\"id\";i:68;}}}s:5:\"menus\";a:0:{}s:6:\"images\";a:4:{s:7:\"created\";i:19;s:7:\"updated\";i:0;s:6:\"failed\";i:0;s:6:\"images\";a:19:{i:0;a:3:{s:6:\"status\";s:7:\"success\";s:13:\"attachment_id\";i:81;s:14:\"attachment_url\";s:90:\"https://concise-goshawk.10web.cloud/wp-content/uploads/2025/11/austrian_roads_pattern.webp\";}i:1;a:3:{s:6:\"status\";s:7:\"success\";s:13:\"attachment_id\";i:82;s:14:\"attachment_url\";s:81:\"https://concise-goshawk.10web.cloud/wp-content/uploads/2025/11/asfiroads_logo.png\";}i:2;a:3:{s:6:\"status\";s:7:\"success\";s:13:\"attachment_id\";i:83;s:14:\"attachment_url\";s:89:\"https://concise-goshawk.10web.cloud/wp-content/uploads/2025/11/austrian_highway_dawn.webp\";}i:3;a:3:{s:6:\"status\";s:7:\"success\";s:13:\"attachment_id\";i:84;s:14:\"attachment_url\";s:94:\"https://concise-goshawk.10web.cloud/wp-content/uploads/2025/11/austrian_highway_landscape.webp\";}i:4;a:3:{s:6:\"status\";s:7:\"success\";s:13:\"attachment_id\";i:85;s:14:\"attachment_url\";s:95:\"https://concise-goshawk.10web.cloud/wp-content/uploads/2025/11/austrian_highway_silhouette.webp\";}i:5;a:3:{s:6:\"status\";s:7:\"success\";s:13:\"attachment_id\";i:86;s:14:\"attachment_url\";s:91:\"https://concise-goshawk.10web.cloud/wp-content/uploads/2025/11/austrian_vignette_types.webp\";}i:6;a:3:{s:6:\"status\";s:7:\"success\";s:13:\"attachment_id\";i:87;s:14:\"attachment_url\";s:102:\"https://concise-goshawk.10web.cloud/wp-content/uploads/2025/11/austria_toll_road_map_illustration.webp\";}i:7;a:3:{s:6:\"status\";s:7:\"success\";s:13:\"attachment_id\";i:88;s:14:\"attachment_url\";s:94:\"https://concise-goshawk.10web.cloud/wp-content/uploads/2025/11/toll_regulations_checklist.webp\";}i:8;a:3:{s:6:\"status\";s:7:\"success\";s:13:\"attachment_id\";i:89;s:14:\"attachment_url\";s:93:\"https://concise-goshawk.10web.cloud/wp-content/uploads/2025/11/toll_road_payment_austria.webp\";}i:9;a:3:{s:6:\"status\";s:7:\"success\";s:13:\"attachment_id\";i:90;s:14:\"attachment_url\";s:95:\"https://concise-goshawk.10web.cloud/wp-content/uploads/2025/11/vignette_installation_guide.webp\";}i:10;a:3:{s:6:\"status\";s:7:\"success\";s:13:\"attachment_id\";i:91;s:14:\"attachment_url\";s:93:\"https://concise-goshawk.10web.cloud/wp-content/uploads/2025/11/digital_vignette_tutorial.webp\";}i:11;a:3:{s:6:\"status\";s:7:\"success\";s:13:\"attachment_id\";i:92;s:14:\"attachment_url\";s:97:\"https://concise-goshawk.10web.cloud/wp-content/uploads/2025/11/austrian_highways_aerial_view.webp\";}i:12;a:3:{s:6:\"status\";s:7:\"success\";s:13:\"attachment_id\";i:93;s:14:\"attachment_url\";s:92:\"https://concise-goshawk.10web.cloud/wp-content/uploads/2025/11/team_lisa_weber_portrait.webp\";}i:13;a:3:{s:6:\"status\";s:7:\"success\";s:13:\"attachment_id\";i:94;s:14:\"attachment_url\";s:98:\"https://concise-goshawk.10web.cloud/wp-content/uploads/2025/11/team_thomas_schneider_portrait.webp\";}i:14;a:3:{s:6:\"status\";s:7:\"success\";s:13:\"attachment_id\";i:95;s:14:\"attachment_url\";s:94:\"https://concise-goshawk.10web.cloud/wp-content/uploads/2025/11/team_anna_mueller_portrait.webp\";}i:15;a:3:{s:6:\"status\";s:7:\"success\";s:13:\"attachment_id\";i:96;s:14:\"attachment_url\";s:91:\"https://concise-goshawk.10web.cloud/wp-content/uploads/2025/11/austrian_vignette_guide.webp\";}i:16;a:3:{s:6:\"status\";s:7:\"success\";s:13:\"attachment_id\";i:97;s:14:\"attachment_url\";s:89:\"https://concise-goshawk.10web.cloud/wp-content/uploads/2025/11/toll_road_map_austria.webp\";}i:17;a:3:{s:6:\"status\";s:7:\"success\";s:13:\"attachment_id\";i:98;s:14:\"attachment_url\";s:94:\"https://concise-goshawk.10web.cloud/wp-content/uploads/2025/11/austrian_highway_toll_road.webp\";}i:18;a:3:{s:6:\"status\";s:7:\"success\";s:13:\"attachment_id\";i:99;s:14:\"attachment_url\";s:89:\"https://concise-goshawk.10web.cloud/wp-content/uploads/2025/11/austria_toll_zone_map.webp\";}}}s:16:\"templates_result\";a:4:{s:7:\"created\";i:3;s:7:\"updated\";i:0;s:6:\"failed\";i:0;s:9:\"templates\";a:3:{i:0;a:5:{s:14:\"template_title\";s:18:\"SinglePostTemplate\";s:12:\"template_key\";s:18:\"SinglePostTemplate\";s:6:\"status\";s:7:\"created\";s:7:\"message\";s:0:\"\";s:2:\"id\";i:105;}i:1;a:5:{s:14:\"template_title\";s:6:\"Footer\";s:12:\"template_key\";s:6:\"Footer\";s:6:\"status\";s:7:\"created\";s:7:\"message\";s:0:\"\";s:2:\"id\";i:106;}i:2;a:5:{s:14:\"template_title\";s:6:\"Header\";s:12:\"template_key\";s:6:\"Header\";s:6:\"status\";s:7:\"created\";s:7:\"message\";s:0:\"\";s:2:\"id\";i:107;}}}s:10:\"stylesheet\";a:4:{s:7:\"created\";i:0;s:7:\"updated\";i:0;s:6:\"failed\";i:1;s:7:\"message\";s:25:\"Stylesheet file not found\";}}", "auto");
INSERT INTO `wp_options` VALUES("491", "tenweb_active_products_list", "a:5:{i:0;s:25:\"duplicator/duplicator.php\";i:1;s:36:\"oneclickweb/text-replacer-plugin.php\";i:2;s:39:\"wp-file-manager/file_folder_manager.php\";i:3;s:45:\"wp-plugin-management/wp-plugin-management.php\";i:4;s:9:\"wvc-theme\";}", "auto");
INSERT INTO `wp_options` VALUES("492", "can_compress_scripts", "1", "on");
INSERT INTO `wp_options` VALUES("493", "fm_key", "4QePNq26jmdf8Ttwc7CAxhO3E", "auto");
INSERT INTO `wp_options` VALUES("495", "duplicator_version_plugin", "1.5.13", "auto");
INSERT INTO `wp_options` VALUES("497", "duplicator_install_info", "a:3:{s:7:\"version\";s:6:\"1.5.13\";s:4:\"time\";i:1763991111;s:10:\"updateTime\";i:1763991111;}", "off");
INSERT INTO `wp_options` VALUES("498", "duplicator_uninstall_package", "1", "auto");
INSERT INTO `wp_options` VALUES("499", "duplicator_uninstall_settings", "1", "auto");
INSERT INTO `wp_options` VALUES("500", "duplicator_settings", "a:20:{s:7:\"version\";s:6:\"1.5.13\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:1;s:14:\"usage_tracking\";b:0;i:0;b:0;}", "auto");
INSERT INTO `wp_options` VALUES("501", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"o&Dpx.KUmEprrPFI6IOahLDAi2YyX=k=j,62J7pqzdcn\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 0,\n    \"buildLastDate\": 0,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 194.19999999999999,\n    \"siteNumFiles\": 8254,\n    \"siteDbSizeMB\": 4.6100000000000003,\n    \"siteDbNumTables\": 49\n}", "auto");
INSERT INTO `wp_options` VALUES("502", "duplicator_notifications", "a:4:{s:6:\"update\";i:1763991111;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("503", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-11-24 13:32:15\";s:7:\"Version\";s:6:\"1.5.13\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.34\";s:10:\"VersionPHP\";s:6:\"8.3.23\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:20:\"20251124_asfiroadsde\";s:4:\"Hash\";s:35:\"4d66dde32c265f808922_20251124133215\";s:8:\"NameHash\";s:56:\"20251124_asfiroadsde_4d66dde32c265f808922_20251124133215\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:66:\"20251124_asfiroadsde_4d66dde32c265f808922_20251124133215_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:24:\"/home/wplive/web/wp-live\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1259;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:6995;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-11-24 13:32:15\";s:7:\"Version\";s:6:\"1.5.13\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.34\";s:10:\"VersionPHP\";s:6:\"8.3.23\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:20:\"20251124_asfiroadsde\";s:4:\"Hash\";s:35:\"4d66dde32c265f808922_20251124133215\";s:8:\"NameHash\";s:56:\"20251124_asfiroadsde_4d66dde32c265f808922_20251124133215\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:38:\"/home/wplive/web/wp-live/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:33:\"/home/wplive/web/wp-live/wp-admin\";i:1;s:36:\"/home/wplive/web/wp-live/wp-includes\";i:2;s:45:\"/home/wplive/web/wp-live/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:24:\"/home/wplive/web/wp-live\";i:1;s:24:\"/home/wplive/web/wp-live\";i:2;s:35:\"/home/wplive/web/wp-live/wp-content\";i:3;s:43:\"/home/wplive/web/wp-live/wp-content/uploads\";i:4;s:43:\"/home/wplive/web/wp-live/wp-content/plugins\";i:5;s:46:\"/home/wplive/web/wp-live/wp-content/mu-plugins\";i:6;s:42:\"/home/wplive/web/wp-live/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:56:\"/home/wplive/web/wp-live/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "auto");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("2", "3", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("3", "4", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("4", "4", "_elementor_template_type", "kit");
INSERT INTO `wp_postmeta` VALUES("5", "5", "elementor_font_face", "@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: normal;\n                                      font-weight: normal;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_font.woff) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: normal;\n                                      font-weight: normal;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_font.woff2) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: normal;\n                                      font-weight: normal;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_font.ttf) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: normal;\n                                      font-weight: normal;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_font.eot) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: normal;\n                                      font-weight: normal;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_font.otf) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: italic;\n                                      font-weight: normal;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_italic_font.woff) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: italic;\n                                      font-weight: normal;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_italic_font.woff2) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: italic;\n                                      font-weight: normal;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_italic_font.ttf) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: italic;\n                                      font-weight: normal;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_italic_font.eot) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: italic;\n                                      font-weight: normal;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_italic_font.otf) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: normal;\n                                      font-weight: bold;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_font.woff) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: normal;\n                                      font-weight: bold;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_font.woff2) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: normal;\n                                      font-weight: bold;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_font.ttf) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: normal;\n                                      font-weight: bold;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_font.eot) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: normal;\n                                      font-weight: bold;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_font.otf) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: italic;\n                                      font-weight: bold;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_Italic_font.woff) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: italic;\n                                      font-weight: bold;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_Italic_font.woff2) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: italic;\n                                      font-weight: bold;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_Italic_font.ttf) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: italic;\n                                      font-weight: bold;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_Italic_font.eot) format(\'truetype\');\n                                    }@font-face {\n                                      font-family: \'Futura\';\n                                      font-style: italic;\n                                      font-weight: bold;\n                                      font-display: auto;\n                                      src: url(https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_Italic_font.otf) format(\'truetype\');\n                                    }");
INSERT INTO `wp_postmeta` VALUES("6", "5", "elementor_font_files", "a:4:{i:0;a:8:{s:11:\"font_weight\";s:6:\"normal\";s:10:\"font_style\";s:6:\"normal\";s:4:\"woff\";a:2:{s:2:\"id\";i:6;s:3:\"url\";s:113:\"https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_font.woff\";}s:5:\"woff2\";a:2:{s:2:\"id\";i:7;s:3:\"url\";s:114:\"https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_font.woff2\";}s:3:\"ttf\";a:2:{s:2:\"id\";i:8;s:3:\"url\";s:112:\"https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_font.ttf\";}s:3:\"svg\";a:2:{s:2:\"id\";s:0:\"\";s:3:\"url\";s:0:\"\";}s:3:\"eot\";a:2:{s:2:\"id\";i:9;s:3:\"url\";s:112:\"https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_font.eot\";}s:3:\"otf\";a:2:{s:2:\"id\";i:10;s:3:\"url\";s:112:\"https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_font.otf\";}}i:1;a:8:{s:11:\"font_weight\";s:6:\"normal\";s:10:\"font_style\";s:6:\"italic\";s:4:\"woff\";a:2:{s:2:\"id\";i:11;s:3:\"url\";s:120:\"https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_italic_font.woff\";}s:5:\"woff2\";a:2:{s:2:\"id\";i:12;s:3:\"url\";s:121:\"https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_italic_font.woff2\";}s:3:\"ttf\";a:2:{s:2:\"id\";i:13;s:3:\"url\";s:119:\"https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_italic_font.ttf\";}s:3:\"svg\";a:2:{s:2:\"id\";s:0:\"\";s:3:\"url\";s:0:\"\";}s:3:\"eot\";a:2:{s:2:\"id\";i:14;s:3:\"url\";s:119:\"https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_italic_font.eot\";}s:3:\"otf\";a:2:{s:2:\"id\";i:15;s:3:\"url\";s:119:\"https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/futura_medium_italic_font.otf\";}}i:2;a:8:{s:11:\"font_weight\";s:4:\"bold\";s:10:\"font_style\";s:6:\"normal\";s:4:\"woff\";a:2:{s:2:\"id\";i:16;s:3:\"url\";s:111:\"https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_font.woff\";}s:5:\"woff2\";a:2:{s:2:\"id\";i:17;s:3:\"url\";s:112:\"https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_font.woff2\";}s:3:\"ttf\";a:2:{s:2:\"id\";i:18;s:3:\"url\";s:110:\"https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_font.ttf\";}s:3:\"svg\";a:2:{s:2:\"id\";s:0:\"\";s:3:\"url\";s:0:\"\";}s:3:\"eot\";a:2:{s:2:\"id\";i:19;s:3:\"url\";s:110:\"https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_font.eot\";}s:3:\"otf\";a:2:{s:2:\"id\";i:20;s:3:\"url\";s:110:\"https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_font.otf\";}}i:3;a:8:{s:11:\"font_weight\";s:4:\"bold\";s:10:\"font_style\";s:6:\"italic\";s:4:\"woff\";a:2:{s:2:\"id\";i:21;s:3:\"url\";s:118:\"https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_Italic_font.woff\";}s:5:\"woff2\";a:2:{s:2:\"id\";i:22;s:3:\"url\";s:119:\"https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_Italic_font.woff2\";}s:3:\"ttf\";a:2:{s:2:\"id\";i:23;s:3:\"url\";s:117:\"https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_Italic_font.ttf\";}s:3:\"svg\";a:2:{s:2:\"id\";s:0:\"\";s:3:\"url\";s:0:\"\";}s:3:\"eot\";a:2:{s:2:\"id\";i:24;s:3:\"url\";s:117:\"https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_Italic_font.eot\";}s:3:\"otf\";a:2:{s:2:\"id\";i:25;s:3:\"url\";s:117:\"https://concise-goshawk.10web.cloud/wp-content/plugins/tenweb-builder/assets/fonts/Futura/Futura_Bold_Italic_font.otf\";}}}");
INSERT INTO `wp_postmeta` VALUES("7", "26", "_wp_attached_file", "2025/11/abstract-bg-cta2.webp");
INSERT INTO `wp_postmeta` VALUES("8", "26", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:29:\"2025/11/abstract-bg-cta2.webp\";s:8:\"filesize\";i:266274;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:29:\"abstract-bg-cta2-300x200.webp\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:12950;}s:5:\"large\";a:5:{s:4:\"file\";s:30:\"abstract-bg-cta2-1024x683.webp\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:61618;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:29:\"abstract-bg-cta2-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:7620;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:29:\"abstract-bg-cta2-768x512.webp\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:41804;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:31:\"abstract-bg-cta2-1536x1024.webp\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:104578;}s:23:\"tenweb_optimizer_mobile\";a:5:{s:4:\"file\";s:29:\"abstract-bg-cta2-600x400.webp\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:30142;}s:23:\"tenweb_optimizer_tablet\";a:5:{s:4:\"file\";s:29:\"abstract-bg-cta2-768x512.webp\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:41804;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("9", "26", "_twbb_image_hash", "1d6793bd2bd5e0cc1797edfdced2154bc42bae22");
INSERT INTO `wp_postmeta` VALUES("10", "26", "_twbb_section_attachment", "1");
INSERT INTO `wp_postmeta` VALUES("11", "26", "_elementor_source_image_hash", "b3cf852d4e805e3ac430edb581c5a30e3f158c41");
INSERT INTO `wp_postmeta` VALUES("12", "27", "_wp_attached_file", "2025/11/abstract-bg-hero.webp");
INSERT INTO `wp_postmeta` VALUES("13", "27", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:29:\"2025/11/abstract-bg-hero.webp\";s:8:\"filesize\";i:360518;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:29:\"abstract-bg-hero-300x200.webp\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:13906;}s:5:\"large\";a:5:{s:4:\"file\";s:30:\"abstract-bg-hero-1024x683.webp\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:82980;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:29:\"abstract-bg-hero-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:7846;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:29:\"abstract-bg-hero-768x512.webp\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:52004;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:31:\"abstract-bg-hero-1536x1024.webp\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:147748;}s:23:\"tenweb_optimizer_mobile\";a:5:{s:4:\"file\";s:29:\"abstract-bg-hero-600x400.webp\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:35812;}s:23:\"tenweb_optimizer_tablet\";a:5:{s:4:\"file\";s:29:\"abstract-bg-hero-768x512.webp\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:52004;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("14", "27", "_twbb_image_hash", "43296830c3fc2a8802811e8f8a62701c5364c148");
INSERT INTO `wp_postmeta` VALUES("15", "27", "_twbb_section_attachment", "1");
INSERT INTO `wp_postmeta` VALUES("16", "27", "_elementor_source_image_hash", "fa0f66c69c71e36727670529ab7210925128e1cf");
INSERT INTO `wp_postmeta` VALUES("17", "28", "_wp_attached_file", "2025/11/abstract-gallery7.webp");
INSERT INTO `wp_postmeta` VALUES("18", "28", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:2560;s:4:\"file\";s:30:\"2025/11/abstract-gallery7.webp\";s:8:\"filesize\";i:151958;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"abstract-gallery7-225x300.webp\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:12546;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"abstract-gallery7-768x1024.webp\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:39982;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"abstract-gallery7-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:9656;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:31:\"abstract-gallery7-768x1024.webp\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:39982;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:32:\"abstract-gallery7-1152x1536.webp\";s:5:\"width\";i:1152;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:66644;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:32:\"abstract-gallery7-1536x2048.webp\";s:5:\"width\";i:1536;s:6:\"height\";i:2048;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:94226;}s:23:\"tenweb_optimizer_mobile\";a:5:{s:4:\"file\";s:30:\"abstract-gallery7-450x600.webp\";s:5:\"width\";i:450;s:6:\"height\";i:600;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:22608;}s:23:\"tenweb_optimizer_tablet\";a:5:{s:4:\"file\";s:31:\"abstract-gallery7-768x1024.webp\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:39982;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("19", "28", "_twbb_image_hash", "81f1900113a3df76ff284bc291be51e97a1acccb");
INSERT INTO `wp_postmeta` VALUES("20", "28", "_twbb_section_attachment", "1");
INSERT INTO `wp_postmeta` VALUES("21", "28", "_elementor_source_image_hash", "37b311985b7a5fc3ed3286f564692085e285f090");
INSERT INTO `wp_postmeta` VALUES("22", "29", "_wp_attached_file", "2025/11/abstract-gallery6.webp");
INSERT INTO `wp_postmeta` VALUES("23", "29", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:30:\"2025/11/abstract-gallery6.webp\";s:8:\"filesize\";i:100994;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"abstract-gallery6-300x200.webp\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:12758;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"abstract-gallery6-1024x683.webp\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:39616;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"abstract-gallery6-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:9904;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"abstract-gallery6-768x512.webp\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:28204;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:32:\"abstract-gallery6-1536x1024.webp\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:62766;}s:23:\"tenweb_optimizer_mobile\";a:5:{s:4:\"file\";s:30:\"abstract-gallery6-600x400.webp\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:21912;}s:23:\"tenweb_optimizer_tablet\";a:5:{s:4:\"file\";s:30:\"abstract-gallery6-768x512.webp\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:28204;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("24", "29", "_twbb_image_hash", "06d2d7ccde8ebddfc481bd8bd717f01c311578e5");
INSERT INTO `wp_postmeta` VALUES("25", "29", "_twbb_section_attachment", "1");
INSERT INTO `wp_postmeta` VALUES("26", "29", "_elementor_source_image_hash", "8ea95ee350ba9ed42fd98384bf00748dc7e9fad4");
INSERT INTO `wp_postmeta` VALUES("27", "30", "_wp_attached_file", "2025/11/abstract-gallery8.webp");
INSERT INTO `wp_postmeta` VALUES("28", "30", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1707;s:6:\"height\";i:2560;s:4:\"file\";s:30:\"2025/11/abstract-gallery8.webp\";s:8:\"filesize\";i:128404;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"abstract-gallery8-200x300.webp\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:10708;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"abstract-gallery8-683x1024.webp\";s:5:\"width\";i:683;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:28344;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"abstract-gallery8-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:8684;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:31:\"abstract-gallery8-768x1152.webp\";s:5:\"width\";i:768;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:31998;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:32:\"abstract-gallery8-1024x1536.webp\";s:5:\"width\";i:1024;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:44832;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:32:\"abstract-gallery8-1366x2048.webp\";s:5:\"width\";i:1366;s:6:\"height\";i:2048;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:62824;}s:23:\"tenweb_optimizer_mobile\";a:5:{s:4:\"file\";s:30:\"abstract-gallery8-400x600.webp\";s:5:\"width\";i:400;s:6:\"height\";i:600;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:16930;}s:23:\"tenweb_optimizer_tablet\";a:5:{s:4:\"file\";s:31:\"abstract-gallery8-683x1024.webp\";s:5:\"width\";i:683;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:28344;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("29", "30", "_twbb_image_hash", "f42a7c4d76820137cc1916d0a2a758250af608a7");
INSERT INTO `wp_postmeta` VALUES("30", "30", "_twbb_section_attachment", "1");
INSERT INTO `wp_postmeta` VALUES("31", "30", "_elementor_source_image_hash", "5fe7ff884f10059457dd5115a7e32dab279d3312");
INSERT INTO `wp_postmeta` VALUES("32", "31", "_wp_attached_file", "2025/11/abstract-gallery9.webp");
INSERT INTO `wp_postmeta` VALUES("33", "31", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1919;s:6:\"height\";i:2560;s:4:\"file\";s:30:\"2025/11/abstract-gallery9.webp\";s:8:\"filesize\";i:228290;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"abstract-gallery9-225x300.webp\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:10396;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"abstract-gallery9-768x1024.webp\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:24166;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"abstract-gallery9-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:8810;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:31:\"abstract-gallery9-768x1025.webp\";s:5:\"width\";i:768;s:6:\"height\";i:1025;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:24320;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:32:\"abstract-gallery9-1151x1536.webp\";s:5:\"width\";i:1151;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:40128;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:32:\"abstract-gallery9-1535x2048.webp\";s:5:\"width\";i:1535;s:6:\"height\";i:2048;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:64138;}s:23:\"tenweb_optimizer_mobile\";a:5:{s:4:\"file\";s:30:\"abstract-gallery9-450x600.webp\";s:5:\"width\";i:450;s:6:\"height\";i:600;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:15278;}s:23:\"tenweb_optimizer_tablet\";a:5:{s:4:\"file\";s:31:\"abstract-gallery9-768x1024.webp\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:24166;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("34", "31", "_twbb_image_hash", "4e9bc186df4f411d48efbd6f5e828f96fef91cc3");
INSERT INTO `wp_postmeta` VALUES("35", "31", "_twbb_section_attachment", "1");
INSERT INTO `wp_postmeta` VALUES("36", "31", "_elementor_source_image_hash", "6ab38fa16abf3e344cbbec254916b5cc2acff095");
INSERT INTO `wp_postmeta` VALUES("37", "32", "_wp_attached_file", "2025/11/abstract-gallery10.webp");
INSERT INTO `wp_postmeta` VALUES("38", "32", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1707;s:6:\"height\";i:2560;s:4:\"file\";s:31:\"2025/11/abstract-gallery10.webp\";s:8:\"filesize\";i:185118;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"abstract-gallery10-200x300.webp\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:8182;}s:5:\"large\";a:5:{s:4:\"file\";s:32:\"abstract-gallery10-683x1024.webp\";s:5:\"width\";i:683;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:21276;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"abstract-gallery10-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:7492;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:32:\"abstract-gallery10-768x1152.webp\";s:5:\"width\";i:768;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:26586;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:33:\"abstract-gallery10-1024x1536.webp\";s:5:\"width\";i:1024;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:47162;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:33:\"abstract-gallery10-1366x2048.webp\";s:5:\"width\";i:1366;s:6:\"height\";i:2048;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:81094;}s:23:\"tenweb_optimizer_mobile\";a:5:{s:4:\"file\";s:31:\"abstract-gallery10-400x600.webp\";s:5:\"width\";i:400;s:6:\"height\";i:600;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:10736;}s:23:\"tenweb_optimizer_tablet\";a:5:{s:4:\"file\";s:32:\"abstract-gallery10-683x1024.webp\";s:5:\"width\";i:683;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:21276;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("39", "32", "_twbb_image_hash", "9931b54c8acce371887bb5cbcc6417616a5768c2");
INSERT INTO `wp_postmeta` VALUES("40", "32", "_twbb_section_attachment", "1");
INSERT INTO `wp_postmeta` VALUES("41", "32", "_elementor_source_image_hash", "a099000c27d29849c94de20e0a36c57b66a32bfa");
INSERT INTO `wp_postmeta` VALUES("42", "33", "_wp_attached_file", "2025/11/abstract-gallery.webp");
INSERT INTO `wp_postmeta` VALUES("43", "33", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:1278;s:4:\"file\";s:29:\"2025/11/abstract-gallery.webp\";s:8:\"filesize\";i:159478;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:29:\"abstract-gallery-300x200.webp\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:15350;}s:5:\"large\";a:5:{s:4:\"file\";s:30:\"abstract-gallery-1024x682.webp\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:55776;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:29:\"abstract-gallery-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:10960;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:29:\"abstract-gallery-768x511.webp\";s:5:\"width\";i:768;s:6:\"height\";i:511;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:39394;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:31:\"abstract-gallery-1536x1022.webp\";s:5:\"width\";i:1536;s:6:\"height\";i:1022;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:93360;}s:23:\"tenweb_optimizer_mobile\";a:5:{s:4:\"file\";s:29:\"abstract-gallery-600x399.webp\";s:5:\"width\";i:600;s:6:\"height\";i:399;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:29578;}s:23:\"tenweb_optimizer_tablet\";a:5:{s:4:\"file\";s:29:\"abstract-gallery-768x511.webp\";s:5:\"width\";i:768;s:6:\"height\";i:511;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:39394;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("44", "33", "_twbb_image_hash", "efd0b657db1dd546af5149d18f2f68e005d94c0d");
INSERT INTO `wp_postmeta` VALUES("45", "33", "_twbb_section_attachment", "1");
INSERT INTO `wp_postmeta` VALUES("46", "33", "_elementor_source_image_hash", "98fcb83febb54bde6c893396b1edbba7be3cab7f");
INSERT INTO `wp_postmeta` VALUES("47", "34", "_wp_attached_file", "2025/11/abstract-gallery2.webp");
INSERT INTO `wp_postmeta` VALUES("48", "34", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:30:\"2025/11/abstract-gallery2.webp\";s:8:\"filesize\";i:109366;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"abstract-gallery2-300x200.webp\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:14816;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"abstract-gallery2-1024x683.webp\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:45958;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"abstract-gallery2-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:10856;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"abstract-gallery2-768x512.webp\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:33906;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:32:\"abstract-gallery2-1536x1024.webp\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:69242;}s:23:\"tenweb_optimizer_mobile\";a:5:{s:4:\"file\";s:30:\"abstract-gallery2-600x400.webp\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:26580;}s:23:\"tenweb_optimizer_tablet\";a:5:{s:4:\"file\";s:30:\"abstract-gallery2-768x512.webp\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:33906;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("49", "34", "_twbb_image_hash", "c3c27d1a201da27dc7c478946b0a54a3996cf9a2");
INSERT INTO `wp_postmeta` VALUES("50", "34", "_twbb_section_attachment", "1");
INSERT INTO `wp_postmeta` VALUES("51", "34", "_elementor_source_image_hash", "812907a4a867f5a02490ff175730cddab3768fa8");
INSERT INTO `wp_postmeta` VALUES("52", "35", "_wp_attached_file", "2025/11/abstract-gallery3.webp");
INSERT INTO `wp_postmeta` VALUES("53", "35", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1814;s:6:\"height\";i:2560;s:4:\"file\";s:30:\"2025/11/abstract-gallery3.webp\";s:8:\"filesize\";i:309968;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"abstract-gallery3-213x300.webp\";s:5:\"width\";i:213;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:14586;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"abstract-gallery3-726x1024.webp\";s:5:\"width\";i:726;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:64666;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"abstract-gallery3-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:10508;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:31:\"abstract-gallery3-768x1084.webp\";s:5:\"width\";i:768;s:6:\"height\";i:1084;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:69864;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:32:\"abstract-gallery3-1088x1536.webp\";s:5:\"width\";i:1088;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:107554;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:32:\"abstract-gallery3-1451x2048.webp\";s:5:\"width\";i:1451;s:6:\"height\";i:2048;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:151204;}s:23:\"tenweb_optimizer_mobile\";a:5:{s:4:\"file\";s:30:\"abstract-gallery3-425x600.webp\";s:5:\"width\";i:425;s:6:\"height\";i:600;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:32408;}s:23:\"tenweb_optimizer_tablet\";a:5:{s:4:\"file\";s:31:\"abstract-gallery3-726x1024.webp\";s:5:\"width\";i:726;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:64666;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("54", "35", "_twbb_image_hash", "44c30326475d2bea2199b862c088e9dfb6a544e4");
INSERT INTO `wp_postmeta` VALUES("55", "35", "_twbb_section_attachment", "1");
INSERT INTO `wp_postmeta` VALUES("56", "35", "_elementor_source_image_hash", "894a8e284998f940b0ae02326ec5f09b867e5068");
INSERT INTO `wp_postmeta` VALUES("57", "36", "_wp_attached_file", "2025/11/abstract-gallery4.webp");
INSERT INTO `wp_postmeta` VALUES("58", "36", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:30:\"2025/11/abstract-gallery4.webp\";s:8:\"filesize\";i:192162;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"abstract-gallery4-300x200.webp\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:11052;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"abstract-gallery4-1024x683.webp\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:52894;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"abstract-gallery4-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:8872;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"abstract-gallery4-768x512.webp\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:33274;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:32:\"abstract-gallery4-1536x1024.webp\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:101994;}s:23:\"tenweb_optimizer_mobile\";a:5:{s:4:\"file\";s:30:\"abstract-gallery4-600x400.webp\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:22896;}s:23:\"tenweb_optimizer_tablet\";a:5:{s:4:\"file\";s:30:\"abstract-gallery4-768x512.webp\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:33274;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("59", "36", "_twbb_image_hash", "79cdcdd2d889fcabb3912d5c32c08856642d0fb3");
INSERT INTO `wp_postmeta` VALUES("60", "36", "_twbb_section_attachment", "1");
INSERT INTO `wp_postmeta` VALUES("61", "36", "_elementor_source_image_hash", "5b6191b1929c6c2d1b26d1f2d3a5e5b3c633dce7");
INSERT INTO `wp_postmeta` VALUES("62", "37", "_wp_attached_file", "2025/11/abstract-gallery11.webp");
INSERT INTO `wp_postmeta` VALUES("63", "37", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:31:\"2025/11/abstract-gallery11.webp\";s:8:\"filesize\";i:44522;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"abstract-gallery11-300x200.webp\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:10258;}s:5:\"large\";a:5:{s:4:\"file\";s:32:\"abstract-gallery11-1024x683.webp\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:22496;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"abstract-gallery11-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:8432;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:31:\"abstract-gallery11-768x512.webp\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:17718;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:33:\"abstract-gallery11-1536x1024.webp\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:32220;}s:23:\"tenweb_optimizer_mobile\";a:5:{s:4:\"file\";s:31:\"abstract-gallery11-600x400.webp\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:14928;}s:23:\"tenweb_optimizer_tablet\";a:5:{s:4:\"file\";s:31:\"abstract-gallery11-768x512.webp\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:17718;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("64", "37", "_twbb_image_hash", "87ca492d6bbdd27629e6f0c92d8f47f9f6e8c3d4");
INSERT INTO `wp_postmeta` VALUES("65", "37", "_twbb_section_attachment", "1");
INSERT INTO `wp_postmeta` VALUES("66", "37", "_elementor_source_image_hash", "4eb73ac63475aeb11ef1f720e6af15521cd0875e");
INSERT INTO `wp_postmeta` VALUES("67", "38", "_wp_attached_file", "2025/11/abstract-gallery12.webp");
INSERT INTO `wp_postmeta` VALUES("68", "38", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:31:\"2025/11/abstract-gallery12.webp\";s:8:\"filesize\";i:158414;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"abstract-gallery12-300x200.webp\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:14188;}s:5:\"large\";a:5:{s:4:\"file\";s:32:\"abstract-gallery12-1024x683.webp\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:56154;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"abstract-gallery12-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:10630;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:31:\"abstract-gallery12-768x512.webp\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:38052;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:33:\"abstract-gallery12-1536x1024.webp\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:93466;}s:23:\"tenweb_optimizer_mobile\";a:5:{s:4:\"file\";s:31:\"abstract-gallery12-600x400.webp\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:27902;}s:23:\"tenweb_optimizer_tablet\";a:5:{s:4:\"file\";s:31:\"abstract-gallery12-768x512.webp\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:38052;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("69", "38", "_twbb_image_hash", "3c3ae574c1a9c73d0ca86bf3d254b2a42575a4ab");
INSERT INTO `wp_postmeta` VALUES("70", "38", "_twbb_section_attachment", "1");
INSERT INTO `wp_postmeta` VALUES("71", "38", "_elementor_source_image_hash", "d7b719d84e95f7e095b37493e6ce76103f44a836");
INSERT INTO `wp_postmeta` VALUES("72", "39", "_wp_attached_file", "2025/11/abstract-gallery5.webp");
INSERT INTO `wp_postmeta` VALUES("73", "39", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:30:\"2025/11/abstract-gallery5.webp\";s:8:\"filesize\";i:74974;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"abstract-gallery5-300x200.webp\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:10228;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"abstract-gallery5-1024x683.webp\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:30600;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"abstract-gallery5-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:8674;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"abstract-gallery5-768x512.webp\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:21628;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:32:\"abstract-gallery5-1536x1024.webp\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:50474;}s:23:\"tenweb_optimizer_mobile\";a:5:{s:4:\"file\";s:30:\"abstract-gallery5-600x400.webp\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:16980;}s:23:\"tenweb_optimizer_tablet\";a:5:{s:4:\"file\";s:30:\"abstract-gallery5-768x512.webp\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:21628;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("74", "39", "_twbb_image_hash", "e5e989cf3f256cdca2ae5d50020a4a39a0a28e81");
INSERT INTO `wp_postmeta` VALUES("75", "39", "_twbb_section_attachment", "1");
INSERT INTO `wp_postmeta` VALUES("76", "39", "_elementor_source_image_hash", "8d15f0b9d67632272afe446a34c0c119581c3bda");
INSERT INTO `wp_postmeta` VALUES("77", "40", "_wp_attached_file", "2025/11/abstract-service7.webp");
INSERT INTO `wp_postmeta` VALUES("78", "40", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:4:\"file\";s:30:\"2025/11/abstract-service7.webp\";s:8:\"filesize\";i:56764;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"abstract-service7-300x300.webp\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:10704;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"abstract-service7-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:4876;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"abstract-service7-768x768.webp\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:31756;}s:23:\"tenweb_optimizer_mobile\";a:5:{s:4:\"file\";s:30:\"abstract-service7-600x600.webp\";s:5:\"width\";i:600;s:6:\"height\";i:600;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:24014;}s:23:\"tenweb_optimizer_tablet\";a:5:{s:4:\"file\";s:30:\"abstract-service7-768x768.webp\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:31756;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("79", "40", "_twbb_image_hash", "c19fc824f7f82b0dd534a183478af3680efba8c9");
INSERT INTO `wp_postmeta` VALUES("80", "40", "_twbb_section_attachment", "1");
INSERT INTO `wp_postmeta` VALUES("81", "40", "_elementor_source_image_hash", "8eb170e9300abe4a1b9e1e5332664673eb44c657");
INSERT INTO `wp_postmeta` VALUES("82", "41", "_wp_attached_file", "2025/11/abstract-service8.webp");
INSERT INTO `wp_postmeta` VALUES("83", "41", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:2400;s:4:\"file\";s:30:\"2025/11/abstract-service8.webp\";s:8:\"filesize\";i:108106;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"abstract-service8-240x300.webp\";s:5:\"width\";i:240;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:7768;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"abstract-service8-819x1024.webp\";s:5:\"width\";i:819;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:27672;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"abstract-service8-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:5504;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"abstract-service8-768x960.webp\";s:5:\"width\";i:768;s:6:\"height\";i:960;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:25228;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:32:\"abstract-service8-1229x1536.webp\";s:5:\"width\";i:1229;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:46366;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:32:\"abstract-service8-1638x2048.webp\";s:5:\"width\";i:1638;s:6:\"height\";i:2048;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:70230;}s:23:\"tenweb_optimizer_mobile\";a:5:{s:4:\"file\";s:30:\"abstract-service8-480x600.webp\";s:5:\"width\";i:480;s:6:\"height\";i:600;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:14902;}s:23:\"tenweb_optimizer_tablet\";a:5:{s:4:\"file\";s:30:\"abstract-service8-768x960.webp\";s:5:\"width\";i:768;s:6:\"height\";i:960;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:25228;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("84", "41", "_twbb_image_hash", "19efac327a4c53c1b1f2beffdfb7646f038fa28c");
INSERT INTO `wp_postmeta` VALUES("85", "41", "_twbb_section_attachment", "1");
INSERT INTO `wp_postmeta` VALUES("86", "41", "_elementor_source_image_hash", "b4c080193479604624e091c9ad502cd09aa9702c");
INSERT INTO `wp_postmeta` VALUES("87", "42", "_wp_attached_file", "2025/11/abstract-service6.webp");
INSERT INTO `wp_postmeta` VALUES("88", "42", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:1277;s:4:\"file\";s:30:\"2025/11/abstract-service6.webp\";s:8:\"filesize\";i:241968;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"abstract-service6-300x200.webp\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:11502;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"abstract-service6-1024x681.webp\";s:5:\"width\";i:1024;s:6:\"height\";i:681;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:51990;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"abstract-service6-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:7222;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"abstract-service6-768x511.webp\";s:5:\"width\";i:768;s:6:\"height\";i:511;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:35876;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:32:\"abstract-service6-1536x1022.webp\";s:5:\"width\";i:1536;s:6:\"height\";i:1022;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:89934;}s:23:\"tenweb_optimizer_mobile\";a:5:{s:4:\"file\";s:30:\"abstract-service6-600x399.webp\";s:5:\"width\";i:600;s:6:\"height\";i:399;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:25906;}s:23:\"tenweb_optimizer_tablet\";a:5:{s:4:\"file\";s:30:\"abstract-service6-768x511.webp\";s:5:\"width\";i:768;s:6:\"height\";i:511;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:35876;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("89", "42", "_twbb_image_hash", "d9d181dd3c60aa42cedd677020c156359281a2e2");
INSERT INTO `wp_postmeta` VALUES("90", "42", "_twbb_section_attachment", "1");
INSERT INTO `wp_postmeta` VALUES("91", "42", "_elementor_source_image_hash", "d1678ab800d3a646cc298ac53ed26d23abe41328");
INSERT INTO `wp_postmeta` VALUES("92", "43", "_wp_attached_file", "2025/11/abstract-bg-hero3.webp");
INSERT INTO `wp_postmeta` VALUES("93", "43", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:1440;s:4:\"file\";s:30:\"2025/11/abstract-bg-hero3.webp\";s:8:\"filesize\";i:263538;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"abstract-bg-hero3-300x225.webp\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:8960;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"abstract-bg-hero3-1024x768.webp\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:50982;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"abstract-bg-hero3-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:5454;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"abstract-bg-hero3-768x576.webp\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:31544;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:32:\"abstract-bg-hero3-1536x1152.webp\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:96712;}s:23:\"tenweb_optimizer_mobile\";a:5:{s:4:\"file\";s:30:\"abstract-bg-hero3-600x450.webp\";s:5:\"width\";i:600;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:22080;}s:23:\"tenweb_optimizer_tablet\";a:5:{s:4:\"file\";s:30:\"abstract-bg-hero3-768x576.webp\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:31544;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("94", "43", "_twbb_image_hash", "55906547cea120f3089d88978a8b27325362d889");
INSERT INTO `wp_postmeta` VALUES("95", "43", "_twbb_section_attachment", "1");
INSERT INTO `wp_postmeta` VALUES("96", "43", "_elementor_source_image_hash", "73b5c5bf7c7151b56a0bfb56283bbaee8e93991f");
INSERT INTO `wp_postmeta` VALUES("97", "44", "_wp_attached_file", "2025/11/abstract-meeting-widescreen.webp");
INSERT INTO `wp_postmeta` VALUES("98", "44", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:40:\"2025/11/abstract-meeting-widescreen.webp\";s:8:\"filesize\";i:237772;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:40:\"abstract-meeting-widescreen-300x200.webp\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:12826;}s:5:\"large\";a:5:{s:4:\"file\";s:41:\"abstract-meeting-widescreen-1024x683.webp\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:51748;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:40:\"abstract-meeting-widescreen-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:7870;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:40:\"abstract-meeting-widescreen-768x512.webp\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:36260;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:42:\"abstract-meeting-widescreen-1536x1024.webp\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:91810;}s:23:\"tenweb_optimizer_mobile\";a:5:{s:4:\"file\";s:40:\"abstract-meeting-widescreen-600x400.webp\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:27384;}s:23:\"tenweb_optimizer_tablet\";a:5:{s:4:\"file\";s:40:\"abstract-meeting-widescreen-768x512.webp\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:36260;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("99", "44", "_twbb_image_hash", "acfad99b15ae111017d86b13735c07030d9a509d");
INSERT INTO `wp_postmeta` VALUES("100", "44", "_twbb_section_attachment", "1");
INSERT INTO `wp_postmeta` VALUES("101", "44", "_elementor_source_image_hash", "2ce7aeb95bc58832fbde2a19540e0bb449167255");
INSERT INTO `wp_postmeta` VALUES("102", "45", "_wp_attached_file", "2025/11/abstract-bg-hero4.webp");
INSERT INTO `wp_postmeta` VALUES("103", "45", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:1329;s:4:\"file\";s:30:\"2025/11/abstract-bg-hero4.webp\";s:8:\"filesize\";i:154122;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"abstract-bg-hero4-300x208.webp\";s:5:\"width\";i:300;s:6:\"height\";i:208;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:9764;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"abstract-bg-hero4-1024x709.webp\";s:5:\"width\";i:1024;s:6:\"height\";i:709;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:38802;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"abstract-bg-hero4-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:6700;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"abstract-bg-hero4-768x532.webp\";s:5:\"width\";i:768;s:6:\"height\";i:532;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:26766;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:32:\"abstract-bg-hero4-1536x1063.webp\";s:5:\"width\";i:1536;s:6:\"height\";i:1063;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:63792;}s:23:\"tenweb_optimizer_mobile\";a:5:{s:4:\"file\";s:30:\"abstract-bg-hero4-600x415.webp\";s:5:\"width\";i:600;s:6:\"height\";i:415;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:20096;}s:23:\"tenweb_optimizer_tablet\";a:5:{s:4:\"file\";s:30:\"abstract-bg-hero4-768x532.webp\";s:5:\"width\";i:768;s:6:\"height\";i:532;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:26766;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("104", "45", "_twbb_image_hash", "69da608158c005f11b2fb825b9d042416edf2c69");
INSERT INTO `wp_postmeta` VALUES("105", "45", "_twbb_section_attachment", "1");
INSERT INTO `wp_postmeta` VALUES("106", "45", "_elementor_source_image_hash", "9328197d29c9008fa039e8b83be9f7f098a2d641");
INSERT INTO `wp_postmeta` VALUES("111", "47", "_elementor_data", "[{\"id\":\"168ea0e\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/about\\/about_1_2\\/background_color_type-none--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"About\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_justify_content\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"1mibgj4d\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"b0qyejue\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"title\":\"Why Choose Us?\",\"header_size\":\"h2\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"5dih4mfk\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"editor\":\"Every business has its unique advantages, and users want to know what sets yours apart. This is the ideal place to highlight the reasons why customers should choose your services or products. Click on the text box to edit the content and include details.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p3\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"kw8y3bz9\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-meeting-widescreen.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"u6i0fyjk\"}]}],\"isInner\":\"false\"},{\"id\":\"b5a4266\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/about\\/about_1_3_1\\/background_color_type-none--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"About\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"e61tqhb2\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"0fwvpek5\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"10\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"title\":\"Achievements\",\"header_size\":\"h2\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"zf9f1x8m\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"10\",\"bottom\":\"10\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"This is the ideal space to showcase a detailed overview of your accomplishments and what they signify for your endeavor.\\n\\nClick on the text box to customize the content and include all the noteworthy details you wish to share.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"dr1ghpen\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"ryjk16mm\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"8tl37quh\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"auto\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"auto\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"starting_number\":0,\"ending_number\":10000,\"title\":\"Number of satisfied clients\",\"duration\":2000,\"thousand_separator\":\"\",\"suffix\":\" \",\"__globals__\":{\"typography_number_typography\":\"globals\\/typography?id=twbb_h4\",\"typography_title_typography\":\"globals\\/typography?id=twbb_p4\",\"number_color\":\"globals\\/colors?id=primary\",\"title_color\":\"globals\\/colors?id=text\"},\"_flex_align_self\":\"flex-start\",\"title_horizontal_alignment\":\"start\",\"number_position\":\"start\",\"title_gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"counter\",\"id\":\"g9nw6b86\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"3lbsn1e6\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"auto\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"auto\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"starting_number\":0,\"ending_number\":100,\"title\":\"Countries reached\",\"duration\":2000,\"thousand_separator\":\"\",\"suffix\":\" \",\"__globals__\":{\"typography_number_typography\":\"globals\\/typography?id=twbb_h4\",\"typography_title_typography\":\"globals\\/typography?id=twbb_p4\",\"number_color\":\"globals\\/colors?id=primary\",\"title_color\":\"globals\\/colors?id=text\"},\"_flex_align_self\":\"flex-start\",\"title_horizontal_alignment\":\"start\",\"number_position\":\"start\",\"title_gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"counter\",\"id\":\"twz9ip7t\"}]}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"1aociceq\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"979ceu2t\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"auto\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"auto\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"starting_number\":0,\"ending_number\":500,\"title\":\"Projects completed\",\"duration\":2000,\"thousand_separator\":\"\",\"suffix\":\" \",\"__globals__\":{\"typography_number_typography\":\"globals\\/typography?id=twbb_h4\",\"typography_title_typography\":\"globals\\/typography?id=twbb_p4\",\"number_color\":\"globals\\/colors?id=primary\",\"title_color\":\"globals\\/colors?id=text\"},\"_flex_align_self\":\"flex-start\",\"title_horizontal_alignment\":\"start\",\"number_position\":\"start\",\"title_gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"counter\",\"id\":\"abjj0zal\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"3p9emts7\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"auto\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"auto\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"starting_number\":0,\"ending_number\":50,\"title\":\"Industry awards won\",\"duration\":2000,\"thousand_separator\":\"\",\"suffix\":\" \",\"__globals__\":{\"typography_number_typography\":\"globals\\/typography?id=twbb_h4\",\"typography_title_typography\":\"globals\\/typography?id=twbb_p4\",\"number_color\":\"globals\\/colors?id=primary\",\"title_color\":\"globals\\/colors?id=text\"},\"_flex_align_self\":\"flex-start\",\"title_horizontal_alignment\":\"start\",\"number_position\":\"start\",\"title_gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"counter\",\"id\":\"e5lvu91i\"}]}]}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_margin\":{\"left\":\"30\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-meeting-square.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"hrb3qfjg\"}]}],\"isInner\":\"false\"},{\"id\":\"404dd89\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/about\\/about_1_3_2\\/background_color_type-none--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"About\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"osutfc4c\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"30\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-meeting2-square.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"rboll9d9\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"06qy26iy\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"10\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"title\":\"Achievements\",\"header_size\":\"h2\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"ymjaagbf\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"10\",\"bottom\":\"10\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"This is the ideal space to showcase a detailed overview of your accomplishments and what they signify for your endeavor.\\n\\nClick on the text box to customize the content and include all the noteworthy details you wish to share.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"20sau4m4\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"kjh2kizm\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"cjhk0qz7\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"auto\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"auto\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"starting_number\":0,\"ending_number\":10000,\"title\":\"Happy clients worldwide\",\"duration\":2000,\"thousand_separator\":\"\",\"suffix\":\" \",\"__globals__\":{\"typography_number_typography\":\"globals\\/typography?id=twbb_h4\",\"typography_title_typography\":\"globals\\/typography?id=twbb_p4\",\"number_color\":\"globals\\/colors?id=primary\",\"title_color\":\"globals\\/colors?id=text\"},\"_flex_align_self\":\"flex-start\",\"title_horizontal_alignment\":\"start\",\"number_position\":\"start\",\"title_gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"counter\",\"id\":\"4jvl2baz\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"ce3s3w61\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"auto\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"auto\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"starting_number\":0,\"ending_number\":100,\"title\":\"Markets penetrated\",\"duration\":2000,\"thousand_separator\":\"\",\"suffix\":\" \",\"__globals__\":{\"typography_number_typography\":\"globals\\/typography?id=twbb_h4\",\"typography_title_typography\":\"globals\\/typography?id=twbb_p4\",\"number_color\":\"globals\\/colors?id=primary\",\"title_color\":\"globals\\/colors?id=text\"},\"_flex_align_self\":\"flex-start\",\"title_horizontal_alignment\":\"start\",\"number_position\":\"start\",\"title_gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"counter\",\"id\":\"6vzum0bv\"}]}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"1lefrins\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"pp9sg87c\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"auto\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"auto\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"starting_number\":0,\"ending_number\":500,\"title\":\"Successful campaigns run\",\"duration\":2000,\"thousand_separator\":\"\",\"suffix\":\" \",\"__globals__\":{\"typography_number_typography\":\"globals\\/typography?id=twbb_h4\",\"typography_title_typography\":\"globals\\/typography?id=twbb_p4\",\"number_color\":\"globals\\/colors?id=primary\",\"title_color\":\"globals\\/colors?id=text\"},\"_flex_align_self\":\"flex-start\",\"title_horizontal_alignment\":\"start\",\"number_position\":\"start\",\"title_gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"counter\",\"id\":\"dxowgwoi\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"5vm3ycmc\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"auto\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"auto\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"starting_number\":0,\"ending_number\":50,\"title\":\"Awards for marketing excellence\",\"duration\":2000,\"thousand_separator\":\"\",\"suffix\":\" \",\"__globals__\":{\"typography_number_typography\":\"globals\\/typography?id=twbb_h4\",\"typography_title_typography\":\"globals\\/typography?id=twbb_p4\",\"number_color\":\"globals\\/colors?id=primary\",\"title_color\":\"globals\\/colors?id=text\"},\"_flex_align_self\":\"flex-start\",\"title_horizontal_alignment\":\"start\",\"number_position\":\"start\",\"title_gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"counter\",\"id\":\"pad7t5g7\"}]}]}]}]}],\"isInner\":\"false\"},{\"id\":\"18b595d\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/blog\\/blog_43\\/background_color_type-none--background_media_type-none--cards_type-no_contrast--num_of_posts-3.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Blog\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_justify_content\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"gj10xki9\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_justify_content\":\"space-between\",\"flex_align_items\":\"flex-end\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"84dlwi3x\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"zc6qfdk4\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Our Recent Blog Posts\",\"header_size\":\"h2\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"tvh60dp5\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"editor\":\"Welcome to our blog, where we explore the latest trends and tips.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"5lmsuomp\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_margin\":{\"left\":\"10\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"text\":\"View all\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"right\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=accent\",\"background_color\":\"globals\\/colors?id=twbb_transparent\",\"button_background_hover_color\":\"globals\\/colors?id=accent\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=accent\",\"hover_color\":\"globals\\/colors?id=twbb_button_inv\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"rgvehuwf\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"classic_content_padding\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"classic_content_padding_mobile\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"classic_image_spacing\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"classic_image_spacing_mobile\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"classic_title_spacing\":{\"unit\":\"px\",\"size\":8,\"sizes\":[]},\"classic_title_spacing_mobile\":{\"unit\":\"px\",\"size\":8,\"sizes\":[]},\"classic_excerpt_length\":15,\"classic_apply_to_custom_excerpt\":\"yes\",\"classic_read_more_text\":\"Read More\",\"cards_read_more_text\":\"Read More\",\"classic_read_more_icon\":{\"value\":\"fas fa-angle-right\",\"library\":\"fa-solid\"},\"classic_meta_spacing\":{\"unit\":\"px\",\"size\":8,\"sizes\":[]},\"classic_meta_spacing_mobile\":{\"unit\":\"px\",\"size\":8,\"sizes\":[]},\"classic_excerpt_spacing\":{\"unit\":\"px\",\"size\":\"26\",\"sizes\":[]},\"classic_title_tag\":\"h5\",\"__globals__\":{\"classic_title_typography_typography\":\"globals\\/typography?id=twbb_h5\",\"classic_title_color\":\"globals\\/colors?id=primary\",\"classic_excerpt_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"classic_excerpt_color\":\"globals\\/colors?id=text\",\"classic_badge_bg_color\":\"globals\\/colors?id=twbb_transparent\",\"classic_badge_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"classic_badge_color\":\"globals\\/colors?id=text\",\"classic_read_more_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"classic_read_more_color\":\"globals\\/colors?id=text\",\"classic_meta_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"classic_meta_color\":\"globals\\/colors?id=text\",\"classic_box_bg_color\":\"globals\\/colors?id=twbb_bg_primary\",\"classic_twbb_badge_color\":\"globals\\/colors?id=secondary\"},\"classic_columns\":\"3\",\"pagination_page_limit\":\"5\",\"pagination_prev_label\":\"&laquo; Previous\",\"pagination_next_label\":\"Next &raquo;\",\"text\":\"Load More\",\"load_more_no_posts_custom_message\":\"No more posts to show\",\"tenweb-posts_post_type\":\"post\",\"classic_thumbnail_mobile\":\"top\",\"classic_posts_per_page\":3,\"classic_show_read_more\":\"\"},\"elType\":\"widget\",\"widgetType\":\"tenweb-posts\",\"id\":\"6xgp1hjf\"}]}],\"isInner\":\"false\"},{\"id\":\"09a5650\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/blog\\/blog_62\\/background_color_type-none--background_media_type-none--cards_type-no_contrast--num_of_posts-4.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Blog\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_justify_content\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"sgcuyc6u\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_justify_content\":\"space-between\",\"flex_align_items\":\"flex-end\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"aawvy4gl\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"j7s2h9h9\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Our Recent Blog Posts\",\"header_size\":\"h2\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"4yo7ov58\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"editor\":\"Welcome to our blog, where we explore the latest trends and tips.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"8as4ecg4\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_margin\":{\"left\":\"10\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"text\":\"View all\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"right\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=accent\",\"background_color\":\"globals\\/colors?id=twbb_transparent\",\"button_background_hover_color\":\"globals\\/colors?id=accent\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=accent\",\"hover_color\":\"globals\\/colors?id=twbb_button_inv\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"3falw5fb\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"classic_content_padding\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"classic_content_padding_mobile\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"classic_image_spacing\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"classic_image_spacing_mobile\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"classic_title_spacing\":{\"unit\":\"px\",\"size\":8,\"sizes\":[]},\"classic_title_spacing_mobile\":{\"unit\":\"px\",\"size\":8,\"sizes\":[]},\"classic_excerpt_length\":15,\"classic_apply_to_custom_excerpt\":\"yes\",\"classic_read_more_text\":\"Read More\",\"cards_read_more_text\":\"Read More\",\"classic_read_more_icon\":{\"value\":\"fas fa-angle-right\",\"library\":\"fa-solid\"},\"classic_meta_spacing\":{\"unit\":\"px\",\"size\":8,\"sizes\":[]},\"classic_meta_spacing_mobile\":{\"unit\":\"px\",\"size\":8,\"sizes\":[]},\"classic_excerpt_spacing\":{\"unit\":\"px\",\"size\":\"26\",\"sizes\":[]},\"classic_title_tag\":\"h5\",\"__globals__\":{\"classic_title_typography_typography\":\"globals\\/typography?id=twbb_h5\",\"classic_title_color\":\"globals\\/colors?id=primary\",\"classic_excerpt_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"classic_excerpt_color\":\"globals\\/colors?id=text\",\"classic_badge_bg_color\":\"globals\\/colors?id=twbb_transparent\",\"classic_badge_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"classic_badge_color\":\"globals\\/colors?id=text\",\"classic_read_more_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"classic_read_more_color\":\"globals\\/colors?id=text\",\"classic_meta_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"classic_meta_color\":\"globals\\/colors?id=text\",\"classic_box_bg_color\":\"globals\\/colors?id=twbb_bg_primary\",\"classic_twbb_badge_color\":\"globals\\/colors?id=secondary\"},\"classic_columns\":\"2\",\"pagination_page_limit\":\"5\",\"pagination_prev_label\":\"&laquo; Previous\",\"pagination_next_label\":\"Next &raquo;\",\"text\":\"Load More\",\"load_more_no_posts_custom_message\":\"No more posts to show\",\"tenweb-posts_post_type\":\"post\",\"classic_thumbnail_mobile\":\"top\",\"classic_posts_per_page\":4,\"classic_meta_data\":[],\"classic_thumbnail\":\"left\",\"classic_twbb_full_height\":\"yes\",\"classic_image_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"tenweb-posts\",\"id\":\"y6sb9ekm\"}]}],\"isInner\":\"false\"},{\"id\":\"ea50d48\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/contact\\/contact_1\\/align-left--background_color_type-none--background_media_type-none--cards_type-no_contrast--form-yes.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Contact\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"0uy7bsr7\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"title\":\"Reach Out\",\"header_size\":\"h2\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"0oxbfwdi\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"We\'re here to help with any questions or support.\",\"align\":\"center\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"wki205uv\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"20\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"20\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"form_name\":\"\",\"form_description\":\"\",\"button_text\":\"Submit\",\"button_width\":\"100\",\"button_text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"button_align_mobile\":\"stretch\",\"form_fields\":[{\"custom_id\":\"name\",\"field_type\":\"text\",\"field_label\":\"Name\",\"required\":\"true\",\"placeholder\":\"Enter your name\"},{\"custom_id\":\"email\",\"field_type\":\"email\",\"field_label\":\"Email\",\"required\":\"true\",\"placeholder\":\"Enter your email\"},{\"custom_id\":\"message\",\"field_type\":\"textarea\",\"field_label\":\"Message\",\"placeholder\":\"Type your message\",\"required\":\"true\"},{\"custom_id\":\"acceptance\",\"field_type\":\"acceptance\",\"acceptance_text\":\"I accept the Terms\",\"required\":\"true\"}],\"row_gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"column_gap\":{\"size\":\"20\",\"unit\":\"px\",\"sizes\":[]},\"label_spacing\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"align_description\":\"left\",\"align_description_mobile\":\"center\",\"_align\":\"left\",\"title_align\":\"left\",\"title_align_mobile\":\"center\",\"align_text_after_buttons_mobile\":\"center\",\"_border_radius\":\"0\",\"title_tag\":\"h1\",\"__globals__\":{\"_background_color\":\"\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"label_color\":\"globals\\/colors?id=secondary\",\"typography_title_typography\":\"globals\\/typography?id=twbb_h3\",\"typography_description_typography\":\"globals\\/typography?id=twbb_p3\",\"label_typography_typography\":\"globals\\/typography?id=twbb_p3\",\"html_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"field_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"html_color\":\"globals\\/colors?id=text\",\"field_text_color\":\"globals\\/colors?id=twbb_button\",\"field_background_color\":\"globals\\/colors?id=twbb_bg_primary\",\"button_typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_background_color\":\"globals\\/colors?id=accent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_accent_hover\",\"button_border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_accent_hover\",\"field_border_color\":\"globals\\/colors?id=twbb_button\"},\"button_border_border\":\"solid\",\"button_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"field_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"field_border_border\":\"solid\",\"step_next_label\":\"Next\",\"step_previous_label\":\"Previous\",\"reset_button_text\":\"Reset\",\"email_content\":\"[all-fields]\",\"email_content_2\":\"[all-fields]\",\"success_message\":\"The form was sent successfully.\",\"error_message\":\"An error occurred.\",\"required_field_message\":\"This field is required.\",\"invalid_message\":\"There&#039;s something wrong. The form is invalid.\",\"button_align\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"twbb_form\",\"id\":\"2kfwjqlt\"}]}],\"isInner\":\"false\"},{\"id\":\"9e92b5c\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/contact\\/contact_10\\/align-left--background_color_type-none--background_media_type-none--cards_type-no_contrast--form-yes.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Contact\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_gap\":{\"column\":\"60\",\"row\":\"60\",\"isLinked\":true,\"unit\":\"px\",\"size\":60},\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"0z3ykrda\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"address\":\"350 Fifth Avenue, New York, US\",\"zoom\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"height\":{\"unit\":\"px\",\"size\":570,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"google_maps\",\"id\":\"9c6bjr7k\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"form_name\":\"Contact US\",\"form_description\":\"We\'re here to help with any questions or support.\",\"button_text\":\"Submit\",\"button_width\":\"100\",\"button_text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"button_align_mobile\":\"stretch\",\"form_fields\":[{\"custom_id\":\"name\",\"field_type\":\"text\",\"field_label\":\"Name\",\"required\":\"true\",\"placeholder\":\"Enter your name\"},{\"custom_id\":\"email\",\"field_type\":\"email\",\"field_label\":\"Email\",\"placeholder\":\"Enter your email\",\"required\":\"true\"},{\"custom_id\":\"message\",\"field_type\":\"textarea\",\"field_label\":\"Message\",\"placeholder\":\"Type your message\",\"required\":\"true\"},{\"custom_id\":\"acceptance\",\"field_type\":\"acceptance\",\"acceptance_text\":\"I accept the Terms\",\"required\":\"true\"}],\"row_gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"column_gap\":{\"size\":\"20\",\"unit\":\"px\",\"sizes\":[]},\"label_spacing\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"align_description\":\"left\",\"align_description_mobile\":\"center\",\"_align\":\"left\",\"title_align\":\"left\",\"title_align_mobile\":\"center\",\"align_text_after_buttons_mobile\":\"center\",\"_border_radius\":\"0\",\"title_tag\":\"h3\",\"__globals__\":{\"_background_color\":\"\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"label_color\":\"globals\\/colors?id=secondary\",\"typography_title_typography\":\"globals\\/typography?id=twbb_h3\",\"typography_description_typography\":\"globals\\/typography?id=twbb_p3\",\"label_typography_typography\":\"globals\\/typography?id=twbb_p3\",\"html_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"field_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"html_color\":\"globals\\/colors?id=text\",\"field_text_color\":\"globals\\/colors?id=twbb_button\",\"field_background_color\":\"globals\\/colors?id=twbb_bg_primary\",\"button_typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_background_color\":\"globals\\/colors?id=accent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_accent_hover\",\"button_border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_accent_hover\",\"field_border_color\":\"globals\\/colors?id=twbb_button\"},\"button_border_border\":\"solid\",\"button_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"field_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"field_border_border\":\"solid\",\"step_next_label\":\"Next\",\"step_previous_label\":\"Previous\",\"reset_button_text\":\"Reset\",\"email_content\":\"[all-fields]\",\"email_content_2\":\"[all-fields]\",\"success_message\":\"The form was sent successfully.\",\"error_message\":\"An error occurred.\",\"required_field_message\":\"This field is required.\",\"invalid_message\":\"There&#039;s something wrong. The form is invalid.\",\"display_form_title_description\":\"yes\",\"button_align\":\"left\"},\"elType\":\"widget\",\"widgetType\":\"twbb_form\",\"id\":\"rxduf26c\"}]}],\"isInner\":\"false\"},{\"id\":\"5baedd8\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/contact\\/contact_16\\/background_color_type-none--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"lxy1yu34\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"zk19qvf0\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_justify_content\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"8cm4fdf3\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":42,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":42,\"sizes\":[]},\"title\":\"Tagline\",\"header_size\":\"h5\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=twbb_label\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"1jkoya1r\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Contact Us\",\"header_size\":\"h2\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"pum3a7eb\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"editor\":\"We\'re here to help with any questions or support.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"i6aj9xa8\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":41,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":41,\"sizes\":[]},\"_margin\":{\"left\":\"10\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"icon_list\":[{\"text\":\"email@example.com\",\"selected_icon\":{\"value\":\"far fa-envelope\",\"library\":\"fa-regular\"}},{\"text\":\"+123456789\",\"selected_icon\":{\"value\":\"fas fa-phone-alt\",\"library\":\"fa-solid\"}},{\"text\":\"1234 Market St, Metropolis\",\"selected_icon\":{\"value\":\"fas fa-map-marker-alt\",\"library\":\"fa-solid\"},\"link\":{\"url\":\"https:\\/\\/maps.google.com\"}}],\"space_between\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"space_between_mobile\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"text_indent\":{\"size\":\"14\",\"unit\":\"px\",\"sizes\":[]},\"icon_align\":\"left\",\"__globals__\":{\"icon_color\":\"globals\\/colors?id=secondary\",\"text_color\":\"globals\\/colors?id=text\",\"icon_typography_typography\":\"globals\\/typography?id=twbb_p3\"},\"icon_size\":{\"size\":\"14\",\"unit\":\"px\",\"sizes\":[]},\"icon_size_mobile\":{\"size\":\"14\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-list\",\"id\":\"364dg73m\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"address\":\"350 Fifth Avenue, New York, US\",\"zoom\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"height\":{\"unit\":\"px\",\"size\":570,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"google_maps\",\"id\":\"nylrq1ev\"}]}],\"isInner\":\"false\"},{\"id\":\"ea86541\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/contact\\/contact_17\\/align-center--background_color_type-none--background_media_type-none--cards_type-no_contrast--form-no.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Contact\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"jepi8p0v\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"selected_icon\":{\"value\":\"far fa-envelope\",\"library\":\"fa-regular\"},\"title_text\":\"Email Us\",\"description_text\":\"Contact us for partnership opportunities at <a href=\\\"mailto:partners@superbestco.com\\\">partners@superbestco.com<\\/a>\",\"title_size\":\"h4\",\"text_align\":\"left\",\"text_align_mobile\":\"center\",\"__globals__\":{\"primary_color\":\"globals\\/colors?id=secondary\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"title_typography_typography\":\"globals\\/typography?id=twbb_h4\",\"description_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-box\",\"id\":\"x5zbhfvk\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"selected_icon\":{\"value\":\"fas fa-phone-alt\",\"library\":\"fa-solid\"},\"title_text\":\"Call Us\",\"description_text\":\"Discuss your project with our team at <a href=\\\"tel:+123456789\\\">123-456-789<\\/a>\",\"title_size\":\"h4\",\"text_align\":\"left\",\"text_align_mobile\":\"center\",\"__globals__\":{\"primary_color\":\"globals\\/colors?id=secondary\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"title_typography_typography\":\"globals\\/typography?id=twbb_h4\",\"description_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-box\",\"id\":\"xq9pbgiz\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"selected_icon\":{\"value\":\"fas fa-map-marker-alt\",\"library\":\"fa-solid\"},\"title_text\":\"Visit Us\",\"description_text\":\"Find our main office at <a href=\\\"https:\\/\\/maps.google.com\\\">1234 Market St, Metropolis<\\/a>\",\"title_size\":\"h4\",\"text_align\":\"left\",\"text_align_mobile\":\"center\",\"__globals__\":{\"primary_color\":\"globals\\/colors?id=secondary\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"title_typography_typography\":\"globals\\/typography?id=twbb_h4\",\"description_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-box\",\"id\":\"cwjiyjc5\"}]}],\"isInner\":\"false\"},{\"id\":\"5f6cb18\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/contact\\/contact_17b\\/align-center--background_color_type-none--background_media_type-none--cards_type-no_contrast--form-no.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Contact\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"3slulbxv\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"ms1ergd0\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"selected_icon\":{\"value\":\"far fa-envelope\",\"library\":\"fa-regular\"},\"title_text\":\"Email Us\",\"description_text\":\"Contact us for partnership opportunities at <a href=\\\"mailto:partners@superbestco.com\\\">partners@superbestco.com<\\/a>\",\"title_size\":\"h4\",\"text_align\":\"left\",\"text_align_mobile\":\"center\",\"__globals__\":{\"primary_color\":\"globals\\/colors?id=secondary\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"title_typography_typography\":\"globals\\/typography?id=twbb_h4\",\"description_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-box\",\"id\":\"en1ozphf\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"selected_icon\":{\"value\":\"fas fa-phone-alt\",\"library\":\"fa-solid\"},\"title_text\":\"Call Us\",\"description_text\":\"Discuss your project with our team at <a href=\\\"tel:+123456789\\\">123-456-789<\\/a>\",\"title_size\":\"h4\",\"text_align\":\"left\",\"text_align_mobile\":\"center\",\"__globals__\":{\"primary_color\":\"globals\\/colors?id=secondary\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"title_typography_typography\":\"globals\\/typography?id=twbb_h4\",\"description_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-box\",\"id\":\"by886x0w\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"selected_icon\":{\"value\":\"fas fa-map-marker-alt\",\"library\":\"fa-solid\"},\"title_text\":\"Visit Us\",\"description_text\":\"Find our main office at <a href=\\\"https:\\/\\/maps.google.com\\\">1234 Market St, Metropolis<\\/a>\",\"title_size\":\"h4\",\"text_align\":\"left\",\"text_align_mobile\":\"center\",\"__globals__\":{\"primary_color\":\"globals\\/colors?id=secondary\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"title_typography_typography\":\"globals\\/typography?id=twbb_h4\",\"description_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-box\",\"id\":\"3s37r949\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"address\":\"350 Fifth Avenue, New York, US\",\"zoom\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"height\":{\"unit\":\"px\",\"size\":570,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"google_maps\",\"id\":\"5ao26eq1\"}]}],\"isInner\":\"false\"},{\"id\":\"8370ee9\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/contact\\/contact_18\\/align-center--background_color_type-none--background_media_type-none--cards_type-no_contrast--form-no.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Contact\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"ju0wy4x7\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"selected_icon\":{\"value\":\"far fa-envelope\",\"library\":\"fa-regular\"},\"title_text\":\"Email Us\",\"description_text\":\"Contact us at <a href=\\\"mailto:info@superbestco.com\\\">info@superbestco.com<\\/a>\",\"title_size\":\"h4\",\"text_align\":\"center\",\"text_align_mobile\":\"center\",\"__globals__\":{\"primary_color\":\"globals\\/colors?id=secondary\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"title_typography_typography\":\"globals\\/typography?id=twbb_h4\",\"description_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-box\",\"id\":\"icj5wzjr\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"selected_icon\":{\"value\":\"fas fa-phone-alt\",\"library\":\"fa-solid\"},\"title_text\":\"Call Us\",\"description_text\":\"Discuss your project with our team at <a href=\\\"tel:+123456789\\\">123-456-789<\\/a>\",\"title_size\":\"h4\",\"text_align\":\"center\",\"text_align_mobile\":\"center\",\"__globals__\":{\"primary_color\":\"globals\\/colors?id=secondary\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"title_typography_typography\":\"globals\\/typography?id=twbb_h4\",\"description_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-box\",\"id\":\"wn0btpnb\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"selected_icon\":{\"value\":\"fas fa-map-marker-alt\",\"library\":\"fa-solid\"},\"title_text\":\"Visit Us\",\"description_text\":\"Find our main office at <a href=\\\"https:\\/\\/maps.google.com\\\">1234 Market St, Metropolis<\\/a>\",\"title_size\":\"h4\",\"text_align\":\"center\",\"text_align_mobile\":\"center\",\"__globals__\":{\"primary_color\":\"globals\\/colors?id=secondary\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"title_typography_typography\":\"globals\\/typography?id=twbb_h4\",\"description_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-box\",\"id\":\"oqs9news\"}]}],\"isInner\":\"false\"},{\"id\":\"1fd85d7\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/contact\\/contact_18b\\/align-center--background_color_type-none--background_media_type-none--cards_type-no_contrast--form-no.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Contact\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"6ln31eks\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"nt13q5ss\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"selected_icon\":{\"value\":\"far fa-envelope\",\"library\":\"fa-regular\"},\"title_text\":\"Email Us\",\"description_text\":\"Contact us for partnership opportunities at <a href=\\\"mailto:partners@superbestco.com\\\">partners@superbestco.com<\\/a>\",\"title_size\":\"h4\",\"text_align\":\"center\",\"text_align_mobile\":\"center\",\"__globals__\":{\"primary_color\":\"globals\\/colors?id=secondary\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"title_typography_typography\":\"globals\\/typography?id=twbb_h4\",\"description_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-box\",\"id\":\"m9upfco6\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"selected_icon\":{\"value\":\"fas fa-phone-alt\",\"library\":\"fa-solid\"},\"title_text\":\"Call Us\",\"description_text\":\"Discuss your project with our team at <a href=\\\"tel:+123456789\\\">123-456-789<\\/a>\",\"title_size\":\"h4\",\"text_align\":\"center\",\"text_align_mobile\":\"center\",\"__globals__\":{\"primary_color\":\"globals\\/colors?id=secondary\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"title_typography_typography\":\"globals\\/typography?id=twbb_h4\",\"description_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-box\",\"id\":\"chfzcwc3\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"selected_icon\":{\"value\":\"fas fa-map-marker-alt\",\"library\":\"fa-solid\"},\"title_text\":\"Visit Us\",\"description_text\":\"Find our main office at <a href=\\\"https:\\/\\/maps.google.com\\\">1234 Market St, Metropolis<\\/a>\",\"title_size\":\"h4\",\"text_align\":\"center\",\"text_align_mobile\":\"center\",\"__globals__\":{\"primary_color\":\"globals\\/colors?id=secondary\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"title_typography_typography\":\"globals\\/typography?id=twbb_h4\",\"description_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-box\",\"id\":\"9r60r1uj\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"address\":\"350 Fifth Avenue, New York, US\",\"zoom\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"height\":{\"unit\":\"px\",\"size\":570,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"google_maps\",\"id\":\"j4k8442n\"}]}],\"isInner\":\"false\"},{\"id\":\"299a8df\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/contact\\/contact_19\\/align-center--background_color_type-none--background_media_type-none--cards_type-no_contrast--form-no.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Contact\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"k98hesz1\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"z6b792ww\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":25,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":25,\"sizes\":[]},\"title\":\"Tagline\",\"header_size\":\"h5\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=twbb_label\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"3nciejdy\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"title\":\"Contact Us\",\"header_size\":\"h2\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"2xsb3m11\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"editor\":\"We\'re here to help with any questions or support.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"04zy6c43\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"cx00wni3\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"selected_icon\":{\"value\":\"far fa-envelope\",\"library\":\"fa-regular\"},\"title_text\":\"Email Us\",\"description_text\":\"Contact us for partnership opportunities at <a href=\\\"mailto:partners@superbestco.com\\\">partners@superbestco.com<\\/a>\",\"title_size\":\"h4\",\"text_align\":\"left\",\"text_align_mobile\":\"center\",\"__globals__\":{\"primary_color\":\"globals\\/colors?id=secondary\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"title_typography_typography\":\"globals\\/typography?id=twbb_h4\",\"description_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-box\",\"id\":\"dyfiac0f\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"selected_icon\":{\"value\":\"fas fa-phone-alt\",\"library\":\"fa-solid\"},\"title_text\":\"Call Us\",\"description_text\":\"Discuss your project with our team at <a href=\\\"tel:+123456789\\\">123-456-789<\\/a>\",\"title_size\":\"h4\",\"text_align\":\"left\",\"text_align_mobile\":\"center\",\"__globals__\":{\"primary_color\":\"globals\\/colors?id=secondary\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"title_typography_typography\":\"globals\\/typography?id=twbb_h4\",\"description_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-box\",\"id\":\"nupnqud7\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"selected_icon\":{\"value\":\"fas fa-map-marker-alt\",\"library\":\"fa-solid\"},\"title_text\":\"Visit Us\",\"description_text\":\"Find our main office at <a href=\\\"https:\\/\\/maps.google.com\\\">1234 Market St, Metropolis<\\/a>\",\"title_size\":\"h4\",\"text_align\":\"left\",\"text_align_mobile\":\"center\",\"__globals__\":{\"primary_color\":\"globals\\/colors?id=secondary\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"title_typography_typography\":\"globals\\/typography?id=twbb_h4\",\"description_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-box\",\"id\":\"3fpthq8z\"}]}]}],\"isInner\":\"false\"},{\"id\":\"d5fa2b4\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/contact\\/contact_20\\/align-center--background_color_type-none--background_media_type-none--cards_type-no_contrast--form-no.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Contact\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"oggr3mnx\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"zg8wkioo\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":25,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":25,\"sizes\":[]},\"title\":\"Tagline\",\"header_size\":\"h5\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=twbb_label\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"1z1g55mn\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"title\":\"Contact Us\",\"header_size\":\"h2\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"5ltfdidn\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"editor\":\"We\'re here to help with any questions or support.\",\"align\":\"center\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"qhool7ec\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"4fl5c5hk\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"selected_icon\":{\"value\":\"far fa-envelope\",\"library\":\"fa-regular\"},\"title_text\":\"Email Us\",\"description_text\":\"Contact us for partnership opportunities at <a href=\\\"mailto:partners@superbestco.com\\\">partners@superbestco.com<\\/a>\",\"title_size\":\"h4\",\"text_align\":\"center\",\"text_align_mobile\":\"center\",\"__globals__\":{\"primary_color\":\"globals\\/colors?id=secondary\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"title_typography_typography\":\"globals\\/typography?id=twbb_h4\",\"description_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-box\",\"id\":\"p0zt2qat\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"selected_icon\":{\"value\":\"fas fa-phone-alt\",\"library\":\"fa-solid\"},\"title_text\":\"Call Us\",\"description_text\":\"Discuss your project with our team at <a href=\\\"tel:+123456789\\\">123-456-789<\\/a>\",\"title_size\":\"h4\",\"text_align\":\"center\",\"text_align_mobile\":\"center\",\"__globals__\":{\"primary_color\":\"globals\\/colors?id=secondary\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"title_typography_typography\":\"globals\\/typography?id=twbb_h4\",\"description_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-box\",\"id\":\"wpr8vjrm\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"selected_icon\":{\"value\":\"fas fa-map-marker-alt\",\"library\":\"fa-solid\"},\"title_text\":\"Visit Us\",\"description_text\":\"Find our main office at <a href=\\\"https:\\/\\/maps.google.com\\\">1234 Market St, Metropolis<\\/a>\",\"title_size\":\"h4\",\"text_align\":\"center\",\"text_align_mobile\":\"center\",\"__globals__\":{\"primary_color\":\"globals\\/colors?id=secondary\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"title_typography_typography\":\"globals\\/typography?id=twbb_h4\",\"description_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-box\",\"id\":\"tzzy8xv8\"}]}]}],\"isInner\":\"false\"},{\"id\":\"89d7d53\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/contact\\/contact_5\\/align-left--background_color_type-none--background_media_type-none--cards_type-no_contrast--form-yes.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Contact\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"p2alhvya\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_justify_content\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"ug2yqe5r\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Get in Touch\",\"header_size\":\"h2\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"er04cgr1\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"We\'re here to help with any questions or support.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"4ypxwra7\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"icon_list\":[{\"text\":\"email@example.com\",\"selected_icon\":{\"value\":\"far fa-envelope\",\"library\":\"fa-regular\"}},{\"text\":\"+123456789\",\"selected_icon\":{\"value\":\"fas fa-phone-alt\",\"library\":\"fa-solid\"}},{\"text\":\"1234 Market St, Metropolis\",\"selected_icon\":{\"value\":\"fas fa-map-marker-alt\",\"library\":\"fa-solid\"},\"link\":{\"url\":\"https:\\/\\/maps.google.com\"}}],\"space_between\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"space_between_mobile\":{\"unit\":\"px\",\"size\":8,\"sizes\":[]},\"text_indent\":{\"size\":\"18\",\"unit\":\"px\",\"sizes\":[]},\"icon_align\":\"left\",\"__globals__\":{\"icon_color\":\"globals\\/colors?id=secondary\",\"text_color\":\"globals\\/colors?id=text\",\"icon_typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"icon_size\":{\"size\":\"18\",\"unit\":\"px\",\"sizes\":[]},\"icon_size_mobile\":{\"size\":\"16\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-list\",\"id\":\"60qsq07u\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_margin\":{\"left\":\"30\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"form_name\":\"\",\"form_description\":\"\",\"button_text\":\"Submit\",\"button_width\":\"100\",\"button_text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"button_align_mobile\":\"stretch\",\"form_fields\":[{\"custom_id\":\"name\",\"field_type\":\"text\",\"field_label\":\"Name\",\"required\":\"true\",\"placeholder\":\"Enter your name\"},{\"custom_id\":\"email\",\"field_type\":\"email\",\"field_label\":\"Email\",\"placeholder\":\"Enter your email\",\"required\":\"true\"},{\"custom_id\":\"message\",\"field_type\":\"textarea\",\"field_label\":\"Message\",\"placeholder\":\"Type your message\",\"required\":\"true\"},{\"custom_id\":\"acceptance\",\"field_type\":\"acceptance\",\"acceptance_text\":\"I accept the Terms\",\"required\":\"true\"}],\"row_gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"column_gap\":{\"size\":\"20\",\"unit\":\"px\",\"sizes\":[]},\"label_spacing\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"align_description\":\"left\",\"align_description_mobile\":\"center\",\"_align\":\"left\",\"title_align\":\"left\",\"title_align_mobile\":\"center\",\"align_text_after_buttons_mobile\":\"center\",\"_border_radius\":\"0\",\"title_tag\":\"h3\",\"__globals__\":{\"_background_color\":\"\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"label_color\":\"globals\\/colors?id=secondary\",\"typography_title_typography\":\"globals\\/typography?id=twbb_h3\",\"typography_description_typography\":\"globals\\/typography?id=twbb_p3\",\"label_typography_typography\":\"globals\\/typography?id=twbb_p3\",\"html_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"field_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"html_color\":\"globals\\/colors?id=text\",\"field_text_color\":\"globals\\/colors?id=twbb_button\",\"field_background_color\":\"globals\\/colors?id=twbb_bg_primary\",\"button_typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_background_color\":\"globals\\/colors?id=accent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_accent_hover\",\"button_border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_accent_hover\",\"field_border_color\":\"globals\\/colors?id=twbb_button\"},\"button_border_border\":\"solid\",\"button_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"field_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"field_border_border\":\"solid\",\"step_next_label\":\"Next\",\"step_previous_label\":\"Previous\",\"reset_button_text\":\"Reset\",\"email_content\":\"[all-fields]\",\"email_content_2\":\"[all-fields]\",\"success_message\":\"The form was sent successfully.\",\"error_message\":\"An error occurred.\",\"required_field_message\":\"This field is required.\",\"invalid_message\":\"There&#039;s something wrong. The form is invalid.\",\"button_align\":\"left\"},\"elType\":\"widget\",\"widgetType\":\"twbb_form\",\"id\":\"ts25afhx\"}]}],\"isInner\":\"false\"},{\"id\":\"d481d3f\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/contact\\/contact_8\\/align-left--background_color_type-none--background_media_type-none--cards_type-no_contrast--form-yes.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Contact\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_gap\":{\"column\":\"60\",\"row\":\"60\",\"isLinked\":true,\"unit\":\"px\",\"size\":60},\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"aerz5yj0\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"form_name\":\"Get in Touch\",\"form_description\":\"We\'re here to help with any questions or support.\",\"button_text\":\"Submit\",\"button_width\":\"100\",\"button_text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"button_align_mobile\":\"stretch\",\"form_fields\":[{\"custom_id\":\"name\",\"field_type\":\"text\",\"field_label\":\"Name\",\"required\":\"true\",\"placeholder\":\"Enter your name\"},{\"custom_id\":\"email\",\"field_type\":\"email\",\"field_label\":\"Email\",\"placeholder\":\"Enter your email\",\"required\":\"true\"},{\"custom_id\":\"message\",\"field_type\":\"textarea\",\"field_label\":\"Message\",\"placeholder\":\"Type your message\",\"required\":\"true\"},{\"custom_id\":\"acceptance\",\"field_type\":\"acceptance\",\"acceptance_text\":\"I accept the Terms\",\"required\":\"true\"}],\"row_gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"column_gap\":{\"size\":\"20\",\"unit\":\"px\",\"sizes\":[]},\"label_spacing\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"align_description\":\"left\",\"align_description_mobile\":\"center\",\"_align\":\"left\",\"title_align\":\"left\",\"title_align_mobile\":\"center\",\"align_text_after_buttons_mobile\":\"center\",\"_border_radius\":\"0\",\"title_tag\":\"h3\",\"__globals__\":{\"_background_color\":\"\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"label_color\":\"globals\\/colors?id=secondary\",\"typography_title_typography\":\"globals\\/typography?id=twbb_h3\",\"typography_description_typography\":\"globals\\/typography?id=twbb_p3\",\"label_typography_typography\":\"globals\\/typography?id=twbb_p3\",\"html_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"field_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"html_color\":\"globals\\/colors?id=text\",\"field_text_color\":\"globals\\/colors?id=twbb_button\",\"field_background_color\":\"globals\\/colors?id=twbb_bg_primary\",\"button_typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_background_color\":\"globals\\/colors?id=accent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_accent_hover\",\"button_border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_accent_hover\",\"field_border_color\":\"globals\\/colors?id=twbb_button\"},\"button_border_border\":\"solid\",\"button_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"field_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"field_border_border\":\"solid\",\"step_next_label\":\"Next\",\"step_previous_label\":\"Previous\",\"reset_button_text\":\"Reset\",\"email_content\":\"[all-fields]\",\"email_content_2\":\"[all-fields]\",\"success_message\":\"The form was sent successfully.\",\"error_message\":\"An error occurred.\",\"required_field_message\":\"This field is required.\",\"invalid_message\":\"There&#039;s something wrong. The form is invalid.\",\"display_form_title_description\":\"yes\",\"button_align\":\"left\"},\"elType\":\"widget\",\"widgetType\":\"twbb_form\",\"id\":\"lp6wumms\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"address\":\"350 Fifth Avenue, New York, US\",\"zoom\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"height\":{\"unit\":\"px\",\"size\":570,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"google_maps\",\"id\":\"u6kw2dnc\"}]}],\"isInner\":\"false\"},{\"id\":\"7a2ee5a\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/cta\\/cta_13\\/align-left--background_color_type-neutral--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Call to action\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_gap\":{\"column\":\"60\",\"row\":\"60\",\"isLinked\":true,\"unit\":\"px\",\"size\":60},\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"__globals__\":{\"background_color\":\"globals\\/colors?id=twbb_bg_3\"},\"background_background\":\"classic\",\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"7sdon503\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"title\":\"Act Now to Grow Your Brand\",\"header_size\":\"h2\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"zexo0agc\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"twbb_title\":\"\",\"twbb_description\":\"Unlock the full potential of your brand by partnering with us.\\nMake changes and add your own text.\",\"twbb_title_tag\":\"h3\",\"twbb_button_one\":\"Learn More\",\"twbb_button_two\":\"Get Started\",\"twbb_button_padding_one\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_button_padding_two\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_position_button\":\"horizontal\",\"twbb_buttons_position\":\"bottom\",\"twbb_title_spacing\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"twbb_title_spacing_tablet\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"twbb_title_spacing_mobile\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"twbb_button_margin_one\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"20\",\"isLinked\":false},\"twbb_button_margin_one_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_alignment\":\"left\",\"twbb_alignment_tablet\":\"left\",\"twbbbuttons_horizontal_alignment\":\"left\",\"twbbbuttons_horizontal_alignment_mobile\":\"center\",\"twbbbuttons_horizontal_alignment_tablet\":\"left\",\"twbb_position_button_mobile\":\"column\",\"__globals__\":{\"twbb_title_typography_typography\":\"globals\\/typography?id=twbb_h3\",\"twbb_title_color\":\"globals\\/colors?id=primary\",\"twbb_description_typography_typography\":\"globals\\/typography?id=twbb_p3\",\"twbb_description_color\":\"globals\\/colors?id=text\",\"twbb_button_typography_one_typography\":\"globals\\/typography?id=accent\",\"twbb_button_text_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_background_color_one\":\"globals\\/colors?id=accent\",\"twbb_button_hover_background_color_one\":\"globals\\/colors?id=twbb_accent_hover\",\"twbb_button_hover_border_color_one\":\"globals\\/colors?id=twbb_accent_hover\",\"_background_color\":\"globals\\/colors?id=twbb_transparent\",\"twbb_button_hover_text_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_border_color_one\":\"globals\\/colors?id=accent\",\"twbb_button_typography_two_typography\":\"globals\\/typography?id=accent\",\"twbb_button_text_color_two\":\"globals\\/colors?id=accent\",\"twbb_button_background_color_two\":\"globals\\/colors?id=twbb_transparent\",\"twbb_button_hover_background_color_two\":\"globals\\/colors?id=accent\",\"twbb_button_hover_text_color_two\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_border_color_two\":\"globals\\/colors?id=accent\",\"twbb_button_hover_border_color_two\":\"globals\\/colors?id=accent\"},\"twbb_vertical_position\":\"top\",\"graphic_element\":\"none\",\"twbb_button_border_width_one\":{\"size\":\"1\",\"unit\":\"px\",\"sizes\":[]},\"twbb_enable_button_two\":\"yes\",\"twbb_button_border_width_two\":{\"size\":\"1\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"twbb_call-to-action\",\"id\":\"0bnqucsl\"}]}],\"isInner\":\"false\"},{\"id\":\"1367d74\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/cta\\/cta_25\\/align-center--background_color_type-neutral--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Call to action\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"__globals__\":{\"background_color\":\"globals\\/colors?id=twbb_bg_3\"},\"background_background\":\"classic\",\"flex_justify_content\":\"center\",\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"5fr6333d\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"twbb_title\":\"Elevate Your Brand with Us\",\"twbb_description\":\"Unlock the full potential of your brand by partnering with us.\\nMake changes and add your own text.\",\"twbb_title_tag\":\"h1\",\"twbb_button_one\":\"Learn More\",\"twbb_button_two\":\"Get Started\",\"twbb_button_padding_one\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_button_padding_two\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_position_button\":\"horizontal\",\"twbb_buttons_position\":\"bottom\",\"twbb_title_spacing\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"twbb_title_spacing_tablet\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"twbb_title_spacing_mobile\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"twbb_button_margin_one\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"20\",\"isLinked\":false},\"twbb_button_margin_one_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_alignment\":\"center\",\"twbb_alignment_tablet\":\"center\",\"twbbbuttons_horizontal_alignment\":\"center\",\"twbbbuttons_horizontal_alignment_mobile\":\"center\",\"twbbbuttons_horizontal_alignment_tablet\":\"center\",\"twbb_position_button_mobile\":\"column\",\"__globals__\":{\"twbb_title_typography_typography\":\"globals\\/typography?id=primary\",\"twbb_title_color\":\"globals\\/colors?id=primary\",\"twbb_description_typography_typography\":\"globals\\/typography?id=twbb_p1\",\"twbb_description_color\":\"globals\\/colors?id=text\",\"twbb_button_typography_one_typography\":\"globals\\/typography?id=accent\",\"twbb_button_text_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_background_color_one\":\"globals\\/colors?id=accent\",\"twbb_button_hover_background_color_one\":\"globals\\/colors?id=twbb_accent_hover\",\"twbb_button_hover_border_color_one\":\"globals\\/colors?id=twbb_accent_hover\",\"_background_color\":\"globals\\/colors?id=twbb_transparent\",\"twbb_button_hover_text_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_border_color_one\":\"globals\\/colors?id=accent\",\"twbb_button_typography_two_typography\":\"globals\\/typography?id=accent\",\"twbb_button_text_color_two\":\"globals\\/colors?id=accent\",\"twbb_button_background_color_two\":\"globals\\/colors?id=twbb_transparent\",\"twbb_button_hover_background_color_two\":\"globals\\/colors?id=accent\",\"twbb_button_hover_text_color_two\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_border_color_two\":\"globals\\/colors?id=accent\",\"twbb_button_hover_border_color_two\":\"globals\\/colors?id=accent\"},\"twbb_vertical_position\":\"top\",\"graphic_element\":\"none\",\"twbb_button_border_width_one\":{\"size\":\"1\",\"unit\":\"px\",\"sizes\":[]},\"twbb_enable_button_two\":\"yes\",\"twbb_button_border_width_two\":{\"size\":\"1\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"twbb_call-to-action\",\"id\":\"r9jyoijc\"}]}],\"isInner\":\"false\"},{\"id\":\"4dcf027\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/cta\\/cta_27\\/align-center--background_color_type-neutral--background_media_type-image--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Call to action\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"__globals__\":{\"background_color\":\"globals\\/colors?id=twbb_bg_inv\"},\"background_background\":\"classic\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_image\":{\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-bg-cta2.webp\",\"id\":26,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_overlay_opacity\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"background_overlay_background\":\"gradient\",\"background_overlay_color\":\"#00000000\",\"background_overlay_color_b\":\"#0000009C\",\"background_overlay_gradient_angle\":{\"unit\":\"deg\",\"size\":270,\"sizes\":[]},\"background_motion_fx_motion_fx_scrolling\":\"yes\",\"background_motion_fx_scale_effect\":\"yes\",\"background_motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"flex_justify_content\":\"center\",\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"hsfpyq5e\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"twbb_title\":\"Transform Your Business\",\"twbb_description\":\"Join the leaders for cutting-edge solutions.\\nMake changes and add your own text.\",\"twbb_title_tag\":\"h1\",\"twbb_button_one\":\"Learn More\",\"twbb_button_two\":\"Get Started\",\"twbb_button_padding_one\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_button_padding_two\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_position_button\":\"horizontal\",\"twbb_buttons_position\":\"bottom\",\"twbb_title_spacing\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"twbb_title_spacing_tablet\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"twbb_title_spacing_mobile\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"twbb_button_margin_one\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"20\",\"isLinked\":false},\"twbb_button_margin_one_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_alignment\":\"center\",\"twbb_alignment_tablet\":\"center\",\"twbbbuttons_horizontal_alignment\":\"center\",\"twbbbuttons_horizontal_alignment_mobile\":\"center\",\"twbbbuttons_horizontal_alignment_tablet\":\"center\",\"twbb_position_button_mobile\":\"column\",\"__globals__\":{\"twbb_title_typography_typography\":\"globals\\/typography?id=primary\",\"twbb_title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"twbb_description_typography_typography\":\"globals\\/typography?id=twbb_p1\",\"twbb_description_color\":\"globals\\/colors?id=twbb_text_inv\",\"twbb_button_typography_one_typography\":\"globals\\/typography?id=accent\",\"twbb_button_text_color_one\":\"globals\\/colors?id=twbb_button\",\"twbb_button_background_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_hover_background_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_hover_border_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"_background_color\":\"globals\\/colors?id=twbb_transparent\",\"twbb_button_hover_text_color_one\":\"globals\\/colors?id=twbb_button\",\"twbb_button_border_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_typography_two_typography\":\"globals\\/typography?id=accent\",\"twbb_button_text_color_two\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_background_color_two\":\"globals\\/colors?id=twbb_transparent\",\"twbb_button_hover_background_color_two\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_hover_text_color_two\":\"globals\\/colors?id=twbb_button\",\"twbb_button_border_color_two\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_hover_border_color_two\":\"globals\\/colors?id=twbb_button_inv\"},\"twbb_vertical_position\":\"top\",\"graphic_element\":\"none\",\"twbb_button_border_width_one\":{\"size\":\"1\",\"unit\":\"px\",\"sizes\":[]},\"twbb_enable_button_two\":\"yes\",\"twbb_button_border_width_two\":{\"size\":\"1\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"twbb_call-to-action\",\"id\":\"rf01wevc\"}]}],\"isInner\":\"false\"},{\"id\":\"b5948bf\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/cta\\/cta_29\\/align-center--background_color_type-primary--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Call to action\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"__globals__\":{\"background_color\":\"globals\\/colors?id=accent\"},\"background_background\":\"classic\",\"flex_justify_content\":\"center\",\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"o7kxqs3l\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"twbb_title\":\"Lead with Confidence\",\"twbb_description\":\"Unlock the full potential of your brand by partnering with us.\\nMake changes and add your own text.\",\"twbb_title_tag\":\"h1\",\"twbb_button_one\":\"Learn More\",\"twbb_button_two\":\"Get Started\",\"twbb_button_padding_one\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_button_padding_two\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_position_button\":\"horizontal\",\"twbb_buttons_position\":\"bottom\",\"twbb_title_spacing\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"twbb_title_spacing_tablet\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"twbb_title_spacing_mobile\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"twbb_button_margin_one\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"20\",\"isLinked\":false},\"twbb_button_margin_one_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_alignment\":\"center\",\"twbb_alignment_tablet\":\"center\",\"twbbbuttons_horizontal_alignment\":\"center\",\"twbbbuttons_horizontal_alignment_mobile\":\"center\",\"twbbbuttons_horizontal_alignment_tablet\":\"center\",\"twbb_position_button_mobile\":\"column\",\"__globals__\":{\"twbb_title_typography_typography\":\"globals\\/typography?id=primary\",\"twbb_title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"twbb_description_typography_typography\":\"globals\\/typography?id=twbb_p1\",\"twbb_description_color\":\"globals\\/colors?id=twbb_text_inv\",\"twbb_button_typography_one_typography\":\"globals\\/typography?id=accent\",\"twbb_button_text_color_one\":\"globals\\/colors?id=twbb_button\",\"twbb_button_background_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_hover_background_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_hover_border_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"_background_color\":\"globals\\/colors?id=twbb_transparent\",\"twbb_button_hover_text_color_one\":\"globals\\/colors?id=twbb_button\",\"twbb_button_border_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_typography_two_typography\":\"globals\\/typography?id=accent\",\"twbb_button_text_color_two\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_background_color_two\":\"globals\\/colors?id=twbb_transparent\",\"twbb_button_hover_background_color_two\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_hover_text_color_two\":\"globals\\/colors?id=twbb_button\",\"twbb_button_border_color_two\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_hover_border_color_two\":\"globals\\/colors?id=twbb_button_inv\"},\"twbb_vertical_position\":\"top\",\"graphic_element\":\"none\",\"twbb_button_border_width_one\":{\"size\":\"1\",\"unit\":\"px\",\"sizes\":[]},\"twbb_enable_button_two\":\"yes\",\"twbb_button_border_width_two\":{\"size\":\"1\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"twbb_call-to-action\",\"id\":\"wy3equ9o\"}]}],\"isInner\":\"false\"},{\"id\":\"b925350\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/cta\\/cta_39\\/background_color_type-none--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"s1315meg\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"6163xa9s\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"iusfktft\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"10\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"title\":\"Act Now to Grow Your Brand\",\"header_size\":\"h2\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"qrqrxpec\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"10\",\"bottom\":\"10\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Unlock the full potential of your brand by partnering with us. Make changes and add your own text.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"emfkd9hm\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"c94zjrm5\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"text\":\"Get Started\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"right\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"background_color\":\"globals\\/colors?id=accent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_accent_hover\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_accent_hover\",\"hover_color\":\"globals\\/colors?id=twbb_button_inv\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"xqsztdkw\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"text\":\"Learn More\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"right\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=accent\",\"background_color\":\"globals\\/colors?id=twbb_transparent\",\"button_background_hover_color\":\"globals\\/colors?id=accent\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=accent\",\"hover_color\":\"globals\\/colors?id=twbb_button_inv\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"wlbo2m4a\"}]}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_margin\":{\"left\":\"10\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-product2.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"8aq6vqo1\"}]}]}],\"isInner\":\"false\"},{\"id\":\"5da428a\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/cta\\/cta_5\\/align-left--background_color_type-primary--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Call to action\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"__globals__\":{\"background_color\":\"globals\\/colors?id=accent\"},\"background_background\":\"classic\",\"flex_justify_content\":\"center\",\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"iwqxteb2\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"twbb_title\":\"Boost Your Reach\",\"twbb_description\":\"Experience dynamic growth and expanded market reach with us.\\nMake changes and add your own text.\",\"twbb_title_tag\":\"h1\",\"twbb_button_one\":\"Learn More\",\"twbb_button_two\":\"Get Started\",\"twbb_button_padding_one\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_button_padding_two\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_position_button\":\"horizontal\",\"twbb_buttons_position\":\"bottom\",\"twbb_title_spacing\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"twbb_title_spacing_tablet\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"twbb_title_spacing_mobile\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"twbb_button_margin_one\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"20\",\"isLinked\":false},\"twbb_button_margin_one_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_alignment\":\"left\",\"twbb_alignment_tablet\":\"left\",\"twbbbuttons_horizontal_alignment\":\"left\",\"twbbbuttons_horizontal_alignment_mobile\":\"center\",\"twbbbuttons_horizontal_alignment_tablet\":\"left\",\"twbb_position_button_mobile\":\"column\",\"__globals__\":{\"twbb_title_typography_typography\":\"globals\\/typography?id=primary\",\"twbb_title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"twbb_description_typography_typography\":\"globals\\/typography?id=twbb_p1\",\"twbb_description_color\":\"globals\\/colors?id=twbb_text_inv\",\"twbb_button_typography_one_typography\":\"globals\\/typography?id=accent\",\"twbb_button_text_color_one\":\"globals\\/colors?id=twbb_button\",\"twbb_button_background_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_hover_background_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_hover_border_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"_background_color\":\"globals\\/colors?id=twbb_transparent\",\"twbb_button_hover_text_color_one\":\"globals\\/colors?id=twbb_button\",\"twbb_button_border_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_typography_two_typography\":\"globals\\/typography?id=accent\",\"twbb_button_text_color_two\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_background_color_two\":\"globals\\/colors?id=twbb_transparent\",\"twbb_button_hover_background_color_two\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_hover_text_color_two\":\"globals\\/colors?id=twbb_button\",\"twbb_button_border_color_two\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_hover_border_color_two\":\"globals\\/colors?id=twbb_button_inv\"},\"twbb_vertical_position\":\"top\",\"graphic_element\":\"none\",\"twbb_button_border_width_one\":{\"size\":\"1\",\"unit\":\"px\",\"sizes\":[]},\"twbb_enable_button_two\":\"yes\",\"twbb_button_border_width_two\":{\"size\":\"1\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"twbb_call-to-action\",\"id\":\"ijw0lm6a\"}]}],\"isInner\":\"false\"},{\"id\":\"84d83a5\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/ecom_banner\\/ecom_banner_1\\/align-center--background_color_type-dark--background_media_type-image--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section twbb_full_h\",\"_title\":\"Ecommerce Banner\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"min_height\":{\"size\":\"80\",\"unit\":\"vh\",\"sizes\":[]},\"min_height_mobile\":{\"size\":\"64.0\",\"unit\":\"vh\",\"sizes\":[]},\"__globals__\":{\"background_color\":\"globals\\/colors?id=twbb_bg_inv\"},\"background_background\":\"classic\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_image\":{\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-bg-hero.webp\",\"id\":27,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_overlay_opacity\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"background_overlay_background\":\"gradient\",\"background_overlay_color\":\"#00000000\",\"background_overlay_color_b\":\"#0000009C\",\"background_overlay_gradient_angle\":{\"unit\":\"deg\",\"size\":270,\"sizes\":[]},\"background_motion_fx_motion_fx_scrolling\":\"yes\",\"background_motion_fx_scale_effect\":\"yes\",\"background_motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"emnf9xfz\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"5ugmqrzh\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Explore Amazing Products Tailored for You!\",\"header_size\":\"h2\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"xbxk104m\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Explore fantastic offers that make shopping effortless and convenient. Discover items that fit seamlessly into your everyday routine.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=twbb_text_inv\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"cp9rm2ug\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"text\":\"See What\\u2019s New\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"background_color\":\"globals\\/colors?id=twbb_transparent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"border_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"hover_color\":\"globals\\/colors?id=twbb_button\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"shfhhj84\"}]}]}],\"isInner\":\"false\"},{\"id\":\"b583ec1\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/ecom_banner\\/ecom_banner_2\\/background_color_type-neutral--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"css_classes\":\"twbb_section twbb_full_h\",\"_title\":\"Ecommerce Banner\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_gap\":{\"column\":\"0\",\"row\":\"20\",\"isLinked\":false,\"unit\":\"px\",\"size\":\"0\"},\"min_height\":{\"size\":\"80\",\"unit\":\"vh\",\"sizes\":[]},\"min_height_mobile\":{\"size\":\"64.0\",\"unit\":\"vh\",\"sizes\":[]},\"__globals__\":{\"background_color\":\"globals\\/colors?id=twbb_bg_3\"},\"background_background\":\"classic\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"4yxgoiam\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"calc(50vw - 640.0px)\",\"right\":\"30px\",\"top\":\"80px\",\"bottom\":\"80px\",\"unit\":\"custom\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_justify_content\":\"center\",\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"ets0517k\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Elevate Your Everyday Essentials\",\"header_size\":\"h2\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"9lnw5s4d\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Browse through our wide range of carefully selected products that cater to all your needs. Whether you\'re looking for the latest trends or timeless essentials, we have something for everyone. Experience quality and value that fit seamlessly into your life.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"xyopm9yh\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"text\":\"Explore Our Collection\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=accent\",\"background_color\":\"globals\\/colors?id=twbb_transparent\",\"button_background_hover_color\":\"globals\\/colors?id=accent\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=accent\",\"hover_color\":\"globals\\/colors?id=twbb_button_inv\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"bucbwfma\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-feature8.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"height\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"object-fit\":\"cover\"},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"ga0u01i4\"}]}],\"isInner\":\"false\"},{\"id\":\"aa78b09\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/ecom_brands\\/ecom_brands_3b\\/background_color_type-none--background_media_type-none--cards_type-no_contrast--layout-slider.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Logos\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"7kfyy3py\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"title\":\"Trusted by the following companies\",\"header_size\":\"h4\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"5k8lqfya\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"twbb_dummy\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"button_border_width\":{\"unit\":\"px\",\"size\":\"1\",\"sizes\":[]},\"slides_height\":{\"unit\":\"px\",\"size\":64,\"sizes\":[]},\"images_slides_height\":{\"unit\":\"px\",\"size\":64,\"sizes\":[]},\"navigation\":\"none\",\"content_max_width\":{\"size\":\"100\",\"unit\":\"%\",\"sizes\":[]},\"slides\":[{\"_id\":\"equvdwof\",\"heading\":\"\",\"description\":\"\",\"button_text\":\"\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"background_image\":{\"id\":\"\",\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/Nike.svg\",\"alt\":\"\",\"source\":\"url\"},\"background_overlay_color\":\"rgba(51,51,51,0.5)\",\"background_color\":\"\",\"background_size\":\"contain\"},{\"_id\":\"ukhajod4\",\"heading\":\"\",\"description\":\"\",\"button_text\":\"\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"background_image\":{\"id\":\"\",\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/Adidas.svg\",\"alt\":\"\",\"source\":\"url\"},\"background_overlay_color\":\"rgba(51,51,51,0.5)\",\"background_color\":\"\",\"background_size\":\"contain\"},{\"_id\":\"9pkx54wo\",\"heading\":\"\",\"description\":\"\",\"button_text\":\"\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"background_image\":{\"id\":\"\",\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/Converse.svg\",\"alt\":\"\",\"source\":\"url\"},\"background_overlay_color\":\"rgba(51,51,51,0.5)\",\"background_color\":\"\",\"background_size\":\"contain\"},{\"_id\":\"6cc0qook\",\"heading\":\"\",\"description\":\"\",\"button_text\":\"\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"background_image\":{\"id\":\"\",\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/Sketchers.svg\",\"alt\":\"\",\"source\":\"url\"},\"background_overlay_color\":\"rgba(51,51,51,0.5)\",\"background_color\":\"\",\"background_size\":\"contain\"},{\"_id\":\"mevzmu86\",\"heading\":\"\",\"description\":\"\",\"button_text\":\"\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"background_image\":{\"id\":\"\",\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/Puma.svg\",\"alt\":\"\",\"source\":\"url\"},\"background_overlay_color\":\"rgba(51,51,51,0.5)\",\"background_color\":\"\",\"background_size\":\"contain\"},{\"_id\":\"hj0vdqyo\",\"heading\":\"\",\"description\":\"\",\"button_text\":\"\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"background_image\":{\"id\":\"\",\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/Reebok.svg\",\"alt\":\"\",\"source\":\"url\"},\"background_overlay_color\":\"rgba(51,51,51,0.5)\",\"background_color\":\"\",\"background_size\":\"contain\"}],\"slider_inner_position\":\"outside\",\"slides_horizontal_position\":\"center\",\"slides_text_align\":\"center\",\"heading_spacing\":{\"unit\":\"px\",\"size\":\"20\",\"sizes\":[]},\"description_spacing\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"space_between\":{\"unit\":\"px\",\"size\":72,\"sizes\":[]},\"__globals__\":{\"heading_typography_typography\":\"globals\\/typography?id=secondary\",\"description_typography_typography\":\"globals\\/typography?id=text\",\"button_typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=accent\",\"button_background_color\":\"globals\\/colors?id=twbb_transparent\",\"heading_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"arrows_color\":\"globals\\/colors?id=twbb_bg_inv\",\"dots_color\":\"globals\\/colors?id=twbb_bg_inv\",\"button_border_color\":\"globals\\/colors?id=accent\",\"button_hover_background_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=accent\",\"button_hover_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"_background_color\":\"globals\\/colors?id=twbb_bg_primary\"},\"slides_per_view\":6,\"slides_per_view_mobile\":3,\"autoplay_speed\":0,\"content_animation\":\"\",\"transition_speed\":5000,\"space_between_mobile\":{\"unit\":\"px\",\"size\":36,\"sizes\":[]},\"speed_liner\":\"yes\",\"_background_background\":\"classic\"},\"elType\":\"widget\",\"widgetType\":\"twbb_slides\",\"id\":\"oteurrao\"}]}],\"isInner\":\"false\"},{\"id\":\"a608779\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/faq\\/faq_2\\/background_color_type-none--background_media_type-none--cards_type-no_contrast--layout-wide.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"FAQ\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"8kgk682x\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"title\":\"FAQs\",\"header_size\":\"h2\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"ry2yjpid\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Explore frequently asked questions about our services.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"4v3srjj3\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"tabs\":[{\"tab_title\":\"What services do you offer?\",\"tab_content\":\"Add a comprehensive list of the services you offer. This could include various categories such as consultation services, product development, customer support and after-sales services, among others.\"},{\"tab_title\":\"What payment methods do you accept?\",\"tab_content\":\"We accept payment via credit card (Visa, MasterCard, American Express), PayPal, and bank transfer.\"},{\"tab_title\":\"DO you offer a guarantee on your services?\",\"tab_content\":\"Yes, we offer a [time period] guarantee on all our services. This ensures that you receive the quality and reliability you expect from us.\"},{\"tab_title\":\"How to get started with you?\",\"tab_content\":\"Contact us through our website or call us directly to discuss your needs and how we can help.\"}],\"__globals__\":{\"title_typography_typography\":\"globals\\/typography?id=twbb_h5\",\"content_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"title_color\":\"globals\\/colors?id=primary\",\"content_color\":\"globals\\/colors?id=text\",\"tab_active_color\":\"globals\\/colors?id=accent\",\"icon_color\":\"globals\\/colors?id=secondary\",\"icon_active_color\":\"globals\\/colors?id=primary\"},\"title_padding\":{\"unit\":\"px\",\"top\":\"14\",\"right\":\"14\",\"bottom\":\"14\",\"left\":\"0\",\"isLinked\":false},\"title_padding_mobile\":{\"unit\":\"px\",\"top\":\"14\",\"right\":\"14\",\"bottom\":\"14\",\"left\":\"0\",\"isLinked\":false},\"content_padding\":{\"unit\":\"px\",\"top\":\"14\",\"right\":\"14\",\"bottom\":\"14\",\"left\":\"0\",\"isLinked\":false},\"content_padding_mobile\":{\"unit\":\"px\",\"top\":\"14\",\"right\":\"14\",\"bottom\":\"14\",\"left\":\"0\",\"isLinked\":false},\"selected_icon\":{\"value\":\"fas fa-chevron-down\",\"library\":\"fa-solid\"},\"selected_active_icon\":{\"value\":\"fas fa-chevron-up\",\"library\":\"fa-solid\"},\"icon_align\":\"right\",\"_border_border\":\"solid\",\"_border_color\":\"#000000\",\"_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"bottom\":0,\"right\":0,\"left\":0,\"isLinked\":false},\"border_width\":{\"unit\":\"px\",\"size\":\"1\",\"sizes\":[]},\"border_color\":\"#000000\"},\"elType\":\"widget\",\"widgetType\":\"toggle\",\"id\":\"d2jqr4nv\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"60\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"60\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"twbb_title\":\"Get in Touch\",\"twbb_description\":\"For more detailed inquiries, please contact our support team.\",\"twbb_title_tag\":\"h1\",\"twbb_button_one\":\"Contact Us\",\"twbb_button_two\":\"\",\"twbb_button_padding_one\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_button_padding_two\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_position_button\":\"horizontal\",\"twbb_buttons_position\":\"bottom\",\"twbb_title_spacing\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"twbb_title_spacing_tablet\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"twbb_title_spacing_mobile\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"twbb_button_margin_one\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"20\",\"isLinked\":false},\"twbb_button_margin_one_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_alignment\":\"left\",\"twbb_alignment_tablet\":\"left\",\"twbbbuttons_horizontal_alignment\":\"left\",\"twbbbuttons_horizontal_alignment_mobile\":\"center\",\"twbbbuttons_horizontal_alignment_tablet\":\"left\",\"twbb_position_button_mobile\":\"column\",\"__globals__\":{\"twbb_title_typography_typography\":\"globals\\/typography?id=primary\",\"twbb_title_color\":\"globals\\/colors?id=primary\",\"twbb_description_typography_typography\":\"globals\\/typography?id=twbb_p1\",\"twbb_description_color\":\"globals\\/colors?id=text\",\"twbb_button_typography_one_typography\":\"globals\\/typography?id=accent\",\"twbb_button_text_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_background_color_one\":\"globals\\/colors?id=accent\",\"twbb_button_hover_background_color_one\":\"globals\\/colors?id=twbb_accent_hover\",\"twbb_button_hover_border_color_one\":\"globals\\/colors?id=twbb_accent_hover\",\"_background_color\":\"globals\\/colors?id=twbb_transparent\",\"twbb_button_hover_text_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_border_color_one\":\"globals\\/colors?id=accent\"},\"twbb_vertical_position\":\"top\",\"graphic_element\":\"none\",\"twbb_button_border_width_one\":{\"size\":\"1\",\"unit\":\"px\",\"sizes\":[]},\"twbb_enable_button_two\":\"\"},\"elType\":\"widget\",\"widgetType\":\"twbb_call-to-action\",\"id\":\"5q199my1\"}]}],\"isInner\":\"false\"},{\"id\":\"77c656f\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/faq\\/faq_3\\/background_color_type-none--background_media_type-none--cards_type-no_contrast--layout-wide.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"FAQ\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_gap\":{\"column\":\"60\",\"row\":\"60\",\"isLinked\":true,\"unit\":\"px\",\"size\":60},\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"dfng76kr\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"twbb_title\":\"FAQs\",\"twbb_description\":\"Delve into our FAQ section to get quick answers to common questions about our services.\",\"twbb_title_tag\":\"h1\",\"twbb_button_one\":\"\",\"twbb_button_two\":\"Contact Us\",\"twbb_button_padding_one\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_button_padding_two\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_position_button\":\"horizontal\",\"twbb_buttons_position\":\"bottom\",\"twbb_title_spacing\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"twbb_title_spacing_tablet\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"twbb_title_spacing_mobile\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"twbb_button_margin_one\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_one_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_alignment\":\"left\",\"twbb_alignment_tablet\":\"left\",\"twbbbuttons_horizontal_alignment\":\"left\",\"twbbbuttons_horizontal_alignment_mobile\":\"center\",\"twbbbuttons_horizontal_alignment_tablet\":\"left\",\"twbb_position_button_mobile\":\"column\",\"__globals__\":{\"twbb_title_typography_typography\":\"globals\\/typography?id=primary\",\"twbb_title_color\":\"globals\\/colors?id=primary\",\"twbb_description_typography_typography\":\"globals\\/typography?id=twbb_p1\",\"twbb_description_color\":\"globals\\/colors?id=text\",\"twbb_button_typography_one_typography\":\"globals\\/typography?id=accent\",\"twbb_button_text_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_background_color_one\":\"globals\\/colors?id=accent\",\"twbb_button_hover_background_color_one\":\"globals\\/colors?id=twbb_accent_hover\",\"twbb_button_hover_border_color_one\":\"globals\\/colors?id=twbb_accent_hover\",\"_background_color\":\"globals\\/colors?id=twbb_transparent\",\"twbb_button_hover_text_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_border_color_one\":\"globals\\/colors?id=accent\",\"twbb_button_typography_two_typography\":\"globals\\/typography?id=accent\",\"twbb_button_text_color_two\":\"globals\\/colors?id=accent\",\"twbb_button_background_color_two\":\"globals\\/colors?id=twbb_transparent\",\"twbb_button_hover_background_color_two\":\"globals\\/colors?id=accent\",\"twbb_button_hover_text_color_two\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_border_color_two\":\"globals\\/colors?id=accent\",\"twbb_button_hover_border_color_two\":\"globals\\/colors?id=accent\"},\"twbb_vertical_position\":\"top\",\"graphic_element\":\"none\",\"twbb_enable_button_one\":\"\",\"twbb_button_border_width_one\":{\"size\":\"1\",\"unit\":\"px\",\"sizes\":[]},\"twbb_enable_button_two\":\"yes\",\"twbb_button_border_width_two\":{\"size\":\"1\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"twbb_call-to-action\",\"id\":\"ik4cfa9y\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"tabs\":[{\"tab_title\":\"What makes you different?\",\"tab_content\":\"Describe what sets your company apart from others in the industry.\"},{\"tab_title\":\"What services do you offer?\",\"tab_content\":\"Add a comprehensive list of the services you offer.\"},{\"tab_title\":\"What payment methods do you accept?\",\"tab_content\":\"We accept payment via credit card (Visa, MasterCard, American Express), PayPal, and bank transfer.\"},{\"tab_title\":\"Where are you located?\",\"tab_content\":\"Add more detailed information about your current location, including your city, state, and country.\"}],\"__globals__\":{\"title_typography_typography\":\"globals\\/typography?id=twbb_h5\",\"content_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"title_color\":\"globals\\/colors?id=primary\",\"content_color\":\"globals\\/colors?id=text\",\"tab_active_color\":\"globals\\/colors?id=accent\",\"icon_color\":\"globals\\/colors?id=secondary\",\"icon_active_color\":\"globals\\/colors?id=primary\"},\"title_padding\":{\"unit\":\"px\",\"top\":\"14\",\"right\":\"14\",\"bottom\":\"14\",\"left\":\"0\",\"isLinked\":false},\"title_padding_mobile\":{\"unit\":\"px\",\"top\":\"14\",\"right\":\"14\",\"bottom\":\"14\",\"left\":\"0\",\"isLinked\":false},\"content_padding\":{\"unit\":\"px\",\"top\":\"14\",\"right\":\"14\",\"bottom\":\"14\",\"left\":\"0\",\"isLinked\":false},\"content_padding_mobile\":{\"unit\":\"px\",\"top\":\"14\",\"right\":\"14\",\"bottom\":\"14\",\"left\":\"0\",\"isLinked\":false},\"selected_icon\":{\"value\":\"fas fa-chevron-down\",\"library\":\"fa-solid\"},\"selected_active_icon\":{\"value\":\"fas fa-chevron-up\",\"library\":\"fa-solid\"},\"icon_align\":\"right\",\"_border_border\":\"solid\",\"_border_color\":\"#000000\",\"_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"bottom\":0,\"right\":0,\"left\":0,\"isLinked\":false},\"border_width\":{\"unit\":\"px\",\"size\":\"1\",\"sizes\":[]},\"border_color\":\"#000000\"},\"elType\":\"widget\",\"widgetType\":\"toggle\",\"id\":\"lubrjv9y\"}]}],\"isInner\":\"false\"},{\"id\":\"b9d36d3\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/gallery\\/gallery_10\\/background_color_type-none--background_media_type-none--cards_type-no_contrast--layout-masonry.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Image Gallery\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"sigpkk8s\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"title\":\"Gallery Title\",\"header_size\":\"h2\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"c1medrpl\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Gallery Brief Description\",\"align\":\"center\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"gvqurpd6\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"gallery\":[{\"id\":28,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-gallery7.webp\",\"description\":\"MOCK_IMAGE_GALLERY7\",\"aspect_ratio\":\"tall\"},{\"id\":29,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-gallery6.webp\",\"description\":\"MOCK_IMAGE_GALLERY6\",\"aspect_ratio\":\"landscape\"},{\"id\":30,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-gallery8.webp\",\"description\":\"MOCK_IMAGE_GALLERY8\",\"aspect_ratio\":\"tall\"},{\"id\":31,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-gallery9.webp\",\"description\":\"MOCK_IMAGE_GALLERY9\",\"aspect_ratio\":\"tall\"},{\"id\":32,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-gallery10.webp\",\"description\":\"MOCK_IMAGE_GALLERY10\",\"aspect_ratio\":\"tall\"}],\"gallery_layout\":\"masonry\",\"gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"hgap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"gap_mobile\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"hgap_mobile\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"columns\":3,\"columns_mobile\":2,\"content_alignment\":\"left\",\"overlay_background\":\"\",\"content_hover_animation\":\"\",\"display_gallery_title_description\":\"\",\"overlay_title\":\"\",\"overlay_description\":\"\",\"link_to\":\"\",\"thumbnail_image_size\":\"full\",\"galleries\":[{\"gallery_title\":\"New Gallery\"}],\"show_all_galleries_label\":\"All\",\"gallery_name\":\"New Gallery\",\"image_border_radius\":{\"size\":\"0\",\"sizes\":[],\"unit\":\"px\"},\"image_hover_animation\":\"grow\",\"lazyload\":\"\"},\"elType\":\"widget\",\"widgetType\":\"twbb_gallery\",\"id\":\"zlv82769\"}]}],\"isInner\":\"false\"},{\"id\":\"fa58b06\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/gallery\\/gallery_5\\/background_color_type-none--background_media_type-none--cards_type-no_contrast--layout-grid.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Image Gallery\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"p9yist7k\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"title\":\"Gallery Title\",\"header_size\":\"h2\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"fs7q5ra2\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Gallery Brief Description\",\"align\":\"center\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"01t9olci\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"gallery\":[{\"id\":33,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-gallery.webp\",\"description\":\"MOCK_IMAGE_GALLERY\",\"aspect_ratio\":\"square\"},{\"id\":34,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-gallery2.webp\",\"description\":\"MOCK_IMAGE_GALLERY2\",\"aspect_ratio\":\"square\"},{\"id\":35,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-gallery3.webp\",\"description\":\"MOCK_IMAGE_GALLERY3\",\"aspect_ratio\":\"square\"},{\"id\":36,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-gallery4.webp\",\"description\":\"MOCK_IMAGE_GALLERY4\",\"aspect_ratio\":\"square\"},{\"id\":37,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-gallery11.webp\",\"description\":\"MOCK_IMAGE_GALLERY11\",\"aspect_ratio\":\"square\"},{\"id\":38,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-gallery12.webp\",\"description\":\"MOCK_IMAGE_GALLERY12\",\"aspect_ratio\":\"square\"}],\"gallery_layout\":\"grid\",\"gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"hgap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"gap_mobile\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"hgap_mobile\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"columns\":3,\"columns_mobile\":2,\"content_alignment\":\"left\",\"overlay_background\":\"\",\"content_hover_animation\":\"\",\"display_gallery_title_description\":\"\",\"overlay_title\":\"\",\"overlay_description\":\"\",\"link_to\":\"\",\"thumbnail_image_size\":\"full\",\"galleries\":[{\"gallery_title\":\"New Gallery\"}],\"show_all_galleries_label\":\"All\",\"gallery_name\":\"New Gallery\",\"image_border_radius\":{\"size\":\"0\",\"sizes\":[],\"unit\":\"px\"},\"aspect_ratio\":\"1:1\",\"image_hover_animation\":\"grow\",\"lazyload\":\"\"},\"elType\":\"widget\",\"widgetType\":\"twbb_gallery\",\"id\":\"p9mwxgwb\"}]}],\"isInner\":\"false\"},{\"id\":\"2b3f6ca\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/gallery\\/gallery_8\\/background_color_type-none--background_media_type-none--cards_type-no_contrast--layout-masonry.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Image Gallery\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"t2vzsnbp\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"title\":\"Gallery Title\",\"header_size\":\"h2\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"2ek9wqzi\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Gallery Brief Description\",\"align\":\"center\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"pxmck3re\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"gallery\":[{\"id\":28,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-gallery7.webp\",\"description\":\"MOCK_IMAGE_GALLERY7\",\"aspect_ratio\":\"tall\"},{\"id\":30,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-gallery8.webp\",\"description\":\"MOCK_IMAGE_GALLERY8\",\"aspect_ratio\":\"tall\"},{\"id\":31,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-gallery9.webp\",\"description\":\"MOCK_IMAGE_GALLERY9\",\"aspect_ratio\":\"tall\"},{\"id\":29,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-gallery6.webp\",\"description\":\"MOCK_IMAGE_GALLERY6\",\"aspect_ratio\":\"landscape\"},{\"id\":38,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-gallery12.webp\",\"description\":\"MOCK_IMAGE_GALLERY12\",\"aspect_ratio\":\"square\"},{\"id\":32,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-gallery10.webp\",\"description\":\"MOCK_IMAGE_GALLERY10\",\"aspect_ratio\":\"tall\"},{\"id\":37,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-gallery11.webp\",\"description\":\"MOCK_IMAGE_GALLERY11\",\"aspect_ratio\":\"square\"}],\"gallery_layout\":\"justified\",\"gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"hgap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"gap_mobile\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"hgap_mobile\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"columns\":2,\"columns_mobile\":2,\"content_alignment\":\"left\",\"overlay_background\":\"\",\"content_hover_animation\":\"\",\"display_gallery_title_description\":\"\",\"overlay_title\":\"\",\"overlay_description\":\"\",\"link_to\":\"\",\"thumbnail_image_size\":\"full\",\"ideal_row_height\":{\"unit\":\"px\",\"size\":400,\"sizes\":[]},\"galleries\":[{\"gallery_title\":\"New Gallery\"}],\"show_all_galleries_label\":\"All\",\"gallery_name\":\"New Gallery\",\"image_border_radius\":{\"size\":\"0\",\"sizes\":[],\"unit\":\"px\"},\"image_hover_animation\":\"grow\",\"lazyload\":\"\"},\"elType\":\"widget\",\"widgetType\":\"twbb_gallery\",\"id\":\"8lmxrr4m\"}]}],\"isInner\":\"false\"},{\"id\":\"0f8a072\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/gallery\\/gallery_9\\/background_color_type-none--background_media_type-none--cards_type-no_contrast--layout-grid.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Image Gallery\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"5z51bsbc\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"title\":\"Gallery Title\",\"header_size\":\"h2\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"lbapldv3\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Gallery Brief Description\",\"align\":\"center\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"br4hn4df\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"p5718in4\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"gallery\":[{\"id\":33,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-gallery.webp\",\"description\":\"MOCK_IMAGE_GALLERY\",\"aspect_ratio\":\"square\"}],\"gallery_layout\":\"grid\",\"gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"hgap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"gap_mobile\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"hgap_mobile\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"columns\":1,\"columns_mobile\":1,\"content_alignment\":\"left\",\"overlay_background\":\"\",\"content_hover_animation\":\"\",\"display_gallery_title_description\":\"\",\"overlay_title\":\"\",\"overlay_description\":\"\",\"link_to\":\"\",\"thumbnail_image_size\":\"full\",\"galleries\":[{\"gallery_title\":\"New Gallery\"}],\"show_all_galleries_label\":\"All\",\"gallery_name\":\"New Gallery\",\"image_border_radius\":{\"size\":\"0\",\"sizes\":[],\"unit\":\"px\"},\"aspect_ratio\":\"1:1\",\"image_hover_animation\":\"grow\",\"lazyload\":\"\"},\"elType\":\"widget\",\"widgetType\":\"twbb_gallery\",\"id\":\"bh7svnsb\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"gallery\":[{\"id\":36,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-gallery4.webp\",\"description\":\"MOCK_IMAGE_GALLERY4\",\"aspect_ratio\":\"square\"},{\"id\":39,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-gallery5.webp\",\"description\":\"MOCK_IMAGE_GALLERY5\",\"aspect_ratio\":\"square\"},{\"id\":34,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-gallery2.webp\",\"description\":\"MOCK_IMAGE_GALLERY2\",\"aspect_ratio\":\"square\"},{\"id\":35,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-gallery3.webp\",\"description\":\"MOCK_IMAGE_GALLERY3\",\"aspect_ratio\":\"square\"}],\"gallery_layout\":\"grid\",\"gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"hgap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"gap_mobile\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"hgap_mobile\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"columns\":2,\"columns_mobile\":2,\"content_alignment\":\"left\",\"overlay_background\":\"\",\"content_hover_animation\":\"\",\"display_gallery_title_description\":\"\",\"overlay_title\":\"\",\"overlay_description\":\"\",\"link_to\":\"\",\"thumbnail_image_size\":\"full\",\"galleries\":[{\"gallery_title\":\"New Gallery\"}],\"show_all_galleries_label\":\"All\",\"gallery_name\":\"New Gallery\",\"image_border_radius\":{\"size\":\"0\",\"sizes\":[],\"unit\":\"px\"},\"aspect_ratio\":\"1:1\",\"image_hover_animation\":\"grow\",\"lazyload\":\"\"},\"elType\":\"widget\",\"widgetType\":\"twbb_gallery\",\"id\":\"z4jvtuo3\"}]}]}],\"isInner\":\"false\"},{\"id\":\"656c40a\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/hero\\/hero_0\\/align-left--background_color_type-dark--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section  twbb-sg-recommended-ecommerce twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section twbb_full_h\",\"_title\":\"Hero\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"min_height\":{\"size\":\"100\",\"unit\":\"vh\",\"sizes\":[]},\"min_height_mobile\":{\"size\":\"80.0\",\"unit\":\"vh\",\"sizes\":[]},\"__globals__\":{\"background_color\":\"globals\\/colors?id=twbb_bg_inv\"},\"background_background\":\"classic\",\"flex_justify_content\":\"center\",\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"xay9umdy\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"button_border_width\":{\"unit\":\"px\",\"size\":\"1\",\"sizes\":[]},\"slides_height\":{\"unit\":\"vh\",\"size\":100,\"sizes\":[]},\"navigation\":\"dots\",\"content_max_width\":{\"size\":66,\"unit\":\"%\",\"sizes\":[]},\"slides\":[{\"_id\":\"r6dntahw\",\"heading\":\"Unlock Amazing Deals Today\",\"description\":\"Shop our exclusive offers and save big on your favorite products. Don\'t wait\\u2014these deals won\'t last long.\",\"button_text\":\"Shop Now & Save\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"background_image\":{\"id\":40,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-service7.webp\",\"alt\":\"\",\"source\":\"library\"},\"background_overlay_color\":\"rgba(51,51,51,0.5)\",\"background_color\":\"\",\"background_ken_burns\":\"yes\",\"background_overlay\":\"yes\",\"background_size\":\"cover\"},{\"_id\":\"yb9hl56y\",\"heading\":\"Your Perfect Finds, Just a Click Away\",\"description\":\"Browse our curated collection and discover top-rated products. Get exactly what you need with fast shipping.\",\"button_text\":\"Browse Now\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"background_image\":{\"id\":41,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-service8.webp\",\"alt\":\"\",\"source\":\"library\"},\"background_overlay_color\":\"rgba(51,51,51,0.5)\",\"background_color\":\"\",\"background_ken_burns\":\"yes\",\"background_overlay\":\"yes\",\"background_size\":\"cover\"},{\"_id\":\"5sib61c4\",\"heading\":\"Get Free Shipping on Every Order\",\"description\":\"Enjoy fast, FREE delivery on all orders. No minimum required\\u2014shop today and get your items delivered at no extra cost.\",\"button_text\":\"Shop & Save Now\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"background_image\":{\"id\":42,\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-service6.webp\",\"alt\":\"\",\"source\":\"library\"},\"background_overlay_color\":\"rgba(51,51,51,0.5)\",\"background_color\":\"\",\"background_ken_burns\":\"yes\",\"background_overlay\":\"yes\",\"background_size\":\"cover\"}],\"slider_inner_position\":\"inside\",\"slides_horizontal_position\":\"left\",\"slides_text_align\":\"left\",\"heading_spacing\":{\"unit\":\"px\",\"size\":\"20\",\"sizes\":[]},\"description_spacing\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"space_between\":{\"size\":0,\"unit\":\"px\",\"sizes\":[]},\"__globals__\":{\"heading_typography_typography\":\"globals\\/typography?id=primary\",\"description_typography_typography\":\"globals\\/typography?id=twbb_p1\",\"button_typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_background_color\":\"globals\\/colors?id=twbb_transparent\",\"heading_color\":\"globals\\/colors?id=twbb_primary_inv\",\"description_color\":\"globals\\/colors?id=twbb_text_inv\",\"arrows_color\":\"globals\\/colors?id=twbb_bg_primary\",\"dots_color\":\"globals\\/colors?id=twbb_bg_primary\",\"button_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_background_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_text_color\":\"globals\\/colors?id=twbb_button\",\"_background_color\":\"globals\\/colors?id=twbb_bg_inv\"},\"slides_per_view\":1,\"slides_per_view_mobile\":1,\"dots_position\":\"inside\",\"autoplay_speed\":2900,\"content_animation\":\"fadeInUp\",\"transition_speed\":500,\"speed_liner\":\"yes\",\"_background_background\":\"classic\"},\"elType\":\"widget\",\"widgetType\":\"twbb_slides\",\"id\":\"s8m7cx2v\"}]}],\"isInner\":\"false\"},{\"id\":\"21c06e1\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/hero\\/hero_19\\/align-left--background_color_type-none--background_media_type-none--cards_type-no_contrast--cta_element-button.json\",\"css_classes\":\"twbb-sg-each-section  twbb-sg-recommended-basic twbb-sg-compatible-basic\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Hero\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"084egcjv\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"30\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-service2.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"dsjmbr34\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"5om4jgtw\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"10\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"title\":\"Welcome\",\"header_size\":\"h1\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"3gr6vw4u\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"10\",\"bottom\":\"10\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Greet your visitors with a brief, captivating introduction. Click to edit and add your own text.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"dj512z1j\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"iff7i1o4\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"text\":\"Get Started\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"background_color\":\"globals\\/colors?id=accent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_accent_hover\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_accent_hover\",\"hover_color\":\"globals\\/colors?id=twbb_button_inv\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"69b2jxc3\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"text\":\"Learn More\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=accent\",\"background_color\":\"globals\\/colors?id=twbb_transparent\",\"button_background_hover_color\":\"globals\\/colors?id=accent\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=accent\",\"hover_color\":\"globals\\/colors?id=twbb_button_inv\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"8qqem8ph\"}]}]}]}],\"isInner\":\"false\"},{\"id\":\"3b5fb33\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/hero\\/hero_26\\/align-center--background_color_type-none--background_media_type-none--cards_type-no_contrast--cta_element-button.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Hero\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_justify_content\":\"center\",\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"17h7srbq\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"title\":\"Welcome to Our Site\",\"header_size\":\"h1\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"rnfv7z6v\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Greet your visitors with a brief, captivating introduction. Click to edit and add your own text.\",\"align\":\"center\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"zadvkaut\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_justify_content\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"9y0g2dsa\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"text\":\"Get Started\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"right\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"background_color\":\"globals\\/colors?id=accent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_accent_hover\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_accent_hover\",\"hover_color\":\"globals\\/colors?id=twbb_button_inv\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"pe72ezy3\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"text\":\"Learn More\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=accent\",\"background_color\":\"globals\\/colors?id=twbb_transparent\",\"button_background_hover_color\":\"globals\\/colors?id=accent\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=accent\",\"hover_color\":\"globals\\/colors?id=twbb_button_inv\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"nagkr887\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-service5.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"jpyshc0m\"}]}],\"isInner\":\"false\"},{\"id\":\"cdbc68e\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/hero\\/hero_27\\/align-center--background_color_type-none--background_media_type-none--cards_type-no_contrast--cta_element-form.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Hero\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_justify_content\":\"center\",\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"pj0femnh\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"title\":\"Welcome to Our Site\",\"header_size\":\"h1\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"hrklrj1x\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Greet your visitors with a brief, captivating introduction. Click to edit and add your own text.\",\"align\":\"center\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"mjb68d8l\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":41,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":41,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"20\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"20\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"form_name\":\"\",\"form_description\":\"\",\"button_text\":\"Sign up\",\"button_width\":\"30\",\"button_text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"button_align_mobile\":\"stretch\",\"form_fields\":[{\"custom_id\":\"email\",\"field_label\":\"Email\",\"field_type\":\"email\",\"placeholder\":\"Enter your email\",\"width\":66,\"required\":\"true\"}],\"row_gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"column_gap\":{\"size\":\"20\",\"unit\":\"px\",\"sizes\":[]},\"label_spacing\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"align_description\":\"center\",\"align_description_mobile\":\"center\",\"_align\":\"center\",\"title_align\":\"center\",\"title_align_mobile\":\"center\",\"align_text_after_buttons_mobile\":\"center\",\"_border_radius\":\"0\",\"title_tag\":\"h1\",\"__globals__\":{\"_background_color\":\"\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"label_color\":\"globals\\/colors?id=secondary\",\"typography_title_typography\":\"globals\\/typography?id=twbb_h3\",\"typography_description_typography\":\"globals\\/typography?id=twbb_p3\",\"label_typography_typography\":\"globals\\/typography?id=twbb_p3\",\"html_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"field_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"html_color\":\"globals\\/colors?id=text\",\"field_text_color\":\"globals\\/colors?id=twbb_button\",\"field_background_color\":\"globals\\/colors?id=twbb_bg_primary\",\"button_typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_background_color\":\"globals\\/colors?id=accent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_accent_hover\",\"button_border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_accent_hover\",\"field_border_color\":\"globals\\/colors?id=twbb_button\"},\"button_border_border\":\"solid\",\"button_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"field_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"field_border_border\":\"solid\",\"step_next_label\":\"Next\",\"step_previous_label\":\"Previous\",\"reset_button_text\":\"Reset\",\"email_content\":\"[all-fields]\",\"email_content_2\":\"[all-fields]\",\"success_message\":\"The form was sent successfully.\",\"error_message\":\"An error occurred.\",\"required_field_message\":\"This field is required.\",\"invalid_message\":\"There&#039;s something wrong. The form is invalid.\",\"show_labels\":\"\",\"button_align\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"twbb_form\",\"id\":\"xqrv6g9p\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-service6.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"ssd9c6bf\"}]}],\"isInner\":\"false\"},{\"id\":\"470b6b1\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/hero\\/hero_30\\/align-center--background_color_type-dark--background_media_type-image--cards_type-no_contrast--cta_element-button.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section twbb_full_h\",\"_title\":\"Hero\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"min_height\":{\"size\":\"100\",\"unit\":\"vh\",\"sizes\":[]},\"min_height_mobile\":{\"size\":\"80.0\",\"unit\":\"vh\",\"sizes\":[]},\"__globals__\":{\"background_color\":\"globals\\/colors?id=twbb_bg_inv\"},\"background_background\":\"classic\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_image\":{\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-bg-hero3.webp\",\"id\":43,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_overlay_opacity\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"background_overlay_background\":\"gradient\",\"background_overlay_color\":\"#00000000\",\"background_overlay_color_b\":\"#0000009C\",\"background_overlay_gradient_angle\":{\"unit\":\"deg\",\"size\":270,\"sizes\":[]},\"background_motion_fx_motion_fx_scrolling\":\"yes\",\"background_motion_fx_scale_effect\":\"yes\",\"background_motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"flex_justify_content\":\"center\",\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"9f0s794k\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"title\":\"Welcome to Our Site\",\"header_size\":\"h1\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"crtirn8w\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Greet your visitors with a brief, captivating introduction. Click to edit and add your own text.\",\"align\":\"center\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=twbb_text_inv\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"h72yai4d\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_justify_content\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"w7z1nhsx\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"text\":\"Get Started\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"right\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button\",\"background_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"border_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"hover_color\":\"globals\\/colors?id=twbb_button\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"grqpcp5m\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"text\":\"Learn More\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"background_color\":\"globals\\/colors?id=twbb_transparent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"border_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"hover_color\":\"globals\\/colors?id=twbb_button\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"u1qapa98\"}]}]}],\"isInner\":\"false\"},{\"id\":\"087954d\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/hero\\/hero_31\\/align-center--background_color_type-dark--background_media_type-image--cards_type-no_contrast--cta_element-form.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section twbb_full_h\",\"_title\":\"Hero\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"min_height\":{\"size\":\"100\",\"unit\":\"vh\",\"sizes\":[]},\"min_height_mobile\":{\"size\":\"80.0\",\"unit\":\"vh\",\"sizes\":[]},\"__globals__\":{\"background_color\":\"globals\\/colors?id=twbb_bg_inv\"},\"background_background\":\"classic\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_image\":{\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-meeting-widescreen.webp\",\"id\":44,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_overlay_opacity\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"background_overlay_background\":\"gradient\",\"background_overlay_color\":\"#00000000\",\"background_overlay_color_b\":\"#0000009C\",\"background_overlay_gradient_angle\":{\"unit\":\"deg\",\"size\":270,\"sizes\":[]},\"background_motion_fx_motion_fx_scrolling\":\"yes\",\"background_motion_fx_scale_effect\":\"yes\",\"background_motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"flex_justify_content\":\"center\",\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"5wj7fjik\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"title\":\"Welcome\",\"header_size\":\"h1\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"h9q8m73s\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Greet your visitors with a brief, captivating introduction. Click to edit and add your own text.\",\"align\":\"center\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=twbb_text_inv\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"9q8u3l0q\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"20\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"20\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"form_name\":\"\",\"form_description\":\"\",\"button_text\":\"Sign up\",\"button_width\":\"30\",\"button_text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"button_align_mobile\":\"stretch\",\"form_fields\":[{\"custom_id\":\"email\",\"field_label\":\"Email\",\"field_type\":\"email\",\"placeholder\":\"Enter your email\",\"width\":66,\"required\":\"true\"}],\"row_gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"column_gap\":{\"size\":\"20\",\"unit\":\"px\",\"sizes\":[]},\"label_spacing\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"align_description\":\"center\",\"align_description_mobile\":\"center\",\"_align\":\"center\",\"title_align\":\"center\",\"title_align_mobile\":\"center\",\"align_text_after_buttons_mobile\":\"center\",\"_border_radius\":\"0\",\"title_tag\":\"h1\",\"__globals__\":{\"_background_color\":\"\",\"title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"description_color\":\"globals\\/colors?id=twbb_text_inv\",\"label_color\":\"globals\\/colors?id=twbb_primary_inv\",\"typography_title_typography\":\"globals\\/typography?id=twbb_h3\",\"typography_description_typography\":\"globals\\/typography?id=twbb_p3\",\"label_typography_typography\":\"globals\\/typography?id=twbb_p3\",\"html_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"field_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"html_color\":\"globals\\/colors?id=twbb_text_inv\",\"field_text_color\":\"globals\\/colors?id=twbb_button\",\"field_background_color\":\"globals\\/colors?id=twbb_bg_primary\",\"button_typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_background_color\":\"globals\\/colors?id=accent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_accent_hover\",\"button_border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_accent_hover\",\"field_border_color\":\"globals\\/colors?id=twbb_button\"},\"button_border_border\":\"solid\",\"button_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"field_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"field_border_border\":\"solid\",\"step_next_label\":\"Next\",\"step_previous_label\":\"Previous\",\"reset_button_text\":\"Reset\",\"email_content\":\"[all-fields]\",\"email_content_2\":\"[all-fields]\",\"success_message\":\"The form was sent successfully.\",\"error_message\":\"An error occurred.\",\"required_field_message\":\"This field is required.\",\"invalid_message\":\"There&#039;s something wrong. The form is invalid.\",\"show_labels\":\"\",\"button_align\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"twbb_form\",\"id\":\"ogcv2lrb\"}]}],\"isInner\":\"false\"},{\"id\":\"1f328ac\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/hero\\/hero_36\\/background_color_type-none--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"css_classes\":\"twbb_section twbb_full_h\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_gap\":{\"column\":\"0\",\"row\":\"20\",\"isLinked\":false,\"unit\":\"px\",\"size\":\"0\"},\"min_height\":{\"size\":\"100\",\"unit\":\"vh\",\"sizes\":[]},\"min_height_mobile\":{\"size\":\"80.0\",\"unit\":\"vh\",\"sizes\":[]},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"2n2xp8qm\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"calc(50vw - 640.0px)\",\"right\":\"30px\",\"top\":\"80px\",\"bottom\":\"80px\",\"unit\":\"custom\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_justify_content\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"9z806b9r\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"10\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"title\":\"Welcome\",\"header_size\":\"h1\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"9vbdp35l\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"10\",\"bottom\":\"10\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Greet your visitors with a brief, captivating introduction. Click to edit and add your own text.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"qa29larq\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"h8urgc2j\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"text\":\"Get Started\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"right\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"background_color\":\"globals\\/colors?id=accent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_accent_hover\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_accent_hover\",\"hover_color\":\"globals\\/colors?id=twbb_button_inv\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"ipdu6pdq\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"text\":\"Learn More\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"right\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=accent\",\"background_color\":\"globals\\/colors?id=twbb_transparent\",\"button_background_hover_color\":\"globals\\/colors?id=accent\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=accent\",\"hover_color\":\"globals\\/colors?id=twbb_button_inv\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"ha1xybof\"}]}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-service7.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"height\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"object-fit\":\"cover\"},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"yd74ymxl\"}]}],\"isInner\":\"false\"},{\"id\":\"daea3a3\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/hero\\/hero_37\\/background_color_type-none--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"css_classes\":\"twbb_section twbb_full_h\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_gap\":{\"column\":\"0\",\"row\":\"20\",\"isLinked\":false,\"unit\":\"px\",\"size\":\"0\"},\"min_height\":{\"size\":\"100\",\"unit\":\"vh\",\"sizes\":[]},\"min_height_mobile\":{\"size\":\"80.0\",\"unit\":\"vh\",\"sizes\":[]},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"j9h4bxog\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-service8.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"height\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"object-fit\":\"cover\"},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"zlg3v8us\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"30px\",\"right\":\"calc(50vw - 640.0px)\",\"top\":\"80px\",\"bottom\":\"80px\",\"unit\":\"custom\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_justify_content\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"h2ruacwl\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"10\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"title\":\"Welcome\",\"header_size\":\"h1\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"itlgj2dz\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"10\",\"bottom\":\"10\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Greet your visitors with a brief, captivating introduction. Click to edit and add your own text.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"0er0run4\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"aww78u58\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"text\":\"Get Started\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"right\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"background_color\":\"globals\\/colors?id=accent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_accent_hover\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_accent_hover\",\"hover_color\":\"globals\\/colors?id=twbb_button_inv\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"iz2af6gk\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"text\":\"Learn More\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"right\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=accent\",\"background_color\":\"globals\\/colors?id=twbb_transparent\",\"button_background_hover_color\":\"globals\\/colors?id=accent\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=accent\",\"hover_color\":\"globals\\/colors?id=twbb_button_inv\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"nlk0onpo\"}]}]}]}],\"isInner\":\"false\"},{\"id\":\"66eae30\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/hero\\/hero_38\\/background_color_type-none--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"css_classes\":\"twbb_section twbb_full_h\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_gap\":{\"column\":\"0\",\"row\":\"20\",\"isLinked\":false,\"unit\":\"px\",\"size\":\"0\"},\"min_height\":{\"size\":\"100\",\"unit\":\"vh\",\"sizes\":[]},\"min_height_mobile\":{\"size\":\"80.0\",\"unit\":\"vh\",\"sizes\":[]},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"o0zlk2tr\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"calc(50vw - 640.0px)\",\"right\":\"30px\",\"top\":\"80px\",\"bottom\":\"80px\",\"unit\":\"custom\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_justify_content\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"25dca2ae\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Welcome\",\"header_size\":\"h1\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"9tslpfgh\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Greet your visitors with a brief, captivating introduction. Click to edit and add your own text.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"7plouvnw\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"20\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"20\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"form_name\":\"\",\"form_description\":\"\",\"button_text\":\"Sign up\",\"button_width\":\"25\",\"button_text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"button_align_mobile\":\"stretch\",\"form_fields\":[{\"custom_id\":\"email\",\"field_label\":\"Email\",\"field_type\":\"email\",\"placeholder\":\"Enter your email\",\"width\":66,\"required\":\"true\"}],\"row_gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"column_gap\":{\"size\":\"20\",\"unit\":\"px\",\"sizes\":[]},\"label_spacing\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"align_description\":\"stretch\",\"align_description_mobile\":\"center\",\"_align\":\"stretch\",\"title_align\":\"stretch\",\"title_align_mobile\":\"center\",\"align_text_after_buttons_mobile\":\"center\",\"_border_radius\":\"0\",\"title_tag\":\"h1\",\"__globals__\":{\"_background_color\":\"\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"label_color\":\"globals\\/colors?id=secondary\",\"typography_title_typography\":\"globals\\/typography?id=twbb_h3\",\"typography_description_typography\":\"globals\\/typography?id=twbb_p3\",\"label_typography_typography\":\"globals\\/typography?id=twbb_p3\",\"html_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"field_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"html_color\":\"globals\\/colors?id=text\",\"field_text_color\":\"globals\\/colors?id=twbb_button\",\"field_background_color\":\"globals\\/colors?id=twbb_bg_primary\",\"button_typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_background_color\":\"globals\\/colors?id=accent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_accent_hover\",\"button_border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_accent_hover\",\"field_border_color\":\"globals\\/colors?id=twbb_button\"},\"button_border_border\":\"solid\",\"button_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"field_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"field_border_border\":\"solid\",\"step_next_label\":\"Next\",\"step_previous_label\":\"Previous\",\"reset_button_text\":\"Reset\",\"email_content\":\"[all-fields]\",\"email_content_2\":\"[all-fields]\",\"success_message\":\"The form was sent successfully.\",\"error_message\":\"An error occurred.\",\"required_field_message\":\"This field is required.\",\"invalid_message\":\"There&#039;s something wrong. The form is invalid.\",\"show_labels\":\"\",\"button_align\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"twbb_form\",\"id\":\"zvdnqkwq\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-service7.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"height\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"object-fit\":\"cover\"},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"o351e2f2\"}]}],\"isInner\":\"false\"},{\"id\":\"cfdcf59\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/hero\\/hero_39\\/background_color_type-none--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"css_classes\":\"twbb_section twbb_full_h\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_gap\":{\"column\":\"0\",\"row\":\"20\",\"isLinked\":false,\"unit\":\"px\",\"size\":\"0\"},\"min_height\":{\"size\":\"100\",\"unit\":\"vh\",\"sizes\":[]},\"min_height_mobile\":{\"size\":\"80.0\",\"unit\":\"vh\",\"sizes\":[]},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"0vzez38p\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-service8.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"height\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"object-fit\":\"cover\"},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"m0di4ian\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"30px\",\"right\":\"calc(50vw - 640.0px)\",\"top\":\"80px\",\"bottom\":\"80px\",\"unit\":\"custom\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_justify_content\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"1md7iwwm\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Welcome\",\"header_size\":\"h1\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"v73ggvo1\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Greet your visitors with a brief, captivating introduction. Click to edit and add your own text.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"z0qqxscn\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"20\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"20\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"form_name\":\"\",\"form_description\":\"\",\"button_text\":\"Sign up\",\"button_width\":\"25\",\"button_text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"button_align_mobile\":\"stretch\",\"form_fields\":[{\"custom_id\":\"email\",\"field_label\":\"Email\",\"field_type\":\"email\",\"placeholder\":\"Enter your email\",\"width\":66,\"required\":\"true\"}],\"row_gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"column_gap\":{\"size\":\"20\",\"unit\":\"px\",\"sizes\":[]},\"label_spacing\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"align_description\":\"stretch\",\"align_description_mobile\":\"center\",\"_align\":\"stretch\",\"title_align\":\"stretch\",\"title_align_mobile\":\"center\",\"align_text_after_buttons_mobile\":\"center\",\"_border_radius\":\"0\",\"title_tag\":\"h1\",\"__globals__\":{\"_background_color\":\"\",\"title_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"label_color\":\"globals\\/colors?id=secondary\",\"typography_title_typography\":\"globals\\/typography?id=twbb_h3\",\"typography_description_typography\":\"globals\\/typography?id=twbb_p3\",\"label_typography_typography\":\"globals\\/typography?id=twbb_p3\",\"html_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"field_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"html_color\":\"globals\\/colors?id=text\",\"field_text_color\":\"globals\\/colors?id=twbb_button\",\"field_background_color\":\"globals\\/colors?id=twbb_bg_primary\",\"button_typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_background_color\":\"globals\\/colors?id=accent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_accent_hover\",\"button_border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_accent_hover\",\"field_border_color\":\"globals\\/colors?id=twbb_button\"},\"button_border_border\":\"solid\",\"button_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"field_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"field_border_border\":\"solid\",\"step_next_label\":\"Next\",\"step_previous_label\":\"Previous\",\"reset_button_text\":\"Reset\",\"email_content\":\"[all-fields]\",\"email_content_2\":\"[all-fields]\",\"success_message\":\"The form was sent successfully.\",\"error_message\":\"An error occurred.\",\"required_field_message\":\"This field is required.\",\"invalid_message\":\"There&#039;s something wrong. The form is invalid.\",\"show_labels\":\"\",\"button_align\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"twbb_form\",\"id\":\"g3cv9owk\"}]}]}],\"isInner\":\"false\"},{\"id\":\"bcb41af\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/hero\\/hero_4\\/align-left--background_color_type-dark--background_media_type-slider--cards_type-no_contrast--cta_element-button.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section twbb_full_h\",\"_title\":\"Hero\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"min_height\":{\"size\":\"100\",\"unit\":\"vh\",\"sizes\":[]},\"min_height_mobile\":{\"size\":\"80.0\",\"unit\":\"vh\",\"sizes\":[]},\"__globals__\":{\"background_color\":\"globals\\/colors?id=twbb_bg_inv\"},\"background_background\":\"slideshow\",\"background_slideshow_gallery\":[{\"id\":\"\",\"description\":\"MOCK_IMAGE_BG_HERO\",\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-bg-hero.webp\",\"alt\":\"\"},{\"id\":\"\",\"description\":\"MOCK_IMAGE_BG_HERO2\",\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-bg-hero2.webp\",\"alt\":\"\"}],\"background_slideshow_ken_burns\":\"yes\",\"background_overlay_opacity\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"background_overlay_background\":\"gradient\",\"background_overlay_color\":\"#00000000\",\"background_overlay_color_b\":\"#0000009C\",\"background_overlay_gradient_angle\":{\"unit\":\"deg\",\"size\":270,\"sizes\":[]},\"flex_justify_content\":\"center\",\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"8zc4d3h4\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"title\":\"Welcome to Our Site\",\"header_size\":\"h1\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"rnky19p6\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Greet your visitors with a brief, captivating introduction. Click to edit and add your own text.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=twbb_text_inv\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"oplnlv1n\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"80uelmgg\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"text\":\"Get Started\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button\",\"background_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"border_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"hover_color\":\"globals\\/colors?id=twbb_button\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"pg7mjm80\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"text\":\"Learn More\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"background_color\":\"globals\\/colors?id=twbb_transparent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"border_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"hover_color\":\"globals\\/colors?id=twbb_button\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"sh5uue8g\"}]}]}],\"isInner\":\"false\"},{\"id\":\"a87fabf\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/hero\\/hero_4e\\/align-left--background_color_type-dark--background_media_type-slider--cards_type-no_contrast--cta_element-button.json\",\"css_classes\":\"twbb-sg-each-section  twbb-sg-recommended-ecommerce twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section twbb_full_h\",\"_title\":\"Hero\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"min_height\":{\"size\":\"100\",\"unit\":\"vh\",\"sizes\":[]},\"min_height_mobile\":{\"size\":\"80.0\",\"unit\":\"vh\",\"sizes\":[]},\"__globals__\":{\"background_color\":\"globals\\/colors?id=twbb_bg_inv\"},\"background_background\":\"slideshow\",\"background_slideshow_gallery\":[{\"id\":\"\",\"description\":\"MOCK_IMAGE_BG_HERO\",\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-bg-hero.webp\",\"alt\":\"\"},{\"id\":\"\",\"description\":\"MOCK_IMAGE_BG_HERO2\",\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-bg-hero2.webp\",\"alt\":\"\"}],\"background_slideshow_ken_burns\":\"yes\",\"background_overlay_opacity\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"background_overlay_background\":\"gradient\",\"background_overlay_color\":\"#00000000\",\"background_overlay_color_b\":\"#0000009C\",\"background_overlay_gradient_angle\":{\"unit\":\"deg\",\"size\":270,\"sizes\":[]},\"flex_justify_content\":\"center\",\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"k7w9hj9m\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"title\":\"Welcome to Our Site\",\"header_size\":\"h1\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"z7pjml9f\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Greet your visitors with a brief, captivating introduction. Click to edit and add your own text.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=twbb_text_inv\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"nitj5u1k\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"ifja0s8x\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"text\":\"Get Started\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button\",\"background_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"border_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"hover_color\":\"globals\\/colors?id=twbb_button\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"23vwrzmi\"}]}]}],\"isInner\":\"false\"},{\"id\":\"b749a22\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/hero\\/hero_5\\/align-left--background_color_type-dark--background_media_type-image--cards_type-no_contrast--cta_element-button.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section twbb_full_h\",\"_title\":\"Hero\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"min_height\":{\"size\":\"100\",\"unit\":\"vh\",\"sizes\":[]},\"min_height_mobile\":{\"size\":\"80.0\",\"unit\":\"vh\",\"sizes\":[]},\"__globals__\":{\"background_color\":\"globals\\/colors?id=twbb_bg_inv\"},\"background_background\":\"classic\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_image\":{\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-bg-hero.webp\",\"id\":27,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_overlay_opacity\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"background_overlay_background\":\"gradient\",\"background_overlay_color\":\"#00000000\",\"background_overlay_color_b\":\"#0000009C\",\"background_overlay_gradient_angle\":{\"unit\":\"deg\",\"size\":270,\"sizes\":[]},\"background_motion_fx_motion_fx_scrolling\":\"yes\",\"background_motion_fx_scale_effect\":\"yes\",\"background_motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"flex_justify_content\":\"center\",\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"2ut54hos\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"title\":\"Welcome to Our Site\",\"header_size\":\"h1\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"kxuc6wc9\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Greet your visitors with a brief, captivating introduction. Click to edit and add your own text.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=twbb_text_inv\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"oyq35q4e\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"c9a5ntxt\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"text\":\"Get Started\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button\",\"background_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"border_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"hover_color\":\"globals\\/colors?id=twbb_button\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"xojcsav3\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"text\":\"Learn More\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"background_color\":\"globals\\/colors?id=twbb_transparent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"border_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"hover_color\":\"globals\\/colors?id=twbb_button\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"v99qo8gu\"}]}]}],\"isInner\":\"false\"},{\"id\":\"8e3314a\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/hero\\/hero_6\\/align-left--background_color_type-dark--background_media_type-image--cards_type-no_contrast--cta_element-form.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section twbb_full_h\",\"_title\":\"Hero\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"min_height\":{\"size\":\"100\",\"unit\":\"vh\",\"sizes\":[]},\"min_height_mobile\":{\"size\":\"80.0\",\"unit\":\"vh\",\"sizes\":[]},\"__globals__\":{\"background_color\":\"globals\\/colors?id=twbb_bg_inv\"},\"background_background\":\"classic\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_image\":{\"url\":\"http:\\/\\/TENWEBLXC-1035129.10web.cloud\\/wp-content\\/uploads\\/2025\\/11\\/abstract-bg-hero4.webp\",\"id\":45,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_overlay_opacity\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"background_overlay_background\":\"gradient\",\"background_overlay_color\":\"#00000000\",\"background_overlay_color_b\":\"#0000009C\",\"background_overlay_gradient_angle\":{\"unit\":\"deg\",\"size\":270,\"sizes\":[]},\"background_motion_fx_motion_fx_scrolling\":\"yes\",\"background_motion_fx_scale_effect\":\"yes\",\"background_motion_fx_scale_speed\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"flex_justify_content\":\"center\",\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"5b86xmog\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"title\":\"Welcome to Our Site\",\"header_size\":\"h1\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"fhv17w5r\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Greet your visitors with a brief, captivating introduction. Click to edit and add your own text.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=twbb_text_inv\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"8yci4ssj\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":41,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":41,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"20\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"20\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"form_name\":\"\",\"form_description\":\"\",\"button_text\":\"Sign up\",\"button_width\":\"30\",\"button_text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"button_align_mobile\":\"stretch\",\"form_fields\":[{\"custom_id\":\"email\",\"field_label\":\"Email\",\"field_type\":\"email\",\"placeholder\":\"Enter your email\",\"width\":66,\"required\":\"true\"}],\"row_gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"column_gap\":{\"size\":\"20\",\"unit\":\"px\",\"sizes\":[]},\"label_spacing\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"align_description\":\"left\",\"align_description_mobile\":\"center\",\"_align\":\"left\",\"title_align\":\"left\",\"title_align_mobile\":\"center\",\"align_text_after_buttons_mobile\":\"center\",\"_border_radius\":\"0\",\"title_tag\":\"h1\",\"__globals__\":{\"_background_color\":\"\",\"title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"description_color\":\"globals\\/colors?id=twbb_text_inv\",\"label_color\":\"globals\\/colors?id=twbb_primary_inv\",\"typography_title_typography\":\"globals\\/typography?id=twbb_h3\",\"typography_description_typography\":\"globals\\/typography?id=twbb_p3\",\"label_typography_typography\":\"globals\\/typography?id=twbb_p3\",\"html_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"field_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"html_color\":\"globals\\/colors?id=twbb_text_inv\",\"field_text_color\":\"globals\\/colors?id=twbb_button\",\"field_background_color\":\"globals\\/colors?id=twbb_bg_primary\",\"button_typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_background_color\":\"globals\\/colors?id=accent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_accent_hover\",\"button_border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_accent_hover\",\"field_border_color\":\"globals\\/colors?id=twbb_button\"},\"button_border_border\":\"solid\",\"button_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"field_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"field_border_border\":\"solid\",\"step_next_label\":\"Next\",\"step_previous_label\":\"Previous\",\"reset_button_text\":\"Reset\",\"email_content\":\"[all-fields]\",\"email_content_2\":\"[all-fields]\",\"success_message\":\"The form was sent successfully.\",\"error_message\":\"An error occurred.\",\"required_field_message\":\"This field is required.\",\"invalid_message\":\"There&#039;s something wrong. The form is invalid.\",\"show_labels\":\"\",\"button_align\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"twbb_form\",\"id\":\"syk7nlk5\"}]}],\"isInner\":\"false\"},{\"id\":\"4ed0269\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/logos\\/logos_3b\\/background_color_type-none--background_media_type-none--cards_type-no_contrast--layout-slider.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Logos\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"41sc9c76\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"title\":\"Trusted by the following companies\",\"header_size\":\"h4\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"amczggr3\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"twbb_dummy\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"button_border_width\":{\"unit\":\"px\",\"size\":\"1\",\"sizes\":[]},\"slides_height\":{\"unit\":\"px\",\"size\":64,\"sizes\":[]},\"images_slides_height\":{\"unit\":\"px\",\"size\":64,\"sizes\":[]},\"navigation\":\"none\",\"content_max_width\":{\"size\":\"100\",\"unit\":\"%\",\"sizes\":[]},\"slides\":[{\"_id\":\"typch7am\",\"heading\":\"\",\"description\":\"\",\"button_text\":\"\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"background_image\":{\"id\":\"\",\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/Nike.svg\",\"alt\":\"\",\"source\":\"url\"},\"background_overlay_color\":\"rgba(51,51,51,0.5)\",\"background_color\":\"\",\"background_size\":\"contain\"},{\"_id\":\"umj1zhq9\",\"heading\":\"\",\"description\":\"\",\"button_text\":\"\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"background_image\":{\"id\":\"\",\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/Adidas.svg\",\"alt\":\"\",\"source\":\"url\"},\"background_overlay_color\":\"rgba(51,51,51,0.5)\",\"background_color\":\"\",\"background_size\":\"contain\"},{\"_id\":\"wop3kl7p\",\"heading\":\"\",\"description\":\"\",\"button_text\":\"\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"background_image\":{\"id\":\"\",\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/Converse.svg\",\"alt\":\"\",\"source\":\"url\"},\"background_overlay_color\":\"rgba(51,51,51,0.5)\",\"background_color\":\"\",\"background_size\":\"contain\"},{\"_id\":\"onatlm3v\",\"heading\":\"\",\"description\":\"\",\"button_text\":\"\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"background_image\":{\"id\":\"\",\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/Sketchers.svg\",\"alt\":\"\",\"source\":\"url\"},\"background_overlay_color\":\"rgba(51,51,51,0.5)\",\"background_color\":\"\",\"background_size\":\"contain\"},{\"_id\":\"c8xt64u8\",\"heading\":\"\",\"description\":\"\",\"button_text\":\"\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"background_image\":{\"id\":\"\",\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/Puma.svg\",\"alt\":\"\",\"source\":\"url\"},\"background_overlay_color\":\"rgba(51,51,51,0.5)\",\"background_color\":\"\",\"background_size\":\"contain\"},{\"_id\":\"esjq34vh\",\"heading\":\"\",\"description\":\"\",\"button_text\":\"\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"background_image\":{\"id\":\"\",\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/Reebok.svg\",\"alt\":\"\",\"source\":\"url\"},\"background_overlay_color\":\"rgba(51,51,51,0.5)\",\"background_color\":\"\",\"background_size\":\"contain\"}],\"slider_inner_position\":\"outside\",\"slides_horizontal_position\":\"center\",\"slides_text_align\":\"center\",\"heading_spacing\":{\"unit\":\"px\",\"size\":\"20\",\"sizes\":[]},\"description_spacing\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"space_between\":{\"unit\":\"px\",\"size\":72,\"sizes\":[]},\"__globals__\":{\"heading_typography_typography\":\"globals\\/typography?id=secondary\",\"description_typography_typography\":\"globals\\/typography?id=text\",\"button_typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=accent\",\"button_background_color\":\"globals\\/colors?id=twbb_transparent\",\"heading_color\":\"globals\\/colors?id=primary\",\"description_color\":\"globals\\/colors?id=text\",\"arrows_color\":\"globals\\/colors?id=twbb_bg_inv\",\"dots_color\":\"globals\\/colors?id=twbb_bg_inv\",\"button_border_color\":\"globals\\/colors?id=accent\",\"button_hover_background_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=accent\",\"button_hover_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"_background_color\":\"globals\\/colors?id=twbb_bg_primary\"},\"slides_per_view\":6,\"slides_per_view_mobile\":3,\"autoplay_speed\":0,\"content_animation\":\"\",\"transition_speed\":5000,\"space_between_mobile\":{\"unit\":\"px\",\"size\":36,\"sizes\":[]},\"speed_liner\":\"yes\",\"_background_background\":\"classic\"},\"elType\":\"widget\",\"widgetType\":\"twbb_slides\",\"id\":\"x8tsotsh\"}]}],\"isInner\":\"false\"},{\"id\":\"9700d6b\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/multiple_features\\/multiple_features_252\\/background_color_type-none--background_media_type-none--cards_type-no_contrast--num_of_features-3.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"ilvvq8t9\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"cpuxb56n\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"title\":\"Explore Our Top 3 Features\",\"header_size\":\"h2\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"ujuscoad\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"editor\":\"Discover how our top features bring unparalleled value to your business with powerful insights.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p3\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"fid6v5jj\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"tm7kvq85\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"twbb_padding\":{\"unit\":\"px\",\"top\":\"16\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_padding_mobile\":{\"unit\":\"px\",\"top\":\"16\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_title\":\"Feature 1\",\"twbb_description\":\"Stay ahead of the game with our advanced analytics feature.\",\"twbb_title_tag\":\"h5\",\"twbb_button_one\":\"\",\"twbb_button_two\":\"Learn More\",\"twbb_button_padding_one\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_button_padding_two\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_position_button\":\"horizontal\",\"twbb_buttons_position\":\"bottom\",\"twbb_title_spacing\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"twbb_title_spacing_tablet\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"twbb_title_spacing_mobile\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"twbb_button_margin_one\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_one_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_alignment\":\"left\",\"twbb_alignment_tablet\":\"left\",\"twbbbuttons_horizontal_alignment\":\"left\",\"twbbbuttons_horizontal_alignment_mobile\":\"center\",\"twbbbuttons_horizontal_alignment_tablet\":\"left\",\"twbb_position_button_mobile\":\"column\",\"__globals__\":{\"twbb_title_typography_typography\":\"globals\\/typography?id=twbb_h5\",\"twbb_title_color\":\"globals\\/colors?id=primary\",\"twbb_description_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"twbb_description_color\":\"globals\\/colors?id=text\",\"twbb_button_typography_one_typography\":\"globals\\/typography?id=accent\",\"twbb_button_text_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_background_color_one\":\"globals\\/colors?id=accent\",\"twbb_button_hover_background_color_one\":\"globals\\/colors?id=twbb_accent_hover\",\"twbb_button_hover_border_color_one\":\"globals\\/colors?id=twbb_accent_hover\",\"_background_color\":\"globals\\/colors?id=twbb_transparent\",\"twbb_button_hover_text_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_border_color_one\":\"globals\\/colors?id=accent\",\"twbb_button_typography_two_typography\":\"globals\\/typography?id=accent\",\"twbb_button_text_color_two\":\"globals\\/colors?id=accent\",\"twbb_button_background_color_two\":\"globals\\/colors?id=twbb_transparent\",\"twbb_button_hover_background_color_two\":\"globals\\/colors?id=accent\",\"twbb_button_hover_text_color_two\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_border_color_two\":\"globals\\/colors?id=accent\",\"twbb_button_hover_border_color_two\":\"globals\\/colors?id=accent\"},\"twbb_vertical_position\":\"space_between\",\"twbb_bg_image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-product1.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"twbb_position\":\"top\",\"image_type\":\"image_tag\",\"twbb_bg_image_size\":\"full\",\"twbbbutton_border_radius\":{\"unit\":\"px\",\"size\":{\"unit\":\"px\",\"size\":\"0\",\"sizes\":[]},\"sizes\":[]},\"twbb_image_background_animation\":\"zoom-in\",\"twbb_enable_button_one\":\"\",\"twbb_button_border_width_one\":{\"size\":\"1\",\"unit\":\"px\",\"sizes\":[]},\"twbb_enable_button_two\":\"yes\",\"twbb_button_border_width_two\":{\"size\":\"1\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"twbb_call-to-action\",\"id\":\"v2ozwx7y\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"twbb_padding\":{\"unit\":\"px\",\"top\":\"16\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_padding_mobile\":{\"unit\":\"px\",\"top\":\"16\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_title\":\"Feature 2\",\"twbb_description\":\"Easily integrate your existing platforms with our scalable solutions.\",\"twbb_title_tag\":\"h5\",\"twbb_button_one\":\"\",\"twbb_button_two\":\"Learn More\",\"twbb_button_padding_one\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_button_padding_two\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_position_button\":\"horizontal\",\"twbb_buttons_position\":\"bottom\",\"twbb_title_spacing\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"twbb_title_spacing_tablet\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"twbb_title_spacing_mobile\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"twbb_button_margin_one\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_one_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_alignment\":\"left\",\"twbb_alignment_tablet\":\"left\",\"twbbbuttons_horizontal_alignment\":\"left\",\"twbbbuttons_horizontal_alignment_mobile\":\"center\",\"twbbbuttons_horizontal_alignment_tablet\":\"left\",\"twbb_position_button_mobile\":\"column\",\"__globals__\":{\"twbb_title_typography_typography\":\"globals\\/typography?id=twbb_h5\",\"twbb_title_color\":\"globals\\/colors?id=primary\",\"twbb_description_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"twbb_description_color\":\"globals\\/colors?id=text\",\"twbb_button_typography_one_typography\":\"globals\\/typography?id=accent\",\"twbb_button_text_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_background_color_one\":\"globals\\/colors?id=accent\",\"twbb_button_hover_background_color_one\":\"globals\\/colors?id=twbb_accent_hover\",\"twbb_button_hover_border_color_one\":\"globals\\/colors?id=twbb_accent_hover\",\"_background_color\":\"globals\\/colors?id=twbb_transparent\",\"twbb_button_hover_text_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_border_color_one\":\"globals\\/colors?id=accent\",\"twbb_button_typography_two_typography\":\"globals\\/typography?id=accent\",\"twbb_button_text_color_two\":\"globals\\/colors?id=accent\",\"twbb_button_background_color_two\":\"globals\\/colors?id=twbb_transparent\",\"twbb_button_hover_background_color_two\":\"globals\\/colors?id=accent\",\"twbb_button_hover_text_color_two\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_border_color_two\":\"globals\\/colors?id=accent\",\"twbb_button_hover_border_color_two\":\"globals\\/colors?id=accent\"},\"twbb_vertical_position\":\"space_between\",\"twbb_bg_image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-product2.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"twbb_position\":\"top\",\"image_type\":\"image_tag\",\"twbb_bg_image_size\":\"full\",\"twbbbutton_border_radius\":{\"unit\":\"px\",\"size\":{\"unit\":\"px\",\"size\":\"0\",\"sizes\":[]},\"sizes\":[]},\"twbb_image_background_animation\":\"zoom-in\",\"twbb_enable_button_one\":\"\",\"twbb_button_border_width_one\":{\"size\":\"1\",\"unit\":\"px\",\"sizes\":[]},\"twbb_enable_button_two\":\"yes\",\"twbb_button_border_width_two\":{\"size\":\"1\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"twbb_call-to-action\",\"id\":\"1gaqai5h\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"twbb_padding\":{\"unit\":\"px\",\"top\":\"16\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_padding_mobile\":{\"unit\":\"px\",\"top\":\"16\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_title\":\"Feature 3\",\"twbb_description\":\"Boost productivity with our versatile automation tools.\",\"twbb_title_tag\":\"h5\",\"twbb_button_one\":\"\",\"twbb_button_two\":\"Learn More\",\"twbb_button_padding_one\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_button_padding_two\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_position_button\":\"horizontal\",\"twbb_buttons_position\":\"bottom\",\"twbb_title_spacing\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"twbb_title_spacing_tablet\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"twbb_title_spacing_mobile\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"twbb_button_margin_one\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_one_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_alignment\":\"left\",\"twbb_alignment_tablet\":\"left\",\"twbbbuttons_horizontal_alignment\":\"left\",\"twbbbuttons_horizontal_alignment_mobile\":\"center\",\"twbbbuttons_horizontal_alignment_tablet\":\"left\",\"twbb_position_button_mobile\":\"column\",\"__globals__\":{\"twbb_title_typography_typography\":\"globals\\/typography?id=twbb_h5\",\"twbb_title_color\":\"globals\\/colors?id=primary\",\"twbb_description_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"twbb_description_color\":\"globals\\/colors?id=text\",\"twbb_button_typography_one_typography\":\"globals\\/typography?id=accent\",\"twbb_button_text_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_background_color_one\":\"globals\\/colors?id=accent\",\"twbb_button_hover_background_color_one\":\"globals\\/colors?id=twbb_accent_hover\",\"twbb_button_hover_border_color_one\":\"globals\\/colors?id=twbb_accent_hover\",\"_background_color\":\"globals\\/colors?id=twbb_transparent\",\"twbb_button_hover_text_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_border_color_one\":\"globals\\/colors?id=accent\",\"twbb_button_typography_two_typography\":\"globals\\/typography?id=accent\",\"twbb_button_text_color_two\":\"globals\\/colors?id=accent\",\"twbb_button_background_color_two\":\"globals\\/colors?id=twbb_transparent\",\"twbb_button_hover_background_color_two\":\"globals\\/colors?id=accent\",\"twbb_button_hover_text_color_two\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_border_color_two\":\"globals\\/colors?id=accent\",\"twbb_button_hover_border_color_two\":\"globals\\/colors?id=accent\"},\"twbb_vertical_position\":\"space_between\",\"twbb_bg_image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-product3.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"twbb_position\":\"top\",\"image_type\":\"image_tag\",\"twbb_bg_image_size\":\"full\",\"twbbbutton_border_radius\":{\"unit\":\"px\",\"size\":{\"unit\":\"px\",\"size\":\"0\",\"sizes\":[]},\"sizes\":[]},\"twbb_image_background_animation\":\"zoom-in\",\"twbb_enable_button_one\":\"\",\"twbb_button_border_width_one\":{\"size\":\"1\",\"unit\":\"px\",\"sizes\":[]},\"twbb_enable_button_two\":\"yes\",\"twbb_button_border_width_two\":{\"size\":\"1\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"twbb_call-to-action\",\"id\":\"ilo5srzl\"}]}]}],\"isInner\":\"false\"},{\"id\":\"582f003\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/multiple_features\\/multiple_features_293\\/background_color_type-none--background_media_type-none--cards_type-no_contrast--num_of_features-4.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"wwvxkc8f\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":25,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":25,\"sizes\":[]},\"twbb_padding\":{\"unit\":\"px\",\"top\":\"16\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_padding_mobile\":{\"unit\":\"px\",\"top\":\"16\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_title\":\"Feature 1: Title\",\"twbb_description\":\"Stay ahead of the game with our advanced analytics feature.\",\"twbb_title_tag\":\"h5\",\"twbb_button_one\":\"\",\"twbb_button_two\":\"\",\"twbb_button_padding_one\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_button_padding_two\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_position_button\":\"horizontal\",\"twbb_buttons_position\":\"bottom\",\"twbb_title_spacing\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"twbb_title_spacing_tablet\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"twbb_title_spacing_mobile\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"twbb_button_margin_one\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_one_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_alignment\":\"center\",\"twbb_alignment_tablet\":\"center\",\"twbbbuttons_horizontal_alignment\":\"center\",\"twbbbuttons_horizontal_alignment_mobile\":\"center\",\"twbbbuttons_horizontal_alignment_tablet\":\"center\",\"twbb_position_button_mobile\":\"column\",\"__globals__\":{\"twbb_title_typography_typography\":\"globals\\/typography?id=twbb_h5\",\"twbb_title_color\":\"globals\\/colors?id=primary\",\"twbb_description_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"twbb_description_color\":\"globals\\/colors?id=text\",\"twbb_button_typography_one_typography\":\"globals\\/typography?id=accent\",\"twbb_button_text_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_background_color_one\":\"globals\\/colors?id=accent\",\"twbb_button_hover_background_color_one\":\"globals\\/colors?id=twbb_accent_hover\",\"twbb_button_hover_border_color_one\":\"globals\\/colors?id=twbb_accent_hover\",\"_background_color\":\"globals\\/colors?id=twbb_transparent\",\"twbb_button_hover_text_color_one\":\"globals\\/colors?id=twbb_button_inv\"},\"twbb_vertical_position\":\"top\",\"twbb_bg_image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-product4.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"twbb_position\":\"top\",\"image_type\":\"image_tag\",\"twbb_bg_image_size\":\"full\",\"twbbbutton_border_radius\":{\"unit\":\"px\",\"size\":{\"unit\":\"px\",\"size\":\"0\",\"sizes\":[]},\"sizes\":[]},\"twbb_image_background_animation\":\"zoom-in\",\"twbbimage_alignment\":\"center\",\"twbb_enable_button_one\":\"\",\"twbb_whole_box\":\"box\",\"twbb_link_whole_box\":{\"url\":\"#\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"twbb_enable_button_two\":\"\"},\"elType\":\"widget\",\"widgetType\":\"twbb_call-to-action\",\"id\":\"p62sk9oe\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":25,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":25,\"sizes\":[]},\"twbb_padding\":{\"unit\":\"px\",\"top\":\"16\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_padding_mobile\":{\"unit\":\"px\",\"top\":\"16\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_title\":\"Feature 2: Title\",\"twbb_description\":\"Connect seamlessly with your audience through social media.\",\"twbb_title_tag\":\"h5\",\"twbb_button_one\":\"\",\"twbb_button_two\":\"\",\"twbb_button_padding_one\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_button_padding_two\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_position_button\":\"horizontal\",\"twbb_buttons_position\":\"bottom\",\"twbb_title_spacing\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"twbb_title_spacing_tablet\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"twbb_title_spacing_mobile\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"twbb_button_margin_one\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_one_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_alignment\":\"center\",\"twbb_alignment_tablet\":\"center\",\"twbbbuttons_horizontal_alignment\":\"center\",\"twbbbuttons_horizontal_alignment_mobile\":\"center\",\"twbbbuttons_horizontal_alignment_tablet\":\"center\",\"twbb_position_button_mobile\":\"column\",\"__globals__\":{\"twbb_title_typography_typography\":\"globals\\/typography?id=twbb_h5\",\"twbb_title_color\":\"globals\\/colors?id=primary\",\"twbb_description_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"twbb_description_color\":\"globals\\/colors?id=text\",\"twbb_button_typography_one_typography\":\"globals\\/typography?id=accent\",\"twbb_button_text_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_background_color_one\":\"globals\\/colors?id=accent\",\"twbb_button_hover_background_color_one\":\"globals\\/colors?id=twbb_accent_hover\",\"twbb_button_hover_border_color_one\":\"globals\\/colors?id=twbb_accent_hover\",\"_background_color\":\"globals\\/colors?id=twbb_transparent\",\"twbb_button_hover_text_color_one\":\"globals\\/colors?id=twbb_button_inv\"},\"twbb_vertical_position\":\"top\",\"twbb_bg_image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-product5.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"twbb_position\":\"top\",\"image_type\":\"image_tag\",\"twbb_bg_image_size\":\"full\",\"twbbbutton_border_radius\":{\"unit\":\"px\",\"size\":{\"unit\":\"px\",\"size\":\"0\",\"sizes\":[]},\"sizes\":[]},\"twbb_image_background_animation\":\"zoom-in\",\"twbbimage_alignment\":\"center\",\"twbb_enable_button_one\":\"\",\"twbb_whole_box\":\"box\",\"twbb_link_whole_box\":{\"url\":\"#\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"twbb_enable_button_two\":\"\"},\"elType\":\"widget\",\"widgetType\":\"twbb_call-to-action\",\"id\":\"9yozjnzu\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":25,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":25,\"sizes\":[]},\"twbb_padding\":{\"unit\":\"px\",\"top\":\"16\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_padding_mobile\":{\"unit\":\"px\",\"top\":\"16\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_title\":\"Feature 3: Title\",\"twbb_description\":\"Optimize your customer relationships with our powerful CRM tools.\",\"twbb_title_tag\":\"h5\",\"twbb_button_one\":\"\",\"twbb_button_two\":\"\",\"twbb_button_padding_one\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_button_padding_two\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_position_button\":\"horizontal\",\"twbb_buttons_position\":\"bottom\",\"twbb_title_spacing\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"twbb_title_spacing_tablet\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"twbb_title_spacing_mobile\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"twbb_button_margin_one\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_one_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_alignment\":\"center\",\"twbb_alignment_tablet\":\"center\",\"twbbbuttons_horizontal_alignment\":\"center\",\"twbbbuttons_horizontal_alignment_mobile\":\"center\",\"twbbbuttons_horizontal_alignment_tablet\":\"center\",\"twbb_position_button_mobile\":\"column\",\"__globals__\":{\"twbb_title_typography_typography\":\"globals\\/typography?id=twbb_h5\",\"twbb_title_color\":\"globals\\/colors?id=primary\",\"twbb_description_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"twbb_description_color\":\"globals\\/colors?id=text\",\"twbb_button_typography_one_typography\":\"globals\\/typography?id=accent\",\"twbb_button_text_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_background_color_one\":\"globals\\/colors?id=accent\",\"twbb_button_hover_background_color_one\":\"globals\\/colors?id=twbb_accent_hover\",\"twbb_button_hover_border_color_one\":\"globals\\/colors?id=twbb_accent_hover\",\"_background_color\":\"globals\\/colors?id=twbb_transparent\",\"twbb_button_hover_text_color_one\":\"globals\\/colors?id=twbb_button_inv\"},\"twbb_vertical_position\":\"top\",\"twbb_bg_image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-product6.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"twbb_position\":\"top\",\"image_type\":\"image_tag\",\"twbb_bg_image_size\":\"full\",\"twbbbutton_border_radius\":{\"unit\":\"px\",\"size\":{\"unit\":\"px\",\"size\":\"0\",\"sizes\":[]},\"sizes\":[]},\"twbb_image_background_animation\":\"zoom-in\",\"twbbimage_alignment\":\"center\",\"twbb_enable_button_one\":\"\",\"twbb_whole_box\":\"box\",\"twbb_link_whole_box\":{\"url\":\"#\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"twbb_enable_button_two\":\"\"},\"elType\":\"widget\",\"widgetType\":\"twbb_call-to-action\",\"id\":\"t6fivokb\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":25,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":25,\"sizes\":[]},\"twbb_padding\":{\"unit\":\"px\",\"top\":\"16\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_padding_mobile\":{\"unit\":\"px\",\"top\":\"16\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_title\":\"Feature 4: Title\",\"twbb_description\":\"Ensure the highest levels of data security with our cutting-edge technology.\",\"twbb_title_tag\":\"h5\",\"twbb_button_one\":\"\",\"twbb_button_two\":\"\",\"twbb_button_padding_one\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_button_padding_two\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"twbb_position_button\":\"horizontal\",\"twbb_buttons_position\":\"bottom\",\"twbb_title_spacing\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"twbb_title_spacing_tablet\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"twbb_title_spacing_mobile\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"twbb_button_margin_one\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_one_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_button_margin_two_mobile\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"twbb_alignment\":\"center\",\"twbb_alignment_tablet\":\"center\",\"twbbbuttons_horizontal_alignment\":\"center\",\"twbbbuttons_horizontal_alignment_mobile\":\"center\",\"twbbbuttons_horizontal_alignment_tablet\":\"center\",\"twbb_position_button_mobile\":\"column\",\"__globals__\":{\"twbb_title_typography_typography\":\"globals\\/typography?id=twbb_h5\",\"twbb_title_color\":\"globals\\/colors?id=primary\",\"twbb_description_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"twbb_description_color\":\"globals\\/colors?id=text\",\"twbb_button_typography_one_typography\":\"globals\\/typography?id=accent\",\"twbb_button_text_color_one\":\"globals\\/colors?id=twbb_button_inv\",\"twbb_button_background_color_one\":\"globals\\/colors?id=accent\",\"twbb_button_hover_background_color_one\":\"globals\\/colors?id=twbb_accent_hover\",\"twbb_button_hover_border_color_one\":\"globals\\/colors?id=twbb_accent_hover\",\"_background_color\":\"globals\\/colors?id=twbb_transparent\",\"twbb_button_hover_text_color_one\":\"globals\\/colors?id=twbb_button_inv\"},\"twbb_vertical_position\":\"top\",\"twbb_bg_image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-product7.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"twbb_position\":\"top\",\"image_type\":\"image_tag\",\"twbb_bg_image_size\":\"full\",\"twbbbutton_border_radius\":{\"unit\":\"px\",\"size\":{\"unit\":\"px\",\"size\":\"0\",\"sizes\":[]},\"sizes\":[]},\"twbb_image_background_animation\":\"zoom-in\",\"twbbimage_alignment\":\"center\",\"twbb_enable_button_one\":\"\",\"twbb_whole_box\":\"box\",\"twbb_link_whole_box\":{\"url\":\"#\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"twbb_enable_button_two\":\"\"},\"elType\":\"widget\",\"widgetType\":\"twbb_call-to-action\",\"id\":\"tc0zl7w2\"}]}],\"isInner\":\"false\"},{\"id\":\"4fa9c0b\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/portfolio\\/portfolio_15\\/background_color_type-none--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"2mpxr4dp\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Portfolio\",\"header_size\":\"h5\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=twbb_label\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"iofcesvi\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Short heading goes here\",\"header_size\":\"h2\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"vj0tj5ni\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"0ugrzpgh\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"__globals__\":{\"color\":\"globals\\/colors?id=twbb_bg_inv\"}},\"elType\":\"widget\",\"widgetType\":\"divider\",\"id\":\"m13bl4vb\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"03410x20\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_justify_content\":\"center\",\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"cft1phga\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"title\":\"Project name here\",\"header_size\":\"h5\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=twbb_h5\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"ljvpq7k8\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"editor\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse varius enim in eros elementum tristique.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"d6nkts70\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"icon_list\":[{\"text\":\"Tag one\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}},{\"text\":\"Tag two\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}},{\"text\":\"Tag three\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}}],\"space_between\":{\"size\":16,\"unit\":\"px\",\"sizes\":[]},\"space_between_mobile\":{\"size\":4,\"unit\":\"px\",\"sizes\":[]},\"text_indent\":{\"size\":0,\"unit\":\"px\",\"sizes\":[]},\"icon_align\":\"left\",\"__globals__\":{\"icon_color\":\"globals\\/colors?id=secondary\",\"text_color\":\"globals\\/colors?id=text\",\"icon_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"12\",\"unit\":\"px\",\"sizes\":[]},\"icon_size_mobile\":{\"size\":\"10\",\"unit\":\"px\",\"sizes\":[]},\"view\":\"inline\"},\"elType\":\"widget\",\"widgetType\":\"icon-list\",\"id\":\"1z9if4fh\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"text\":\"View Project\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"0\",\"bottom\":\"12\",\"left\":\"0\",\"isLinked\":false},\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=accent\",\"background_color\":\"globals\\/colors?id=twbb_transparent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_transparent\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_accent_hover\"},\"border_border\":\"none\",\"button_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":0,\"spread\":0,\"color\":\"#000000\"},\"button_box_shadow_box_shadow_type\":\"yes\",\"selected_icon\":{\"value\":\"fas fa-angle-right\",\"library\":\"fa-solid\"},\"icon_align\":\"right\",\"icon_indent\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"2i9lgafq\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_margin\":{\"left\":\"10\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-portfolio1.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"yp9lt4yj\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"__globals__\":{\"color\":\"globals\\/colors?id=twbb_bg_inv\"}},\"elType\":\"widget\",\"widgetType\":\"divider\",\"id\":\"tiiq6ouv\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"b6bs6f4h\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_justify_content\":\"center\",\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"mu5sbwib\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"title\":\"Project name here\",\"header_size\":\"h5\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=twbb_h5\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"mj4701r4\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"editor\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse varius enim in eros elementum tristique.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"7sxcyvhi\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"icon_list\":[{\"text\":\"Tag one\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}},{\"text\":\"Tag two\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}},{\"text\":\"Tag three\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}}],\"space_between\":{\"size\":16,\"unit\":\"px\",\"sizes\":[]},\"space_between_mobile\":{\"size\":4,\"unit\":\"px\",\"sizes\":[]},\"text_indent\":{\"size\":0,\"unit\":\"px\",\"sizes\":[]},\"icon_align\":\"left\",\"__globals__\":{\"icon_color\":\"globals\\/colors?id=secondary\",\"text_color\":\"globals\\/colors?id=text\",\"icon_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"12\",\"unit\":\"px\",\"sizes\":[]},\"icon_size_mobile\":{\"size\":\"10\",\"unit\":\"px\",\"sizes\":[]},\"view\":\"inline\"},\"elType\":\"widget\",\"widgetType\":\"icon-list\",\"id\":\"x7mz8j1n\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"text\":\"View Project\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"0\",\"bottom\":\"12\",\"left\":\"0\",\"isLinked\":false},\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=accent\",\"background_color\":\"globals\\/colors?id=twbb_transparent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_transparent\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_accent_hover\"},\"border_border\":\"none\",\"button_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":0,\"spread\":0,\"color\":\"#000000\"},\"button_box_shadow_box_shadow_type\":\"yes\",\"selected_icon\":{\"value\":\"fas fa-angle-right\",\"library\":\"fa-solid\"},\"icon_align\":\"right\",\"icon_indent\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"obc5klq9\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_margin\":{\"left\":\"10\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-portfolio2.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"gj0cgfpi\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"__globals__\":{\"color\":\"globals\\/colors?id=twbb_bg_inv\"}},\"elType\":\"widget\",\"widgetType\":\"divider\",\"id\":\"5dwbmdg3\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"jup4lcbm\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_justify_content\":\"center\",\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"ge3z9ei5\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"title\":\"Project name here\",\"header_size\":\"h5\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=twbb_h5\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"0wr2n4l1\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"editor\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse varius enim in eros elementum tristique.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"2h3g5nvu\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"icon_list\":[{\"text\":\"Tag one\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}},{\"text\":\"Tag two\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}},{\"text\":\"Tag three\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}}],\"space_between\":{\"size\":16,\"unit\":\"px\",\"sizes\":[]},\"space_between_mobile\":{\"size\":4,\"unit\":\"px\",\"sizes\":[]},\"text_indent\":{\"size\":0,\"unit\":\"px\",\"sizes\":[]},\"icon_align\":\"left\",\"__globals__\":{\"icon_color\":\"globals\\/colors?id=secondary\",\"text_color\":\"globals\\/colors?id=text\",\"icon_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"12\",\"unit\":\"px\",\"sizes\":[]},\"icon_size_mobile\":{\"size\":\"10\",\"unit\":\"px\",\"sizes\":[]},\"view\":\"inline\"},\"elType\":\"widget\",\"widgetType\":\"icon-list\",\"id\":\"4scvnnds\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"text\":\"View Project\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"0\",\"bottom\":\"12\",\"left\":\"0\",\"isLinked\":false},\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=accent\",\"background_color\":\"globals\\/colors?id=twbb_transparent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_transparent\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_accent_hover\"},\"border_border\":\"none\",\"button_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":0,\"spread\":0,\"color\":\"#000000\"},\"button_box_shadow_box_shadow_type\":\"yes\",\"selected_icon\":{\"value\":\"fas fa-angle-right\",\"library\":\"fa-solid\"},\"icon_align\":\"right\",\"icon_indent\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"nhq76r8n\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_margin\":{\"left\":\"10\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-portfolio3.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"pgmeixj6\"}]}]}],\"isInner\":\"false\"},{\"id\":\"98360f2\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/portfolio\\/portfolio_16\\/background_color_type-none--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"z4emj82n\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Portfolio\",\"header_size\":\"h5\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=twbb_label\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"hw13raeo\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Short heading goes here\",\"header_size\":\"h2\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"ov9euado\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"7i5xictn\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"__globals__\":{\"color\":\"globals\\/colors?id=twbb_bg_inv\"}},\"elType\":\"widget\",\"widgetType\":\"divider\",\"id\":\"96bv6fxx\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"pyq2vq47\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"10\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-portfolio1.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"xzcswzl4\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_justify_content\":\"center\",\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"i6883yxt\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"title\":\"Project name here\",\"header_size\":\"h5\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=twbb_h5\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"nhioib92\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"editor\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse varius enim in eros elementum tristique.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"8jmeuwq7\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"icon_list\":[{\"text\":\"Tag one\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}},{\"text\":\"Tag two\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}},{\"text\":\"Tag three\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}}],\"space_between\":{\"size\":16,\"unit\":\"px\",\"sizes\":[]},\"space_between_mobile\":{\"size\":4,\"unit\":\"px\",\"sizes\":[]},\"text_indent\":{\"size\":0,\"unit\":\"px\",\"sizes\":[]},\"icon_align\":\"left\",\"__globals__\":{\"icon_color\":\"globals\\/colors?id=secondary\",\"text_color\":\"globals\\/colors?id=text\",\"icon_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"12\",\"unit\":\"px\",\"sizes\":[]},\"icon_size_mobile\":{\"size\":\"10\",\"unit\":\"px\",\"sizes\":[]},\"view\":\"inline\"},\"elType\":\"widget\",\"widgetType\":\"icon-list\",\"id\":\"0ci2qrxw\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"text\":\"View Project\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"0\",\"bottom\":\"12\",\"left\":\"0\",\"isLinked\":false},\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=accent\",\"background_color\":\"globals\\/colors?id=twbb_transparent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_transparent\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_accent_hover\"},\"border_border\":\"none\",\"button_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":0,\"spread\":0,\"color\":\"#000000\"},\"button_box_shadow_box_shadow_type\":\"yes\",\"selected_icon\":{\"value\":\"fas fa-angle-right\",\"library\":\"fa-solid\"},\"icon_align\":\"right\",\"icon_indent\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"nvzyrup4\"}]}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"__globals__\":{\"color\":\"globals\\/colors?id=twbb_bg_inv\"}},\"elType\":\"widget\",\"widgetType\":\"divider\",\"id\":\"tcecywhe\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"2w55vk6y\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"10\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-portfolio2.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"6sb3e9yx\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_justify_content\":\"center\",\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"io5nz469\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"title\":\"Project name here\",\"header_size\":\"h5\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=twbb_h5\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"g3nxzdl4\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"editor\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse varius enim in eros elementum tristique.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"75xm747c\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"icon_list\":[{\"text\":\"Tag one\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}},{\"text\":\"Tag two\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}},{\"text\":\"Tag three\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}}],\"space_between\":{\"size\":16,\"unit\":\"px\",\"sizes\":[]},\"space_between_mobile\":{\"size\":4,\"unit\":\"px\",\"sizes\":[]},\"text_indent\":{\"size\":0,\"unit\":\"px\",\"sizes\":[]},\"icon_align\":\"left\",\"__globals__\":{\"icon_color\":\"globals\\/colors?id=secondary\",\"text_color\":\"globals\\/colors?id=text\",\"icon_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"12\",\"unit\":\"px\",\"sizes\":[]},\"icon_size_mobile\":{\"size\":\"10\",\"unit\":\"px\",\"sizes\":[]},\"view\":\"inline\"},\"elType\":\"widget\",\"widgetType\":\"icon-list\",\"id\":\"j4jmjf5h\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"text\":\"View Project\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"0\",\"bottom\":\"12\",\"left\":\"0\",\"isLinked\":false},\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=accent\",\"background_color\":\"globals\\/colors?id=twbb_transparent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_transparent\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_accent_hover\"},\"border_border\":\"none\",\"button_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":0,\"spread\":0,\"color\":\"#000000\"},\"button_box_shadow_box_shadow_type\":\"yes\",\"selected_icon\":{\"value\":\"fas fa-angle-right\",\"library\":\"fa-solid\"},\"icon_align\":\"right\",\"icon_indent\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"1z1besrx\"}]}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"__globals__\":{\"color\":\"globals\\/colors?id=twbb_bg_inv\"}},\"elType\":\"widget\",\"widgetType\":\"divider\",\"id\":\"xhdjld41\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"8v69k38g\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"10\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-portfolio3.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"25yvmdk5\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_justify_content\":\"center\",\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"n0uiky3t\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"title\":\"Project name here\",\"header_size\":\"h5\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=twbb_h5\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"tei1b1nl\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"editor\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse varius enim in eros elementum tristique.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"yxnj5nv8\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"icon_list\":[{\"text\":\"Tag one\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}},{\"text\":\"Tag two\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}},{\"text\":\"Tag three\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}}],\"space_between\":{\"size\":16,\"unit\":\"px\",\"sizes\":[]},\"space_between_mobile\":{\"size\":4,\"unit\":\"px\",\"sizes\":[]},\"text_indent\":{\"size\":0,\"unit\":\"px\",\"sizes\":[]},\"icon_align\":\"left\",\"__globals__\":{\"icon_color\":\"globals\\/colors?id=secondary\",\"text_color\":\"globals\\/colors?id=text\",\"icon_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"12\",\"unit\":\"px\",\"sizes\":[]},\"icon_size_mobile\":{\"size\":\"10\",\"unit\":\"px\",\"sizes\":[]},\"view\":\"inline\"},\"elType\":\"widget\",\"widgetType\":\"icon-list\",\"id\":\"05ulu27v\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"text\":\"View Project\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"0\",\"bottom\":\"12\",\"left\":\"0\",\"isLinked\":false},\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=accent\",\"background_color\":\"globals\\/colors?id=twbb_transparent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_transparent\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_accent_hover\"},\"border_border\":\"none\",\"button_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":0,\"spread\":0,\"color\":\"#000000\"},\"button_box_shadow_box_shadow_type\":\"yes\",\"selected_icon\":{\"value\":\"fas fa-angle-right\",\"library\":\"fa-solid\"},\"icon_align\":\"right\",\"icon_indent\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"1nacu95z\"}]}]}]}],\"isInner\":\"false\"},{\"id\":\"60c4d43\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/portfolio\\/portfolio_4\\/background_color_type-none--background_media_type-none--cards_type-high_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"7ubjroib\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Portfolio\",\"header_size\":\"h5\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=twbb_label\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"e70k6s8n\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Short heading goes here\",\"header_size\":\"h2\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"j8ffp5jq\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit.\",\"align\":\"center\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"1tv3nla6\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"48\",\"right\":\"48\",\"top\":\"48\",\"bottom\":\"48\",\"unit\":\"px\",\"isLinked\":false},\"margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"48\",\"right\":\"48\",\"top\":\"48\",\"bottom\":\"48\",\"unit\":\"px\",\"isLinked\":false},\"margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"48\",\"right\":\"48\",\"top\":\"48\",\"bottom\":\"48\",\"unit\":\"px\",\"isLinked\":false},\"margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"__globals__\":{\"background_color\":\"globals\\/colors?id=twbb_bg_inv\"},\"background_background\":\"classic\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"r81005wf\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_margin\":{\"left\":\"-48\",\"right\":\"-48\",\"top\":\"-48\",\"bottom\":\"10\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-portfolio1.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"height\":{\"unit\":\"custom\",\"size\":\"calc(100% + 48px)\",\"sizes\":[]},\"object-fit\":\"cover\"},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"aqv9j3r5\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_justify_content\":\"space-between\",\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"c1y2b43k\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"gse3gxt4\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Project name here\",\"header_size\":\"h5\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"typography_typography\":\"globals\\/typography?id=twbb_h5\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"3mgbwueg\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"icon_list\":[{\"text\":\"Tag one\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}},{\"text\":\"Tag two\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}},{\"text\":\"Tag three\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}}],\"space_between\":{\"size\":16,\"unit\":\"px\",\"sizes\":[]},\"space_between_mobile\":{\"size\":4,\"unit\":\"px\",\"sizes\":[]},\"text_indent\":{\"size\":0,\"unit\":\"px\",\"sizes\":[]},\"icon_align\":\"left\",\"__globals__\":{\"icon_color\":\"globals\\/colors?id=twbb_text_inv\",\"text_color\":\"globals\\/colors?id=twbb_text_inv\",\"icon_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"12\",\"unit\":\"px\",\"sizes\":[]},\"icon_size_mobile\":{\"size\":\"10\",\"unit\":\"px\",\"sizes\":[]},\"view\":\"inline\"},\"elType\":\"widget\",\"widgetType\":\"icon-list\",\"id\":\"6n8ex5z5\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"text\":\"View Project\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"0\",\"bottom\":\"12\",\"left\":\"0\",\"isLinked\":false},\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"background_color\":\"globals\\/colors?id=twbb_transparent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_transparent\",\"border_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_button_inv\"},\"border_border\":\"none\",\"button_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":0,\"spread\":0,\"color\":\"#000000\"},\"button_box_shadow_box_shadow_type\":\"yes\",\"selected_icon\":{\"value\":\"fas fa-angle-right\",\"library\":\"fa-solid\"},\"icon_align\":\"right\",\"icon_indent\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"5zg22fj0\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_margin\":{\"left\":\"10\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse varius enim in eros elementum tristique. Duis cursus, mi quis viverra ornare, eros dolor interdum nulla, ut commodo diam libero vitae erat.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=twbb_text_inv\",\"typography_typography\":\"globals\\/typography?id=twbb_p3\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"bh4990vt\"}]}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"48\",\"right\":\"48\",\"top\":\"48\",\"bottom\":\"48\",\"unit\":\"px\",\"isLinked\":false},\"margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"48\",\"right\":\"48\",\"top\":\"48\",\"bottom\":\"48\",\"unit\":\"px\",\"isLinked\":false},\"margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"48\",\"right\":\"48\",\"top\":\"48\",\"bottom\":\"48\",\"unit\":\"px\",\"isLinked\":false},\"margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"__globals__\":{\"background_color\":\"globals\\/colors?id=twbb_bg_inv\"},\"background_background\":\"classic\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"wue0aqrn\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_margin\":{\"left\":\"-48\",\"right\":\"-48\",\"top\":\"-48\",\"bottom\":\"10\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-portfolio2.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"height\":{\"unit\":\"custom\",\"size\":\"calc(100% + 48px)\",\"sizes\":[]},\"object-fit\":\"cover\"},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"a4lrczk0\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_justify_content\":\"space-between\",\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"mszldzpb\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"iu7spxa9\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Project name here\",\"header_size\":\"h5\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"typography_typography\":\"globals\\/typography?id=twbb_h5\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"oyr06kd4\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"icon_list\":[{\"text\":\"Tag one\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}},{\"text\":\"Tag two\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}},{\"text\":\"Tag three\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}}],\"space_between\":{\"size\":16,\"unit\":\"px\",\"sizes\":[]},\"space_between_mobile\":{\"size\":4,\"unit\":\"px\",\"sizes\":[]},\"text_indent\":{\"size\":0,\"unit\":\"px\",\"sizes\":[]},\"icon_align\":\"left\",\"__globals__\":{\"icon_color\":\"globals\\/colors?id=twbb_text_inv\",\"text_color\":\"globals\\/colors?id=twbb_text_inv\",\"icon_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"12\",\"unit\":\"px\",\"sizes\":[]},\"icon_size_mobile\":{\"size\":\"10\",\"unit\":\"px\",\"sizes\":[]},\"view\":\"inline\"},\"elType\":\"widget\",\"widgetType\":\"icon-list\",\"id\":\"xivn6tov\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_margin\":{\"left\":\"10\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse varius enim in eros elementum tristique. Duis cursus, mi quis viverra ornare, eros dolor interdum nulla, ut commodo diam libero vitae erat.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=twbb_text_inv\",\"typography_typography\":\"globals\\/typography?id=twbb_p3\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"g9w8lkxa\"}]}]}]}],\"isInner\":\"false\"},{\"id\":\"3679eeb\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/portfolio\\/portfolio_6h\\/background_color_type-none--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"krr9b9fp\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-portfolio1.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"vybu9cep\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"lieu46bh\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":58,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"wafrh4yg\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"title\":\"Project name here\",\"header_size\":\"h1\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"1j3ya4o3\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse varius enim in eros elementum tristique.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"c4ggd6ol\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"icon_list\":[{\"text\":\"Tag one\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}},{\"text\":\"Tag two\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}},{\"text\":\"Tag three\",\"selected_icon\":{\"value\":\"fas fa-hashtag\",\"library\":\"fa-solid\"}}],\"space_between\":{\"size\":16,\"unit\":\"px\",\"sizes\":[]},\"space_between_mobile\":{\"size\":4,\"unit\":\"px\",\"sizes\":[]},\"text_indent\":{\"size\":0,\"unit\":\"px\",\"sizes\":[]},\"icon_align\":\"left\",\"__globals__\":{\"icon_color\":\"globals\\/colors?id=secondary\",\"text_color\":\"globals\\/colors?id=text\",\"icon_typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"icon_size\":{\"size\":\"18\",\"unit\":\"px\",\"sizes\":[]},\"icon_size_mobile\":{\"size\":\"16\",\"unit\":\"px\",\"sizes\":[]},\"view\":\"inline\"},\"elType\":\"widget\",\"widgetType\":\"icon-list\",\"id\":\"je7kz58b\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":41,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":41,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"container_type\":\"grid\",\"grid_columns_grid\":{\"unit\":\"fr\",\"size\":2,\"sizes\":[]},\"grid_rows_grid\":{\"unit\":\"fr\",\"size\":2,\"sizes\":[]},\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"8525ihjt\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"mw44az2y\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"title\":\"Client\",\"header_size\":\"h5\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=twbb_h5\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"8uxikb9q\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"editor\":\"Full name\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"2zejo6by\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"q2jbcqft\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"title\":\"Date\",\"header_size\":\"h5\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=twbb_h5\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"mytx8j4z\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"editor\":\"August 2023\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"9z42ewuu\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"je4pz1gi\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"title\":\"Role\",\"header_size\":\"h5\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=twbb_h5\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"t7qmsedn\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"editor\":\"Role name\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"w1tb50gz\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"b6zf27kk\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"title\":\"Link\",\"header_size\":\"h5\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=twbb_h5\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"js8cgy22\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"editor\":\"https:\\/\\/www.example.com\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"t8dgjljy\"}]}]}]}]}],\"isInner\":\"false\"},{\"id\":\"dc1a815\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/pricing\\/pricing_19_1\\/background_color_type-none--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Pricing\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"qytvngox\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":77,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":77,\"sizes\":[]},\"title\":\"Price list\",\"header_size\":\"h2\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"l3rb367l\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":77,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":77,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Here is an overview of your pricing plan. This includes a brief description of the service, key features, and other relevant information for potential customers.\",\"align\":\"center\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"0mv2896x\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"ar57r06i\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"50\",\"right\":\"50\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"50\",\"right\":\"50\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"50\",\"right\":\"50\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"css_classes\":\"twbb_dummy\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"__globals__\":{\"background_color\":\"globals\\/colors?id=twbb_bg_1\"},\"background_background\":\"classic\",\"flex_justify_content\":\"space-between\",\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"y0fdijuq\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"keiqetdb\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Basic\",\"header_size\":\"h4\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=twbb_h4\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"mmu6qzkk\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"20\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"20\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"title\":\"$10\\/mo\",\"header_size\":\"h4\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=twbb_h4\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"ft09iihb\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"editor\":\"This is a description of the plan\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"lix57ckn\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"icon_list\":[{\"text\":\"Feature 1\",\"selected_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"}},{\"text\":\"Feature 2\",\"selected_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"}},{\"text\":\"Feature 3\",\"selected_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"}}],\"space_between\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"space_between_mobile\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"text_indent\":{\"size\":\"12\",\"unit\":\"px\",\"sizes\":[]},\"icon_align\":\"left\",\"__globals__\":{\"icon_color\":\"globals\\/colors?id=text\",\"text_color\":\"globals\\/colors?id=text\",\"icon_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"12\",\"unit\":\"px\",\"sizes\":[]},\"icon_size_mobile\":{\"size\":\"10\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-list\",\"id\":\"j4xaua9g\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"10\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"text\":\"Buy Now\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"background_color\":\"globals\\/colors?id=accent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_accent_hover\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_accent_hover\",\"hover_color\":\"globals\\/colors?id=twbb_button_inv\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"tl2jl6e2\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"50\",\"right\":\"50\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"50\",\"right\":\"50\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"50\",\"right\":\"50\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"css_classes\":\"twbb_dummy\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"__globals__\":{\"background_color\":\"globals\\/colors?id=accent\"},\"background_background\":\"classic\",\"flex_justify_content\":\"space-between\",\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"685peiv1\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"rzvv36k7\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Standard\",\"header_size\":\"h4\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"typography_typography\":\"globals\\/typography?id=twbb_h4\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"7ufc5xp7\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"20\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"20\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"title\":\"$199\\/mo\",\"header_size\":\"h4\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"typography_typography\":\"globals\\/typography?id=twbb_h4\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"mnp5qy4g\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"editor\":\"This is a description of the plan\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=twbb_text_inv\",\"typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"057h1zoq\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"icon_list\":[{\"text\":\"Feature 1\",\"selected_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"}},{\"text\":\"Feature 2\",\"selected_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"}},{\"text\":\"Feature 3\",\"selected_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"}},{\"text\":\"Feature 4\",\"selected_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"}}],\"space_between\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"space_between_mobile\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"text_indent\":{\"size\":\"12\",\"unit\":\"px\",\"sizes\":[]},\"icon_align\":\"left\",\"__globals__\":{\"icon_color\":\"globals\\/colors?id=twbb_text_inv\",\"text_color\":\"globals\\/colors?id=twbb_text_inv\",\"icon_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"12\",\"unit\":\"px\",\"sizes\":[]},\"icon_size_mobile\":{\"size\":\"10\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-list\",\"id\":\"mwufsd5n\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"10\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"text\":\"Buy Now\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button\",\"background_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"border_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"hover_color\":\"globals\\/colors?id=twbb_button\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"7udn16iv\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"50\",\"right\":\"50\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"50\",\"right\":\"50\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"50\",\"right\":\"50\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"css_classes\":\"twbb_dummy\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"__globals__\":{\"background_color\":\"globals\\/colors?id=twbb_bg_1\"},\"background_background\":\"classic\",\"flex_justify_content\":\"space-between\",\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"jjieeqp3\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items\":\"flex-start\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"0m1uxz7p\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Premium\",\"header_size\":\"h4\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=twbb_h4\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"fyuo6f8b\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"20\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"20\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"title\":\"$30\\/mo\",\"header_size\":\"h4\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=twbb_h4\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"i74wahhu\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"editor\":\"This is a description of the plan\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"mh9guwab\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"icon_list\":[{\"text\":\"Feature 1\",\"selected_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"}},{\"text\":\"Feature 2\",\"selected_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"}},{\"text\":\"Feature 3\",\"selected_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"}},{\"text\":\"Feature 4\",\"selected_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"}}],\"space_between\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"space_between_mobile\":{\"unit\":\"px\",\"size\":4,\"sizes\":[]},\"text_indent\":{\"size\":\"12\",\"unit\":\"px\",\"sizes\":[]},\"icon_align\":\"left\",\"__globals__\":{\"icon_color\":\"globals\\/colors?id=text\",\"text_color\":\"globals\\/colors?id=text\",\"icon_typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"icon_size\":{\"size\":\"12\",\"unit\":\"px\",\"sizes\":[]},\"icon_size_mobile\":{\"size\":\"10\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-list\",\"id\":\"gxg3nd4c\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"10\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"text\":\"Buy Now\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"background_color\":\"globals\\/colors?id=accent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_accent_hover\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_accent_hover\",\"hover_color\":\"globals\\/colors?id=twbb_button_inv\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"a66vquzq\"}]}]}]}],\"isInner\":\"false\"},{\"id\":\"81ef90b\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/pricing\\/pricing_19_2\\/background_color_type-none--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Pricing\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"tftj9fzt\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":77,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":77,\"sizes\":[]},\"title\":\"Price list\",\"header_size\":\"h2\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"3497ktav\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":77,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":77,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Here is an overview of your pricing plan. This includes a brief description of the service, key features, and other relevant information for potential customers.\",\"align\":\"center\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"4agr9svm\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"ki4nv1g6\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"50\",\"right\":\"50\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"50\",\"right\":\"50\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"50\",\"right\":\"50\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"css_classes\":\"twbb_dummy\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"__globals__\":{\"background_color\":\"globals\\/colors?id=twbb_bg_1\"},\"background_background\":\"classic\",\"flex_justify_content\":\"space-between\",\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"5c4co861\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"5mi0si8i\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Basic\",\"header_size\":\"h4\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=twbb_h4\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"hi30vi2e\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"editor\":\"This is a description of the plan\",\"align\":\"center\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"a5m55e2f\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"__globals__\":{\"color\":\"globals\\/colors?id=twbb_bg_inv\"}},\"elType\":\"widget\",\"widgetType\":\"divider\",\"id\":\"au2hyhcg\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"20\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"20\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"title\":\"$10\\/mo\",\"header_size\":\"h4\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=twbb_h4\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"ksmxsnca\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"10\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"text\":\"Buy Now\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"background_color\":\"globals\\/colors?id=accent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_accent_hover\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_accent_hover\",\"hover_color\":\"globals\\/colors?id=twbb_button_inv\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"bykcdz68\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"50\",\"right\":\"50\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"50\",\"right\":\"50\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"50\",\"right\":\"50\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"css_classes\":\"twbb_dummy\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"__globals__\":{\"background_color\":\"globals\\/colors?id=accent\"},\"background_background\":\"classic\",\"flex_justify_content\":\"space-between\",\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"sbxmiori\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"t3g3rb8n\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Standard\",\"header_size\":\"h4\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"typography_typography\":\"globals\\/typography?id=twbb_h4\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"uxdgo0b5\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"editor\":\"This is a description of the plan\",\"align\":\"center\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=twbb_text_inv\",\"typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"gh5zz258\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"__globals__\":{\"color\":\"globals\\/colors?id=twbb_bg_primary\"}},\"elType\":\"widget\",\"widgetType\":\"divider\",\"id\":\"dw8apvxn\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"20\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"20\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"title\":\"$20\\/mo\",\"header_size\":\"h4\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"typography_typography\":\"globals\\/typography?id=twbb_h4\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"0sbfct7o\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"10\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"text\":\"Buy Now\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button\",\"background_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"border_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"hover_color\":\"globals\\/colors?id=twbb_button\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"2ius1522\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"50\",\"right\":\"50\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"50\",\"right\":\"50\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"50\",\"right\":\"50\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"css_classes\":\"twbb_dummy\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"__globals__\":{\"background_color\":\"globals\\/colors?id=twbb_bg_1\"},\"background_background\":\"classic\",\"flex_justify_content\":\"space-between\",\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"qgmrfxfj\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"sg2xrggc\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Premium\",\"header_size\":\"h4\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=twbb_h4\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"817j6cmj\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"editor\":\"This is a description of the plan\",\"align\":\"center\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p4\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"zd5n28u1\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"__globals__\":{\"color\":\"globals\\/colors?id=twbb_bg_inv\"}},\"elType\":\"widget\",\"widgetType\":\"divider\",\"id\":\"p28kfxux\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"20\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"20\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"title\":\"$30\\/mo\",\"header_size\":\"h4\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=twbb_h4\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"d3utdqtb\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"10\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"text\":\"Buy Now\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"background_color\":\"globals\\/colors?id=accent\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_accent_hover\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_accent_hover\",\"hover_color\":\"globals\\/colors?id=twbb_button_inv\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"74iu8p58\"}]}]}]}],\"isInner\":\"false\"},{\"id\":\"39072ac\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/products_categories\\/product_categories_0\\/background_color_type-none--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section twbb_full_h\",\"_title\":\"Product categories\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"min_height\":{\"size\":\"80\",\"unit\":\"vh\",\"sizes\":[]},\"min_height_mobile\":{\"size\":\"64.0\",\"unit\":\"vh\",\"sizes\":[]},\"flex_justify_content\":\"center\",\"flex_align_items_mobile\":\"flex-start\",\"overflow\":\"hidden\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"n0qz3iv5\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_justify_content\":\"space-between\",\"flex_align_items\":\"flex-end\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"6s28zruf\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"8um23kkc\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"title\":\"Shop by category\",\"header_size\":\"h2\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"d1035pz3\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"editor\":\"Discover our collection of products\",\"align\":\"center\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"7jpy8qsd\"}]}]},{\"settings\":{\"_flex_align_self_mobile\":\"flex-end\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_border_border\":\"none\",\"_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"categories_count\":\"none\",\"row_gap\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"column_gap\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"regulate_image_height\":\"yes\",\"image_height\":{\"unit\":\"vh\",\"size\":80,\"sizes\":[]},\"image_height_mobile\":{\"unit\":\"vh\",\"size\":70,\"sizes\":[]},\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_typography_typography\":\"globals\\/typography?id=twbb_h5\",\"title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"border_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_text_color\":\"globals\\/colors?id=twbb_button\",\"background_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"hover_color\":\"globals\\/colors?id=twbb_button\",\"arrows_color\":\"globals\\/colors?id=twbb_button\",\"pagination_color_active\":\"globals\\/colors?id=twbb_button\",\"pagination_color_secondary\":\"globals\\/colors?id=twbb_button\"},\"border_border\":\"solid\",\"background_background\":\"classic\",\"number\":4,\"columns\":2,\"image_spacing_laptop\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"image_spacing_tablet\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"_flex_align_self\":\"center\",\"columns_mobile\":1,\"columns_tablet\":2,\"hide_empty\":\"yes\",\"image_spacing_mobile\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_element_custom_width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"order\":\"asc\",\"content_horizontal_position\":\"left\",\"content_vertical_position\":\"flex-end\",\"image_overlay\":\"rgba(51,51,51,0.5)\",\"content_animation_duration\":{\"unit\":\"px\",\"size\":250,\"sizes\":[]},\"button_text\":\"Shop Now\",\"category_title_position\":\"inside\",\"title_spacing\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]},\"box_padding\":{\"unit\":\"px\",\"top\":\"48\",\"right\":\"48\",\"bottom\":\"48\",\"left\":\"48\",\"isLinked\":true},\"image_hover_animation\":\"grow\",\"show_button\":\"yes\",\"show_title\":\"block\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"twbb_woocommerce-categories\",\"id\":\"9zcd17gc\"}]}],\"isInner\":\"false\"},{\"id\":\"9402fb6\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/products_categories\\/product_categories_1\\/background_color_type-none--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section twbb_full_h\",\"_title\":\"Product categories\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"min_height\":{\"size\":\"80\",\"unit\":\"vh\",\"sizes\":[]},\"min_height_mobile\":{\"size\":\"64.0\",\"unit\":\"vh\",\"sizes\":[]},\"flex_justify_content\":\"center\",\"flex_align_items_mobile\":\"flex-start\",\"overflow\":\"hidden\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"4w9q5mky\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"flex-end\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_border_border\":\"none\",\"_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"categories_count\":\"none\",\"row_gap\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"column_gap\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"regulate_image_height\":\"yes\",\"image_height\":{\"unit\":\"vh\",\"size\":80,\"sizes\":[]},\"image_height_mobile\":{\"unit\":\"vh\",\"size\":70,\"sizes\":[]},\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_typography_typography\":\"globals\\/typography?id=twbb_h5\",\"title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"border_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_text_color\":\"globals\\/colors?id=twbb_button\",\"background_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"hover_color\":\"globals\\/colors?id=twbb_button\",\"arrows_color\":\"globals\\/colors?id=twbb_button\",\"pagination_color_active\":\"globals\\/colors?id=twbb_button\",\"pagination_color_secondary\":\"globals\\/colors?id=twbb_button\"},\"border_border\":\"solid\",\"background_background\":\"classic\",\"number\":4,\"columns\":2,\"image_spacing_laptop\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"image_spacing_tablet\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"_flex_align_self\":\"center\",\"columns_mobile\":1,\"columns_tablet\":2,\"hide_empty\":\"yes\",\"image_spacing_mobile\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_element_custom_width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"order\":\"asc\",\"content_horizontal_position\":\"left\",\"content_vertical_position\":\"flex-end\",\"image_overlay\":\"rgba(51,51,51,0.5)\",\"content_animation_duration\":{\"unit\":\"px\",\"size\":250,\"sizes\":[]},\"button_text\":\"Shop Now\",\"category_title_position\":\"inside\",\"title_spacing\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]},\"box_padding\":{\"unit\":\"px\",\"top\":\"48\",\"right\":\"48\",\"bottom\":\"48\",\"left\":\"48\",\"isLinked\":true},\"image_hover_animation\":\"grow\",\"show_button\":\"yes\",\"show_title\":\"block\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"twbb_woocommerce-categories\",\"id\":\"jo9wqebq\"}]}],\"isInner\":\"false\"},{\"id\":\"ad3c162\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/products_categories\\/product_categories_3\\/background_color_type-none--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Product categories\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_justify_content\":\"center\",\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"hjuc11ox\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"title\":\"Shop by category\",\"header_size\":\"h4\",\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"6m893aoi\"},{\"settings\":{\"_flex_align_self_mobile\":\"flex-end\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_border_border\":\"none\",\"_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"categories_count\":\"none\",\"row_gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"column_gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"regulate_image_height\":\"yes\",\"image_height\":{\"unit\":\"vh\",\"size\":95,\"sizes\":[]},\"image_height_mobile\":{\"unit\":\"vh\",\"size\":70,\"sizes\":[]},\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_typography_typography\":\"globals\\/typography?id=twbb_h5\",\"title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"border_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_text_color\":\"globals\\/colors?id=twbb_button\",\"background_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"hover_color\":\"globals\\/colors?id=twbb_button\",\"arrows_color\":\"globals\\/colors?id=twbb_button\",\"pagination_color_active\":\"globals\\/colors?id=twbb_button\",\"pagination_color_secondary\":\"globals\\/colors?id=twbb_button\"},\"border_border\":\"solid\",\"background_background\":\"classic\",\"number\":4,\"columns\":3,\"image_spacing_laptop\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"image_spacing_tablet\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"_flex_align_self\":\"center\",\"columns_mobile\":1,\"columns_tablet\":3,\"hide_empty\":\"yes\",\"image_spacing_mobile\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_element_custom_width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"order\":\"asc\",\"content_horizontal_position\":\"center\",\"content_vertical_position\":\"center\",\"image_overlay\":\"rgba(51,51,51,0.5)\",\"content_animation_duration\":{\"unit\":\"px\",\"size\":250,\"sizes\":[]},\"button_text\":\"Shop Now\",\"category_title_position\":\"inside\",\"title_spacing\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]},\"box_padding\":{\"unit\":\"px\",\"top\":\"48\",\"right\":\"48\",\"bottom\":\"48\",\"left\":\"48\",\"isLinked\":true},\"image_hover_animation\":\"grow\",\"show_button\":\"yes\",\"show_title\":\"block\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"image_border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"slider_view\":\"yes\",\"carousel_full_width_mobile\":\"yes\",\"carousel_full_width\":\"\",\"navigation_position\":\"inside\",\"pagination_alignment\":\"center\",\"pagination_position\":\"inside\",\"pause_on_interaction\":\"\",\"show_arrows\":\"\",\"autoplay\":\"yes\",\"autoplay_speed\":4000,\"loop\":\"yes\",\"navigation_position_mobile\":\"inside\",\"_padding_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"35\",\"bottom\":\"0\",\"left\":\"35\",\"isLinked\":false}},\"elType\":\"widget\",\"widgetType\":\"twbb_woocommerce-categories\",\"id\":\"ng8h2ury\"}]}],\"isInner\":\"false\"},{\"id\":\"c647672\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/products_categories\\/product_categories_4\\/background_color_type-none--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Product categories\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_align_items_mobile\":\"flex-start\",\"overflow\":\"hidden\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"e11oed3b\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"flex-end\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_border_border\":\"none\",\"_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"categories_count\":\"none\",\"row_gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"column_gap\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"regulate_image_height\":\"yes\",\"image_height\":{\"unit\":\"vh\",\"size\":95,\"sizes\":[]},\"image_height_mobile\":{\"unit\":\"vh\",\"size\":70,\"sizes\":[]},\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_typography_typography\":\"globals\\/typography?id=twbb_h5\",\"title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"border_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_text_color\":\"globals\\/colors?id=twbb_button\",\"background_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"hover_color\":\"globals\\/colors?id=twbb_button\",\"arrows_color\":\"globals\\/colors?id=twbb_button\",\"pagination_color_active\":\"globals\\/colors?id=twbb_button\",\"pagination_color_secondary\":\"globals\\/colors?id=twbb_button\"},\"border_border\":\"solid\",\"background_background\":\"classic\",\"number\":4,\"columns\":3,\"image_spacing_laptop\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"image_spacing_tablet\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"_flex_align_self\":\"center\",\"columns_mobile\":1,\"columns_tablet\":3,\"hide_empty\":\"yes\",\"image_spacing_mobile\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_element_custom_width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"order\":\"asc\",\"content_horizontal_position\":\"center\",\"content_vertical_position\":\"center\",\"image_overlay\":\"rgba(51,51,51,0.5)\",\"content_animation_duration\":{\"unit\":\"px\",\"size\":250,\"sizes\":[]},\"button_text\":\"Shop Now\",\"category_title_position\":\"inside\",\"title_spacing\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]},\"box_padding\":{\"unit\":\"px\",\"top\":\"48\",\"right\":\"48\",\"bottom\":\"48\",\"left\":\"48\",\"isLinked\":true},\"image_hover_animation\":\"grow\",\"show_button\":\"yes\",\"show_title\":\"block\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"slider_view\":\"yes\",\"carousel_full_width_mobile\":\"yes\",\"navigation_position\":\"inside\",\"autoplay\":\"yes\",\"loop\":\"yes\",\"pagination_alignment\":\"center\",\"show_arrows_mobile\":\"\",\"navigation_position_mobile\":\"inside\"},\"elType\":\"widget\",\"widgetType\":\"twbb_woocommerce-categories\",\"id\":\"e32saz2c\"}]}],\"isInner\":\"false\"},{\"id\":\"3f82a98\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/products_categories\\/product_categories_5\\/background_color_type-none--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Product categories\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_justify_content\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"pz56fvj3\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"flex-end\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_border_border\":\"none\",\"_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"categories_count\":\"none\",\"row_gap\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"column_gap\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"regulate_image_height\":\"yes\",\"image_height\":{\"unit\":\"vh\",\"size\":80,\"sizes\":[]},\"image_height_mobile\":{\"unit\":\"vh\",\"size\":70,\"sizes\":[]},\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_typography_typography\":\"globals\\/typography?id=twbb_h5\",\"title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"border_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_text_color\":\"globals\\/colors?id=twbb_button\",\"background_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"hover_color\":\"globals\\/colors?id=twbb_button\",\"arrows_color\":\"globals\\/colors?id=twbb_button\",\"pagination_color_active\":\"globals\\/colors?id=twbb_button\",\"pagination_color_secondary\":\"globals\\/colors?id=twbb_button\"},\"border_border\":\"solid\",\"background_background\":\"classic\",\"number\":4,\"columns\":2,\"image_spacing_laptop\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"image_spacing_tablet\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"_flex_align_self\":\"center\",\"columns_mobile\":1,\"columns_tablet\":2,\"hide_empty\":\"yes\",\"image_spacing_mobile\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_element_custom_width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"order\":\"asc\",\"content_horizontal_position\":\"center\",\"content_vertical_position\":\"center\",\"image_overlay\":\"rgba(51,51,51,0.5)\",\"content_animation_duration\":{\"unit\":\"px\",\"size\":250,\"sizes\":[]},\"button_text\":\"Shop Now\",\"category_title_position\":\"inside\",\"title_spacing\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]},\"box_padding\":{\"unit\":\"px\",\"top\":\"48\",\"right\":\"48\",\"bottom\":\"48\",\"left\":\"48\",\"isLinked\":true},\"image_hover_animation\":\"grow\",\"show_button\":\"yes\",\"show_title\":\"block\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"image_border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"slider_view\":\"yes\",\"carousel_full_width_mobile\":\"yes\",\"carousel_full_width\":\"\",\"navigation_position\":\"inside\",\"autoplay\":\"\",\"loop\":\"yes\",\"pagination_alignment\":\"center\",\"show_pagination\":\"\",\"show_arrows_mobile\":\"\"},\"elType\":\"widget\",\"widgetType\":\"twbb_woocommerce-categories\",\"id\":\"j0jezq1e\"}]}],\"isInner\":\"false\"},{\"id\":\"0ec7301\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/products_categories\\/product_categories_6\\/background_color_type-none--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Product categories\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"3bbmqg06\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"title\":\"Shop by category\",\"header_size\":\"h5\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"u3jgu8zx\"},{\"settings\":{\"_flex_align_self_mobile\":\"flex-end\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_border_border\":\"none\",\"_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"categories_count\":\"none\",\"row_gap\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"column_gap\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"regulate_image_height\":\"yes\",\"image_height\":{\"unit\":\"vh\",\"size\":80,\"sizes\":[]},\"image_height_mobile\":{\"unit\":\"vh\",\"size\":70,\"sizes\":[]},\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_typography_typography\":\"globals\\/typography?id=twbb_h5\",\"title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"border_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_text_color\":\"globals\\/colors?id=twbb_button\",\"background_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"hover_color\":\"globals\\/colors?id=twbb_button\",\"arrows_color\":\"globals\\/colors?id=twbb_button\",\"pagination_color_active\":\"globals\\/colors?id=twbb_button\",\"pagination_color_secondary\":\"globals\\/colors?id=twbb_button\"},\"border_border\":\"solid\",\"background_background\":\"classic\",\"number\":4,\"columns\":2,\"image_spacing_laptop\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"image_spacing_tablet\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"_flex_align_self\":\"center\",\"columns_mobile\":1,\"columns_tablet\":2,\"hide_empty\":\"yes\",\"image_spacing_mobile\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_element_custom_width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"order\":\"asc\",\"content_horizontal_position\":\"center\",\"content_vertical_position\":\"center\",\"image_overlay\":\"rgba(51,51,51,0.5)\",\"content_animation_duration\":{\"unit\":\"px\",\"size\":250,\"sizes\":[]},\"button_text\":\"Shop Now\",\"category_title_position\":\"inside\",\"title_spacing\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]},\"box_padding\":{\"unit\":\"px\",\"top\":\"48\",\"right\":\"48\",\"bottom\":\"48\",\"left\":\"48\",\"isLinked\":true},\"image_hover_animation\":\"grow\",\"show_button\":\"yes\",\"show_title\":\"block\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"image_border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"slider_view\":\"yes\",\"carousel_full_width_mobile\":\"yes\",\"slides_per_view\":2,\"slides_per_view_mobile\":1,\"autoplay\":\"\",\"loop\":\"\",\"show_arrows_mobile\":\"\",\"_padding_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"35\",\"bottom\":\"0\",\"left\":\"35\",\"isLinked\":false}},\"elType\":\"widget\",\"widgetType\":\"twbb_woocommerce-categories\",\"id\":\"ggvvsu81\"}]}],\"isInner\":\"false\"},{\"id\":\"fcab567\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/products_categories\\/product_categories_7\\/background_color_type-none--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Product categories\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"e1k6cc4s\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"title\":\"Shop now\",\"header_size\":\"h5\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"ka2xb09k\"},{\"settings\":{\"_flex_align_self_mobile\":\"flex-end\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_border_border\":\"none\",\"_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"categories_count\":\"none\",\"row_gap\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"column_gap\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"regulate_image_height\":\"yes\",\"image_height\":{\"unit\":\"vh\",\"size\":80,\"sizes\":[]},\"image_height_mobile\":{\"unit\":\"vh\",\"size\":70,\"sizes\":[]},\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_typography_typography\":\"globals\\/typography?id=twbb_h5\",\"title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"border_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_text_color\":\"globals\\/colors?id=twbb_button\",\"background_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"hover_color\":\"globals\\/colors?id=twbb_button\",\"arrows_color\":\"globals\\/colors?id=twbb_button\",\"pagination_color_active\":\"globals\\/colors?id=twbb_button\",\"pagination_color_secondary\":\"globals\\/colors?id=twbb_button\"},\"border_border\":\"solid\",\"background_background\":\"classic\",\"number\":4,\"columns\":2,\"image_spacing_laptop\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"image_spacing_tablet\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"_flex_align_self\":\"center\",\"columns_mobile\":1,\"columns_tablet\":2,\"hide_empty\":\"yes\",\"image_spacing_mobile\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_element_custom_width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"order\":\"asc\",\"content_horizontal_position\":\"center\",\"content_vertical_position\":\"center\",\"image_overlay\":\"rgba(51,51,51,0.5)\",\"content_animation_duration\":{\"unit\":\"px\",\"size\":250,\"sizes\":[]},\"button_text\":\"Shop Now\",\"category_title_position\":\"inside\",\"title_spacing\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]},\"box_padding\":{\"unit\":\"px\",\"top\":\"48\",\"right\":\"48\",\"bottom\":\"48\",\"left\":\"48\",\"isLinked\":true},\"image_hover_animation\":\"grow\",\"show_button\":\"yes\",\"show_title\":\"block\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"image_border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"slider_view\":\"yes\",\"carousel_full_width_mobile\":\"yes\",\"slides_per_view\":2,\"slides_per_view_mobile\":1,\"navigation_position\":\"inside\",\"autoplay\":\"\",\"loop\":\"\",\"show_arrows_mobile\":\"\",\"show_pagination\":\"\",\"hide_edge_arrows\":\"hide\",\"_padding_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"35\",\"bottom\":\"0\",\"left\":\"35\",\"isLinked\":false}},\"elType\":\"widget\",\"widgetType\":\"twbb_woocommerce-categories\",\"id\":\"kvatx5i9\"}]}],\"isInner\":\"false\"},{\"id\":\"ea92b64\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/products_categories\\/product_categories_8\\/background_color_type-none--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Product categories\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_justify_content\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"gshbmfqb\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"flex-end\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_border_border\":\"none\",\"_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"categories_count\":\"none\",\"row_gap\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"column_gap\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"regulate_image_height\":\"yes\",\"image_height\":{\"unit\":\"vh\",\"size\":80,\"sizes\":[]},\"image_height_mobile\":{\"unit\":\"vh\",\"size\":70,\"sizes\":[]},\"align\":\"center\",\"align_mobile\":\"center\",\"__globals__\":{\"title_typography_typography\":\"globals\\/typography?id=twbb_h5\",\"title_color\":\"globals\\/colors?id=twbb_primary_inv\",\"border_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_text_color\":\"globals\\/colors?id=twbb_button\",\"background_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_background_hover_color\":\"globals\\/colors?id=twbb_button_inv\",\"button_hover_border_color\":\"globals\\/colors?id=twbb_button_inv\",\"hover_color\":\"globals\\/colors?id=twbb_button\",\"arrows_color\":\"globals\\/colors?id=twbb_button\",\"pagination_color_active\":\"globals\\/colors?id=twbb_button\",\"pagination_color_secondary\":\"globals\\/colors?id=twbb_button\"},\"border_border\":\"solid\",\"background_background\":\"classic\",\"number\":4,\"columns\":2,\"image_spacing_laptop\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"image_spacing_tablet\":{\"unit\":\"em\",\"size\":\"\",\"sizes\":[]},\"_flex_align_self\":\"center\",\"columns_mobile\":1,\"columns_tablet\":2,\"hide_empty\":\"yes\",\"image_spacing_mobile\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_element_custom_width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"order\":\"asc\",\"content_horizontal_position\":\"center\",\"content_vertical_position\":\"center\",\"image_overlay\":\"rgba(51,51,51,0.5)\",\"content_animation_duration\":{\"unit\":\"px\",\"size\":250,\"sizes\":[]},\"button_text\":\"Shop Now\",\"category_title_position\":\"inside\",\"title_spacing\":{\"size\":\"30\",\"unit\":\"px\",\"sizes\":[]},\"box_padding\":{\"unit\":\"px\",\"top\":\"48\",\"right\":\"48\",\"bottom\":\"48\",\"left\":\"48\",\"isLinked\":true},\"image_hover_animation\":\"grow\",\"show_button\":\"yes\",\"show_title\":\"block\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"image_border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"slider_view\":\"yes\",\"carousel_full_width_mobile\":\"yes\",\"slides_per_view\":2,\"slides_per_view_mobile\":1,\"navigation_position\":\"inside\",\"autoplay\":\"yes\",\"loop\":\"yes\",\"pagination_alignment\":\"center\",\"show_pagination\":\"\",\"_padding_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"35\",\"bottom\":\"0\",\"left\":\"35\",\"isLinked\":false}},\"elType\":\"widget\",\"widgetType\":\"twbb_woocommerce-categories\",\"id\":\"b4s3wr4t\"}]}],\"isInner\":\"false\"},{\"id\":\"22948e5\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/products_list\\/products_list_0\\/background_color_type-neutral--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Products list\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"__globals__\":{\"background_color\":\"globals\\/colors?id=twbb_bg_3\"},\"background_background\":\"classic\",\"flex_justify_content\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"40gloh38\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_justify_content\":\"space-between\",\"flex_align_items\":\"flex-end\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"zrd2x0ja\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"yo31c2lf\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Shop by category\",\"header_size\":\"h2\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"0mxvqlny\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"editor\":\"Discover our collection of products\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"cz538088\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_margin\":{\"left\":\"10\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"text\":\"View all\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"right\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=accent\",\"background_color\":\"globals\\/colors?id=twbb_transparent\",\"button_background_hover_color\":\"globals\\/colors?id=accent\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=accent\",\"hover_color\":\"globals\\/colors?id=twbb_button_inv\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"ihkb2cx4\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"ot229xyq\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"products_related_products_title_text\":\"Related Products\",\"products_upsells_title_text\":\"You may also like...\",\"products_cross_sells_title_text\":\"You may be interested in...\",\"query_post_type\":\"product\",\"query_include\":[],\"query_include_term_ids\":[],\"_skin\":\"classic\",\"modern_skin_hide_products_buttons\":\"always_show\",\"classic_skin_hide_products_buttons\":\"\",\"content_width\":\"full\",\"columns\":3,\"rows\":1,\"classic_skin_columns\":3,\"classic_skin_rows\":1,\"modern_skin_columns\":3,\"modern_skin_rows\":1,\"paginate\":\"no\",\"classic_skin_title_spacing\":{\"unit\":\"px\",\"size\":3,\"sizes\":[]},\"classic_skin_title_spacing_mobile\":16,\"classic_skin_desc_spacing\":18,\"classic_skin_desc_spacing_mobile\":16,\"classic_skin_onsale_border_radius\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"classic_skin_onsale_width\":{\"unit\":\"px\",\"size\":74,\"sizes\":[]},\"classic_skin_onsale_height\":{\"unit\":\"px\",\"size\":36,\"sizes\":[]},\"classic_skin_onsale_distance\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"modern_skin_hide_product_quantity\":\"yes\",\"classic_skin_hide_product_quantity\":\"yes\",\"classic_button_typography_typography\":\"custom\",\"classic_button_typography_font_family\":\"Montserrat\",\"classic_button_typography_font_size\":{\"unit\":\"px\",\"size\":\"14\",\"sizes\":[]},\"classic_button_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":\"14\",\"sizes\":[]},\"classic_button_typography_font_weight\":\"normal\",\"classic_button_typography_text_transform\":\"none\",\"classic_button_typography_font_style\":\"normal\",\"classic_button_typography_text_decoration\":\"underline\",\"classic_button_typography_line_height\":{\"unit\":\"%\",\"size\":\"150\",\"sizes\":[]},\"classic_button_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"classic_button_typography_line_height_mobile\":{\"unit\":\"%\",\"size\":\"150\",\"sizes\":[]},\"classic_skin_box_border_color\":\"#00000000\",\"classic_skin_box_border_color_hover\":\"#000000\",\"classic_skin_box_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"__globals__\":{\"classic_title_typography_typography\":\"globals\\/typography?id=twbb_bold\",\"classic_desc_typography_typography\":\"globals\\/typography?id=text\",\"classic_price_typography_typography\":\"globals\\/typography?id=twbb_p3\",\"classic_old_price_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"classic_skin_desc_color\":\"globals\\/colors?id=text\",\"classic_skin_title_color\":\"globals\\/colors?id=primary\",\"classic_skin_price_color\":\"globals\\/colors?id=text\",\"classic_skin_old_price_color\":\"globals\\/colors?id=text\",\"classic_skin_onsale_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"classic_skin_onsale_text_background_color\":\"globals\\/colors?id=twbb_button\",\"classic_skin_button_text_color\":\"globals\\/colors?id=primary\",\"classic_skin_button_hover_color\":\"globals\\/colors?id=secondary\",\"classic_skin_box_border_color_hover\":\"globals\\/colors?id=twbb_bg_inv\",\"classic_skin_box_border_color\":\"globals\\/colors?id=twbb_transparent\",\"classic_skin_box_bg_color_hover\":\"\",\"classic_onsale_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"classic_skin_star_color\":\"globals\\/colors?id=twbb_bg_inv\"},\"classic_skin_hide_products_description\":\"yes\",\"modern_skin_hide_products_description\":\"yes\",\"classic_skin_align\":\"left\",\"classic_skin_single_image_width\":\"woocommerce_thumbnail%%600\",\"classic_skin_image_spacing\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"classic_skin_rating_spacing\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"classic_skin_description_length\":4,\"classic_skin_column_gap\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"classic_skin_image_border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"classic_skin_star_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"classic_skin_box_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"14\",\"left\":\"0\",\"isLinked\":false},\"classic_skin_content_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"14\",\"isLinked\":false},\"classic_box_shadow_hover_box_shadow\":{\"horizontal\":-100,\"vertical\":0,\"blur\":10,\"spread\":0,\"color\":\"rgba(0,0,0,0.5)\"},\"classic_skin_thumbnail_image_width\":\"custom\",\"classic_onsale_typography_typography\":\"custom\",\"classic_onsale_typography_font_family\":\"Montserrat\",\"classic_onsale_typography_font_size\":{\"unit\":\"px\",\"size\":\"16\",\"sizes\":[]},\"classic_onsale_typography_font_size_mobile\":{\"size\":\"16\",\"unit\":\"px\",\"sizes\":[]},\"classic_onsale_typography_font_weight\":\"normal\",\"classic_onsale_typography_text_transform\":\"none\",\"classic_onsale_typography_font_style\":\"normal\",\"classic_onsale_typography_text_decoration\":\"none\",\"classic_onsale_typography_line_height\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"classic_onsale_typography_line_height_tablet\":{\"size\":\"\",\"unit\":\"px\",\"sizes\":[]},\"classic_onsale_typography_line_height_mobile\":{\"size\":\"\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"twbb_woocommerce-products\",\"id\":\"ikl4rv6n\"}]}]}],\"isInner\":\"false\"},{\"id\":\"5a31b66\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/products_list\\/products_list_1\\/background_color_type-neutral--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Products list\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"__globals__\":{\"background_color\":\"globals\\/colors?id=twbb_bg_3\"},\"background_background\":\"classic\",\"flex_justify_content\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"5anoke0v\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_justify_content\":\"space-between\",\"flex_align_items\":\"flex-end\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"8prtdtt5\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":66,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"oxuzgf02\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Shop by category\",\"header_size\":\"h2\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"wv5gdgk0\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"editor\":\"Discover our collection of products\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"7wxi0i8w\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":33,\"sizes\":[]},\"_margin\":{\"left\":\"10\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"text\":\"View all\",\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"24\",\"bottom\":\"12\",\"left\":\"24\",\"isLinked\":false},\"align\":\"right\",\"align_mobile\":\"center\",\"__globals__\":{\"typography_typography\":\"globals\\/typography?id=accent\",\"button_text_color\":\"globals\\/colors?id=accent\",\"background_color\":\"globals\\/colors?id=twbb_transparent\",\"button_background_hover_color\":\"globals\\/colors?id=accent\",\"border_color\":\"globals\\/colors?id=accent\",\"button_hover_border_color\":\"globals\\/colors?id=accent\",\"hover_color\":\"globals\\/colors?id=twbb_button_inv\"},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true}},\"elType\":\"widget\",\"widgetType\":\"button\",\"id\":\"gxo5s90d\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"margin\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"40\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_align_items_mobile\":\"flex-start\",\"overflow\":\"hidden\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"yfnpgboz\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"products_related_products_title_text\":\"Related Products\",\"products_upsells_title_text\":\"You may also like...\",\"products_cross_sells_title_text\":\"You may be interested in...\",\"query_post_type\":\"product\",\"query_include\":[],\"query_include_term_ids\":[],\"_skin\":\"classic\",\"modern_skin_hide_products_buttons\":\"always_show\",\"classic_skin_hide_products_buttons\":\"\",\"content_width\":\"full\",\"columns\":3,\"rows\":1,\"classic_skin_columns\":10,\"classic_skin_rows\":1,\"modern_skin_columns\":10,\"modern_skin_rows\":1,\"paginate\":\"no\",\"classic_skin_title_spacing\":{\"unit\":\"px\",\"size\":3,\"sizes\":[]},\"classic_skin_title_spacing_mobile\":16,\"classic_skin_desc_spacing\":18,\"classic_skin_desc_spacing_mobile\":16,\"classic_skin_onsale_border_radius\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"classic_skin_onsale_width\":{\"unit\":\"px\",\"size\":74,\"sizes\":[]},\"classic_skin_onsale_height\":{\"unit\":\"px\",\"size\":36,\"sizes\":[]},\"classic_skin_onsale_distance\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"modern_skin_hide_product_quantity\":\"yes\",\"classic_skin_hide_product_quantity\":\"yes\",\"classic_button_typography_typography\":\"custom\",\"classic_button_typography_font_family\":\"Montserrat\",\"classic_button_typography_font_size\":{\"unit\":\"px\",\"size\":\"14\",\"sizes\":[]},\"classic_button_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":\"14\",\"sizes\":[]},\"classic_button_typography_font_weight\":\"normal\",\"classic_button_typography_text_transform\":\"none\",\"classic_button_typography_font_style\":\"normal\",\"classic_button_typography_text_decoration\":\"underline\",\"classic_button_typography_line_height\":{\"unit\":\"%\",\"size\":\"150\",\"sizes\":[]},\"classic_button_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"classic_button_typography_line_height_mobile\":{\"unit\":\"%\",\"size\":\"150\",\"sizes\":[]},\"classic_skin_box_border_color\":\"#00000000\",\"classic_skin_box_border_color_hover\":\"#000000\",\"classic_skin_box_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"__globals__\":{\"classic_title_typography_typography\":\"globals\\/typography?id=twbb_bold\",\"classic_desc_typography_typography\":\"globals\\/typography?id=text\",\"classic_price_typography_typography\":\"globals\\/typography?id=twbb_p3\",\"classic_old_price_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"classic_skin_desc_color\":\"globals\\/colors?id=text\",\"classic_skin_title_color\":\"globals\\/colors?id=primary\",\"classic_skin_price_color\":\"globals\\/colors?id=text\",\"classic_skin_old_price_color\":\"globals\\/colors?id=text\",\"classic_skin_onsale_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"classic_skin_onsale_text_background_color\":\"globals\\/colors?id=twbb_button\",\"classic_skin_button_text_color\":\"globals\\/colors?id=primary\",\"classic_skin_button_hover_color\":\"globals\\/colors?id=secondary\",\"classic_skin_box_border_color_hover\":\"globals\\/colors?id=twbb_bg_inv\",\"classic_skin_box_border_color\":\"globals\\/colors?id=twbb_transparent\",\"classic_skin_box_bg_color_hover\":\"\",\"classic_onsale_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"classic_skin_star_color\":\"globals\\/colors?id=twbb_bg_inv\"},\"classic_skin_hide_products_description\":\"yes\",\"modern_skin_hide_products_description\":\"yes\",\"slides_per_view\":\"3\",\"classic_skin_align\":\"left\",\"classic_skin_single_image_width\":\"woocommerce_thumbnail%%600\",\"classic_skin_image_spacing\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"classic_skin_rating_spacing\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"classic_skin_description_length\":4,\"classic_skin_column_gap\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"classic_skin_image_border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"classic_skin_star_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"classic_skin_box_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"14\",\"left\":\"0\",\"isLinked\":false},\"classic_skin_content_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"14\",\"isLinked\":false},\"classic_box_shadow_hover_box_shadow\":{\"horizontal\":-100,\"vertical\":0,\"blur\":10,\"spread\":0,\"color\":\"rgba(0,0,0,0.5)\"},\"classic_skin_thumbnail_image_width\":\"custom\",\"slider_view\":\"yes\",\"autoplay\":\"yes\",\"navigation_position\":\"inside\",\"pagination_alignment\":\"center\",\"classic_onsale_typography_typography\":\"custom\",\"classic_onsale_typography_font_family\":\"Montserrat\",\"classic_onsale_typography_font_size\":{\"unit\":\"px\",\"size\":\"16\",\"sizes\":[]},\"classic_onsale_typography_font_size_mobile\":{\"size\":\"16\",\"unit\":\"px\",\"sizes\":[]},\"classic_onsale_typography_font_weight\":\"normal\",\"classic_onsale_typography_text_transform\":\"none\",\"classic_onsale_typography_font_style\":\"normal\",\"classic_onsale_typography_text_decoration\":\"none\",\"classic_onsale_typography_line_height\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"classic_onsale_typography_line_height_tablet\":{\"size\":\"\",\"unit\":\"px\",\"sizes\":[]},\"classic_onsale_typography_line_height_mobile\":{\"size\":\"\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"twbb_woocommerce-products\",\"id\":\"w6g9beko\"}]}]}],\"isInner\":\"false\"},{\"id\":\"939e4e8\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/products_list\\/products_list_2\\/background_color_type-neutral--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"50\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"50\",\"right\":\"50\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"35\",\"bottom\":\"35\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Products list\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"__globals__\":{\"background_color\":\"globals\\/colors?id=twbb_bg_3\"},\"background_background\":\"classic\",\"flex_justify_content\":\"center\",\"flex_align_items_mobile\":\"flex-start\",\"overflow\":\"hidden\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"ad52la6a\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"products_related_products_title_text\":\"Related Products\",\"products_upsells_title_text\":\"You may also like...\",\"products_cross_sells_title_text\":\"You may be interested in...\",\"query_post_type\":\"product\",\"query_include\":[],\"query_include_term_ids\":[],\"_skin\":\"classic\",\"modern_skin_hide_products_buttons\":\"always_show\",\"classic_skin_hide_products_buttons\":\"\",\"content_width\":\"full\",\"columns\":4,\"rows\":1,\"classic_skin_columns\":10,\"classic_skin_rows\":1,\"modern_skin_columns\":10,\"modern_skin_rows\":1,\"paginate\":\"no\",\"classic_skin_title_spacing\":{\"unit\":\"px\",\"size\":3,\"sizes\":[]},\"classic_skin_title_spacing_mobile\":16,\"classic_skin_desc_spacing\":18,\"classic_skin_desc_spacing_mobile\":16,\"classic_skin_onsale_border_radius\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"classic_skin_onsale_width\":{\"unit\":\"px\",\"size\":74,\"sizes\":[]},\"classic_skin_onsale_height\":{\"unit\":\"px\",\"size\":36,\"sizes\":[]},\"classic_skin_onsale_distance\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"modern_skin_hide_product_quantity\":\"yes\",\"classic_skin_hide_product_quantity\":\"yes\",\"classic_button_typography_typography\":\"custom\",\"classic_button_typography_font_family\":\"Montserrat\",\"classic_button_typography_font_size\":{\"unit\":\"px\",\"size\":\"14\",\"sizes\":[]},\"classic_button_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":\"14\",\"sizes\":[]},\"classic_button_typography_font_weight\":\"normal\",\"classic_button_typography_text_transform\":\"none\",\"classic_button_typography_font_style\":\"normal\",\"classic_button_typography_text_decoration\":\"underline\",\"classic_button_typography_line_height\":{\"unit\":\"%\",\"size\":\"150\",\"sizes\":[]},\"classic_button_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"classic_button_typography_line_height_mobile\":{\"unit\":\"%\",\"size\":\"150\",\"sizes\":[]},\"classic_skin_box_border_color\":\"#00000000\",\"classic_skin_box_border_color_hover\":\"#000000\",\"classic_skin_box_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"__globals__\":{\"classic_title_typography_typography\":\"globals\\/typography?id=twbb_bold\",\"classic_desc_typography_typography\":\"globals\\/typography?id=text\",\"classic_price_typography_typography\":\"globals\\/typography?id=twbb_p3\",\"classic_old_price_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"classic_skin_desc_color\":\"globals\\/colors?id=text\",\"classic_skin_title_color\":\"globals\\/colors?id=primary\",\"classic_skin_price_color\":\"globals\\/colors?id=text\",\"classic_skin_old_price_color\":\"globals\\/colors?id=text\",\"classic_skin_onsale_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"classic_skin_onsale_text_background_color\":\"globals\\/colors?id=twbb_button\",\"classic_skin_button_text_color\":\"globals\\/colors?id=primary\",\"classic_skin_button_hover_color\":\"globals\\/colors?id=secondary\",\"classic_skin_box_border_color_hover\":\"globals\\/colors?id=twbb_bg_inv\",\"classic_skin_box_border_color\":\"globals\\/colors?id=twbb_transparent\",\"classic_skin_box_bg_color_hover\":\"\",\"classic_onsale_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"classic_skin_star_color\":\"globals\\/colors?id=twbb_bg_inv\"},\"classic_skin_hide_products_description\":\"yes\",\"modern_skin_hide_products_description\":\"yes\",\"slides_per_view\":\"4\",\"classic_skin_align\":\"left\",\"classic_skin_single_image_width\":\"woocommerce_thumbnail%%600\",\"classic_skin_image_spacing\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"classic_skin_rating_spacing\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"classic_skin_description_length\":4,\"classic_skin_column_gap\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"classic_skin_image_border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"classic_skin_star_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"classic_skin_box_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"14\",\"left\":\"0\",\"isLinked\":false},\"classic_skin_content_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"14\",\"isLinked\":false},\"classic_box_shadow_hover_box_shadow\":{\"horizontal\":-100,\"vertical\":0,\"blur\":10,\"spread\":0,\"color\":\"rgba(0,0,0,0.5)\"},\"classic_skin_thumbnail_image_width\":\"custom\",\"slider_view\":\"yes\",\"autoplay\":\"yes\",\"slider_full_width_layout\":\"cut-from-right\",\"loop\":\"yes\",\"classic_onsale_typography_typography\":\"custom\",\"classic_onsale_typography_font_family\":\"Montserrat\",\"classic_onsale_typography_font_size\":{\"unit\":\"px\",\"size\":\"16\",\"sizes\":[]},\"classic_onsale_typography_font_size_mobile\":{\"size\":\"16\",\"unit\":\"px\",\"sizes\":[]},\"classic_onsale_typography_font_weight\":\"normal\",\"classic_onsale_typography_text_transform\":\"none\",\"classic_onsale_typography_font_style\":\"normal\",\"classic_onsale_typography_text_decoration\":\"none\",\"classic_onsale_typography_line_height\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"classic_onsale_typography_line_height_tablet\":{\"size\":\"\",\"unit\":\"px\",\"sizes\":[]},\"classic_onsale_typography_line_height_mobile\":{\"size\":\"\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"twbb_woocommerce-products\",\"id\":\"crtwoe04\"}]}],\"isInner\":\"false\"},{\"id\":\"4e6e05a\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/products_list\\/products_list_3\\/background_color_type-neutral--background_media_type-none--cards_type-no_contrast.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"50\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"50\",\"right\":\"50\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"35\",\"bottom\":\"35\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Products list\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"__globals__\":{\"background_color\":\"globals\\/colors?id=twbb_bg_3\"},\"background_background\":\"classic\",\"flex_justify_content\":\"center\",\"flex_align_items_mobile\":\"flex-start\",\"overflow\":\"hidden\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"2oz8gqk6\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"products_related_products_title_text\":\"Related Products\",\"products_upsells_title_text\":\"You may also like...\",\"products_cross_sells_title_text\":\"You may be interested in...\",\"query_post_type\":\"product\",\"query_include\":[],\"query_include_term_ids\":[],\"_skin\":\"classic\",\"modern_skin_hide_products_buttons\":\"always_show\",\"classic_skin_hide_products_buttons\":\"\",\"content_width\":\"full\",\"columns\":4,\"rows\":1,\"classic_skin_columns\":10,\"classic_skin_rows\":1,\"modern_skin_columns\":10,\"modern_skin_rows\":1,\"paginate\":\"no\",\"classic_skin_title_spacing\":{\"unit\":\"px\",\"size\":3,\"sizes\":[]},\"classic_skin_title_spacing_mobile\":16,\"classic_skin_desc_spacing\":18,\"classic_skin_desc_spacing_mobile\":16,\"classic_skin_onsale_border_radius\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"classic_skin_onsale_width\":{\"unit\":\"px\",\"size\":74,\"sizes\":[]},\"classic_skin_onsale_height\":{\"unit\":\"px\",\"size\":36,\"sizes\":[]},\"classic_skin_onsale_distance\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"modern_skin_hide_product_quantity\":\"yes\",\"classic_skin_hide_product_quantity\":\"yes\",\"classic_button_typography_typography\":\"custom\",\"classic_button_typography_font_family\":\"Montserrat\",\"classic_button_typography_font_size\":{\"unit\":\"px\",\"size\":\"14\",\"sizes\":[]},\"classic_button_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":\"14\",\"sizes\":[]},\"classic_button_typography_font_weight\":\"normal\",\"classic_button_typography_text_transform\":\"none\",\"classic_button_typography_font_style\":\"normal\",\"classic_button_typography_text_decoration\":\"underline\",\"classic_button_typography_line_height\":{\"unit\":\"%\",\"size\":\"150\",\"sizes\":[]},\"classic_button_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"classic_button_typography_line_height_mobile\":{\"unit\":\"%\",\"size\":\"150\",\"sizes\":[]},\"classic_skin_box_border_color\":\"#00000000\",\"classic_skin_box_border_color_hover\":\"#000000\",\"classic_skin_box_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"__globals__\":{\"classic_title_typography_typography\":\"globals\\/typography?id=twbb_bold\",\"classic_desc_typography_typography\":\"globals\\/typography?id=text\",\"classic_price_typography_typography\":\"globals\\/typography?id=twbb_p3\",\"classic_old_price_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"classic_skin_desc_color\":\"globals\\/colors?id=text\",\"classic_skin_title_color\":\"globals\\/colors?id=primary\",\"classic_skin_price_color\":\"globals\\/colors?id=text\",\"classic_skin_old_price_color\":\"globals\\/colors?id=text\",\"classic_skin_onsale_text_color\":\"globals\\/colors?id=twbb_button_inv\",\"classic_skin_onsale_text_background_color\":\"globals\\/colors?id=twbb_button\",\"classic_skin_button_text_color\":\"globals\\/colors?id=primary\",\"classic_skin_button_hover_color\":\"globals\\/colors?id=secondary\",\"classic_skin_box_border_color_hover\":\"globals\\/colors?id=twbb_bg_inv\",\"classic_skin_box_border_color\":\"globals\\/colors?id=twbb_transparent\",\"classic_skin_box_bg_color_hover\":\"\",\"classic_onsale_typography_typography\":\"globals\\/typography?id=twbb_p4\",\"classic_skin_star_color\":\"globals\\/colors?id=twbb_bg_inv\"},\"classic_skin_hide_products_description\":\"yes\",\"modern_skin_hide_products_description\":\"yes\",\"slides_per_view\":\"4\",\"classic_skin_align\":\"left\",\"classic_skin_single_image_width\":\"woocommerce_thumbnail%%600\",\"classic_skin_image_spacing\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"classic_skin_rating_spacing\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"classic_skin_description_length\":4,\"classic_skin_column_gap\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"classic_skin_image_border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"classic_skin_star_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"classic_skin_box_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"14\",\"left\":\"0\",\"isLinked\":false},\"classic_skin_content_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"14\",\"isLinked\":false},\"classic_box_shadow_hover_box_shadow\":{\"horizontal\":-100,\"vertical\":0,\"blur\":10,\"spread\":0,\"color\":\"rgba(0,0,0,0.5)\"},\"classic_skin_thumbnail_image_width\":\"custom\",\"slider_view\":\"yes\",\"autoplay\":\"yes\",\"slider_full_width_layout\":\"full-width\",\"loop\":\"yes\",\"classic_onsale_typography_typography\":\"custom\",\"classic_onsale_typography_font_family\":\"Montserrat\",\"classic_onsale_typography_font_size\":{\"unit\":\"px\",\"size\":\"16\",\"sizes\":[]},\"classic_onsale_typography_font_size_mobile\":{\"size\":\"16\",\"unit\":\"px\",\"sizes\":[]},\"classic_onsale_typography_font_weight\":\"normal\",\"classic_onsale_typography_text_transform\":\"none\",\"classic_onsale_typography_font_style\":\"normal\",\"classic_onsale_typography_text_decoration\":\"none\",\"classic_onsale_typography_line_height\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"classic_onsale_typography_line_height_tablet\":{\"size\":\"\",\"unit\":\"px\",\"sizes\":[]},\"classic_onsale_typography_line_height_mobile\":{\"size\":\"\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"twbb_woocommerce-products\",\"id\":\"djik7jhz\"}]}],\"isInner\":\"false\"},{\"id\":\"28d3ba4\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/single_feature\\/single_feature_18\\/background_color_type-none--background_media_type-none--cards_type-no_contrast--num_of_features-1.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"eahyj2vu\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_justify_content\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"77nw26dh\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Explore Our Revolutionary Feature\",\"header_size\":\"h2\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"o1vvstzx\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Gain insights into the remarkable benefits of our feature and see how it can elevate your business.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"o4jhwfp1\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"icon_list\":[{\"text\":\"Advantage 1: Cutting-edge technology\",\"selected_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"}},{\"text\":\"Advantage 2: Intuitive user experience\",\"selected_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"}},{\"text\":\"Advantage 3: Unmatched customer support\",\"selected_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"}}],\"space_between\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"space_between_mobile\":{\"unit\":\"px\",\"size\":8,\"sizes\":[]},\"text_indent\":{\"size\":\"18\",\"unit\":\"px\",\"sizes\":[]},\"icon_align\":\"left\",\"__globals__\":{\"icon_color\":\"globals\\/colors?id=secondary\",\"text_color\":\"globals\\/colors?id=text\",\"icon_typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"icon_size\":{\"size\":\"18\",\"unit\":\"px\",\"sizes\":[]},\"icon_size_mobile\":{\"size\":\"16\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-list\",\"id\":\"cny4hrzk\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_margin\":{\"left\":\"30\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-service.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"q5w68u32\"}]}],\"isInner\":\"false\"},{\"id\":\"1961e33\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/single_feature\\/single_feature_18b\\/background_color_type-none--background_media_type-none--cards_type-no_contrast--num_of_features-1.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"css_classes\":\"twbb_section\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_gap\":{\"column\":\"0\",\"row\":\"20\",\"isLinked\":false,\"unit\":\"px\",\"size\":\"0\"},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"8gxz06ck\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"calc(50vw - 640.0px)\",\"right\":\"30px\",\"top\":\"80px\",\"bottom\":\"80px\",\"unit\":\"custom\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_justify_content\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"w6y0ocbo\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Explore Our Revolutionary Feature\",\"header_size\":\"h2\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"h58n0uda\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Gain insights into the remarkable benefits of our feature and see how it can elevate your business.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"wh6yz7fw\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"icon_list\":[{\"text\":\"Advantage 1: Cutting-edge technology\",\"selected_icon\":{\"value\":\"fas fa-user\",\"library\":\"fa-solid\"}},{\"text\":\"Advantage 2: Intuitive user experience\",\"selected_icon\":{\"value\":\"fas fa-user\",\"library\":\"fa-solid\"}},{\"text\":\"Advantage 3: Unmatched customer support\",\"selected_icon\":{\"value\":\"fas fa-user\",\"library\":\"fa-solid\"}}],\"space_between\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"space_between_mobile\":{\"unit\":\"px\",\"size\":8,\"sizes\":[]},\"text_indent\":{\"size\":\"18\",\"unit\":\"px\",\"sizes\":[]},\"icon_align\":\"left\",\"__globals__\":{\"icon_color\":\"globals\\/colors?id=secondary\",\"text_color\":\"globals\\/colors?id=text\",\"icon_typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"icon_size\":{\"size\":\"18\",\"unit\":\"px\",\"sizes\":[]},\"icon_size_mobile\":{\"size\":\"16\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-list\",\"id\":\"5rvo5n3n\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-feature6.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"height\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"object-fit\":\"cover\"},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"i6ynwyn9\"}]}],\"isInner\":\"false\"},{\"id\":\"b08aba1\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/single_feature\\/single_feature_18c\\/background_color_type-none--background_media_type-none--cards_type-low_contrast--num_of_features-1.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"893f55st\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"48\",\"right\":\"48\",\"top\":\"48\",\"bottom\":\"48\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"48\",\"right\":\"48\",\"top\":\"48\",\"bottom\":\"48\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"48\",\"right\":\"48\",\"top\":\"48\",\"bottom\":\"48\",\"unit\":\"px\",\"isLinked\":false},\"border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"__globals__\":{\"background_color\":\"globals\\/colors?id=twbb_bg_1\"},\"background_background\":\"classic\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"x2qc78x4\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_justify_content\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"js6twscn\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Explore Our Revolutionary Feature\",\"header_size\":\"h2\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"tt849umy\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Gain insights into the remarkable benefits of our feature and see how it can elevate your business.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"uqn5oefw\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"icon_list\":[{\"text\":\"Advantage 1: Cutting-edge technology\",\"selected_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"}},{\"text\":\"Advantage 2: Intuitive user experience\",\"selected_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"}},{\"text\":\"Advantage 3: Unmatched customer support\",\"selected_icon\":{\"value\":\"fas fa-star\",\"library\":\"fa-solid\"}}],\"space_between\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"space_between_mobile\":{\"unit\":\"px\",\"size\":8,\"sizes\":[]},\"text_indent\":{\"size\":\"18\",\"unit\":\"px\",\"sizes\":[]},\"icon_align\":\"left\",\"__globals__\":{\"icon_color\":\"globals\\/colors?id=text\",\"text_color\":\"globals\\/colors?id=text\",\"icon_typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"icon_size\":{\"size\":\"18\",\"unit\":\"px\",\"sizes\":[]},\"icon_size_mobile\":{\"size\":\"16\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-list\",\"id\":\"w5h9wwf4\"}]},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_margin\":{\"left\":\"10\",\"right\":\"-48\",\"top\":\"-48\",\"bottom\":\"-48\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-feature7.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"height\":{\"unit\":\"custom\",\"size\":\"calc(100% + 96px)\",\"sizes\":[]},\"object-fit\":\"cover\"},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"dgfbpoun\"}]}]}],\"isInner\":\"false\"},{\"id\":\"c8739a9\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/single_feature\\/single_feature_212\\/background_color_type-none--background_media_type-none--cards_type-no_contrast--num_of_features-1.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"15\",\"right\":\"50\",\"top\":\"80\",\"bottom\":\"80\",\"unit\":\"px\",\"isLinked\":false},\"padding_mobile\":{\"left\":\"15\",\"right\":\"15\",\"top\":\"50\",\"bottom\":\"50\",\"unit\":\"px\",\"isLinked\":false},\"css_classes\":\"twbb_section\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"content_width\":\"boxed\",\"boxed_width\":{\"size\":\"1280\",\"unit\":\"px\",\"sizes\":[]},\"flex_align_items\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"rgced6o1\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_margin\":{\"left\":\"0\",\"right\":\"30\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":false},\"_margin_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_margin_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-feature3.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"xwlo5wgd\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_justify_content\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"qco3w8xl\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Introducing Our New Feature\",\"header_size\":\"h2\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"181ky07u\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Introducing our new feature that will revolutionize your business. Our innovative technology streamlines processes, increases revenue, and boosts productivity.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"align_mobile\":\"center\"},\"elType\":\"widget\",\"widgetType\":\"text-editor\",\"id\":\"n9cnr9yd\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"icon_list\":[{\"text\":\"Benefit 1: Enhanced productivity\",\"selected_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"}},{\"text\":\"Benefit 2: Streamlined processes\",\"selected_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"}},{\"text\":\"Benefit 3: Comprehensive analytics\",\"selected_icon\":{\"value\":\"fas fa-check\",\"library\":\"fa-solid\"}}],\"space_between\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"space_between_mobile\":{\"unit\":\"px\",\"size\":8,\"sizes\":[]},\"text_indent\":{\"size\":\"18\",\"unit\":\"px\",\"sizes\":[]},\"icon_align\":\"left\",\"__globals__\":{\"icon_color\":\"globals\\/colors?id=secondary\",\"text_color\":\"globals\\/colors?id=text\",\"icon_typography_typography\":\"globals\\/typography?id=twbb_p1\"},\"icon_size\":{\"size\":\"18\",\"unit\":\"px\",\"sizes\":[]},\"icon_size_mobile\":{\"size\":\"16\",\"unit\":\"px\",\"sizes\":[]}},\"elType\":\"widget\",\"widgetType\":\"icon-list\",\"id\":\"yg7yldto\"}]}]}],\"isInner\":\"false\"},{\"id\":\"bfbcd49\",\"elType\":\"container\",\"settings\":{\"_element_id\":\"twbb-sg-section-ai20-sections\\/single_feature\\/single_feature_212b\\/background_color_type-none--background_media_type-none--cards_type-no_contrast--num_of_features-1.json\",\"css_classes\":\"twbb-sg-each-section   twbb-sg-compatible-basic twbb-sg-compatible-ecommerce\",\"content_width\":\"full\",\"flex_direction\":\"column\"},\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"css_classes\":\"twbb_section\",\"_title\":\"Container\",\"flex_direction\":\"row\",\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_gap\":{\"column\":\"0\",\"row\":\"20\",\"isLinked\":false,\"unit\":\"px\",\"size\":\"0\"},\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"1ah5h8il\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"image\":{\"url\":\"https:\\/\\/ai20-sections-dev.s3.amazonaws.com\\/images\\/abstract-feature9.webp\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"url\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"height\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"object-fit\":\"cover\"},\"elType\":\"widget\",\"widgetType\":\"image\",\"id\":\"ds9djxrj\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"padding\":{\"left\":\"30px\",\"right\":\"calc(50vw - 640.0px)\",\"top\":\"80px\",\"bottom\":\"80px\",\"unit\":\"custom\",\"isLinked\":false},\"padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"css_classes\":\"\",\"_title\":\"Container\",\"flex_direction\":\"column\",\"flex_direction_tablet\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_justify_content_mobile\":\"center\",\"flex_justify_content_tablet\":\"center\",\"flex_gap\":{\"column\":\"20\",\"row\":\"20\",\"isLinked\":true,\"unit\":\"px\",\"size\":20},\"flex_justify_content\":\"center\",\"flex_align_items_mobile\":\"flex-start\"},\"elType\":\"container\",\"widgetType\":\"container\",\"id\":\"zrtarst6\",\"elements\":[{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"title\":\"Introducing Our New Feature\",\"header_size\":\"h2\",\"align\":\"left\",\"align_mobile\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"globals\\/typography?id=primary\"}},\"elType\":\"widget\",\"widgetType\":\"heading\",\"id\":\"aqxr9w03\"},{\"settings\":{\"_flex_align_self_mobile\":\"center\",\"_css_classes\":\"\",\"_animation\":\"fadeInUp\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_element_width_mobile\":\"inherit\",\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"30\",\"unit\":\"px\",\"isLinked\":false},\"_padding_tablet\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"_padding_mobile\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\",\"unit\":\"px\",\"isLinked\":true},\"editor\":\"Introducing our new feature that will revolutionize your business. Our innovative technology streamlines processes, increases revenue, and boosts productivity.\",\"align\":\"left\",\"__globals__\":{\"text_color\":\"globals\\/colors?id=text\",\"typography